/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.templateperm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.templateperm.TemplatePermQueryUtil;
import kd.epm.eb.business.templateperm.TemplatePermUpgradeHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.templateperm.EntityTypeEnum;
import kd.epm.eb.common.templateperm.TemplateTypeEnum;
import kd.epm.eb.common.templateperm.TemplateUserQueryResult;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;

public class TemplatePermServiceHelper {
    public static Map<Long, TemplateUserQueryResult> getTemplateEntityPermMap(Long modelId, TemplateTypeEnum templateType, Set<Long> schemeIds) {
        TemplatePermUpgradeHelper.getInstance().upgradeModelTemplatePermData(modelId);
        HashMap<Long, TemplateUserQueryResult> result = new HashMap<Long, TemplateUserQueryResult>(16);
        boolean modelAdmin = CentralAppBillService.getInstance().isModelAdmin(modelId);
        if (modelAdmin) {
            for (Long schemeId : schemeIds) {
                TemplateUserQueryResult queryResult = new TemplateUserQueryResult();
                queryResult.setHasAllPerm(true);
                result.put(schemeId, queryResult);
            }
            return result;
        }
        QFBuilder qfBuilder = new QFBuilder();
        TemplatePermServiceHelper.addModelQFilter(qfBuilder, modelId);
        TemplatePermServiceHelper.addUserQFilter(qfBuilder);
        HashMap<Long, Set<Long>> templateSchemeMap = new HashMap<Long, Set<Long>>(16);
        Set<Long> templates = TemplatePermServiceHelper.getTemplatesBySchemeIds(schemeIds, templateType, templateSchemeMap);
        TemplatePermServiceHelper.addTemplateQFilter(qfBuilder, templates, templateType);
        DynamicObjectCollection records = QueryServiceHelper.query((String)"eb_templateuser_entity", (String)"id, templateid, userid, usertype, modelid, applytemplate, templatetype, entityid, entity_range, entity_exclude, entitytype, viewgroup", (QFilter[])qfBuilder.toArrays(), (String)"entity_exclude");
        if (records.size() == 0) {
            return result;
        }
        Map<Long, Long> schemeViewIdMap = TemplatePermServiceHelper.getSchemeViewIdMap(schemeIds);
        Map viewToViewGroupMap = TemplatePermQueryUtil.getViewToViewGroupMap((Long)modelId);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        for (DynamicObject record : records) {
            Long template = TemplatePermServiceHelper.getTemplateId(templateType, record);
            Set refSchemeIds = (Set)templateSchemeMap.get(template);
            if (refSchemeIds == null) continue;
            Long entityViewGroupId = record.getLong("viewgroup");
            long entityId = record.getLong("entityid");
            String entityRange = record.getString("entity_range");
            boolean entityExclude = record.getBoolean("entity_exclude");
            String entityType = record.getString("entitytype");
            for (Long refSchemeId : refSchemeIds) {
                Long schemeViewId = schemeViewIdMap.get(refSchemeId);
                Long schemeRelViewGroupId = (Long)viewToViewGroupMap.get(schemeViewId);
                if (!IDUtils.equals((Object)schemeRelViewGroupId, (Object)entityViewGroupId)) continue;
                TemplateUserQueryResult queryResult = result.computeIfAbsent(refSchemeId, t -> new TemplateUserQueryResult());
                queryResult.addTemplateEntityResult(template, Long.valueOf(StringUtils.isEmpty((String)entityRange) ? 0L : entityId), entityExclude, () -> TemplatePermServiceHelper.getRefEntitySet(modelCacheHelper, memberPropCache, entityId, entityRange, entityType, schemeViewId), () -> TemplatePermServiceHelper.getAllEntityMemberIds(modelCacheHelper, schemeViewId));
            }
        }
        return result;
    }

    public static Set<Long> getUserHasPermTemplateIds(Long modelId, TemplateTypeEnum templateType, Set<Long> templateIds, Set<Long> entityIds, Long entityViewId) {
        TemplateUserQueryResult userTemplatePerm = TemplatePermServiceHelper.getUserTemplatePermDetails(modelId, templateType, templateIds, entityIds, entityViewId);
        return userTemplatePerm.getTemplates();
    }

    public static TemplateUserQueryResult getUserTemplatePermDetails(Long modelId, TemplateTypeEnum templateType, Set<Long> templateIds, Set<Long> entityIds, Long entityViewId) {
        TemplatePermUpgradeHelper.getInstance().upgradeModelTemplatePermData(modelId);
        TemplateUserQueryResult result = new TemplateUserQueryResult();
        boolean modelAdmin = CentralAppBillService.getInstance().isModelAdmin(modelId);
        if (modelAdmin) {
            result.setHasAllPerm(true);
            return result;
        }
        QFBuilder qfBuilder = new QFBuilder();
        TemplatePermServiceHelper.addModelQFilter(qfBuilder, modelId);
        TemplatePermServiceHelper.addUserQFilter(qfBuilder);
        TemplatePermServiceHelper.addTemplateQFilter(qfBuilder, templateIds, templateType);
        HashSet<Long> selectedMemberIds = new HashSet<Long>(16);
        TemplatePermServiceHelper.addEntityQFilter(qfBuilder, entityIds, selectedMemberIds, modelId, entityViewId);
        TemplatePermServiceHelper.addEntityViewGroupFilter(qfBuilder, entityViewId);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        DynamicObjectCollection records = QueryServiceHelper.query((String)"eb_templateuser_entity", (String)"id, templateid, userid, usertype, modelid, applytemplate, templatetype, entityid, entity_range, entity_exclude, entitytype, viewgroup", (QFilter[])qfBuilder.toArrays(), (String)"entity_exclude");
        Map recordToViewIdMap = TemplatePermQueryUtil.removeNotIncludeRecord((DynamicObjectCollection)records, null, selectedMemberIds, (long)modelId, (Long)entityViewId);
        for (DynamicObject record : records) {
            Long templateId = TemplatePermServiceHelper.getTemplateId(templateType, record);
            long entityId = record.getLong("entityid");
            String entityRange = record.getString("entity_range");
            String entityType = record.getString("entitytype");
            boolean entityExclude = record.getBoolean("entity_exclude");
            Long viewId = (Long)recordToViewIdMap.get(record);
            result.addTemplateEntityResult(templateId, Long.valueOf(StringUtils.isEmpty((String)entityRange) ? 0L : entityId), entityExclude, () -> TemplatePermServiceHelper.getRefEntitySet(modelCacheHelper, memberPropCache, entityId, entityRange, entityType, viewId), () -> TemplatePermServiceHelper.getAllEntityMemberIds(modelCacheHelper, viewId));
        }
        return result;
    }

    public static Long getTemplateId(TemplateTypeEnum templateType, DynamicObject record) {
        if (TemplateTypeEnum.BUDGET == templateType) {
            return record.getLong("templateid");
        }
        if (TemplateTypeEnum.APPLY == templateType) {
            return record.getLong("applytemplate");
        }
        return 0L;
    }

    public static void deleteRefTemplatePermRecord(String fieldKey, Collection<Long> fieldValues) {
        QFilter qfilter = new QFilter(fieldKey, "in", fieldValues);
        DeleteServiceHelper.delete((String)"eb_templateuser_entity", (QFilter[])new QFilter[]{qfilter});
    }

    private static Set<Long> getAllEntityMemberIds(IModelCacheHelper modelCacheHelper, Long entityViewId) {
        List members = modelCacheHelper.getMembers(entityViewId, SysDimensionEnum.Entity.getNumber());
        return members.stream().map(BaseCache::getId).collect(Collectors.toSet());
    }

    private static Set<Long> getRefEntitySet(IModelCacheHelper modelCacheHelper, MemberPropCache memberPropCache, Long entityId, String entityRange, String entityType, Long entityViewId) {
        Member member;
        if (entityId == null || entityId == 0L || StringUtils.isEmpty((String)entityRange)) {
            return Collections.emptySet();
        }
        String dimNumber = SysDimensionEnum.Entity.getNumber();
        if (EntityTypeEnum.DEFINED_PROPERTY.getCode().equals(entityType)) {
            Long dimId = modelCacheHelper.getDimension(dimNumber).getId();
            return memberPropCache.getMembersByPropValues(dimId, entityViewId, entityId).stream().map(item -> item.getId()).collect(Collectors.toSet());
        }
        if (EntityTypeEnum.ENTITY.getCode().equals(entityType) && (member = modelCacheHelper.getMember(dimNumber, entityViewId, entityId)) != null) {
            return EpmThreadLocalUtils.getMemberRangeIdSet((long)modelCacheHelper.getModelobj().getId(), (String)dimNumber, (long)entityViewId, (String)member.getNumber(), (int)Integer.parseInt(entityRange));
        }
        return Collections.emptySet();
    }

    private static void addModelQFilter(QFBuilder qfBuilder, Long modelId) {
        qfBuilder.add(new QFilter("modelid", "=", (Object)modelId));
    }

    private static void addUserQFilter(QFBuilder qfBuilder) {
        HashSet<Long> userIds = new HashSet<Long>(16);
        userIds.add(UserUtils.getUserId());
        Map<Long, List<Long>> usrGrpUserList = TemplatePermServiceHelper.getUsrGrpUserList(userIds);
        usrGrpUserList.forEach((key, value) -> userIds.addAll((Collection<Long>)value));
        qfBuilder.add(new QFilter("userid", "in", userIds));
    }

    private static void addTemplateQFilter(QFBuilder qfBuilder, Set<Long> templates, TemplateTypeEnum templateType) {
        if (templates == null) {
            return;
        }
        String templateField = null;
        if (TemplateTypeEnum.BUDGET == templateType) {
            templateField = "templateid";
        } else if (TemplateTypeEnum.APPLY == templateType) {
            templateField = "applytemplate";
        }
        qfBuilder.add(new QFilter(templateField, "in", templates));
    }

    private static void addEntityQFilter(QFBuilder qfBuilder, Set<Long> entityIds, Set<Long> selectedMemberIds, Long modelId, Long entityViewId) {
        if (entityIds == null) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        ArrayList<Long> toQueryEntityIds = new ArrayList<Long>(16);
        toQueryEntityIds.addAll(entityIds);
        selectedMemberIds.addAll(entityIds);
        List propRelations = memberPropCache.getPropRelations(SysDimensionEnum.Entity.getNumber());
        propRelations.stream().filter(e -> entityIds.contains(e.getMemberId())).forEach(e -> {
            Long propValueId = e.getPropValueId();
            if (!toQueryEntityIds.contains(propValueId)) {
                toQueryEntityIds.add(propValueId);
            }
        });
        Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
        if (selectedMemberIds.size() != 0) {
            Long viewGroupId = TemplatePermQueryUtil.getViewGroupId((Long)entityViewId);
            List viewIds = (List)TemplatePermQueryUtil.getViewGroupToViewMap((Long)modelId).get(viewGroupId);
            HashSet<Long> ancestors = new HashSet<Long>(selectedMemberIds);
            if (viewIds != null) {
                for (Long viewId : viewIds) {
                    for (Long memberId : selectedMemberIds) {
                        TemplatePermQueryUtil.addAncestors(ancestors, (Dimension)dimension, toQueryEntityIds, null, (Long)memberId, (Long)viewId);
                    }
                }
            }
        }
        toQueryEntityIds.add(0L);
        qfBuilder.add(new QFilter("entityid", "in", toQueryEntityIds));
    }

    private static void addEntityViewGroupFilter(QFBuilder qfBuilder, Long entityViewId) {
        HashSet<Long> viewGroupIds = new HashSet<Long>(16);
        Long viewGroupId = TemplatePermQueryUtil.getViewGroupId((Long)entityViewId);
        if (IDUtils.isNotEmptyLong((Long)viewGroupId).booleanValue()) {
            viewGroupIds.add(viewGroupId);
        }
        viewGroupIds.add(0L);
        qfBuilder.add(new QFilter("viewgroup", "in", viewGroupIds));
    }

    private static Set<Long> getTemplatesBySchemeIds(Set<Long> schemeIds, TemplateTypeEnum templateType, Map<Long, Set<Long>> templateSchemeMap) {
        HashSet<Long> templates = new HashSet<Long>(16);
        String templateFieldKey = "ftemplateid";
        if (TemplateTypeEnum.APPLY == templateType) {
            templateFieldKey = "fapplytemplateid";
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select " + templateFieldKey + ", fschemeid from t_eb_templateorg where ", new Object[0]);
        sqlBuilder.appendIn("fschemeid", schemeIds.toArray());
        sqlBuilder.append(" group by " + templateFieldKey + ", fschemeid", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"getEntityPermInScheme", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (dataSet != null && dataSet.hasNext()) {
                Row next = dataSet.next();
                Long templateId = next.getLong(templateFieldKey);
                if (templateId == 0L) continue;
                templates.add(templateId);
                if (templateSchemeMap == null) continue;
                Set refSchemeIds = templateSchemeMap.computeIfAbsent(templateId, k -> new HashSet(16));
                refSchemeIds.add(next.getLong("fschemeid"));
            }
        }
        return templates;
    }

    public static Map<Long, List<Long>> getUsrGrpUserList(Set<Long> userIdSet) {
        if (null != userIdSet && !userIdSet.isEmpty()) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
            qFilterList.add(new QFilter("user", "in", userIdSet));
            Map usrGrpUserMap = BusinessDataServiceHelper.loadFromCache((String)"bos_usergroupstaff", (String)"usergroup_id, user_id", (QFilter[])qFilterList.toArray(new QFilter[0]));
            if (null != usrGrpUserMap && !usrGrpUserMap.isEmpty()) {
                HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(usrGrpUserMap.size());
                for (Map.Entry entry : usrGrpUserMap.entrySet()) {
                    DynamicObject dynamic = (DynamicObject)entry.getValue();
                    if (null == dynamic) continue;
                    List groups = result.computeIfAbsent(dynamic.getLong("user_id"), k -> new ArrayList(16));
                    groups.add(dynamic.getLong("usergroup_id"));
                }
                return result;
            }
            return new HashMap<Long, List<Long>>(1);
        }
        return new HashMap<Long, List<Long>>(1);
    }

    public static Map<Long, Long> getSchemeViewIdMap(Set<Long> schemeIds) {
        if (null != schemeIds && !schemeIds.isEmpty()) {
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"eb_rptscheme", (String)"id,orgview", (QFilter[])new QFilter("id", "in", schemeIds).toArray());
            return collection.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("orgview")));
        }
        return new HashMap<Long, Long>(1);
    }

    public static Long getSchemeViewId(Long schemeId) {
        if (IDUtils.isNotEmptyLong((Long)schemeId).booleanValue()) {
            DynamicObject object = QueryServiceHelper.queryOne((String)"eb_rptscheme", (String)"id,orgview", (QFilter[])new QFilter("id", "=", (Object)schemeId).toArray());
            return object.getLong("orgview");
        }
        return 0L;
    }

    public static void deletePropertyAllocateRecord(Collection<Long> propValIds) {
        if (CollectionUtils.isEmpty(propValIds)) {
            return;
        }
        propValIds.removeIf(IDUtils::isEmptyLong);
        if (CollectionUtils.isNotEmpty(propValIds)) {
            DeleteServiceHelper.delete((String)"eb_templateuser_entity", (QFilter[])new QFilter("entityid", "in", propValIds).toArray());
        }
    }
}

