/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.tree;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.business.tree.VirtualTreeBuilder;
import kd.epm.eb.common.cache.utils.ObjectCache;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.jetbrains.annotations.NotNull;

public class VirtualBCMTreeBuilder
extends VirtualTreeBuilder {
    private static final Map<Object, String> BOOLEANMAP = new HashMap<Object, String>();

    public static VirtualBCMTreeBuilder get(@NotNull MemberF7Parameter f7Parameter) {
        return new VirtualBCMTreeBuilder(f7Parameter);
    }

    protected VirtualBCMTreeBuilder(@NotNull MemberF7Parameter f7Parameter) {
        super(f7Parameter);
    }

    protected List<Map<String, Object>> queryInitData() {
        LinkedList treeData = Lists.newLinkedList();
        String schemaNumber = this.getF7Parameter().getSchemaNumber();
        if (StringUtils.isEmpty((String)schemaNumber)) {
            schemaNumber = "DefaultScheme";
        }
        HashMap params = Maps.newHashMap();
        params.put("modelNum", this.getF7Parameter().getModelNumber());
        params.put("dimNum", this.getF7Parameter().getDimensionNumber());
        params.put("schemeNum", schemaNumber);
        params.put("permType", this.getF7Parameter().getPermissionType());
        params.put("userId", IDUtils.isNotNull((Long)this.getF7Parameter().getUserId()) ? String.valueOf(this.getF7Parameter().getUserId()) : String.valueOf(UserUtils.getUserId()));
        HashSet<String> backFillNumber = null;
        ArrayList<String[]> backFillMembers = null;
        if (this.getF7Parameter().isBackFillVirtualMember() && this.getF7Parameter().getSelectedVirtualMember() != null && !this.getF7Parameter().getSelectedVirtualMember().isEmpty()) {
            backFillNumber = new HashSet<String>(this.getF7Parameter().getSelectedVirtualMember().size());
            backFillMembers = new ArrayList<String[]>(this.getF7Parameter().getSelectedVirtualMember().size());
            for (String[] virMember : this.getF7Parameter().getSelectedVirtualMember()) {
                if (!StringUtils.isEmptyArrays((String[])virMember) || virMember.length <= 1 || !StringUtils.isNotEmpty((String)virMember[1])) continue;
                backFillNumber.add(virMember[1]);
            }
        } else if (this.getF7Parameter().getSelectedVirtualMember() != null && !this.getF7Parameter().getSelectedVirtualMember().isEmpty()) {
            this.setVirtualMembers(this.getF7Parameter().getSelectedVirtualMember());
        }
        LinkedHashMap allNodeMap = Maps.newLinkedHashMap();
        ObjectCache objCache = ObjectCache.get();
        String _rootId = null;
        boolean hasRootMember = false;
        try {
            String _paramsStr = SerializationUtils.toJsonString((Object)params);
            String _treeData = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"bcm", (String)"MemberQueryMsService", (String)"queryMemberTree", (Object[])new Object[]{_paramsStr});
            if (StringUtils.isNotEmpty((String)_treeData)) {
                Map<String, Object> _member;
                JSONObject members = JSON.parseObject((String)_treeData);
                if (members != null) {
                    for (Map.Entry entry : members.entrySet()) {
                        _member = new HashMap<String, Object>();
                        _member.put("id", entry.getKey());
                        if (entry.getValue() instanceof Map) {
                            Map tmpMap = (Map)entry.getValue();
                            String _memberNumber = (String)tmpMap.get("number");
                            _member.put("number", _memberNumber);
                            if (!hasRootMember && (hasRootMember = StringUtils.equals((String)this.getF7Parameter().getDimensionNumber(), (String)_memberNumber))) {
                                _rootId = (String)entry.getKey();
                            }
                            _member.put("name", tmpMap.get("name"));
                            _member.put("parent.id", objCache.valueOf(tmpMap.get("parentId")));
                            Object _obj = tmpMap.get("data");
                            if (_obj instanceof Map) {
                                tmpMap = (Map)_obj;
                                _member.put("level", objCache.valueOf(tmpMap.get("level")));
                                _member.put("dseq", objCache.valueOf(tmpMap.get("dseq")));
                                _member.put("isleaf", BOOLEANMAP.get(tmpMap.get("isleaf")));
                            }
                        }
                        treeData.add(_member);
                        allNodeMap.put(entry.getKey(), _member);
                        if (backFillNumber == null || !backFillNumber.contains((String)_member.get("number")) || backFillMembers == null) continue;
                        backFillMembers.add(new String[]{IDUtils.toString((Object)_member.get("id")), (String)_member.get("number"), (String)_member.get("name")});
                    }
                }
                if (!hasRootMember) {
                    _member = this.getDefaultRootNode();
                    _rootId = IDUtils.toString((Object)_member.get("id"));
                    treeData.add(_member);
                    allNodeMap.put(_rootId, _member);
                }
            } else {
                log.info("MemberQueryMsService-queryMemberTree:data is null. params=" + _paramsStr);
            }
        }
        catch (Exception ex) {
            log.error("queryInitData-error:", (Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff08%1\uff09\u3002", (String)"VirtualBCMTreeBuilder_0", (String)"epm-eb-business", (Object[])new Object[]{ex.getMessage()}));
        }
        if (backFillMembers != null && !backFillMembers.isEmpty()) {
            this.setVirtualMembers(backFillMembers);
        }
        Long rootId = IDUtils.toLong(_rootId);
        for (Map.Entry entry : allNodeMap.entrySet()) {
            String _id = (String)entry.getKey();
            String _parentId = IDUtils.toString(((Map)entry.getValue()).get("parent.id"));
            if (allNodeMap.containsKey(_parentId) || !StringUtils.notEquals((String)_rootId, (String)_id)) continue;
            ((Map)entry.getValue()).put("parent.id", rootId);
        }
        return treeData;
    }

    protected Map<String, Object> getDefaultRootNode() {
        HashMap<String, Object> rootNode = new HashMap<String, Object>();
        rootNode.put("id", IDUtils.toString((Object)this.getF7Parameter().getDimensionId()));
        rootNode.put("number", this.getF7Parameter().getDimensionNumber());
        rootNode.put("name", this.getF7Parameter().getDimensionName());
        rootNode.put("parent.id", "");
        rootNode.put("level", "1");
        rootNode.put("dseq", "1");
        rootNode.put("isleaf", "0");
        rootNode.put("use", "0");
        return rootNode;
    }

    protected void filterData(List<Map<String, Object>> memberTreeData) {
        Map<String, Object> treeData;
        if (!memberTreeData.isEmpty() && (treeData = memberTreeData.get(0)).containsKey("use")) {
            memberTreeData.remove(0);
        }
    }

    static {
        BOOLEANMAP.put(BgConstant.TRUE_STR, "1");
        BOOLEANMAP.put(BgConstant.FALSE_STR, "0");
        BOOLEANMAP.put(null, "0");
    }
}

