/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.utils;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.memberF7.F7PatternEnum;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.RowColDimMember;
import org.jetbrains.annotations.NotNull;

public class CustomF7utils {
    private static final Log log = LogFactory.getLog(CustomF7utils.class);

    public static void openCustomF7Range(Long modelId, String dimNumber, Long viewId, IFormView formView, RangeF7Param f7Param) {
        DynamicObject dimension = NewF7Utils.getDimension((Long)modelId, (String)dimNumber);
        if (f7Param.getPattern() == F7PatternEnum.NORANGE) {
            MemberF7Parameter f8Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)dimension, (String)RowColDimMember.class.getName());
            CustomF7utils.openF8Range(formView, modelId, dimNumber, viewId, f7Param, f8Param);
            if ("epm_userdefinedmembertree".equals(f8Param.baseEntityNumber())) {
                f8Param.setCanSelectRoot(false);
            }
            NewF7Utils.openF7((IFormView)formView, (MemberF7Parameter)f8Param, (CloseCallBack)f7Param.getCloseCallBack());
        } else if (f7Param.getPattern() == F7PatternEnum.FLOAT) {
            MemberF7Parameter f8Param = NewF7Utils.multipleF8((Long)modelId, (DynamicObject)dimension, (String)RowColDimMember.class.getName());
            CustomF7utils.openF8Range(formView, modelId, dimNumber, viewId, f7Param, f8Param);
            f8Param.setPattern(f7Param.getPattern());
            f8Param.setShowCustomProperty(f7Param.isOpenProperty());
            NewF7Utils.openF8Float((IFormView)formView, (MemberF7Parameter)f8Param, (CloseCallBack)f7Param.getCloseCallBack());
        } else {
            MemberF7Parameter f8Param = NewF7Utils.multipleF8((Long)modelId, (DynamicObject)dimension, (String)DynamicObject.class.getName());
            f8Param.setReturnAllData(true);
            CustomF7utils.openF8Range(formView, modelId, dimNumber, viewId, f7Param, f8Param);
            NewF7Utils.openF8((IFormView)formView, (MemberF7Parameter)f8Param, (CloseCallBack)f7Param.getCloseCallBack());
        }
    }

    private static void openF8Range(@NotNull IFormView view, @NotNull Long modelId, @NotNull String dimNumber, Long viewId, @NotNull RangeF7Param f7Param, @NotNull MemberF7Parameter newF8Param) {
        RowColDimMember floatMember;
        if (IDUtils.isNotNull((Long)f7Param.getBizModelId())) {
            newF8Param.setBusModelId(f7Param.getBizModelId());
        }
        if (IDUtils.isNotNull((Long)f7Param.getDatasetId())) {
            newF8Param.setDatasetId(f7Param.getDatasetId());
        }
        if (IDUtils.isNotNull((Long)viewId)) {
            newF8Param.setViewId(viewId);
        }
        newF8Param.setEnableView(f7Param.isEnableView());
        newF8Param.setVerifyPermission(f7Param.isNeedPermCheck());
        if (f7Param.getPermType() != null) {
            newF8Param.setPermType(f7Param.getPermType());
        }
        NewF7Utils.setShowCusProperty((MemberF7Parameter)newF8Param, (RangeF7Param)f7Param);
        NewF7Utils.setCanSelectRoot((MemberF7Parameter)newF8Param);
        newF8Param.setCanSelectBudgetPeriodRoot(f7Param.isCanSelectBudgetPeriodRoot());
        newF8Param.setShowVariable(org.apache.commons.lang3.StringUtils.equals((CharSequence)"isNeedVar", (CharSequence)f7Param.getIsNeedVar()));
        newF8Param.setHideDecompose(!f7Param.isQueryDecompose());
        newF8Param.setRangeType(f7Param.getRangeType());
        newF8Param.setLockRangeSelect(f7Param.isLockRangeSelect());
        newF8Param.setVariableType(f7Param.getVariableType());
        newF8Param.setMustSelected(f7Param.isMustSelected());
        newF8Param.setMultiSelect(!f7Param.isSingleSelect());
        newF8Param.setShowDisableVisible(f7Param.isShowDisableVisible());
        newF8Param.setShowDisable(f7Param.isShowDisable());
        newF8Param.setShowLevel(f7Param.isShowLevel());
        newF8Param.setSwitchViewBySelMem(f7Param.isSwitchViewBySelMem());
        if (CollectionUtils.isNotEmpty((Collection)f7Param.getUserRange())) {
            newF8Param.setRangeType(F7RangeTypeEnum.CUSTOMIZE);
            newF8Param.setCusRange(f7Param.getUserRange());
        }
        if (f7Param.getDefaultRange() != null) {
            newF8Param.setDefRangeValue(f7Param.getDefaultRange());
        }
        newF8Param.setShowExclude(f7Param.isShowExclude());
        if (newF8Param.isShowExclude()) {
            newF8Param.setExcludeMemberIds(f7Param.getExcludeMemberIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)f7Param.getqFilters())) {
            List after = NewF7Utils.filterF7Param((List)f7Param.getqFilters());
            if (!after.isEmpty()) {
                newF8Param.addCustomCommFilter(after);
            }
            if (IDUtils.isNull((Long)f7Param.getDatasetId())) {
                for (QFilter filter : f7Param.getqFilters()) {
                    if (!filter.getProperty().equalsIgnoreCase("dataset")) continue;
                    if (filter.getValue() instanceof Long) {
                        newF8Param.setDatasetId((Long)filter.getValue());
                        break;
                    }
                    if (!(filter.getValue() instanceof Collection)) break;
                    newF8Param.setDatasetIds(IDUtils.toLongs((Collection)((Collection)filter.getValue())));
                    break;
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)f7Param.getCon_list())) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            CustomF7utils.loadSelectedData(f7Param.getCon_list(), newF8Param, modelCacheHelper.getDimension(dimNumber));
        } else if (StringUtils.isNotEmpty((String)f7Param.getMemberInfo()) && (floatMember = (RowColDimMember)SerializationUtils.deSerializeFromBase64((String)f7Param.getMemberInfo())) != null) {
            newF8Param.setFloat(floatMember.isFloat());
            newF8Param.setFloatAddNew(floatMember.isQuickAddNew());
            if (floatMember.getDefaultParent() != null) {
                newF8Param.setFloatParentId(floatMember.getDefaultParent().getId());
            }
            if (floatMember.getMembers() != null) {
                LinkedHashMap selected = Maps.newLinkedHashMapWithExpectedSize((int)floatMember.getMembers().size());
                for (IDimensionMember _member : floatMember.getMembers()) {
                    selected.put(_member.getId(), _member.getScope());
                }
                newF8Param.setSelectIds((Map)selected);
            }
        }
        if (StringUtils.isNotEmpty((String)f7Param.getSign())) {
            newF8Param.setViewSign(f7Param.getSign());
            CustomF7utils.loadCacheSelectedData(view, newF8Param);
        }
    }

    @Deprecated
    public static void openCustomF7Range(Long modelId, String dimNumber, Long viewId, boolean isSingleSelect, List<QFilter> qFilters, CloseCallBack closeCallBack, IFormView formView, List<MemberCondition> con_list, String sign) {
        CustomF7utils.openCustomF7Range(modelId, dimNumber, viewId, isSingleSelect, qFilters, closeCallBack, formView, con_list, sign, F7RangeTypeEnum.DEFAULT.getNumber(), null);
    }

    @Deprecated
    public static void openCustomF7Range(Long modelId, String dimNumber, Long viewId, boolean isSingleSelect, List<QFilter> qFilters, CloseCallBack closeCallBack, IFormView formView, List<MemberCondition> con_list, String sign, String rangeType, FormShowParameter showParameter) {
        CustomF7utils.openCustomF7Range(modelId, dimNumber, viewId, isSingleSelect, qFilters, closeCallBack, formView, con_list, sign, rangeType, showParameter, false);
    }

    @Deprecated
    public static void openCustomF7Range(Long modelId, String dimNumber, long viewId, boolean isSingleSelect, List<QFilter> qFilters, CloseCallBack closeCallBack, IFormView formView, List<MemberCondition> con_list, String sign, String rangeType, FormShowParameter showParameter, boolean enableView, boolean isNeedPermCheck, Long bizModelId) {
        CustomF7utils.openCustomF7Range(modelId, dimNumber, viewId, isSingleSelect, qFilters, closeCallBack, formView, con_list, sign, rangeType, showParameter, enableView, isNeedPermCheck, bizModelId, null);
    }

    public static void openCustomF7Range(Long modelId, String dimNumber, long viewId, boolean isSingleSelect, List<QFilter> qFilters, CloseCallBack closeCallBack, IFormView formView, List<MemberCondition> con_list, String sign, String rangeType, FormShowParameter showParameter, boolean enableView, boolean isNeedPermCheck, Long bizModelId, IModelCacheHelper modelCacheHelper) {
        List after;
        MemberF7Parameter f8Param = NewF7Utils.multipleF8((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)DynamicObject.class.getName());
        f8Param.setMultiSelect(!isSingleSelect);
        if (IDUtils.isNotNull((Long)bizModelId)) {
            f8Param.setBusModelId(bizModelId);
        }
        if (IDUtils.isNotNull((long)viewId)) {
            f8Param.setViewId(Long.valueOf(viewId));
        }
        f8Param.setEnableView(enableView);
        if (StringUtils.isNotEmpty((String)rangeType)) {
            f8Param.setRangeType(F7RangeTypeEnum.numberOf((String)rangeType));
        } else {
            f8Param.setRangeType(F7RangeTypeEnum.DEFAULT);
        }
        f8Param.setVerifyPermission(isNeedPermCheck);
        if (CollectionUtils.isNotEmpty(qFilters) && !(after = NewF7Utils.filterF7Param(qFilters)).isEmpty()) {
            f8Param.addCustomCommFilter(after);
        }
        if (CollectionUtils.isNotEmpty(con_list)) {
            if (modelCacheHelper == null) {
                modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            }
            CustomF7utils.loadSelectedData(con_list, f8Param, modelCacheHelper.getDimension(dimNumber));
        }
        if (StringUtils.isNotEmpty((String)sign)) {
            f8Param.setViewSign(sign);
            CustomF7utils.loadCacheSelectedData(formView, f8Param);
        }
        if (showParameter != null && "true".equalsIgnoreCase((String)showParameter.getCustomParam("showNotEnable"))) {
            f8Param.setShowNotEnable(true);
        }
        if (f8Param.getDatasetIds() == null || f8Param.getDatasetIds().isEmpty()) {
            for (QFilter filter : qFilters) {
                if (!filter.getProperty().equalsIgnoreCase("dataset")) continue;
                if (filter.getValue() instanceof Long) {
                    f8Param.setDatasetId((Long)filter.getValue());
                    break;
                }
                if (!(filter.getValue() instanceof Collection)) break;
                f8Param.setDatasetIds(IDUtils.toLongs((Collection)((Collection)filter.getValue())));
                break;
            }
        }
        NewF7Utils.openF8((IFormView)formView, (MemberF7Parameter)f8Param, (CloseCallBack)closeCallBack);
    }

    @Deprecated
    public static void openCustomF7Range(Long modelId, String dimNumber, Long viewId, boolean isSingleSelect, List<QFilter> qFilters, CloseCallBack closeCallBack, IFormView formView, List<MemberCondition> con_list, String sign, String rangeType, FormShowParameter showParameter, boolean enableView) {
        CustomF7utils.openCustomF7Range(modelId, dimNumber, viewId, isSingleSelect, qFilters, closeCallBack, formView, con_list, sign, rangeType, showParameter, enableView, false, 0L);
    }

    public static void loadCacheSelectedData(@NotNull IFormView formView, @NotNull MemberF7Parameter newF8Param) {
        if (formView == null || newF8Param == null) {
            return;
        }
        String selectedData = formView.getPageCache().get(newF8Param.getViewSign());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)selectedData)) {
            MemberPropCache propCache = MemberPropCacheService.getOrCreate((Long)newF8Param.getModelId());
            List members = null;
            try {
                members = (List)SerializationUtils.fromJsonString((String)selectedData, List.class);
            }
            catch (Exception ex) {
                log.error("f8-loadCacheSelectedData-error:", (Throwable)ex);
                log.error("f8-loadCacheSelectedData-error:", (Object)selectedData);
            }
            if (members != null) {
                LinkedHashMap selected = Maps.newLinkedHashMapWithExpectedSize((int)members.size());
                for (Map member : members) {
                    CustomPropertyValue propertyValue;
                    Long memberId;
                    CustomProperty property;
                    Object _scope = member.get("scope");
                    if (_scope == null || "".equals(_scope)) {
                        _scope = member.get("range");
                    }
                    if ((property = propCache.getProperty(memberId = IDUtils.toLong(member.get("id")))) != null && (propertyValue = propCache.getPropertyValue(newF8Param.getDimensionNumber(), property.getNumber(), (String)member.get("number"))) != null) {
                        memberId = propertyValue.getId();
                    }
                    if (_scope instanceof String) {
                        selected.put(memberId, RangeEnum.getRangeByVal((int)Integer.parseInt((String)_scope)).getIndex());
                        continue;
                    }
                    selected.put(memberId, RangeEnum.ONLY.getIndex());
                }
                newF8Param.setSelectIds((Map)selected);
            }
        }
    }

    public static void loadSelectedData(List<MemberCondition> members, @NotNull MemberF7Parameter f8Param, @NotNull Dimension dimension) {
        if (members == null || members.isEmpty() || f8Param == null || dimension == null) {
            return;
        }
        LinkedHashMap selected = Maps.newLinkedHashMapWithExpectedSize((int)members.size());
        LinkedHashMap rangeLevels = Maps.newLinkedHashMapWithExpectedSize((int)members.size());
        MemberPropCache propCache = null;
        HashMap varNumbers = Maps.newHashMapWithExpectedSize((int)members.size());
        for (MemberCondition member : members) {
            RangeEnum _range = RangeEnum.ONLY;
            if (StringUtils.isNotEmpty((String)member.getRange())) {
                _range = RangeEnum.getRangeByVal((int)Integer.parseInt(member.getRange()));
            }
            if (StringUtils.isNotEmpty((String)member.getId())) {
                Long memberId = IDUtils.toLong((Object)member.getId());
                selected.put(memberId, _range.getIndex());
                if (member.getRangeLevel() <= 0) continue;
                rangeLevels.put(memberId, member.getRangeLevel());
                continue;
            }
            if (!StringUtils.isNotEmpty((String)member.getNumber())) continue;
            if (member.isProp()) {
                CustomPropertyValue propertyValue;
                String[] propNumbers;
                if (!StringUtils.isNotEmpty((String)member.getLongnumber()) || (propNumbers = member.getLongnumber().split("!")).length != 2) continue;
                if (propCache == null) {
                    propCache = MemberPropCacheService.getOrCreate((Long)f8Param.getModelId());
                }
                if ((propertyValue = propCache.getPropertyValue(f8Param.getDimensionNumber(), propNumbers[0], propNumbers[1])) == null) continue;
                selected.put(propertyValue.getId(), _range.getIndex());
                continue;
            }
            if (member.isVariable()) {
                varNumbers.put(member.getNumber(), _range.getIndex());
                continue;
            }
            Member _member = dimension.getMember(f8Param.getViewId(), member.getNumber());
            if (_member == null) continue;
            selected.put(_member.getId(), _range.getIndex());
            if (member.getRangeLevel() <= 0) continue;
            rangeLevels.put(_member.getId(), member.getRangeLevel());
        }
        if (!varNumbers.isEmpty()) {
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", (Object)f8Param.getModelId());
            builder.add("dimension", "=", (Object)f8Param.getDimensionId());
            builder.add("number", "in", varNumbers.keySet());
            Map vars = BusinessDataServiceHelper.loadFromCache((String)"eb_periodvariable", (String)"id,number,name", (QFilter[])builder.toArray());
            if (vars != null && !vars.isEmpty()) {
                for (DynamicObject _var : vars.values()) {
                    selected.put(_var.getLong("id"), varNumbers.get(_var.getString("number")));
                }
            }
        }
        f8Param.setSelectIds((Map)selected);
        if (!rangeLevels.isEmpty()) {
            f8Param.addRangeLevel((Map)rangeLevels);
        }
    }
}

