/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.model;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.MultiLangEnumBridge;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.face.IControlAmount;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.impl.model.AbstractBgControlRecord;
import kd.epm.eb.control.impl.model.ControlParam;
import kd.epm.eb.control.utils.BgControlRecordUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.control.utils.BgPeriodUtils;

public class BgControlRecord
extends AbstractBgControlRecord
implements IControlAmount {
    private static final long serialVersionUID = -3965131344663949608L;
    private String memberKey = null;
    private String memberKeyIgnPeriod = null;
    private String dataKey = null;
    private boolean isRemove = false;
    private boolean isOnlyCheck = false;
    private BigDecimal newAmount = null;
    private Set<String> parentMemberkeyByBudget = null;

    public BgControlRecord getClone() {
        BgControlRecord newobj = (BgControlRecord)((Object)this.clone());
        newobj.setBizModel(this.getBizModel());
        return newobj;
    }

    public static BgControlRecord createFromControlParam(IControlParam controlParam, String entityNumber, Collection<Dimension> dimensions, Date createTime, String operation) {
        return BgControlRecord.createFromControlParam(controlParam, entityNumber, dimensions, createTime, operation, null);
    }

    public static BgControlRecord createFromControlParam(IControlParam controlParam, String entityNumber, Collection<Dimension> dimensions, Date createTime, String operation, Member occPeriod) {
        JSONObject entityObj;
        if (controlParam == null || StringUtils.isEmpty((String)entityNumber) || dimensions == null || dimensions.isEmpty()) {
            return null;
        }
        BgControlRecord record = new BgControlRecord();
        record.setEntityNumber(entityNumber);
        record.setCreateTime(createTime);
        record.setBizModel(controlParam.getBizModel());
        record.setEntityNumber(entityNumber);
        record.setBizId(controlParam.getBizId());
        record.setBizNumber(controlParam.getBizNumber());
        record.setOperation(operation);
        record.setAmount(controlParam.getAmount());
        record.setSetting(controlParam.getSetting().getId());
        record.setRefBizId(controlParam.getRefBizId());
        record.setEntryId(controlParam.getEntryId());
        record.setOccPeriod(occPeriod);
        record.setOnlyCheck(controlParam.isOnlyCheck());
        for (Dimension dimension : dimensions) {
            record.setMember(controlParam.getMember(false, dimension.getNumber()));
        }
        record.setBgMemberJson(BgControlRecord.getBudgetMemberJson(controlParam, dimensions));
        record.setReqOrgUnit(controlParam.getReqMember(SysDimensionEnum.Entity.getNumber()));
        record.setReqAccount(controlParam.getReqMember(SysDimensionEnum.Account.getNumber()));
        Member metric = controlParam.getMember(false, SysDimensionEnum.Metric.getNumber());
        if (metric != null) {
            record.setMember(metric);
        }
        record.setRequestId(RequestContext.get().getTraceId());
        record.setStatus("2");
        JSONObject reqObj = controlParam.getReqObj();
        if (reqObj != null && reqObj.containsKey((Object)SysDimensionEnum.Entity.getNumber())) {
            entityObj = reqObj.getJSONObject(SysDimensionEnum.Entity.getNumber());
            record.setReqEntBaseData(entityObj.getString("metaType"));
            record.setReqEntId(entityObj.getLong("id"));
        }
        if (reqObj != null && reqObj.containsKey((Object)SysDimensionEnum.Account.getNumber())) {
            entityObj = reqObj.getJSONObject(SysDimensionEnum.Account.getNumber());
            record.setReqAccBasedata(entityObj.getString("metaType"));
            record.setReqAccId(entityObj.getLong("id"));
        }
        return record;
    }

    public static String getBudgetMemberJson(IControlParam controlParam, Collection<Dimension> dimensions) {
        JSONObject bgMemberJson = new JSONObject();
        for (Dimension dimension : dimensions) {
            if (!SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber()) && !SysDimensionEnum.Account.getNumber().equals(dimension.getNumber()) && !BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) continue;
            if (controlParam.getMember(true, dimension.getNumber()) != null) {
                bgMemberJson.put(controlParam.getMember(false, dimension.getNumber()).getId().toString(), (Object)controlParam.getMember(true, dimension.getNumber()).getId().toString());
                continue;
            }
            bgMemberJson.put(controlParam.getMember(false, dimension.getNumber()).getId().toString(), (Object)controlParam.getMember(false, dimension.getNumber()).getId().toString());
        }
        return bgMemberJson.toJSONString();
    }

    public static List<IControlParam> createControlParam(IControlParameter controlParameter, List<BgControlRecord> controlRecords) {
        ArrayList<IControlParam> controlParams = new ArrayList<IControlParam>(controlRecords.size());
        Collection allModels = CacheServiceHelper.queryCacheByScenVerNoTime();
        HashMap bizModelMap = new HashMap(16);
        if (allModels != null) {
            allModels.forEach(f -> bizModelMap.put(BizModel.getKey((Long)f.getId(), (Long)(f.getStartVersion() == null ? 0L : f.getStartVersion().getLong("bussmodel.id"))), f));
        }
        JSONObject bgMemberJson = null;
        HashMap<Long, IModelCacheHelper> cachehelper = new HashMap<Long, IModelCacheHelper>(1);
        for (BgControlRecord controlRecord : controlRecords) {
            bgMemberJson = StringUtils.isNotEmpty((String)controlRecord.getBgMemberJson()) ? JSONObject.parseObject((String)controlRecord.getBgMemberJson()) : null;
            BizModel bizModel = controlRecord.getBizModel();
            ControlParam controlParam = new ControlParam();
            controlParam.setBizModel(bizModel);
            controlParam.setAmount(controlRecord.getAmount());
            controlParam.setAmend(controlRecord.getAmount());
            controlParam.setBizNumber(controlRecord.getBizNumber());
            controlParam.setBizId(controlRecord.getBizId());
            controlParam.setRefBizId(controlRecord.getRefBizId());
            controlParam.setEntityNumber(controlRecord.getEntityNumber());
            List dimensions = bizModel.getDimensions();
            for (Dimension dimension : dimensions) {
                controlParam.setMember(false, controlRecord.getMember(dimension));
            }
            Date bizTime = BgPeriodUtils.parseBizTime((IControlParam)controlParam);
            controlParam.setBizTime(bizTime);
            if (bizModelMap == null || bizModelMap.get(bizModel.getKey()) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u63a7\u5236\u7248\u672c\u4fe1\u606f\u3002", (String)"BgControlRecord_7", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            DynamicObject controlVersion = ((BizModel)bizModelMap.get(bizModel.getKey())).getStartVersion();
            IModelCacheHelper modelCache = (IModelCacheHelper)cachehelper.get(bizModel.getId());
            if (modelCache == null) {
                modelCache = ModelCacheContext.getOrCreate((Long)bizModel.getId());
                cachehelper.put(bizModel.getId(), modelCache);
            }
            for (Dimension dimension : dimensions) {
                Member member = null;
                if (SysDimensionEnum.AuditTrail.getNumber().equals(dimension.getNumber())) {
                    Long atId;
                    if (controlVersion != null && (atId = (Long)controlVersion.get("audittrail.id")) != null && atId != 0L) {
                        member = new Member(atId, (String)controlVersion.get("audittrail.name"), (String)controlVersion.get("audittrail.number"));
                        member.setDimension(dimension);
                        controlParam.setMember(true, member);
                    }
                    if (member != null) continue;
                    member = new Member(null, "ATTotal", "ATTotal");
                    member.setDimension(dimension);
                    controlParam.setMember(true, member);
                    continue;
                }
                if (SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber())) {
                    member = new Member(null, "CurrentPeriod", "CurrentPeriod");
                    member.setDimension(dimension);
                    controlParam.setMember(true, member);
                    member = new Member(null, "Occupation", "Occupation");
                    member.setDimension(dimension);
                    controlParam.setMember(false, member);
                    continue;
                }
                if (SysDimensionEnum.DataType.getNumber().equals(dimension.getNumber())) {
                    Long dtId;
                    member = null;
                    if (controlVersion != null && controlVersion.getDataEntityType().getProperties().containsKey((Object)"datatype.id") && (dtId = (Long)controlVersion.get("datatype.id")) != null && dtId != 0L) {
                        member = new Member(dtId, (String)controlVersion.get("datatype.name"), (String)controlVersion.get("datatype.number"));
                    }
                    if (member == null) {
                        member = new Member(null, "Budget", "Budget");
                    }
                    member.setDimension(dimension);
                    controlParam.setMember(true, member);
                    continue;
                }
                if (SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) {
                    member = new Member(null, "ICNone", "ICNone");
                    member.setDimension(dimension);
                    controlParam.setMember(true, member);
                    controlParam.setMember(false, member);
                    continue;
                }
                if (SysDimensionEnum.Version.getNumber().equals(dimension.getNumber())) {
                    if (controlVersion == null) continue;
                    Member version = new Member((Long)controlVersion.get("version.id"), (String)controlVersion.get("version.name"), (String)controlVersion.get("version.number"));
                    version.setDimension(dimension);
                    controlParam.setMember(true, version);
                    version = new Member((Long)controlVersion.get("acversion.id"), (String)controlVersion.get("acversion.name"), (String)controlVersion.get("acversion.number"));
                    version.setDimension(dimension);
                    controlParam.setMember(false, version);
                    continue;
                }
                if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.Account.getNumber().equals(dimension.getNumber()) || BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                    if (StringUtils.isNotEmpty((String)controlRecord.getBgMemberJson())) {
                        Long memberId = controlRecord.getMember(dimension).getId();
                        if (bgMemberJson != null && bgMemberJson.containsKey((Object)String.valueOf(memberId))) {
                            kd.epm.eb.common.cache.impl.Member _member = modelCache.getMemberByAnyView(bizModel.getControlBusModelId(), dimension.getNumber(), IDUtils.toLong((Object)bgMemberJson.getString(String.valueOf(memberId))));
                            if (_member != null) {
                                if (_member.getLevel() == 1 && bizModel.getControlBusModelId() != 0L) {
                                    Long viewId = modelCache.getViewByBusModelAndDimNumber(bizModel.getControlBusModelId(), dimension.getNumber());
                                    _member = modelCache.getRootMember(dimension.getNumber(), viewId);
                                }
                                Member m = Member.loadFormCache((kd.epm.eb.common.cache.impl.Member)_member);
                                m.setDimension(dimension);
                                controlParam.setMember(true, m);
                                continue;
                            }
                            controlParam.setMember(true, controlRecord.getMember(dimension));
                            continue;
                        }
                        controlParam.setMember(true, controlRecord.getMember(dimension));
                        continue;
                    }
                    controlParam.setMember(true, controlRecord.getMember(dimension));
                    continue;
                }
                controlParam.setMember(true, controlRecord.getMember(dimension));
            }
            controlParams.add((IControlParam)controlParam);
        }
        return controlParams;
    }

    public static BgControlRecord createFromControlParam(BgControlRecord bgControlRecord, Date createTime, String operation) {
        if (bgControlRecord == null) {
            return null;
        }
        BgControlRecord record = bgControlRecord.getClone();
        record.setCreateTime(createTime);
        record.setOperation(operation);
        return record;
    }

    public DynamicObject getObject() {
        DynamicObject obj = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"eb_bgcontrolrecord"));
        obj.set("id", (Object)DBServiceHelper.genGlobalLongId());
        obj.set("entitynumber", (Object)this.getEntityNumber());
        obj.set("bizid", (Object)this.getBizId());
        obj.set("biznumber", (Object)this.getBizNumber());
        obj.set("amount", (Object)this.getAmount());
        obj.set("creator", (Object)this.getCreator());
        obj.set("createtime", (Object)this.getCreateTime());
        obj.set("operation", (Object)this.getOperation());
        obj.set("settingid", (Object)(this.getSetting() != null ? this.getSetting() : 0L));
        obj.set("occperiod", (Object)(this.getOccPeriod() != null ? this.getOccPeriodId() : 0L));
        obj.set("model", (Object)this.getBizModel().getId());
        obj.set("reqorgunit", (Object)this.getReqOrgUnitId());
        obj.set("reqaccount", (Object)this.getReqAccountId());
        for (Dimension dimension : this.getBizModel().getDimensions()) {
            if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                String userDefined = BgControlUtils.getEBUserDefined(dimension);
                if (userDefined == null) continue;
                obj.set(userDefined, (Object)this.getMember(dimension).getId());
                continue;
            }
            obj.set((String)BgControlRecordUtils.getRecordProps().get(dimension.getNumber()), (Object)this.getMember(dimension).getId());
        }
        obj.set("occtype", (Object)this.getOccType());
        obj.set("bgmemberjson", (Object)this.getBgMemberJson());
        obj.set("refbizid", (Object)this.getRefBizId());
        obj.set("entryid", (Object)this.getEntryId());
        obj.set("requestId", (Object)this.getRequestId());
        obj.set("status", (Object)this.getStatus());
        obj.set("writeofftype", (Object)this.getWriteOffType());
        obj.set("refentryid", (Object)this.getRefEntryId());
        obj.set("serialtextjson", (Object)this.getSerialJson());
        return obj;
    }

    public String getMemberKey(boolean ignPeriod) {
        if (this.getBizModel() == null || this.getBizModel().getDimensions() == null || this.getBizModel().getDimensions().isEmpty()) {
            ControlException.errorBizModel();
        }
        if (ignPeriod) {
            if (this.memberKeyIgnPeriod == null) {
                this.memberKeyIgnPeriod = BgControlUtils.getMemberKey(this, false, true, this.getBizModel().getDimensions());
            }
            return this.memberKeyIgnPeriod;
        }
        if (this.memberKey == null) {
            this.memberKey = BgControlUtils.getMemberKey(this, false, false, this.getBizModel().getDimensions());
        }
        return this.memberKey;
    }

    public String getMemberKey() {
        return this.getMemberKey(false);
    }

    public String getReqKey() {
        return this.getReqOrgUnitId() + "!" + this.getReqAccountId();
    }

    public Member getReqOrgUnitOcc() {
        return this.getReqOrgUnit();
    }

    public Member getReqAccountOcc() {
        return this.getReqAccount();
    }

    public String getMemberKeyByIgnChangeType() {
        if (this.getBizModel() == null || this.getBizModel().getDimensions() == null || this.getBizModel().getDimensions().isEmpty()) {
            ControlException.errorBizModel();
        }
        if (this.dataKey == null) {
            this.dataKey = BgControlUtils.getMemberKey(this, true, true, this.getBizModel().getDimensions());
        }
        return this.dataKey;
    }

    public void setRemove(boolean isRemove) {
        this.isRemove = isRemove;
    }

    public boolean isRemove() {
        return this.isRemove;
    }

    public void setOnlyCheck(boolean isOnlyCheck) {
        this.isOnlyCheck = isOnlyCheck;
    }

    public boolean isOnlyCheck() {
        return this.isOnlyCheck;
    }

    public boolean isOccupation() {
        return false;
    }

    public BigDecimal getOccValue() {
        return this.getAmount();
    }

    public void setNewAmount(BigDecimal newAmount) {
        this.newAmount = newAmount;
    }

    public BigDecimal getNewAmount() {
        return this.newAmount;
    }

    public Member getMember(boolean isBudget, String dimensionNumber) {
        Member member = this.getMember(dimensionNumber);
        if (member != null && this.getBizModel() != null) {
            member.setDimension(this.getBizModel().getDimension(dimensionNumber));
            Long modelId = this.getBizModel().getId();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Long viewId = modelCacheHelper.getViewByBusModelAndDimNumber(this.getBizModel().getControlBusModelId(), dimensionNumber);
            kd.epm.eb.common.cache.impl.Member _m = modelCacheHelper.getMember(dimensionNumber, viewId, member.getNumber());
            if (_m != null) {
                member.setLongNumber(_m.getLongNumber());
            }
        }
        return member;
    }

    public Set<String> getParentMemberkeyByBudget(Map<Long, Set<String>> members) {
        if (this.parentMemberkeyByBudget == null) {
            this.parentMemberkeyByBudget = BgControlUtils.getParentMemberKey(this, true, false, false, this.getBizModel().getDimensions(), members);
            this.parentMemberkeyByBudget.remove(this.getMemberKey());
        }
        return this.parentMemberkeyByBudget;
    }

    public Boolean isOcc() {
        String changeType = this.getMember(SysDimensionEnum.ChangeType.getNumber()).getNumber();
        return "Occupation".equals(changeType);
    }

    public Boolean isExe() {
        String changeType = this.getMember(SysDimensionEnum.ChangeType.getNumber()).getNumber();
        return "Execute".equals(changeType);
    }

    public Boolean isOccExe(Boolean isOccOrExe) {
        String changeType = this.getMember(SysDimensionEnum.ChangeType.getNumber()).getNumber();
        return isOccOrExe != false ? "Occupation".equals(changeType) : "Execute".equals(changeType);
    }

    public static class Status {
        public static final String NORMAL = "1";
        public static final String CONFIRM = "2";
        public static final String DEL = "3";
    }

    public static enum OccupationType {
        INITOCC("initocc", new MultiLangEnumBridge("\u521d\u59cb\u5360\u7528", "BgControlRecord_1", "epm-eb-business")),
        REVOCC("revocc", new MultiLangEnumBridge("\u8865\u5145\u5360\u7528", "BgControlRecord_2", "epm-eb-business")),
        WOOCC("woocc", new MultiLangEnumBridge("\u51b2\u9500\u5360\u7528", "BgControlRecord_3", "epm-eb-business")),
        CLSOCC("clsocc", new MultiLangEnumBridge("\u5173\u95ed\u5360\u7528", "BgControlRecord_4", "epm-eb-business")),
        REPOCC("repocc", new MultiLangEnumBridge("\u91cd\u542f\u5360\u7528", "BgControlRecord_5", "epm-eb-business")),
        EXECUTE("execute", new MultiLangEnumBridge("\u6267\u884c", "BgControlRecord_6", "epm-eb-business")),
        REVEXEC("revexec", new MultiLangEnumBridge("\u8865\u5145\u6267\u884c", "BgControlRecord_8", "epm-eb-business"));

        private String number;
        private MultiLangEnumBridge name;

        private OccupationType(String number, MultiLangEnumBridge name) {
            this.number = number;
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }
    }
}

