/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.control.impl.model.BgControlRecord;
import kd.epm.eb.control.utils.BgControlRecordUtils;

public class BgReturnBudgetUtils {
    public static List<BgControlRecord> returnBudget(String entityNumber, String bizId, List<BgControlRecord> records) {
        if (entityNumber == null || bizId == null || records == null || records.isEmpty()) {
            return records;
        }
        ArrayList<BgControlRecord> filter = new ArrayList<BgControlRecord>(records.size());
        ArrayList<BgControlRecord> returns = new ArrayList<BgControlRecord>(records.size());
        HashMap<Long, BizModel> models = new HashMap<Long, BizModel>();
        for (BgControlRecord record : records) {
            if (bizId.equals(record.getBizId())) {
                record.setAmount(record.getAmount().negate());
                returns.add(record);
                models.put(record.getBizModel().getKey(), record.getBizModel());
                continue;
            }
            filter.add(record);
        }
        String bizNumber = records.get(0).getBizNumber();
        if (!returns.isEmpty()) {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    BgControlRecordUtils.batchSaveOlap(models.values(), records, (String)bizNumber);
                    BgControlRecordUtils.delete(new HashSet<BgControlRecord>(records));
                }
                catch (Throwable ex) {
                    tx.markRollback();
                    throw ex;
                }
            }
        }
        return filter;
    }
}

