/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.algo.olap.Cell;
import kd.epm.eb.algo.olap.Cube;
import kd.epm.eb.algo.olap.Hierarchy;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.collection.IList;
import kd.epm.eb.algo.olap.impl.AxisImpl;
import kd.epm.eb.algo.olap.impl.CellImpl;
import kd.epm.eb.algo.olap.impl.CellKey;
import kd.epm.eb.algo.olap.impl.CellReaderImpl;
import kd.epm.eb.algo.olap.impl.CellValues;
import kd.epm.eb.algo.olap.impl.ConnectionImpl;
import kd.epm.eb.algo.olap.impl.CubeImpl;
import kd.epm.eb.algo.olap.impl.DimensionImpl;
import kd.epm.eb.algo.olap.impl.EvaluateContext;
import kd.epm.eb.algo.olap.impl.EvaluatorImpl;
import kd.epm.eb.algo.olap.impl.MdxResultBase;
import kd.epm.eb.algo.olap.impl.Stats;
import kd.epm.eb.algo.olap.mdx.CellReader;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.MdxQuery;
import kd.epm.eb.algo.olap.mdx.QueryAxis;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.Scope;
import kd.epm.eb.algo.olap.util.Util;
import org.apache.log4j.Logger;

public class MdxResultSimpleImpl
extends MdxResultBase {
    private static final Logger logger = Logger.getLogger(MdxResultSimpleImpl.class);
    private final CellValues cellValues;
    private transient CellKey point;
    private transient HashMap<QueryAxis, IList> axisPositionList;
    private boolean x = false;
    private ConnectionImpl cn;
    private long beginTime;
    private int timeCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdxResultSimpleImpl(MdxQuery query, List<String[]>[] filters, Stats stats) throws OlapException {
        super(query, new AxisImpl[query.getAxes().length]);
        this.point = new CellKey(new int[query.getAxes().length]);
        CubeImpl cube = (CubeImpl)query.getCube();
        this.cn = (ConnectionImpl)query.getConnection();
        CellReaderImpl cellReader = new CellReaderImpl(this.cn.database.getCubeDataReader((Cube)cube));
        EvaluatorImpl evaluator = new EvaluatorImpl((EvaluateContext)query, (Cube)cube, (CellReader)cellReader);
        this.cellValues = new CellValues();
        this.axisPositionList = new HashMap();
        boolean allNonEmpty = false;
        this.beginTime = System.currentTimeMillis();
        Set cellCalculatedMemberSet = query.getCellCalculationMemberSet(evaluator.push());
        QueryAxis[] queryAxes = query.getAxes();
        if (queryAxes[0].isNonEmpty() && !queryAxes[1].isNonEmpty()) {
            this.x = true;
        } else if (queryAxes[0].isNonEmpty() && queryAxes[1].isNonEmpty()) {
            allNonEmpty = true;
        }
        ArrayList[] memFilters = null;
        if (filters != null && filters.length > 0) {
            Map memberMap;
            HashMap<String, Map> dimMemberMap = new HashMap<String, Map>();
            int xn = cube.getDimensions().length;
            for (int x = 0; x < xn; ++x) {
                DimensionImpl dim = (DimensionImpl)cube.getDimensions()[x];
                memberMap = dimMemberMap.computeIfAbsent(dim.getName(), f -> new HashMap());
                Iterator iter = dim.memberIterator();
                while (iter.hasNext()) {
                    Member _member = (Member)iter.next();
                    memberMap.put(_member.getName(), _member);
                }
            }
            memFilters = new ArrayList[filters.length];
            List<String[]> _filter2 = null;
            ArrayList<Member[]> _bFilter = null;
            Member[] _members = null;
            for (List<String[]> _filter2 : filters) {
                if (_filter2 == null || _filter2.size() <= 1) continue;
                _bFilter = new ArrayList<Member[]>(_filter2.size());
                String[] fields = _filter2.get(0);
                for (String[] numbers : _filter2) {
                    if (numbers == null) continue;
                    _members = new Member[numbers.length];
                    int zn = fields.length;
                    for (int z = 0; z < zn; ++z) {
                        memberMap = (Map)dimMemberMap.get(fields[z]);
                        if (memberMap == null) continue;
                        _members[z] = (Member)memberMap.get(numbers[z]);
                        if (_members[z] != null) continue;
                        logger.error((Object)("filter field -> " + fields[z] + " Number -> " + numbers[z] + " not find."));
                        _members = null;
                        break;
                    }
                    if (_members == null) continue;
                    _bFilter.add(_members);
                }
                memFilters[x] = _bFilter;
            }
        }
        try {
            Calc slicerCalc = query.getSlicerCalc();
            if (slicerCalc != null) {
                Scope scope = new Scope(slicerCalc, false, Scope.NeedHierarchize.No);
                slicerCalc = slicerCalc.optimize(scope, (Evaluator)evaluator);
            }
            query.setSlicerCalc(slicerCalc);
            IList slicerPositions = this.executeSliceAxis(evaluator.push(), slicerCalc);
            Member[] slicerPosition = (Member[])slicerPositions.get(0);
            evaluator.setContext(slicerPosition);
            evaluator.setSlicerMember(slicerPosition);
            Calc calc = null;
            for (int i = 0; i < this.axes.length; ++i) {
                QueryAxis axis = query.getAxes()[i];
                calc = query.getAxisCalcs()[i];
                if (calc != null) {
                    Scope scope = new Scope(calc, axis.isNonEmpty(), Scope.NeedHierarchize.Unknow);
                    calc = calc.optimize(scope, (Evaluator)evaluator);
                }
                query.getAxisCalcs()[i] = calc;
                IList list = this.executeAxis((CellReader)cellReader, evaluator.push(), axis, calc);
                this.axisPositionList.put(axis, list);
                evaluator.clearExpResultCache(false);
            }
            if (allNonEmpty) {
                QueryAxis axis = query.getAxes()[0];
                IList list0 = this.axisPositionList.get(axis);
                axis = query.getAxes()[1];
                IList list1 = this.axisPositionList.get(axis);
                if (list0.size() > 1500 && list1.size() > 1500) {
                    throw new OlapException("Too much query axis,two query axis exceed 1500 positions,please reduce one query axis range.");
                }
                if (list0.size() > list1.size()) {
                    this.x = true;
                }
            }
            long t1 = System.currentTimeMillis();
            this.executeBody((CellReader)cellReader, evaluator, query, cellCalculatedMemberSet, memFilters);
            this.println("MdxResultImpl.executeBody:" + (System.currentTimeMillis() - t1) + " ms.");
            this.println("MdxQuery.useTime:" + query.useTime + " ms.");
            this.println("CellValues size: " + this.cellValues.values.size());
            stats.appendMessage("MdxQuery.useTime:" + query.useTime + " ms.");
            stats.appendMessage("CellValues size: " + this.cellValues.values.size());
            this.cn.database.printStatistics(stats);
            this.axisPositionList = null;
        }
        finally {
            evaluator.clearExpResultCache(true);
        }
    }

    private void println(String message) {
        logger.info((Object)message);
    }

    private Member[] toMemberArray(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Member[]) {
            return (Member[])o;
        }
        if (o instanceof Member) {
            return new Member[]{(Member)o};
        }
        if (o instanceof Object[]) {
            Object[] os = (Object[])o;
            Member[] ms = new Member[os.length];
            System.arraycopy(os, 0, ms, 0, os.length);
            return ms;
        }
        throw new ClassCastException();
    }

    private boolean isEmpty(int[] pos, int offset, int fixedAxis) {
        int axisCount = this.getAxes().length;
        pos[fixedAxis] = offset;
        return this.isEmptyRecurse(pos, fixedAxis, axisCount - 1);
    }

    private boolean isEmptyRecurse(int[] pos, int fixedAxis, int axis) {
        if (axis < 0) {
            Object value = this.cellValues.get(new CellKey(pos));
            return value == null;
        }
        if (axis == fixedAxis) {
            return this.isEmptyRecurse(pos, fixedAxis, axis - 1);
        }
        IList positions = this.axisPositionList.get(this.query.getAxes()[axis]);
        int i = 0;
        int count = positions.size();
        while (i < count) {
            pos[axis] = i++;
            if (this.isEmptyRecurse(pos, fixedAxis, axis - 1)) continue;
            return false;
        }
        return true;
    }

    private int getAxisIndex(int index) {
        return this.x ? (index + 1) % 2 : index;
    }

    private QueryAxis getAxis(int index) {
        return this.query.getAxes()[this.getAxisIndex(index)];
    }

    private IList executeAxis(CellReader cellReader, Evaluator evaluator, QueryAxis axis, Calc calc) throws OlapException {
        if (evaluator == null || axis == null || calc == null) {
            return (IList)Collections.EMPTY_LIST;
        }
        boolean nonEmpty = axis.isNonEmpty();
        evaluator.setNonEmpty(nonEmpty);
        boolean nonFactEmpty = axis.isNonFactEmpty();
        evaluator.setNonFactEmpty(nonFactEmpty);
        Object value = calc.evaluate(evaluator);
        evaluator.setNonEmpty(false);
        evaluator.setNonFactEmpty(false);
        if (value == null) {
            value = Collections.EMPTY_LIST;
        }
        return (IList)value;
    }

    private IList executeSliceAxis(Evaluator evaluator, Calc calc) throws OlapException {
        IList positions = this.query.getListFactory().createArrayList();
        if (calc == null) {
            Member[] members = new Member[]{};
            positions.add((Object)members);
        } else {
            IList list;
            Object value = calc.evaluate(evaluator);
            if (value instanceof Member || value instanceof Member[]) {
                list = this.query.getListFactory().createArrayList();
                list.add(value);
                value = list;
            }
            list = (IList)value;
            Object o = list.getFirst();
            IList members = this.query.getListFactory().createArrayList();
            if (o != null) {
                if (o instanceof Object[]) {
                    Object[] a = (Object[])o;
                    HashMap<Hierarchy, IList> map = new HashMap<Hierarchy, IList>(3);
                    for (int j = 0; j < a.length; ++j) {
                        if (a[j] == null) continue;
                        Member tm = (Member)a[j];
                        members.add((Object)tm);
                        o = map.get(tm.getHierarchy());
                        if (o != null) {
                            ((IList)o).add((Object)tm);
                            continue;
                        }
                        IList l = this.query.getListFactory().createArrayList();
                        l.add((Object)tm);
                        map.put(tm.getHierarchy(), l);
                    }
                    if (map.size() != members.size()) {
                        for (Map.Entry entry : map.entrySet()) {
                            Hierarchy hier = (Hierarchy)entry.getKey();
                            IList memberList = (IList)entry.getValue();
                            if (memberList.size() == 1) {
                                members.add(memberList.get(0));
                                continue;
                            }
                            throw new OlapException("Slice only support one tuple.");
                        }
                    }
                } else {
                    members.add(o);
                }
            }
            positions.add((Object)((Member[])members.toArray((Object[])new Member[0])));
        }
        return positions;
    }

    private void executeBody(CellReader cellReader, EvaluatorImpl evaluator, MdxQuery query, Set cellCalculatedMemberSet, List<Member[]>[] filters) throws OlapException {
        this.cellValues.clear();
        this.executeStripe(1, (EvaluatorImpl)evaluator.push(), cellCalculatedMemberSet, filters);
        evaluator.clearExpResultCache(false);
    }

    private StripeResult executeStripe(int axis, EvaluatorImpl evaluator, Set cellCalculatedMemberSet, List<Member[]>[] filters) throws OlapException {
        boolean allNull;
        IList positions2;
        QueryAxis queryAxis;
        block25: {
            int checkSize;
            int count;
            int i;
            IList positions;
            boolean nonempty;
            block24: {
                if (axis < 0) {
                    Member[] context = null;
                    Member contextMeasure = evaluator.getCurrentMeasure();
                    Object o = null;
                    context = (Member[])evaluator.getCurrentMembers().clone();
                    o = evaluator.evaluateCurrent();
                    if (o != null && o != Util.nullValue && !(o instanceof Exception)) {
                        return new StripeResult(new CellImpl(context, contextMeasure, o, null), false);
                    }
                    return new StripeResult(null, false);
                }
                queryAxis = this.getAxis(axis);
                nonempty = queryAxis.isNonEmpty();
                positions = this.axisPositionList.get(queryAxis);
                positions2 = this.query.getListFactory().createArrayList();
                i = 0;
                allNull = true;
                count = 0;
                checkSize = 100;
                int axisIndex = this.getAxisIndex(axis);
                List<Member[]> _filter = null;
                if (filters != null && filters.length > axisIndex) {
                    _filter = filters[axisIndex];
                }
                if (_filter == null || _filter.isEmpty()) break block24;
                for (Member[] members : _filter) {
                    if (count % checkSize == 0) {
                        this.checkOutTime();
                    }
                    if (nonempty) {
                        boolean empty = false;
                        for (int j = 0; j < members.length; ++j) {
                            if (members[j].hasData() || members[j].maybeNeedCalc() || cellCalculatedMemberSet.contains(members[j])) continue;
                            empty = true;
                            break;
                        }
                        if (empty) continue;
                    }
                    evaluator.setContext(members);
                    StripeResult sr = this.executeStripe(axis - 1, evaluator, cellCalculatedMemberSet, filters);
                    if (axis == 1) {
                        if (sr.allNull && nonempty) continue;
                        this.point.ordinals[this.getAxisIndex((int)axis)] = ++i;
                    } else {
                        boolean nonfactempty = axis == 0 ? this.getAxis(1).isNonFactEmpty() : this.getAxis(0).isNonFactEmpty();
                        this.point.ordinals[this.getAxisIndex((int)axis)] = i++;
                        if (sr.cell != null) {
                            this.putCellValues(sr);
                            if (allNull) {
                                if (nonfactempty) {
                                    Member[] ms = sr.cell.getMemberContext();
                                    Member measureMember = ms[ms.length - 1];
                                    if (!measureMember.isCalculated()) {
                                        allNull = false;
                                    }
                                } else {
                                    allNull = false;
                                }
                            }
                        }
                    }
                    positions2.add((Object)members);
                    ++count;
                }
                break block25;
            }
            Iterator iter = positions.iterator();
            while (iter.hasNext()) {
                block27: {
                    Member[] members;
                    block29: {
                        StripeResult sr;
                        block28: {
                            block26: {
                                if (count % checkSize == 0) {
                                    this.checkOutTime();
                                }
                                members = this.toMemberArray(iter.next());
                                if (!nonempty) break block26;
                                boolean empty = false;
                                for (int j = 0; j < members.length; ++j) {
                                    if (members[j].hasData() || members[j].maybeNeedCalc() || cellCalculatedMemberSet.contains(members[j])) continue;
                                    empty = true;
                                    break;
                                }
                                if (empty) break block27;
                            }
                            evaluator.setContext(members);
                            sr = this.executeStripe(axis - 1, evaluator, cellCalculatedMemberSet, filters);
                            if (axis != 1) break block28;
                            if (sr.allNull && nonempty) break block27;
                            this.point.ordinals[this.getAxisIndex((int)axis)] = ++i;
                            break block29;
                        }
                        boolean nonfactempty = axis == 0 ? this.getAxis(1).isNonFactEmpty() : this.getAxis(0).isNonFactEmpty();
                        this.point.ordinals[this.getAxisIndex((int)axis)] = i++;
                        if (sr.cell != null) {
                            this.putCellValues(sr);
                            if (allNull) {
                                if (nonfactempty) {
                                    Member[] ms = sr.cell.getMemberContext();
                                    Member measureMember = ms[ms.length - 1];
                                    if (!measureMember.isCalculated()) {
                                        allNull = false;
                                    }
                                } else {
                                    allNull = false;
                                }
                            }
                        }
                    }
                    positions2.add((Object)members);
                }
                ++count;
            }
        }
        this.axisPositionList.put(queryAxis, positions2);
        return new StripeResult(null, allNull);
    }

    public void putCellValues(StripeResult sr) {
        if (sr.cell.getValue() instanceof BigDecimal) {
            BigDecimal value = (BigDecimal)sr.cell.getValue();
            if (value.compareTo(BigDecimal.ZERO) != 0) {
                CellKey key = this.point.copy();
                this.cellValues.put(key, (Cell)sr.cell);
            }
        } else {
            CellKey key = this.point.copy();
            this.cellValues.put(key, (Cell)sr.cell);
        }
    }

    public Cell getCell(int[] pos) {
        throw new OlapException("Not supported now, please use getCellIterator().");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("Cells:");
        Iterator iter = this.cellValues.cellIterator();
        while (iter.hasNext()) {
            Cell cell = (Cell)iter.next();
            str.append("\r\n");
            str.append(cell.toString());
        }
        return str.toString();
    }

    public Iterator<Cell> getCellIterator() {
        return this.cellValues.cellIterator();
    }

    private void checkOutTime() {
        long endTime = System.currentTimeMillis();
        ++this.timeCount;
        if (this.beginTime + (long)this.cn.getOutTime() < endTime) {
            throw new OlapException("calc out time.(timeCount=" + this.timeCount + "; outTime=" + this.cn.getOutTime() + "ms)");
        }
    }

    private static class StripeResult {
        CellImpl cell;
        boolean allNull;

        public StripeResult(CellImpl cell, boolean allNull) {
            this.cell = cell;
            this.allNull = allNull;
        }
    }
}

