/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.adjuest;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.JSONUtils;
import kd.epm.eb.business.servicehelper.EbBatchSave;
import kd.epm.eb.business.servicehelper.EbOlapServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.ProjectOperationEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.EntityUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.impl.model.BudgetBalance;
import kd.epm.eb.control.impl.model.ControlParam;
import kd.epm.eb.control.utils.BgRegisterUtils;
import kd.epm.eb.ebBusiness.serviceHelper.DimensionServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;
import kd.epm.eb.olap.OlapServiceCaller;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.impl.utils.KDOlapRequestUtils;
import kd.epm.eb.olap.service.view.ViewMemberManager;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;
import kd.epm.eb.service.adjuest.IAdjustExternalInvokeService;

public class AdjustExternalInvokeServiceImpl
implements IAdjustExternalInvokeService {
    public static final String CONTROL_VERSION_CACHE = "CONTROL_VERSION_CACHE";
    public static final String KEY_BUDGET = "budget";
    public static final String KEY_ADJUST = "adjust";
    public static final String FINALBUDGET = "finaladjust";
    public static final String RESTOREDATA = "restoreData";
    private kd.epm.eb.common.model.Member parentMem;
    private Dimension exitDimension;
    private Long exitDimmemId;
    private static final Log log = LogFactory.getLog(AdjustExternalInvokeServiceImpl.class);

    public String adjustAudio(DynamicObject dynamicObject, Map<String, Object> dimmember) {
        this.verify(dimmember);
        this.saveDataToLogTable(dynamicObject, dimmember);
        log.info("adjustAudio : dynamicobect" + dynamicObject.toString());
        log.info("adjustAudio : dimmember" + dimmember);
        return this.AddOlapDimension_new(dynamicObject, dimmember);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String adjust(DynamicObject dynamicObject, Map<String, Object> dimmember) {
        log.info("dynamicobect" + dynamicObject.toString());
        log.info("dimmember" + dimmember);
        try {
            this.chenckAdjustfiled(dimmember);
            Collection<IControlParam> iControlParams = this.queryOlapData(dynamicObject, dimmember);
            BizModel model = ((IBudgetBalance)iControlParams.toArray()[0]).getBizModel();
            HashMap<String, Map<String, kd.epm.eb.common.model.Member>> numberAndDimemberId = new HashMap<String, Map<String, kd.epm.eb.common.model.Member>>(16);
            LinkedList<Dimension> defDimension = new LinkedList<Dimension>();
            Map<String, Map<String, String>> adjustMap = this.getAdjustMap(iControlParams, model, dimmember, numberAndDimemberId, defDimension);
            DLock lock = DLock.create((String)"eb/AdjustIAdjustExternal");
            try {
                String returnData;
                if (!lock.tryLock(5000L)) {
                    throw new KDBizException(AdjustExternalInvokeServiceImpl.getLockErrorMessage("AdjustExternalInvokeServiceImpl/control"));
                }
                Collection<IBudgetBalance> newBalances = this.getNewBalances(adjustMap, model);
                this.putBudgetToAdjustList(adjustMap, newBalances);
                this.checkBalance(adjustMap);
                this.removeAdjustIdZeroValue(adjustMap);
                this.createAdjustBillByAdjustMap(adjustMap, dynamicObject, numberAndDimemberId, model, defDimension);
                List<Map<String, String>> adjustList = this.removeMapOtherDataAndGetList(adjustMap, false);
                this.saveOlapData(adjustList, model.getId(), model.getCubeNumber());
                String string = returnData = this.getReturnData(adjustList);
                return string;
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                lock.unlock();
            }
        }
        catch (Exception ex) {
            log.error("adjust-error", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    public String creatMem(Map<String, Object> MemberMessage) {
        try {
            this.checkMemberMessage(MemberMessage);
            BizModel bizModel = CommonUtils.getModel((String)MemberMessage.get("modelNumber").toString());
            this.checkDim(MemberMessage, bizModel);
            DynamicObject parentMessage = this.getParentMessage(MemberMessage, bizModel);
            Map<String, Object> dimmemberMap = this.putMessageToDimmemberMap(MemberMessage, bizModel);
            this.createMemByAdjust(MemberMessage, dimmemberMap, bizModel, parentMessage);
            return "success";
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    private Map<String, Object> putMessageToDimmemberMap(Map<String, Object> memberMessage, BizModel bizModel) {
        HashMap<String, Object> dimmember = new HashMap<String, Object>(16);
        String dimNumber = memberMessage.get("dimNumber").toString();
        kd.epm.eb.common.model.Dimension dimension = bizModel.getDimension(dimNumber);
        dimmember.put("dimId", dimension.getId());
        dimmember.put("dimNum", dimension.getNumber());
        return dimmember;
    }

    private void createMemByAdjust(Map<String, Object> memberMessage, Map<String, Object> dimmemberMap, BizModel bizModel, DynamicObject parentMessage) {
        DynamicObject object = null;
        String dimMemNumber = memberMessage.get("dimMemNumber").toString();
        String dimMemName = memberMessage.get("dimMemName").toString();
        DLock lock = DLock.create((String)"eb/AdjustcreateMemByAdjust");
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (!lock.tryLock(5000L)) {
                    throw new KDBizException(AdjustExternalInvokeServiceImpl.getLockErrorMessage("AdjustExternalInvokeServiceImpl/control"));
                }
                if (this.isExitModel(bizModel)) {
                    object = this.createMemberToBcm(dimMemNumber, dimMemName, dimmemberMap, parentMessage, bizModel);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
            finally {
                lock.unlock();
            }
        }
        Long id = object == null ? DBServiceHelper.genGlobalLongId() : object.getLong("id");
        String dimNumber = dimmemberMap.get("dimNum").toString();
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)bizModel.getId());
        Model modelobj = orCreate.getModelobj();
        ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((Model)modelobj);
        Member member = new Member();
        member.setNumber(dimMemNumber);
        ArrayList<Member> members = new ArrayList<Member>(8);
        members.add(member);
        DynamicObject model_d = CommonUtils.getModel_d((String)bizModel.getNumber());
        List datasets = DatasetServiceHelper.getDatasets((DynamicObject)model_d, (String)SysDimensionEnum.Entity.getNumber());
        ShrekOlapServiceHelper.addCubeMembers((Model)modelobj, (List)datasets, (String)dimNumber, members, (ShrekConfig)config);
        this.createMemberToEb(id, dimMemNumber, dimMemName, dimmemberMap, parentMessage, bizModel, orCreate);
    }

    private boolean isExitModel(BizModel bizModel) {
        return QueryServiceHelper.exists((String)"bcm_model", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizModel.getId())});
    }

    private DynamicObject getParentMessage(Map<String, Object> memberMessage, BizModel bizModel) {
        Object parentNumber = memberMessage.get("parentNumber");
        String dimNumber = memberMessage.get("dimNumber").toString();
        kd.epm.eb.common.model.Dimension dimension = bizModel.getDimension(dimNumber);
        if (parentNumber == null) {
            this.parentMem = CommonUtils.getMemberByNumber((kd.epm.eb.common.model.Dimension)dimension, (long)bizModel.getId(), (String)dimNumber);
            if (this.parentMem == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u76f8\u5e94\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"AdjustExternalInvokeServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
        } else {
            this.parentMem = CommonUtils.getMemberByNumber((kd.epm.eb.common.model.Dimension)dimension, (long)bizModel.getId(), (String)parentNumber.toString());
            if (this.parentMem == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7236\u8282\u70b9\u5728\u7ef4\u5ea6\u6210\u5458\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"AdjustExternalInvokeServiceImpl_1", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
            HashSet<Long> memberIds = new HashSet<Long>(16);
            memberIds.add(this.parentMem.getId());
            OlapServiceCaller olapServiceCaller = new OlapServiceCaller();
            if (this.parentMem.isLeaf() && olapServiceCaller.existData(bizModel.getId(), dimNumber, memberIds)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7236\u8282\u70b9\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u80fd\u521b\u5efa\u4e0b\u7ea7\u3002", (String)"AdjustExternalInvokeServiceImpl_2", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
        }
        return this.getParentDyn(bizModel, dimension);
    }

    private DynamicObject getParentDyn(BizModel bizModel, kd.epm.eb.common.model.Dimension dimension) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)bizModel.getId());
        qf.add("id", "=", (Object)this.parentMem.getId());
        return BusinessDataServiceHelper.loadSingle((String)"epm_userdefinedmembertree", (String)"id,number,longnumber,isleaf,level", (QFilter[])qf.toArray());
    }

    private void checkDim(Map<String, Object> memberMessage, BizModel bizModel) {
        String dimNumber;
        List allDimNumber = CommonUtils.getAllDimNumber((Long)bizModel.getId());
        if (!allDimNumber.contains(dimNumber = memberMessage.get("dimNumber").toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7ef4\u5ea6\u7f16\u7801\u5728\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustExternalInvokeServiceImpl_3", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
    }

    private void checkMemberMessage(Map<String, Object> memberMessage) {
        if (memberMessage == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684map\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"AdjustExternalInvokeServiceImpl_4", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (memberMessage.get("modelNumber") != null && StringUtils.isEmpty((String)memberMessage.get("modelNumber").toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4f53\u7cfb\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"AdjustExternalInvokeServiceImpl_5", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (memberMessage.get("dimNumber") != null && StringUtils.isEmpty((String)memberMessage.get("dimNumber").toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7ef4\u5ea6\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"AdjustExternalInvokeServiceImpl_6", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (memberMessage.get("dimMemNumber") != null && StringUtils.isEmpty((String)memberMessage.get("dimMemNumber").toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"AdjustExternalInvokeServiceImpl_7", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (memberMessage.get("dimMemName") != null && StringUtils.isEmpty((String)memberMessage.get("dimMemName").toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7ef4\u5ea6\u6210\u5458\u540d\u79f0\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"AdjustExternalInvokeServiceImpl_8", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
    }

    private String getReturnData(List<Map<String, String>> adjustList) {
        try {
            String data = JSONUtils.toString(adjustList);
            return data;
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private List<Map<String, String>> removeMapOtherDataAndGetList(Map<String, Map<String, String>> adjustMap, boolean b) {
        ArrayList<Map<String, String>> adjustList = new ArrayList<Map<String, String>>(16);
        for (Map.Entry<String, Map<String, String>> map : adjustMap.entrySet()) {
            map.getValue().remove(KEY_BUDGET);
            map.getValue().remove(KEY_ADJUST);
            map.getValue().remove("balance");
            String removeValue = map.getValue().remove(FINALBUDGET);
            map.getValue().put(FacTabFieldDefEnum.FIELD_MONEY.getField(), removeValue);
            adjustList.add(map.getValue());
        }
        return adjustList;
    }

    private void createAdjustBillByAdjustMap(Map<String, Map<String, String>> adjustMap, DynamicObject dynamicObject, Map<String, Map<String, kd.epm.eb.common.model.Member>> numberAndDimemberIdMap, BizModel model, LinkedList<Dimension> defDimension) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                String codeRuleNumber = this.getCodeRuleNumber("eb_adjustbill", null);
                Long userId = UserUtils.getUserId();
                DynamicObject adjpstbillDoc = BusinessDataServiceHelper.newDynamicObject((String)"eb_adjustbill");
                long adjpstId = GlobalIdUtil.genGlobalLongId();
                adjpstbillDoc.set("billno", (Object)codeRuleNumber);
                adjpstbillDoc.set("billstatus", (Object)"E");
                adjpstbillDoc.set("applier", (Object)userId);
                adjpstbillDoc.set("applydate", (Object)TimeServiceHelper.now());
                adjpstbillDoc.set("billtype", (Object)"1");
                String entityName = this.getEntityName(dynamicObject);
                String number = this.getbillNumber(dynamicObject);
                adjpstbillDoc.set("adjustreason", (Object)ResManager.loadResFormat((String)"\u201c%1\u201d\u8c03\u6574\u5355,\u7f16\u7801\u4e3a\u201c%2\u201d\u3002", (String)"AdjustExternalInvokeServiceImpl_9", (String)"epm-eb-mservice", (Object[])new Object[]{entityName, number}));
                this.setUserMessage(adjpstbillDoc, userId);
                DynamicObjectCollection multperiod = adjpstbillDoc.getDynamicObjectCollection("multperiod");
                Map<String, String> entryHand = adjustMap.get(adjustMap.keySet().toArray()[0]);
                adjpstbillDoc.set("model", (Object)model.getId());
                adjpstbillDoc.set("datatype", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.DataType.getNumber()).get(entryHand.get(SysDimensionEnum.DataType.getNumber())).getId());
                adjpstbillDoc.set("version", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Version.getNumber()).get(entryHand.get(SysDimensionEnum.Version.getNumber())).getId());
                adjpstbillDoc.set("year", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Year.getNumber()).get(entryHand.get(SysDimensionEnum.Year.getNumber())).getId());
                adjpstbillDoc.set("changetype", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.ChangeType.getNumber()).get(entryHand.get(SysDimensionEnum.ChangeType.getNumber())).getId());
                adjpstbillDoc.set("currency", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Currency.getNumber()).get(entryHand.get(SysDimensionEnum.Currency.getNumber())).getId());
                adjpstbillDoc.set("id", (Object)adjpstId);
                ArrayList<String> isExitNumber = new ArrayList<String>(16);
                HashMap<String, String> isExitkey = new HashMap<String, String>(16);
                DynamicObjectCollection adjdetailentity = adjpstbillDoc.getDynamicObjectCollection("adjdetailentity");
                int i = 0;
                for (Map.Entry<String, Map<String, String>> map : adjustMap.entrySet()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    DynamicObject doc = adjdetailentity.addNew();
                    Map<String, String> entry = map.getValue();
                    doc.set("seq", (Object)(i + 1));
                    kd.epm.eb.common.model.Member member_entity = numberAndDimemberIdMap.get(SysDimensionEnum.Entity.getNumber()).get(entry.get(SysDimensionEnum.Entity.getNumber()));
                    kd.epm.eb.common.model.Member member_account = numberAndDimemberIdMap.get(SysDimensionEnum.Account.getNumber()).get(entry.get(SysDimensionEnum.Account.getNumber()));
                    doc.set("entity", (Object)member_entity.getId());
                    stringBuilder.append(member_entity.getNumber()).append("!");
                    doc.set("account", (Object)member_account.getId());
                    stringBuilder.append(member_account.getNumber()).append("!");
                    for (int j = 0; j < defDimension.size(); ++j) {
                        kd.epm.eb.common.model.Member member_def = numberAndDimemberIdMap.get(defDimension.get(j).getNumber()).get(entry.get(defDimension.get(j).getNumber()));
                        doc.set("customdim" + (j + 1), (Object)member_def.getId());
                        stringBuilder.append(member_def.getNumber()).append("!");
                    }
                    kd.epm.eb.common.model.Member member_period = numberAndDimemberIdMap.get(SysDimensionEnum.Period.getNumber()).get(entry.get(SysDimensionEnum.Period.getNumber()));
                    String value = (String)isExitkey.get(stringBuilder.toString());
                    if (value == null) {
                        value = i + "";
                    }
                    if (!isExitNumber.contains(member_period.getId().toString())) {
                        DynamicObject periodDoc = multperiod.addNew();
                        periodDoc.set("fbasedataid", (Object)member_period.getId());
                        doc.set("ordersign", (Object)(value + ":" + (isExitNumber.size() + 1)));
                        isExitNumber.add(member_period.getId().toString());
                    }
                    if (!isExitkey.containsKey(stringBuilder.toString())) {
                        isExitkey.put(stringBuilder.toString(), i + "");
                    }
                    doc.set("period", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Period.getNumber()).get(entry.get(SysDimensionEnum.Period.getNumber())).getId());
                    doc.set("budgetdata", (Object)new BigDecimal(entry.get(KEY_BUDGET)));
                    doc.set("adjustdata", (Object)entry.get(KEY_ADJUST));
                    if (entry.get(KEY_ADJUST).equals("0")) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u6574\u6570\u4e3a\u96f6\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AdjustExternalInvokeServiceImpl_10", (String)"epm-eb-mservice", (Object[])new Object[0]));
                    }
                    doc.set("finaldata", (Object)entry.get(FINALBUDGET));
                    ++i;
                }
                Object[] nones = new Object[]{adjpstbillDoc};
                BusinessDataWriter.save((IDataEntityType)adjpstbillDoc.getDynamicObjectType(), (Object[])nones);
            }
            catch (Exception e) {
                tx.markRollback();
                log.error("createAdjustBill_new", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private String getbillNumber(DynamicObject dynamicObject) {
        IDataEntityProperty number_p = (IDataEntityProperty)dynamicObject.getDynamicObjectType().getProperties().get((Object)"number");
        IDataEntityProperty billno_p = (IDataEntityProperty)dynamicObject.getDynamicObjectType().getProperties().get((Object)"billno");
        if (number_p != null) {
            String number = dynamicObject.getString("number");
            return number;
        }
        if (billno_p != null) {
            String billno = dynamicObject.getString("billno");
            return billno;
        }
        return "";
    }

    private String getEntityName(DynamicObject dynamicObject) {
        DynamicObject entitys = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dynamicObject.getDataEntityType().getExtendName())});
        String name = "";
        if (entitys != null && (name = entitys.getString("name")) != null && !name.isEmpty()) {
            return name;
        }
        return name;
    }

    private void removeAdjustIdZeroValue(Map<String, Map<String, String>> adjustMap) {
        ArrayList<String> removeKey = new ArrayList<String>(16);
        for (Map.Entry<String, Map<String, String>> mapEntry : adjustMap.entrySet()) {
            Map<String, String> value = mapEntry.getValue();
            String adjust = value.get(KEY_ADJUST);
            BigDecimal bigDecimal_adjust = new BigDecimal(adjust);
            if (bigDecimal_adjust.compareTo(BigDecimal.ZERO) != 0) continue;
            removeKey.add(mapEntry.getKey());
        }
        for (String key : removeKey) {
            adjustMap.remove(key);
        }
    }

    private void checkBalance(Map<String, Map<String, String>> adjustMap) {
        for (Map.Entry<String, Map<String, String>> mapEntry : adjustMap.entrySet()) {
            Map<String, String> value = mapEntry.getValue();
            String adjust = value.get(KEY_ADJUST);
            String balance = value.get("balance");
            String budget = value.get(KEY_BUDGET);
            BigDecimal bigDecimal_adjust = new BigDecimal(adjust);
            BigDecimal bigDecimal_balance = new BigDecimal(balance);
            BigDecimal bigDecimal_budget = new BigDecimal(budget);
            if (bigDecimal_adjust.compareTo(BigDecimal.ZERO) < 0 && bigDecimal_balance.add(bigDecimal_adjust).compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(ResManager.loadResFormat((String)"%1\u7684\u9884\u7b97\u4f59\u989d\u4e0d\u8db3\u3002", (String)"AdjustExternalInvokeServiceImpl_11", (String)"epm-eb-mservice", (Object[])new Object[]{mapEntry.getKey()}));
            }
            value.put(FINALBUDGET, bigDecimal_budget.add(bigDecimal_adjust).toPlainString());
        }
    }

    private void putBudgetToAdjustList(Map<String, Map<String, String>> adjustMap, Collection<IBudgetBalance> newBalances) {
        for (IBudgetBalance iBudgetBalance : newBalances) {
            Map budget_member = (Map)((ControlParam)iBudgetBalance).get("BUDGET_MEMBER");
            for (Map.Entry<String, Map<String, String>> mapEntry : adjustMap.entrySet()) {
                boolean isExit = true;
                String key = mapEntry.getKey();
                for (Map.Entry map : budget_member.entrySet()) {
                    kd.epm.eb.common.model.Member member = (kd.epm.eb.common.model.Member)map.getValue();
                    if (member == null) {
                        isExit = false;
                        break;
                    }
                    if (key.contains(member.getNumber())) continue;
                    isExit = false;
                    break;
                }
                if (!isExit) continue;
                BigDecimal budget = iBudgetBalance.getBudget();
                if (budget == null) {
                    mapEntry.getValue().put(KEY_BUDGET, BigDecimal.ZERO.toPlainString());
                } else {
                    mapEntry.getValue().put(KEY_BUDGET, budget.toPlainString());
                }
                BigDecimal balance = iBudgetBalance.getBalance();
                if (balance == null) {
                    mapEntry.getValue().put("balance", BigDecimal.ZERO.toPlainString());
                    continue;
                }
                mapEntry.getValue().put("balance", balance.toPlainString());
            }
        }
        log.info(KEY_ADJUST + adjustMap.toString());
    }

    protected Collection<IBudgetBalance> getNewBalances(Map<String, Map<String, String>> dimMap, BizModel model) {
        ArrayList<String> types = new ArrayList<String>();
        ArrayList adjustList = new ArrayList(16);
        for (Map.Entry<String, Map<String, String>> mapEntry : dimMap.entrySet()) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.putAll(mapEntry.getValue());
            map.remove(KEY_ADJUST);
            adjustList.add(map);
        }
        BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
        types.add(BgControlSettingTypeEnum.MONTH.getNumber());
        return bgControlCaller.queryBalance(model.getId(), adjustList, types, false);
    }

    private Map<String, Map<String, String>> getAdjustMap(Collection<IControlParam> iControlParams, BizModel model, Map<String, Object> dimmember, Map<String, Map<String, kd.epm.eb.common.model.Member>> numberAndDimemberId, LinkedList<Dimension> defDimension) {
        try {
            HashMap<String, Map<String, String>> dimMap = new HashMap<String, Map<String, String>>(16);
            List<Dimension> dimensions = this.getDimension(model, defDimension);
            Map<String, String> defNumber = this.getDefNumber(defDimension);
            this.queryAllDimmems(dimensions, true, numberAndDimemberId);
            for (IControlParam iControlParam : iControlParams) {
                StringBuilder budgetKey = new StringBuilder(model.getId().toString());
                Map budget_member = (Map)((BudgetBalance)iControlParam).get("BUDGET_MEMBER");
                HashMap<String, String> memberMap = new HashMap<String, String>(16);
                memberMap.put(KEY_ADJUST, iControlParam.getPropValueMap().get(dimmember.get("filed")).toString());
                for (Map.Entry mapEntry : budget_member.entrySet()) {
                    String dimNumber = (String)mapEntry.getKey();
                    String memNumber = ((kd.epm.eb.common.model.Member)mapEntry.getValue()).getNumber();
                    Map<String, kd.epm.eb.common.model.Member> leafMem = numberAndDimemberId.get(dimNumber);
                    memberMap.put(dimNumber, memNumber);
                    if (defNumber.containsKey(dimNumber)) {
                        if (!leafMem.containsKey(memNumber)) {
                            kd.epm.eb.common.model.Member member = leafMem.get(memNumber);
                            if (member != null) {
                                memNumber = member.getDimension().getShortNumber() + "None";
                                memberMap.put(dimNumber, memNumber);
                            } else {
                                memNumber = defNumber.get(dimNumber);
                                memberMap.put(dimNumber, memNumber);
                            }
                        }
                    } else {
                        if (!leafMem.containsKey(memNumber) && !dimNumber.equals(SysDimensionEnum.AuditTrail.getNumber())) {
                            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e0d\u5b58\u5728\u6216\u8005\u8be5\u7ef4\u5ea6\u6210\u5458\u4e0d\u662f\u660e\u7ec6\u8282\u70b9%2", (String)"AdjustExternalInvokeServiceImpl_12", (String)"epm-eb-mservice", (Object[])new Object[]{dimNumber, memNumber}));
                        }
                        if (((String)mapEntry.getKey()).equals(SysDimensionEnum.AuditTrail.getNumber())) {
                            memNumber = "EntityInput";
                            memberMap.put((String)mapEntry.getKey(), memNumber);
                        }
                    }
                    budgetKey.append("!").append(dimNumber).append("_").append(memNumber);
                }
                String budget = budgetKey.toString();
                if (dimMap.containsKey(budget)) {
                    Map map = (Map)dimMap.get(budget);
                    String adjust_old = (String)map.get(KEY_ADJUST);
                    String adjust = (String)memberMap.get(KEY_ADJUST);
                    BigDecimal bigDecimal = new BigDecimal(adjust);
                    BigDecimal bigDecimal_old = new BigDecimal(adjust_old);
                    bigDecimal = bigDecimal.add(bigDecimal_old);
                    memberMap.put(KEY_ADJUST, bigDecimal.toPlainString());
                }
                dimMap.put(budget, memberMap);
            }
            return dimMap;
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    private Map<String, String> getDefNumber(LinkedList<Dimension> defDimension) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (Dimension dimension : defDimension) {
            map.put(dimension.getNumber(), dimension.getShortNumber() + "None");
        }
        return map;
    }

    private Map<String, Map<String, kd.epm.eb.common.model.Member>> queryAllDimmems(List<Dimension> dimensions, boolean isleaf, Map<String, Map<String, kd.epm.eb.common.model.Member>> numberAndDimemberId) {
        for (Dimension dimension : dimensions) {
            String selectFiled = "id,name,number,parent.number,parent.id,parent.name,isleaf";
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("dimension", "=", (Object)dimension.getId());
            if (isleaf) {
                qfBuilder.add("isleaf", "=", (Object)isleaf);
            }
            DataSet result = QueryServiceHelper.queryDataSet((String)"epm", (String)dimension.getMemberModel(), (String)selectFiled, (QFilter[])qfBuilder.toArrays(), (String)"level");
            Iterator rows = result.iterator();
            HashMap<String, kd.epm.eb.common.model.Member> map = new HashMap<String, kd.epm.eb.common.model.Member>(16);
            while (rows.hasNext()) {
                Row memberRow = (Row)rows.next();
                kd.epm.eb.common.model.Member member = new kd.epm.eb.common.model.Member(memberRow.getLong("id"), memberRow.getString("name"), memberRow.getString("number"));
                member.setLeaf(memberRow.getBoolean("isleaf").booleanValue());
                map.put(memberRow.getString("number"), member);
            }
            numberAndDimemberId.put(dimension.getNumber(), map);
        }
        return numberAndDimemberId;
    }

    private Collection<IControlParam> queryOlapData(DynamicObject dynamicObject, Map<String, Object> dimmember) {
        try {
            ArrayList<Map> tmpColls = new ArrayList<Map>(16);
            BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
            Set<String> appilyValue = this.getAppilyValue(dimmember);
            Collection iBudgetBalances = bgControlCaller.queryDimensionMemberBySetFiled(dynamicObject, appilyValue);
            for (IBudgetBalance balance : iBudgetBalances) {
                tmpColls.add(balance.toMap());
            }
            log.info("begin" + JSONUtils.toString(tmpColls));
            return iBudgetBalances;
        }
        catch (IOException e) {
            log.error("queryOlapData", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private Set<String> getAppilyValue(Map<String, Object> dimmember) {
        HashSet<String> appilyFiled = new HashSet<String>(16);
        appilyFiled.add(dimmember.get("filed").toString());
        return appilyFiled;
    }

    private void chenckAdjustfiled(Map<String, Object> dimmember) {
        if (dimmember == null || dimmember.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684map\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"AdjustExternalInvokeServiceImpl_14", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (dimmember.get("filed") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684map\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"AdjustExternalInvokeServiceImpl_14", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
    }

    private void saveDataToLogTable(DynamicObject dynamicObject, Map<String, Object> dimmember) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                DynamicObject doc = BusinessDataServiceHelper.newDynamicObject((String)"eb_adjustimpllog");
                DynamicObject kind = (DynamicObject)dimmember.get("proRootKind");
                doc.set("dyn", (Object)dynamicObject.toString());
                doc.set("userfield", dimmember.get("userId"));
                doc.set("newdimmemnumber", dimmember.get("new_dimmemNumber"));
                doc.set("newdimmemname", dimmember.get("new_dimmemName"));
                doc.set("entrytityname", dimmember.get("entrytityName"));
                doc.set("budgetmoney", dimmember.get("budgetMoney"));
                doc.set("budgetitem", dimmember.get("budgetitem"));
                doc.set("restoredata", dimmember.get(RESTOREDATA));
                doc.set("usetime", (Object)TimeServiceHelper.now());
                if (doc.getString("newdimmemnumber").length() > 50 || doc.getString("newdimmemname").length() > 50) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u6700\u5927\u957f\u5ea6\u4e3a50\u3002", (String)"AdjustExternalInvokeServiceImpl_73", (String)"epm-eb-mservice", (Object[])new Object[0]));
                }
                if (kind != null && !kind.getString("number").isEmpty() && !kind.getString("name").isEmpty()) {
                    if (kind.getString("number").length() > 50 || kind.getString("name").length() > 50) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u6700\u5927\u957f\u5ea6\u4e3a50\u3002", (String)"AdjustExternalInvokeServiceImpl_73", (String)"epm-eb-mservice", (Object[])new Object[0]));
                    }
                    doc.set("parentnumber", kind.get("number"));
                    doc.set("parentname", kind.get("name"));
                }
                doc.set("olddimmemberid", (Object)dynamicObject.getString("billno"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{doc});
            }
            catch (Exception ex) {
                tx.markRollback();
                log.error("AdjustExternalInvokeServiceImpl", (Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    private void verify(Map<String, Object> dimmember) {
        if (dimmember == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684map\u4e3anull\u3002", (String)"AdjustExternalInvokeServiceImpl_18", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (dimmember.get("new_dimmemNumber") == null || dimmember.get("new_dimmemNumber").toString().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65b0\u7684\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"AdjustExternalInvokeServiceImpl_19", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (dimmember.get("new_dimmemName") == null || dimmember.get("new_dimmemName").toString().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u65b0\u7684\u7ef4\u5ea6\u6210\u5458\u540d\u5b57\u4e3a\u7a7a\u3002", (String)"AdjustExternalInvokeServiceImpl_20", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (dimmember.get("userId") == null || dimmember.get("userId").toString().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7528\u6237id\u4e3a\u7a7a\u3002", (String)"AdjustExternalInvokeServiceImpl_21", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (dimmember.get("entrytityName") == null || dimmember.get("entrytityName").toString().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u5355\u636e\u4f53\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"AdjustExternalInvokeServiceImpl_22", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (dimmember.get("budgetMoney") == null || dimmember.get("budgetMoney").toString().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u8c03\u5242\u91d1\u989d\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"AdjustExternalInvokeServiceImpl_23", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (dimmember.get("budgetitem") == null || dimmember.get("budgetitem").toString().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u6807\u51c6\u9884\u7b97\u4e13\u9879\u4e3a\u7a7a\u3002", (String)"AdjustExternalInvokeServiceImpl_24", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (dimmember.get(RESTOREDATA) == null || dimmember.get(RESTOREDATA).toString().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u8c03\u5242\u6307\u4ee4\u4e3a\u7a7a\u3002", (String)"AdjustExternalInvokeServiceImpl_25", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
    }

    public ApiResult deleteAdjust(String billNumber) {
        if (billNumber == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u8c03\u5242\u5355\u7684\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a\u3002", (String)"AdjustExternalInvokeServiceImpl_31", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        try {
            int billno = DeleteServiceHelper.delete((String)"eb_adjpstbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNumber)});
            if (billno == 1) {
                String msg = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"AdjustExternalInvokeServiceImpl_32", (String)"epm-eb-mservice", (Object[])new Object[0]);
                return ApiResult.success((Object)msg);
            }
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u8c03\u5242\u5355\u7684\u5355\u636e\u7f16\u7801\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdjustExternalInvokeServiceImpl_33", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private String AddOlapDimension_new(DynamicObject dynamicObject, Map<String, Object> dimmember) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void queryDimensionInfo(DynamicObject dynamicObject, Map<String, Object> dimmember) {
        DynamicObjectCollection entrytityName = dynamicObject.getDynamicObjectCollection(dimmember.get("entrytityName").toString());
        if (entrytityName.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u68c0\u6d4b\u5230\u8c03\u7528\u9884\u7b97\u5206\u5f55\u5355\u636e\u4f53\u5185\u5bb9\u3002", (String)"AdjustExternalInvokeServiceImpl_43", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        String oldMemberId = ((DynamicObject)entrytityName.get(0)).getString(dimmember.get("proMemberIdKey").toString());
        QFBuilder qfBuilder = new QFBuilder("id", "=", (Object)IDUtils.toLong((Object)oldMemberId));
        DynamicObject member = QueryServiceHelper.queryOne((String)"epm_userdefinedmembertree", (String)"dimension", (QFilter[])qfBuilder.toArray());
        if (member == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7b97\u9879\u76eeid\u5bf9\u5e94\u7684\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"AdjustExternalInvokeServiceImpl_44", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        qfBuilder.clear();
        String dimId = member.getString("dimension");
        qfBuilder.add("id", "=", (Object)IDUtils.toLong((Object)member.getString("dimension")));
        DynamicObject dimension = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"number,name,shortnumber", (QFilter[])qfBuilder.toArray());
        if (dimension == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7b97\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"AdjustExternalInvokeServiceImpl_45", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        dimmember.put("dimId", dimId);
        dimmember.put("dimNum", dimension.getString("number"));
        dimmember.put("dimName", dimension.getString("name"));
        dimmember.put("dimeShortNum", dimension.getString("shortnumber"));
        DynamicObject proRootKind = (DynamicObject)dimmember.get("proRootKind");
        if (proRootKind == null || proRootKind.getString("number").isEmpty() || proRootKind.getString("name").isEmpty()) {
            dimmember.put("parentNum", dimmember.get("dimNum"));
            dimmember.put("parentName", dimmember.get("dimName"));
        } else {
            dimmember.put("parentNum", proRootKind.getString("number"));
            dimmember.put("parentName", proRootKind.getString("name"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<List<Map<String, String>>> compareMemberMap(Collection<IBudgetBalance> iBudgetBalances_new, Collection<IControlParam> iBudgetBalances, DynamicObject dynamicObject, Map<String, Object> dimmember, List<Map<String, String>> adjustList, BizModel model) {
        boolean isEb = model.isEBByModel();
        HashMap<String, String> accountMapper = new HashMap<String, String>(16);
        HashMap<String, String> entityMappper = new HashMap<String, String>(16);
        HashMap<String, String> bizNumAndName = new HashMap<String, String>(16);
        BigDecimal zero = BigDecimal.ZERO;
        String account = "Account";
        String entity = "Entity";
        for (IControlParam ic : iBudgetBalances) {
            kd.epm.eb.common.model.Member reqMember = ic.getReqMember(account);
            String reqNum = reqMember.getNumber();
            accountMapper.put(reqNum, ic.getAccount(true).getNumber());
            entityMappper.put(ic.getReqMember(entity).getNumber(), ic.getOrgUnit(true).getNumber());
            bizNumAndName.put(reqNum, reqMember.getName());
        }
        String proDimNum = dimmember.get("dimNum").toString();
        Map<String, String> commonDimData = this.getCommonDimMap(iBudgetBalances_new.iterator().next(), proDimNum, isEb);
        if (!isEb) {
            commonDimData.computeIfAbsent("Metric", v -> this.getDefauteMetric(dynamicObject, model));
        }
        String newMemberNum = dimmember.get("new_dimmemNumber").toString();
        String proEntityKey = dimmember.get("costOrgKey").toString() + ".number";
        String proAccountKey = dimmember.get("budgetitem").toString() + ".number";
        String proDimkey = dimmember.get("ebMemberNumKey").toString();
        HashMap groupObject = new HashMap(16);
        DynamicObjectCollection entrytityName = dynamicObject.getDynamicObjectCollection(dimmember.get("entrytityName").toString());
        List collect = entrytityName.stream().filter(d -> zero.compareTo(this.getBudgetMoney(d, dimmember)) != 0).collect(Collectors.toList());
        for (Object object : collect) {
            String string;
            ArrayList<Object> objects;
            String accountNum = (String)accountMapper.get(object.getString(proAccountKey));
            String entityNum = (String)entityMappper.get(object.getString(proEntityKey));
            if (accountNum == null || entityNum == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5b57\u6bb5\u4e0e\u9884\u7b97\u7ef4\u5ea6\u6210\u5458\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u9884\u7b97\u63a7\u5236\u914d\u7f6e\u3002", (String)"AdjustExternalInvokeServiceImpl_46", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
            String key = accountNum + entityNum + this.prasePeriods(isEb, (DynamicObject)object, dimmember);
            Map<String, ArrayList<Object>> listMap = (Map)groupObject.get(key);
            if (listMap == null) {
                listMap = new HashMap<String, ArrayList<Object>>(16);
                groupObject.put(key, listMap);
            }
            if ((objects = (ArrayList<Object>)listMap.get(string = object.getString(proDimkey))) == null) {
                objects = new ArrayList<Object>(10);
                listMap.put(string, objects);
            }
            objects.add(object);
        }
        HashMap<String, IBudgetBalance> groupBudget = new HashMap<String, IBudgetBalance>(16);
        for (IBudgetBalance iBudgetBalance : iBudgetBalances_new) {
            String key = this.getKey(iBudgetBalance, dimmember, isEb);
            groupBudget.put(key, iBudgetBalance);
        }
        ArrayList<List<Map<String, String>>> adjustDataList = new ArrayList<List<Map<String, String>>>(10);
        for (Map.Entry entry : groupObject.entrySet()) {
            ArrayList billList = new ArrayList(((Map)entry.getValue()).size());
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                void var32_40;
                BigDecimal balane;
                void var32_37;
                IBudgetBalance iBudgetBalance = (IBudgetBalance)groupBudget.get((String)entry.getKey() + (String)entry2.getKey());
                if (iBudgetBalance == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u9884\u7b97\u7ef4\u5ea6\u5339\u914d\u503c\uff0c\u8bf7\u68c0\u67e5\u63a7\u5236\u914d\u7f6e\u3002", (String)"AdjustExternalInvokeServiceImpl_47", (String)"epm-eb-mservice", (Object[])new Object[0]));
                }
                HashMap<String, String> mapRow = new HashMap<String, String>(commonDimData);
                mapRow.put(proDimNum, (String)entry2.getKey());
                mapRow.put("Account", iBudgetBalance.getAccount(true).getNumber());
                mapRow.put("Entity", iBudgetBalance.getOrgUnit(true).getNumber());
                if (isEb) {
                    mapRow.put("Year", iBudgetBalance.getMember(true, "Year").getNumber());
                    mapRow.put("Period", iBudgetBalance.getMember(true, "Period").getNumber());
                } else {
                    mapRow.put("BudgetPeriod", iBudgetBalance.getMember(true, "BudgetPeriod").getNumber());
                }
                BigDecimal bigDecimal = BigDecimal.ZERO;
                List value = (List)entry2.getValue();
                for (DynamicObject object : value) {
                    BigDecimal bigDecimal2 = var32_37.add(this.getBudgetMoney(object, dimmember));
                }
                if (zero.compareTo((BigDecimal)var32_37) == 0) continue;
                Object operate = dimmember.get(RESTOREDATA);
                if (ProjectOperationEnum.Auditee.getIndex().equals(operate) || ProjectOperationEnum.Close.getIndex().equals(operate)) {
                    BigDecimal bigDecimal3 = BigDecimal.ZERO.subtract((BigDecimal)var32_37);
                }
                BigDecimal bigDecimal4 = balane = iBudgetBalance.getBalance() == null ? BigDecimal.ZERO : iBudgetBalance.getBalance();
                if (balane.subtract((BigDecimal)var32_40).compareTo(BigDecimal.ZERO) < 0) {
                    String number = ((DynamicObject)value.get(0)).getString(proAccountKey);
                    log.info("\u4f59\u989d\u4e0d\u8db3\uff1a" + SerializationUtils.toJsonString(mapRow));
                    throw new KDBizException(ResManager.loadResFormat((String)"\u6807\u51c6\u9884\u7b97\u9879%1(%2)\u7684\u9884\u7b97\u4f59\u989d\u4e0d\u8db3", (String)"AdjustExternalInvokeServiceImpl_48", (String)"epm-eb-mservice", (Object[])new Object[]{bizNumAndName.get(number), number}));
                }
                BigDecimal budget = iBudgetBalance.getBudget() == null ? BigDecimal.ZERO : iBudgetBalance.getBudget();
                mapRow.put(KEY_BUDGET, budget.toPlainString());
                mapRow.put(KEY_ADJUST, BigDecimal.ZERO.subtract((BigDecimal)var32_40).toPlainString());
                budget = budget.subtract((BigDecimal)var32_40);
                mapRow.put(FINALBUDGET, budget.toPlainString());
                mapRow.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), budget.toPlainString());
                billList.add(mapRow);
            }
            if (billList.size() == 0) continue;
            HashMap<String, String> mapNew = new HashMap<String, String>((Map)billList.get(0));
            mapNew.put(proDimNum, newMemberNum);
            BigDecimal bigDecimal = BigDecimal.ZERO;
            mapNew.put(KEY_BUDGET, bigDecimal.toPlainString());
            BigDecimal adjustNew = BigDecimal.ZERO;
            for (Map map : billList) {
                adjustNew = adjustNew.add(new BigDecimal((String)map.get(KEY_ADJUST)));
            }
            if ((adjustNew = BigDecimal.ZERO.subtract(adjustNew)).compareTo(zero) == 0) continue;
            mapNew.put(KEY_ADJUST, adjustNew.toPlainString());
            mapNew.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), bigDecimal.add(adjustNew).toPlainString());
            mapNew.put(FINALBUDGET, adjustNew.toPlainString());
            billList.add(mapNew);
            adjustDataList.add(billList);
        }
        return adjustDataList;
    }

    private String getDefauteMetric(DynamicObject dynamicObject, BizModel model) {
        String entityNumber = EntityUtils.getEntityNumber((DynamicObject)dynamicObject);
        String[] props = BgRegisterUtils.queryRegisterBizUnit((String)entityNumber);
        if (props.length < 3) {
            ControlException.notDefaultBizProp((String)entityNumber);
        }
        String bizTimeProperty = props[1];
        Date date = dynamicObject.getDate(bizTimeProperty);
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)model.getId());
        qfBuilder.add("entryentity.subentryentity.bill.number", "=", (Object)entityNumber);
        qfBuilder.add("entryentity.subentryentity.effectivetime", "<=", (Object)date);
        QFilter qFilter = new QFilter("entryentity.subentryentity.invalidtime", "is null", null);
        qFilter.or(new QFilter("entryentity.subentryentity.invalidtime", ">", (Object)date));
        qfBuilder.add(qFilter);
        DynamicObject object = QueryServiceHelper.queryOne((String)"eb_dimmaterule", (String)"entryentity.subentryentity.metricfield.number", (QFilter[])qfBuilder.toArray());
        if (object == null || StringUtils.isEmpty((String)object.getString("entryentity.subentryentity.metricfield.number"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u9ed8\u8ba4\u5ea6\u91cf\u3002", (String)"AdjustExternalInvokeServiceImpl_50", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        return object.getString("entryentity.subentryentity.metricfield.number");
    }

    private void addDimensionInfo(List<List<Map<String, String>>> billLists, Map<String, String> accountNumAndBusModel, IModelCacheHelper modelContext) {
        for (List<Map<String, String>> billList : billLists) {
            for (Map<String, String> map : billList) {
                List dimensionList = modelContext.getDimensionList(Long.valueOf(Long.parseLong(accountNumAndBusModel.get(map.get("Account")))));
                for (Dimension d : dimensionList) {
                    map.computeIfAbsent(d.getNumber(), v -> d.getShortNumber() + "None");
                }
            }
        }
    }

    private Map<String, String> getCommonDimMap(IBudgetBalance balanceObject, String proDimNum, boolean isEb) {
        Map map = (Map)((BudgetBalance)balanceObject).get("BUDGET_MEMBER");
        Map<String, String> commonMap = map.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((kd.epm.eb.common.model.Member)e.getValue()).getNumber()));
        commonMap.remove(proDimNum);
        commonMap.remove("Account");
        commonMap.remove("Entity");
        if (isEb) {
            commonMap.remove("Year");
            commonMap.remove("Period");
        } else {
            commonMap.remove("BudgetPeriod");
        }
        return commonMap;
    }

    private DynamicObject createAdjusstBill(List<Map<String, String>> billList, Map<String, Map<String, String>> numberAndDimemberIdMap, List<Dimension> defDimension, Map<String, Object> dimmember, BizModel model, Map<String, String> accountNumAndBusModel, IModelCacheHelper modelContext) {
        String codeRuleNumber = this.getCodeRuleNumber("eb_adjpstbill", null);
        String userId = dimmember.get("userId").toString();
        DynamicObject adjpstbillDoc = null;
        adjpstbillDoc = model.isEBByModel() ? BusinessDataServiceHelper.newDynamicObject((String)"eb_adjpstbill") : BusinessDataServiceHelper.newDynamicObject((String)"bgm_adjpstbill");
        long adjpstId = GlobalIdUtil.genGlobalLongId();
        adjpstbillDoc.set("billno", (Object)codeRuleNumber);
        adjpstbillDoc.set("billstatus", (Object)"E");
        adjpstbillDoc.set("applier", (Object)userId);
        adjpstbillDoc.set("applydate", (Object)TimeServiceHelper.now());
        adjpstbillDoc.set("billtype", (Object)"2");
        String dimnumber = dimmember.get("new_dimmemNumber").toString();
        if (ProjectOperationEnum.Auditee.getIndex().equals(dimmember.get(RESTOREDATA))) {
            adjpstbillDoc.set("adjustreason", (Object)ResManager.loadResFormat((String)"\u7acb\u9879\u5355\u53cd\u5ba1\u6838\u8c03\u5242%1\u3002", (String)"AdjustExternalInvokeServiceImpl_51", (String)"epm-eb-mservice", (Object[])new Object[]{dimnumber}));
        } else if (ProjectOperationEnum.Close.getIndex().equals(dimmember.get(RESTOREDATA))) {
            adjpstbillDoc.set("adjustreason", (Object)ResManager.loadResFormat((String)"\u7acb\u9879\u5355\u5173\u95ed\u8c03\u5242%1\u3002", (String)"AdjustExternalInvokeServiceImpl_52", (String)"epm-eb-mservice", (Object[])new Object[]{dimnumber}));
        } else if (ProjectOperationEnum.Audit.getIndex().equals(dimmember.get(RESTOREDATA))) {
            adjpstbillDoc.set("adjustreason", (Object)ResManager.loadResFormat((String)"\u7acb\u9879\u5355\u5ba1\u6838\u8c03\u5242%1\u3002", (String)"AdjustExternalInvokeServiceImpl_53", (String)"epm-eb-mservice", (Object[])new Object[]{dimnumber}));
        } else if (ProjectOperationEnum.Closeable.getIndex().equals(dimmember.get(RESTOREDATA))) {
            adjpstbillDoc.set("adjustreason", (Object)ResManager.loadResFormat((String)"\u7acb\u9879\u5355\u53cd\u5173\u95ed\u8c03\u5242%1\u3002", (String)"AdjustExternalInvokeServiceImpl_54", (String)"epm-eb-mservice", (Object[])new Object[]{dimnumber}));
        }
        this.setUserMessage(adjpstbillDoc, Long.parseLong(userId));
        Map<String, String> adjpstDataMap = billList.get(0);
        if (model.isEBByModel()) {
            DynamicObjectCollection multperiod = adjpstbillDoc.getDynamicObjectCollection("multperiod");
            DynamicObject periodDoc = multperiod.addNew();
            periodDoc.set("fbasedataid", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Period.getNumber()).get(adjpstDataMap.get(SysDimensionEnum.Period.getNumber())));
            adjpstbillDoc.set("year", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Year.getNumber()).get(adjpstDataMap.get(SysDimensionEnum.Year.getNumber())));
        } else {
            adjpstbillDoc.set("dataset", (Object)accountNumAndBusModel.get(adjpstDataMap.get("Account")));
            adjpstbillDoc.set("bizmodel", (Object)model.getControlBusModelId());
            DynamicObjectCollection multiBudgetPeriod = adjpstbillDoc.getDynamicObjectCollection("budgetperiods");
            DynamicObject budgetPeriodDoc = multiBudgetPeriod.addNew();
            budgetPeriodDoc.set("fbasedataid", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.BudgetPeriod.getNumber()).get(adjpstDataMap.get(SysDimensionEnum.BudgetPeriod.getNumber())));
        }
        adjpstbillDoc.set("model", (Object)model.getId());
        adjpstbillDoc.set("datatype", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.DataType.getNumber()).get(adjpstDataMap.get(SysDimensionEnum.DataType.getNumber())));
        adjpstbillDoc.set("version", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Version.getNumber()).get(adjpstDataMap.get(SysDimensionEnum.Version.getNumber())));
        adjpstbillDoc.set("changetype", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.ChangeType.getNumber()).get(adjpstDataMap.get(SysDimensionEnum.ChangeType.getNumber())));
        adjpstbillDoc.set("currency", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Currency.getNumber()).get(adjpstDataMap.get(SysDimensionEnum.Currency.getNumber())));
        adjpstbillDoc.set("id", (Object)adjpstId);
        String entityId = numberAndDimemberIdMap.get(SysDimensionEnum.Entity.getNumber()).get(adjpstDataMap.get(SysDimensionEnum.Entity.getNumber()));
        String accountNum = adjpstDataMap.get(SysDimensionEnum.Account.getNumber());
        String accountId = numberAndDimemberIdMap.get(SysDimensionEnum.Account.getNumber()).get(accountNum);
        DynamicObjectCollection adjdetailentity = adjpstbillDoc.getDynamicObjectCollection("adjdetailentity");
        for (int i = 0; i < billList.size(); ++i) {
            Map<String, String> map = billList.get(i);
            DynamicObject doc = adjdetailentity.addNew();
            doc.set("seq", (Object)1);
            doc.set("entity", (Object)entityId);
            doc.set("account", (Object)accountId);
            if (model.isEBByModel()) {
                doc.set("period", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Period.getNumber()).get(map.get(SysDimensionEnum.Period.getNumber())));
            } else {
                doc.set("metric", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Metric.getNumber()).get(map.get(SysDimensionEnum.Metric.getNumber())));
                doc.set("budgetperiod", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.BudgetPeriod.getNumber()).get(map.get(SysDimensionEnum.BudgetPeriod.getNumber())));
                defDimension = modelContext.getDimensionList(Long.valueOf(Long.parseLong(accountNumAndBusModel.get(accountNum)))).stream().filter(d -> !d.isPreset()).collect(Collectors.toList());
            }
            defDimension.sort(this.getComparator());
            doc.set("groupnum", (Object)1);
            for (int j = 0; j < defDimension.size() && j < 6; ++j) {
                String defDimNum = defDimension.get(j).getNumber();
                doc.set("customdim" + (j + 1), (Object)numberAndDimemberIdMap.get(defDimNum).get(map.get(defDimNum)));
            }
            doc.set("budgetdata", (Object)map.get(KEY_BUDGET));
            doc.set("adjustdata", (Object)map.get(KEY_ADJUST));
            doc.set("finaldata", (Object)map.get(FINALBUDGET));
            if (BigDecimal.ZERO.compareTo(new BigDecimal(map.get(KEY_ADJUST))) == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u6574\u6570\u4e3a\u96f6\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AdjustExternalInvokeServiceImpl_10", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
            doc.set("ordersign", (Object)(i + ":" + 1));
        }
        return adjpstbillDoc;
    }

    private Comparator getComparator() {
        Comparator<Dimension> comparator = new Comparator<Dimension>(){

            @Override
            public int compare(Dimension o1, Dimension o2) {
                int seq = o1.getSeq() - o2.getSeq();
                if (seq > 0) {
                    return 1;
                }
                if (seq < 0) {
                    return -1;
                }
                return 0;
            }
        };
        return comparator;
    }

    private DynamicObject changeParentOrCreatParentNode(boolean isExit, Map<String, Object> dimmember, BizModel model) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)model.getId());
        qf.add("dimension", "=", (Object)IDUtils.toLong((Object)dimmember.get("dimId")));
        qf.add("number", "=", dimmember.get("parentNum"));
        DynamicObject parentDynamicObject = BusinessDataServiceHelper.loadSingle((String)"epm_userdefinedmembertree", (String)"id,number,longnumber,isleaf,level", (QFilter[])qf.toArrays());
        if (parentDynamicObject == null) {
            parentDynamicObject = this.createMember(dimmember.get("parentNum").toString(), dimmember.get("parentName").toString(), dimmember, model, null);
        }
        return parentDynamicObject;
    }

    private DynamicObject createMember(String dimmemNumber, String dimmemName, Map<String, Object> dimmember, BizModel model, DynamicObject parent) {
        String dimId = dimmember.get("dimId").toString();
        String dimNumber = dimmember.get("dimNum").toString();
        if (parent == null) {
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", (Object)model.getId());
            qf.add("dimension", "=", (Object)IDUtils.toLong((Object)dimId));
            qf.add("number", "=", (Object)dimNumber);
            parent = BusinessDataServiceHelper.loadSingle((String)"epm_userdefinedmembertree", (String)"id,number,longnumber,isleaf,level", (QFilter[])qf.toArray());
        }
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)model.getId());
        DynamicObject memberToEb = this.createMemberToEb(DBServiceHelper.genGlobalLongId(), dimmemNumber, dimmemName, dimmember, parent, model, orCreate);
        Model modelobj = orCreate.getModelobj();
        ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((Model)modelobj);
        Member member = new Member();
        member.setNumber(dimmemNumber);
        ArrayList<Member> members = new ArrayList<Member>(8);
        members.add(member);
        DynamicObject modelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)model.getId(), (String)"epm_model");
        List datasets = DatasetServiceHelper.getDatasets((DynamicObject)modelObj, (String)dimNumber);
        ShrekOlapServiceHelper.addCubeMembers((Model)modelobj, (List)datasets, (String)dimNumber, members, (ShrekConfig)config);
        return memberToEb;
    }

    private DynamicObject createMemberToEb(Long memberid, String memNum, String memName, Map<String, Object> dimmember, DynamicObject parent, BizModel model, IModelCacheHelper modelCache) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"epm_userdefinedmembertree");
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        Long dimensionId = IDUtils.toLong((Object)dimmember.get("dimId"));
        object.set("modifier", (Object)userId);
        object.set("modifytime", (Object)now);
        object.set("status", (Object)"C");
        object.set("creator", (Object)userId);
        object.set("createtime", (Object)now);
        object.set("enable", (Object)"1");
        object.set("membersource", (Object)"4");
        object.set("storagetype", (Object)"2");
        object.set("isleaf", (Object)"1");
        object.set("aggoprt", (Object)"1");
        object.set("id", (Object)memberid);
        object.set("number", (Object)memNum);
        object.set("shownumber", (Object)memNum);
        object.set("name", (Object)memName);
        object.set("parent", (Object)parent.getString("id"));
        object.set("model", (Object)model.getId());
        object.set("dimension", (Object)dimensionId);
        object.set("longnumber", (Object)(parent.getString("longnumber") + "!" + memNum));
        object.set("datatype", (Object)"0");
        object.set("level", (Object)(parent.getInt("level") + 1));
        object.set("dseq", (Object)DimensionServiceHelper.getDSeq((long)parent.getLong("id"), (String)"epm_userdefinedmembertree", (String)"AdjustExternalInvokeServiceImpl"));
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)model.getId());
        builder.add("dimension", "=", (Object)IDUtils.toLong((Object)dimensionId));
        builder.add("number", "=", (Object)memNum);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"epm_userdefinedmembertree", (String)"id,name,number,modifier,modifytime,creator,createtime", (QFilter[])builder.toArray());
        Boolean isAdd = Boolean.FALSE;
        if (dynamicObject == null) {
            isAdd = Boolean.TRUE;
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        } else {
            isAdd = Boolean.FALSE;
            memberid = dynamicObject.getLong("id");
            dynamicObject.set("name", (Object)memName);
            dynamicObject.set("number", (Object)memNum);
            dynamicObject.set("shownumber", (Object)memNum);
            dynamicObject.set("modifier", (Object)userId);
            dynamicObject.set("modifytime", (Object)now);
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        }
        Dimension dimension = modelCache.getDimension(dimensionId);
        if (dimension == null) {
            throw new KDBizException("error dimId");
        }
        Long viewId = dimension != null ? modelCache.getViewByBusModelAndDimNumber(model.getControlBusModelId(), dimension.getNumber()) : 0L;
        log.info("adjustAudio : saveMember" + memNum + "," + dimension.getNumber() + "parentId=" + parent.getString("id") + "parentNumber=" + parent.getString("number") + "," + isAdd + ",viewId=" + viewId);
        Member parentMember = modelCache.getMember(dimension.getNumber(), viewId, parent.getString("number"));
        DynamicObject dyna = BusinessDataServiceHelper.loadSingle((Object)memberid, (String)"epm_userdefinedmembertree");
        log.info("number=" + dyna.getString("number") + ",shownumber=" + dyna.getString("shownumber"));
        Long vid = parentMember != null ? ((ViewMember)parentMember).getVid() : 0L;
        DimensionViewMember dimensionViewMember = ViewMemberManager.getInstance().buildViewMemberByOldMember(dyna, viewId, IDUtils.isNotEmptyLong((Long)vid) != false ? vid : modelCache.getRootMember(dimension.getNumber(), viewId).getId(), isAdd);
        ViewMemberManager.getInstance().saveViewMemberOnly(dimensionViewMember.getModel().longValue(), dimension.getNumber(), viewId, dimensionViewMember);
        log.info("load from epm_userdefinedmembertree where id=" + parent.get("id"));
        DynamicObject object1 = BusinessDataServiceHelper.loadSingle((String)"epm_userdefinedmembertree", (String)"id,isleaf", (QFilter[])new QFilter("id", "=", parent.get("id")).toArray());
        if (object1 != null && object1.getBoolean("isleaf")) {
            object1.set("isleaf", (Object)"0");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object1});
        }
        return object;
    }

    private DynamicObject createMemberToBcm(String memNum, String memName, Map<String, Object> dimmember, DynamicObject parent, BizModel model) {
        if (!model.isEBByModel()) {
            return null;
        }
        String dimId = dimmember.get("dimId").toString();
        String dimNumber = dimmember.get("dimNum").toString();
        Long memberId = DBServiceHelper.genGlobalLongId();
        DynamicObject none = BusinessDataServiceHelper.newDynamicObject((String)"bcm_userdefinedmember");
        DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)none);
        none.set("number", (Object)memNum);
        none.set("name", (Object)memName);
        none.set("model", (Object)model.getId());
        none.set("dimension", (Object)dimId);
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{none});
        DynamicObject noneTree = BusinessDataServiceHelper.newDynamicObject((String)"bcm_userdefinedmembertree");
        DimensionServiceHelper.initDimensionDyObject((DynamicObject)noneTree);
        noneTree.set("model", (Object)model.getId());
        noneTree.set("dimension", (Object)dimId);
        noneTree.set("level", (Object)(parent.getInt("level") + 1));
        noneTree.set("parent", (Object)parent.getString("id"));
        noneTree.set("datatype", (Object)"0");
        noneTree.set("storagetype", (Object)"4");
        noneTree.set("aggoprt", (Object)"1");
        noneTree.set("isleaf", (Object)true);
        noneTree.set("longnumber", (Object)(parent.getString("longnumber") + "!" + memNum));
        noneTree.set("number", (Object)memNum);
        noneTree.set("name", (Object)memName);
        noneTree.set("dseq", (Object)DimensionServiceHelper.getDSeq((long)parent.getLong("id"), (String)"bcm_userdefinedmembertree", (String)"AdjustExternalInvokeServiceImpl"));
        noneTree.set("id", (Object)memberId);
        noneTree.set("member", save[0]);
        if (!QueryServiceHelper.exists((String)"bcm_userdefinedmembertree", (Object)noneTree.getLong("id"))) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{noneTree});
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)parent.get("id"), (String)"bcm_userdefinedmembertree");
            if (object != null && object.getBoolean("isleaf")) {
                object.set("isleaf", (Object)"0");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
            OlapServiceHelper.createMember((String)model.getCubeNumber(), (String)dimNumber, (String)memNum);
        }
        return noneTree;
    }

    private void addDimmappingMessage(Collection<IBudgetBalance> iBudgetBalances_new, Collection<IControlParam> iBudgetBalances, Map<String, Object> dimmember, boolean isEb) {
        Map<String, List<IControlParam>> collect = iBudgetBalances.stream().collect(Collectors.groupingBy(b -> this.getKey(b, dimmember, isEb)));
        for (IBudgetBalance ib : iBudgetBalances_new) {
            List<IControlParam> ic = collect.get(this.getKey(ib, dimmember, isEb));
            if (ic == null || ic.size() <= 0) continue;
            IControlParam remove = ic.remove(0);
            ib.setReqMember(remove.getReqMember("Account"));
            ib.setReqMember(remove.getReqMember("Entity"));
        }
    }

    private String getKey(Object object, Map<String, Object> dimmember, boolean isEb) {
        if (object instanceof IBudgetBalance) {
            IBudgetBalance ib = (IBudgetBalance)object;
            String data = isEb ? ib.getMember(true, SysDimensionEnum.Year.getNumber()).getNumber() + ib.getMember(true, SysDimensionEnum.Period.getNumber()).getNumber() : ib.getMember(true, SysDimensionEnum.BudgetPeriod.getNumber()).getNumber();
            return ib.getAccount(true).getNumber() + ib.getOrgUnit(true).getNumber() + data + ib.getMember(true, dimmember.get("dimNum").toString()).getNumber();
        }
        HashMap map = (HashMap)object;
        String period = isEb ? (String)map.get("Year") + (String)map.get("Period") : (String)map.get("BudgetPeriod");
        return (String)map.get("Account") + (String)map.get("Entity") + period + (String)map.get(dimmember.get("dimNum").toString());
    }

    private String prasePeriods(boolean isEb, DynamicObject ob, Map<String, Object> dimmember) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        String costPeriodKey = format.format(ob.getDate(dimmember.get("costPeriodKey").toString()));
        String[] split = costPeriodKey.split("-");
        if (isEb) {
            return "FY" + split[0] + "M_M" + split[1];
        }
        return "FY" + split[0] + ".M" + split[1];
    }

    private BigDecimal getBudgetMoney(Object object, Map<String, Object> dimmember) {
        String bdoutamount = ((DynamicObject)object).getString(dimmember.get("budgetMoney").toString());
        BigDecimal adjbigDecimal = null;
        adjbigDecimal = StringUtils.isEmpty((String)bdoutamount) ? BigDecimal.ZERO : new BigDecimal(bdoutamount);
        return adjbigDecimal;
    }

    protected Collection<IBudgetBalance> isExitNotLeafdim(Collection<IControlParam> iBudgetBalances, List<Dimension> defDimension, List<Map<String, String>> adjustList, Map<String, Object> dimmember, BizModel model, Map<String, String> accountNumAndBusModel) {
        Map<String, Dimension> defDimMap = defDimension.stream().collect(Collectors.toMap(d -> d.getNumber(), d -> d));
        for (IBudgetBalance iBudgetBalance : iBudgetBalances) {
            HashMap<String, String> memberMap = new HashMap<String, String>(16);
            String account = iBudgetBalance.getAccount(true).getNumber();
            if (!model.isEBByModel()) {
                accountNumAndBusModel.computeIfAbsent(account, v -> this.queryBusModel(model.getId(), account));
            }
            Map budget_member = (Map)((BudgetBalance)iBudgetBalance).get("BUDGET_MEMBER");
            for (Map.Entry mapEntry : budget_member.entrySet()) {
                String dimNum = (String)mapEntry.getKey();
                kd.epm.eb.common.model.Member value = (kd.epm.eb.common.model.Member)mapEntry.getValue();
                memberMap.put(dimNum, value.getNumber());
                if (!dimNum.equals(SysDimensionEnum.AuditTrail.getNumber())) continue;
                memberMap.put(dimNum, "EntityInput");
            }
            adjustList.add(memberMap);
        }
        log.info("adjustAudio : queryParam " + SerializationUtils.toJsonString(adjustList));
        return new BgControlCallerImpl().queryBalance(model.getId(), adjustList, Collections.singletonList(BgControlSettingTypeEnum.MONTH.getNumber()), true, model.getControlBusModelId());
    }

    private String queryBusModel(Long modelId, String accountNum) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        qf.add("number", "=", (Object)accountNum);
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_accountmembertree", (String)"dataset.id", (QFilter[])qf.toArrays());
        if (object == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u672a\u627e\u5230\u79d1\u76ee%1\u5bf9\u5e94\u7684\u6570\u636e\u96c6\u3002", (String)"AdjustExternalInvokeServiceImpl_58", (String)"epm-eb-mservice", (Object[])new Object[]{accountNum}));
        }
        return object.getString("dataset.id");
    }

    private void setNewDimBudget(List<List<Map<String, String>>> billLists, Map<String, Object> dimmember, BizModel model) {
        try {
            ArrayList<Map<String, String>> adjustList = new ArrayList<Map<String, String>>(10);
            for (List<Map<String, String>> billList : billLists) {
                adjustList.add(billList.get(billList.size() - 1));
            }
            List<Map<String, String>> newAdjustList = this.getNewAdjustList(adjustList);
            this.removeOtherData(newAdjustList, true);
            BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
            ArrayList<String> type = new ArrayList<String>();
            type.add(BgControlSettingTypeEnum.MONTH.getNumber());
            Collection iBudgetBalances = bgControlCaller.queryBalance(model.getId(), newAdjustList, type, false, model.getControlBusModelId());
            block3: for (IBudgetBalance iBudgetBalance : iBudgetBalances) {
                String key = this.getKey(iBudgetBalance, dimmember, model.isEBByModel());
                for (Map map : adjustList) {
                    String key1 = this.getKey(map, dimmember, model.isEBByModel());
                    if (!key.equals(key1)) continue;
                    BigDecimal budget = iBudgetBalance.getBudget();
                    if (budget == null) {
                        budget = BigDecimal.ZERO;
                    }
                    map.put(KEY_BUDGET, budget.toPlainString());
                    String adjust = (String)map.get(KEY_ADJUST);
                    BigDecimal adjustMoney = null;
                    adjustMoney = adjust == null ? BigDecimal.ZERO : new BigDecimal(adjust);
                    BigDecimal balance = iBudgetBalance.getBalance();
                    if (balance == null) {
                        balance = BigDecimal.ZERO;
                    }
                    if (balance.add(adjustMoney).compareTo(BigDecimal.ZERO) < 0) {
                        throw new KDBizException(ResManager.loadResFormat((String)"%1\u4e0b\u7684%2\u9884\u7b97\u4f59\u989d\u4e0d\u8db3\u3002", (String)"AdjustExternalInvokeServiceImpl_60", (String)"epm-eb-mservice", (Object[])new Object[]{dimmember.get("dimName"), dimmember.get("new_dimmemName")}));
                    }
                    map.put(FINALBUDGET, budget.add(adjustMoney).toPlainString());
                    map.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), budget.add(adjustMoney).toPlainString());
                    continue block3;
                }
            }
        }
        catch (Exception ex) {
            log.error("setNewDimBudget: end", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    private List<Map<String, String>> getNewAdjustList(List<Map<String, String>> adjustList) {
        ArrayList<Map<String, String>> adjustList_new = new ArrayList<Map<String, String>>(adjustList.size());
        for (Map<String, String> map : adjustList) {
            HashMap<String, String> map1 = new HashMap<String, String>(16);
            map1.putAll(map);
            adjustList_new.add(map1);
        }
        return adjustList_new;
    }

    private void removeOtherData(List<Map<String, String>> adjustList, boolean isRemoveMoney) {
        for (Map<String, String> map : adjustList) {
            map.remove(KEY_BUDGET);
            map.remove(KEY_ADJUST);
            map.remove(FINALBUDGET);
            if (!isRemoveMoney) continue;
            map.remove(FacTabFieldDefEnum.FIELD_MONEY.getField());
        }
    }

    public void saveOlapData(List<Map<String, String>> dimlist, long modelId, String modelNumber) {
        if (dimlist == null || dimlist.isEmpty() || modelId == 0L || modelNumber == null) {
            return;
        }
        EbBatchSave batchSave = EbOlapServiceHelper.getBatchSave();
        SaveCommandInfo saveCommandInfo = null;
        BgData bgData = null;
        String value = null;
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensions = cacheHelper.getDimensionList();
        ArrayList<String> dimesnionNums = new ArrayList<String>(dimensions.size());
        for (Dimension dimension : dimensions) {
            dimesnionNums.add(dimension.getNumber());
        }
        try {
            saveCommandInfo = new SaveCommandInfo();
            saveCommandInfo.addDimensions(cacheHelper.getModelobj().getDimensionNums());
            saveCommandInfo.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            batchSave.open(modelNumber, saveCommandInfo);
            for (Map map : dimlist) {
                value = (String)map.get(FacTabFieldDefEnum.FIELD_MONEY.getField());
                if (value == null) continue;
                bgData = new BgData(Long.valueOf(modelId), map);
                try {
                    batchSave.add(dimesnionNums, bgData, (Object)new BigDecimal(value));
                }
                catch (Exception ex) {
                    batchSave.add(dimesnionNums, bgData, (Object)value);
                }
            }
            batchSave.flush();
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadResFormat((String)"OLAP\u4fdd\u5b58\u5931\u8d25\u201c%1\u201d\u3002", (String)"AdjustExternalInvokeServiceImpl_64", (String)"epm-eb-mservice", (Object[])new Object[]{e.getMessage()}));
        }
        finally {
            OlapContext.clearSaveDataContext();
            batchSave.close();
        }
    }

    private Map<String, List<IKDCell>> getIKdCells(List<Map<String, String>> adjustList, BizModel model, Map<String, String> accountNumAndBusModel) {
        IModelCacheHelper modelContext = ModelCacheContext.getOrCreate((Long)model.getId());
        HashMap<String, List<IKDCell>> ikdCells = new HashMap<String, List<IKDCell>>(16);
        List dimensionList = null;
        String[] dimensionArr = null;
        List cells = null;
        BigDecimal FMoney = null;
        String busModelId = null;
        for (Map<String, String> adjust : adjustList) {
            busModelId = accountNumAndBusModel.get(adjust.get("Account"));
            cells = ikdCells.computeIfAbsent(busModelId, v -> new LinkedList());
            dimensionList = modelContext.getDimensionList(Long.valueOf(Long.parseLong(busModelId)));
            dimensionArr = new String[dimensionList.size()];
            for (int i = 0; i < dimensionList.size(); ++i) {
                dimensionArr[i] = adjust.get(((Dimension)dimensionList.get(i)).getNumber());
            }
            FMoney = new BigDecimal(adjust.get(FacTabFieldDefEnum.FIELD_MONEY.getField()));
            cells.add(KDCell.of((String[])dimensionArr, (BigDecimal)FMoney));
        }
        return ikdCells;
    }

    private void saveOlapDataToBgmd(IModelCacheHelper orCreate, BizModel model, List<IKDCell> cells, Long busModelId) {
        List dimensionList = orCreate.getDimensionList(busModelId);
        String[] useDimension = new String[dimensionList.size()];
        for (int i = 0; i < dimensionList.size(); ++i) {
            useDimension[i] = ((Dimension)dimensionList.get(i)).getNumber();
        }
        IKDOlapRequest request = KDOlapRequestUtils.of((Long)model.getId(), (Long)model.getControlBusModelId(), (Long)busModelId, cells);
        request.getOlapData().setUseDimension(useDimension);
        request.getOlapData().setDimensionMap(orCreate.getDimensionMap(busModelId));
        request.getOlapData().setModelCacheHelper(orCreate);
        request.getProperties().setPropertyValue("IGNORE_SAVE_TEXT", KDValue.valueOf((String)BgConstant.TRUE_STR));
        request.getProperties().setPropertyValue("IGNORE_PERM_SAVE", KDValue.valueOf((String)BgConstant.TRUE_STR));
        request.getProperties().setPropertyValue("IGNORE_DATA_LOCK", KDValue.valueOf((String)BgConstant.TRUE_STR));
        OlapServiceCaller caller = new OlapServiceCaller();
        caller.save(request);
    }

    public String getCodeRuleNumber(String entityNumber, String property) {
        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
        if (property != null) {
            dy.set(property, (Object)TimeServiceHelper.getTimeStamp());
        }
        return service.getNumber(entityNumber, dy, null);
    }

    private Map<String, String> createAdjustBill_new(List<Map<String, String>> adjustList, Map<String, Map<String, String>> numberAndDimemberIdMap, List<Dimension> defDimension, Map<String, Object> dimmember, BizModel model) {
        try {
            String codeRuleNumber = this.getCodeRuleNumber("eb_adjpstbill", null);
            String userId = dimmember.get("userId").toString();
            DynamicObject adjpstbillDoc = null;
            adjpstbillDoc = model.isEBByModel() ? BusinessDataServiceHelper.newDynamicObject((String)"eb_adjpstbill") : BusinessDataServiceHelper.newDynamicObject((String)"bgm_adjpstbill");
            long adjpstId = GlobalIdUtil.genGlobalLongId();
            adjpstbillDoc.set("billno", (Object)codeRuleNumber);
            adjpstbillDoc.set("billstatus", (Object)"E");
            adjpstbillDoc.set("applier", (Object)userId);
            adjpstbillDoc.set("applydate", (Object)TimeServiceHelper.now());
            adjpstbillDoc.set("billtype", (Object)"2");
            String dimnumber = dimmember.get("new_dimmemNumber").toString();
            if (ProjectOperationEnum.Auditee.getIndex().equals(dimmember.get(RESTOREDATA))) {
                adjpstbillDoc.set("adjustreason", (Object)ResManager.loadResFormat((String)"\u7acb\u9879\u5355\u53cd\u5ba1\u6838\u8c03\u5242%1\u3002", (String)"AdjustExternalInvokeServiceImpl_51", (String)"epm-eb-mservice", (Object[])new Object[]{dimnumber}));
            } else if (ProjectOperationEnum.Close.getIndex().equals(dimmember.get(RESTOREDATA))) {
                adjpstbillDoc.set("adjustreason", (Object)ResManager.loadResFormat((String)"\u7acb\u9879\u5355\u5173\u95ed\u8c03\u5242%1\u3002", (String)"AdjustExternalInvokeServiceImpl_52", (String)"epm-eb-mservice", (Object[])new Object[]{dimnumber}));
            } else if (ProjectOperationEnum.Audit.getIndex().equals(dimmember.get(RESTOREDATA))) {
                adjpstbillDoc.set("adjustreason", (Object)ResManager.loadResFormat((String)"\u7acb\u9879\u5355\u5ba1\u6838\u8c03\u5242%1\u3002", (String)"AdjustExternalInvokeServiceImpl_53", (String)"epm-eb-mservice", (Object[])new Object[]{dimnumber}));
            } else if (ProjectOperationEnum.Closeable.getIndex().equals(dimmember.get(RESTOREDATA))) {
                adjpstbillDoc.set("adjustreason", (Object)ResManager.loadResFormat((String)"\u7acb\u9879\u5355\u53cd\u5173\u95ed\u8c03\u5242%1\u3002", (String)"AdjustExternalInvokeServiceImpl_54", (String)"epm-eb-mservice", (Object[])new Object[]{dimnumber}));
            }
            this.setUserMessage(adjpstbillDoc, Long.parseLong(userId));
            Map<String, String> entryHand = adjustList.get(0);
            if (model.isEBByModel()) {
                DynamicObjectCollection multperiod = adjpstbillDoc.getDynamicObjectCollection("multperiod");
                DynamicObject periodDoc = multperiod.addNew();
                periodDoc.set("fbasedataid", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Period.getNumber()).get(entryHand.get(SysDimensionEnum.Period.getNumber())));
                adjpstbillDoc.set("year", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Year.getNumber()).get(entryHand.get(SysDimensionEnum.Year.getNumber())));
            } else {
                DynamicObjectCollection multiBudgetPeriod = adjpstbillDoc.getDynamicObjectCollection("budgetperiods");
                DynamicObject budgetPeriodDoc = multiBudgetPeriod.addNew();
                budgetPeriodDoc.set("fbasedataid", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.BudgetPeriod.getNumber()).get(entryHand.get(SysDimensionEnum.BudgetPeriod.getNumber())));
            }
            adjpstbillDoc.set("model", (Object)model.getId());
            adjpstbillDoc.set("datatype", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.DataType.getNumber()).get(entryHand.get(SysDimensionEnum.DataType.getNumber())));
            adjpstbillDoc.set("version", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Version.getNumber()).get(entryHand.get(SysDimensionEnum.Version.getNumber())));
            adjpstbillDoc.set("changetype", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.ChangeType.getNumber()).get(entryHand.get(SysDimensionEnum.ChangeType.getNumber())));
            adjpstbillDoc.set("currency", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Currency.getNumber()).get(entryHand.get(SysDimensionEnum.Currency.getNumber())));
            adjpstbillDoc.set("id", (Object)adjpstId);
            DynamicObjectCollection adjdetailentity = adjpstbillDoc.getDynamicObjectCollection("adjdetailentity");
            for (int i = 0; i < adjustList.size(); ++i) {
                DynamicObject doc = adjdetailentity.addNew();
                Map<String, String> entry = adjustList.get(i);
                doc.set("seq", (Object)(i + 1));
                doc.set("entity", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Entity.getNumber()).get(entry.get(SysDimensionEnum.Entity.getNumber())));
                doc.set("account", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Account.getNumber()).get(entry.get(SysDimensionEnum.Account.getNumber())));
                doc.set("groupnum", (Object)1);
                for (int j = 0; j < defDimension.size() && j < 6; ++j) {
                    doc.set("customdim" + (j + 1), (Object)numberAndDimemberIdMap.get(defDimension.get(j).getNumber()).get(entry.get(defDimension.get(j).getNumber())));
                }
                doc.set("ordersign", (Object)(i + ":" + 1));
                if (model.isEBByModel()) {
                    doc.set("period", (Object)numberAndDimemberIdMap.get(SysDimensionEnum.Period.getNumber()).get(entry.get(SysDimensionEnum.Period.getNumber())));
                }
                doc.set("budgetdata", (Object)entry.get(KEY_BUDGET));
                doc.set("adjustdata", (Object)entry.get(KEY_ADJUST));
                if (entry.get(KEY_ADJUST).equals("0")) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u6574\u6570\u4e3a\u96f6\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AdjustExternalInvokeServiceImpl_10", (String)"epm-eb-mservice", (Object[])new Object[0]));
                }
                doc.set("finaldata", (Object)entry.get(FINALBUDGET));
            }
            Object[] nones = new Object[]{adjpstbillDoc};
            BusinessDataWriter.save((IDataEntityType)adjpstbillDoc.getDynamicObjectType(), (Object[])nones);
            return this.setReturnMessage(nones, adjustList, model);
        }
        catch (Exception e) {
            log.error("createAdjustBill_new", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private Map<String, String> setReturnMessage(Object[] nones, List<Map<String, String>> adjustList, BizModel model) {
        DynamicObject doc = (DynamicObject)nones[0];
        HashMap<String, String> returnMessage = new HashMap<String, String>(8);
        returnMessage.put("billNumber", doc.getString("billno"));
        returnMessage.put("dimMessage", SerializationUtils.toJsonString(adjustList));
        returnMessage.put("model", model.getNumber());
        return returnMessage;
    }

    private void setUserMessage(DynamicObject adjpstbillDoc, Long userId) {
        String position;
        DynamicObject user = this.getUserMessage(userId);
        if (user == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002", (String)"AdjustExternalInvokeServiceImpl_65", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        DynamicObjectCollection companyInfos = user.getDynamicObjectCollection("entryentity");
        if (companyInfos.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7533\u8bf7\u4eba\u7684\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002", (String)"AdjustExternalInvokeServiceImpl_66", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        DynamicObject department = ((DynamicObject)companyInfos.get(0)).getDynamicObject("dpt");
        if (department == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7533\u8bf7\u4eba\u90e8\u95e8\u4fe1\u606f\u5931\u8d25\u3002", (String)"AdjustExternalInvokeServiceImpl_67", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        Map company = OrgUnitServiceHelper.getCompanyfromOrg((Long)department.getLong("id"));
        adjpstbillDoc.set("department", (Object)department.getString("id"));
        if (company != null) {
            adjpstbillDoc.set("company", company.get("id"));
        }
        if ((position = ((DynamicObject)companyInfos.get(0)).getString("position")) != null) {
            adjpstbillDoc.set("position", (Object)position);
        }
    }

    private DynamicObject getUserMessage(Long userId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", (Object)userId);
        return BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"entryentity,entryentity.dpt,entryentity.position", (QFilter[])qfBuilder.toArrays());
    }

    private boolean queryDimAndDimmenberByModel(List<Dimension> dimensions, Map<String, Map<String, String>> numberAndDimemberIdMap, Map<String, List<kd.epm.eb.common.model.Member>> dimMember, Map<String, Object> dimmember) {
        boolean isExit = false;
        String inputMemNum = dimmember.get("new_dimmemNumber").toString();
        String inputDimNum = dimmember.get("dimNum").toString();
        for (Dimension dimension : dimensions) {
            String dimNumber = dimension.getNumber();
            HashMap<String, String> numberAndDimemberId = new HashMap<String, String>(100);
            String selectFiled = "id,name,number,parent.number,parent.id,parent.name";
            ArrayList<kd.epm.eb.common.model.Member> memberList = new ArrayList<kd.epm.eb.common.model.Member>(10);
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("dimension", "=", (Object)dimension.getId());
            DynamicObjectCollection query = QueryServiceHelper.query((String)dimension.getMemberModel(), (String)selectFiled, (QFilter[])qfBuilder.toArray());
            for (DynamicObject memberRow : query) {
                String memId = memberRow.getString("id");
                String memName = memberRow.getString("name");
                String memNumber = memberRow.getString("number");
                kd.epm.eb.common.model.Member member = new kd.epm.eb.common.model.Member(Long.valueOf(Long.parseLong(memId)), memName, memNumber);
                memberList.add(member);
                numberAndDimemberId.put(memNumber, memId);
                if (!dimNumber.equals(inputDimNum)) continue;
                this.exitDimension = dimension;
                if (!memNumber.equals(inputMemNum)) continue;
                this.exitDimmemId = Long.parseLong(memId);
                isExit = true;
            }
            numberAndDimemberIdMap.put(dimNumber, numberAndDimemberId);
            dimMember.put(dimNumber, memberList);
        }
        return isExit;
    }

    private List<Dimension> getDimension(BizModel model, List<Dimension> defDimension) {
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>();
        String selectFiled = "id,name,number,shortnumber,membermodel,fieldmapped,issysdimension,dseq";
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)model.getId()));
        DataSet result = QueryServiceHelper.queryDataSet((String)"EPM", (String)"epm_dimension", (String)selectFiled, (QFilter[])qfBuilder.toArrays(), (String)"dseq");
        if (!result.isEmpty()) {
            for (Row row : result) {
                Dimension dimension = new Dimension();
                dimension.setId(row.getLong("id"));
                dimension.setNumber(row.getString("number"));
                dimension.setName(row.getString("name"));
                dimension.setShortNumber(row.getString("shortnumber"));
                dimension.setSeq(row.getInteger("dseq").intValue());
                dimension.setPreset(row.getBoolean("issysdimension").booleanValue());
                dimension.setMemberModel(row.getString("membermodel"));
                if (!dimension.isPreset()) {
                    defDimension.add(dimension);
                }
                dimensionList.add(dimension);
            }
        }
        return dimensionList;
    }

    public static String getLockErrorMessage(String lockType) {
        String message = ResManager.loadKDString((String)"\u9879\u76ee\u4e91\u8c03\u5242\u7533\u8bf7\u9501\u5931\u8d25", (String)"AdjustExternalInvokeServiceImpl_71", (String)"epm-eb-mservice", (Object[])new Object[0]);
        if ("audit/control".equals(lockType)) {
            message = ResManager.loadKDString((String)"\u9879\u76ee\u4e91\u8c03\u5242\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AdjustExternalInvokeServiceImpl_72", (String)"epm-eb-mservice", (Object[])new Object[0]);
        }
        return message;
    }

    private void writeLog(DynamicObject dynamicObject, List<List<Map<String, String>>> billLists, String op) {
        DynamicObject doc = BusinessDataServiceHelper.newDynamicObject((String)"eb_adjustimpllog");
        doc.set("dyn", (Object)SerializationUtils.toJsonString(billLists));
        doc.set("usetime", (Object)TimeServiceHelper.now());
        doc.set("olddimmemberid", (Object)dynamicObject.getString("billno"));
        doc.set("restoredata", (Object)op);
        DynamicObject[] docs = new DynamicObject[]{doc};
        SaveServiceHelper.save((DynamicObject[])docs);
    }

    private static /* synthetic */ String lambda$AddOlapDimension_new$1(DynamicObject d) {
        return d.getString("billno");
    }

    private static /* synthetic */ Map lambda$AddOlapDimension_new$0(IControlParam b) {
        return b.toMap();
    }
}

