/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.openapi.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.service.openapi.ApiObject;
import kd.epm.eb.service.openapi.impl.AbstractImpl;
import org.jetbrains.annotations.NotNull;

public class MemberUpdateImpl
extends AbstractImpl {
    private static final String[] compelKeys = new String[]{"modelNumber", "dimNumber", "viewNumber", "members"};

    public static MemberUpdateImpl get(@NotNull LogStats stats) {
        return new MemberUpdateImpl(stats);
    }

    private MemberUpdateImpl(@NotNull LogStats stats) {
        super(stats);
    }

    public Map<String, Object> update(@NotNull Map<String, Object> params) {
        Map<String, Object> result;
        try {
            result = this.$update(params);
        }
        finally {
            this.destory();
        }
        return result;
    }

    public Map<String, Object> $update(@NotNull Map<String, Object> params) {
        ApiObject apiObject = this.verify(params, compelKeys, AbstractImpl.Type.UPDATE, true);
        if (SysDimensionEnum.Account.getNumber().equals(apiObject.dimNumber)) {
            apiObject = this.verify(params, new String[]{"datasetNumber"}, apiObject, AbstractImpl.Type.UPDATE, true);
        }
        if (this.getEXCLUDE().contains(apiObject.dimNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u4fee\u6539\u4e0d\u652f\u6301\u9884\u7b97\u671f\u95f4\u3001\u7248\u672c\u3001\u5ea6\u91cf\u3001\u7ebf\u7d22\u3001\u53d8\u52a8\u7c7b\u578b\u3001\u6570\u636e\u7c7b\u578b\u7b49\u7ef4\u5ea6\u3002", (String)"MemberUpdateImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        LinkedHashSet success = Sets.newLinkedHashSet();
        LinkedHashMap errors = Maps.newLinkedHashMap();
        result.put("success", success);
        result.put("errors", errors);
        if (apiObject.members == null || apiObject.members.isEmpty()) {
            return result;
        }
        this.dealOpenApi(apiObject, success, errors, AbstractImpl.Type.UPDATE);
        return result;
    }

    @Override
    protected Set<String> queryRefNumberParent(ApiObject apiObject, Set<String> refNumbers) {
        Set<String> _refNumbers = super.queryRefNumberParent(apiObject, refNumbers);
        boolean hasAccount = SysDimensionEnum.Account.getNumber().equals(apiObject.dimNumber);
        Long modelId = apiObject.model.getLong("id");
        Long dimensionId = apiObject.dimension.getLong("id");
        Long viewId = apiObject.view != null ? Long.valueOf(apiObject.view.getLong("id")) : null;
        Long datasetId = null;
        if (hasAccount) {
            datasetId = apiObject.hasEbModel() ? Long.valueOf(0L) : Long.valueOf(((DynamicObject)apiObject.datasetMap.get(apiObject.datasetNumber)).getLong("id"));
        }
        SqlBuilder sql = new SqlBuilder();
        if (IDUtils.isNotNull((Long)viewId)) {
            sql.append("select fnumber from t_eb_viewmember where fid in (select fparentid from t_eb_viewmember where fmodelid = ? and fviewid = ? and fdimensionid = ?", new Object[]{modelId, viewId, dimensionId});
            sql.append(" and ", new Object[0]).appendIn("fnumber", refNumbers.toArray());
            sql.append(")", new Object[0]);
        } else {
            sql.append("select fnumber from " + apiObject.getMemberTable() + " where fid in (select fparentid from " + apiObject.getMemberTable() + " where fmodelid = ? and fdimensionid = ?", new Object[]{modelId, dimensionId});
            sql.append(" and ", new Object[0]).appendIn("fnumber", refNumbers.toArray());
            if (hasAccount) {
                sql.append(" and fdataset = ?", new Object[]{datasetId});
            }
            sql.append(")", new Object[0]);
        }
        try (DataSet ds = DB.queryDataSet((String)"queryParentNumber", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    _refNumbers.add(row.getString("fnumber"));
                }
            }
        }
        return _refNumbers;
    }
}

