/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.upgrade.epbs;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class ParamSetUpgradeServiceImpl
implements IUpgradeService {
    private static final List<String> customParam = Arrays.asList("BG001", "BG004", "BG010", "BG011", "BG012", "BG015", "BG021", "BG029", "BG030", "BG031", "BG024", "EPM001", "BG039", "BG043");
    private static final Map<String, String> codeMap = new HashMap<String, String>(16);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"ParamSetUpgradeServiceImpl");){
            try {
                if (!UpdateRecordHelper.isUpdated((String)"ParamSetUpgrade")) {
                    String log = this.execute();
                    result.setLog(log);
                    UpdateRecordHelper.addRecord((String)"ParamSetUpgrade", (String)log, null, (boolean)true);
                }
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        return result;
    }

    public String execute() {
        HashMap<String, Long> newCodeIdMap = new HashMap<String, Long>(16);
        try (DataSet ds = DB.queryDataSet((String)"ParamSetUpgradeServiceImpl", (DBRoute)BgBaseConstant.epm, (String)("select fid,fnumber from t_epbs_preset_param where fnumber in (" + SqlBatchUtils.getBatchParamsSql((int)codeMap.size()) + ")"), (Object[])codeMap.values().toArray());){
            while (ds != null && ds.hasNext()) {
                Row param = ds.next();
                newCodeIdMap.put(param.getString("fnumber"), param.getLong("fid"));
            }
        }
        HashSet<String> exists = new HashSet<String>(16);
        ArrayList<Object[]> newParamValues = new ArrayList<Object[]>(10);
        HashMap paramUpgradeCountMap = new HashMap(16);
        HashSet<Long> modelIds = new HashSet<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)"ParamSetUpgradeServiceImpl", (DBRoute)BgBaseConstant.epm, (String)"select fid,fnodeid,fmodelid,fparams,fcreatedate,fmodifydate from t_eb_param_setting order by fmodifydate desc");){
            while (ds != null && ds.hasNext()) {
                Row param = ds.next();
                long nodeId = param.getLong("fnodeid");
                long modelId = param.getLong("fmodelid");
                String params = param.getString("fparams");
                if (StringUtils.isEmpty((String)params) || IDUtils.isEmptyLong((Long)modelId).booleanValue()) continue;
                modelIds.add(modelId);
                HashMap<String, Object> newParamMap = new HashMap<String, Object>(16);
                Map paramMap = (Map)SerializationUtils.fromJsonString((String)params, Map.class);
                for (Map.Entry entry : paramMap.entrySet()) {
                    String newParamCode = codeMap.get(nodeId + "!!" + (String)entry.getKey());
                    if (newParamCode == null) continue;
                    if (customParam.contains(newParamCode)) {
                        JSONObject jsonObject = (JSONObject)newParamMap.computeIfAbsent(newParamCode, e -> new JSONObject());
                        jsonObject.put((String)entry.getKey(), entry.getValue());
                        if (entry.getValue() instanceof Map) {
                            Map value = (Map)entry.getValue();
                            if (value.get("id") == null) continue;
                            jsonObject.put((String)entry.getKey(), value.get("id"));
                            continue;
                        }
                        if (!(entry.getValue() instanceof Collection)) continue;
                        Collection values = (Collection)entry.getValue();
                        ArrayList<Long> ids = new ArrayList<Long>(values.size());
                        for (Object value : values) {
                            Map fbasedataid;
                            Map mapValue;
                            if (value instanceof Map && (mapValue = (Map)value).get("fbasedataid") instanceof Map && (fbasedataid = (Map)mapValue.get("fbasedataid")).get("id") != null) {
                                ids.add((Long)fbasedataid.get("id"));
                            }
                            jsonObject.put((String)entry.getKey(), ids);
                        }
                        continue;
                    }
                    if (entry.getValue() instanceof Boolean) {
                        if (((Boolean)entry.getValue()).booleanValue()) {
                            newParamMap.put(newParamCode, 1);
                            continue;
                        }
                        newParamMap.put(newParamCode, 0);
                        continue;
                    }
                    newParamMap.put(newParamCode, entry.getValue());
                }
                for (Map.Entry entry : newParamMap.entrySet()) {
                    Long newParamId = (Long)newCodeIdMap.get(entry.getKey());
                    if (!exists.add(newParamId + "!!" + modelId)) continue;
                    Object paramValue = entry.getValue();
                    paramValue = paramValue instanceof Map ? SerializationUtils.toJsonString(entry.getValue()) : String.valueOf(paramValue);
                    Integer count = paramUpgradeCountMap.getOrDefault(entry.getKey(), 0);
                    paramUpgradeCountMap.put(entry.getKey(), count + 1);
                    newParamValues.add(new Object[]{newParamId, modelId, GlobalIdUtil.genGlobalLongId(), param.get("fmodifydate"), paramValue});
                }
            }
        }
        if (modelIds.size() > 0) {
            DB.execute((DBRoute)BgBaseConstant.epm, (String)("delete from t_epbs_param_set where fmodelid !=0 and fmodelid in ( " + SqlBatchUtils.getBatchParamsSql((int)modelIds.size()) + " )"), (Object[])modelIds.toArray());
        }
        if (newParamValues.size() > 0) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)"insert into t_epbs_param_set(fid,fmodelid,fentryid,fmodifytime,fparams) values (?,?,?,?,?)", newParamValues);
        }
        return SerializationUtils.toJsonString(paramUpgradeCountMap);
    }

    static {
        codeMap.put("4!!adjust_small", "BG001");
        codeMap.put("4!!adjust_show", "BG001");
        codeMap.put("4!!budget_balance", "BG002");
        codeMap.put("4!!allow_negative", "BG003");
        codeMap.put("4!!allow_rowdim_same", "BG051");
        codeMap.put("4!!allow_onorder_bill", "BG052");
        codeMap.put("5!!adjust_small", "BG004");
        codeMap.put("5!!adjust_show", "BG004");
        codeMap.put("5!!budget_balance", "BG005");
        codeMap.put("5!!allow_negative", "BG006");
        codeMap.put("5!!allow_rowdim_same", "BG053");
        codeMap.put("5!!allow_onorder_bill", "BG054");
        codeMap.put("6!!adjust_small", "BG001");
        codeMap.put("6!!adjust_show", "BG001");
        codeMap.put("6!!budget_balance", "BG002");
        codeMap.put("6!!allow_negative", "BG003");
        codeMap.put("6!!allow_rowdim_same", "BG051");
        codeMap.put("6!!allow_onorder_bill", "BG052");
        codeMap.put("6!!on_order", "EB001");
        codeMap.put("7!!adjust_small", "BG004");
        codeMap.put("7!!adjust_show", "BG004");
        codeMap.put("7!!budget_balance", "BG005");
        codeMap.put("7!!allow_negative", "BG006");
        codeMap.put("7!!allow_rowdim_same", "BG053");
        codeMap.put("7!!allow_onorder_bill", "BG054");
        codeMap.put("7!!on_order", "EB002");
        codeMap.put("12!!rejectopinion", "BG007");
        codeMap.put("12!!rejectonreport", "BG034");
        codeMap.put("12!!rejectonreportworkflow", "BG050");
        codeMap.put("12!!shrink", "BG008");
        codeMap.put("12!!showlist", "BG009");
        codeMap.put("12!!adjust", "BG010");
        codeMap.put("12!!adjustleaf", "BG010");
        codeMap.put("12!!approveeditnoleafcell", "BG010");
        codeMap.put("12!!approveedit", "BG010");
        codeMap.put("12!!adjustnotleaf", "BG010");
        codeMap.put("14!!rejectopinion", "BG007");
        codeMap.put("14!!rejectonreport", "BG034");
        codeMap.put("14!!shrink", "BG008");
        codeMap.put("14!!showlist", "BG009");
        codeMap.put("14!!adjust", "BG010");
        codeMap.put("14!!adjustleaf", "BG010");
        codeMap.put("14!!approveeditnoleafcell", "BG010");
        codeMap.put("14!!approveedit", "BG010");
        codeMap.put("14!!adjustnotleaf", "BG010");
        codeMap.put("11!!datalockswitch", "BG011");
        codeMap.put("11!!audittrail", "BG011");
        codeMap.put("11!!reporttitle", "BG012");
        codeMap.put("11!!reporttabshowstatus", "BG013");
        codeMap.put("11!!editnoleafcell", "BG014");
        codeMap.put("11!!reportcolor", "BG015");
        codeMap.put("11!!unweavereportconfirm", "BG016");
        codeMap.put("11!!btnrecalcvisible", "BG017");
        codeMap.put("11!!lastselectpagemem", "BG049");
        codeMap.put("11!!forbidcommitparent", "BG055");
        codeMap.put("11!!exportformatvalue", "BG056");
        codeMap.put("16!!reporttitle", "BG012");
        codeMap.put("16!!reporttabshowstatus", "BG013");
        codeMap.put("16!!editnoleafcell", "BG014");
        codeMap.put("16!!reportcolor", "BG015");
        codeMap.put("16!!unweavereportconfirm", "BG016");
        codeMap.put("16!!btnrecalcvisible", "BG017");
        codeMap.put("16!!lastselectpagemem", "BG049");
        codeMap.put("16!!forbidcommitparent", "BG055");
        codeMap.put("16!!exportformatvalue", "BG056");
        codeMap.put("23!!nopagemumber", "BG018");
        codeMap.put("20!!nopagemumber", "BG018");
        codeMap.put("22!!entityfilterswitch", "BG028");
        codeMap.put("22!!checkdatalock", "BG035");
        codeMap.put("22!!orgpagesize", "BG036");
        codeMap.put("22!!checkmembperm1", "BG037");
        codeMap.put("22!!checkmembperm2", "BG038");
        codeMap.put("22!!checkbcmperm1", "BG047");
        codeMap.put("22!!checkbcmperm2", "BG048");
        codeMap.put("24!!entityfilterswitch", "BG028");
        codeMap.put("24!!checkdatalock", "BG035");
        codeMap.put("24!!orgpagesize", "BG036");
        codeMap.put("24!!checkbcmperm1", "BG047");
        codeMap.put("24!!checkbcmperm2", "BG048");
        codeMap.put("8!!reduce_adjust", "BGC001");
        codeMap.put("8!!reduce_redistribute", "BGC002");
        codeMap.put("8!!balancecheckprecision", "BGC003");
        codeMap.put("8!!balancecheckoccupation", "BGC004");
        codeMap.put("8!!lock_orgunit", "BGC005");
        codeMap.put("10!!partswitch", "BG019");
        codeMap.put("10!!execrulewhenopen", "BG020");
        codeMap.put("10!!smsswitch", "BG021");
        codeMap.put("10!!userid", "BG021");
        codeMap.put("10!!rule_release_max_times", "BG022");
        codeMap.put("10!!rulebatch_max_cell_amount", "BG023");
        codeMap.put("10!!custom_attribute_relation", "BG024");
        codeMap.put("10!!casetoexecution", "BG025");
        codeMap.put("10!!maxexecutetime", "BG026");
        codeMap.put("10!!collectresult", "BG027");
        codeMap.put("10!!shrek_page_type", "BG039");
        codeMap.put("10!!custom_shrek_page", "BG039");
        codeMap.put("10!!custom_shrek_cart_page", "BG039");
        codeMap.put("10!!custom_algo_page", "BG040");
        codeMap.put("10!!retryerrorcalc", "BG041");
        codeMap.put("10!!applybillruleswitch", "BG042");
        codeMap.put("10!!reportexportbatchexec", "BG043");
        codeMap.put("10!!reportexportpage", "BG043");
        codeMap.put("10!!right_check_cart", "BG044");
        codeMap.put("13!!selecteddims", "BG029");
        codeMap.put("13!!longnamenumdisplay", "BG030");
        codeMap.put("13!!perioduserdefine", "BG033");
        codeMap.put("15!!selecteddims", "BG029");
        codeMap.put("15!!longnamenumdisplay", "BG030");
        codeMap.put("15!!perioduserdefine", "BG033");
        codeMap.put("21!!storelevel", "BG031");
        codeMap.put("17!!tasklist_permcontrol", "BG032");
        codeMap.put("60!!pagesize", "BG045");
        codeMap.put("60!!examine_prop_relation", "BG046");
        codeMap.put("123454321!!opendatalog", "EPM001");
    }
}

