/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.ebSpread.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Stopwatch;
import java.util.Base64;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.ebSpread.util.GZIPUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DataAndJsonTranslator {
    private static final Log log = LogFactory.getLog(DataAndJsonTranslator.class);
    public static final String DEFAULT_SHEET_NAME = "Sheet1";
    public static final String ROWOUTLINES = "rowOutlines";
    public static final String COLUMNOUTLINES = "columnOutlines";
    private static final int DEFAULT_TEMPLATE_CELL_SIZE = 200000;
    private static final int MAX_TEMPLATE_CELL_SIZE = 500000;
    private static final Pattern rowCountPattern = Pattern.compile("\"rowCount\"\\s*:\\s*(\\d+)");
    private static final Pattern colCountPattern = Pattern.compile("\"columnCount\"\\s*:\\s*(\\d+)");

    public static String dealBase64Str(String spreadJson) {
        if (spreadJson.startsWith("base64")) {
            return spreadJson.substring(6);
        }
        return spreadJson;
    }

    public static JSONObject getSheetObject(JSONObject object) {
        return DataAndJsonTranslator.getSheetObject(object, DEFAULT_SHEET_NAME);
    }

    public static JSONObject getSheetObject(JSONObject object, String sheetname) {
        if (object == null) {
            return null;
        }
        if (sheetname == null) {
            sheetname = DEFAULT_SHEET_NAME;
        }
        JSONObject sheets = (JSONObject)object.get((Object)"sheets");
        JSONObject sheet = (JSONObject)sheets.values().iterator().next();
        if (sheets.containsKey((Object)sheetname)) {
            sheet = (JSONObject)sheets.get((Object)sheetname);
        }
        return sheet;
    }

    public static JSONObject getDataTable(JSONObject object, String sheetname) {
        if (object == null) {
            return null;
        }
        if (sheetname == null) {
            sheetname = DEFAULT_SHEET_NAME;
        }
        JSONObject sheets = (JSONObject)object.get((Object)"sheets");
        JSONObject sheet = (JSONObject)sheets.values().iterator().next();
        if (sheets.containsKey((Object)sheetname)) {
            sheet = (JSONObject)sheets.get((Object)sheetname);
        }
        JSONObject data = (JSONObject)sheet.get((Object)"data");
        return (JSONObject)data.get((Object)"dataTable");
    }

    public static String unCompressSpreadJson(String spreadJson) {
        if (StringUtils.isBlank((CharSequence)spreadJson)) {
            return "";
        }
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            String uncompress = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(DataAndJsonTranslator.dealBase64Str(spreadJson))));
            log.info("ParseSpreadJson uncompress compressLen:{} uncompressLen:{} cost:{}ms", new Object[]{spreadJson.length(), uncompress.length(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
            stopwatch.reset();
            stopwatch.start();
            long rowCount = DataAndJsonTranslator.getRowCountFromSpread(uncompress);
            long colCount = DataAndJsonTranslator.getColCountFromSpread(uncompress);
            log.info("ParseSpreadJson match rowCount:{} colCount:{} cost:{}ms", new Object[]{rowCount, colCount, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
            DataAndJsonTranslator.checkIsOverMaxCell(rowCount, colCount);
            return uncompress;
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private static void checkIsOverMaxCell(long rowCount, long colCount) {
        long cellCount = rowCount * colCount;
        int configMaxCell = (Integer)CommonUtils.getMetaDataFieldDefaultValue((String)"eb_global_param", (String)"templatemaxcell", () -> 200000);
        int templateMaxCell = Math.min(configMaxCell, 500000);
        if (cellCount > (long)templateMaxCell) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u5143\u683c\u6570\u8d85\u51fa\u6700\u5927\u9650\u5236\uff1a%1$s\uff0c\u8bf7\u51cf\u5c11\u884c\u6216\u5217\u3002", (String)"FixTemplateProcess_1", (String)"epm-eb-spread", (Object[])new Object[0]), templateMaxCell));
        }
    }

    public static Pair<Integer, Integer> getRowColCountFromSpread(String spreadJson) {
        String uncompress = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(DataAndJsonTranslator.dealBase64Str(spreadJson))));
        int rowCount = DataAndJsonTranslator.getRowCountFromSpread(uncompress);
        int colCount = DataAndJsonTranslator.getColCountFromSpread(uncompress);
        return Pair.of((Object)rowCount, (Object)colCount);
    }

    private static int getRowCountFromSpread(String spreadJson) {
        int rowCount = 0;
        try {
            Matcher rowMatcher = rowCountPattern.matcher(spreadJson);
            if (rowMatcher.find()) {
                rowCount = Integer.parseInt(rowMatcher.group(1));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return rowCount;
    }

    private static int getColCountFromSpread(String spreadJson) {
        int colCount = 0;
        try {
            Matcher colMatcher = colCountPattern.matcher(spreadJson);
            if (colMatcher.find()) {
                colCount = Integer.parseInt(colMatcher.group(1));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return colCount;
    }

    public static JSONObject fromSpreadJson(String spreadJson) {
        if (spreadJson != null) {
            String uncompress = DataAndJsonTranslator.unCompressSpreadJson(spreadJson);
            Stopwatch stopwatch = Stopwatch.createStarted();
            JSONObject jsonObject = JSON.parseObject((String)uncompress, (Feature[])new Feature[]{Feature.OrderedField});
            log.info("ParseSpreadJson toObj cost:{}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return jsonObject;
        }
        return null;
    }

    public static String toSpreadJson(JSONObject object) {
        byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)object.toJSONString()));
        String bbs = new String(bb);
        return "base64" + bbs;
    }

    public static List<Integer[]> getLockedCells(JSONObject spreadJson) {
        JSONObject dataTable = DataAndJsonTranslator.getDataTable(spreadJson, DEFAULT_SHEET_NAME);
        if (dataTable != null) {
            LinkedList<Integer[]> lockedRowCols = new LinkedList<Integer[]>();
            for (Map.Entry rowEntry : dataTable.entrySet()) {
                Integer r = Integer.valueOf(rowEntry.getKey() + "");
                JSONObject columns = (JSONObject)rowEntry.getValue();
                for (Map.Entry columnEntry : columns.entrySet()) {
                    Integer c = Integer.valueOf(columnEntry.getKey() + "");
                    JSONObject column = (JSONObject)columnEntry.getValue();
                    JSONObject style = column.getJSONObject("style");
                    if (style == null || style.get((Object)"locked") == null || !Boolean.TRUE.equals(style.get((Object)"locked"))) continue;
                    lockedRowCols.add(new Integer[]{r, c});
                }
            }
            return lockedRowCols;
        }
        return null;
    }

    public static String replaceOutlineElements(String sourceSerial, String targetSerial) {
        if (sourceSerial != null && targetSerial != null) {
            HashSet<String> elements = new HashSet<String>(2);
            try {
                JSONObject sourceJsonObject = DataAndJsonTranslator.fromSpreadJson(sourceSerial);
                JSONObject sourceSheet = DataAndJsonTranslator.getSheetObject(sourceJsonObject);
                if (sourceSheet == null) {
                    return targetSerial;
                }
                JSONObject outlines = null;
                for (String e : new String[]{ROWOUTLINES, COLUMNOUTLINES}) {
                    JSONArray outlineItems;
                    outlines = (JSONObject)sourceSheet.get((Object)e);
                    if (outlines == null || (outlineItems = (JSONArray)outlines.get((Object)"items")) == null || outlineItems.size() <= 0) continue;
                    elements.add(e);
                }
                if (!elements.isEmpty()) {
                    JSONObject targetJsonObject = DataAndJsonTranslator.fromSpreadJson(targetSerial);
                    JSONObject targetSheet = DataAndJsonTranslator.getSheetObject(targetJsonObject);
                    if (targetSheet == null) {
                        return targetSerial;
                    }
                    boolean replaced = false;
                    for (String element : elements) {
                        Object sourceElement = sourceSheet.get((Object)element);
                        Object targetElement = targetSheet.get((Object)element);
                        if (targetElement != null && sourceElement != null) {
                            targetSheet.replace((Object)element, sourceElement);
                            replaced = true;
                            continue;
                        }
                        if (targetElement == null && sourceElement != null) {
                            targetSheet.put(element, sourceElement);
                            replaced = true;
                            continue;
                        }
                        if (targetElement == null || sourceElement != null) continue;
                        targetSheet.remove((Object)element);
                        replaced = true;
                    }
                    if (replaced) {
                        return DataAndJsonTranslator.toSpreadJson(targetJsonObject);
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return targetSerial;
    }

    public static boolean templateHasOutLineElements(String serial) {
        if (StringUtils.isEmpty((CharSequence)serial)) {
            return false;
        }
        HashSet<String> elements = new HashSet<String>(2);
        JSONObject sourceJsonObject = DataAndJsonTranslator.fromSpreadJson(serial);
        JSONObject sourceSheet = DataAndJsonTranslator.getSheetObject(sourceJsonObject);
        if (sourceSheet == null) {
            return false;
        }
        JSONObject outlines = null;
        for (String e : new String[]{ROWOUTLINES, COLUMNOUTLINES}) {
            JSONArray outlineItems;
            outlines = (JSONObject)sourceSheet.get((Object)e);
            if (outlines == null || (outlineItems = (JSONArray)outlines.get((Object)"items")) == null || outlineItems.size() <= 0) continue;
            elements.add(e);
        }
        return !elements.isEmpty();
    }

    public static Point getSpreadRowAndColCount(JSONObject spreadJson) {
        if (spreadJson == null) {
            return null;
        }
        JSONObject sheets = DataAndJsonTranslator.getSheetObject(spreadJson);
        if (sheets != null && sheets.containsKey((Object)"rowCount") && sheets.containsKey((Object)"columnCount")) {
            Point point = new Point(sheets.getInteger("columnCount").intValue(), sheets.getInteger("rowCount").intValue());
            return point;
        }
        return null;
    }
}

