/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.adaptor;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.eventbus.EventBusUtil;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.FloatRows;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.Counter;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.RangeModel;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.impl.bizrule.event.CalcButtonEvent;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.OlapReportService;
import kd.epm.eb.olap.service.request.FloatQueryRequest;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.domain.view.js.SpreadProperties;
import kd.epm.eb.spread.template.DefaultTemplateModel;
import kd.epm.eb.spread.template.IBaseEntry;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.afix.multisetting.MultiAreaSetting;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spread.style.MetricCellStyleInfo;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.MetricCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.fix.FixSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.utils.AttachmentHelper;
import kd.epm.eb.spread.utils.DimPropertyHelper;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections4.CollectionUtils;

public class OlapQuerySync {
    private ITemplateModel templateModel;
    private IEbSpreadManager ebSpreadManager;
    private ISpreadContainer spreadContainer;
    private List<QueryRequest> queryRequests = new LinkedList<QueryRequest>();
    private int first_size = 8192;
    private ViewArea viewArea;
    private Map<String, Set<CellDimMember>> alldimensionWithMembers;
    private Map<String, List<String[]>> rowMemberRelMap;
    private IModelCacheHelper modelCacheHelper = null;
    private Set<Integer> refreshedRows;
    private Log log = LogFactory.getLog(OlapQuerySync.class);
    private Long processId;
    private String processType;
    private String currentOrgNumber;
    private String currentOrgLongNumber;
    private Set<Long> bizRules;
    private Map<String, String> relationGraphPointMemberMap;
    private MembersKey relationGraphPointMemberKey = new MembersKey();
    private boolean findRelationGraphPointCell = false;
    private final List<CellArea> relationGraphCellAreas = new ArrayList<CellArea>(16);
    private AreasStyle relationGraphAreasStyle = null;
    private Long rptEntityId;
    private List<Map<String, Set<String>>> filterMemberNumberList;
    private boolean isExport = false;
    private boolean isRuleExecution;
    private boolean issync;
    private String pageid;
    private boolean syncSuccessed;
    private Map<String, Integer> dimIndex = null;

    public OlapQuerySync(ITemplateModel templateModel, IEbSpreadManager ebSpreadManager, ISpreadContainer spreadContainer, String pageid, ViewArea viewArea, Set<Integer> refreshedRows, Map<String, Set<CellDimMember>> alldimensionWithMembers, Map<String, List<String[]>> rowMemberRelMap, IModelCacheHelper modelCacheHelper) {
        this.viewArea = viewArea;
        this.templateModel = templateModel;
        this.ebSpreadManager = ebSpreadManager;
        this.spreadContainer = spreadContainer;
        this.refreshedRows = refreshedRows;
        this.alldimensionWithMembers = alldimensionWithMembers;
        this.rowMemberRelMap = rowMemberRelMap;
        this.modelCacheHelper = modelCacheHelper;
        this.pageid = pageid;
        this.initQueryInfo();
    }

    public OlapQuerySync(ITemplateModel templateModel, IEbSpreadManager ebSpreadManager, ISpreadContainer spreadContainer, IModelCacheHelper modelCacheHelper) {
        this.templateModel = templateModel;
        this.ebSpreadManager = ebSpreadManager;
        this.spreadContainer = spreadContainer;
        this.modelCacheHelper = modelCacheHelper;
    }

    public void setIsRuleExecution(boolean isRuleExecution) {
        this.isRuleExecution = isRuleExecution;
    }

    public boolean getIsRuleExecution() {
        return this.isRuleExecution;
    }

    public Long getProcessId() {
        return this.processId;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }

    public Long getRptEntityId() {
        return this.rptEntityId;
    }

    public void setRptEntityId(Long rptEntityId) {
        this.rptEntityId = rptEntityId;
    }

    public String getProcessType() {
        return this.processType;
    }

    public void setProcessType(String processType) {
        this.processType = processType;
    }

    public String getCurrentOrgNumber() {
        return this.currentOrgNumber;
    }

    public void setCurrentOrgNumber(String currentOrgNumber) {
        this.currentOrgNumber = currentOrgNumber;
    }

    public String getCurrentOrgLongNumber() {
        return this.currentOrgLongNumber;
    }

    public void setCurrentOrgLongNumber(String currentOrgLongNumber) {
        this.currentOrgLongNumber = currentOrgLongNumber;
    }

    public Set<Long> getBizRules() {
        return this.bizRules;
    }

    public void setBizRules(Set<Long> bizRules) {
        this.bizRules = bizRules;
    }

    public Map<String, String> getRelationGraphPointMemberMap() {
        return this.relationGraphPointMemberMap;
    }

    public void setRelationGraphPointMemberMap(Map<String, String> relationGraphPointMemberMap) {
        this.relationGraphPointMemberMap = relationGraphPointMemberMap;
    }

    public boolean isFindRelationGraphPointCell() {
        return this.findRelationGraphPointCell;
    }

    public AreasStyle getRelationGraphAreasStyle() {
        return this.relationGraphAreasStyle;
    }

    public List<Map<String, Set<String>>> getFilterMemberNumberList() {
        return this.filterMemberNumberList;
    }

    public void setFilterMemberNumberList(List<Map<String, Set<String>>> filterMemberNumberList) {
        this.filterMemberNumberList = filterMemberNumberList;
    }

    public List<FloatRows> onlyQueryFloatMembers() {
        if (!(this.getEbSpreadManager().isHasFloat() && this.templateModel instanceof FixTemplateModel && this.ebSpreadManager instanceof FixSpreadManager)) {
            return null;
        }
        LinkedList<FloatQueryRequest> requests = new LinkedList<FloatQueryRequest>();
        FixTemplateModel fixTemplateModel = (FixTemplateModel)this.templateModel;
        FixSpreadManager fixSpreadManager = (FixSpreadManager)this.ebSpreadManager;
        Long modelId = fixTemplateModel.getModelId();
        Long datasetId = fixTemplateModel.getTemplateBaseInfo().getDatasetID();
        HashSet rowcolDims = new HashSet(this.templateModel.getRowcolDims());
        HashMap pageViewDimMems = new HashMap(16);
        this.ebSpreadManager.getAlldimensionWithMembers().forEach((k, v) -> {
            if (!rowcolDims.contains(k)) {
                pageViewDimMems.put(k, new HashSet(v));
            }
        });
        Map varValus = null;
        if (IDUtils.isNotNull((Long)this.getProcessId())) {
            varValus = ReportVarUtil.getVarValues((String)this.getProcessType(), (Long)this.templateModel.getModelId(), (Long)this.getProcessId(), (String)this.templateModel.getTemplateBaseInfo().getVarBase());
        }
        List multiAreaManagers = fixSpreadManager.getMultiAreaManager();
        List<Map<String, Set<String>>> filterMemberNumberList = this.getFilterMemberNumberList();
        HashMap<String, Set> filterDimMemers = new HashMap<String, Set>(16);
        HashSet<String> needClearDim = new HashSet<String>(16);
        HashSet<String> allFilterKeys = new HashSet<String>(16);
        if (CollectionUtils.isNotEmpty(filterMemberNumberList)) {
            for (Map<String, Set<String>> filter : filterMemberNumberList) {
                if (filter.containsKey("templateFilter")) continue;
                allFilterKeys.addAll(filter.keySet());
            }
            for (Map<String, Set<String>> filter : filterMemberNumberList) {
                if (!filter.containsKey("templateFilter")) {
                    for (String string : allFilterKeys) {
                        Set<String> strings = filter.get(string);
                        if (CollectionUtils.isEmpty(strings)) {
                            needClearDim.add(string);
                            continue;
                        }
                        Set members = filterDimMemers.computeIfAbsent(string, k -> new HashSet(16));
                        members.addAll(strings);
                    }
                    continue;
                }
                for (Map.Entry entry : filter.entrySet()) {
                    Set members = filterDimMemers.computeIfAbsent((String)entry.getKey(), k -> new HashSet(16));
                    members.addAll((Collection)entry.getValue());
                }
            }
            if (CollectionUtils.isNotEmpty(needClearDim)) {
                for (String key : needClearDim) {
                    filterDimMemers.remove(key);
                }
            }
        }
        for (IMultiAreaSetting multiAreaSetting : fixTemplateModel.getAreaRanges()) {
            MultiAreaManager multiAreaManager;
            String areaIndex = multiAreaSetting.getAreaRangeStart();
            if (multiAreaSetting.getFloatOnWhere() != 0 || (multiAreaManager = multiAreaManagers.stream().filter(e -> e.getAreaIndex().equals(areaIndex)).findFirst().orElseGet(null)) == null) continue;
            int partitionSeq = 0;
            for (MultiAreaSetting.FloatInfo floatInfo : multiAreaSetting.getFloatInfos()) {
                String dimNumber;
                FloatQueryRequest request = new FloatQueryRequest();
                request.setModelId(modelId);
                request.setDatasetId(datasetId);
                request.setNumber(areaIndex);
                request.setSeq(partitionSeq++);
                request.setRangeType(floatInfo.getRangeType());
                request.setFilterTopItems(floatInfo.isFilterTopItems());
                LinkedList<String> floatDims = new LinkedList<String>();
                FloatQueryRequest.FixedDim fixedDim = new FloatQueryRequest.FixedDim();
                fixedDim.setDimNumbers(new LinkedList());
                fixedDim.setMemberNumbers(new LinkedList());
                Map<String, PageViewDimMember> apv = multiAreaManager.getAreaPageViewDims();
                LinkedList<String> apvMems = new LinkedList<String>();
                if (apv != null && apv.size() > 0) {
                    for (Map.Entry entry : apv.entrySet()) {
                        if (entry.getKey() == null || entry.getValue() == null) continue;
                        fixedDim.getDimNumbers().add(entry.getKey());
                        apvMems.add(((PageViewDimMember)entry.getValue()).getNumber());
                    }
                }
                fixedDim.getDimNumbers().addAll(multiAreaManager.getColpartitionDims());
                for (List list : multiAreaManager.getColpartitionDimMems()) {
                    if (list != null && !list.contains(null)) {
                        List mems = list.stream().filter(e -> !e.isProperty()).map(CellDimMember::getDimMemberNumber).collect(Collectors.toList());
                        if (apvMems.size() > 0) {
                            LinkedList fixMems = new LinkedList(apvMems);
                            fixMems.addAll(mems);
                            fixedDim.getMemberNumbers().add(fixMems);
                            continue;
                        }
                        fixedDim.getMemberNumbers().add(mems);
                        continue;
                    }
                    throw new KDBizException(ResManager.loadResFormat((String)"\u62a5\u8868\u6a21\u677f\u5728\u6d6e\u52a8\u6570\u636e\u533a\u57df%1\u4e2d\u5217\u7ef4\u6210\u5458\u8bbe\u7f6e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u8bbe\u7f6e\u5e76\u91cd\u65b0\u53d1\u5e03\u3002", (String)"OlapQuerySync_8", (String)"epm-eb-spread", (Object[])new Object[]{multiAreaManager.getAreaIndex()}));
                }
                if (fixedDim.getMemberNumbers().isEmpty()) continue;
                request.setFixedDim(fixedDim);
                HashMap<String, Long> dimViews = new HashMap<String, Long>(16);
                HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>(pageViewDimMems);
                if (multiAreaManager.getAreaPageViewDims() != null && !multiAreaManager.getAreaPageViewDims().isEmpty()) {
                    multiAreaManager.getAreaPageViewDims().forEach((k, v) -> {
                        Set cfr_ignored_0 = memberInfo.put((String)k, Sets.newHashSet((Object[])new String[]{v.getNumber()}));
                    });
                }
                for (int i = 0; i < multiAreaManager.getColpartitionDims().size(); ++i) {
                    dimNumber = multiAreaManager.getColpartitionDims().get(i);
                    for (int j = 0; j < multiAreaManager.getColpartitionDimMems().size(); ++j) {
                        Set memNumbers = hashMap.computeIfAbsent(dimNumber, f -> new HashSet());
                        CellDimMember cellDimMember = multiAreaManager.getColpartitionDimMems().get(j).get(i);
                        if (cellDimMember == null) continue;
                        memNumbers.add(cellDimMember.getDimMemberNumber());
                    }
                }
                for (IRowColDimensionEntry rowColDimensionEntry : floatInfo.getPartition().getRowColDimensionEntries()) {
                    String memNumber;
                    dimNumber = rowColDimensionEntry.getDimension().getNumber();
                    List dimMembers = rowColDimensionEntry.getMembers();
                    if (dimNumber == null || dimMembers == null || dimMembers.isEmpty()) continue;
                    Long dimensionViewId = DimensionViewServiceHelper.getViewId((Map)this.templateModel.getDimemsionViews(), (Long)datasetId, (String)dimNumber, (String)areaIndex);
                    dimViews.put(dimNumber, dimensionViewId);
                    if (rowColDimensionEntry.isFloat()) {
                        floatDims.add(dimNumber);
                        Set memNumbers = hashMap.computeIfAbsent(dimNumber, f -> new HashSet());
                        for (IDimensionMember dimMember : dimMembers) {
                            memNumber = ReportVarUtil.getRealDimByVar((Long)this.templateModel.getModelId(), (String)dimMember.getNumber(), (String)dimNumber, (Map)varValus);
                            List cacheMems = this.modelCacheHelper.getMember(dimNumber, dimensionViewId, memNumber, dimMember.getScope());
                            if (cacheMems == null) continue;
                            if (floatInfo.getRangeType() == 0) {
                                Optional<Member> first = cacheMems.stream().filter(x -> !x.isLeaf()).findFirst();
                                if (first.isPresent()) {
                                    request.setRangeType(1);
                                } else {
                                    cacheMems = cacheMems.stream().filter(e -> e.isLeaf()).collect(Collectors.toList());
                                }
                            }
                            List collect = null;
                            collect = this.getCurrentOrgLongNumber() != null && SysDimensionEnum.Entity.getNumber().equals(dimNumber) ? cacheMems.stream().filter(e -> e.getNumber() != null && e.getNumber().equals(this.getCurrentOrgNumber()) || e.getLongNumber() != null && e.getLongNumber().startsWith(this.getCurrentOrgLongNumber() + "!")).map(BaseCache::getNumber).collect(Collectors.toList()) : cacheMems.stream().map(BaseCache::getNumber).collect(Collectors.toList());
                            memNumbers.addAll(collect);
                        }
                        Set strings = (Set)filterDimMemers.get(dimNumber);
                        if (!CollectionUtils.isNotEmpty((Collection)strings)) continue;
                        memNumbers.retainAll(strings);
                        continue;
                    }
                    memNumber = ReportVarUtil.getRealDimByVar((Long)this.templateModel.getModelId(), (String)((IDimensionMember)dimMembers.get(0)).getNumber(), (String)dimNumber, (Map)varValus);
                    Set strings = (Set)filterDimMemers.get(dimNumber);
                    Member member = this.modelCacheHelper.getMember(dimNumber, dimensionViewId, memNumber);
                    if (floatInfo.getRangeType() == 0 && !member.isLeaf()) {
                        request.setRangeType(1);
                    }
                    if (CollectionUtils.isEmpty((Collection)strings) || strings.contains(memNumber)) {
                        hashMap.put(dimNumber, Sets.newHashSet((Object[])new String[]{memNumber}));
                        continue;
                    }
                    hashMap.put(dimNumber, Sets.newHashSet());
                }
                request.setFloatDims(floatDims);
                request.setMemberInfo(hashMap);
                request.setViewMap(DimensionViewServiceHelper.getViewIds((Map)this.ebSpreadManager.getDimemsionViews(), (String)areaIndex));
                if (request.getRangeType() == 1 && request.isFilterTopItems() && !ModelServiceHelper.isUserHasRootPermByModel((long)UserUtils.getUserId(), (Long)request.getModelId())) {
                    OlapQuerySync.filterTopItems(this.modelCacheHelper, floatDims, hashMap, dimViews);
                }
                requests.add(request);
            }
        }
        Iterator iterator = requests.iterator();
        while (iterator.hasNext()) {
            FloatQueryRequest request = (FloatQueryRequest)iterator.next();
            Map memberInfo = request.getMemberInfo();
            memberInfo.forEach((k, v) -> v.removeIf(StringUtils::isEmpty));
            boolean bl = memberInfo.values().stream().anyMatch(v -> CollectionUtils.isEmpty((Collection)v));
            if (!bl) continue;
            CommonServiceHelper.handleLog((Log)this.log, (String)"emptyDim", (String)JSONUtils.toString((Object)memberInfo));
            iterator.remove();
        }
        try {
            List floatMember = OlapReportService.getInstance().getFloatMember(this.templateModel.getTemplateBaseInfo().getId().longValue(), requests, this.templateModel.getTemplateBaseInfo().getFloatcalculate());
            if (CollectionUtils.isEmpty((Collection)floatMember)) {
                return Collections.emptyList();
            }
            if (CollectionUtils.isEmpty(filterMemberNumberList) || CollectionUtils.isEmpty(needClearDim)) {
                return floatMember;
            }
            for (FloatRows floatRows : floatMember) {
                List list = floatRows.getFloatDims();
                List floatRowList = floatRows.getFloatRows();
                Iterator iterator2 = floatRowList.iterator();
                while (iterator2.hasNext()) {
                    FloatRows.FloatRow next = (FloatRows.FloatRow)iterator2.next();
                    List colItems = next.getColItems();
                    HashSet<Boolean> templateViasbleSet = new HashSet<Boolean>(2);
                    HashSet<Boolean> centrelViasbleSet = new HashSet<Boolean>(2);
                    for (Map<String, Set<String>> filter : filterMemberNumberList) {
                        boolean templateFilter = filter.containsKey("templateFilter");
                        boolean bl = true;
                        for (Map.Entry<String, Set<String>> filterValue : filter.entrySet()) {
                            boolean contains;
                            int index = list.indexOf(filterValue.getKey());
                            if (index == -1 || (contains = filterValue.getValue().contains(colItems.get(index)))) continue;
                            bl = false;
                            break;
                        }
                        if (templateFilter) {
                            templateViasbleSet.add(bl);
                            continue;
                        }
                        centrelViasbleSet.add(bl);
                    }
                    if (CollectionUtils.isNotEmpty(centrelViasbleSet) && CollectionUtils.isNotEmpty(templateViasbleSet)) {
                        if (centrelViasbleSet.contains(true) && templateViasbleSet.contains(true)) continue;
                        iterator2.remove();
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty(centrelViasbleSet)) {
                        if (centrelViasbleSet.contains(true)) continue;
                        iterator2.remove();
                        continue;
                    }
                    if (!CollectionUtils.isNotEmpty(templateViasbleSet) || templateViasbleSet.contains(true)) continue;
                    iterator2.remove();
                }
            }
            return floatMember;
        }
        catch (Exception ex) {
            this.log.error("budget-olap-log : ", (Throwable)ex);
            throw new KDBizException(ResManager.loadResFormat((String)"olap\u67e5\u8be2\u6d6e\u52a8\u6210\u5458\u5931\u8d25\uff0c%1", (String)"OlapQuerySync_5", (String)"epm-eb-spread", (Object[])new Object[]{ThrowableHelper.getMessage((Exception)ex)}));
        }
    }

    public static void filterTopItems(IModelCacheHelper modelCacheHelper, List<String> floatDims, Map<String, Set<String>> memberInfo, Map<String, Long> dimViews) {
        if (modelCacheHelper != null && floatDims != null && memberInfo != null) {
            Set<String> memNumbers = null;
            Object memLongNumbers = null;
            ArrayList<Member> members = null;
            for (String dimNumber : floatDims) {
                memNumbers = memberInfo.get(dimNumber);
                if (memNumbers == null || memNumbers.size() <= 1) continue;
                HashSet<String> topMemNumbers = new HashSet<String>(16);
                members = new ArrayList<Member>(modelCacheHelper.getMembers(dimNumber, dimViews == null ? null : dimViews.get(dimNumber), memNumbers));
                members.sort(Comparator.comparing(Member::getLongNumber));
                String prevLongNum = "";
                for (Member member : members) {
                    if (member.getLongNumber().startsWith(prevLongNum + "!")) continue;
                    topMemNumbers.add(member.getNumber());
                    prevLongNum = member.getLongNumber();
                }
                memberInfo.put(dimNumber, topMemNumbers);
            }
        }
    }

    public Map<MembersKey, Object> onlyQueryData(Counter counter, boolean isOnlyDetail) {
        return this.getDataByQueryInfo(counter, isOnlyDetail);
    }

    public Map<MembersKey, Object> onlyQueryData(Counter counter, boolean isOnlyDetail, boolean isExport) {
        this.isExport = isExport;
        return this.getDataByQueryInfo(counter, isOnlyDetail);
    }

    public Map<String, Set<CellDimMember>> getAlldimensionWithMembers() {
        if (this.alldimensionWithMembers == null && this.viewArea == null) {
            return this.getAlldimensionWithMembersFromSM();
        }
        return this.alldimensionWithMembers;
    }

    private Map<String, Set<CellDimMember>> getAlldimensionWithMembersFromSM() {
        if (this.ebSpreadManager == null || this.ebSpreadManager.getAlldimensionWithMembers() == null) {
            return null;
        }
        HashMap<String, Set<CellDimMember>> result = new HashMap<String, Set<CellDimMember>>(this.ebSpreadManager.getAlldimensionWithMembers().size());
        for (Map.Entry entry : this.ebSpreadManager.getAlldimensionWithMembers().entrySet()) {
            if (entry.getValue() == null) continue;
            result.computeIfAbsent((String)entry.getKey(), (Function<String, Set<CellDimMember>>)((Function<String, Set>)f -> this.toSetCellDimMember((Set)entry.getValue())));
        }
        return result;
    }

    private Set<CellDimMember> toSetCellDimMember(Set<String> origin) {
        if (origin != null) {
            HashSet<CellDimMember> target = new HashSet<CellDimMember>(origin.size());
            origin.forEach(e -> target.add(new CellDimMember(e)));
            return target;
        }
        return null;
    }

    public void runSync(String pageid) {
        this.issync = true;
        this.pageid = pageid;
        this.refreshCellData();
    }

    public void refreshCellData() {
        this.refreshCellData(false);
    }

    public int refreshCellData(boolean isOnlyDetail) {
        Counter counter = new Counter();
        Map<MembersKey, Object> datas = this.getDataByQueryInfo(counter, isOnlyDetail);
        if (counter.getSize() >= 0) {
            if (this.issync && !Thread.currentThread().getName().startsWith(new PageCache(this.pageid).get("currentThread"))) {
                this.log.info("\u52a8\u6001\u62a5\u8868\u540e\u53f0\u5237\u6570\u7ebf\u7a0b\u88ab\u63d0\u524d\u53d6\u6d88" + Thread.currentThread().getName());
                return 0;
            }
            new OlapDataProcess(datas, counter.getSize()).refreshCellData();
        }
        if (datas != null) {
            return datas.size();
        }
        return 0;
    }

    public Map<MembersKey, Object> getDataByQueryInfo(Counter counter, boolean isOnlyDetail) {
        if (this.queryRequests == null || this.queryRequests.isEmpty()) {
            counter.setSize(-1);
            return null;
        }
        List bgCells = null;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)this.templateModel.getTemplateBaseInfo().getId(), (String)"eb_templateentity");
        bgCells = this.isExport ? OlapReportService.getInstance().export(this.templateModel.getTemplateBaseInfo().getId().longValue(), this.queryRequests) : (dynamicObject != null ? OlapReportService.getInstance().reportQuery(this.templateModel.getTemplateBaseInfo().getId().longValue(), this.queryRequests) : OlapReportService.getInstance().reportQuery(this.getBizRules(), this.queryRequests));
        if (this.isRuleExecution) {
            Long modelId = this.modelCacheHelper.getModelobj().getId();
            Long datasetId = this.templateModel.getTemplateBaseInfo().getDatasetID();
            Map alldimensionWithMembers = this.ebSpreadManager.getAlldimensionWithMembers();
            List leafCells = OlapCommService.getInstance().queryLeafList(new QueryRequest(modelId, datasetId, alldimensionWithMembers));
            this.log.info("\u67e5\u8be2\u6240\u6709\u660e\u7ec6\u6570\u636e:" + leafCells.size());
            EventBusUtil.post((Object)new CalcButtonEvent(modelId, datasetId, leafCells));
        }
        return this.convertToMembersKeyMap(counter, bgCells, this.getDimIndex());
    }

    private Map<MembersKey, Object> convertToMembersKeyMap(Counter counter, List<BGCell> bgCellList, Map<String, Integer> dimindexs) {
        if (bgCellList == null || dimindexs == null) {
            return null;
        }
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)bgCellList.size());
        for (BGCell bgCell : bgCellList) {
            Object[] keys = new String[dimindexs.size() + 1];
            for (Map.Entry entry : bgCell.getMemberMap().entrySet()) {
                keys[dimindexs.get(entry.getKey()).intValue()] = (String)entry.getValue();
            }
            returnMap.put(new MembersKey(keys), bgCell.getValue());
            counter.setSize(counter.getSize() + 1);
        }
        return returnMap;
    }

    private void initQueryInfo() {
        if (this.templateModel instanceof FixTemplateModel) {
            this.initQueryInfo_fix((FixTemplateModel)this.templateModel);
        } else if (this.templateModel instanceof DefaultTemplateModel) {
            this.initQueryInfo_dy((DefaultTemplateModel)this.templateModel);
        }
        this.checkQueryInfo();
    }

    private void checkQueryInfo() {
        for (QueryRequest queryRequest : this.queryRequests) {
            Map memberInfo = queryRequest.getMemberInfo();
            HashMap memberInfoCopy = Maps.newHashMapWithExpectedSize((int)memberInfo.size());
            for (Map.Entry entry : memberInfo.entrySet()) {
                Set value = (Set)entry.getValue();
                HashSet valueCopy = Sets.newHashSet((Iterable)value);
                valueCopy.removeIf(StringUtils::isEmpty);
                if (CollectionUtils.isEmpty((Collection)valueCopy)) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a\uff1a%1 \u7684\u7ef4\u5ea6\u6ca1\u6709\u6709\u6743\u7684\u6210\u5458\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"FixSpreadManager_0", (String)"epm-eb-spread", (Object[])new Object[]{entry.getKey()}));
                }
                memberInfoCopy.put(entry.getKey(), valueCopy);
            }
            queryRequest.setMemberInfo((Map)memberInfoCopy);
        }
    }

    private void initQueryInfo_fix(FixTemplateModel fixTemplateModel) {
        if (fixTemplateModel == null || fixTemplateModel.getAreaRanges().isEmpty()) {
            return;
        }
        Long modelId = this.modelCacheHelper.getModelobj().getId();
        Long datasetId = this.templateModel.getTemplateBaseInfo().getDatasetID();
        LinkedList<String> selectDims = new LinkedList<String>(this.alldimensionWithMembers.keySet());
        Map<String, Long> dimensionViews = this.ebSpreadManager.getDimemsionViews();
        HashMap partRowDimMap = new HashMap(16);
        fixTemplateModel.getAreaRanges().forEach(areaSetting -> {
            String partitionKey = "";
            String areaRange = areaSetting.getAreaRange();
            String[] split = areaRange.split(":");
            if (split.length == 2) {
                partitionKey = split[0];
            }
            if (StringUtils.isEmpty((String)partitionKey)) {
                return;
            }
            partRowDimMap.put(partitionKey, areaSetting.getRowdims());
        });
        if (fixTemplateModel.getAreaRanges().size() > 1) {
            String dimNumber;
            List rowColDims = fixTemplateModel.getRowcolDims();
            HashMap<String, Map<String, List<CellDimMember>>> partitionMap_byDimNum = new HashMap<String, Map<String, List<CellDimMember>>>(16);
            HashMap<String, Map> partitionMap_byPartNum = new HashMap<String, Map>(16);
            HashMap<String, String> hashMap = new HashMap<String, String>(16);
            for (Map.Entry<String, Set<CellDimMember>> entry : this.alldimensionWithMembers.entrySet()) {
                dimNumber = entry.getKey();
                Set<CellDimMember> value = entry.getValue();
                if (!CollectionUtils.isNotEmpty(value)) continue;
                if (rowColDims.contains(dimNumber)) {
                    partitionMap_byDimNum.put(dimNumber, entry.getValue().stream().collect(Collectors.groupingBy(CellDimMember::getPartition)));
                    continue;
                }
                hashMap.put(dimNumber, entry.getValue().iterator().next().getDimMemberNumber());
            }
            for (Map.Entry<String, Set<Object>> entry : partitionMap_byDimNum.entrySet()) {
                dimNumber = entry.getKey();
                for (Map.Entry entry2 : ((Map)((Object)entry.getValue())).entrySet()) {
                    String partNumber = (String)entry2.getKey();
                    Map allDimMemsInPartition = partitionMap_byPartNum.computeIfAbsent(partNumber, k -> new HashMap(16));
                    allDimMemsInPartition.put(dimNumber, entry2.getValue());
                }
            }
            for (Map.Entry<String, Set<Object>> entry : partitionMap_byPartNum.entrySet()) {
                String partitionKey = entry.getKey();
                Map map = (Map)((Object)entry.getValue());
                HashMap memberInfo = new HashMap(16);
                map.forEach((k, v) -> memberInfo.put(k, v.stream().map(CellDimMember::getDimMemberNumber).collect(Collectors.toSet())));
                hashMap.forEach((k, v) -> {
                    Set cfr_ignored_0 = memberInfo.put(k, Sets.newHashSet((Object[])new String[]{v}));
                });
                if (memberInfo.size() != selectDims.size()) {
                    this.log.info("remove request memberInfo key:" + JSONUtils.toString(memberInfo.keySet()) + "selectDims" + selectDims);
                    continue;
                }
                QueryRequest queryRequest = new QueryRequest(modelId, datasetId, this.extractDimensionViewsByPartition(dimensionViews, partitionKey, null), memberInfo, selectDims);
                queryRequest.setRowMemberRelDims(partRowDimMap.getOrDefault(partitionKey, Collections.emptyList()));
                queryRequest.setRowMemberRelList(this.rowMemberRelMap.getOrDefault(partitionKey, Collections.emptyList()));
                this.queryRequests.add(queryRequest);
            }
        } else {
            Object areaRange;
            String[] stringArray;
            HashMap memberInfo = new HashMap(16);
            String partitionKey = null;
            if (this.templateModel.getAreaRanges().size() > 0 && (stringArray = ((String)(areaRange = ((IMultiAreaSetting)this.templateModel.getAreaRanges().get(0)).getAreaRange())).split(":")).length == 2) {
                partitionKey = stringArray[0];
            }
            for (Map.Entry entry : this.alldimensionWithMembers.entrySet()) {
                if (entry.getValue() != null && ((Set)entry.getValue()).size() > 0) {
                    memberInfo.put(entry.getKey(), ((Set)entry.getValue()).stream().map(CellDimMember::getDimMemberNumber).collect(Collectors.toSet()));
                    continue;
                }
                throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a\uff1a%1 \u7684\u7ef4\u5ea6\u6ca1\u6709\u6709\u6743\u7684\u6210\u5458\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"FixSpreadManager_0", (String)"epm-eb-spread", (Object[])new Object[]{entry.getKey()}));
            }
            QueryRequest queryRequest = new QueryRequest(modelId, datasetId, (Map)(StringUtils.isEmpty(partitionKey) ? dimensionViews : this.extractDimensionViewsByPartition(dimensionViews, partitionKey, null)), memberInfo, selectDims);
            queryRequest.setRowMemberRelDims(partRowDimMap.getOrDefault(partitionKey, Collections.emptyList()));
            queryRequest.setRowMemberRelList(this.rowMemberRelMap.getOrDefault(partitionKey, Collections.emptyList()));
            this.queryRequests.add(queryRequest);
        }
        Iterator<QueryRequest> iterator = this.queryRequests.iterator();
        while (iterator.hasNext()) {
            QueryRequest request = iterator.next();
            Map memberInfo = request.getMemberInfo();
            memberInfo.forEach((k, v) -> v.removeIf(StringUtils::isEmpty));
            boolean bl = memberInfo.values().stream().anyMatch(CollectionUtils::isEmpty);
            if (!bl) continue;
            this.log.info("remove request:{}", (Object)request);
            iterator.remove();
        }
    }

    private void initQueryInfo_dy(DefaultTemplateModel templateModel) {
        if (templateModel == null) {
            return;
        }
        Long modelId = this.modelCacheHelper.getModelobj().getId();
        Long datasetId = templateModel.getTemplateBaseInfo().getDatasetID();
        LinkedList<String> selectDims = new LinkedList<String>(this.alldimensionWithMembers.keySet());
        Map dimensionViews = this.ebSpreadManager.getDimemsionViews();
        boolean isNeedPartition = false;
        if (dimensionViews != null && dimensionViews.keySet().stream().anyMatch(k -> k.contains("_"))) {
            String dimNumber;
            int partNum = 0;
            for (Object rcp : templateModel.getPartitionSetting().getRowPartition()) {
                for (IRowColDimensionEntry rcde : rcp.getRowColDimensionEntries()) {
                    dimNumber = rcde.getDimension().getNumber();
                    if (!SysDimensionEnum.Entity.getNumber().equals(dimNumber) && !SysDimensionEnum.ChangeType.getNumber().equals(dimNumber) && !"epm_userdefinedmembertree".equals(rcde.getDimension().getMemberModel())) continue;
                    dimensionViews.computeIfAbsent(dimNumber + "_" + "r" + partNum, f -> IDUtils.toLong(this.ebSpreadManager.getDimemsionViews().get(rcde.getDimension().getNumber())));
                }
                ++partNum;
            }
            partNum = 0;
            for (Object rcp : templateModel.getPartitionSetting().getColPartition()) {
                for (IRowColDimensionEntry rcde : rcp.getRowColDimensionEntries()) {
                    dimNumber = rcde.getDimension().getNumber();
                    if (!SysDimensionEnum.Entity.getNumber().equals(dimNumber) && !SysDimensionEnum.ChangeType.getNumber().equals(dimNumber) && !"epm_userdefinedmembertree".equals(rcde.getDimension().getMemberModel())) continue;
                    dimensionViews.computeIfAbsent(dimNumber + "_" + "c" + partNum, f -> IDUtils.toLong(this.ebSpreadManager.getDimemsionViews().get(rcde.getDimension().getNumber())));
                }
                ++partNum;
            }
            HashMap checkMap = new HashMap(16);
            for (Map.Entry entry : dimensionViews.entrySet()) {
                dimNumber = ((String)entry.getKey()).split("_")[0];
                if (!checkMap.containsKey(dimNumber)) {
                    checkMap.put(dimNumber, entry.getValue());
                    continue;
                }
                if (IDUtils.equals(checkMap.get(dimNumber), entry.getValue())) continue;
                isNeedPartition = true;
                break;
            }
        }
        List rowDimList = this.ebSpreadManager.getRowpartitionDims();
        if (isNeedPartition) {
            Map allDimMemsInPartition;
            String partNumber;
            String dimNumber;
            List rowDimNums = templateModel.getAreaRangeEntry().getRowdimensions().stream().map(IBaseEntry::getNumber).collect(Collectors.toList());
            List colDimNums = templateModel.getAreaRangeEntry().getColdimensions().stream().map(IBaseEntry::getNumber).collect(Collectors.toList());
            Boolean isMetricInRow = templateModel.getAreaRangeEntry().isMetricInRow();
            HashMap<String, Map<String, List<CellDimMember>>> hashMap = new HashMap<String, Map<String, List<CellDimMember>>>(16);
            HashMap<String, Map> rowPartitionMap_byPartNum = new HashMap<String, Map>(16);
            HashMap<String, Map<String, List<CellDimMember>>> colPartitionMap_byDimNum = new HashMap<String, Map<String, List<CellDimMember>>>(16);
            HashMap<String, Map> colPartitionMap_byPartNum = new HashMap<String, Map>(16);
            HashMap<String, String> pageViewDimMems = new HashMap<String, String>(16);
            for (Map.Entry<String, Set<CellDimMember>> entry : this.alldimensionWithMembers.entrySet()) {
                if (rowDimNums.contains(entry.getKey()) || SysDimensionEnum.Metric.getNumber().equals(entry.getKey()) && Boolean.TRUE.equals(isMetricInRow)) {
                    hashMap.put(entry.getKey(), entry.getValue().stream().collect(Collectors.groupingBy(e -> e.getPartition() == null ? "" : e.getPartition())));
                    continue;
                }
                if (colDimNums.contains(entry.getKey()) || SysDimensionEnum.Metric.getNumber().equals(entry.getKey()) && Boolean.FALSE.equals(isMetricInRow)) {
                    colPartitionMap_byDimNum.put(entry.getKey(), entry.getValue().stream().collect(Collectors.groupingBy(e -> e.getPartition() == null ? "" : e.getPartition())));
                    continue;
                }
                if (entry.getValue() != null && !entry.getValue().isEmpty()) {
                    pageViewDimMems.put(entry.getKey(), entry.getValue().iterator().next().getDimMemberNumber());
                    continue;
                }
                throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a\uff1a%1 \u7684\u7ef4\u5ea6\u6ca1\u6709\u6709\u6743\u7684\u6210\u5458\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"FixSpreadManager_0", (String)"epm-eb-spread", (Object[])new Object[]{entry.getKey()}));
            }
            for (Map.Entry<String, Set<Object>> entry : hashMap.entrySet()) {
                dimNumber = entry.getKey();
                for (Map.Entry partEntry : ((Map)((Object)entry.getValue())).entrySet()) {
                    partNumber = (String)partEntry.getKey();
                    allDimMemsInPartition = rowPartitionMap_byPartNum.computeIfAbsent(partNumber, k -> new HashMap(16));
                    allDimMemsInPartition.put(dimNumber, partEntry.getValue());
                }
            }
            for (Map.Entry<String, Set<Object>> entry : colPartitionMap_byDimNum.entrySet()) {
                dimNumber = entry.getKey();
                for (Map.Entry partEntry : ((Map)((Object)entry.getValue())).entrySet()) {
                    partNumber = (String)partEntry.getKey();
                    allDimMemsInPartition = colPartitionMap_byPartNum.computeIfAbsent(partNumber, k -> new HashMap(16));
                    allDimMemsInPartition.put(dimNumber, partEntry.getValue());
                }
            }
            for (Map.Entry<String, Set<Object>> entry : rowPartitionMap_byPartNum.entrySet()) {
                String rowPartition = entry.getKey();
                Map rowDimMems = (Map)((Object)entry.getValue());
                for (Map.Entry colEntry : colPartitionMap_byPartNum.entrySet()) {
                    String colPartition = (String)colEntry.getKey();
                    Map colDimMems = (Map)colEntry.getValue();
                    HashMap memberInfo = new HashMap(16);
                    rowDimMems.forEach((k, v) -> memberInfo.put(k, v.stream().map(CellDimMember::getDimMemberNumber).collect(Collectors.toSet())));
                    colDimMems.forEach((k, v) -> memberInfo.put(k, v.stream().map(CellDimMember::getDimMemberNumber).collect(Collectors.toSet())));
                    pageViewDimMems.forEach((k, v) -> {
                        Set cfr_ignored_0 = memberInfo.put(k, Sets.newHashSet((Object[])new String[]{v}));
                    });
                    QueryRequest queryRequest = new QueryRequest(modelId, datasetId, this.extractDimensionViewsByPartition(dimensionViews, rowPartition, colPartition), memberInfo, selectDims);
                    queryRequest.setRowMemberRelDims(rowDimList);
                    queryRequest.setRowMemberRelList(this.rowMemberRelMap.getOrDefault(rowPartition, Collections.emptyList()));
                    this.queryRequests.add(queryRequest);
                }
            }
        } else {
            HashMap memberInfo = new HashMap(16);
            for (Map.Entry<String, Set<CellDimMember>> entry : this.alldimensionWithMembers.entrySet()) {
                if (entry.getValue() != null && entry.getValue().size() > 0) {
                    memberInfo.put(entry.getKey(), entry.getValue().stream().map(CellDimMember::getDimMemberNumber).collect(Collectors.toSet()));
                    continue;
                }
                throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a\uff1a%1 \u7684\u7ef4\u5ea6\u6ca1\u6709\u6709\u6743\u7684\u6210\u5458\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"FixSpreadManager_0", (String)"epm-eb-spread", (Object[])new Object[]{entry.getKey()}));
            }
            ArrayList rowMemberRelList = new ArrayList(1000);
            this.rowMemberRelMap.values().forEach(rowMemberRelList::addAll);
            QueryRequest queryRequest = new QueryRequest(modelId, datasetId, dimensionViews, memberInfo, selectDims);
            queryRequest.setRowMemberRelDims(rowDimList);
            queryRequest.setRowMemberRelList(rowMemberRelList);
            this.queryRequests.add(queryRequest);
        }
    }

    private Map<String, Long> extractDimensionViewsByPartition(Map<String, Long> dimensionViews, String rowPartition, String colPartition) {
        if (dimensionViews != null) {
            HashMap<String, Long> dimViewsByPart = new HashMap<String, Long>(16);
            dimensionViews.forEach((k, v) -> {
                if (k.endsWith("_" + rowPartition) || k.endsWith("_" + colPartition)) {
                    dimViewsByPart.put(k.substring(0, k.indexOf("_")), (Long)v);
                } else if (!k.contains("_") && !dimViewsByPart.containsKey(k)) {
                    dimViewsByPart.put((String)k, (Long)v);
                }
            });
            return dimViewsByPart;
        }
        return null;
    }

    protected Map<String, Object> getPacageCellMap(ECell cell) {
        HashMap<String, Object> valMap = new HashMap<String, Object>(3);
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), cell.getRow());
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), cell.getCol());
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), cell.getValue());
        return valMap;
    }

    private void packageCells(List<Map<String, Object>> parameters, ECell cell) {
        parameters.add(this.getPacageCellMap(cell));
    }

    public void refreshFixCellData(Map<MembersKey, Object> datas, Counter counter) {
        OlapDataProcess olapDataProcess = new OlapDataProcess(datas, counter.getSize());
        olapDataProcess.setIsfix(true);
        olapDataProcess.refreshCellData();
    }

    private Map<String, Integer> getDimIndex() {
        if (this.dimIndex == null) {
            Map<String, Set<CellDimMember>> alldimensionWithMembers = this.getAlldimensionWithMembers();
            int[] index = new int[]{1};
            this.dimIndex = new LinkedHashMap<String, Integer>(16);
            alldimensionWithMembers.forEach((K, V) -> {
                this.dimIndex.put((String)K, index[0]);
                index[0] = index[0] + 1;
            });
        }
        return this.dimIndex;
    }

    private Object getRealValueWithDataUnit(BigDecimal unit, Pair<Boolean, BigDecimal> unitSetting, Object value) {
        if (value instanceof Long || value instanceof BigDecimal) {
            if (unitSetting != null && Boolean.FALSE.equals(unitSetting.p1) && unitSetting.p2 != null) {
                unit = (BigDecimal)unitSetting.p2;
            }
            if (unit != null) {
                if (value instanceof Long) {
                    value = BigDecimal.valueOf((Long)value).divide(unit);
                } else if (value instanceof BigDecimal) {
                    value = ((BigDecimal)value).divide(unit);
                }
            }
        }
        return value;
    }

    public static BigDecimal getDataUnit(String dataunit) {
        BigDecimal unit = null;
        if (kd.bos.util.StringUtils.isNotEmpty((String)dataunit) && !"0".equals(dataunit)) {
            unit = BigDecimal.TEN.pow(Integer.parseInt(dataunit));
        }
        return unit;
    }

    public static Map<String, Pair<Boolean, BigDecimal>> getUnitSettings(ITemplateModel templateModel) {
        String reportUnit = null;
        DynamicObject templateObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateModel.getTemplateBaseInfo().getId(), (String)"eb_templateentity");
        reportUnit = templateObject != null && templateModel.getTemplateBaseInfo() != null && templateModel.getTemplateBaseInfo().getDataunit() != null ? "unit" + templateModel.getTemplateBaseInfo().getDataunit() : "unit0";
        Map<Object, DynamicObject> metricsMap = OlapQuerySync.getMetricsMap(templateModel.getModelId());
        return OlapQuerySync.getUnitSettings(templateModel, reportUnit, metricsMap);
    }

    public static Map<String, Pair<Boolean, BigDecimal>> getUnitSettings(ITemplateModel templateModel, String reportUnit, Map<Object, DynamicObject> metricsMap) {
        HashMap<String, Pair<Boolean, BigDecimal>> unitSetting = new HashMap<String, Pair<Boolean, BigDecimal>>(16);
        if (templateModel.getMetricCellStyleInfo() != null && !templateModel.getMetricCellStyleInfo().isEmpty()) {
            for (MetricCellStyleInfo info : templateModel.getMetricCellStyleInfo()) {
                if (info.getMetricNumber() == null || info.getUseRptunit() == null) continue;
                if (!MetricDataTypeEnum.CURRENCY.getIndex().equals(info.getDatatype() + "") && !MetricDataTypeEnum.NONMONETARY.getIndex().equals(info.getDatatype() + "")) {
                    unitSetting.put(info.getMetricNumber(), (Pair<Boolean, BigDecimal>)Pair.onePair((Object)Boolean.FALSE, (Object)BigDecimal.ONE));
                    continue;
                }
                if (info.getUseRptunit().booleanValue()) {
                    unitSetting.put(info.getMetricNumber(), (Pair<Boolean, BigDecimal>)Pair.onePair((Object)info.getUseRptunit(), (Object)MetricUtils.unitStr2BigDecimal((String)reportUnit)));
                    continue;
                }
                unitSetting.put(info.getMetricNumber(), (Pair<Boolean, BigDecimal>)Pair.onePair((Object)info.getUseRptunit(), (Object)MetricUtils.unitStr2BigDecimal((String)info.getUnit())));
            }
        }
        if (metricsMap != null) {
            for (DynamicObject dynamicObject : metricsMap.values()) {
                String number = dynamicObject.getString("number");
                String dataType = dynamicObject.getString("datatype");
                Integer decimal = dynamicObject.getInt("decimalnum");
                if (unitSetting.containsKey(number)) continue;
                if (MetricDataTypeEnum.CURRENCY.getIndex().equals(dataType)) {
                    unitSetting.put(number, (Pair<Boolean, BigDecimal>)Pair.onePair((Object)Boolean.TRUE, (Object)MetricUtils.unitStr2BigDecimal((String)reportUnit)));
                    continue;
                }
                if (MetricDataTypeEnum.NONMONETARY.getIndex().equals(dataType)) {
                    unitSetting.put(number, (Pair<Boolean, BigDecimal>)Pair.onePair((Object)Boolean.FALSE, (Object)BigDecimal.ONE));
                    continue;
                }
                unitSetting.put(number, (Pair<Boolean, BigDecimal>)Pair.onePair((Object)Boolean.FALSE, (Object)BigDecimal.ONE));
            }
        }
        return unitSetting;
    }

    private static Map<Object, DynamicObject> getMetricsMap(Long modelId) {
        return BusinessDataServiceHelper.loadFromCache((String)"epm_metricmembertree", (String)"number,datatype,decimalnum", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("isleaf", "=", (Object)Boolean.TRUE)});
    }

    /*
     * WARNING - void declaration
     */
    private String getDimNumbers(MembersKey membersKey, Map<String, Integer> dimindexs, List<String> row_dimnums, List<String> col_dimnums, List<CellDimMember> row_dimMembers, List<CellDimMember> col_dimMembers, MultiAreaManager multiAreaManager, MembersKey relationGraphPointMemberKey, DimNumberData dimNumberData) {
        int n;
        Map rowDimPosMap;
        Map<String, String> relationGraphPointMemberMap = this.getRelationGraphPointMemberMap();
        Object[] dimensionMembers = new String[dimindexs.size() + 1];
        Object[] relationGraphMembers = new String[dimindexs.size() + 1];
        String metricNumber = null;
        boolean isRelationGraphFlag = false;
        if (dimNumberData.pageDimensionMembers == null || dimNumberData.pageRelationGraphMembers == null) {
            dimNumberData.pageDimensionMembers = new String[dimindexs.size() + 1];
            dimNumberData.pageRelationGraphMembers = new String[dimindexs.size() + 1];
            for (Map.Entry entry : this.ebSpreadManager.getPageViewDims().entrySet()) {
                if ("Metric".equals(entry.getKey())) {
                    dimNumberData.metricNumber = this.modelCacheHelper.getMember((String)entry.getKey(), null, ((PageViewDimMember)entry.getValue()).getNumber()).getNumber();
                }
                dimNumberData.pageDimensionMembers[dimindexs.get(entry.getKey()).intValue()] = ((PageViewDimMember)entry.getValue()).getNumber();
                if (relationGraphPointMemberMap == null || !relationGraphPointMemberMap.containsKey(entry.getKey())) continue;
                dimNumberData.pageRelationGraphMembers[dimindexs.get(entry.getKey()).intValue()] = relationGraphPointMemberMap.get(entry.getKey());
                dimNumberData.isRelationGraphFlag = true;
            }
            if (multiAreaManager != null && multiAreaManager.getAreaPageViewDims() != null) {
                for (Map.Entry<Object, Object> entry : multiAreaManager.getAreaPageViewDims().entrySet()) {
                    if ("Metric".equals(entry.getKey())) {
                        dimNumberData.metricNumber = this.modelCacheHelper.getMember((String)entry.getKey(), null, ((PageViewDimMember)entry.getValue()).getNumber()).getNumber();
                    }
                    dimNumberData.pageDimensionMembers[dimindexs.get((Object)entry.getKey()).intValue()] = ((PageViewDimMember)entry.getValue()).getNumber();
                    if (!dimNumberData.isRelationGraphFlag || relationGraphPointMemberMap == null || !relationGraphPointMemberMap.containsKey(entry.getKey())) continue;
                    dimNumberData.pageRelationGraphMembers[dimindexs.get((Object)entry.getKey()).intValue()] = relationGraphPointMemberMap.get(entry.getKey());
                }
            }
        }
        System.arraycopy(dimNumberData.pageDimensionMembers, 0, dimensionMembers, 0, dimNumberData.pageDimensionMembers.length);
        System.arraycopy(dimNumberData.pageRelationGraphMembers, 0, relationGraphMembers, 0, dimNumberData.pageRelationGraphMembers.length);
        isRelationGraphFlag = dimNumberData.isRelationGraphFlag;
        metricNumber = dimNumberData.metricNumber;
        if (!dimNumberData.initRowDimPos) {
            dimNumberData.rowDimPosMap = multiAreaManager == null ? null : DimPropertyHelper.getDimPosMap(multiAreaManager.getRowHeaders());
            rowDimPosMap = dimNumberData.rowDimPosMap;
            dimNumberData.initRowDimPos = true;
        } else {
            rowDimPosMap = dimNumberData.rowDimPosMap;
        }
        boolean bl = false;
        int len = row_dimnums.size();
        while (n < len) {
            String dimKey = row_dimnums.get(n);
            int realPos = rowDimPosMap == null ? n : (Integer)rowDimPosMap.get(dimKey);
            CellDimMember cellDimMember = row_dimMembers.get(realPos);
            if (cellDimMember == null) {
                return null;
            }
            if (cellDimMember instanceof MetricCellDimMember) {
                metricNumber = String.valueOf(((MetricCellDimMember)cellDimMember).getDimMemberNumber());
            }
            dimensionMembers[dimindexs.get((Object)dimKey).intValue()] = cellDimMember.getDimMemberNumber();
            if (isRelationGraphFlag && relationGraphPointMemberMap != null && relationGraphPointMemberMap.containsKey(dimKey)) {
                relationGraphMembers[dimindexs.get((Object)dimKey).intValue()] = relationGraphPointMemberMap.get(dimKey);
            }
            ++n;
        }
        if (!dimNumberData.initColDimPos) {
            dimNumberData.colDimPosMap = multiAreaManager == null ? null : DimPropertyHelper.getDimPosMap(multiAreaManager.getColHeaders());
            Map map = dimNumberData.colDimPosMap;
            dimNumberData.initColDimPos = true;
        } else {
            Map<String, Integer> map = dimNumberData.colDimPosMap;
        }
        int len2 = col_dimnums.size();
        for (int i = 0; i < len2; ++i) {
            void var16_23;
            String dimKey = col_dimnums.get(i);
            int realPos = var16_23 == null ? i : (Integer)var16_23.get(dimKey);
            CellDimMember cellDimMember = col_dimMembers.get(realPos);
            if (cellDimMember == null) {
                return null;
            }
            if (cellDimMember instanceof MetricCellDimMember) {
                metricNumber = String.valueOf(((MetricCellDimMember)cellDimMember).getDimMemberNumber());
            }
            dimensionMembers[dimindexs.get((Object)dimKey).intValue()] = cellDimMember.getDimMemberNumber();
            if (!isRelationGraphFlag || relationGraphPointMemberMap == null || !relationGraphPointMemberMap.containsKey(dimKey)) continue;
            relationGraphMembers[dimindexs.get((Object)dimKey).intValue()] = relationGraphPointMemberMap.get(dimKey);
        }
        if (isRelationGraphFlag) {
            this.relationGraphPointMemberKey.setKeys(relationGraphMembers);
        }
        membersKey.setKeys(dimensionMembers);
        return metricNumber;
    }

    private boolean isApprovelBill() {
        PageCache pageCache;
        boolean flag = false;
        if (this.pageid != null && StringUtils.isNotEmpty((String)(pageCache = new PageCache(this.pageid)).get("isApproveBill"))) {
            flag = true;
        }
        return flag;
    }

    public IEbSpreadManager getEbSpreadManager() {
        return this.ebSpreadManager;
    }

    public boolean isSyncSuccessed() {
        return this.syncSuccessed;
    }

    public void setExport(boolean export) {
        this.isExport = export;
    }

    public static class ViewArea
    implements Serializable {
        private int startrow = -1;
        private int endrow = -1;
        private int startcol = -1;
        private int endcol = -1;

        public ViewArea(int startrow, int endrow, int startcol, int endcol, ISheet sheet) {
            this.startrow = Math.max(startrow, sheet.getValueAreaRowStart());
            this.endrow = Math.min(endrow, sheet.getRealMaxRows());
            this.startcol = Math.max(startcol, sheet.getValueAreaColStart());
            this.endcol = Math.min(endcol, sheet.getRealMaxCols());
        }

        public ViewArea(int startrow, int endrow, int startcol, int endcol) {
            this.startrow = startrow;
            this.endrow = endrow;
            this.startcol = startcol;
            this.endcol = endcol;
        }

        public ViewArea(int startrow, int endrow, int startcol, int endcol, RangeModel rangeModel) {
            this.startrow = Math.max(startrow, rangeModel.getY_start());
            this.endrow = Math.min(endrow, rangeModel.getY_end());
            this.startcol = Math.max(startcol, rangeModel.getX_start());
            this.endcol = Math.min(endcol, rangeModel.getX_end());
        }

        public int getStartrow() {
            return this.startrow;
        }

        public int getEndrow() {
            return this.endrow;
        }

        public int getStartcol() {
            return this.startcol;
        }

        public int getEndcol() {
            return this.endcol;
        }

        public static ViewArea ofFirstScreenView() {
            return new ViewArea(0, 1000, 0, 50);
        }

        public String toString() {
            return "ViewArea{startrow=" + this.startrow + ", endrow=" + this.endrow + ", startcol=" + this.startcol + ", endcol=" + this.endcol + '}';
        }
    }

    public static class DimNumberData {
        public String[] pageDimensionMembers = null;
        public String[] pageRelationGraphMembers = null;
        private boolean isRelationGraphFlag = false;
        private String metricNumber = null;
        public boolean initRowDimPos = false;
        public Map<String, Integer> rowDimPosMap = null;
        public boolean initColDimPos = false;
        public Map<String, Integer> colDimPosMap = null;
    }

    class OlapDataProcess {
        private Map<MembersKey, Object> querydatas;
        private int allsize;
        private boolean isfix;

        public void setIsfix(boolean isfix) {
            this.isfix = isfix;
        }

        public OlapDataProcess(Map<MembersKey, Object> querydatas, int allsize) {
            this.querydatas = querydatas == null ? new HashMap(16) : querydatas;
            this.allsize = allsize > 0 ? allsize : 16;
        }

        public void refreshCellData() {
            if (this.isfix) {
                this.refreshCellDataWithOlapData_Fix();
            } else {
                this.refreshCellDataWithOlapData();
            }
        }

        private void refreshCellDataWithOlapData() {
            BigDecimal unit = OlapQuerySync.getDataUnit(OlapQuerySync.this.templateModel.getTemplateBaseInfo().getDataunit());
            Map<String, Pair<Boolean, BigDecimal>> unitSettings = OlapQuerySync.getUnitSettings(OlapQuerySync.this.templateModel);
            Map<String, Integer> dimindexs = OlapQuerySync.this.getDimIndex();
            ISheet sheet = OlapQuerySync.this.ebSpreadManager.getEbook().getSheet(0);
            ArrayList<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>(this.allsize);
            MembersKey membersKey = new MembersKey();
            MembersKey relationGraphPointMemberkey = new MembersKey();
            List row_dimnums = OlapQuerySync.this.ebSpreadManager.getRowpartitionDims();
            List col_dimnums = OlapQuerySync.this.ebSpreadManager.getColpartitionDims();
            dimindexs = AttachmentHelper.sortDimNumByPos(dimindexs);
            List<String> allDimNums = dimindexs.keySet().stream().collect(Collectors.toList());
            Map<MembersKey, String> membersKeyMap = AttachmentHelper.getTaskCellKeys(OlapQuerySync.this.ebSpreadManager.getModelobj().getId(), allDimNums);
            ArrayList<String> attachementRanges = new ArrayList<String>(16);
            DimNumberData dimNumberData = new DimNumberData();
            HashMap<String, String> rangesRemarkMap = new HashMap<String, String>(16);
            for (int row = OlapQuerySync.this.viewArea.getStartrow(); row <= OlapQuerySync.this.viewArea.getEndrow(); ++row) {
                List row_dimMembers;
                if (OlapQuerySync.this.refreshedRows.contains(row) || (row_dimMembers = (List)OlapQuerySync.this.ebSpreadManager.getRowpartitionDimMems().get(row)) == null || row_dimMembers.size() == 0) continue;
                for (int col = sheet.getValueAreaColStart(); col < sheet.getRealMaxCols(); ++col) {
                    ECell cell;
                    List col_dimMembers = (List)OlapQuerySync.this.ebSpreadManager.getColpartitionDimMems().get(col);
                    if (col_dimMembers == null || col_dimMembers.size() == 0) continue;
                    String metricNumber = OlapQuerySync.this.getDimNumbers(membersKey, dimindexs, row_dimnums, col_dimnums, row_dimMembers, col_dimMembers, null, relationGraphPointMemberkey, dimNumberData);
                    String cellTagDy = membersKeyMap.get(membersKey);
                    if (cellTagDy != null) {
                        String posStr = ExcelUtils.xy2Pos((int)col, (int)row);
                        rangesRemarkMap.put(posStr, cellTagDy);
                        attachementRanges.add(posStr);
                    }
                    if (OlapQuerySync.this.relationGraphPointMemberMap != null && OlapQuerySync.this.relationGraphPointMemberKey.getKeys() != null && membersKey.equals((Object)OlapQuerySync.this.relationGraphPointMemberKey)) {
                        OlapQuerySync.this.relationGraphCellAreas.add(new CellArea(row, col, 1, 1));
                    }
                    Object oldvalue = (cell = sheet.getECellNotAdd(row, col)) == null ? null : cell.getValue();
                    Object newvalue = this.querydatas.get(membersKey);
                    newvalue = OlapQuerySync.this.getRealValueWithDataUnit(unit, (Pair<Boolean, BigDecimal>)unitSettings.get(metricNumber), newvalue);
                    if (newvalue != null && newvalue.equals(oldvalue) || newvalue == null && oldvalue == null) continue;
                    if (cell == null) {
                        cell = sheet.getECell(row, col);
                    }
                    if (newvalue instanceof BigDecimal && ((BigDecimal)newvalue).compareTo(BigDecimal.ZERO) == 0) {
                        cell.setValue(null);
                    } else {
                        cell.setValue(newvalue);
                    }
                    if (OlapQuerySync.this.issync) continue;
                    OlapQuerySync.this.packageCells(parameters, cell);
                }
            }
            if (parameters.size() > 0 && !OlapQuerySync.this.issync) {
                OlapQuerySync.this.spreadContainer.updateCellValue(parameters);
            }
            if (attachementRanges.size() > 0) {
                AttachmentHelper.setTaskCellTagsByRange(attachementRanges, true, OlapQuerySync.this.spreadContainer);
            }
            if (rangesRemarkMap.size() > 0) {
                AttachmentHelper.setCellCommonByRange(rangesRemarkMap, true, OlapQuerySync.this.spreadContainer);
            }
            this.setRelationGraphCellStyle();
            OlapQuerySync.this.syncSuccessed = true;
        }

        private void setRelationGraphCellStyle() {
            if (CollectionUtils.isEmpty((Collection)OlapQuerySync.this.relationGraphCellAreas)) {
                return;
            }
            OlapQuerySync.this.relationGraphAreasStyle = new AreasStyle();
            OlapQuerySync.this.relationGraphAreasStyle.setRange(OlapQuerySync.this.relationGraphCellAreas);
            CellStyleInfo cellStyle = new CellStyleInfo();
            cellStyle.setBkc("#ff0000");
            OlapQuerySync.this.relationGraphAreasStyle.setStyle(cellStyle);
            OlapQuerySync.this.findRelationGraphPointCell = true;
        }

        private void refreshCellDataWithOlapData_Fix() {
            BigDecimal unit = OlapQuerySync.getDataUnit(OlapQuerySync.this.templateModel.getTemplateBaseInfo().getDataunit());
            Map<String, Pair<Boolean, BigDecimal>> unitSetting = OlapQuerySync.getUnitSettings(OlapQuerySync.this.templateModel);
            Map<String, Integer> dimindexs = OlapQuerySync.this.getDimIndex();
            ArrayList<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>(this.allsize);
            MembersKey membersKey = null;
            dimindexs = AttachmentHelper.sortDimNumByPos(dimindexs);
            List<String> allDimNums = dimindexs.keySet().stream().collect(Collectors.toList());
            Map<MembersKey, String> membersKeyMap = AttachmentHelper.getTaskCellKeys(OlapQuerySync.this.ebSpreadManager.getModelobj().getId(), allDimNums);
            ArrayList<String> attachementRanges = new ArrayList<String>(16);
            HashMap<String, String> rangesRemarkMap = new HashMap<String, String>(16);
            for (MultiAreaManager multiAreaManager : OlapQuerySync.this.ebSpreadManager.getMultiAreaManager()) {
                DimNumberData dimNumberData = new DimNumberData();
                MultiAreaManager.ValueArea valueRowColStart = multiAreaManager.getValueAreaStart();
                int row_start = valueRowColStart.getRow_start();
                int col_start = valueRowColStart.getCol_start();
                List<String> row_dimnums = multiAreaManager.getRowpartitionDims();
                List<String> col_dimnums = multiAreaManager.getColpartitionDims();
                int rowHeadDimsCount = row_dimnums.size();
                int colHeadDimsCount = col_dimnums.size();
                if (multiAreaManager.getDimPropertys() != null) {
                    rowHeadDimsCount += DimPropertyHelper.getPropertyCount(multiAreaManager.getDimPropertys(), row_dimnums);
                    colHeadDimsCount += DimPropertyHelper.getPropertyCount(multiAreaManager.getDimPropertys(), col_dimnums);
                }
                ISheet sheet = multiAreaManager.getData().getDataSheet();
                int rowSize = multiAreaManager.getRowpartitionDimMems().size();
                for (int viewRow = OlapQuerySync.this.viewArea.getStartrow(); viewRow <= OlapQuerySync.this.viewArea.getEndrow(); ++viewRow) {
                    List<CellDimMember> row_dimMembers;
                    int row;
                    if (OlapQuerySync.this.refreshedRows != null && OlapQuerySync.this.refreshedRows.contains(viewRow)) continue;
                    int n = row = multiAreaManager.getFloatonWhere() == 1 ? viewRow - row_start - colHeadDimsCount : viewRow - row_start;
                    if (row < 0 || row > rowSize - 1 || (row_dimMembers = multiAreaManager.getRowpartitionDimMems().get(row)) == null || row_dimMembers.isEmpty()) continue;
                    long rowDimCount = row_dimMembers.stream().filter(dimmem -> dimmem != null && !dimmem.isProperty()).count();
                    if ((long)row_dimnums.size() != rowDimCount) continue;
                    int relativerow = multiAreaManager.getFloatonWhere() == 1 ? row + colHeadDimsCount : row;
                    for (int col = 0; col < multiAreaManager.getColpartitionDimMems().size(); ++col) {
                        String cellTagDy;
                        String metricNumber;
                        List<CellDimMember> col_dimMembers = multiAreaManager.getColpartitionDimMems().get(col);
                        if (col_dimMembers == null || col_dimMembers.isEmpty()) continue;
                        long colDimCount = col_dimMembers.stream().filter(dimmem -> dimmem != null && !dimmem.isProperty()).count();
                        if ((long)col_dimnums.size() != colDimCount || (metricNumber = OlapQuerySync.this.getDimNumbers(membersKey = new MembersKey(), dimindexs, row_dimnums, col_dimnums, row_dimMembers, col_dimMembers, multiAreaManager, null, dimNumberData)) == null) continue;
                        int relativecol = multiAreaManager.getFloatonWhere() == 0 ? col + rowHeadDimsCount : col;
                        ECell cell = sheet.getECellNotAdd(relativerow, relativecol);
                        Object oldvalue = cell == null ? null : cell.getValue();
                        Object newvalue = this.querydatas.get(membersKey);
                        if (cell == null) {
                            cell = sheet.getECell(relativerow, relativecol);
                        }
                        if ((cellTagDy = membersKeyMap.get(membersKey)) != null) {
                            String posStr = ExcelUtils.xy2Pos((int)(cell.getCol() + col_start), (int)(cell.getRow() + row_start));
                            rangesRemarkMap.put(posStr, cellTagDy);
                            attachementRanges.add(posStr);
                        }
                        if (OlapQuerySync.this.relationGraphPointMemberMap != null && OlapQuerySync.this.relationGraphPointMemberKey.getKeys() != null && membersKey.equals((Object)OlapQuerySync.this.relationGraphPointMemberKey)) {
                            OlapQuerySync.this.relationGraphCellAreas.add(new CellArea(cell.getRow() + row_start, cell.getCol() + col_start, 1, 1));
                        }
                        if ((newvalue = OlapQuerySync.this.getRealValueWithDataUnit(unit, (Pair<Boolean, BigDecimal>)unitSetting.get(metricNumber), newvalue)) != null && newvalue.equals(oldvalue) || newvalue == null && oldvalue == null) continue;
                        cell.setValue(newvalue);
                        if (OlapQuerySync.this.issync) continue;
                        cell.setRow(cell.getRow() + row_start);
                        cell.setCol(cell.getCol() + col_start);
                        OlapQuerySync.this.packageCells(parameters, cell);
                    }
                }
            }
            if (parameters.size() > 0 && !OlapQuerySync.this.issync) {
                OlapQuerySync.this.spreadContainer.updateCellValue(parameters);
            }
            if (attachementRanges.size() > 0) {
                AttachmentHelper.setTaskCellTagsByRange(attachementRanges, true, OlapQuerySync.this.spreadContainer);
            }
            if (rangesRemarkMap.size() > 0) {
                AttachmentHelper.setCellCommonByRange(rangesRemarkMap, true, OlapQuerySync.this.spreadContainer);
            }
            this.setRelationGraphCellStyle();
            OlapQuerySync.this.syncSuccessed = true;
        }
    }
}

