/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.adaptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.form.spread.Spread;
import kd.bos.form.spread.SpreadActionAdapter;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.decompose.entity.AdjustParam;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.utils.ApproveAdjustUtils;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.command.event.CellValueEvent;
import kd.epm.eb.spread.command.event.SpreadActionListener;
import kd.epm.eb.spread.command.rangedefined.FormulaCell;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.listener.ISpreadBaseSupport;
import kd.epm.eb.spread.template.spread.IReportModelSupport;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;
import kd.epm.eb.spread.utils.ReportHelper;
import kd.epm.eb.spread.utils.ReportVar.VarException;
import kd.epm.eb.spread.utils.adjustdecompose.AdjustDecomposeServiceHelper;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections4.MapUtils;

public class SpreadJsAction
extends SpreadActionAdapter
implements ISpreadAction {
    private static final Log log = LogFactory.getLog(SpreadJsAction.class);
    private static String AMOUNT_PATTERN = "^\\(?((-?([0-9]+|[0-9]{1,3}(,[0-9]{3})*))(.[0-9]{1,})?)\\)?$";

    public SpreadJsAction(AbstractFormPlugin plugin, String spreadkey) {
        super(plugin);
    }

    public void updateCellValue(SpreadEvent event) {
        super.updateCellValue(event);
        this.cellValueUpdate(event);
    }

    public void selectedSpread(SpreadEvent event) {
        SpreadPostDataInfo data = event.getPostData();
        if (data.getSelRows() != null && data.getSelRows().size() > 0 && data.getSelCols() != null && data.getSelCols().size() > 0) {
            this.sortSelectData(data);
            int focusCellRow_st = (Integer)data.getSelRows().get(0);
            int focusCellRow_end = (Integer)data.getSelRows().get(data.getSelRows().size() - 1);
            int focusCellCol_st = (Integer)data.getSelCols().get(0);
            int focusCellCol_end = (Integer)data.getSelCols().get(data.getSelCols().size() - 1);
            if (this.plugin instanceof ISpreadBaseSupport) {
                SpreadSelector spreadSelector = new SpreadSelector(focusCellRow_st, focusCellCol_st, focusCellRow_end, focusCellCol_end);
                ((ISpreadBaseSupport)ISpreadBaseSupport.class.cast(this.plugin)).setSpreadSelector(spreadSelector);
                if (this.plugin instanceof SpreadActionListener) {
                    ((SpreadActionListener)SpreadActionListener.class.cast(this.plugin)).cellClick(spreadSelector);
                }
            }
        }
    }

    public void invokePluginMethod(SpreadEvent event) {
        String methodname = (String)event.getPostData().getInvokeParams().get("invokemethod");
        this.callPluginMethod(methodname, event.getPostData().getInvokeParams());
    }

    public void callPluginMethod(String methodName, Object params) {
        try {
            MethodUtils.invokeMethod((Object)this.plugin, (String)methodName, (Object)params);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | KDBizException e) {
            log.error(e.getMessage(), e);
            if (e instanceof InvocationTargetException || this.isVarException((Exception)e)) {
                throw new KDBizException(e.getCause().getMessage());
            }
            throw new RuntimeException(e);
        }
    }

    private boolean isVarException(Exception e) {
        InvocationTargetException targetEx = (InvocationTargetException)e;
        Throwable t = targetEx.getTargetException();
        return t.getClass().isInstance(VarException.class) || t.getClass().isInstance(KDBizException.class) || t.getClass().isAssignableFrom(VarException.class) || t.getClass().isAssignableFrom(KDBizException.class);
    }

    public void showFormulaPanel(SpreadEvent event) {
        this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6682\u4e0d\u652f\u6301\u516c\u5f0f\u5411\u5bfc\u3002", (String)"SpreadJsAction_0", (String)"epm-eb-spread", (Object[])new Object[0]));
    }

    private void sortSelectData(SpreadPostDataInfo data) {
        if (CollectionUtils.isNotEmpty((Collection)data.getSelCols())) {
            log.info("sortSelectData\uff1a{}  elmentType:{}", (Object)JSONObject.toJSONString((Object)data), ((Integer)data.getSelCols().get(0)).getClass());
        }
        data.getSelRows().sort(this.sortSmallTobig());
        data.getSelCols().sort(this.sortSmallTobig());
        int rowindex = data.getSelRows().indexOf(-1);
        int colindex = data.getSelCols().indexOf(-1);
        if (rowindex != -1) {
            data.getSelRows().remove(rowindex);
        }
        if (colindex != -1) {
            data.getSelCols().remove(colindex);
        }
    }

    private Comparator<Integer> sortSmallTobig() {
        return (o1, o2) -> {
            if (o1 < o2) {
                return -1;
            }
            return 1;
        };
    }

    protected boolean isNotSupportExcelFormat(String data) {
        String vdata = this.removeAmountSign(data);
        return StringUtils.isNotEmpty((String)vdata) && Pattern.matches(AMOUNT_PATTERN, vdata.trim());
    }

    protected String removeAmountSign(String data) {
        return data.replaceAll("[\\\\$,US\\\\$,\u00a3,\u00a5]", "");
    }

    public void cellValueUpdate(SpreadEvent event) {
        IEbSpreadManager ebSpreadManager = null;
        if (this.plugin instanceof IReportModelSupport) {
            ebSpreadManager = ((IReportModelSupport)IReportModelSupport.class.cast(this.plugin)).getSpreadManager();
        }
        if (ebSpreadManager == null) {
            return;
        }
        Spread spread = (Spread)event.getSource();
        SpreadPostDataInfo data = spread.getPostDataInfo();
        if (data == null) {
            data = event.getPostData();
        }
        ISpreadContainer spreadContainer = null;
        if (this.plugin instanceof ISpreadBaseSupport) {
            spreadContainer = ((ISpreadBaseSupport)ISpreadBaseSupport.class.cast(this.plugin)).getspreadContainer();
        }
        String invokeAction = "";
        LinkedHashMap invokeParams = data.getInvokeParams();
        if (MapUtils.isNotEmpty((Map)invokeParams)) {
            invokeAction = String.valueOf(invokeParams.get("ebInvokeAction"));
        }
        List values = data.getValues();
        if (!"importData".equalsIgnoreCase(invokeAction) && !this.canEdit(values, ebSpreadManager, spreadContainer)) {
            return;
        }
        boolean valueUpdated = false;
        long updateTime = System.currentTimeMillis();
        if (data.getValues() != null) {
            data.getValues().forEach(v -> {
                if (v.get("v") instanceof String) {
                    v.put("v", v.get("v").toString().trim());
                }
            });
            for (LinkedHashMap e : data.getValues()) {
                ECell cell = ebSpreadManager.getEbook().getSheet(0).getECell(((Integer)e.get("r")).intValue(), ((Integer)e.get("c")).intValue());
                Object val = e.get("v");
                if (!(val instanceof Number) && !(val instanceof String) && !(val instanceof Character) && val != null) continue;
                valueUpdated = true;
                if (val instanceof String) {
                    val = val.toString().trim();
                    Date date = kd.epm.eb.common.utils.StringUtils.isDate((String)((String)val));
                    if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)((String)val))) {
                        val = null;
                    } else if (date != null) {
                        IModelCacheHelper orCreate;
                        Member member;
                        Map<String, String> memberMapByCell = this.getMemberMapByCell((Integer)e.get("r"), (Integer)e.get("c"), ebSpreadManager);
                        String metricMember = memberMapByCell.get(SysDimensionEnum.Metric.getNumber());
                        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)metricMember) && (member = (orCreate = ModelCacheContext.getOrCreate((Long)ebSpreadManager.getModelobj().getId())).getMember(SysDimensionEnum.Metric.getNumber(), null, metricMember)) != null && MetricDataTypeEnum.DATE.getIndex().equals(member.getDatatype())) {
                            val = ConvertUtils.convertToOADate((Date)date);
                        }
                    } else if (!(cell instanceof StyleCell && "@".equals(((StyleCell)cell).getFormatter()) || !this.isNotSupportExcelFormat((String)val))) {
                        String metricNumber = null;
                        Map<String, String> memberMapByCell = this.getMemberMapByCell((Integer)e.get("r"), (Integer)e.get("c"), ebSpreadManager);
                        if (memberMapByCell != null && (metricNumber = memberMapByCell.get(SysDimensionEnum.Metric.getNumber())) != null) {
                            String metricDataType = ebSpreadManager.getMetricDatatypeMap().get(metricNumber) + "";
                            if (MetricDataTypeEnum.CURRENCY.getIndex().equals(metricDataType) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(metricDataType)) {
                                String vdata = this.removeAmountSign((String)val);
                                boolean isNegative = vdata.startsWith("(");
                                String validateData = vdata.replaceAll("\\(", "").replaceAll("\\)", "").replaceAll(",", "");
                                if (isNegative) {
                                    validateData = "-" + validateData;
                                }
                                try {
                                    val = new BigDecimal(validateData);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                boolean needUpdateUi = false;
                boolean needUpdateFormula = false;
                if (this.plugin instanceof ISpreadBaseSupport) {
                    CellValueEvent cellValueEvent = new CellValueEvent(cell.getValue(), val, cell);
                    ((SpreadActionListener)SpreadActionListener.class.cast(this.plugin)).cellValueUpdate(cellValueEvent);
                    if (cellValueEvent.isCancel()) {
                        needUpdateUi = true;
                        val = cell.getValue();
                    } else if (cellValueEvent.getResetValue() != null) {
                        needUpdateUi = true;
                        val = cellValueEvent.getResetValue();
                    } else if (cellValueEvent.isSetValueNull()) {
                        needUpdateUi = true;
                        needUpdateFormula = true;
                        val = null;
                    }
                }
                if (val == null && cell.getValue() != null) {
                    ebSpreadManager.getToDeleteData().add(cell.getRow() + ebSpreadManager.getDeleteSepar() + cell.getCol());
                }
                if (cell.getValue() == null && val != null) {
                    ebSpreadManager.getToDeleteData().remove(cell.getRow() + ebSpreadManager.getDeleteSepar() + cell.getCol());
                }
                cell.setValue(val);
                cell.setUserObject("ut", (Object)updateTime);
                if (spreadContainer == null || !needUpdateUi) continue;
                spreadContainer.updateCellValue2(Lists.newArrayList((Object[])new ECell[]{cell}));
                if (!needUpdateFormula) continue;
                spreadContainer.setFormula(Lists.newArrayList((Object[])new FormulaCell[]{new FormulaCell(cell, null)}));
            }
            this.plugin.getView().getPageCache().remove("isAdjust");
        }
        ((IReportModelSupport)IReportModelSupport.class.cast(this.plugin)).cacheSpreadManager();
        this.plugin.getPageCache().put("isValueUpdate", valueUpdated ? "1" : "0");
    }

    public boolean canEdit(List<LinkedHashMap<String, Object>> values, IEbSpreadManager ebSpreadManager, ISpreadContainer spreadContainer) {
        boolean canAdjust = true;
        try {
            boolean approveAdjust;
            IModelCacheHelper modelCacheHelper = ebSpreadManager.getModelCacheHelper();
            Long modelId = ebSpreadManager.getModelobj().getId();
            Long appBillId = ApproveBillHelper.getAppBillIdFromPage((IFormView)this.plugin.getView());
            String reportProcessId = ReportHelper.getReportProcessId4ApproveLock(this.plugin.getPageCache(), appBillId, this.getSpreadManager());
            boolean isVirtual = false;
            if (!ConvertUtils.toLong((Object)reportProcessId).equals(this.getSpreadManager().getReportProcessId())) {
                isVirtual = true;
            }
            if ((approveAdjust = ApproveAdjustUtils.getInstance().approveAdjust(modelId, ebSpreadManager.getReportProcessId(), this.plugin.getView(), appBillId, Boolean.valueOf(isVirtual))) && !BgTaskStateEnum.INCOMPLETE.getNumber().equals(this.plugin.getPageCache().get("current_report_status"))) {
                AdjustParam adjustParam = CommonUtils.getAdjustParam((Long)modelId);
                Long bizModelId = ebSpreadManager.getBusModelid();
                Long datasetId = ebSpreadManager.getDatasetid();
                Map dimensionViews = ebSpreadManager.getDimemsionViews();
                for (LinkedHashMap<String, Object> value : values) {
                    Integer row = (Integer)value.get("r");
                    Integer col = (Integer)value.get("c");
                    Map<String, String> memberMap = this.getMemberMapByCell(row, col, ebSpreadManager);
                    if (memberMap == null || memberMap.size() <= 0) continue;
                    try {
                        Map dimViewMap = AdjustDecomposeServiceHelper.getDimViewMap((Map)dimensionViews, memberMap, (IModelCacheHelper)modelCacheHelper, (Map)ebSpreadManager.getRowpartitionDimMemsByRow(row), (Map)ebSpreadManager.getColpartitionDimMemsByCol(col));
                        AdjustServiceHelper.canAdjust((IModelCacheHelper)modelCacheHelper, (Long)bizModelId, (Long)datasetId, (Map)dimViewMap, memberMap, (AdjustParam)adjustParam, (String)this.plugin.getPageCache().get("current_report_status"));
                    }
                    catch (KDBizException e) {
                        canAdjust = false;
                        log.error("cant-edit" + JSON.toJSONString(memberMap));
                        this.plugin.getView().showTipNotification(e.getMessage());
                        break;
                    }
                }
                if (!canAdjust && spreadContainer != null) {
                    ArrayList<ECell> cells = new ArrayList<ECell>(values.size());
                    for (LinkedHashMap<String, Object> e : values) {
                        ECell cell = ebSpreadManager.getEbook().getSheet(0).getECell(((Integer)e.get("r")).intValue(), ((Integer)e.get("c")).intValue());
                        cells.add(cell);
                    }
                    spreadContainer.updateCellValue2(cells);
                }
                this.plugin.getView().getPageCache().put("isAdjust", "1");
            }
        }
        catch (Exception e) {
            log.error("canEdit-error", (Throwable)e);
        }
        return canAdjust;
    }

    protected IEbSpreadManager getSpreadManager() {
        return ((AbstractReportPlugin)((Object)AbstractReportPlugin.class.cast(this.plugin))).getSpreadManager();
    }

    public Map<String, String> getMemberMapByCell(int row, int col, IEbSpreadManager spreadManager) {
        return ReportHelper.getMemberMapByCell(spreadManager, row, col);
    }

    public void getLookupData(SpreadEvent event) {
        if (event.getPostData().getInvokeParams() != null) {
            int r = (Integer)event.getPostData().getInvokeParams().get("r");
            int c = (Integer)event.getPostData().getInvokeParams().get("c");
            Map lookupDataInfo = (Map)event.getPostData().getInvokeParams().get("lookupInfo");
            LookUpDataArgs bean = new LookUpDataArgs();
            this.populateValues(bean, lookupDataInfo);
            bean.setR(r);
            bean.setC(c);
            if (bean.getValue() != null) {
                this.callPluginMethod("spreadF7LookUpData", bean);
            }
        }
    }

    protected void populateValues(Object populateBean, Map<String, ? extends Object> values) {
        try {
            BeanUtils.populate((Object)populateBean, values);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (e instanceof InvocationTargetException) {
                log.error(((InvocationTargetException)e).getTargetException());
            }
            throw new RuntimeException(e);
        }
    }
}

