/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.lockcontroller.SpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.lockcell.NoLeafStorageLockControllerHelper;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;

public class RealNoLeafCellLockController
implements ISpreadLockControl {
    private static final Log log = LogFactory.getLog(RealNoLeafCellLockController.class);
    private final NoLeafStorageLockControllerHelper controllerHelper = new NoLeafStorageLockControllerHelper();

    public void control(SpreadLockContext spreadLockContext) {
        if (spreadLockContext == null || spreadLockContext.getEbSpreadManager() == null) {
            return;
        }
        try {
            this.init(spreadLockContext);
            CanEditNoLeafStrategy spreadLockControl = new CanEditNoLeafStrategy();
            spreadLockControl.control(spreadLockContext);
        }
        catch (Exception e) {
            log.error(CommonServiceHelper.getStackTraceStr((Throwable)e));
            throw new KDBizException(e.getMessage());
        }
    }

    private void init(SpreadLockContext spreadLockContext) {
        Boolean approveAdjust = false;
        if (spreadLockContext.getParams().get("approveAdjust") != null) {
            approveAdjust = (Boolean)spreadLockContext.getParams().get("approveAdjust");
        }
        Boolean isReject = spreadLockContext.getFormView() != null && spreadLockContext.getFormView().getPageCache() != null && BgTaskStateEnum.INCOMPLETE.getNumber().equalsIgnoreCase(spreadLockContext.getFormView().getPageCache().get("current_report_status"));
        this.controllerHelper.init(spreadLockContext.getEbSpreadManager(), approveAdjust, isReject);
    }

    private boolean checkPageViewLock(SpreadLockContext spreadLockContext) {
        if (spreadLockContext == null || spreadLockContext.getEbSpreadManager() == null) {
            return false;
        }
        if (this.controllerHelper.isWholePageLock()) {
            spreadLockContext.lockAllData(null, "#FFF8E1");
            spreadLockContext.setStopcommand(true);
            log.info("locked All by checkPageViewLock");
        }
        return this.controllerHelper.isWholePageLock() || this.controllerHelper.isWholePageCanEdit();
    }

    private void lockRowCol(SpreadLockContext spreadLockContext, ISheet sheet, boolean isrow, Set<Integer> locks, Map<Integer, Set<Integer>> lockRowCols) {
        if (sheet != null) {
            int size;
            int start = isrow ? sheet.getValueAreaColStart() : sheet.getValueAreaRowStart();
            int n = size = isrow ? sheet.getRealMaxCols() : sheet.getRealMaxRows();
            if (locks != null) {
                for (Integer n2 : locks) {
                    for (int i = start; i < size; ++i) {
                        StyleCell styleCell = (StyleCell)sheet.getECell(isrow ? n2 : i, isrow ? i : n2);
                        styleCell.setLocked(true);
                        styleCell.setBackColor("#FFF8E1");
                        Set cols = spreadLockContext.getLockCells().computeIfAbsent(isrow ? n2 : i, t -> new HashSet(16));
                        if (isrow) {
                            cols.add(i);
                            continue;
                        }
                        cols.add(n2);
                    }
                }
            }
            if (lockRowCols != null) {
                for (Map.Entry entry : lockRowCols.entrySet()) {
                    Integer lock = (Integer)entry.getKey();
                    Set set = (Set)entry.getValue();
                    for (Integer i : set) {
                        StyleCell styleCell = (StyleCell)sheet.getECell((isrow ? lock : i).intValue(), (isrow ? i : lock).intValue());
                        styleCell.setLocked(true);
                        styleCell.setBackColor("#FFF8E1");
                        Set cols = spreadLockContext.getLockCells().computeIfAbsent(isrow ? lock : i, t -> new HashSet(16));
                        cols.add(isrow ? i : lock);
                    }
                }
            }
        }
    }

    class CanEditNoLeafStrategy
    implements ISpreadLockControl {
        private static final long serialVersionUID = -7331390069306445051L;

        CanEditNoLeafStrategy() {
        }

        public void control(SpreadLockContext spreadLockContext) {
            if (spreadLockContext == null || spreadLockContext.getEbSpreadManager() == null) {
                return;
            }
            log.info("RealNoLeafCellLockController.control controllerHelper = " + RealNoLeafCellLockController.this.controllerHelper);
            if (!RealNoLeafCellLockController.this.checkPageViewLock(spreadLockContext)) {
                ISheet sheet = spreadLockContext.getEbSpreadManager().getEbook().getSheet(0);
                RealNoLeafCellLockController.this.lockRowCol(spreadLockContext, sheet, true, RealNoLeafCellLockController.this.controllerHelper.getLockRows(), RealNoLeafCellLockController.this.controllerHelper.getLockRowCols());
                RealNoLeafCellLockController.this.lockRowCol(spreadLockContext, sheet, false, RealNoLeafCellLockController.this.controllerHelper.getLockCols(), RealNoLeafCellLockController.this.controllerHelper.getLockColRows());
            }
        }
    }
}

