/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.stylecontroller.styleset;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.spread.command.stylecontroller.ISpreadStyleControl;
import kd.epm.eb.spread.command.stylecontroller.SpreadStyleControlContext;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.MetricCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;

public class EnumMetricCellController
implements ISpreadStyleControl {
    private SpreadStyleControlContext styleControlContext = null;

    public void control(SpreadStyleControlContext styleControlContext) {
        this.styleControlContext = styleControlContext;
        if (!this.checkHasEnumMetric()) {
            return;
        }
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        LinkedList<Integer> rows = new LinkedList<Integer>();
        LinkedList<Integer> cols = new LinkedList<Integer>();
        if (ebSpreadManager.getRowpartitionDims().contains(SysDimensionEnum.Metric.getNumber())) {
            this.checkRowColIsEnum(ebSpreadManager.getRowpartitionDimMems(), rows);
        } else {
            this.checkRowColIsEnum(ebSpreadManager.getColpartitionDimMems(), cols);
        }
        this.resolveRowColStyle(rows, ebSpreadManager, styleControlContext, true);
        this.resolveRowColStyle(cols, ebSpreadManager, styleControlContext, false);
    }

    private boolean checkHasEnumMetric() {
        IEbSpreadManager ebSpreadManager = this.styleControlContext.getEbSpreadManager();
        Set mems = (Set)ebSpreadManager.getAlldimensionWithMembers().get(SysDimensionEnum.Metric.getNumber());
        Map metricDataTypeMap = ebSpreadManager.getMetricDatatypeMap();
        if (mems != null && metricDataTypeMap != null) {
            for (String metricDimMem : mems) {
                if (!MetricDataTypeEnum.ENUM.getIndex().equals(String.valueOf(metricDataTypeMap.get(metricDimMem)))) continue;
                return true;
            }
        }
        return false;
    }

    private void checkRowColIsEnum(List<List<CellDimMember>> partitionDimMems, List<Integer> rowcols) {
        for (int rowcol = 0; rowcol < partitionDimMems.size(); ++rowcol) {
            List<CellDimMember> cellDimMembers = partitionDimMems.get(rowcol);
            if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
            boolean needcontinue = false;
            for (CellDimMember cellDimMember : cellDimMembers) {
                if (!cellDimMember.isMetric()) continue;
                needcontinue = true;
                MetricCellDimMember metricCellDimMember = (MetricCellDimMember)cellDimMember;
                if (!MetricDataTypeEnum.ENUM.getIndex().equals(String.valueOf(metricCellDimMember.getDatatype()))) break;
                rowcols.add(rowcol);
                break;
            }
            if (!needcontinue) break;
        }
    }

    private void resolveRowColStyle(List<Integer> rowcols, IEbSpreadManager ebSpreadManager, SpreadStyleControlContext styleControlContext, boolean isrow) {
        if (rowcols.size() == 0) {
            return;
        }
        ISheet sheet = ebSpreadManager.getEbook().getSheet(0);
        for (Integer rowcol : rowcols) {
            if (rowcol == null) continue;
            if (isrow) {
                for (int col = sheet.getValueAreaColStart(); col < sheet.getRealMaxCols(); ++col) {
                    styleControlContext.getRowEnumCells().add(new ECell(rowcol.intValue(), col));
                }
                continue;
            }
            for (int row = sheet.getValueAreaRowStart(); row < sheet.getRealMaxRows(); ++row) {
                styleControlContext.getColEnumCells().add(new ECell(row, rowcol.intValue()));
            }
        }
    }
}

