/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.stylecontroller.styleset.fix;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.command.stylecontroller.FixSpreadStyleControlContext;
import kd.epm.eb.spread.command.stylecontroller.ISpreadStyleControl;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;

public class FixEnumMetricCellController
implements ISpreadStyleControl {
    private List<Long> enumMetricIds = null;
    private IModelCacheHelper modelCacheHelper = null;
    private FixSpreadStyleControlContext styleControlContext = null;

    public void controlFix(FixSpreadStyleControlContext styleControlContext) {
        this.styleControlContext = styleControlContext;
        if (!this.initEnumMetricIDs(styleControlContext)) {
            return;
        }
        if (this.isMetricOnPageView(styleControlContext)) {
            return;
        }
        Long memId = null;
        Member member = null;
        HashMap<String, Long> memNumAndIds = new HashMap<String, Long>(16);
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        for (MultiAreaManager multiAreaManager : ebSpreadManager.getMultiAreaManager()) {
            List<List<CellDimMember>> colpartitionDimMems;
            PageViewDimMember apvd = multiAreaManager.getAreaPageViewDims().get(SysDimensionEnum.Metric.getNumber());
            if (apvd != null && apvd.getNumber() != null) {
                memId = (Long)memNumAndIds.get(apvd.getNumber());
                if (memId == null) {
                    memId = this.getModelCacheHelper().getMember(SysDimensionEnum.Metric.getNumber(), null, apvd.getNumber()).getId();
                    memNumAndIds.put(apvd.getNumber(), memId);
                }
                if (this.enumMetricIds.contains(memId)) {
                    this.setAllEnumsInArea(multiAreaManager);
                    continue;
                }
            }
            int rowStartPoint = multiAreaManager.getValueAreaStart().getData_row_start();
            int colStartPoint = multiAreaManager.getValueAreaStart().getData_col_start();
            if (multiAreaManager.getRowpartitionDims().contains(SysDimensionEnum.Metric.getNumber())) {
                List<List<CellDimMember>> rowpartitionDimMems = multiAreaManager.getRowpartitionDimMems();
                if (rowpartitionDimMems == null) continue;
                for (int i = 0; i < rowpartitionDimMems.size(); ++i) {
                    if (rowpartitionDimMems.get(i) == null) continue;
                    for (CellDimMember cellDimMember : rowpartitionDimMems.get(i)) {
                        if (cellDimMember == null || !cellDimMember.isMetric() || !StringUtils.isNotEmpty((String)cellDimMember.getDimMemberNumber())) continue;
                        memId = (Long)memNumAndIds.get(cellDimMember.getDimMemberNumber());
                        if (memId == null && (member = this.getModelCacheHelper().getMember(SysDimensionEnum.Metric.getNumber(), null, cellDimMember.getDimMemberNumber())) != null) {
                            memId = member.getId();
                            memNumAndIds.put(cellDimMember.getDimMemberNumber(), memId);
                        }
                        if (!this.enumMetricIds.contains(memId)) continue;
                        for (int j = 0; j < multiAreaManager.getColpartitionDimMems().size(); ++j) {
                            styleControlContext.getRowEnumCells().add(new ECell(i + rowStartPoint, j + colStartPoint));
                        }
                    }
                }
                continue;
            }
            if (!multiAreaManager.getColpartitionDims().contains(SysDimensionEnum.Metric.getNumber()) || (colpartitionDimMems = multiAreaManager.getColpartitionDimMems()) == null) continue;
            int rowCount = multiAreaManager.getValueArea().getRc();
            if (rowCount == 0) {
                rowCount = multiAreaManager.getRowpartitionDimMems().size();
            }
            for (int i = 0; i < colpartitionDimMems.size(); ++i) {
                if (colpartitionDimMems.get(i) == null) continue;
                for (CellDimMember cellDimMember : colpartitionDimMems.get(i)) {
                    if (cellDimMember == null || !cellDimMember.isMetric()) continue;
                    memId = (Long)memNumAndIds.get(cellDimMember.getDimMemberNumber());
                    if (memId == null) {
                        memId = this.getModelCacheHelper().getMember(SysDimensionEnum.Metric.getNumber(), null, cellDimMember.getDimMemberNumber()).getId();
                        memNumAndIds.put(cellDimMember.getDimMemberNumber(), memId);
                    }
                    if (!this.enumMetricIds.contains(memId)) continue;
                    for (int j = 0; j < rowCount; ++j) {
                        styleControlContext.getColEnumCells().add(new ECell(rowStartPoint + j, colStartPoint + i));
                    }
                }
            }
        }
    }

    private boolean initEnumMetricIDs(FixSpreadStyleControlContext styleControlContext) {
        QFilter qFilter = new QFilter("model", "=", (Object)styleControlContext.getEbSpreadManager().getModelobj().getId());
        QFilter qFilter1 = new QFilter("dimid", "=", (Object)styleControlContext.getEbSpreadManager().getModelCacheHelper().getDimension(SysDimensionEnum.Metric.getNumber()).getId());
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"eb_enumvalue", (String)"id,enumnumber", (QFilter[])new QFilter[]{qFilter, qFilter1});
        this.enumMetricIds = docs.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        return this.enumMetricIds != null && this.enumMetricIds.size() > 0;
    }

    private boolean isMetricOnPageView(FixSpreadStyleControlContext styleControlContext) {
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        PageViewDimMember pageViewDimMember = (PageViewDimMember)ebSpreadManager.getPageViewDims().get(SysDimensionEnum.Metric.getNumber());
        if (pageViewDimMember == null) {
            return false;
        }
        Long memId = null;
        Set mems = (Set)ebSpreadManager.getAlldimensionWithMembers().get(SysDimensionEnum.Metric.getNumber());
        if (mems != null && mems.size() > 0) {
            memId = this.getModelCacheHelper().getMember(SysDimensionEnum.Metric.getNumber(), null, (String)mems.iterator().next()).getId();
        }
        if (!this.enumMetricIds.contains(memId)) {
            return true;
        }
        List multiAreaManagers = styleControlContext.getEbSpreadManager().getMultiAreaManager();
        for (MultiAreaManager multiAreaManager : multiAreaManagers) {
            this.setAllEnumsInArea(multiAreaManager);
        }
        return true;
    }

    private void setAllEnumsInArea(MultiAreaManager multiAreaManager) {
        if (multiAreaManager != null) {
            int rowStartPoint = multiAreaManager.getValueAreaStart().getData_row_start();
            int colStartPoint = multiAreaManager.getValueAreaStart().getData_col_start();
            for (int i = 0; i < multiAreaManager.getRowpartitionDimMems().size(); ++i) {
                for (int j = 0; j < multiAreaManager.getColpartitionDimMems().size(); ++j) {
                    this.styleControlContext.getRowEnumCells().add(new ECell(i + rowStartPoint, j + colStartPoint));
                }
            }
        }
    }

    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper != null) {
            return this.modelCacheHelper;
        }
        this.modelCacheHelper = this.styleControlContext.getEbSpreadManager().getModelCacheHelper();
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.styleControlContext.getEbSpreadManager().getModelobj().getId());
        }
        return this.modelCacheHelper;
    }
}

