/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.control;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.grapecity.documents.excel.SaveFileFormat;
import com.grapecity.documents.excel.Workbook;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.exception.KDBizException;
import kd.epm.eb.ebSpread.util.DataAndJsonTranslator;
import kd.epm.eb.spread.command.rangedefined.RedPointCell;
import kd.epm.eb.spread.control.POISpreadContainer;
import kd.epm.eb.spread.utils.SpreadDisposeUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbookType;

public class BGPOISpreadContainer
extends POISpreadContainer {
    public BGPOISpreadContainer(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void rebuildSpread(String json) {
        String jsonObj = null;
        if (json != null) {
            jsonObj = json.startsWith("base64") ? DataAndJsonTranslator.unCompressSpreadJson(json) : json;
            this.baseJsonMap = (LinkedHashMap)JSON.parseObject((String)jsonObj, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
            if (this.baseJsonMap.containsKey("tabStripVisible")) {
                this.baseJsonMap.put("tabStripVisible", true);
            }
            SpreadDisposeUtils.removeRowFilter((Map)this.baseJsonMap);
            JSONObject result = new JSONObject(true);
            result.putAll((Map)this.baseJsonMap);
            jsonObj = result.toJSONString();
        }
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        Workbook workbook_gc = new Workbook();
        workbook_gc.fromJson(jsonObj);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        workbook_gc.save((OutputStream)out, SaveFileFormat.Xlsx);
        String excelUrl = cache.saveAsUrl(this.fileName + "." + XSSFWorkbookType.XLSX.getExtension(), out.toByteArray(), 1000);
        try {
            this.workbook = (XSSFWorkbook)WorkbookFactory.create((InputStream)cache.getInputStream(excelUrl));
            this.workbook.setSheetName(0, this.sheetName);
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    @Override
    public void setCellTag(List<RedPointCell> redPointCells) {
    }

    @Override
    public void updateCellValue(List<Map<String, Object>> parameters) {
        super.updateCellValue(parameters);
        if (this.getSheet() == null) {
            return;
        }
        if (CollectionUtils.isEmpty(parameters)) {
            return;
        }
        for (Map<String, Object> map : parameters) {
            Cell cell;
            if (map == null) continue;
            Integer r = (Integer)map.get("r");
            Integer c = (Integer)map.get("c");
            Object value = map.get("v");
            if (r == null || c == null || (cell = this.getCell(r, c)) == null || value != null) continue;
            cell.setCellValue("");
        }
    }
}

