/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.template.TemplateMemberModel;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.spread.template.DefaultTemplateModel;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import org.apache.commons.collections4.CollectionUtils;

public class TemplateMemberRelHelper {
    public static TemplateMemberModel getMemberRel(Long modelId, Long templateId) {
        DynamicObject template = BusinessDataServiceHelper.loadSingle((String)"eb_templateentity", (String)"id,data,templatetype", (QFilter[])new QFBuilder("id", "=", (Object)templateId).toArray());
        String templateData = template.getString("data");
        TemplateMemberModel templateMemberModel = new TemplateMemberModel();
        String templateType = template.getString("templatetype");
        templateMemberModel.setTemplateType(templateType);
        ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)templateData);
        if (templateModel == null) {
            return templateMemberModel;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        HashSet<String> varDimSet = new HashSet<String>(16);
        Map<String, Set<String>> viewMember = TemplateMemberRelHelper.getViewMember(templateModel, varDimSet);
        Map<String, Set<String>> pageMember = TemplateMemberRelHelper.getPageMember(templateModel, modelCache, varDimSet);
        HashMap rowColMember = new HashMap(16);
        Map<String, Map<String, Set<String>>> areaRowColMember = TemplateMemberRelHelper.getRowColMember(templateModel, modelCache, varDimSet);
        areaRowColMember.values().forEach(rowColMember::putAll);
        List<TemplateMemberModel.AreaMemberRel> areaRowColMemberRel = TemplateMemberRelHelper.getAreaRowColMemberRel(templateModel, modelCache);
        areaRowColMemberRel.forEach(areaMemberRel -> {
            if (BgTemplateTypeEnum.DYNAMIC.getNumber().equals(templateType)) {
                areaMemberRel.setRowColMember(rowColMember);
            } else {
                Map memMap = (Map)areaRowColMember.get(areaMemberRel.getAreaIndex());
                areaMemberRel.setRowColMember(memMap);
            }
        });
        templateMemberModel.setViewMember(viewMember);
        templateMemberModel.setPageMember(pageMember);
        templateMemberModel.setRowColMember(rowColMember);
        templateMemberModel.setAreaMemberRelList(areaRowColMemberRel);
        templateMemberModel.setVarDimSet(varDimSet);
        return templateMemberModel;
    }

    public static Map<String, Set<String>> getViewMember(ITemplateModel templateModel, Set<String> varDimSet) {
        if (CollectionUtils.isEmpty((Collection)templateModel.getViewpointmembentry())) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> memberMap = new HashMap<String, Set<String>>(templateModel.getViewpointmembentry().size());
        for (IViewPointDimensionEntry viewMem : templateModel.getViewpointmembentry()) {
            String dimNumber = viewMem.getDimension().getNumber();
            IDimensionMember member = viewMem.getMember();
            if (TemplateVarCommonUtil.checkIsVar((String)member.getNumber(), (String)dimNumber).booleanValue()) {
                varDimSet.add(dimNumber);
                continue;
            }
            memberMap.put(dimNumber, Sets.newHashSet((Object[])new String[]{member.getNumber()}));
        }
        return memberMap;
    }

    public static Map<String, Set<String>> getPageMember(ITemplateModel templateModel, IModelCacheHelper modelCache, Set<String> varDimSet) {
        if (CollectionUtils.isEmpty((Collection)templateModel.getPagemembentry())) {
            return Collections.emptyMap();
        }
        Map dimensionViews = templateModel.getDimemsionViews();
        HashMap<String, Set<String>> memberMap = new HashMap<String, Set<String>>(templateModel.getPagemembentry().size());
        for (IPageDimensionEntry pageMem : templateModel.getPagemembentry()) {
            String dimNumber = pageMem.getDimension().getNumber();
            List members = pageMem.getMembers();
            Long viewId = (Long)dimensionViews.get(dimNumber);
            Set memNumberSet = memberMap.computeIfAbsent(dimNumber, k -> new HashSet(16));
            for (IDimensionMember member : members) {
                if (TemplateVarCommonUtil.checkIsVar((String)member.getNumber(), (String)dimNumber).booleanValue()) {
                    varDimSet.add(dimNumber);
                    continue;
                }
                List memberList = modelCache.getMember(dimNumber, viewId, member.getNumber(), member.getScope());
                Set numberSet = memberList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                memNumberSet.addAll(numberSet);
            }
        }
        return memberMap;
    }

    public static Map<String, Map<String, Set<String>>> getRowColMember(ITemplateModel templateModel, IModelCacheHelper modelCache, Set<String> varDimSet) {
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelCache.getModelobj().getId());
        Map dimensionViews = templateModel.getDimemsionViews();
        HashMap<String, Map<String, Set<String>>> areaMemberMap = new HashMap<String, Map<String, Set<String>>>(8);
        if (templateModel instanceof FixTemplateModel) {
            if (CollectionUtils.isEmpty((Collection)templateModel.getAreaRanges())) {
                return Collections.emptyMap();
            }
            FixTemplateModel fixTemplateModel = (FixTemplateModel)templateModel;
            for (IMultiAreaSetting multiAreaSetting : fixTemplateModel.getAreaRanges()) {
                String areaIndex = multiAreaSetting.getAreaRange().split(":")[0];
                Map memberMap = areaMemberMap.computeIfAbsent(areaIndex, k -> new HashMap(16));
                Map rowColMemberMap = fixTemplateModel.retrieveRowColMembersWithScope(areaIndex);
                rowColMemberMap.forEach((dimNumber, memberSet) -> {
                    Long viewId = DimensionViewServiceHelper.getViewId((Map)dimensionViews, (String)dimNumber, (String)areaIndex);
                    Set memNumberSet = memberMap.computeIfAbsent(dimNumber, k -> new HashSet(16));
                    memberSet.forEach(member -> {
                        if (TemplateVarCommonUtil.checkIsVar((String)member.getNumber(), (String)dimNumber).booleanValue()) {
                            varDimSet.add((String)dimNumber);
                            return;
                        }
                        if (RangeF7PropertyCataEnum.Property.getIndex().equals(member.getType())) {
                            Set refMembers = memberPropCache.getRefMembersByLongNumber(dimNumber, member.getLongNumber());
                            if (CollectionUtils.isNotEmpty((Collection)refMembers)) {
                                memNumberSet.addAll(refMembers);
                            }
                        } else {
                            List memberList = modelCache.getMember(dimNumber, viewId, member.getNumber(), member.getRange());
                            Set numberSet = memberList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                            memNumberSet.addAll(numberSet);
                        }
                    });
                });
            }
        } else if (templateModel instanceof DefaultTemplateModel) {
            Map memberMap = areaMemberMap.computeIfAbsent("row", k -> new HashMap(16));
            Map rowColMemberMap = templateModel.retrieveRowColMembersWithScope();
            rowColMemberMap.forEach((dimNumber, memberSet) -> {
                Set memNumberSet = memberMap.computeIfAbsent(dimNumber, k -> new HashSet(16));
                memberSet.forEach(member -> {
                    if (TemplateVarCommonUtil.checkIsVar((String)member.getNumber(), (String)dimNumber).booleanValue()) {
                        varDimSet.add((String)dimNumber);
                        return;
                    }
                    Long viewId = DimensionViewServiceHelper.getViewId((Map)dimensionViews, (String)dimNumber, (String)member.getPart());
                    List memberList = modelCache.getMember(dimNumber, viewId, member.getNumber(), member.getRange());
                    Set numberSet = memberList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                    memNumberSet.addAll(numberSet);
                });
            });
        }
        return areaMemberMap;
    }

    public static List<TemplateMemberModel.AreaMemberRel> getAreaRowColMemberRel(ITemplateModel templateModel, IModelCacheHelper modelCache) {
        if (templateModel == null) {
            return Collections.emptyList();
        }
        ArrayList<TemplateMemberModel.AreaMemberRel> areaMemberRelList = new ArrayList<TemplateMemberModel.AreaMemberRel>(8);
        if (templateModel instanceof FixTemplateModel) {
            TemplateMemberRelHelper.getFixAreaMemberRelList(templateModel, areaMemberRelList);
        } else if (templateModel instanceof DefaultTemplateModel) {
            TemplateMemberRelHelper.getDynamicAreaMemberRelList(templateModel, modelCache, areaMemberRelList);
        }
        return areaMemberRelList;
    }

    private static void getDynamicAreaMemberRelList(ITemplateModel templateModel, IModelCacheHelper modelCache, List<TemplateMemberModel.AreaMemberRel> areaMemberRelList) {
        if (templateModel.getPartitionSetting() == null) {
            return;
        }
        Map dimensionViews = templateModel.getDimensionView();
        int rowPartIndex = 0;
        for (RowColPartition partition : templateModel.getPartitionSetting().getRowPartition()) {
            String rowPart = "r" + rowPartIndex++;
            ArrayList<String> rowDims = new ArrayList<String>(partition.getRowColDimensionEntries().size() + 1);
            ArrayList dimMemNumberList = new ArrayList(partition.getRowColDimensionEntries().size() + 1);
            for (IRowColDimensionEntry entry : partition.getRowColDimensionEntries()) {
                String dimNumber = entry.getDimension().getNumber();
                rowDims.add(dimNumber);
                Long viewId = DimensionViewServiceHelper.getViewId((Map)dimensionViews, (String)dimNumber, (String)rowPart);
                HashSet memNumbers = new HashSet(32);
                for (IDimensionMember m : entry.getMembers()) {
                    String memNumber = m.getNumber();
                    if (TemplateVarCommonUtil.checkIsVar((String)memNumber, (String)dimNumber).booleanValue()) continue;
                    List memberList = modelCache.getMember(dimNumber, viewId, memNumber, m.getScope());
                    memNumbers.addAll(memberList.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                }
                dimMemNumberList.add(new ArrayList(memNumbers));
            }
            if (!partition.getMetricDimMmebers().isEmpty()) {
                String metricDimNumber = SysDimensionEnum.Metric.getNumber();
                rowDims.add(metricDimNumber);
                HashSet<String> memNumbers = new HashSet<String>(8);
                for (IDimensionMember m : partition.getMetricDimMmebers()) {
                    String memNumber = m.getNumber();
                    if (TemplateVarCommonUtil.checkIsVar((String)memNumber, (String)metricDimNumber).booleanValue()) continue;
                    memNumbers.add(memNumber);
                }
                dimMemNumberList.add(new ArrayList(memNumbers));
            }
            List memRelList = Lists.cartesianProduct(dimMemNumberList);
            List rowMemberRelList = memRelList.stream().map(rowMemList -> rowMemList.toArray(new String[0])).collect(Collectors.toList());
            TemplateMemberModel.AreaMemberRel areaMemberRel = new TemplateMemberModel.AreaMemberRel();
            areaMemberRel.setAreaIndex(rowPart);
            areaMemberRelList.add(areaMemberRel);
            areaMemberRel.setRowMemberRelDims(rowDims);
            areaMemberRel.setRowMemberRelList(rowMemberRelList);
        }
    }

    private static void getFixAreaMemberRelList(ITemplateModel templateModel, List<TemplateMemberModel.AreaMemberRel> areaMemberRelList) {
        if (CollectionUtils.isEmpty((Collection)templateModel.getAreaRanges())) {
            return;
        }
        FixTemplateModel fixTemplateModel = (FixTemplateModel)templateModel;
        for (IMultiAreaSetting multiAreaSetting : fixTemplateModel.getAreaRanges()) {
            String areaIndex = multiAreaSetting.getAreaRange().split(":")[0];
            TemplateMemberModel.AreaMemberRel areaMemberRel = new TemplateMemberModel.AreaMemberRel();
            areaMemberRel.setAreaIndex(areaIndex);
            areaMemberRelList.add(areaMemberRel);
            if (multiAreaSetting.getFloatOnWhere() != -1) {
                areaMemberRel.setFloatOnWhere(Integer.valueOf(multiAreaSetting.getFloatOnWhere()));
                continue;
            }
            List rowDims = multiAreaSetting.getRowdims();
            HashSet rowDimSet = new HashSet(rowDims);
            int rowDimSize = rowDims.size();
            ArrayList<String[]> rowMemberRelList = new ArrayList<String[]>(20);
            areaMemberRel.setRowMemberRelDims(rowDims);
            areaMemberRel.setRowMemberRelList(rowMemberRelList);
            ISheet areaSheet = multiAreaSetting.getAreaSheet();
            for (int i = 0; i < areaSheet.getMaxRowCount(); ++i) {
                List row = areaSheet.getRow(i);
                int arrIndex = 0;
                String[] memRelArr = new String[rowDimSize];
                for (ECell cell : row) {
                    Object isProperty = cell.getUserObject("isproperty");
                    if (Objects.equals("1", isProperty)) continue;
                    Object _dimNumber = cell.getUserObject("dimnumber");
                    Object _memNumber = cell.getUserObject("number");
                    if (_dimNumber == null || _memNumber == null) continue;
                    String dimNumber = String.valueOf(_dimNumber);
                    String memNumber = String.valueOf(_memNumber);
                    if (TemplateVarCommonUtil.checkIsVar((String)memNumber, (String)dimNumber).booleanValue() || !rowDimSet.contains(dimNumber)) break;
                    memRelArr[arrIndex++] = memNumber;
                    if (arrIndex < rowDimSize) continue;
                    break;
                }
                if (arrIndex != rowDimSize) continue;
                rowMemberRelList.add(memRelArr);
            }
        }
    }
}

