/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.serializer.ESheetSerializer;

public class EbSpreadManagerSerializer
extends JsonSerializer<EbSpreadManager> {
    public void serialize(EbSpreadManager ebSpreadManager, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Integer metricRowIndex;
        ESheetSerializer eSheetSerializer = new ESheetSerializer();
        eSheetSerializer.setJsonGenerator(jsonGenerator);
        eSheetSerializer.setSerializerProvider(serializerProvider);
        jsonGenerator.writeStartObject();
        Integer metricColIndex = ebSpreadManager.getMetricColIndex();
        if (metricColIndex != null) {
            jsonGenerator.writeNumberField("metricColIndex", metricColIndex.intValue());
        }
        if ((metricRowIndex = ebSpreadManager.getMetricRowIndex()) != null) {
            jsonGenerator.writeNumberField("metricRowIndex", metricRowIndex.intValue());
        }
        jsonGenerator.writeNumberField("mdt", ebSpreadManager.getDimMemDefaultDisplayType());
        this.writeDimensionViews(ebSpreadManager.getDimemsionViews(), jsonGenerator);
        this.writeSpreadManager((IEbSpreadManager)ebSpreadManager, jsonGenerator);
        this.writeBook(ebSpreadManager.getEbook(), eSheetSerializer, jsonGenerator);
        jsonGenerator.writeEndObject();
    }

    private void writeBook(IEBook ebook, ESheetSerializer eSheetSerializer, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeArrayFieldStart("book");
        int j = ebook.getSheetCount();
        for (int i = 0; i < j; ++i) {
            jsonGenerator.writeStartObject();
            eSheetSerializer.serialize(ebook.getSheet(0));
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
    }

    private void writeDimensionViews(Map<String, Long> dimensionViews, JsonGenerator jsonGenerator) throws IOException {
        if (dimensionViews != null && !dimensionViews.isEmpty()) {
            jsonGenerator.writeObjectFieldStart("dimemsionViews");
            for (Map.Entry<String, Long> dimView : dimensionViews.entrySet()) {
                if (dimView == null) continue;
                jsonGenerator.writeStringField(dimView.getKey(), String.valueOf(dimView.getValue()));
            }
            jsonGenerator.writeEndObject();
        }
    }

    private void writeSpreadManager(IEbSpreadManager ebSpreadManager, JsonGenerator jsonGenerator) throws IOException {
        IEBook book = ebSpreadManager.getEbook();
        ebSpreadManager.setEbook(null);
        jsonGenerator.writeStringField("sm", ObjectSerialUtil.toByteSerialized((Object)ebSpreadManager));
        ebSpreadManager.setEbook(book);
    }
}

