/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.serializer.afix;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.utils.RangeModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.MetricCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.serializer.ESheetSerializer;

public class FixMultiAreaManagerSerializer
extends JsonSerializer<MultiAreaManager> {
    private final ESheetSerializer eSheetSerializer = new ESheetSerializer();

    public void seteSheetSerializerInfo(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        this.eSheetSerializer.setJsonGenerator(jsonGenerator);
        this.eSheetSerializer.setSerializerProvider(serializerProvider);
    }

    public void serialize(MultiAreaManager multiAreaManager, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeStartObject();
        this.writeAreaRange(multiAreaManager.getAreaRange(), jsonGenerator);
        jsonGenerator.writeStringField("startpoint", multiAreaManager.getStartpoint() == null ? "null" : multiAreaManager.getStartpoint());
        jsonGenerator.writeStringField("areaIndex", multiAreaManager.getAreaIndex() == null ? "null" : multiAreaManager.getAreaIndex());
        this.writeAreaPageViewDimMembs(multiAreaManager.getAreaPageViewDims(), jsonGenerator);
        this.writePartitionDimMembs(multiAreaManager.getColpartitionDimMems(), false, jsonGenerator);
        this.writeStringCollection("coldims", multiAreaManager.getColpartitionDims(), jsonGenerator);
        if (multiAreaManager.getColHeaders() != null) {
            jsonGenerator.writeStringField("colheaders", SerializationUtils.toJsonString(multiAreaManager.getColHeaders()));
        }
        this.writePartitionDimMembs(multiAreaManager.getRowpartitionDimMems(), true, jsonGenerator);
        this.writeStringCollection("rowdims", multiAreaManager.getRowpartitionDims(), jsonGenerator);
        if (multiAreaManager.getRowHeaders() != null) {
            jsonGenerator.writeStringField("rowheaders", SerializationUtils.toJsonString(multiAreaManager.getRowHeaders()));
        }
        if (multiAreaManager.getFixReportRowSeqDto() != null) {
            jsonGenerator.writeStringField("seqDto", SerializationUtils.toJsonString((Object)multiAreaManager.getFixReportRowSeqDto()));
        }
        this.writeAreaData(multiAreaManager.getData(), jsonGenerator);
        this.writeStringCollection("delData", multiAreaManager.getToDeleteData(), jsonGenerator);
        this.writeStringCollection("uptData", multiAreaManager.getUpdatedData(), jsonGenerator);
        jsonGenerator.writeNumberField("floatOnWhere", multiAreaManager.getFloatonWhere());
        String propertysJsonStr = "";
        Map<String, List<PropertyObj>> dimPropertys = multiAreaManager.getDimPropertys();
        if (dimPropertys != null && dimPropertys.size() > 0) {
            propertysJsonStr = SerializationUtils.toJsonString(dimPropertys);
        }
        jsonGenerator.writeStringField("DimPropertys", propertysJsonStr);
        jsonGenerator.writeBooleanField("userStyle", multiAreaManager.isUserStyle());
        jsonGenerator.writeBooleanField("hasCellHyperLinkInfo", multiAreaManager.isHasCellHyperLinkInfo());
        jsonGenerator.writeEndObject();
    }

    private void writeAreaRange(RangeModel areaRange, JsonGenerator jsonGenerator) throws IOException {
        if (areaRange != null) {
            jsonGenerator.writeObjectFieldStart("areaRange");
            jsonGenerator.writeNumberField("pos_sx", areaRange.getX_start());
            jsonGenerator.writeNumberField("pos_ex", areaRange.getX_end());
            jsonGenerator.writeNumberField("pos_sy", areaRange.getY_start());
            jsonGenerator.writeNumberField("pos_ey", areaRange.getY_end());
            jsonGenerator.writeEndObject();
        }
    }

    private void writeAreaPageViewDimMembs(Map<String, PageViewDimMember> pageViewDims, JsonGenerator jsonGenerator) throws IOException {
        if (pageViewDims != null && !pageViewDims.isEmpty()) {
            jsonGenerator.writeObjectFieldStart("APVDimMembs");
            PageViewDimMember member = null;
            for (Map.Entry<String, PageViewDimMember> dimMemb : pageViewDims.entrySet()) {
                jsonGenerator.writeObjectFieldStart(dimMemb.getKey());
                member = dimMemb.getValue();
                jsonGenerator.writeStringField("number", member.getNumber());
                jsonGenerator.writeBooleanField("leaf", member.isIsleaf());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
    }

    private void writePartitionDimMembs(List<List<CellDimMember>> partitionDimMembs, boolean isRow, JsonGenerator jsonGenerator) throws IOException {
        if (!isRow) {
            jsonGenerator.writeArrayFieldStart("colMembs");
        } else {
            jsonGenerator.writeArrayFieldStart("rowMembs");
        }
        if (partitionDimMembs != null && !partitionDimMembs.isEmpty()) {
            for (List<CellDimMember> cellMembs : partitionDimMembs) {
                jsonGenerator.writeStartArray();
                if (cellMembs != null && !cellMembs.isEmpty()) {
                    for (CellDimMember cellMemb : cellMembs) {
                        jsonGenerator.writeStartObject();
                        if (cellMemb != null) {
                            if (cellMemb.isIsleaf()) {
                                jsonGenerator.writeBooleanField("leaf", cellMemb.isIsleaf());
                            }
                            if (cellMemb.getDimMemberNumber() != null) {
                                jsonGenerator.writeStringField("number", cellMemb.getDimMemberNumber());
                            }
                            if (cellMemb.isMetric()) {
                                jsonGenerator.writeBooleanField("isMetric", cellMemb.isMetric());
                            }
                            if (cellMemb.isProperty()) {
                                jsonGenerator.writeBooleanField("isProperty", cellMemb.isProperty());
                            }
                            if (cellMemb.getFormat() != null) {
                                jsonGenerator.writeStringField("format", cellMemb.getFormat());
                            }
                            if (cellMemb.getSuffix() != null) {
                                jsonGenerator.writeStringField("suffix", cellMemb.getSuffix());
                            }
                            if (cellMemb.getPrefix() != null) {
                                jsonGenerator.writeStringField("prefix", cellMemb.getPrefix());
                            }
                            if (cellMemb.isMetric()) {
                                MetricCellDimMember metriccell = (MetricCellDimMember)cellMemb;
                                if (metriccell.getDatatype() != null) {
                                    jsonGenerator.writeNumberField("datatype", metriccell.getDatatype().intValue());
                                }
                                if (metriccell.getDecimalnum() != null) {
                                    jsonGenerator.writeStringField("decimalnum", metriccell.getDecimalnum());
                                }
                                if (metriccell.getSign() != null) {
                                    jsonGenerator.writeStringField("sign", metriccell.getSign());
                                }
                            }
                        } else {
                            jsonGenerator.writeStringField("number", "");
                        }
                        jsonGenerator.writeEndObject();
                    }
                }
                jsonGenerator.writeEndArray();
            }
        }
        jsonGenerator.writeEndArray();
    }

    private void writeAreaData(MultiAreaManager.AreaDataInfo areaDataInfo, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeObjectFieldStart("areaData");
        this.eSheetSerializer.serialize(areaDataInfo.getDataSheet());
        jsonGenerator.writeEndObject();
    }

    private void writeStringCollection(String fieldKey, Collection<String> collection, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeArrayFieldStart(fieldKey);
        if (collection != null) {
            for (String str : collection) {
                jsonGenerator.writeString(str);
            }
        }
        jsonGenerator.writeEndArray();
    }
}

