/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.serializer.afix;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.spread.template.BaseEntry;
import kd.epm.eb.spread.template.IBaseEntry;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.fix.FixSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.serializer.afix.FixMulAreaManagerDeserializer;

public class FixSpreadManagerDeserializer
extends JsonDeserializer<FixSpreadManager> {
    public FixSpreadManager deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        FixSpreadManager fixSpreadManager = new FixSpreadManager();
        JsonNode rootNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        fixSpreadManager.setModelobj(this.readModelObj(rootNode));
        fixSpreadManager.setBusModelid(Long.valueOf(rootNode.get("busModelid").asLong()));
        fixSpreadManager.setDatasetid(Long.valueOf(rootNode.get("datasetid").asLong()));
        fixSpreadManager.getAlldimensionWithMembers().putAll(this.readAllDimMembs(rootNode));
        fixSpreadManager.getDimemsionViews().putAll(this.readDimensionViews(rootNode));
        fixSpreadManager.getPageViewDims().putAll(this.readPVDims(rootNode));
        fixSpreadManager.setShowNumber(rootNode.get("isShowNum").asBoolean());
        fixSpreadManager.getMultiAreaManager().addAll(this.readMultAreaManager(rootNode, fixSpreadManager, deserializationContext));
        fixSpreadManager.getFormulaMap().putAll(this.readFormulaMap(rootNode, "formulaMap"));
        fixSpreadManager.getOutAreaHyperLink().putAll(this.readFormulaMap(rootNode, "outAreaHyperLink"));
        fixSpreadManager.setReportProcessId(Long.valueOf(rootNode.get("reportprocessId") == null ? 0L : rootNode.get("reportprocessId").asLong()));
        fixSpreadManager.setProcessId(Long.valueOf(rootNode.get("reportprocessId") == null ? 0L : rootNode.get("processId").asLong()));
        fixSpreadManager.setProcessType(rootNode.get("reportprocessId") == null ? "" : rootNode.get("processType").asText());
        return fixSpreadManager;
    }

    private Map<String, Map<String, String>> readFormulaMap(JsonNode rootNode, String key) {
        HashMap<String, Map<String, String>> formulaMap = new HashMap<String, Map<String, String>>(16);
        JsonNode node = rootNode.get(key);
        if (node != null) {
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                JsonNode fieldNode = (JsonNode)field.getValue();
                Iterator fieldsEntry = fieldNode.fields();
                HashMap formula = new HashMap(16);
                while (fieldsEntry.hasNext()) {
                    Map.Entry field1 = (Map.Entry)fieldsEntry.next();
                    formula.put(field1.getKey(), field1.getValue() != null ? ((JsonNode)field1.getValue()).asText() : "");
                }
                formulaMap.put((String)field.getKey(), formula);
            }
        }
        return formulaMap;
    }

    private Map<String, Set<String>> readAllDimMembs(JsonNode rootNode) {
        HashMap<String, Set<String>> allDimMembs = new HashMap<String, Set<String>>();
        JsonNode node = rootNode.get("allDimMembs");
        HashSet<String> membNums = null;
        if (node != null) {
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                membNums = new HashSet<String>();
                Map.Entry field = (Map.Entry)fields.next();
                if (field.getValue() != null) {
                    Iterator membsIte = ((JsonNode)field.getValue()).elements();
                    while (membsIte.hasNext()) {
                        membNums.add(((JsonNode)membsIte.next()).asText());
                    }
                }
                allDimMembs.put((String)field.getKey(), (Set<String>)membNums);
            }
        }
        return allDimMembs;
    }

    private Map<String, Long> readDimensionViews(JsonNode rootNode) {
        HashMap<String, Long> dimensionViews = new HashMap<String, Long>();
        JsonNode node = rootNode.get("dimemsionViews");
        if (node != null) {
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                dimensionViews.put((String)field.getKey(), field.getValue() != null ? Long.parseLong(((JsonNode)field.getValue()).asText()) : 0L);
            }
        }
        return dimensionViews;
    }

    private Map<String, PageViewDimMember> readPVDims(JsonNode rootNode) {
        HashMap<String, PageViewDimMember> pvDims = new HashMap<String, PageViewDimMember>();
        JsonNode node = rootNode.get("PVDimMembs");
        Object membNums = null;
        if (node != null) {
            Iterator fields = node.fields();
            PageViewDimMember dimMember = null;
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                JsonNode memb = (JsonNode)field.getValue();
                if (memb != null) {
                    dimMember = new PageViewDimMember(memb.get("number").asText(), memb.get("leaf").asBoolean());
                }
                pvDims.put((String)field.getKey(), dimMember);
            }
        }
        return pvDims;
    }

    private IBaseEntry readModelObj(JsonNode rootNode) {
        String modelNum = rootNode.get("modelNum").asText();
        Long modelid = rootNode.get("modelid").asLong();
        BaseEntry modelEntry = new BaseEntry(modelid, modelNum, "");
        return modelEntry;
    }

    private List<MultiAreaManager> readMultAreaManager(JsonNode rootNode, FixSpreadManager fixSpreadManager, DeserializationContext deserializationContext) throws IOException {
        ArrayList<MultiAreaManager> multiAreaManagers = new ArrayList<MultiAreaManager>();
        MultiAreaManager manager = null;
        JsonNode areaManagerNode = rootNode.get("areaManager");
        if (areaManagerNode != null) {
            Iterator managersIte = areaManagerNode.elements();
            while (managersIte.hasNext()) {
                FixMulAreaManagerDeserializer areaManagerDeserializer = new FixMulAreaManagerDeserializer();
                JsonNode node = (JsonNode)managersIte.next();
                manager = areaManagerDeserializer.deserialize(node, deserializationContext);
                manager.setEbSpreadManager((IEbSpreadManager)fixSpreadManager);
                multiAreaManagers.add(manager);
            }
        }
        return multiAreaManagers;
    }
}

