/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.serializer.afix;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.fix.FixSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.serializer.afix.FixMultiAreaManagerSerializer;

public class FixSpreadManagerSerializer
extends JsonSerializer<FixSpreadManager> {
    public void serialize(FixSpreadManager fixSpreadManager, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        this.writeAllDimAndMembs(fixSpreadManager.getAlldimensionWithMembers(), jsonGenerator);
        this.writeDimensionViews(fixSpreadManager.getDimemsionViews(), jsonGenerator);
        this.writePageViewDimMembs(fixSpreadManager.getPageViewDims(), jsonGenerator);
        jsonGenerator.writeStringField("modelNum", fixSpreadManager.getModelobj().getNumber());
        jsonGenerator.writeNumberField("modelid", fixSpreadManager.getModelobj().getId().longValue());
        jsonGenerator.writeNumberField("busModelid", fixSpreadManager.getBusModelid().longValue());
        jsonGenerator.writeNumberField("datasetid", fixSpreadManager.getDatasetid().longValue());
        jsonGenerator.writeBooleanField("isShowNum", fixSpreadManager.isShowNumber());
        this.writeAreaManager(fixSpreadManager.getMultiAreaManager(), jsonGenerator, serializerProvider);
        jsonGenerator.writeBooleanField("isFloat", fixSpreadManager.isHasFloat());
        this.writeFormulaMap(fixSpreadManager.getFormulaMap(), "formulaMap", jsonGenerator);
        this.writeFormulaMap(fixSpreadManager.getOutAreaHyperLink(), "outAreaHyperLink", jsonGenerator);
        this.writeProcess(fixSpreadManager.getReportProcessId(), fixSpreadManager.getProcessId(), fixSpreadManager.getProcessType(), jsonGenerator);
        jsonGenerator.writeEndObject();
    }

    private void writeFormulaMap(Map<String, Map<String, String>> formulaMap, String key, JsonGenerator jsonGenerator) throws IOException {
        if (formulaMap != null && !formulaMap.isEmpty()) {
            jsonGenerator.writeObjectFieldStart(key);
            for (Map.Entry<String, Map<String, String>> formula : formulaMap.entrySet()) {
                jsonGenerator.writeObjectFieldStart(formula.getKey());
                for (Map.Entry<String, String> entry : formula.getValue().entrySet()) {
                    jsonGenerator.writeStringField(entry.getKey(), entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
    }

    private void writeAllDimAndMembs(Map<String, Set<String>> alldimensionWithMembers, JsonGenerator jsonGenerator) throws IOException {
        if (alldimensionWithMembers != null && !alldimensionWithMembers.isEmpty()) {
            jsonGenerator.writeObjectFieldStart("allDimMembs");
            for (Map.Entry<String, Set<String>> dimMembs : alldimensionWithMembers.entrySet()) {
                jsonGenerator.writeArrayFieldStart(dimMembs.getKey());
                if (dimMembs.getValue() != null) {
                    for (String membNum : dimMembs.getValue()) {
                        jsonGenerator.writeString(membNum == null ? "null" : membNum);
                    }
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
    }

    private void writeDimensionViews(Map<String, Long> dimensionViews, JsonGenerator jsonGenerator) throws IOException {
        if (dimensionViews != null && !dimensionViews.isEmpty()) {
            jsonGenerator.writeObjectFieldStart("dimemsionViews");
            for (Map.Entry<String, Long> dimView : dimensionViews.entrySet()) {
                if (dimView == null) continue;
                jsonGenerator.writeStringField(dimView.getKey(), String.valueOf(dimView.getValue()));
            }
            jsonGenerator.writeEndObject();
        }
    }

    private void writePageViewDimMembs(Map<String, PageViewDimMember> pageViewDims, JsonGenerator jsonGenerator) throws IOException {
        if (pageViewDims != null && !pageViewDims.isEmpty()) {
            jsonGenerator.writeObjectFieldStart("PVDimMembs");
            PageViewDimMember member = null;
            for (Map.Entry<String, PageViewDimMember> dimMemb : pageViewDims.entrySet()) {
                jsonGenerator.writeObjectFieldStart(dimMemb.getKey());
                member = dimMemb.getValue();
                jsonGenerator.writeStringField("number", member.getNumber());
                jsonGenerator.writeBooleanField("leaf", member.isIsleaf());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
    }

    private void writeAreaManager(List<MultiAreaManager> multiAreaManager, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeArrayFieldStart("areaManager");
        if (multiAreaManager != null && !multiAreaManager.isEmpty()) {
            FixMultiAreaManagerSerializer areaManagerSerializer = new FixMultiAreaManagerSerializer();
            areaManagerSerializer.seteSheetSerializerInfo(jsonGenerator, serializerProvider);
            for (MultiAreaManager areaManager : multiAreaManager) {
                areaManagerSerializer.serialize(areaManager, jsonGenerator, serializerProvider);
            }
        }
        jsonGenerator.writeEndArray();
    }

    private void writeProcess(Long reportProcessId, Long processId, String processType, JsonGenerator jsonGenerator) throws IOException {
        if (processId != null && StringUtils.isNotEmpty((String)processType)) {
            if (reportProcessId != null) {
                jsonGenerator.writeStringField("reportprocessId", reportProcessId.toString());
            }
            if (processId != null) {
                jsonGenerator.writeStringField("processId", processId.toString());
            }
            jsonGenerator.writeStringField("processType", processType);
        }
    }
}

