/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.applybill.MemberShowType;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberParamsUtils;
import kd.epm.eb.common.reportprocess.utils.ReportProcessUtil;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.base.CacheUtils;
import kd.epm.eb.common.utils.base.LanguageUtils;
import kd.epm.eb.spread.report.excel.entity.RptProcessQInfo;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.afix.multimanager.AreaInfo;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.utils.AttachmentHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ReportHelper {
    private static final Log log = LogFactory.getLog(ReportHelper.class);

    public static boolean isRptSchemeClosed(Long schemeAssignId) {
        if (IDUtils.isNull((Long)schemeAssignId)) {
            return false;
        }
        String sql = "select top 1 rs.fstatus from t_eb_rptscheme rs, t_eb_schemeassign sa where rs.fid = sa.fschemeid and sa.fid = ? ";
        try (DataSet rst = DB.queryDataSet((String)"isRptSchemeClosed", (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[]{schemeAssignId});){
            Integer status = null;
            if (rst.hasNext()) {
                status = rst.next().getInteger("fstatus");
                log.info("scheme.status:{}", (Object)status);
                boolean bl = status != null && status != 1;
                return bl;
            }
        }
        return false;
    }

    public static void refreshBtnUnitStyle(int dataUnit, IFormView formView, String btnKey) {
        if (formView == null || btnKey == null) {
            return;
        }
        HashMap<String, String> language = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> parm = new HashMap<String, HashMap<String, String>>();
        language.put(LanguageUtils.getLang((Lang)Lang.zh_CN).toString(), ResManager.loadResFormat((String)"\u5355\u4f4d\uff1a%1", (String)"AbstractReportPlugin_34", (String)"epm-eb-spread", (Object[])new Object[]{ReportHelper.getDataUnitName(dataUnit)}));
        parm.put("text", language);
        formView.updateControlMetadata(btnKey, parm);
    }

    public static void refreshBtnMemberShowStyle(MemberShowType showType, IFormView formView, String btnKey) {
        if (showType == null || formView == null || btnKey == null) {
            return;
        }
        HashMap<String, String> language = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> parm = new HashMap<String, HashMap<String, String>>();
        language.put(LanguageUtils.getLang((Lang)Lang.zh_CN).toString(), showType.getDesc());
        parm.put("text", language);
        formView.updateControlMetadata(btnKey, parm);
    }

    public static void refreshBtnEmptyRowStyle(boolean showEmptyRow, IFormView formView, String btnKey) {
        if (formView == null || btnKey == null) {
            return;
        }
        HashMap<String, String> language = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> parm = new HashMap<String, HashMap<String, String>>();
        String desc = showEmptyRow ? ResManager.loadKDString((String)"\u663e\u793a\u7a7a\u767d\u884c", (String)"ReportHelper_2", (String)"epm-eb-spread", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9690\u85cf\u7a7a\u767d\u884c", (String)"ReportHelper_1", (String)"epm-eb-spread", (Object[])new Object[0]);
        language.put(LanguageUtils.getLang((Lang)Lang.zh_CN).toString(), desc);
        parm.put("text", language);
        formView.updateControlMetadata(btnKey, parm);
    }

    public static String getDataUnitName(int dataUnit) {
        String unitName = "--";
        switch (dataUnit) {
            case 3: {
                unitName = ResManager.loadKDString((String)"\u5343", (String)"AbstractReportPlugin_0", (String)"epm-eb-spread", (Object[])new Object[0]);
                break;
            }
            case 4: {
                unitName = ResManager.loadKDString((String)"\u4e07", (String)"AbstractReportPlugin_1", (String)"epm-eb-spread", (Object[])new Object[0]);
                break;
            }
            case 6: {
                unitName = ResManager.loadKDString((String)"\u767e\u4e07", (String)"AbstractReportPlugin_2", (String)"epm-eb-spread", (Object[])new Object[0]);
                break;
            }
            case 8: {
                unitName = ResManager.loadKDString((String)"\u4ebf", (String)"AbstractReportPlugin_3", (String)"epm-eb-spread", (Object[])new Object[0]);
                break;
            }
            case 10: {
                unitName = ResManager.loadKDString((String)"\u767e\u4ebf", (String)"AbstractReportPlugin_4", (String)"epm-eb-spread", (Object[])new Object[0]);
                break;
            }
        }
        return unitName;
    }

    public static void removeDimMemRelationCache(IPageCache pageCache, Long processId) {
        String sessionId = pageCache.get("CacheKey_dimMemRelataionMap");
        CacheUtils.loadingCacheInvalidate((String)("CacheKey_dimMemRelataionMap" + sessionId + processId));
    }

    public static void removeDimRelationCache(IPageCache pageCache, Long processId) {
        String sessionId = pageCache.get("CacheKey_dimRelataionMap");
        CacheUtils.loadingCacheInvalidate((String)("CacheKey_dimRelataionMap" + sessionId + processId));
    }

    public static List<Long> getDimRelation(IFormView view, Long processId) {
        List<Long> relationIds = new ArrayList<Long>(16);
        if (view == null) {
            return relationIds;
        }
        IPageCache pageCache = view.getPageCache();
        if (pageCache != null && processId != null) {
            String sessionId = pageCache.get("CacheKey_dimMemRelataionMap");
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)sessionId)) {
                sessionId = GlobalIdUtil.genStringId();
                pageCache.put("CacheKey_dimMemRelataionMap", sessionId);
            }
            if ((relationIds = (List)CacheUtils.loadingCacheGet((String)("CacheKey_dimMemRelataionMap" + sessionId + processId))) != null) {
                return relationIds;
            }
            String bgTemplateInfoJson = pageCache.get("bgtemplate_info");
            BgTemplate templateBaseInfo = !kd.epm.eb.common.utils.StringUtils.isEmpty((String)bgTemplateInfoJson) ? (BgTemplate)ObjectSerialUtil.deSerializedBytes((String)bgTemplateInfoJson) : ReportHelper.getBgTemplate(pageCache.get("templateId"));
            if (templateBaseInfo != null) {
                Long modelId = templateBaseInfo.getModelID();
                Long bizModel = templateBaseInfo.getBizModel();
                relationIds = "1".equals(templateBaseInfo.getIsDimRelation()) ? templateBaseInfo.getDimRelations() : DimensionRelationUtils.getRelationList((Long)modelId, (Long)bizModel);
                CacheUtils.loadingCachePut((String)("CacheKey_dimMemRelataionMap" + sessionId + processId), relationIds);
            }
        }
        return relationIds;
    }

    private static BgTemplate getBgTemplate(String templateId) {
        String selectFields = "id,model,dataset.businessmodel,isrelation,dimrelationinfo2";
        DynamicObject dyna = BusinessDataServiceHelper.loadSingle((String)"eb_templateentity", (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)IDUtils.toLong((Object)templateId)).toArray());
        if (dyna != null) {
            BgTemplate templateBaseInfo = new BgTemplate();
            templateBaseInfo.setModelID(dyna.getLong("model_id"));
            templateBaseInfo.setIsDimRelation(dyna.getBoolean("isrelation") ? "1" : "0");
            DynamicObjectCollection dimrelationinfos = dyna.getDynamicObjectCollection("dimrelationinfo2");
            List<Long> dimRelations = dimrelationinfos.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList());
            templateBaseInfo.setDimRelations(dimRelations);
            Long busModelId = dyna.getLong("dataset.businessmodel_id");
            templateBaseInfo.setBizModel(busModelId);
            return templateBaseInfo;
        }
        return null;
    }

    public static Map<String, Set<String>> getDimRelationMap(IFormView view, Long processId) {
        Map<String, Set<String>> dimRelationMap = new HashMap<String, Set<String>>(16);
        if (view == null) {
            return dimRelationMap;
        }
        IPageCache pageCache = view.getPageCache();
        if (pageCache != null && processId != null) {
            Map dimRelationMapCache;
            String sessionId = pageCache.get("CacheKey_dimRelataionMap");
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)sessionId)) {
                sessionId = GlobalIdUtil.genStringId();
                pageCache.put("CacheKey_dimRelataionMap", sessionId);
            }
            if ((dimRelationMapCache = (Map)CacheUtils.loadingCacheGet((String)("CacheKey_dimRelataionMap" + sessionId + processId))) != null) {
                return dimRelationMapCache;
            }
            String bgTemplateInfoJson = pageCache.get("bgtemplate_info");
            BgTemplate templateBaseInfo = !kd.epm.eb.common.utils.StringUtils.isEmpty((String)bgTemplateInfoJson) ? (BgTemplate)ObjectSerialUtil.deSerializedBytes((String)bgTemplateInfoJson) : ReportHelper.getBgTemplate(pageCache.get("templateId"));
            if (templateBaseInfo != null) {
                Long modelId = templateBaseInfo.getModelID();
                Long bizModel = templateBaseInfo.getBizModel();
                if ("1".equals(templateBaseInfo.getIsDimRelation())) {
                    List<Long> dimRelations = templateBaseInfo.getDimRelations();
                    dimRelationMap = DimensionRelationUtils.getRelationMap((Long)modelId, (Long)bizModel, dimRelations);
                } else {
                    dimRelationMap = DimensionRelationUtils.getRelationMap((Long)modelId, (Long)bizModel, new ArrayList(10));
                }
                CacheUtils.loadingCachePut((String)("CacheKey_dimRelataionMap" + sessionId + processId), dimRelationMap);
                return dimRelationMap;
            }
        }
        return dimRelationMap;
    }

    public static Map<String, String> getMemberMapByCellFix(AreaInfo areaInfo) {
        Map<String, CellDimMember> colMems;
        LinkedHashMap<String, String> allDimMap = new LinkedHashMap<String, String>(16);
        if (areaInfo == null || areaInfo.getRelativerow() < 0 || areaInfo.getRelativecol() < 0) {
            return allDimMap;
        }
        LinkedHashMap<String, CellDimMember> dimMemberMap = new LinkedHashMap<String, CellDimMember>();
        Map<String, CellDimMember> rowMems = areaInfo.getMultiAreaManager().getRowpartitionDimMemsByRow(areaInfo.getRelativerow());
        if (rowMems != null) {
            dimMemberMap.putAll(rowMems);
        }
        if ((colMems = areaInfo.getMultiAreaManager().getColpartitionDimMemsByCol(areaInfo.getRelativecol())) != null) {
            dimMemberMap.putAll(colMems);
        }
        if (dimMemberMap.size() != areaInfo.getMultiAreaManager().getRowpartitionDims().size() + areaInfo.getMultiAreaManager().getColpartitionDims().size()) {
            return allDimMap;
        }
        Map<String, PageViewDimMember> pageViewDimMemberMap = areaInfo.getMultiAreaManager().getAreaPageViewDims();
        if (pageViewDimMemberMap != null) {
            for (Map.Entry<String, PageViewDimMember> entry : pageViewDimMemberMap.entrySet()) {
                dimMemberMap.put(entry.getKey(), new CellDimMember(entry.getValue().isIsleaf(), entry.getValue().getNumber()));
            }
        }
        Map<String, String> rowColDimMap = dimMemberMap.entrySet().stream().collect(Collectors.toMap(key -> (String)key.getKey(), value -> {
            CellDimMember value1 = (CellDimMember)value.getValue();
            if (value1 == null) {
                return "";
            }
            return value1.getDimMemberNumber();
        }));
        Map allDimMems = areaInfo.getMultiAreaManager().getEbSpreadManager().getAlldimensionWithMembers();
        for (Map.Entry dimMem : allDimMems.entrySet()) {
            String curDim = (String)dimMem.getKey();
            if (rowColDimMap.containsKey(curDim)) {
                allDimMap.put((String)dimMem.getKey(), rowColDimMap.get(curDim));
                continue;
            }
            String curMem = "";
            if (dimMem.getValue() != null && ((Set)dimMem.getValue()).size() > 0) {
                curMem = (String)((Set)dimMem.getValue()).iterator().next();
            }
            allDimMap.put((String)dimMem.getKey(), curMem);
        }
        return allDimMap;
    }

    public static Map<String, String> getMemberMapByCellFix(IEbSpreadManager spreadManager, int row, int col) {
        return ReportHelper.getMemberMapByCellFix(spreadManager, row, col, true, true);
    }

    public static Map<String, String> getMemberMapByCellFix(IEbSpreadManager spreadManager, int row, int col, boolean needFullDims, boolean needDimOrder) {
        Map<String, CellDimMember> colMems;
        HashMap<String, String> allDimMap = new HashMap<String, String>(20);
        AreaInfo areaInfo = spreadManager.getAreaInfoByRowCol(row, col);
        if (areaInfo == null || areaInfo.getRelativerow() < 0 || areaInfo.getRelativecol() < 0) {
            return allDimMap;
        }
        HashMap<String, String> rowColDimMap = new HashMap<String, String>(20);
        Map<String, CellDimMember> rowMems = areaInfo.getMultiAreaManager().getRowpartitionDimMemsByRow(areaInfo.getRelativerow());
        if (rowMems != null) {
            for (Map.Entry<String, CellDimMember> entry : rowMems.entrySet()) {
                CellDimMember cellDimMember = entry.getValue();
                rowColDimMap.put(entry.getKey(), cellDimMember == null ? "" : cellDimMember.getDimMemberNumber());
            }
        }
        if ((colMems = areaInfo.getMultiAreaManager().getColpartitionDimMemsByCol(areaInfo.getRelativecol())) != null) {
            for (Map.Entry<String, CellDimMember> entry : colMems.entrySet()) {
                CellDimMember cellDimMember = entry.getValue();
                rowColDimMap.put(entry.getKey(), cellDimMember == null ? "" : cellDimMember.getDimMemberNumber());
            }
        }
        if (needFullDims && rowColDimMap.size() != areaInfo.getMultiAreaManager().getRowpartitionDims().size() + areaInfo.getMultiAreaManager().getColpartitionDims().size()) {
            return allDimMap;
        }
        Map<String, PageViewDimMember> map = areaInfo.getMultiAreaManager().getAreaPageViewDims();
        if (map != null) {
            for (Map.Entry<String, PageViewDimMember> entry : map.entrySet()) {
                rowColDimMap.put(entry.getKey(), entry.getValue().getNumber());
            }
        }
        Map map2 = areaInfo.getMultiAreaManager().getEbSpreadManager().getAlldimensionWithMembers();
        for (Map.Entry entry : map2.entrySet()) {
            String curDim = (String)entry.getKey();
            if (rowColDimMap.containsKey(curDim)) {
                allDimMap.put((String)entry.getKey(), (String)rowColDimMap.get(curDim));
                continue;
            }
            String curMem = "";
            if (entry.getValue() != null && ((Set)entry.getValue()).size() > 0) {
                curMem = (String)((Set)entry.getValue()).iterator().next();
            }
            allDimMap.put((String)entry.getKey(), curMem);
        }
        if (needDimOrder) {
            Long l = spreadManager.getDatasetid();
            List list = spreadManager.getModelCacheHelper().getDimensionList(l);
            List<String> orderDims = list.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            return AttachmentHelper.sortDimByDataSet(allDimMap, orderDims);
        }
        return allDimMap;
    }

    public static Map<String, String> getMemberMapByCell(IEbSpreadManager spreadManager, int row, int col) {
        Map rowMems;
        ISheet sheet = spreadManager.getEbook().getSheet(0);
        LinkedHashMap<String, String> allDimMap = new LinkedHashMap<String, String>(16);
        if (col < sheet.getValueAreaColStart() || row < sheet.getValueAreaRowStart()) {
            return allDimMap;
        }
        LinkedHashMap dimMemberMap = new LinkedHashMap(16);
        Map colMems = spreadManager.getColpartitionDimMemsByCol(Integer.valueOf(col));
        if (colMems != null) {
            dimMemberMap.putAll(colMems);
        }
        if ((rowMems = spreadManager.getRowpartitionDimMemsByRow(Integer.valueOf(row))) != null) {
            dimMemberMap.putAll(rowMems);
        }
        Map<String, String> rowColDimMap = dimMemberMap.entrySet().stream().collect(Collectors.toMap(key -> (String)key.getKey(), value -> ((CellDimMember)value.getValue()).getDimMemberNumber()));
        Map allDimMems = spreadManager.getAlldimensionWithMembers();
        for (Map.Entry dimMem : allDimMems.entrySet()) {
            String curDim = (String)dimMem.getKey();
            if (rowColDimMap.containsKey(curDim)) {
                allDimMap.put((String)dimMem.getKey(), rowColDimMap.get(curDim));
                continue;
            }
            String curMem = "";
            if (dimMem.getValue() != null && ((Set)dimMem.getValue()).size() > 0) {
                curMem = (String)((Set)dimMem.getValue()).iterator().next();
            }
            allDimMap.put((String)dimMem.getKey(), curMem);
        }
        Long datasetId = spreadManager.getDatasetid();
        List dimensions = spreadManager.getModelCacheHelper().getDimensionList(datasetId);
        List<String> orderDims = dimensions.stream().map(dimsion -> dimsion.getNumber()).collect(Collectors.toList());
        return AttachmentHelper.sortDimByDataSet(allDimMap, orderDims);
    }

    public static String getVrRptProcessId(String sourceRptProcessId, Long approveBillId, IEbSpreadManager ebSpreadManager) {
        Long id = ReportHelper.getVrRptProcessId(IDUtils.toLong((Object)sourceRptProcessId), approveBillId, ebSpreadManager);
        sourceRptProcessId = id == null ? "0" : String.valueOf(id);
        return sourceRptProcessId;
    }

    public static String getReportProcessId4ApproveLock(IPageCache pageCache, Long approveBillId, IEbSpreadManager spreadManager) {
        String reportProcessId = pageCache.get("curProcessId");
        if (StringUtils.isEmpty((CharSequence)reportProcessId)) {
            reportProcessId = pageCache.get("current_report_id");
        }
        reportProcessId = ReportHelper.getVrRptProcessId(reportProcessId, approveBillId, spreadManager);
        return reportProcessId;
    }

    public static Long getVrRptProcessId(Long sourceRptProcessId, Long approveBillId, IEbSpreadManager ebSpreadManager) {
        return ReportHelper.getVrRptProcessId(sourceRptProcessId, approveBillId, ebSpreadManager, null);
    }

    public static Long getVrRptProcessId(Long sourceRptProcessId, Long approveBillId, IEbSpreadManager ebSpreadManager, RptProcessQInfo processQInfo) {
        if (!ReportProcessUtil.checkReportProcessStatus((Long)sourceRptProcessId, (Long)approveBillId).booleanValue()) {
            sourceRptProcessId = ReportHelper.getVrRptProcessId(sourceRptProcessId, ebSpreadManager, processQInfo);
        }
        return sourceRptProcessId;
    }

    public static Long getVrRptProcessId(Long sourceRptProcessId, IEbSpreadManager ebSpreadManager, RptProcessQInfo processQInfo) {
        PageViewDimMember pageViewDimMember;
        Map pageViewDims;
        if (ebSpreadManager != null && (pageViewDims = ebSpreadManager.getPageViewDims()) != null && (pageViewDimMember = (PageViewDimMember)pageViewDims.get(SysDimensionEnum.Entity.getNumber())) != null) {
            if (processQInfo == null) {
                Map map = ReportProcessUtil.getDimensionIdByReportProcess((Long)IDUtils.toLong((Object)sourceRptProcessId));
                processQInfo = new RptProcessQInfo((Long)map.get("template"), (Long)map.get(SysDimensionEnum.BudgetPeriod.getNumber()), (Long)map.get(SysDimensionEnum.Version.getNumber()), (Long)map.get(SysDimensionEnum.DataType.getNumber()), (Long)ebSpreadManager.getDimemsionViews().get(SysDimensionEnum.Entity.getNumber()));
            }
            if ((sourceRptProcessId = ReportProcessUtil.getReportProcessId((Long)ebSpreadManager.getModelobj().getId(), (Long)processQInfo.getTempId(), (String)pageViewDimMember.getNumber(), (Long)processQInfo.getPeriodId(), (Long)processQInfo.getVersionId(), (Long)processQInfo.getDatatypeId(), (Long)processQInfo.getOrgViewId())) == 0L) {
                sourceRptProcessId = ReportProcessUtil.checkVimReportProcessStatus((Long)ebSpreadManager.getModelobj().getId(), (Long)processQInfo.getTempId(), (String)pageViewDimMember.getNumber(), (Long)processQInfo.getPeriodId(), (Long)processQInfo.getVersionId(), (Long)processQInfo.getDatatypeId(), (Long)processQInfo.getOrgViewId());
            }
        }
        return sourceRptProcessId;
    }

    public static void setLongNameNumDisVisible(Long modelId, IFormView view) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || view == null) {
            return;
        }
        List longNameNumDisplayParams = MemberParamsUtils.getLongNameNumDisplayParamsByCache((long)modelId);
        if (CollectionUtils.isEmpty((Collection)longNameNumDisplayParams)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"btn_showlongnumber", "btn_showlongname", "btn_showlongnamenum"});
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"btn_showlongnumber", "btn_showlongname", "btn_showlongnamenum"});
        }
    }

    public static List<String> getLongDisplayDimNums(int memberDisplayType, IModelCacheHelper modelCacheHelper) {
        ArrayList<String> longDisplayDimNums = new ArrayList<String>(16);
        if (modelCacheHelper == null || modelCacheHelper.getModelobj() == null) {
            return longDisplayDimNums;
        }
        Long modelId = modelCacheHelper.getModelobj().getId();
        if (MemberDisplayTypeEnum.LONGNUMBER.getIndex() == memberDisplayType || MemberDisplayTypeEnum.LONGNAME.getIndex() == memberDisplayType || MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() == memberDisplayType) {
            return MemberParamsUtils.getLongNameNumDisplayParamsByCache((long)modelId);
        }
        return longDisplayDimNums;
    }

    public static boolean isTaskUnable(Long taskProcessId) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"eb_taskprocess", (String)"task.isclosed", (QFilter[])new QFilter("id", "=", (Object)taskProcessId).toArray());
        if (object == null) {
            return false;
        }
        return !object.getBoolean("task.isclosed");
    }
}

