/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.analytics;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.DataRuleResult;
import kd.bos.permission.api.DataRuleSingleResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.extdata.model.DimFieldEntry;
import kd.fi.bcm.business.extdata.model.ExtField;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.permission.cache.BcmPermSingleModel;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.util.DataQueryAnalyticsHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AnalyticsQueryTypeEnum;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.dimension.FieldTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.BCMBaseFunction;
import kd.fi.bcm.formplugin.dataquery.QueryDataTabManger;
import kd.fi.bcm.formplugin.dataquery.QueryDataTabMangerCache;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.intergration.util.EADataPushUtil;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.collections.CollectionUtils;

public class DataQueryAnalyticsPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
BCMBaseFunction,
DynamicPage,
MainPage {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(DataQueryAnalyticsPlugin.class);
    private static final String SING_PREFIX = "multi";
    private static final String MUL_PRE = "mul";
    private static final String FIX_SUF = "_fix";
    private static final String STRETCH_BTN = "stretch";
    private static final String RETRACT_BTN = "retract";
    private static final String RESET_BTN = "reset";
    private static final String QUERY_BTN = "query";
    private static final String REFERSH_BTN = "refresh";
    private static final String EXPORT_EXCEL = "exportexcel";
    private static final String SCHEME_LIST = "schemelist";
    private static final String ADD_SCHEME = "addscheme";
    private static final String SAVE_SCHEME = "savescheme";
    private static final String SAVE_AS_SCHEME = "saveasscheme";
    protected static final String ORG = "org";
    protected static final String MODEL_DY = "model";
    protected static final String FILTER_SCHEME = "filterscheme";
    protected static final String COMBO_FIELD = "combofield";
    protected static final String EXT_MODEL = "extmodel";
    protected static final String FILTER_AP = "filterap";
    protected static final String OLAP_PANEL_AP = "olappanelap";
    protected static final String OLAP_FILTER_AP = "olapfilterap";
    protected static final String EXT_FILTER_AP = "extfilterap";
    protected static final String LIGHT_ANALYTICS_AP = "lightanalyticsap";
    protected static final String REPORT_LIST_AP = "reportlistap";
    protected static final String LIST_AP = "listap";
    protected static final String OPEN_AP = "openap";
    protected static final String CLOSE_AP = "cloap";
    protected static final String OPEN_LABLE_AP = "openlabelap";
    protected static final String CLO_LABLE_AP = "clolabelap";
    protected static final String HEIG_FILTER_AP = "highfilterap";
    protected static final String MUL_SCENE_F7 = "mulscenario";
    protected static final String MUL_YEAR_F7 = "mulyear";
    protected static final String MUL_PERIOD_F7 = "mulperiod";
    protected static final String MUL_CURRENCY_F7 = "mulcurrency";
    protected static final String MUL_ENTITY_F7 = "mulentity";
    protected static final String AUDITTRAIL_F7 = "audittrail";
    protected static final String PROCESS_F7 = "process";
    protected static final String LIST_MODEL = "listmodel";
    protected static final String ANALYSIS_MODEL = "analysismodel";
    private static final String f7MapCACHEKEY = "f7MapCacheKey";
    private static final String FILTER_GRID_AP = "filtergridap";
    private static final String FMONEY = "FMONEY";
    private static final String RESULT_PANEL_AP = "resultpanelap";
    private static final String SCHEME_ID_KEY = "scheme_id_key";
    private static final String BCM_DIMENSION_DATA = "bcm_dimension_data";
    private static final String ENTRY_ENTITY = "commembentry";
    private static final List<String> SINGLE_TREE_F7 = Lists.newArrayList((Object[])new String[]{"audittrail", "process"});
    private static final Set<String> MULTI_DIM_KEYS = Sets.newHashSet((Object[])new String[]{"mulscenario", "mulyear", "mulperiod", "mulcurrency", "mulentity"});
    private static final List<String> MUSTINPUT = Arrays.asList("Entity", "Account", "Scenario", "Year", "Period");
    private Map<String, String> mappedToCol = new HashMap<String, String>(16);
    private Set<String> conditions = Sets.newHashSet((Object[])new String[]{"67", "17", "59"});
    private QueryDataTabManger queryDataTabManger;
    protected QueryDataTabMangerCache queryDataTabMangerCache;

    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(SINGLE_TREE_F7, SingleF7TypeEnum.COMMON, map);
        this.initSingleMemberF7(map);
        Vector listModel = (Vector)this.getControl(LIST_MODEL);
        listModel.addClickListener((ClickListener)this);
        Vector analysisModel = (Vector)this.getControl(ANALYSIS_MODEL);
        analysisModel.addClickListener((ClickListener)this);
        if (this.getPage((IFormView)this.getView()) != null) {
            this.getPage((IFormView)this.getView()).bindCtrlMapping((IFormView)this.getView());
        }
        this.queryDataTabMangerCache = new QueryDataTabMangerCache(this.getPageCache());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(MODEL_DY);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit extendModel = (BasedataEdit)this.getControl(EXT_MODEL);
        if (extendModel != null) {
            extendModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit proBdData = (BasedataEdit)this.getControl(PROCESS_F7);
        proBdData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit audiBdData = (BasedataEdit)this.getControl(AUDITTRAIL_F7);
        audiBdData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{MUL_SCENE_F7, MUL_YEAR_F7, MUL_PERIOD_F7, MUL_CURRENCY_F7, MUL_ENTITY_F7, OPEN_AP, CLOSE_AP, STRETCH_BTN, RETRACT_BTN, RESET_BTN, QUERY_BTN, OPEN_LABLE_AP, CLO_LABLE_AP});
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (this.getPage((IFormView)this.getView()) != null) {
            Element c = this.getPage((IFormView)this.getView()).findElementBySign(e.getKey());
            if (c != null && TextEditElement.class.isAssignableFrom(c.getClass())) {
                TextEdit edit = new TextEdit();
                edit.setKey(e.getKey());
                edit.setModel(this.getModel());
                edit.setView((IFormView)this.getView());
                edit.addClickListener((ClickListener)this);
                e.setControl((Control)edit);
            } else if (c != null) {
                e.setControl(c.getControl((IFormView)this.getView()));
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((BasedataEdit)evt.getSource()).getKey();
        if (MODEL_DY.equals(key)) {
            if (StringUtils.isNotEmpty((String)MODEL_DY) && this.getControl(MODEL_DY) != null) {
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                ArrayList qFilterList = ((BasedataEdit)this.getControl(MODEL_DY)).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList();
                }
                qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            }
        } else if (EXT_MODEL.equals(key)) {
            Object model = this.getModel().getValue(MODEL_DY);
            if (model == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExtendDataRptFormPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.setListFilterParameter(new ListFilterParameter(Arrays.asList(new QFilter(MODEL_DY, "=", (Object)((DynamicObject)model).getLong("id")), new QFilter("extendsgroup.grouptype", "in", this.getNoEquityExtendGroupType())), null));
            }
        } else if (PROCESS_F7.equals(key) || AUDITTRAIL_F7.equals(key)) {
            List customQFilters = evt.getCustomQFilters();
            QFilter qf = new QFilter(MODEL_DY, "=", (Object)this.getModelId());
            qf.and("status", "=", (Object)StatusEnum.Checked.toString());
            qf.and("enable", "=", (Object)"1");
            customQFilters.add(qf);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL_DY);
        if (modelId == null || modelId.equals("0")) {
            return;
        }
        this.getModel().setValue(MODEL_DY, (Object)modelId);
        this.getPageCache().put("KEY_MODEL_ID", modelId);
        this.setVisiableOfPanelAp();
        this.setCombsValueOfScheme(null);
    }

    public void beforeBindData(EventObject e) {
        if (Boolean.TRUE.toString().equals(this.getPageCache().get("isHaveScheme"))) {
            QFilter qf = new QFilter(MODEL_DY, "=", (Object)this.getModelId());
            qf.and("number", "=", this.getModel().getValue(FILTER_SCHEME));
            DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_analyticsscheme_base", (String)"id, combofield, extmodel", (QFilter[])qf.toArray());
            if (dyn != null) {
                this.updateFieldValueNoProperty(COMBO_FIELD, dyn.getString(COMBO_FIELD));
                if (dyn.getLong(EXT_MODEL) != 0L) {
                    this.updateFieldValueNoProperty(EXT_MODEL, dyn.getLong(EXT_MODEL));
                }
            }
        }
        this.setHighFilter();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (Boolean.TRUE.toString().equals(this.getPageCache().get("isHaveScheme"))) {
            this.overValueByScheme((String)this.getModel().getValue(FILTER_SCHEME));
            this.getView().updateView(EXT_FILTER_AP);
        } else {
            DynamicObject defaultExtendModel = this.getDefaultExtendModel(String.valueOf(this.getModelId()));
            if (defaultExtendModel != null) {
                this.getModel().setValue(EXT_MODEL, (Object)defaultExtendModel);
            }
            this.getPageCache().put("choise_model", LIST_MODEL);
            this.createMutiF7();
            this.setHighFilter();
            this.setFilterGridName();
        }
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        DynamicObject rowData = packageDataEvent.getRowData();
        Map<String, String> mappedToCol = this.getMappedToCol();
        for (Map.Entry<String, String> entry : mappedToCol.entrySet()) {
            IDNumberTreeNode member;
            String field = entry.getKey();
            String entityNum = entry.getValue();
            String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
            if (!StringUtils.isNotEmpty((String)rowData.getString(field)) || (member = MemberReader.findMemberByNumber((String)modelNum, (String)entityNum, (String)rowData.getString(field))) == IDNumberTreeNode.NotFoundTreeNode) continue;
            if (entityNum.equals(SysDimensionEnum.Entity.getNumber()) && rowData.getString(field).contains("_")) {
                rowData.set(field, (Object)(rowData.getString(field) + " | " + member.getParent().getName() + "_" + member.getName()));
                continue;
            }
            rowData.set(field, (Object)(rowData.getString(field) + " | " + member.getName()));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        String opkey = evt.getItemKey();
        if (!this.isEPM()) {
            this.checkPerm(opkey);
        }
        switch (itemKey = evt.getItemKey()) {
            case "refresh": {
                this.refresh();
                break;
            }
            case "exportexcel": {
                this.exportExcel();
                break;
            }
            case "schemelist": {
                this.showSchemeList(itemKey);
                break;
            }
            case "addscheme": {
                this.addScheme(itemKey);
                break;
            }
            case "savescheme": {
                this.saveExistScheme();
                break;
            }
            case "saveasscheme": {
                this.addScheme(itemKey);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (MULTI_DIM_KEYS.contains(key)) {
            if (this.getModel().getValue(EXT_MODEL) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62d3\u5c55\u6a21\u578b\u3002", (String)"DataQueryAnalyticsPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openDimF7View(key);
        } else if (LIST_MODEL.equals(key)) {
            this.jumpIntoAnalysis(LIST_MODEL);
        } else if (ANALYSIS_MODEL.equals(key)) {
            this.jumpIntoAnalysis(ANALYSIS_MODEL);
        } else if (QUERY_BTN.equals(key)) {
            String value = (String)this.getModel().getValue(COMBO_FIELD);
            if (AnalyticsQueryTypeEnum.ExtData.getIndex().equals(value)) {
                this.queryExtData();
            } else {
                this.queryOlapData();
            }
        } else if (RESET_BTN.equals(key)) {
            this.updateFilterGrid();
        } else if (OPEN_AP.equals(key) || OPEN_LABLE_AP.equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FILTER_AP, CLOSE_AP});
            this.getView().setVisible(Boolean.FALSE, new String[]{OPEN_AP});
        } else if (CLOSE_AP.equals(key) || CLO_LABLE_AP.equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FILTER_AP, CLOSE_AP});
            this.getView().setVisible(Boolean.TRUE, new String[]{OPEN_AP});
        } else if (STRETCH_BTN.equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{HEIG_FILTER_AP, RETRACT_BTN});
            this.getView().setVisible(Boolean.FALSE, new String[]{STRETCH_BTN});
        } else if (RETRACT_BTN.equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{HEIG_FILTER_AP, RETRACT_BTN});
            this.getView().setVisible(Boolean.TRUE, new String[]{STRETCH_BTN});
        } else {
            List dimNums = (List)this.getDims().get("dimsUpperCase");
            String dimLowNum = key.substring(5);
            Optional<String> dimOp = dimNums.stream().filter(x -> x.equalsIgnoreCase(dimLowNum)).findFirst();
            if (dimOp.isPresent()) {
                this.showExtMultiF7(key, dimOp.get());
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (MULTI_DIM_KEYS.contains(actionId)) {
            this.getAndSetExtF7Value(actionId, evt);
        } else if ("close".equals(actionId)) {
            this.getView().close();
        } else if (ADD_SCHEME.equals(actionId) || SAVE_AS_SCHEME.equals(actionId)) {
            this.handleSaveScheme(evt, actionId);
        } else if (SCHEME_LIST.equals(actionId)) {
            this.schemeListCloseBackEvt(evt);
        } else {
            List dimNums = (List)this.getDims().get("dimsUpperCase");
            String dimLowNum = actionId.substring(5);
            Optional<String> dimOp = dimNums.stream().filter(x -> x.equalsIgnoreCase(dimLowNum)).findFirst();
            if (dimOp.isPresent()) {
                this.getAndSetOlapF7Value(actionId, evt);
            } else {
                Object returnData = evt.getReturnData();
                if (returnData != null) {
                    Map map = (Map)evt.getReturnData();
                    if ("ok".equals(map.get("status"))) {
                        this.getModel().setValue(COMBO_FIELD, (Object)"0");
                    } else {
                        this.getView().close();
                    }
                }
            }
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        String name = e.getProperty().getName();
        Set dimNums = ((List)this.getDims().get("dims")).stream().map(x -> SING_PREFIX + x).collect(Collectors.toSet());
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue == null || StringUtils.isEmpty((String)newValue.toString())) {
            DimensionScope dimensionScope;
            Map multiF7Map;
            String f7MapCache;
            if (MULTI_DIM_KEYS.contains(name)) {
                this.getPageCache().remove(name);
            } else if (dimNums.contains(name) && StringUtils.isNotEmpty((String)(f7MapCache = this.getPageCache().get(f7MapCACHEKEY))) && (multiF7Map = (Map)this.deSerializedBytes(f7MapCache)) != null && (dimensionScope = (DimensionScope)multiF7Map.get(name)) != null) {
                dimensionScope.clear();
                this.getPageCache().remove(name);
                this.getPageCache().put(f7MapCACHEKEY, this.toByteSerialized(multiF7Map));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "model": {
                this.updateModel(e);
                break;
            }
            case "extmodel": {
                this.updateFilterGrid();
                break;
            }
            case "combofield": {
                this.propertyChangedOfCombField();
                break;
            }
            case "filterscheme": {
                this.overValueByScheme((String)this.getModel().getValue(FILTER_SCHEME));
                break;
            }
        }
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        ReportList reportList = (ReportList)this.getControl(REPORT_LIST_AP);
        ArrayList selRows = (ArrayList)reportList.getEntryState().get("selRows");
        int pageRows = reportList.getEntryState().getPageRows();
        if (!data.isEmpty() && !selRows.isEmpty() && pageRows != selRows.size()) {
            Iterator arg5 = data.iterator();
            while (arg5.hasNext()) {
                DynamicObject dyo = (DynamicObject)arg5.next();
                int fseq = (Integer)dyo.get("fseq");
                if (selRows.contains(fseq)) continue;
                arg5.remove();
            }
        }
        Map<String, String> mappedToCol = this.getMappedToCol();
        for (DynamicObject rowData : data) {
            for (Map.Entry<String, String> entry : mappedToCol.entrySet()) {
                IDNumberTreeNode member;
                String field = entry.getKey();
                String entityNum = entry.getValue();
                String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
                if (!StringUtils.isNotEmpty((String)rowData.getString(field)) || (member = MemberReader.findMemberByNumber((String)modelNum, (String)entityNum, (String)rowData.getString(field))) == IDNumberTreeNode.NotFoundTreeNode) continue;
                rowData.set(field, (Object)(member.getNumber() + " | " + member.getName()));
            }
        }
        this.writeLog(ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"ExtendDataRptFormPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bfc\u51fa\u62d3\u5c55\u6570\u636e\u6210\u529f", (String)"ExtendDataRptFormPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        Object amount = ThreadCache.get((Object)"amount");
        if (amount != null) {
            this.getPageCache().put("total", amount.toString());
        }
        this.writeLog(ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ExtendDataRptFormPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u67e5\u8be2\u62d3\u5c55\u6570\u636e\u6210\u529f", (String)"ExtendDataRptFormPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        Map customParam = queryParam.getCustomParam();
        customParam.put("extendsModel", this.getExtendsModel(((DynamicObject)this.getModel().getValue(EXT_MODEL)).getLong("id")));
        HashMap<String, Object> dim2Mems = new HashMap<String, Object>(16);
        for (String multiDimKey : MULTI_DIM_KEYS) {
            String multiStr = this.getPageCache().get(multiDimKey);
            if (!StringUtils.isNotEmpty((String)multiStr)) continue;
            List results = (List)SerializationUtils.fromJsonString((String)multiStr, List.class);
            this.getAllMembersOfScope(multiDimKey, this.getModelId(), results, dim2Mems);
        }
        dim2Mems.put(PROCESS_F7, ((DynamicObject)this.getModel().getValue(PROCESS_F7)).getString("number"));
        dim2Mems.put(AUDITTRAIL_F7, ((DynamicObject)this.getModel().getValue(AUDITTRAIL_F7)).getString("number"));
        customParam.put("dim2Mems", dim2Mems);
        customParam.put(MODEL_DY, this.getModel().getValue(MODEL_DY));
        QFilter highFilter = this.getExtHighQFilter();
        if (highFilter != null) {
            queryParam.getFilter().setQFilters(Collections.singletonList(highFilter));
        }
    }

    private void updateModel(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (newValue == null) {
            this.setValue(MODEL_DY, oldValue);
        } else {
            String modelId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)MODEL_DY);
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (String)modelId);
            this.getPageCache().put("KEY_MODEL_ID", modelId);
            this.getPageCache().remove("ext_query");
            this.getPageCache().remove("olap_query");
            this.handlePageCache(modelId);
            this.setCombsValueOfScheme(null);
            if (Boolean.FALSE.toString().equals(this.getPageCache().get("isHaveScheme"))) {
                String queryType = (String)this.getModel().getValue(COMBO_FIELD);
                if (AnalyticsQueryTypeEnum.OlapData.getIndex().equals(queryType)) {
                    this.createMutiF7();
                } else {
                    DynamicObject defaultExtendModel = this.getDefaultExtendModel(modelId);
                    this.getModel().setValue(EXT_MODEL, (Object)defaultExtendModel);
                }
            }
        }
    }

    private void getAllMembersOfScope(String dimNum, long modelId, List<Map<String, String>> results, Map<String, Object> dim2Mems) {
        ArrayList<String> memNums = new ArrayList<String>(10);
        ArrayList<String> entIds = new ArrayList<String>(10);
        HashMap<Long, String> id2Nums = new HashMap<Long, String>(16);
        String entityName = SysDimensionEnum.getEnumByNumberIgnoreCase((String)dimNum.replace(MUL_PRE, "")).getMemberTreemodel();
        for (Map<String, String> map : results) {
            String pid = map.get("pid");
            if (StringUtils.isEmpty((String)pid) || "0".equals(pid)) {
                this.getAllMemsByScope(map, memNums, entIds, id2Nums, entityName);
                continue;
            }
            Set memIds = QueryMemberDetailsHelper.getMemberIdsByDefinedRange((String)entityName, (Long)Long.parseLong(map.get("id")), (int)Integer.parseInt(map.get("scope")), (String)Long.toString(modelId), (DetailTypeEnum)DetailTypeEnum.OTHERS);
            this.getAllNumsByIds(memIds, memNums, id2Nums);
        }
        if (id2Nums.size() == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u8303\u56f4\u4e0b\uff0c%s\u7ef4\u5ea6\u7684\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"DataQueryAnalyticsPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.getDimTypesEnumByNumber((String)dimNum.replace(MUL_PRE, "")).getName()));
        }
        if (MUL_ENTITY_F7.equals(dimNum)) {
            dim2Mems.put(dimNum, id2Nums);
        } else {
            dim2Mems.put(dimNum, memNums);
        }
    }

    private void showExtMultiF7(String key, String dimNum) {
        DynamicObject dim = QueryDimensionServiceHelper.getMsgByNumber((long)this.getModelId(), (String)dimNum);
        FormShowParameter para = new FormShowParameter();
        if (dimNum.equalsIgnoreCase(DimTypesEnum.INTERCOMPANY.getNumber())) {
            para.setFormId("bcm_mulmemberf7_tem_ic");
        } else {
            para.setFormId("bcm_mulmemberf7base_tem");
        }
        para.getOpenStyle().setShowType(ShowType.Modal);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dimension", dim.getInt("dseq") + "");
        params.put("sign", key);
        params.put(key, this.getPageCache().get(key));
        params.put("isHiddenLocalradio", Boolean.TRUE.toString());
        para.setCustomParams(params);
        para.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"ConvertDiffRangePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dim.getString("name")));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private void propertyChangedOfCombField() {
        Object value = this.getModel().getValue(MODEL_DY);
        if (value == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExtendDataRptFormPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.clearDimValuesAndCache();
        String queryType = (String)this.getModel().getValue(COMBO_FIELD);
        if (AnalyticsQueryTypeEnum.ExtData.getIndex().equals(queryType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{EXT_MODEL, EXT_FILTER_AP, REPORT_LIST_AP});
            this.getView().setVisible(Boolean.FALSE, new String[]{OLAP_PANEL_AP, RESULT_PANEL_AP});
            DynamicObject defaultExtendModel = this.getDefaultExtendModel(String.valueOf(this.getModelId()));
            if (defaultExtendModel != null) {
                this.updateFieldValueNoProperty(EXT_MODEL, defaultExtendModel);
            }
            this.updateFilterGrid();
            ((ReportList)this.getControl(REPORT_LIST_AP)).initEmptyGrid();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{EXT_MODEL, EXT_FILTER_AP, REPORT_LIST_AP});
            this.getView().setVisible(Boolean.TRUE, new String[]{OLAP_PANEL_AP, RESULT_PANEL_AP});
            this.updateFilterGrid();
            this.createMutiF7();
            CommandParam com = new CommandParam("bcm_dataqueryanalytics", "bcm_query_result", "clearData", new Object[0]);
            this.sendMsg((IFormView)this.getView(), com);
        }
        this.updateFieldValueNoProperty(FILTER_SCHEME, null);
    }

    private void createMutiF7() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExtendDataRptFormPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<DynamicObject> cols = this.getAllDimensions();
        ArrayList dimensions = new ArrayList(10);
        cols.forEach(p -> dimensions.add(Pair.onePair((Object)p.getString("number"), (Object)p.getString("name"))));
        Area area = new Area(OLAP_FILTER_AP);
        HashMap sign2DimNumber = new HashMap(8);
        HashMap f7DimModels = new HashMap(8);
        SchemeContext schemeContext = new SchemeContext(modelId);
        dimensions.stream().forEach(p -> {
            String sign = SING_PREFIX + ((String)p.p1).toLowerCase(Locale.ENGLISH);
            f7DimModels.put(sign, new DimensionScope(String.valueOf(modelId), schemeContext.getDimensionByNumber((String)p.p1)));
            sign2DimNumber.put(sign, p.p1);
            TextEditElement element = new TextEditElement((String)p.p2, sign, DimensionServiceHelper.getDimMembEntityNumByDimNum((String)((String)p.p1)));
            Style style = element.getStyle();
            Margin margin = new Margin();
            margin.setTop("1px");
            margin.setBottom("10px");
            margin.setRight("30px");
            style.setMargin(margin);
            if (MUSTINPUT.contains(p.p1)) {
                element.setMustInput(true);
            }
            element.setCustomStyle(fieldAp -> {
                FieldAp newfilap = (FieldAp)fieldAp;
                newfilap.setBackColor("#fafafa");
            });
            element.setNumber((String)p.p1);
            element.setFontSize(12);
            element.setLabelWidth(new LocaleString("50px"));
            element.setWidth(new LocaleString("12%"));
            area.addElement((Element)element);
        });
        this.getPageCache().put(f7MapCACHEKEY, this.toByteSerialized(f7DimModels));
        Page page = new Page();
        page.addArea(area);
        this.setPage((IFormView)this.getView(), page);
        page.updatePage((IFormView)this.getView());
    }

    private void openDimF7View(String key) {
        String dimNum = key.replace(MUL_PRE, "");
        Optional<DynamicObject> opDimDy = MemberReader.getDimDyoByModelId((long)this.getModelId()).values().stream().filter(x -> dimNum.equalsIgnoreCase(x.getString("number"))).findFirst();
        if (!opDimDy.isPresent()) {
            return;
        }
        DynamicObject dimDy = opDimDy.get();
        String name = dimDy.getString("name");
        FormShowParameter para = new FormShowParameter();
        if ("InternalCompany".equalsIgnoreCase(dimNum)) {
            para.setFormId("bcm_mulmemberf7_tem_ic");
            para.setCustomParam("sign", (Object)(key + "_" + DimTypesEnum.INTERCOMPANY.getNumber()));
        } else {
            para.setFormId("bcm_mulmemberf7base_tem");
            para.setCustomParam("sign", (Object)key);
        }
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("dimensionid", (Object)dimDy.getLong("id"));
        para.setCustomParam("dimension", dimDy.getInt("dseq") > 0 ? Integer.valueOf(dimDy.getInt("dseq")) : "-1");
        para.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        para.setCustomParam("isHiddenLocalradio", (Object)Boolean.TRUE.toString());
        para.setCaption(String.format(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - %s", (String)"ExtDimMemberEdit_06", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private void setHighFilter() {
        String value = (String)this.getModel().getValue(COMBO_FIELD);
        if (AnalyticsQueryTypeEnum.ExtData.getIndex().equals(value)) {
            this.setExtHighFilter();
        } else {
            this.setOlapHighFilter();
        }
    }

    private void setOlapHighFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRID_AP);
        filterGrid.setEntityNumber("random");
        filterGrid.setEntityNumber("bcm_extenddata");
        List dimNums = (List)this.getDims().get("dimsUpperCase");
        BiMap<String, String> dimNum2Fields = this.getMappedOfDimensions("bcm_extenddata", dimNums);
        ArrayList<Object> keys = new ArrayList<Object>(10);
        for (String dimNum : dimNums) {
            keys.add(dimNum2Fields.get((Object)dimNum));
        }
        filterGrid.setFilterFieldKeys(keys);
    }

    private BiMap<String, String> getMappedOfDimensions(String entityName, List<String> dimNums) {
        long modelId = this.getModelId();
        String fieldMappedCache = this.getPageCache().get("field_mapped" + modelId);
        if (StringUtils.isNotEmpty((String)fieldMappedCache)) {
            return (BiMap)this.deSerializedBytes(fieldMappedCache);
        }
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)entityName).getProperties();
        HashBiMap dimNum2Fields = HashBiMap.create();
        HashSet<String> sets = new HashSet<String>(10);
        block0: for (String dimNum : dimNums) {
            for (IDataEntityProperty property : properties) {
                String name = property.getName().toLowerCase(Locale.ENGLISH);
                if (property.getPropertyType() != String.class || !sets.add(name)) continue;
                dimNum2Fields.put((Object)dimNum, (Object)name);
                continue block0;
            }
        }
        this.getPageCache().put("field_mapped" + modelId, this.toByteSerialized(dimNum2Fields));
        return dimNum2Fields;
    }

    private void setExtHighFilter() {
        Object extendmodel = this.getModel().getValue(EXT_MODEL);
        if (extendmodel != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRID_AP);
            long extendModelId = ((DynamicObject)extendmodel).getLong("id");
            ExtendsModel extendsModel = new ExtendsModel(Long.valueOf(extendModelId));
            if (ExtendDimGroupType.EQUITY.getIndex().equals(extendsModel.getExtendsGroupType())) {
                this.getModel().setValue(EXT_MODEL, null);
                return;
            }
            this.getView().getPageCache().put("extendsModel_" + extendModelId, this.toByteSerialized(extendsModel));
            String extendDataEntity = "bcm_extenddata";
            if (ExtendDimGroupType.TRANSACTION.getIndex().equals(extendsModel.getExtendsGroupType())) {
                extendDataEntity = "bcm_extenddata_bus";
            }
            filterGrid.setEntityNumber("random");
            filterGrid.setEntityNumber(extendDataEntity);
            List fieldEntries = extendsModel.getFieldEntry();
            Map<String, String> dimFieldMapped = this.getDimFieldMapped();
            ArrayList<String> keys = new ArrayList<String>(10);
            for (FieldEntry fieldEntry : fieldEntries) {
                String dataField;
                if (FieldTypeEnum.DIM_FIELD.getType() == fieldEntry.getFieldType()) {
                    dataField = dimFieldMapped.get(fieldEntry.getDimension().getNumber());
                    keys.add(dataField);
                    continue;
                }
                if (FieldTypeEnum.EXT_FIELD.getType() != fieldEntry.getFieldType()) continue;
                dataField = fieldEntry.getExtField().getMapped();
                keys.add(dataField);
            }
            filterGrid.setFilterFieldKeys(keys);
        }
    }

    private void filterCondition(List<Map<String, Object>> filterColumns) {
        for (Map<String, Object> map : filterColumns) {
            ArrayList compareTypes = (ArrayList)map.get("compareTypes");
            Iterator iterator = compareTypes.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (obj instanceof CompareTypeDto) {
                    CompareTypeDto compareType = (CompareTypeDto)obj;
                    if (this.conditions.contains(compareType.getId())) continue;
                    iterator.remove();
                    continue;
                }
                if (this.conditions.contains(((LinkedHashMap)obj).get("id"))) continue;
                iterator.remove();
            }
        }
    }

    private Map<String, String> getDimFieldMapped() {
        Map<String, String> dimsLoadMap;
        LinkedHashMap fieldMapped = Maps.newLinkedHashMap();
        long modelId = this.getModelId();
        QFilter filter = new QFilter(MODEL_DY, "=", (Object)modelId);
        String mappingStr = this.getPageCache().get("dimMapping_" + modelId);
        if (StringUtils.isEmpty((String)mappingStr)) {
            dimsLoadMap = QueryServiceHelper.query((String)"bcm_dimension", (String)"number, fieldmapped", (QFilter[])new QFilter[]{filter}).stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), dynamicObject -> dynamicObject.getString("fieldmapped")));
            this.getPageCache().put("dimMapping_" + modelId, this.toByteSerialized(dimsLoadMap));
        } else {
            dimsLoadMap = (Map<String, String>)this.deSerializedBytes(mappingStr);
        }
        dimsLoadMap.forEach((k, v) -> {
            String mapped = v;
            if (StringUtils.isEmpty((String)v)) {
                mapped = SysDimensionEnum.getEnumByNumber((String)k).getSign();
            }
            fieldMapped.put(k, mapped);
        });
        fieldMapped.put(ORG, ORG);
        return fieldMapped;
    }

    private void setFilterGridName() {
        String value = (String)this.getModel().getValue(COMBO_FIELD);
        if (AnalyticsQueryTypeEnum.ExtData.getIndex().equals(value)) {
            this.setExtFilterGridName();
        } else {
            this.setOlapFilterGridName();
        }
    }

    private void setOlapFilterGridName() {
        Map<String, Object> dims = this.getDims();
        List allDimensions = (List)dims.get("dimNum2Names");
        List dimNums = (List)dims.get("dimsUpperCase");
        HashMap<Object, String> markToNumber = new HashMap<Object, String>(16);
        for (Pair dim : allDimensions) {
            markToNumber.put(dim.p1, (String)dim.p1 + "-" + (String)dim.p2);
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRID_AP);
        BiMap<String, String> dimNum2Fields = this.getMappedOfDimensions("bcm_extenddata", dimNums);
        BiMap field2dimNums = dimNum2Fields.inverse();
        List filterColumns = filterGrid.getFilterColumns();
        for (Map col : filterColumns) {
            col.compute("fieldName", (kFN, vFN) -> {
                String value = (String)markToNumber.get(field2dimNums.get(vFN));
                if (value != null) {
                    this.setColName(col, value);
                }
                return vFN;
            });
        }
        this.filterCondition(filterColumns);
    }

    private void setExtFilterGridName() {
        Object extendmodel = this.getModel().getValue(EXT_MODEL);
        if (extendmodel != null) {
            long extendModelId = ((DynamicObject)extendmodel).getLong("id");
            ExtendsModel extendsModel = (ExtendsModel)this.deSerializedBytes(this.getPageCache().get("extendsModel_" + extendModelId));
            List fieldEntries = extendsModel.getFieldEntry();
            Map<String, String> dimFieldMapped = this.getDimFieldMapped();
            HashMap<String, String> markToNumber = new HashMap<String, String>(16);
            for (FieldEntry fieldEntry : fieldEntries) {
                String dataField = "";
                if (FieldTypeEnum.DIM_FIELD.getType() == fieldEntry.getFieldType()) {
                    dataField = dimFieldMapped.get(fieldEntry.getDimension().getNumber());
                } else if (FieldTypeEnum.EXT_FIELD.getType() == fieldEntry.getFieldType()) {
                    dataField = fieldEntry.getExtField().getMapped();
                }
                markToNumber.put(dataField, fieldEntry.getNumber() + "-" + fieldEntry.getName());
            }
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRID_AP);
            List filterColumns = filterGrid.getFilterColumns();
            for (Map col : filterColumns) {
                col.compute("fieldName", (kFN, vFN) -> {
                    String value = (String)markToNumber.get(vFN);
                    if (value != null) {
                        this.setColName(col, dimFieldMapped.containsValue(vFN) ? String.format(ResManager.loadKDString((String)"%s \u7ef4\u5ea6\u6210\u5458\u7f16\u7801", (String)"ExtendDataRptFormPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), value) : String.format(ResManager.loadKDString((String)"%s \u62d3\u5c55\u5b57\u6bb5\u503c", (String)"ExtendDataRptFormPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), value));
                    }
                    return vFN;
                });
            }
            this.filterCondition(filterColumns);
        }
    }

    private DynamicObject getDefaultExtendModel(String modelId) {
        DynamicObject defaultExtendModel = null;
        if (StringUtils.isNotEmpty((String)modelId)) {
            defaultExtendModel = BusinessDataServiceHelper.loadSingle((String)"bcm_extendsmodel", (String)"id,number,name", (QFilter[])new QFilter(MODEL_DY, "=", (Object)Long.parseLong(modelId)).and("extendsgroup.grouptype", "in", this.getNoEquityExtendGroupType()).toArray());
        }
        return defaultExtendModel;
    }

    private QFilter getQFilterByFilterCondition(String filterGridName, String entityName, long userId, String appNum) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(filterGridName);
        FilterCondition fc = filterGrid.getFilterGridState().getFilterCondition();
        String ruleStr = "";
        if (fc != null && !CollectionUtils.isEmpty((Collection)fc.getFilterRow())) {
            ruleStr = SerializationUtils.toJsonString((Object)fc);
        }
        DataRuleResult dataRuleResult = new DataRuleResult();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        String checkPermOrgKey = PermCommonUtil.getCheckPermOrg((MainEntityType)dataEntityType);
        if (StringUtils.isEmpty((String)checkPermOrgKey)) {
            dataRuleResult.setNeedDimCtrl(false);
        }
        DataRuleSingleResult drsr = new DataRuleSingleResult();
        drsr.setFilterJson(ruleStr);
        dataRuleResult.getSingleResultList().add(drsr);
        QFilter qfilter = PermCommonUtil.convertDataRuleResultToQFilter((DataRuleResult)dataRuleResult, (long)userId, (String)appNum, (String)entityName);
        return PermCommonUtil.convertQFilter((String)entityName, (QFilter)qfilter);
    }

    private ReportColumn addDefineColumn(String label, LocaleString localeString, String type) {
        ReportColumn reportColumn = new ReportColumn();
        if ("decimal".equals(type)) {
            reportColumn = new DecimalReportColumn();
            reportColumn.setScale(16);
            reportColumn.setNoDisplayScaleZero(true);
            ((DecimalReportColumn)reportColumn).setSummary(1);
        }
        reportColumn.setCaption(localeString);
        reportColumn.setWidth(new LocaleString("100px"));
        reportColumn.setFieldKey(label);
        reportColumn.setFieldType(type);
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setTextAlign("center");
        reportColumn.setStyle(columnStyle);
        return reportColumn;
    }

    private List<String> getNoEquityExtendGroupType() {
        return Arrays.stream(ExtendDimGroupType.values()).filter(value -> value != ExtendDimGroupType.EQUITY).map(ExtendDimGroupType::getIndex).collect(Collectors.toList());
    }

    private void setVisiableOfPanelAp() {
        this.getView().setVisible(Boolean.FALSE, new String[]{EXT_MODEL, EXT_FILTER_AP, LIGHT_ANALYTICS_AP, HEIG_FILTER_AP, OPEN_AP, RETRACT_BTN, REPORT_LIST_AP});
    }

    private void setColName(Map<String, Object> col, String name) {
        col.compute("fieldCaption", (kFC, vFC) -> new LocaleString(name).getLocaleValue());
    }

    public AbstractFormPlugin getPlugin() {
        return this;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        if (this instanceof DynamicPage) {
            try {
                MainEntityType copy = (MainEntityType)e.getOriginalEntityType().clone();
                e.setNewEntityType(copy);
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            super.getEntityType(e);
        }
    }

    public boolean needCache() {
        return Boolean.FALSE;
    }

    private ExtendsModel getExtendsModel(long extId) {
        String extStr = this.getView().getPageCache().get("extendsModel_" + extId);
        if (StringUtils.isEmpty((String)extStr)) {
            ExtendsModel extendsModel = new ExtendsModel(Long.valueOf(extId));
            this.getView().getPageCache().put("extendsModel_" + extId, this.toByteSerialized(extendsModel));
        }
        return (ExtendsModel)this.deSerializedBytes(this.getView().getPageCache().get("extendsModel_" + extId));
    }

    private void getAllMemsByScope(Map<String, String> memScope, List<String> entNums, List<String> entIds, Map<Long, String> id2Nums, String entityName) {
        String scopeValue = memScope.get("scope");
        if ("10".equals(scopeValue)) {
            String number = memScope.get("number");
            Long id = Long.parseLong(memScope.get("id"));
            entNums.add(memScope.get("number"));
            entIds.add(memScope.get("id"));
            id2Nums.put(id, number);
        } else {
            Map result = QueryMemberDetailsHelper.getMemberInfoByRange((String)entityName, (Long)Long.parseLong(memScope.get("id")), (String)memScope.get("number"), (int)Integer.parseInt(scopeValue), (String)String.valueOf(this.getModelId()));
            entNums.addAll((Set)result.get("numbers"));
            entIds.addAll((Set)result.get("ids"));
            id2Nums.putAll((Map)result.get("id2Nums"));
        }
    }

    private void getAllNumsByIds(Set<Long> entIds, List<String> entNums, Map<Long, String> id2Nums) {
        QFilter qf = new QFilter("id", "in", entIds);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, number, storagetype", (QFilter[])qf.toArray());
        result.forEach(x -> {
            String number = x.getString("number");
            Long id = x.getLong("id");
            entNums.add(number);
            id2Nums.put(id, number);
        });
    }

    private void writeLog(String opName, String opDescription) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)opDescription, (Long)this.getModelId(), (String)this.getModel().getDataEntityType().getName());
        logService.addLog(logInfo);
    }

    private Map<String, String> getMappedToCol() {
        if (this.mappedToCol.isEmpty()) {
            Map<String, String> dimFieldMapped = this.getDimFieldMapped();
            Object extendmodel = this.getModel().getValue(EXT_MODEL);
            if (extendmodel != null) {
                long extendModelId = ((DynamicObject)extendmodel).getLong("id");
                ExtendsModel extendsModel = (ExtendsModel)this.deSerializedBytes(this.getPageCache().get("extendsModel_" + extendModelId));
                for (DimFieldEntry fieldEntry : extendsModel.getDimFieldEntry()) {
                    String mapped = dimFieldMapped.get(fieldEntry.getDimension().getNumber());
                    this.mappedToCol.put(mapped, fieldEntry.getDimension().getNumber());
                }
            }
            this.mappedToCol.put("src_entity", DimTypesEnum.ENTITY.getNumber());
            this.mappedToCol.put(ORG, DimTypesEnum.ENTITY.getNumber());
            for (String dimKey : MULTI_DIM_KEYS) {
                dimKey = dimKey.replace(MUL_PRE, "");
                if (DimTypesEnum.ENTITY.getNumber().toLowerCase(Locale.ENGLISH).equals(dimKey) || SysDimensionEnum.getEnumByLowerCaseNumber((String)dimKey) == null) continue;
                this.mappedToCol.put(dimKey.toLowerCase(Locale.ENGLISH) + FIX_SUF, SysDimensionEnum.getEnumByLowerCaseNumber((String)dimKey).getNumber());
            }
        }
        return this.mappedToCol;
    }

    private QFilter getExtHighQFilter() {
        DynamicObject extDy = (DynamicObject)this.getModel().getValue(EXT_MODEL);
        long extendModelId = extDy.getLong("id");
        ExtendsModel extModel = this.getExtendsModel(extendModelId);
        String extendDataEntity = "bcm_extenddata";
        if (ExtendDimGroupType.TRANSACTION.getIndex().equals(extModel.getExtendsGroupType())) {
            extendDataEntity = "bcm_extenddata_bus";
        }
        return this.getQFilterByFilterCondition(FILTER_GRID_AP, extendDataEntity, RequestContext.get().getCurrUserId(), this.getApplicationType().getAppnum());
    }

    private void setOlapHighQFilter(QFilter qFilter, Map<String, Object> paramValues) {
        String[] arrays = qFilter.toString().split(" ");
        if (arrays.length > 0) {
            List dimNums = (List)this.getDims().get("dimsUpperCase");
            BiMap fields2Dims = this.getMappedOfDimensions("bcm_extenddata", dimNums).inverse();
            for (int i = 0; i < arrays.length; i += 4) {
                String value;
                Set<Object> nums = (HashSet)paramValues.get(fields2Dims.get((Object)arrays[i]));
                if (CollectionUtils.isEmpty((Collection)nums)) {
                    String entityNumber = SysDimensionEnum.getMemberTreemodelByNumber((String)((String)fields2Dims.get((Object)arrays[i])));
                    Map allNodeFromCache = MemberReader.getAllNodeFromCache((String)entityNumber, (Object)this.getModelId());
                    nums = allNodeFromCache != null ? allNodeFromCache.values().stream().map(x -> x.getNumber()).collect(Collectors.toSet()) : new HashSet(0);
                }
                if (nums.size() <= 0) continue;
                String logic = arrays[i + 1];
                if ("=".equalsIgnoreCase(logic)) {
                    value = arrays[i + 2].replace("'", "");
                    paramValues.put((String)fields2Dims.get((Object)arrays[i]), nums.stream().filter(x -> x.equalsIgnoreCase(value)).collect(Collectors.toSet()));
                    continue;
                }
                if ("IN".equalsIgnoreCase(logic)) {
                    value = arrays[i + 2];
                    HashSet values = Sets.newHashSet((Object[])value.substring(1, value.length() - 1).split(","));
                    Set trueValues = values.stream().map(x -> x.replace("'", "")).collect(Collectors.toSet());
                    paramValues.put((String)fields2Dims.get((Object)arrays[i]), nums.stream().filter(x -> trueValues.contains(x)).collect(Collectors.toSet()));
                    continue;
                }
                value = arrays[i + 2].replace("'", "").replace("%", "");
                paramValues.put((String)fields2Dims.get((Object)arrays[i]), nums.stream().filter(x -> x.contains(value)).collect(Collectors.toSet()));
            }
        }
    }

    private void getAndSetExtF7Value(String actionId, ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        DynamicObjectCollection memScopes = (DynamicObjectCollection)evt.getReturnData();
        this.setAndCacheExtDimsValue(actionId, memScopes);
    }

    private void setAndCacheExtDimsValue(String actionId, DynamicObjectCollection memScopes) {
        if (memScopes == null || memScopes.size() == 0) {
            this.getModel().setValue(actionId, (Object)"");
            this.getPageCache().put(actionId, "");
        } else {
            StringBuilder sb = new StringBuilder();
            ArrayList list = new ArrayList(10);
            for (DynamicObject dot : memScopes) {
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("id", dot.get(4).toString());
                map.put("scope", dot.get(5).toString());
                map.put("number", dot.get(2).toString());
                map.put("name", dot.get(3).toString());
                map.put("pid", dot.get(6).toString());
                this.buildPageViewShowName(sb, dot.get(3).toString(), dot.getInt(5));
                map.put("dimKey", actionId);
                list.add(map);
            }
            if (StringUtils.isEmpty((String)sb.toString())) {
                this.getModel().setValue(actionId, (Object)sb.toString());
                this.getPageCache().remove(actionId);
            } else {
                this.getModel().setValue(actionId, (Object)sb.substring(0, sb.length() - 1));
                this.getPageCache().put(actionId, SerializationUtils.toJsonString(list));
            }
        }
    }

    private void setAndCacheOlapDimValue(String actionId, DynamicObjectCollection doc) {
        Map f7DimModels = (Map)this.deSerializedBytes(this.getPageCache().get(f7MapCACHEKEY));
        DimensionScope dimScope = (DimensionScope)f7DimModels.get(actionId);
        dimScope.clear();
        if (doc != null && doc.size() != 0) {
            ArrayList list = new ArrayList(10);
            for (DynamicObject dyn : doc) {
                long id = dyn.getLong(4);
                int scope = dyn.getInt(5);
                dimScope.addDimeMemRange(id, scope);
                this.getModel().setValue(actionId, (Object)dimScope.toString());
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("id", dyn.get(4).toString());
                map.put("scope", dyn.get(5).toString());
                map.put("number", dyn.get(2).toString());
                map.put("name", dyn.get(3).toString());
                map.put("pid", dyn.get(6).toString());
                list.add(map);
            }
            if (list.size() == 0) {
                this.getPageCache().remove(actionId);
            } else {
                this.getPageCache().put(actionId, SerializationUtils.toJsonString(list));
            }
            this.getPageCache().put(f7MapCACHEKEY, this.toByteSerialized(f7DimModels));
        } else {
            this.getModel().setValue(actionId, (Object)"");
            this.getPageCache().put(actionId, "");
        }
    }

    private void getAndSetOlapF7Value(String actionId, ClosedCallBackEvent evt) {
        if (ThreadCache.get((Object)"okbtn") == null) {
            return;
        }
        DynamicObjectCollection doc = (DynamicObjectCollection)evt.getReturnData();
        this.setAndCacheOlapDimValue(actionId, doc);
    }

    private void queryExtData() {
        String msg = this.verifyExtQuery();
        if (StringUtils.isNotEmpty((String)msg)) {
            this.getView().showTipNotification(msg);
            return;
        }
        this.queryAndPackageExtDataColumns();
        this.showAnalysisView();
        this.getPageCache().put("ext_query", "true");
    }

    private void showAnalysisView() {
        ExtendsModel extendsModel = this.getExtendsModel(((DynamicObject)this.getModel().getValue(EXT_MODEL)).getLong("id"));
        HashSet multiDims = Sets.newHashSet(MULTI_DIM_KEYS);
        List dimFieldEntry = extendsModel.getDimFieldEntry();
        for (DimFieldEntry fieldEntry : dimFieldEntry) {
            multiDims.add(MUL_PRE + fieldEntry.getDimension().getNumber().toLowerCase(Locale.ENGLISH));
        }
        Map<String, Object> dimMap = this.getDimMap(multiDims, true);
        FormShowParameter fs = new FormShowParameter();
        fs.setFormId("bcm_far_pivot_inh");
        fs.getOpenStyle().setShowType(ShowType.InContainer);
        fs.getOpenStyle().setTargetKey(LIGHT_ANALYTICS_AP);
        fs.setCustomParam("onlyAnalysis", (Object)Boolean.TRUE);
        QFilter highFilter = this.getExtHighQFilter();
        if (highFilter != null) {
            fs.setCustomParam("filter", (Object)highFilter.toSerializedString());
        }
        fs.setCustomParam("modelId", (Object)this.getModelId());
        fs.setCustomParam("dimMap", dimMap.get("dim"));
        fs.setCustomParam("dproMap", dimMap.get("pro"));
        List extFieldEntries = extendsModel.getExtFieldEntry();
        fs.setCustomParam("fmoney", extFieldEntries.stream().map(x -> ((ExtField)x.get("extfield")).get("number").toString()).collect(Collectors.toSet()));
        fs.setCustomParam("extendsModelId", (Object)extendsModel.getId());
        fs.setCustomParam("extendsModelNumber", (Object)extendsModel.getNumber());
        fs.setCustomParam("type", (Object)AnalyticsQueryTypeEnum.ExtData.getIndex());
        fs.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
        this.getView().showForm(fs);
    }

    private void queryAndPackageExtDataColumns() {
        DynamicObject extDy = (DynamicObject)this.getModel().getValue(EXT_MODEL);
        long extendModelId = extDy.getLong("id");
        ReportList reportList = (ReportList)this.getControl(REPORT_LIST_AP);
        try {
            reportList.setSelectedAll(true);
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
        }
        List columns = reportList.getColumns();
        ExtendsModel extendsModel = this.getExtendsModel(extendModelId);
        Map<String, String> dimFieldMapped = this.getDimFieldMapped();
        columns.add(this.addDefineColumn(ORG, new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ExtendDataRptFormPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "text"));
        columns.add(this.addDefineColumn("src_entity", new LocaleString(ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"ExtendDataRptFormPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "text"));
        for (String dimKey : MULTI_DIM_KEYS) {
            if ((dimKey = dimKey.replace(MUL_PRE, "")).equals(DimTypesEnum.ENTITY.getNumber().toLowerCase(Locale.ENGLISH))) continue;
            columns.add(this.addDefineColumn(dimKey.toLowerCase(Locale.ENGLISH) + FIX_SUF, new LocaleString(MemberReader.getDimensionNameById((long)MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)DimEntityNumEnum.getNumberByLowercaseNumber((String)dimKey)))), "text"));
        }
        for (FieldEntry fieldEntry : extendsModel.getFieldEntry()) {
            ReportColumn reportColumn;
            if (FieldTypeEnum.DIM_FIELD.getType() == fieldEntry.getFieldType()) {
                String name = fieldEntry.getDimension().getName();
                reportColumn = this.addDefineColumn(dimFieldMapped.get(fieldEntry.getDimension().getNumber()), new LocaleString(name), "text");
            } else {
                ExtField extField = fieldEntry.getExtField();
                reportColumn = extField.getMapped().contains("numext") ? this.addDefineColumn(extField.getMapped(), new LocaleString(extField.getName()), "decimal") : (extField.getMapped().contains("dateext") ? this.addDefineColumn(extField.getMapped(), new LocaleString(extField.getName()), "date") : this.addDefineColumn(extField.getMapped(), new LocaleString(extField.getName()), "text"));
            }
            columns.add(reportColumn);
        }
        ((ReportFilter)this.getControl("reportfilterap")).search();
    }

    private String verifyExtQuery() {
        Object model = this.getModel().getValue(MODEL_DY);
        if (model == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExtendDataRptFormPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        Object extModel = this.getModel().getValue(EXT_MODEL);
        if (extModel == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62d3\u5c55\u6a21\u578b\u3002", (String)"DataQueryAnalyticsPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        for (String ele : MULTI_DIM_KEYS) {
            if (!StringUtils.isEmpty((String)this.getPageCache().get(ele))) continue;
            ele = ele.replace(MUL_PRE, "");
            return String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s", (String)"ExtendDataRptFormPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.getDimTypesEnumByNumber((String)ele).getName());
        }
        if (this.getModel().getValue(PROCESS_F7) == null) {
            return String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s", (String)"ExtendDataRptFormPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.PROCESS.getName());
        }
        if (this.getModel().getValue(AUDITTRAIL_F7) == null) {
            return String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s", (String)"ExtendDataRptFormPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.AUDITTRIAL.getName());
        }
        ExtendsModel extendsModel = this.getExtendsModel(((DynamicObject)this.getModel().getValue(EXT_MODEL)).getLong("id"));
        Object extendmodel = this.getModel().getValue(EXT_MODEL);
        if (extendmodel != null) {
            List fieldEntries = extendsModel.getFieldEntry();
            HashSet<String> fieldMaps = new HashSet<String>();
            for (FieldEntry fieldEntry : fieldEntries) {
                if (FieldTypeEnum.EXT_FIELD.getType() != fieldEntry.getFieldType() || fieldMaps.add(fieldEntry.getExtField().getMapped())) continue;
                return ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u5b57\u6bb5\u4e0e\u540e\u53f0\u7269\u7406\u8868\u5b57\u6bb5\u6620\u5c04\u5b58\u5728\u91cd\u590d\u9519\u8bef\u3002", (String)"ExtendDataRptFormPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private void queryOlapData() {
        String msg = this.verifyOlapQuery();
        if (StringUtils.isNotEmpty((String)msg)) {
            this.getView().showTipNotification(msg);
            return;
        }
        this.showAnalysisViewOfOlap();
        this.queryAndPackageOlapDataColumns();
        this.getPageCache().put("olap_query", "true");
    }

    private String verifyOlapQuery() {
        if (this.getModel().getValue(MODEL_DY) == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExtendDataRptFormPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        for (String dim : MUSTINPUT) {
            String value = (String)this.getModel().getValue(SING_PREFIX + dim.toLowerCase(Locale.ENGLISH));
            if (!StringUtils.isEmpty((String)value)) continue;
            return String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s", (String)"ExtendDataRptFormPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.getDimTypesEnumByNumber((String)dim).getName());
        }
        return "";
    }

    private void queryAndPackageOlapDataColumns() {
        long modelId = this.getModelId();
        List dimNums = (List)this.getDims().get("dimsUpperCase");
        Map dimDyMaps = MemberReader.getDimDyoByModelId((long)modelId);
        Map f7DimModels = (Map)this.deSerializedBytes(this.getPageCache().get(f7MapCACHEKEY));
        Map<String, Object> paramValues = this.getDimParamValues(modelId, dimNums, dimDyMaps, f7DimModels);
        QFilter qFilter = this.getQFilterByFilterCondition(FILTER_GRID_AP, "bcm_extenddata", RequestContext.get().getCurrUserId(), this.getApplicationType().getAppnum());
        for (String dim : MUSTINPUT) {
            Set numbers = (Set)paramValues.get(dim);
            if (!CollectionUtils.isEmpty((Collection)numbers)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6 %s \u6ca1\u6709\u627e\u5230\u6709\u6548\u6210\u5458\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DataQueryAnalyticsPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), DimTypesEnum.getDimTypesEnumByNumber((String)dim).getName()));
            return;
        }
        if (qFilter != null && StringUtils.isNotEmpty((String)qFilter.toString())) {
            this.setOlapHighQFilter(qFilter, paramValues);
        }
        paramValues.put(MODEL_DY, MemberReader.findModelNumberById((Object)modelId));
        paramValues.put("excludeDynaData", this.getModel().getValue("excludedynadata"));
        paramValues.put("includeCalType", false);
        paramValues.put("excludeNullData", this.getModel().getValue("excludeNullData"));
        paramValues.put("measures", FMONEY);
        paramValues.put("hidetabandbtn", Boolean.TRUE);
        ArrayList dimensionKey = new ArrayList(10);
        dimNums.forEach(p -> dimensionKey.add(p));
        paramValues.put("dimensionKey", dimensionKey);
        this.getQueryDataTabManger().resetOlapExcute((IFormView)this.getView());
        this.getQueryDataTabManger().addOlapQueryDataTabInfo(this.getPageIdAndCache(this.getPageCache(), "bcm_query_result"), ResManager.loadKDString((String)"\u591a\u7ef4\u67e5\u8be2\u7ed3\u679c", (String)"OlapQueryDataPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), paramValues).showTabView((IFormView)this.getView());
        this.cacheQueryDataTabManger();
    }

    private boolean filterNoPermMembers(Set<Long> ids, Set<String> numbers, Map<String, DynamicObject> dimDyMaps, String dimNum, long modelId) {
        DynamicObject dynamicObject = dimDyMaps.get(dimNum);
        if (dynamicObject == null) {
            throw new KDBizException("the dimension is not found");
        }
        long dimId = dynamicObject.getLong("id");
        String entityName = dynamicObject.getString("membermodel");
        List<IDNumberTreeNode> members = MemberReader.getAllNodeFromCache((String)entityName, (Object)modelId).values().stream().filter(x -> ids.contains(x.getId())).collect(Collectors.toList());
        Map<Long, String> id2Nums = members.stream().collect(Collectors.toMap(x -> x.getId(), y -> y.getNumber()));
        if (id2Nums.size() != ids.size()) {
            throw new KDBizException("the member ids size not equal numbers size");
        }
        Map<Long, List<Long>> relationMap = this.buildPCRelation(members);
        int formerSize = ids.size();
        this.delNoPermMember(id2Nums, relationMap, ids, numbers, modelId, dimId);
        if (ids.size() != formerSize) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Map<Long, List<Long>> buildPCRelation(List<IDNumberTreeNode> members) {
        HashMap<Long, List<Long>> relationMap = new HashMap<Long, List<Long>>();
        members.forEach(p -> {
            long id = p.getId();
            IDNumberTreeNode parent = p.getParent();
            if (parent != null && parent != IDNumberTreeNode.NotFoundTreeNode) {
                long parentId = parent.getId();
                if (relationMap.get(parentId) != null) {
                    ((List)relationMap.get(parentId)).add(id);
                } else {
                    ArrayList<Long> children = new ArrayList<Long>();
                    children.add(id);
                    relationMap.put(parentId, children);
                }
            }
        });
        return relationMap;
    }

    private void delNoPermMember(Map<Long, String> id2Nums, Map<Long, List<Long>> relationMap, Set<Long> ids, Set<String> numbers, long modelId, long dimId) {
        PermissionService service = PermissionServiceImpl.getInstance((Long)modelId);
        if (service.isAdmin()) {
            return;
        }
        Iterator<Map.Entry<Long, String>> iterator = id2Nums.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, String> next = iterator.next();
            Long memId = next.getKey();
            String memNum = next.getValue();
            if (service.memberCanShow(Long.valueOf(dimId), memId, relationMap)) continue;
            iterator.remove();
            ids.remove(memId);
            numbers.remove(memNum);
        }
    }

    protected QueryDataTabManger getQueryDataTabManger() {
        if (this.queryDataTabManger != null) {
            return this.queryDataTabManger;
        }
        this.queryDataTabManger = this.queryDataTabMangerCache.getQueryDataTabManger();
        if (this.queryDataTabManger == null) {
            this.queryDataTabManger = new QueryDataTabManger();
        }
        return this.queryDataTabManger;
    }

    protected void cacheQueryDataTabManger() {
        if (!ObjectUtils.isEmpty((Object)this.getQueryDataTabManger())) {
            this.queryDataTabMangerCache.cacheQueryDataTabManger(this.getQueryDataTabManger());
        }
    }

    private void exportExcel() {
        if (AnalyticsQueryTypeEnum.ExtData.getIndex().equals(this.getModel().getValue(COMBO_FIELD))) {
            String message = this.verifyExtQuery();
            if (StringUtils.isNotEmpty((String)message)) {
                this.getView().showTipNotification(message);
                return;
            }
            ReportList reportList = (ReportList)this.getControl(REPORT_LIST_AP);
            String url = reportList.exportExcel();
            this.downloadFile(url, "bcm_dataqueryanalytics", "1G2FW/G3YIL8");
            String opName = ResManager.loadKDString((String)"\u5bfc\u51fa\u62d3\u5c55\u6570\u636e", (String)"DataQueryAnalyticsPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String opDes = ResManager.loadKDString((String)"\u5bfc\u51fa\u62d3\u5c55\u6570\u636e\u6210\u529f", (String)"DataQueryAnalyticsPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            this.writeLog(opName, opDes);
        } else {
            String message = this.verifyOlapQuery();
            if (StringUtils.isNotEmpty((String)message)) {
                this.getView().showTipNotification(message);
                return;
            }
            CommandParam com = new CommandParam("bcm_dataqueryanalytics", "bcm_query_result", "exportOlapData", new Object[]{"bcm_dataqueryanalytics", "1G2FW/G3YIL8"});
            this.sendMsg((IFormView)this.getView(), com);
        }
    }

    private void refresh() {
        String value = (String)this.getModel().getValue(COMBO_FIELD);
        if (AnalyticsQueryTypeEnum.ExtData.getIndex().equals(value)) {
            this.queryExtData();
        } else {
            this.queryOlapData();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void jumpIntoAnalysis(String key) {
        if (AnalyticsQueryTypeEnum.ExtData.getIndex().equals(this.getModel().getValue(COMBO_FIELD))) {
            String extQuery = this.getPageCache().get("ext_query");
            if (StringUtils.isNotEmpty((String)extQuery) && Boolean.TRUE.toString().equals(extQuery)) {
                this.setVisibleOfAnalysis(key);
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u67e5\u8be2\u6570\u636e\u540e\u518d\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"DataQueryAnalyticsPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String olapQuery = this.getPageCache().get("olap_query");
        if (StringUtils.isNotEmpty((String)olapQuery) && Boolean.TRUE.toString().equals(olapQuery)) {
            this.setVisibleOfAnalysis(key);
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u67e5\u8be2\u6570\u636e\u540e\u518d\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"DataQueryAnalyticsPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private void setVisibleOfAnalysis(String key) {
        boolean flag = LIST_MODEL.equals(key);
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{LIST_AP});
        this.getView().setVisible(Boolean.valueOf(!flag), new String[]{LIGHT_ANALYTICS_AP});
        this.getPageCache().put("choise_model", key);
    }

    private void showAnalysisViewOfOlap() {
        long modelId = this.getModelId();
        List dimNums = (List)this.getDims().get("dimsUpperCase");
        Map dimDyMaps = MemberReader.getDimDyoByModelId((long)modelId);
        Map f7DimModels = (Map)this.deSerializedBytes(this.getPageCache().get(f7MapCACHEKEY));
        QFilter qFilter = this.getQFilterByFilterCondition(FILTER_GRID_AP, "bcm_extenddata", RequestContext.get().getCurrUserId(), this.getApplicationType().getAppnum());
        Map<Object, Object> map = new HashMap(16);
        if (qFilter == null || StringUtils.isEmpty((String)qFilter.toString())) {
            map = this.getDimMap(f7DimModels.keySet(), false);
        } else {
            Map<String, Object> paramValues = this.getDimParamValues(modelId, dimNums, dimDyMaps, f7DimModels);
            this.setOlapHighQFilter(qFilter, paramValues);
            map.put("dim", this.addSelfOfAllMembers(paramValues));
            map.put("pro", Lists.newArrayList());
        }
        FormShowParameter fs = new FormShowParameter();
        fs.setFormId("bcm_far_pivot_inh");
        fs.getOpenStyle().setShowType(ShowType.InContainer);
        fs.getOpenStyle().setTargetKey(LIGHT_ANALYTICS_AP);
        fs.setCustomParam("onlyAnalysis", (Object)Boolean.TRUE);
        fs.setCustomParam("modelId", (Object)this.getModelId());
        fs.setCustomParam("dimMap", map.get("dim"));
        fs.setCustomParam("dproMap", map.get("pro"));
        fs.setCustomParam("excludeDynaData", this.getModel().getValue("excludedynadata"));
        fs.setCustomParam("excludeNullData", this.getModel().getValue("excludeNullData"));
        fs.setCustomParam("fmoney", (Object)FMONEY);
        fs.setCustomParam("type", (Object)AnalyticsQueryTypeEnum.OlapData.getIndex());
        fs.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
        this.getView().showForm(fs);
    }

    private Map<String, Object> getDimMap(Set<String> multiDimKeys, boolean isExt) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        HashMap dimMap = new HashMap(16);
        ArrayList dproLists = new ArrayList(10);
        String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
        Collection values = MemberReader.getDimDyoByModelId((long)this.getModelId()).values();
        Map<String, String> num2ShortNum = values.stream().collect(Collectors.toMap(x -> x.getString("number").toLowerCase(Locale.ENGLISH), y -> y.getString("shortnumber")));
        Map<String, String> lowNum2Num = values.stream().collect(Collectors.toMap(x -> x.getString("number").toLowerCase(Locale.ENGLISH), y -> y.getString("number")));
        int preIndex = isExt ? 3 : 5;
        for (String multiDimKey : multiDimKeys) {
            String multiStr = this.getPageCache().get(multiDimKey);
            String dimLowNum = multiDimKey.substring(preIndex);
            if (StringUtils.isNotEmpty((String)multiStr)) {
                List results = (List)SerializationUtils.fromJsonString((String)multiStr, List.class);
                ArrayList list = new ArrayList(10);
                if (StringUtils.isEmpty((String)((String)((Map)results.get(0)).get("pid")))) {
                    for (Map memMap : results) {
                        HashMap rangeMap = new HashMap(16);
                        rangeMap.put("number", memMap.get("number"));
                        rangeMap.put("range", memMap.get("scope"));
                        list.add(rangeMap);
                    }
                    dimMap.put(num2ShortNum.get(dimLowNum), list);
                    continue;
                }
                String dimNum = lowNum2Num.get(dimLowNum);
                for (Map memMap : results) {
                    HashMap rangeMap = new HashMap(16);
                    rangeMap.put("number", memMap.get("number"));
                    rangeMap.put("name", memMap.get("name"));
                    rangeMap.put("source", dimNum);
                    dproLists.add(rangeMap);
                }
                dimMap.put(num2ShortNum.get(dimLowNum), Lists.newArrayList());
                continue;
            }
            dimMap.put(num2ShortNum.get(dimLowNum), Lists.newArrayList());
        }
        if (isExt) {
            HashMap<String, String> proRangeMap = new HashMap<String, String>(16);
            proRangeMap.put("number", ((DynamicObject)this.getModel().getValue(PROCESS_F7)).getString("number"));
            proRangeMap.put("range", String.valueOf(RangeEnum.VALUE_10.getValue()));
            dimMap.put(SysDimensionEnum.Process.getShortnumber(), Collections.singletonList(proRangeMap));
            HashMap<String, String> audiRangeMap = new HashMap<String, String>(16);
            audiRangeMap.put("number", ((DynamicObject)this.getModel().getValue(AUDITTRAIL_F7)).getString("number"));
            audiRangeMap.put("range", String.valueOf(RangeEnum.VALUE_10.getValue()));
            dimMap.put(SysDimensionEnum.AuditTrail.getShortnumber(), Collections.singletonList(audiRangeMap));
        }
        map.put("dim", dimMap);
        map.put("pro", dproLists);
        return map;
    }

    private Map<String, List<Map<String, String>>> addSelfOfAllMembers(Map<String, Object> paramValues) {
        HashMap<String, List<Map<String, String>>> map = new HashMap<String, List<Map<String, String>>>(16);
        Collection values = MemberReader.getDimDyoByModelId((long)this.getModelId()).values();
        Map<String, String> num2ShortNum = values.stream().collect(Collectors.toMap(x -> x.getString("number"), y -> y.getString("shortnumber")));
        for (Map.Entry<String, Object> next : paramValues.entrySet()) {
            String key = next.getKey();
            Set value = (Set)next.getValue();
            ArrayList list = new ArrayList(10);
            for (String member : value) {
                HashMap<String, String> rangeMap = new HashMap<String, String>(16);
                rangeMap.put("number", member);
                rangeMap.put("range", "10");
                list.add(rangeMap);
            }
            String shortNum = num2ShortNum.get(key);
            map.put(shortNum, list);
        }
        return map;
    }

    private Map<String, Object> getDimParamValues(long modelId, List<String> dimNums, Map<String, DynamicObject> dimDyMaps, Map<String, DimensionScope> f7DimModels) {
        return dimNums.stream().collect(Collectors.toMap(dimNum -> dimNum, dimNum -> {
            Set numbers = ((DimensionScope)f7DimModels.get(SING_PREFIX + dimNum.toLowerCase(Locale.ENGLISH))).getResolveScopes();
            Set ids = ((DimensionScope)f7DimModels.get(SING_PREFIX + dimNum.toLowerCase(Locale.ENGLISH))).getResolveScopeIds();
            if (CollectionUtils.isNotEmpty((Collection)numbers)) {
                this.filterNoPermMembers(ids, numbers, dimDyMaps, (String)dimNum, modelId);
            }
            if ("Entity".equals(dimNum)) {
                QFilter qf = new QFilter(MODEL_DY, "=", (Object)modelId);
                qf.and(new QFilter("parent.number", "in", (Object)numbers).or("number", "in", (Object)numbers));
                qf.and("status", "!=", (Object)StatusEnum.TempSave.toString());
                QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"parent.number, number", (QFilter[])qf.toArray()).forEach(e -> numbers.add(e.getString("parent.number") + "_" + e.getString("number")));
            }
            return numbers;
        }));
    }

    private void showSchemeList(String itemKey) {
        Object modelDy = this.getModel().getValue(MODEL_DY);
        if (modelDy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExtendDataRptFormPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bcm_analyticsscheme_list");
        param.setCustomParam(MODEL_DY, (Object)((DynamicObject)modelDy).getLong("id"));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, itemKey));
        this.getView().showForm((FormShowParameter)param);
    }

    private void addScheme(String itemKey) {
        Object modelDy = this.getModel().getValue(MODEL_DY);
        if (modelDy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExtendDataRptFormPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter param = new FormShowParameter();
        if (SAVE_AS_SCHEME.equals(itemKey)) {
            Object querytype = this.getModel().getValue(COMBO_FIELD);
            Object extModel = this.getModel().getValue(EXT_MODEL);
            if (AnalyticsQueryTypeEnum.ExtData.getIndex().equals(querytype)) {
                if (extModel == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62d3\u5c55\u6a21\u578b\u3002", (String)"DataQueryAnalyticsPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                param.setCustomParam(EXT_MODEL, (Object)((DynamicObject)extModel).getLong("id"));
            }
            param.setCustomParam(COMBO_FIELD, querytype);
        }
        param.setFormId("bcm_analyticsscheme");
        param.setCustomParam(MODEL_DY, (Object)((DynamicObject)modelDy).getLong("id"));
        param.setCustomParam("sign", (Object)itemKey);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, itemKey));
        this.getView().showForm(param);
    }

    private void handlePageCache(String modelId) {
        this.getPageCache().remove("field_mapped" + modelId);
        this.getPageCache().remove(BCM_DIMENSION_DATA);
        this.clearDimValuesAndCache();
    }

    private void clearDimValuesAndCache() {
        String olapDims = this.getPageCache().get(f7MapCACHEKEY);
        if (StringUtils.isNotEmpty((String)olapDims)) {
            Map f7DimModels = (Map)this.deSerializedBytes(olapDims);
            this.getPageCache().remove(f7MapCACHEKEY);
            Set olapDimSets = f7DimModels.keySet();
            for (String mulDim : olapDimSets) {
                this.getModel().setValue(mulDim, null);
                this.getPageCache().remove(mulDim);
            }
        }
        for (String multiDimKey : MULTI_DIM_KEYS) {
            this.getPageCache().remove(multiDimKey);
            this.getModel().setValue(multiDimKey, null);
            this.getModel().setValue(PROCESS_F7, null);
            this.getModel().setValue(AUDITTRAIL_F7, null);
        }
    }

    private void handleSaveScheme(ClosedCallBackEvent evt, String actionId) {
        Map returnData = (Map)evt.getReturnData();
        if (returnData != null) {
            this.saveScheme(returnData, actionId);
        }
    }

    private void saveScheme(Map<String, Object> returnData, String actionId) {
        boolean isAddScheme = ADD_SCHEME.equals(actionId);
        String opName = isAddScheme ? ResManager.loadKDString((String)"\u65b0\u589e\u65b9\u6848\u6210\u529f\u3002", (String)"DataQueryAnalyticsPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53e6\u5b58\u65b9\u6848\u6210\u529f\u3002", (String)"DataQueryAnalyticsPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        try (TXHandle tx = TX.required((String)"bcm_analyticsscheme_base");){
            try {
                DynamicObject scheme = BusinessDataServiceHelper.newDynamicObject((String)"bcm_analyticsscheme_base");
                this.setDyValues(scheme, returnData);
                if (!isAddScheme) {
                    this.setDyListValues(scheme, (String)returnData.get(COMBO_FIELD));
                }
                Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
                Object schemeId = ((DynamicObject)result[0]).getPkValue();
                Object permclass = returnData.get("permclass");
                if (permclass != null) {
                    PermClassEntityHelper.savePermClass((String)"bcm_analyticsscheme_base", (Object)schemeId, (Object)this.getModelId(), (Object)permclass);
                }
                this.getPageCache().put(SCHEME_ID_KEY, String.valueOf(schemeId));
                this.getView().showSuccessNotification(opName);
                String ope = isAddScheme ? ResManager.loadKDString((String)"\u65b0\u589e\u65b9\u6848", (String)"DataQueryAnalyticsPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53e6\u5b58\u65b9\u6848", (String)"DataQueryAnalyticsPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                String opDes = isAddScheme ? ResManager.loadKDString((String)"\u65b0\u589e%s\u65b9\u6848\u6210\u529f", (String)"DataQueryAnalyticsPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[]{scheme.getString("number")}) : ResManager.loadKDString((String)"\u53e6\u5b58%s\u65b9\u6848\u6210\u529f", (String)"DataQueryAnalyticsPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[]{scheme.getString("number")});
                this.writeLog(ope, opDes);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        this.setCombsValueOfScheme((String)returnData.get("number"));
    }

    private void setCombsValueOfScheme(String number) {
        long modelId = this.getModelId();
        QFilter qf = new QFilter(MODEL_DY, "=", (Object)modelId);
        DynamicObjectCollection schemeList = QueryServiceHelper.query((String)"bcm_analyticsscheme_base", (String)"id, number, name", (QFilter[])qf.toArray(), (String)"dseq");
        Set havePermSchemeIds = DataQueryAnalyticsHelper.getHavePermSchemeIds((long)modelId, (long)RequestContext.get().getCurrUserId());
        List havePermSchemeList = schemeList.stream().filter(x -> havePermSchemeIds.contains(x.getLong("id"))).collect(Collectors.toList());
        ComboEdit comboEdit = (ComboEdit)this.getControl(FILTER_SCHEME);
        if (CollectionUtils.isNotEmpty(havePermSchemeList)) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(havePermSchemeList.size());
            for (DynamicObject dynamicObject : havePermSchemeList) {
                String name = dynamicObject.getString("name");
                String num = dynamicObject.getString("number");
                ComboItem comboItem = new ComboItem(new LocaleString(name), num);
                items.add(comboItem);
            }
            comboEdit.setComboItems(items);
            String schemeNum = StringUtils.isEmpty((String)number) ? ((ComboItem)items.get(0)).getValue() : number;
            this.getModel().setValue(FILTER_SCHEME, (Object)schemeNum);
            this.getView().updateView(FILTER_SCHEME);
            this.getView().setEnable(Boolean.TRUE, new String[]{SAVE_SCHEME});
            this.getPageCache().put("isHaveScheme", "true");
            return;
        }
        comboEdit.setComboItems(null);
        this.getModel().setValue(FILTER_SCHEME, null);
        this.getView().setEnable(Boolean.FALSE, new String[]{SAVE_SCHEME});
        this.getPageCache().put("isHaveScheme", "false");
    }

    private void setDyListValues(DynamicObject scheme, String queryType) {
        DynamicObjectCollection coll = scheme.getDynamicObjectCollection(ENTRY_ENTITY);
        coll.clear();
        Map dimNum2DimDys = MemberReader.getDimDyoByModelId((long)this.getModelId());
        DynamicObjectType dyType = coll.getDynamicObjectType();
        if (AnalyticsQueryTypeEnum.ExtData.getIndex().equals(queryType)) {
            Object auditF7;
            for (String multiDimKey : MULTI_DIM_KEYS) {
                String multiStr = this.getPageCache().get(multiDimKey);
                if (!StringUtils.isNotEmpty((String)multiStr)) continue;
                String dimNum = multiDimKey.replace(MUL_PRE, "");
                String dimKey = dimNum2DimDys.keySet().stream().filter(x -> x.equalsIgnoreCase(dimNum)).findFirst().get();
                long dimId = ((DynamicObject)dimNum2DimDys.get(dimKey)).getLong("id");
                List results = (List)SerializationUtils.fromJsonString((String)multiStr, List.class);
                for (Map map : results) {
                    String pid = map.get("pid") == null ? null : ((String)map.get("pid")).trim();
                    Long mid = Long.valueOf((String)map.get("id"));
                    int range = Integer.parseInt((String)map.get("scope"));
                    DynamicObject entry = new DynamicObject(dyType);
                    entry.set("comdimension", (Object)dimId);
                    entry.set("commembid", (Object)mid);
                    entry.set("range", (Object)range);
                    entry.set("pid", StringUtils.isEmpty((String)pid) ? Long.valueOf(0L) : pid);
                    coll.add((Object)entry);
                }
            }
            Object processF7 = this.getModel().getValue(PROCESS_F7);
            if (processF7 != null) {
                DynamicObject entryPro = new DynamicObject(dyType);
                entryPro.set("comdimension", (Object)((DynamicObject)dimNum2DimDys.get(DimTypesEnum.PROCESS.getNumber())).getLong("id"));
                entryPro.set("commembid", (Object)((DynamicObject)processF7).getLong("id"));
                entryPro.set("range", (Object)"10");
                entryPro.set("pid", (Object)0L);
                coll.add((Object)entryPro);
            }
            if ((auditF7 = this.getModel().getValue(AUDITTRAIL_F7)) != null) {
                DynamicObject entryAudi = new DynamicObject(dyType);
                entryAudi.set("comdimension", (Object)((DynamicObject)dimNum2DimDys.get(DimTypesEnum.AUDITTRIAL.getNumber())).getLong("id"));
                entryAudi.set("commembid", (Object)((DynamicObject)auditF7).getLong("id"));
                entryAudi.set("range", (Object)"10");
                entryAudi.set("pid", (Object)0L);
                coll.add((Object)entryAudi);
            }
        } else {
            String olapDims = this.getPageCache().get(f7MapCACHEKEY);
            if (StringUtils.isNotEmpty((String)olapDims)) {
                Map f7DimModels = (Map)this.deSerializedBytes(olapDims);
                Set multiDims = f7DimModels.keySet();
                for (String multiDim : multiDims) {
                    String dimMemStr = this.getPageCache().get(multiDim);
                    String dimNum = multiDim.substring(5);
                    String dimKey = dimNum2DimDys.keySet().stream().filter(x -> x.equalsIgnoreCase(dimNum)).findFirst().get();
                    long dimId = ((DynamicObject)dimNum2DimDys.get(dimKey)).getLong("id");
                    if (!StringUtils.isNotEmpty((String)dimMemStr)) continue;
                    List list = (List)SerializationUtils.fromJsonString((String)dimMemStr, List.class);
                    for (Map map : list) {
                        String pid = map.get("pid") == null ? null : ((String)map.get("pid")).trim();
                        Long mid = Long.valueOf((String)map.get("id"));
                        int range = Integer.parseInt((String)map.get("scope"));
                        DynamicObject entry = new DynamicObject(coll.getDynamicObjectType());
                        entry.set("comdimension", (Object)dimId);
                        entry.set("commembid", (Object)mid);
                        entry.set("range", (Object)range);
                        entry.set("pid", StringUtils.isEmpty((String)pid) ? Long.valueOf(0L) : pid);
                        coll.add((Object)entry);
                    }
                }
            }
        }
    }

    private void setDyValues(DynamicObject scheme, Map<String, Object> returnData) {
        scheme.set("name", returnData.get("name"));
        scheme.set("number", returnData.get("number"));
        scheme.set(COMBO_FIELD, returnData.get(COMBO_FIELD));
        scheme.set("description", returnData.get("description"));
        scheme.set(EXT_MODEL, returnData.get(EXT_MODEL) == null ? Integer.valueOf(0) : returnData.get(EXT_MODEL));
        scheme.set("permrange", returnData.get("permrange"));
        scheme.set("enable", (Object)"1");
        scheme.set(MODEL_DY, (Object)this.getModelId());
        String userId = RequestContext.get().getUserId();
        Date nowDate = TimeServiceHelper.now();
        scheme.set("creator", (Object)userId);
        scheme.set("createtime", (Object)nowDate);
        QFilter filter = new QFilter(MODEL_DY, "=", (Object)this.getModelId());
        DynamicObjectCollection dseqs = QueryServiceHelper.query((String)"bcm_analyticsscheme_base", (String)"dseq", (QFilter[])filter.toArray(), (String)"dseq desc");
        if (CollectionUtils.isEmpty((Collection)dseqs)) {
            scheme.set("dseq", (Object)0);
        } else {
            scheme.set("dseq", (Object)new AtomicInteger(((DynamicObject)dseqs.get(0)).getInt("dseq")).getAndIncrement());
        }
        scheme.set("modifier", (Object)userId);
        scheme.set("modifytime", (Object)nowDate);
        String extendDataEntity = "bcm_extenddata";
        if (AnalyticsQueryTypeEnum.ExtData.getIndex().equals(returnData.get(COMBO_FIELD))) {
            DynamicObject extDy = (DynamicObject)returnData.get(EXT_MODEL);
            long extendModelId = extDy.getLong("id");
            ExtendsModel extModel = this.getExtendsModel(extendModelId);
            if (ExtendDimGroupType.TRANSACTION.getIndex().equals(extModel.getExtendsGroupType())) {
                extendDataEntity = "bcm_extenddata_bus";
            }
        } else {
            scheme.set("excludeNullData", this.getModel().getValue("excludeNullData"));
            scheme.set("excludedynadata", this.getModel().getValue("excludedynadata"));
        }
        FilterCondition filterCondition = ((FilterGrid)this.getControl(FILTER_GRID_AP)).getFilterGridState().getFilterCondition();
        scheme.set("highfilter", (Object)(filterCondition.getFilterRow().size() == 0 ? " " : SerializationUtils.toJsonString((Object)filterCondition)));
    }

    private void overValueByScheme(String value) {
        if (StringUtils.isEmpty((String)value)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{SAVE_SCHEME});
            this.getPageCache().put(SCHEME_ID_KEY, "");
            return;
        }
        long modelId = this.getModelId();
        this.handlePageCache(String.valueOf(modelId));
        QFilter qf = new QFilter(MODEL_DY, "=", (Object)modelId);
        qf.and("number", "=", (Object)String.valueOf(value));
        long schemeId = QueryServiceHelper.queryOne((String)"bcm_analyticsscheme_base", (String)"id", (QFilter[])qf.toArray()).getLong("id");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_analyticsscheme_base");
        if (dynamicObject == null) {
            return;
        }
        this.updateFieldValueNoProperty(COMBO_FIELD, dynamicObject.getString(COMBO_FIELD));
        this.changeScheme(dynamicObject);
        this.getView().setEnable(Boolean.TRUE, new String[]{SAVE_SCHEME});
    }

    private void updateFieldValueNoProperty(String sign, Object value) {
        this.getModel().beginInit();
        this.getModel().setValue(sign, value);
        this.getView().updateView(sign);
        this.getModel().endInit();
    }

    private void changeScheme(DynamicObject dynamicObject) {
        String queryType = dynamicObject.getString(COMBO_FIELD);
        if (AnalyticsQueryTypeEnum.ExtData.getIndex().equals(queryType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{EXT_MODEL, EXT_FILTER_AP, REPORT_LIST_AP});
            this.getView().setVisible(Boolean.FALSE, new String[]{OLAP_PANEL_AP, RESULT_PANEL_AP});
            this.updateFieldValueNoProperty(EXT_MODEL, dynamicObject.get(EXT_MODEL));
            this.updateFilterGrid();
            this.setExtDimAndHighFilterValues(dynamicObject);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{EXT_MODEL, EXT_FILTER_AP, REPORT_LIST_AP});
            this.getView().setVisible(Boolean.TRUE, new String[]{OLAP_PANEL_AP, RESULT_PANEL_AP});
            this.updateFilterGrid();
            this.createMutiF7();
            this.setOlapDimAndHighFilterValues(dynamicObject);
        }
        this.getPageCache().put(SCHEME_ID_KEY, dynamicObject.getString("id"));
    }

    private void setOlapDimAndHighFilterValues(DynamicObject schemeDy) {
        Map f7data = EADataPushUtil.buildDefaultF7Data((DynamicObject)schemeDy, (long)this.getModelId());
        if (f7data.size() < 1) {
            return;
        }
        Map f7DimModels = (Map)this.deSerializedBytes(this.getPageCache().get(f7MapCACHEKEY));
        for (Map.Entry next : f7data.entrySet()) {
            String key = SING_PREFIX + (String)next.getKey();
            DimensionScope dimScope = (DimensionScope)f7DimModels.get(key);
            dimScope.clear();
            List list = (List)next.getValue();
            if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
            StringBuilder sb = new StringBuilder();
            for (Map map : list) {
                int scope = Integer.parseInt((String)map.get("scope"));
                this.buildPageViewShowName(sb, (String)map.get("name"), scope);
                long id = Long.parseLong((String)map.get("id"));
                dimScope.addDimeMemRange(id, scope);
                this.getModel().setValue(key, (Object)dimScope.toString());
            }
            this.getPageCache().put(key, SerializationUtils.toJsonString((Object)list));
            this.getView().updateView(key);
        }
        this.getPageCache().put(f7MapCACHEKEY, this.toByteSerialized(f7DimModels));
        this.overrideHightFilter(schemeDy.getString("highfilter"));
    }

    private void setExtDimAndHighFilterValues(DynamicObject schemeDy) {
        Map f7data = EADataPushUtil.buildDefaultF7Data((DynamicObject)schemeDy, (long)this.getModelId());
        if (f7data.size() < 1) {
            return;
        }
        for (Map.Entry next : f7data.entrySet()) {
            String key = (String)next.getKey();
            String action = MUL_PRE + (String)next.getKey();
            List list = (List)next.getValue();
            if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
            if (MULTI_DIM_KEYS.contains(action)) {
                StringBuilder sb = new StringBuilder();
                for (Map map : list) {
                    this.buildPageViewShowName(sb, (String)map.get("name"), Integer.parseInt((String)map.get("scope")));
                }
                if (StringUtils.isEmpty((String)sb.toString())) {
                    this.getModel().setValue(action, (Object)sb.toString());
                    this.getPageCache().remove(action);
                    continue;
                }
                this.getModel().setValue(action, (Object)sb.substring(0, sb.length() - 1));
                this.getPageCache().put(action, SerializationUtils.toJsonString((Object)list));
                continue;
            }
            this.getModel().setValue(key, ((Map)list.get(0)).get("id"));
        }
        this.overrideHightFilter(schemeDy.getString("highfilter"));
    }

    private void overrideHightFilter(String highfilter) {
        if (StringUtils.isEmpty((String)highfilter)) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRID_AP);
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)highfilter, FilterCondition.class);
        filterGrid.SetValue(condition);
        this.getView().updateView(FILTER_GRID_AP);
    }

    private void saveExistScheme() {
        Object value = this.getModel().getValue(FILTER_SCHEME);
        if (value == null) {
            return;
        }
        Object modelDy = this.getModel().getValue(MODEL_DY);
        if (modelDy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ExtendDataRptFormPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String schemeId = this.getPageCache().get(SCHEME_ID_KEY);
        if (StringUtils.isEmpty((String)schemeId) || "0".equals(schemeId)) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(schemeId), (String)"bcm_analyticsscheme_base");
        if (dynamicObject == null) {
            return;
        }
        if (!DataQueryAnalyticsHelper.isHavePermOfSchemeOfWrite((long)Long.parseLong(schemeId), (long)this.getModelId(), (long)RequestContext.get().getCurrUserId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u8be5\u65b9\u6848\u7684\u7f16\u8f91\u6743\u9650\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"DataAnalyticsSchemePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String combField = (String)this.getModel().getValue(COMBO_FIELD);
        dynamicObject.set(COMBO_FIELD, (Object)combField);
        boolean isExtData = AnalyticsQueryTypeEnum.ExtData.getIndex().equals(combField);
        dynamicObject.set(EXT_MODEL, isExtData ? this.getModel().getValue(EXT_MODEL) : Long.valueOf(0L));
        FilterCondition filterCondition = ((FilterGrid)this.getControl(FILTER_GRID_AP)).getFilterGridState().getFilterCondition();
        dynamicObject.set("highfilter", (Object)(filterCondition.getFilterRow().size() == 0 ? " " : SerializationUtils.toJsonString((Object)filterCondition)));
        this.setDyListValues(dynamicObject, (String)this.getModel().getValue(COMBO_FIELD));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataAnalyticsSchemeListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        String opName = ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848", (String)"DataQueryAnalyticsPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String opDes = ResManager.loadKDString((String)"\u4fdd\u5b58%s\u65b9\u6848\u6210\u529f", (String)"DataQueryAnalyticsPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[]{dynamicObject.getString("number")});
        this.writeLog(opName, opDes);
    }

    private void schemeListCloseBackEvt(ClosedCallBackEvent evt) {
        this.refreshFilterScheme();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        String type = (String)((Map)returnData).get("type");
        if ("btnok".equals(type)) {
            Object schemeId = ((Map)returnData).get("schemeId");
            if (schemeId == null) {
                return;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(schemeId, (String)"bcm_analyticsscheme_base");
            if (dynamicObject == null) {
                return;
            }
            this.updateFieldValueNoProperty(FILTER_SCHEME, dynamicObject.getString("number"));
            this.updateFieldValueNoProperty(COMBO_FIELD, dynamicObject.getString(COMBO_FIELD));
            this.changeScheme(dynamicObject);
        }
    }

    private void refreshFilterScheme() {
        String schemeId = this.getPageCache().get(SCHEME_ID_KEY);
        if (StringUtils.isEmpty((String)schemeId) || "0".equals(schemeId)) {
            return;
        }
        QFilter qf = new QFilter("id", "=", (Object)Long.parseLong(schemeId));
        DynamicObject schemeDy = QueryServiceHelper.queryOne((String)"bcm_analyticsscheme_base", (String)"number", (QFilter[])qf.toArray());
        if (Boolean.TRUE.toString().equals(this.getPageCache().get("isHaveScheme"))) {
            String schemNum = schemeDy == null ? null : schemeDy.getString("number");
            this.setCombsValueOfScheme(schemNum);
        }
    }

    private void buildPageViewShowName(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.VALUE_10) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"EADataPushBillPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(",");
        }
    }

    private Map<String, Object> getDims() {
        HashMap<String, Object> mapData = new HashMap<String, Object>(16);
        ArrayList dims = new ArrayList(10);
        ArrayList dimsUpperCase = new ArrayList(10);
        ArrayList dimsIdList = new ArrayList(10);
        ArrayList dimsMemberModelList = new ArrayList(10);
        ArrayList dimNum2Names = new ArrayList(10);
        List<DynamicObject> dyObjectList = this.getAllDimensions();
        dyObjectList.forEach(dyObj -> {
            dimsIdList.add(dyObj.getString("id"));
            dims.add(dyObj.getString("number").toLowerCase(Locale.ENGLISH));
            dimsUpperCase.add(dyObj.getString("number"));
            dimsMemberModelList.add(dyObj.getString("membermodel"));
            dimNum2Names.add(Pair.onePair((Object)dyObj.getString("number"), (Object)dyObj.getString("name")));
        });
        mapData.put("dims", dims);
        mapData.put("dimsUpperCase", dimsUpperCase);
        mapData.put("dimsIdList", dimsIdList);
        mapData.put("dimsMemberModelList", dimsMemberModelList);
        mapData.put("dimNum2Names", dimNum2Names);
        return mapData;
    }

    private List<DynamicObject> getAllDimensions() {
        String dimStr = this.getPageCache().get(BCM_DIMENSION_DATA);
        if (StringUtils.isEmpty((String)dimStr)) {
            QFilter qFilter = new QFilter(MODEL_DY, "=", (Object)this.getModelId());
            DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,name,number,shortnumber,issysdimension,membermodel,dseq", (QFilter[])qFilter.toArray(), (String)"dseq");
            this.getPageCache().put(BCM_DIMENSION_DATA, ObjectSerialUtil.toByteSerialized((Object)dims));
            return dims;
        }
        return (List)ObjectSerialUtil.deSerializedBytes((String)dimStr);
    }

    private void updateFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRID_AP);
        filterGrid.getFilterGridState().getFilterCondition().getFilterRow().clear();
        filterGrid.SetValue(new FilterCondition());
        this.setHighFilter();
        this.getView().updateView(FILTER_GRID_AP);
        this.mappedToCol.clear();
        this.setFilterGridName();
    }

    public void checkPerm(String opkey) {
        String[] perm = this.getPerm(opkey, this.getView().getEntityId());
        if (perm == null) {
            return;
        }
        String bizAppId = this.getView().getFormShowParameter().getAppId();
        if (ApplicationTypeEnum.BGMD.appnum.equalsIgnoreCase(bizAppId)) {
            bizAppId = ApplicationTypeEnum.EB.appnum;
        }
        this.doCheckPermission(perm[0], perm[1], this.getModelId(), bizAppId);
        this.doCheckUnionPerm(perm);
    }

    protected String[] getPerm(String opkey, String entityId) {
        Map permitem = BcmPermSingleModel.getInstance().getPermitem();
        Map map = (Map)permitem.get(entityId);
        if (map == null || map.get(opkey) == null) {
            return null;
        }
        String[] perm = ((String)map.get(opkey)).split("@");
        if (perm.length < 2) {
            return null;
        }
        return perm;
    }
}

