/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.isc.util.misc.NetUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.OpenApiSdkUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.MD5;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.entity.FpyUploadItem;

public class FpyOperateUtil {
    private static final Log logger = LogFactory.getLog(FpyOperateUtil.class);
    private static final String ERRCODE = "errcode";
    private static final String DESCRIPTION = "description";
    private static final Class clazz = FpyOperateUtil.class;

    public static String upload(String uploadUrl, FpyUploadItem fpyUploadItem) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("archivesCode", (Object)fpyUploadItem.getArchivesCode());
        jsonObject.put("accountBookNo", (Object)fpyUploadItem.getAccountBookNo());
        jsonObject.put("accountBookName", (Object)fpyUploadItem.getAccountBookName());
        jsonObject.put("period", (Object)fpyUploadItem.getPeriod());
        jsonObject.put("batchNumber", (Object)fpyUploadItem.getBatchNumber());
        jsonObject.put("businessType", (Object)fpyUploadItem.getBusinessType());
        jsonObject.put("fileName", (Object)fpyUploadItem.getFileName());
        jsonObject.put("institutionIssuesNo", (Object)fpyUploadItem.getInstitutionIssuesNo());
        jsonObject.put("institutionIssuesName", (Object)fpyUploadItem.getInstitutionIssuesName());
        logger.info("\u4e0a\u4f20\u6587\u4ef6\u5165\u53c2\uff1a{}", (Object)jsonObject.toJSONString());
        long fileLength = 0L;
        if (null != fpyUploadItem.getFileBytes()) {
            fileLength = fpyUploadItem.getFileBytes().length;
        } else if (null != fpyUploadItem.getFilebase64()) {
            fileLength = FpyOperateUtil.imageSize(fpyUploadItem.getFilebase64());
        }
        boolean isFpyEafc = uploadUrl.contains("eafc_collect");
        boolean isOnlyDeployed = uploadUrl.contains("?");
        if (isFpyEafc && !isOnlyDeployed) {
            if (StringUtils.isNotEmpty((CharSequence)fpyUploadItem.getFilePath())) {
                jsonObject.put("filePath", (Object)fpyUploadItem.getFilePath());
            } else {
                jsonObject.put("filebase64", (Object)fpyUploadItem.getFilebase64());
            }
            OpenApiResult apiResult = OpenApiSdkUtil.invoke((String)uploadUrl, new HashMap(jsonObject));
            logger.info(String.format(ResManager.loadKDString((String)"fileName\uff1a%1$s\uff0cfileSize:%2$s\uff0caccountBookName\uff1a%3$s\u672c\u6b21\u5f52\u6863HTTP POST \u8fd4\u56de\u503c:--%4$s", (String)"FpyOperateUtil_1", (String)"fi-aef-common", (Object[])new Object[0]), fpyUploadItem.getFileName(), fileLength, fpyUploadItem.getAccountBookName(), JSONObject.toJSONString((Object)apiResult)));
            if (apiResult.isStatus()) {
                apiResult.setErrorCode("0000");
            }
            HashMap<String, String> paramMap = new HashMap<String, String>(2);
            paramMap.put(ERRCODE, apiResult.getErrorCode());
            paramMap.put(DESCRIPTION, apiResult.getMessage());
            return JSONObject.toJSONString(paramMap);
        }
        if (SysParamConfig.getBoolean("archivetoxinghan", false)) {
            jsonObject.put("filebase64", (Object)fpyUploadItem.getFilebase64());
            Map paramMap = (Map)DispatchServiceHelper.invokeBizService((String)"eafc", (String)"eafc_collect", (String)"FileHandleService", (String)"upload", (Object[])new Object[]{jsonObject});
            logger.info(String.format(ResManager.loadKDString((String)"fileName\uff1a%1$s\uff0cfileSize:%2$s\uff0caccountBookName\uff1a%3$s\u672c\u6b21\u5f52\u6863HTTP POST \u8fd4\u56de\u503c:--%4$s", (String)"FpyOperateUtil_1", (String)"fi-aef-common", (Object[])new Object[0]), fpyUploadItem.getFileName(), fileLength, fpyUploadItem.getAccountBookName(), JSONObject.toJSONString((Object)paramMap)));
            return JSONObject.toJSONString((Object)paramMap);
        }
        if (fileLength <= 0xA00000L || isFpyEafc) {
            if (isFpyEafc && StringUtils.isNotEmpty((CharSequence)fpyUploadItem.getFilePath())) {
                jsonObject.put("filePath", (Object)fpyUploadItem.getFilePath());
            } else {
                jsonObject.put("filebase64", (Object)fpyUploadItem.getFilebase64());
            }
            Object object = FpyOperateUtil.sendHttpByApic("fi-aef-uploadFile", "POST", uploadUrl, new HashMap<String, Object>((Map<String, Object>)jsonObject));
            String responseContent = object.toString();
            responseContent = responseContent.replaceAll("\"errorCode\":\"0\"", "\"errorCode\":\"0000\"");
            responseContent = responseContent.replaceAll("\"errorCode\"", "\"errcode\"");
            responseContent = responseContent.replaceAll("\"message\"", "\"description\"");
            if (StringUtils.isNotEmpty((CharSequence)responseContent)) {
                logger.info(String.format(ResManager.loadKDString((String)"fileName\uff1a%1$s\uff0cfileSize:%2$s\uff0caccountBookName\uff1a%3$s\u672c\u6b21\u5f52\u6863HTTP POST \u8fd4\u56de\u503c:--%4$s", (String)"FpyOperateUtil_1", (String)"fi-aef-common", (Object[])new Object[0]), fpyUploadItem.getFileName(), fileLength, fpyUploadItem.getAccountBookName(), object.toString()));
                return responseContent;
            }
            return "";
        }
        if (fileLength > 0xA00000L) {
            String toUploadchunkUrl = uploadUrl.replace("/auth/file/upload", "/auth/toUploadchunk");
            String mergeFileUrl = uploadUrl.replace("/auth/file/upload", "/auth/mergeFile");
            String getuploadIdUrl = uploadUrl.replace("/auth/file/upload", "/auth/start/getuploadId");
            jsonObject.put("fileMd5", (Object)fpyUploadItem.getFileMD5());
            JSONObject result1 = FpyOperateUtil.getuploadId(getuploadIdUrl, jsonObject);
            if (null != result1) {
                LogUtil.printLog((Log)logger, (String)"begin toUploadchunk...");
                byte[] fileBytes = fpyUploadItem.getFileBytes();
                logger.info(String.format(ResManager.loadKDString((String)"fileName\uff1a%1$s\uff0cfileSize:%2$s\uff0caccountBookName\uff1a%3$s\u5927\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u53c2\u6570:--%4$s", (String)"FpyOperateUtil_2", (String)"fi-aef-common", (Object[])new Object[0]), fpyUploadItem.getFileName(), fileLength, fpyUploadItem.getAccountBookName(), fileBytes.length));
                if (FpyOperateUtil.toUploadChunk(result1, fileBytes, fpyUploadItem.getFileMD5(), toUploadchunkUrl, fpyUploadItem.getFileName())) {
                    LogUtil.printLog((Log)logger, (String)"begin mergeFile...");
                    return FpyOperateUtil.toMergeFile(mergeFileUrl, fpyUploadItem.getFileMD5(), result1);
                }
            }
        }
        return "";
    }

    public static String noticeArchive(String uploadNoticeUrl, FpyUploadItem fpyUploadItem) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("archivesCode", (Object)fpyUploadItem.getArchivesCode());
        jsonObject.put("accountBookNo", (Object)fpyUploadItem.getAccountBookNo());
        jsonObject.put("accountBookName", (Object)fpyUploadItem.getAccountBookName());
        jsonObject.put("institutionIssuesNo", (Object)fpyUploadItem.getInstitutionIssuesNo());
        jsonObject.put("institutionIssuesName", (Object)fpyUploadItem.getInstitutionIssuesName());
        jsonObject.put("period", (Object)fpyUploadItem.getPeriod());
        jsonObject.put("batchNumber", (Object)fpyUploadItem.getBatchNumber());
        jsonObject.put("businessType", (Object)fpyUploadItem.getBusinessType());
        jsonObject.put("archivist", (Object)fpyUploadItem.getArchivist());
        jsonObject.put("dataSource", (Object)fpyUploadItem.getDataSource());
        String code = "";
        String description = "";
        logger.info("\u901a\u77e5\u5f52\u6863\u5165\u53c2\uff1a{}", (Object)jsonObject.toJSONString());
        boolean isFpyEafc = uploadNoticeUrl.contains("eafc_collect");
        boolean isOnlyDeployed = uploadNoticeUrl.contains("?");
        if (isFpyEafc && !isOnlyDeployed) {
            jsonObject.put("filebase64", (Object)fpyUploadItem.getFilebase64());
            OpenApiResult apiResult = OpenApiSdkUtil.invoke((String)uploadNoticeUrl, new HashMap(jsonObject));
            logger.info("notice result {}", (Object)apiResult);
            if (apiResult.isStatus()) {
                apiResult.setErrorCode("0000");
            }
            code = apiResult.getErrorCode();
            description = apiResult.getMessage();
            return code;
        }
        if (SysParamConfig.getBoolean("archivetoxinghan", false)) {
            Map paramMap = (Map)DispatchServiceHelper.invokeBizService((String)"eafc", (String)"eafc_collect", (String)"FileHandleService", (String)"startAnalysis", (Object[])new Object[]{jsonObject});
            logger.info("notice result {}", (Object)paramMap);
            code = paramMap.get(ERRCODE) + "";
            description = paramMap.get(DESCRIPTION) + "";
            return code;
        }
        Object object = FpyOperateUtil.sendHttpByApic("fi-aef-notice", "POST", uploadNoticeUrl, new HashMap<String, Object>((Map<String, Object>)jsonObject));
        String responseContent = object.toString();
        responseContent = responseContent.replaceAll("\"errorCode\":\"0\"", "\"errorCode\":\"0000\"");
        responseContent = responseContent.replaceAll("\"errorCode\"", "\"errcode\"");
        responseContent = responseContent.replaceAll("\"message\"", "\"description\"");
        Map map = (Map)SerializationUtils.fromJsonString((String)responseContent, Map.class);
        code = map.get(ERRCODE) + "";
        description = map.get(DESCRIPTION) + "";
        if (!"0000".equals(code)) {
            logger.error(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u901a\u77e5\u5f52\u6863\u7684\u63a5\u53e3\u8fd4\u56de\u7684\u9519\u8bef\u4fe1\u606f\u662f:%s", (String)"FpyOperateUtil_5", (String)"fi-aef-common", (Object[])new Object[0]), map));
        }
        return code;
    }

    public static String reverse(String uploadDeleteUrl, FpyUploadItem fpyUploadItem) {
        HashMap<String, Object> map = new HashMap<String, Object>(7);
        map.put("accountBookNo", fpyUploadItem.getAccountBookNo());
        map.put("accountBookName", fpyUploadItem.getAccountBookName());
        map.put("period", fpyUploadItem.getPeriod());
        map.put("billids", fpyUploadItem.getBillidsMap().keySet().stream().map(key -> key.split("\\.")[1]).collect(Collectors.joining(",")));
        map.put("businessType", fpyUploadItem.getBusinessType());
        map.put("archivist", fpyUploadItem.getArchivist());
        map.put("dataSource", fpyUploadItem.getDataSource());
        map.put("institutionIssuesNo", fpyUploadItem.getInstitutionIssuesNo());
        map.put("institutionIssuesName", fpyUploadItem.getInstitutionIssuesName());
        logger.info("\u4e0a\u4f20\u6587\u4ef6\u5165\u53c2\uff1a{}", (Object)new JSONObject(map).toJSONString());
        String code = "";
        boolean isFpyEafc = uploadDeleteUrl.contains("eafc_collect");
        boolean isOnlyDeployed = uploadDeleteUrl.contains("?");
        if (isFpyEafc && !isOnlyDeployed) {
            map.put("filebase64", fpyUploadItem.getFilebase64());
            OpenApiResult apiResult = OpenApiSdkUtil.invoke((String)uploadDeleteUrl, map);
            logger.info("reverse : {}, paramMap : {}", map, (Object)apiResult);
            if (apiResult.isStatus()) {
                apiResult.setErrorCode("0000");
            }
            if (!"0000".equals(code = apiResult.getErrorCode())) {
                logger.error(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u53cd\u5f52\u6863\u7684\u63a5\u53e3\u8fd4\u56de\u7684\u9519\u8bef\u4fe1\u606f\u662f:%s", (String)"FpyOperateUtil_7", (String)"fi-aef-common", (Object[])new Object[0]), apiResult));
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
            paramMap.put(ERRCODE, apiResult.getErrorCode());
            paramMap.put(DESCRIPTION, apiResult.getMessage());
            paramMap.put("data", apiResult.getData());
            return JSONObject.toJSONString(paramMap);
        }
        if (SysParamConfig.getBoolean("archivetoxinghan", false)) {
            Map paramMap = (Map)DispatchServiceHelper.invokeBizService((String)"eafc", (String)"eafc_collect", (String)"FileHandleService", (String)"isRepeatArchive", (Object[])new Object[]{map});
            logger.info("reverse : {}, paramMap : {}", map, (Object)paramMap);
            code = paramMap.get(ERRCODE) + "";
            if (!"0000".equals(code)) {
                logger.error(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u53cd\u5f52\u6863\u7684\u63a5\u53e3\u8fd4\u56de\u7684\u9519\u8bef\u4fe1\u606f\u662f:%s", (String)"FpyOperateUtil_7", (String)"fi-aef-common", (Object[])new Object[0]), paramMap));
            }
            return JSONObject.toJSONString((Object)paramMap);
        }
        Object object = FpyOperateUtil.sendHttpByApic("fi-aef-delete", "POST", uploadDeleteUrl, new HashMap<String, Object>(map));
        String responseContent = object.toString();
        responseContent = responseContent.replaceAll("\"errorCode\":\"0\"", "\"errorCode\":\"0000\"");
        responseContent = responseContent.replaceAll("\"errorCode\"", "\"errcode\"");
        Map paramMap = (Map)SerializationUtils.fromJsonString((String)(responseContent = responseContent.replaceAll("\"message\"", "\"description\"")), Map.class);
        code = paramMap.get(ERRCODE) + "";
        if (!"0000".equals(code)) {
            logger.error(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u901a\u77e5\u5f52\u6863\u7684\u63a5\u53e3\u8fd4\u56de\u7684\u9519\u8bef\u4fe1\u606f\u662f:%s", (String)"FpyOperateUtil_5", (String)"fi-aef-common", (Object[])new Object[0]), paramMap));
        }
        return responseContent;
    }

    public static String getAppToken(DynamicObject imageConfig) {
        String uploadway = imageConfig.getString("uploadway");
        if ("5".equals(uploadway) || "6".equals(uploadway)) {
            return FpyOperateUtil.getEafcAppToken(imageConfig);
        }
        String serviceip = imageConfig.getString("serviceip");
        String serviceport = imageConfig.getString("serviceport");
        String requestway = imageConfig.getString("requestway");
        String requestUrl = "";
        requestUrl = "2".equals(requestway) ? "https://" + serviceip + ":" + serviceport + "/archive/oauth/token" : "http://" + serviceip + ":" + serviceport + "/archive/oauth/token";
        String archivesCode = imageConfig.getString("username");
        String authCode = imageConfig.getString("password");
        Long timestamp = System.currentTimeMillis();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("archivesCode", (Object)archivesCode);
        jsonObject.put("sign", (Object)MD5.md5crypt((String)(archivesCode + authCode + timestamp)));
        jsonObject.put("timestamp", (Object)timestamp);
        if (SysParamConfig.getBoolean("archivetoxinghan", false)) {
            return "token";
        }
        String token = "1";
        Object object = FpyOperateUtil.sendHttpByApic("fi-aef-getAccessToken", "POST", requestUrl, new HashMap<String, Object>((Map<String, Object>)jsonObject));
        Map map = (Map)SerializationUtils.fromJsonString((String)object.toString(), Map.class);
        if (map != null) {
            token = (String)map.get("accessToken");
        }
        return token;
    }

    private static String getEafcAppToken(DynamicObject imageConfig) {
        Object data;
        Object data2;
        String serviceip = imageConfig.getString("serviceip");
        String serviceport = imageConfig.getString("serviceport");
        String uploadway = imageConfig.getString("uploadway");
        String requestway = imageConfig.getString("requestway");
        String appTokenURL = "";
        String accessTokenURL = "";
        if ("2".equals(requestway)) {
            appTokenURL = "https://" + serviceip + (StringUtils.isEmpty((CharSequence)serviceport) ? "" : ":" + serviceport) + "/api/getAppToken.do";
            accessTokenURL = "https://" + serviceip + (StringUtils.isEmpty((CharSequence)serviceport) ? "" : ":" + serviceport) + "/api/login.do";
        } else {
            appTokenURL = "http://" + serviceip + (StringUtils.isEmpty((CharSequence)serviceport) ? "" : ":" + serviceport) + "/api/getAppToken.do";
            accessTokenURL = "http://" + serviceip + (StringUtils.isEmpty((CharSequence)serviceport) ? "" : ":" + serviceport) + "/api/login.do";
        }
        String archivesCode = imageConfig.getString("username");
        String authCode = imageConfig.getString("password");
        if ("5".equals(uploadway)) {
            return "token";
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appId", (Object)archivesCode);
        jsonObject.put("appSecret", (Object)authCode);
        String appToken = "1";
        Object object = FpyOperateUtil.sendHttpByApic("fi-aef-getAccessToken", "POST", appTokenURL, new HashMap<String, Object>((Map<String, Object>)jsonObject));
        String responseContent = object.toString();
        Map map = (Map)SerializationUtils.fromJsonString((String)responseContent, Map.class);
        if (map != null && map.get("data") != null && (data2 = map.get("data")) instanceof Map) {
            appToken = ((Map)data2).get("app_token").toString();
        }
        jsonObject.clear();
        jsonObject.put("user", (Object)UserServiceHelper.getCurrentUser((String)"username").getString("username"));
        jsonObject.put("usertype", (Object)"UserName");
        jsonObject.put("apptoken", (Object)appToken);
        jsonObject.put("language", (Object)RequestContext.get().getLang().getLocale().getLanguage());
        String accessToken = "2";
        object = FpyOperateUtil.sendHttpByApic("fi-aef-getAccessToken", "POST", accessTokenURL, new HashMap<String, Object>((Map<String, Object>)jsonObject));
        responseContent = object.toString();
        map = (Map)SerializationUtils.fromJsonString((String)responseContent, Map.class);
        if (map != null && map.get("data") != null && (data = map.get("data")) instanceof Map) {
            accessToken = ((Map)data).get("access_token").toString();
        }
        return accessToken;
    }

    public static ThreeTuple<String, String, String> getURL(DynamicObject imageConfig, String token) {
        String uploadUrl = "";
        String noticeUrl = "";
        String deleteUrl = "";
        if (imageConfig == null) {
            return new ThreeTuple((Object)uploadUrl, (Object)noticeUrl, (Object)deleteUrl);
        }
        String uploadway = imageConfig.getString("uploadway");
        String requestway = imageConfig.getString("requestway");
        String serviceip = imageConfig.getString("serviceip");
        String serviceport = imageConfig.getString("serviceport");
        if ("3".equals(uploadway)) {
            if ("2".equals(requestway)) {
                uploadUrl = "https://" + serviceip + ":" + serviceport + "/archive/auth/file/upload?access_token=" + token;
                noticeUrl = "https://" + serviceip + ":" + serviceport + "/archive/auth/save/start?access_token=" + token;
            } else if ("1".equals(requestway)) {
                uploadUrl = "http://" + serviceip + ":" + serviceport + "/archive/auth/file/upload?access_token=" + token;
                noticeUrl = "http://" + serviceip + ":" + serviceport + "/archive/auth/save/start?access_token=" + token;
            }
        } else if ("6".equals(uploadway)) {
            if ("2".equals(requestway)) {
                uploadUrl = "https://" + serviceip + (StringUtils.isEmpty((CharSequence)serviceport) ? "" : ":" + serviceport) + "/kapi/v2/eafc/eafc_collect/archive/upload?access_token=" + token;
                noticeUrl = "https://" + serviceip + (StringUtils.isEmpty((CharSequence)serviceport) ? "" : ":" + serviceport) + "/kapi/v2/eafc/eafc_collect/archive/start?access_token=" + token;
                deleteUrl = "https://" + serviceip + (StringUtils.isEmpty((CharSequence)serviceport) ? "" : ":" + serviceport) + "/kapi/v2/eafc/eafc_collect/archive/delete?access_token=" + token;
            } else if ("1".equals(requestway)) {
                uploadUrl = "http://" + serviceip + (StringUtils.isEmpty((CharSequence)serviceport) ? "" : ":" + serviceport) + "/kapi/v2/eafc/eafc_collect/archive/upload?access_token=" + token;
                noticeUrl = "http://" + serviceip + (StringUtils.isEmpty((CharSequence)serviceport) ? "" : ":" + serviceport) + "/kapi/v2/eafc/eafc_collect/archive/start?access_token=" + token;
                deleteUrl = "http://" + serviceip + (StringUtils.isEmpty((CharSequence)serviceport) ? "" : ":" + serviceport) + "/kapi/v2/eafc/eafc_collect/archive/delete?access_token=" + token;
            }
        } else if ("5".equals(uploadway)) {
            uploadUrl = "/v2/eafc/eafc_collect/archive/upload";
            noticeUrl = "/v2/eafc/eafc_collect/archive/start";
            deleteUrl = "/v2/eafc/eafc_collect/archive/delete";
        }
        return new ThreeTuple((Object)uploadUrl, (Object)noticeUrl, (Object)deleteUrl);
    }

    @Deprecated
    public static final String sendHttpsRequestByPost(String url, String json) throws Exception {
        return "";
    }

    public static JSONObject getuploadId(String url, JSONObject jsonObject) {
        JSONObject result = null;
        try {
            String responseContent = FpyOperateUtil.sendHttpByApic("fi-aef-uploadFile", "POST", url, new HashMap<String, Object>((Map<String, Object>)jsonObject)).toString();
            if (StringUtils.isNotEmpty((CharSequence)responseContent)) {
                JSONObject resultJosn = JSON.parseObject((String)responseContent);
                if ("0000".equals(resultJosn.getString(ERRCODE))) {
                    result = resultJosn.getJSONObject("data");
                } else {
                    logger.error("\u83b7\u53d6\u4e0a\u4f20id\u8bf7\u6c42\u5931\u8d25:{}", (Object)responseContent);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e0a\u4f20id\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean toUploadChunk(JSONObject jsonObject, byte[] fileBytes, String fileMD5, String toUploadchunkUrl, String fileName) {
        FileInputStream is = null;
        Integer chunkSize = 10;
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            Integer chunkSizeByte = chunkSize * 1024 * 1024;
            int length = fileBytes.length;
            double aa = (double)length / (double)chunkSizeByte.intValue();
            int chunkTotal = (int)Math.ceil(aa);
            params.put("total", chunkTotal);
            params.put("uploadId", jsonObject.getString("uploadId"));
            params.put("chunkSize", chunkSizeByte);
            params.put("fileMd5", fileMD5);
            byte[] byt = new byte[chunkSizeByte.intValue()];
            for (int i = 0; i < chunkTotal; ++i) {
                int from = i * chunkSizeByte;
                int to = from + chunkSizeByte;
                if (to > length) {
                    to = length;
                    params.put("chunkSize", to - from);
                    byt = new byte[to - from];
                    byt = Arrays.copyOfRange(fileBytes, from, to);
                } else {
                    byt = Arrays.copyOfRange(fileBytes, from, to);
                }
                params.put("current", i + 1);
                params.put("bytes", byt);
                ByteBuffer wrap = ByteBuffer.wrap(byt);
                params.put("chunkMd5", MD5.getMD5((ByteBuffer)wrap));
                String responseContent = FpyOperateUtil.sendHttpByApic("fi-aef-uploadFile", "POST", toUploadchunkUrl, params).toString();
                logger.info("\u6587\u4ef6{}\u5206\u5757\u603b\u6570\u662f{}\uff0c\u7b2c{}\u5206\u5757\u4e0a\u4f20\u6210\u529f", new Object[]{fileName, chunkTotal, i + 1});
                JSONObject jsonResult = JSON.parseObject((String)responseContent);
                if ("0000".equals(jsonResult.getString(ERRCODE))) continue;
                logger.error("\u5206\u6bb5\u4e0a\u4f20\u51fa\u9519{}", (Object)responseContent);
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u5206\u7247\u6587\u4ef6\u5f02\u5e38\uff0c\u5206\u5757\u53c2\u6570\uff1a{}", params, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error("\u6d41\u5173\u95ed\u5f02\u5e38");
                }
            }
        }
        return true;
    }

    public static long imageSize(String image) {
        String str = image.substring(22);
        Integer equalIndex = str.indexOf("=");
        if (str.indexOf("=") > 0) {
            str = str.substring(0, equalIndex);
        }
        long strLength = str.length();
        long size = strLength - strLength / 8L * 2L;
        return size;
    }

    public static String fileMD5(byte[] bytes) {
        String MD5str = "";
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        MD5str = MD5.getMD5((ByteBuffer)buf);
        return MD5str;
    }

    public static String toMergeFile(String mergeUrl, String fileMd5, JSONObject result1) {
        String responseContent = "";
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("fileMd5", (Object)fileMd5);
            jsonObject.put("uploadId", (Object)result1.getString("uploadId"));
            String params = jsonObject.toJSONString();
            responseContent = FpyOperateUtil.sendHttpByApic("fi-aef-uploadFile", "POST", mergeUrl, new HashMap<String, Object>((Map<String, Object>)jsonObject)).toString();
            JSONObject resultJosn = JSON.parseObject((String)responseContent);
            if ("0000".equals(resultJosn.getString(ERRCODE))) {
                LogUtil.printLog((Log)logger, (String)"toMergeFile success");
            } else {
                logger.error("\u5408\u5e76\u6587\u4ef6\u5931\u8d25:{}", (Object)responseContent);
            }
        }
        catch (Exception e) {
            logger.error("\u5408\u5e76\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        return responseContent;
    }

    public static Object sendHttpByApic(String number, String method, String url, Map<String, Object> dataMap) {
        return FpyOperateUtil.sendHttpByApic(number, method, url, JSON.toJSONString(dataMap));
    }

    public static Object sendHttpByApic(String number, String method, String url, String data) {
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_apic_script", (QFilter[])new QFilter("number", "=", (Object)number).toArray());
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew((String)"FpyOperateUtil.sendHttpByApic");){
            if (object == null) {
                try (InputStream in = clazz.getClassLoader().getResource(String.format("resources/%s.dts", number)).openStream();){
                    String jsonStr = NetUtil.readText((InputStream)in);
                    Object result = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscResourceService", (String)"importResourceWithPattern", (Object[])new Object[]{jsonStr, true});
                    if (result == null) {
                        logger.info(number + "\u7684\u81ea\u5b9a\u4e49API\u5bfc\u5165\u6210\u529f\u3002");
                    }
                }
                catch (IOException e) {
                    logger.error(number + "\u7684\u81ea\u5b9a\u4e49API\u5bfc\u5165\u5931\u8d25\uff1a", (Throwable)e);
                }
            }
            HashMap params = new HashMap(2);
            HashMap cookiesMap = new HashMap(2);
            HashMap<String, String> headersMap = new HashMap<String, String>(2);
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("url", url);
            paramMap.put("method", method);
            paramMap.put("charset", "utf-8");
            paramMap.put("data", data);
            paramMap.put("cookies", cookiesMap);
            headersMap.put("Content-Type", "application/json");
            paramMap.put("headers", headersMap);
            paramMap.put("timeout", 10000);
            params.put("paramMap", paramMap);
            Object result = null;
            try {
                result = DispatchServiceHelper.invokeExternalService((String)"aef", (String)number, params);
                logger.info("sendHttpByApic param : {} ,result :{}", params, result);
                Object object2 = result;
                return object2;
            }
            catch (Exception err) {
                try {
                    txHandle.markRollback();
                    logger.error((Throwable)err);
                    throw err;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }
}

