/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.common.util;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.fileservice.FileItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.FileNameUtils;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.ArchiveUtil;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.constant.BillType;
import kd.fi.aef.entity.ArchiveLogInfo;
import kd.fi.aef.entity.ArchiveRangeInfo;
import kd.fi.aef.entity.Attach;
import kd.fi.aef.helper.QueryFinanceBillHelper;
import kd.fi.bd.util.AccountUtils;

public class SingleArchiveUtil {
    private static final Log logger = LogFactory.getLog(SingleArchiveUtil.class);
    private static final String[] aviliableFormat = new String[]{"jpg", "png", "jpeg", "bmp", "doc", "docx", "xlsx", "xls", "pdf"};

    public static void createThreadCache(String billType, Set<Long> ids) {
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)billType, (String)"id,entries.id,entries.currency.id,entries.account,entries.account.number,entries.account.fullname,entries.assgrp.value", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, (String)"id,entries.seq");
        HashMap<String, ArrayList<DynamicObject>> map = new HashMap<String, ArrayList<DynamicObject>>();
        for (DynamicObject dyn : dyns) {
            String id = dyn.getString("id");
            ArrayList<DynamicObject> dys = (ArrayList<DynamicObject>)map.get(id);
            if (dys != null && !dys.isEmpty()) {
                dys.add(dyn);
                map.put(id, dys);
                continue;
            }
            dys = new ArrayList<DynamicObject>();
            dys.add(dyn);
            map.put(id, dys);
        }
        ThreadCache.put((Object)"glVoucher", map);
    }

    public static FileItem getFileItem(String tenantId, String accountId, byte[] pdfData, String billid, String billType) {
        ByteArrayInputStream in = new ByteArrayInputStream(pdfData);
        String fileName = billid + ".pdf";
        FileItem fileItem = new FileItem(fileName, FileNameUtils.getBillImageFileName((String)tenantId, (String)accountId, (String)billType, (String)fileName), (InputStream)in);
        return fileItem;
    }

    public static DynamicObject getBillPathDynamicObject(String url, String billType, int imageType, Long billId, Long userId, String filename, Date date) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"aef_archieve_imagepath");
        DynamicObject temp = (DynamicObject)type.createInstance();
        temp.set("billid", (Object)billId);
        temp.set("imagetype", (Object)imageType);
        temp.set("imagepath", (Object)url);
        temp.set("billtype", (Object)billType);
        temp.set("filename", (Object)filename);
        temp.set("archievetime", (Object)date);
        temp.set("archieveid", (Object)userId);
        return temp;
    }

    public static DynamicObject getArhieveRecordDynamicObject(String billType, String application, String schemeId, Row row, Long userId, Date date, String uploadway, String optype, String reason, Date billbizdate, String uniquekey, String batchCode) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"aef_acelre");
        DynamicObject temp = (DynamicObject)type.createInstance();
        temp.set("billtype", (Object)billType);
        temp.set("application", (Object)application);
        temp.set("wayid", (Object)Long.valueOf(schemeId));
        if (null != row) {
            temp.set("billno", (Object)row.getString(ArchiveUtil.getFieldName(billType, QueryFinanceBillHelper.getBillNo((String)billType))));
            temp.set("billid", (Object)row.getLong(ArchiveUtil.getFieldName(billType, "id")));
            temp.set("org", (Object)row.getLong("org"));
            if ("gl_voucher".equals(billType)) {
                temp.set("filingperiod", (Object)row.getLong("periodid"));
                temp.set("booktype", (Object)row.getLong("booktypeid"));
            }
            if ("fa_card_fin".equals(billType)) {
                temp.set("filingperiod", (Object)row.getLong("period"));
            }
            if ("cas_balanceadjust".equals(billType) || "cas_bankstatement".equals(billType)) {
                temp.set("filingperiod", (Object)row.getLong("periodid"));
            }
        }
        temp.set("batchcode", (Object)batchCode);
        temp.set("uploadway", (Object)uploadway);
        temp.set("type", (Object)optype);
        temp.set("reason", (Object)reason);
        temp.set("billbizdate", (Object)billbizdate);
        temp.set("uniquekey", (Object)uniquekey);
        temp.set("billstatus", (Object)"C");
        temp.set("filingid", (Object)userId);
        temp.set("creator", (Object)userId);
        temp.set("auditor", (Object)userId);
        temp.set("modifier", (Object)userId);
        temp.set("fexetime", (Object)date);
        temp.set("createtime", (Object)date);
        temp.set("modifytime", (Object)date);
        return temp;
    }

    public static DynamicObject getTaxArhieveDynamicObject(ArchiveLogInfo archiveLogInfo) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"aef_acelre_tax");
        DynamicObject temp = (DynamicObject)type.createInstance();
        temp.set("billtype", (Object)archiveLogInfo.getBilltype());
        temp.set("application", (Object)archiveLogInfo.getApplication());
        temp.set("wayid", (Object)archiveLogInfo.getSchemeId());
        temp.set("billno", (Object)archiveLogInfo.getBillno());
        temp.set("billid", (Object)archiveLogInfo.getBillid());
        temp.set("org", (Object)archiveLogInfo.getOrgId());
        temp.set("batchcode", (Object)archiveLogInfo.getBatchCode());
        temp.set("uploadway", (Object)archiveLogInfo.getUploadway());
        temp.set("type", (Object)archiveLogInfo.getType());
        temp.set("reason", (Object)archiveLogInfo.getReason());
        temp.set("billbizdate", (Object)archiveLogInfo.getBillbizdate());
        temp.set("group", (Object)archiveLogInfo.getGroupId());
        temp.set("otherdata_tag", (Object)archiveLogInfo.getOtherdata());
        temp.set("filingperiod", (Object)archiveLogInfo.getPeriod());
        temp.set("taxarchivedata", (Object)archiveLogInfo.getTaxarchivedata());
        temp.set("group", (Object)archiveLogInfo.getGroupId());
        temp.set("skssqq", (Object)archiveLogInfo.getSkssqq());
        temp.set("skssqz", (Object)archiveLogInfo.getSkssqz());
        temp.set("billstatus", (Object)"C");
        temp.set("filingid", (Object)archiveLogInfo.getUserId());
        temp.set("creator", (Object)archiveLogInfo.getUserId());
        temp.set("auditor", (Object)archiveLogInfo.getUserId());
        temp.set("modifier", (Object)archiveLogInfo.getUserId());
        temp.set("fexetime", (Object)archiveLogInfo.getDate());
        temp.set("createtime", (Object)archiveLogInfo.getDate());
        temp.set("modifytime", (Object)archiveLogInfo.getDate());
        return temp;
    }

    public static Map<String, String> invokeBcmPrintService(ArchiveContext context) {
        Map<String, String> result;
        ArchiveRangeInfo info = (ArchiveRangeInfo)SerializationUtils.fromJsonString((String)context.getArchiverange(), ArchiveRangeInfo.class);
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("modelId", info.getModelId());
        HashMap<Long, Integer> orgs = new HashMap<Long, Integer>(2);
        String orgJson = info.getOrgJson();
        List orgList = (List)SerializationUtils.fromJsonString((String)orgJson, List.class);
        for (Map map : orgList) {
            orgs.put(Long.parseLong((String)map.get("id")), Integer.parseInt((String)map.get("scope")));
        }
        param.put("orgs", orgs);
        param.put("templateIds", info.getReportEntityIds());
        param.put("currencyId", info.getCurrencyId());
        param.put("dataUnit", info.getAmountUnit());
        param.put("scenarioId", context.getBcmscene());
        param.put("fyId", context.getBcmfy());
        param.put("periodId", context.getBcmperiod());
        param.put("isOnlyReport", Boolean.TRUE);
        boolean mergeRptArchiveCheckAuth = context.isMergeRptArchiveCheckAuth();
        param.put("permCheck", mergeRptArchiveCheckAuth);
        RequestContext.get().setClientFullContextPath(ConfigurationUtil.getString((String)"domain.contextUrl"));
        try {
            result = SingleArchiveUtil.invokeBcmPrintService(param);
        }
        catch (Exception e) {
            logger.error(String.format("\u5f52\u6863\u5931\u8d25\uff1a{%s}", ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u62a5\u8868\u5f52\u6863\u63a5\u53e3\u5931\u8d25{%s}\u3002", (String)"ArchiveReportFormByDowJonesLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        return result;
    }

    private static Map<String, String> invokeBcmPrintService(Map<String, Object> param) {
        LogUtil.printLog((Log)logger, (String)ResManager.loadKDString((String)"\u62a5\u8868\u5f52\u6863\u5165\u53c2\uff1a{}", (String)"SingleArchiveUtil_2", (String)"fi-aef-common", (Object[])new Object[0]), (Object[])new Object[]{param});
        Map<String, String> result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"bcm", (String)"ReportPrintMsService", (String)"getPrintUrls", (Object[])new Object[]{param});
        LogUtil.printLog((Log)logger, (String)ResManager.loadKDString((String)"\u62a5\u8868\u5f52\u6863\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u503c \uff1a{}", (String)"SingleArchiveUtil_0", (String)"fi-aef-common", (Object[])new Object[0]), (Object[])new Object[]{param, result});
        result = null != result ? result.entrySet().stream().filter(r -> null != r.getKey() && (!((String)r.getKey()).endsWith("_0") || ((String)r.getKey()).equals("type_0"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : Collections.emptyMap();
        LogUtil.printLog((Log)logger, (String)ResManager.loadKDString((String)"\u5904\u7406\u540e\u62a5\u8868\u5f52\u6863\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u503c \uff1a{}", (String)"SingleArchiveUtil_1", (String)"fi-aef-common", (Object[])new Object[0]), (Object[])new Object[]{param, result});
        return result;
    }

    public static DynamicObject getRptArhieveRecordDynamicObject(String schemeId, Long userId, Date date, String uploadway, String optype, String reason, Date billbizdate, String uniquekey, long bcmscene, long bcmfy, long bcmperiod, String batchcode) {
        String[] arr;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"aef_acelre_rpt");
        DynamicObject temp = (DynamicObject)type.createInstance();
        temp.set("wayid", (Object)Long.valueOf(schemeId));
        temp.set("uploadway", (Object)uploadway);
        temp.set("type", (Object)optype);
        temp.set("reason", (Object)reason);
        temp.set("billbizdate", (Object)billbizdate);
        temp.set("uniquekey", (Object)uniquekey);
        if (StringUtils.isNotEmpty((CharSequence)uniquekey) && (arr = uniquekey.split("_")).length == 3) {
            temp.set("bcmorgid", (Object)Long.parseLong(arr[0]));
            temp.set("bcmtemplateid", (Object)Long.parseLong(arr[1]));
        }
        temp.set("billtype", (Object)"aef_rpt");
        temp.set("bcmscene", (Object)bcmscene);
        temp.set("bcmfy", (Object)bcmfy);
        temp.set("bcmperiod", (Object)bcmperiod);
        temp.set("batchcode", (Object)batchcode);
        if (SysParamConfig.getBoolean("needwritebackstatus", false)) {
            temp.set("status", (Object)"2");
        }
        temp.set("billstatus", (Object)"C");
        temp.set("filingid", (Object)userId);
        temp.set("creator", (Object)userId);
        temp.set("auditor", (Object)userId);
        temp.set("modifier", (Object)userId);
        temp.set("fexetime", (Object)date);
        temp.set("createtime", (Object)date);
        temp.set("modifytime", (Object)date);
        return temp;
    }

    public static DataSet getAttacheDynamicObjects(String billType, Set<Long> ids) {
        QFilter filter = new QFilter("fbilltype", "=", (Object)billType);
        QFilter filter2 = new QFilter("finterid", "in", ids.stream().map(x -> x.toString()).collect(Collectors.toSet()));
        QFilter[] filters = new QFilter[]{filter, filter2};
        DataSet attaches = QueryServiceHelper.queryDataSet((String)"getAttacheDynamicObjects", (String)"bos_attachment", (String)"finterid,fattachmentname,ffileid,fextname", (QFilter[])filters, null);
        return attaches;
    }

    public static void saveAefAcelreByFtp(ArrayList<DynamicObject> dynamicObjects, ArrayList<DynamicObject> filePaths) {
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])filePaths.toArray(new DynamicObject[0]));
    }

    public static FileItem getReportFileItem(String tenantId, String accountId, byte[] pdfData, String billType, Map<String, Object> map) {
        String endperiod;
        ByteArrayInputStream in = new ByteArrayInputStream(pdfData);
        String periodStr = "";
        String startperiod = String.valueOf(map.get("startperiod"));
        periodStr = startperiod.equals(endperiod = String.valueOf(map.get("endperiod"))) ? startperiod : startperiod + "-" + endperiod;
        String fileName = billType + "-" + String.valueOf(map.get("org")) + "-" + periodStr + ".pdf";
        FileItem fileItem = new FileItem(fileName, FileNameUtils.getRptImageFileName((String)tenantId, (String)accountId, (String)billType, (String)fileName), (InputStream)in);
        return fileItem;
    }

    public static DynamicObject getArhieveRecordRptDynamicObject(String billType, String appId, String schemeId, Map<String, Object> map, Date date, String uploadway, Long billId, Long userId, String optype, String reason, Date billbizdate, String uniquekey, String batchcode, Long booktypeId) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"aef_acelre");
        DynamicObject temp = (DynamicObject)type.createInstance();
        temp.set("billtype", (Object)billType);
        temp.set("application", (Object)appId);
        temp.set("wayid", (Object)Long.valueOf(schemeId));
        temp.set("org", map.get("org"));
        temp.set("filingperiod", map.get("endperiod"));
        temp.set("billno", (Object)BillType.getBillTypeDesc((String)billType));
        temp.set("billid", (Object)billId);
        temp.set("uploadway", (Object)uploadway);
        temp.set("type", (Object)optype);
        temp.set("reason", (Object)reason);
        temp.set("billbizdate", (Object)billbizdate);
        temp.set("uniquekey", (Object)uniquekey);
        temp.set("batchcode", (Object)batchcode);
        temp.set("booktype", (Object)booktypeId);
        temp.set("billstatus", (Object)"C");
        temp.set("filingid", (Object)userId);
        temp.set("creator", (Object)userId);
        temp.set("auditor", (Object)userId);
        temp.set("modifier", (Object)userId);
        temp.set("fexetime", (Object)date);
        temp.set("createtime", (Object)date);
        temp.set("modifytime", (Object)date);
        return temp;
    }

    public static DynamicObject getArhieveSubledDynamicObject(String billType, String accountNumber, String appId, String schemeId, Map<String, Object> map, Date date, String uploadway, Long billId, Long userId, String optype, String reason, Date billbizdate, String uniquekey, String batchcode, Long booktypeId) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"aef_acelre");
        DynamicObject temp = (DynamicObject)type.createInstance();
        temp.set("billtype", (Object)billType);
        temp.set("application", (Object)appId);
        temp.set("wayid", (Object)Long.valueOf(schemeId));
        temp.set("org", map.get("org"));
        temp.set("filingperiod", map.get("endperiod"));
        temp.set("billno", (Object)accountNumber);
        temp.set("billid", (Object)billId);
        temp.set("uploadway", (Object)uploadway);
        temp.set("type", (Object)optype);
        temp.set("reason", (Object)reason);
        temp.set("billbizdate", (Object)billbizdate);
        temp.set("uniquekey", (Object)uniquekey);
        temp.set("batchcode", (Object)batchcode);
        temp.set("booktype", (Object)booktypeId);
        temp.set("billstatus", (Object)"C");
        temp.set("filingid", (Object)userId);
        temp.set("creator", (Object)userId);
        temp.set("auditor", (Object)userId);
        temp.set("modifier", (Object)userId);
        temp.set("fexetime", (Object)date);
        temp.set("createtime", (Object)date);
        temp.set("modifytime", (Object)date);
        return temp;
    }

    public static Map<Long, ArrayList<Map<String, String>>> getAttachFile(String billType, Set<Long> ids) {
        HashMap<Long, ArrayList<Map<String, String>>> map = new HashMap<Long, ArrayList<Map<String, String>>>(16);
        QFilter filter = new QFilter("fbilltype", "=", (Object)billType);
        QFilter filter2 = new QFilter("finterid", "in", ids.parallelStream().map(x -> String.valueOf(x)).collect(Collectors.toSet()));
        QFilter[] filters = new QFilter[]{filter, filter2};
        DataSet set = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.common.util.SingleArchiveUtil.getAttachFile", (String)"bos_attachment", (String)"finterid,fattachmentname,ffileid,fextname", (QFilter[])filters, (String)"finterid");
        for (Row row : set) {
            String type = row.getString("fextname");
            if (!Arrays.stream(aviliableFormat).anyMatch(h -> h.equalsIgnoreCase(type))) continue;
            String fileName = row.getString("fattachmentname");
            String url = row.getString("ffileid");
            Long billId = row.getLong("finterid");
            HashMap<String, String> filedMap = new HashMap<String, String>();
            filedMap.put("fileName", fileName);
            filedMap.put("url", url);
            ArrayList maplist = (ArrayList)map.get(billId);
            if (maplist != null && !maplist.isEmpty()) {
                maplist.add(filedMap);
                map.put(billId, maplist);
                continue;
            }
            ArrayList<HashMap<String, String>> mapList = new ArrayList<HashMap<String, String>>();
            mapList.add(filedMap);
            map.put(billId, mapList);
        }
        return map;
    }

    public static Map<Long, List<Attach>> getIdAndAttacheFiles(String billType, Set<Long> ids) {
        HashMap<Long, List<Attach>> map = new HashMap<Long, List<Attach>>();
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(new QFilter("fbilltype", "=", (Object)billType));
        qfilters.add(new QFilter("finterid", "in", ids.parallelStream().map(x -> String.valueOf(x)).collect(Collectors.toSet())));
        String algoKey = "kd.fi.aef.common.util.SingleArchiveUtil.getIdAndAttaches";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_attachment", (String)"fextname,fbilltype,ffileid,finterid,fattachmentname", (QFilter[])qfilters.toArray(new QFilter[0]), (String)"finterid");){
            for (Row row : dataSet) {
                Long id = row.getLong("finterid");
                Attach attach = new Attach();
                attach.setBillId(row.getString("finterid"));
                attach.setBillType(billType);
                attach.setExtName(row.getString("fextname"));
                attach.setFileName(row.getString("fattachmentname"));
                attach.setUrl(row.getString("ffileid"));
                map.computeIfAbsent(id, value -> new ArrayList()).add(attach);
            }
        }
        return map;
    }

    public static Map<String, Map<Long, List<String>>> getImageNumberMap(String billType, Set<Long> ids) {
        HashMap<String, Map<Long, List<String>>> map = new HashMap<String, Map<Long, List<String>>>(16);
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(16);
        qfilters.add(new QFilter("billtype", "=", (Object)billType));
        qfilters.add(new QFilter("billid", "in", ids.parallelStream().map(x -> String.valueOf(x)).collect(Collectors.toSet())));
        String algoKey = "kd.fi.aef.common.util.SingleArchiveUtil.getImageNumberMap";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_billimagemap", (String)"billid,billtype,imagenumber", (QFilter[])qfilters.toArray(new QFilter[0]), (String)"billid");){
            for (Row row : dataSet) {
                Long id = row.getLong("billid");
                String billtype = row.getString("billtype");
                Map imageNumberMap = map.computeIfAbsent(billtype, value -> new HashMap());
                List imageNumbers = imageNumberMap.computeIfAbsent(id, value -> new ArrayList());
                imageNumbers.add(row.getString("imagenumber"));
            }
        }
        return map;
    }

    public static void deleteBkrs(Set<Long> needArchiveIds) {
        HashSet<Long> idSet = new HashSet<Long>(needArchiveIds.size());
        QFilter idFilter = new QFilter("billid", "in", needArchiveIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AbstractArchiveLogicUnit.deleteBkrs", (String)"aef_bkrs", (String)"id", (QFilter[])idFilter.toArray(), null);){
            for (Row row : dataSet) {
                idSet.add(row.getLong("id"));
            }
        }
        OperationServiceHelper.executeOperate((String)"delete", (String)"aef_bkrs", (Object[])idSet.toArray(), (OperateOption)OperateOption.create());
    }

    public static void insertInvoicePool(Map<String, Set<DynamicObject>> vatInvoiceMap, JSONObject json, String tickettype, Long vid, Map<Long, JSONObject> voucherJson, String refbillType, Long refbillId) {
        String billType = "";
        switch (tickettype) {
            case "atr_receiver": {
                billType = "aef_atrreceiver";
                break;
            }
            case "rai_receiver": {
                billType = "aef_raireceiver";
                break;
            }
            case "bkrs": {
                billType = "aef_bkrs";
                break;
            }
            case "bker_receiver": {
                billType = "aef_bkerreceiver";
                break;
            }
            case "inv_ord_receiver": {
                billType = "aef_invordreceiver";
                break;
            }
            case "inv_spcl_receiver": {
                billType = "aef_invspclreceiver";
                break;
            }
            case "inv_tlf_receiver": {
                billType = "aef_invtlfreceiver";
                break;
            }
            case "ntrev_gpm_receiver": {
                billType = "aef_ntrevgpmreceiver";
                break;
            }
            case "einv_ord_receiver": {
                billType = "aef_einvordreceiver";
                break;
            }
            case "einv_spcl_receiver": {
                billType = "aef_einvspclreceiver";
                break;
            }
            case "efi": {
                billType = "aef_efi";
                break;
            }
        }
        json.remove((Object)"InformationOfAccountingDocumentsTuple");
        DynamicObject dyn = SingleArchiveUtil.getArhievePoolDynamicObject(json, billType, vid, voucherJson, refbillType, refbillId);
        vatInvoiceMap.computeIfAbsent(billType, value -> new HashSet()).add(dyn);
    }

    public static DynamicObject getArhievePoolDynamicObject(JSONObject json, String billType, Long vId, Map<Long, JSONObject> voucherJson, String refbillType, Long refbillId) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)billType);
        DynamicObject temp = (DynamicObject)type.createInstance();
        temp.set("org", json.get((Object)"org"));
        temp.set("sourcebillno", json.get((Object)"sourcebillno"));
        if (!"aef_bkrs".equals(billType)) {
            temp.set("org", voucherJson.get(vId).get((Object)"org"));
            temp.set("billtype", (Object)refbillType);
            temp.set("billid", (Object)refbillId);
            temp.set("directvoucherid", (Object)vId);
        } else {
            temp.set("billid", json.get((Object)"billid"));
            temp.set("billtype", (Object)"bei_elecstatement");
        }
        temp.set("archivedate", (Object)new Date());
        temp.set("xbrlurl", json.get((Object)"xbrlUrl"));
        temp.set("largejson_tag", (Object)json.toString());
        switch (billType) {
            case "aef_invordreceiver": {
                temp.set("socialcreditcode", json.get((Object)"UnifiedSocialCreditCodeOfAccountingEntity"));
                temp.set("accountingentityname", json.get((Object)"NameOfAccountingEntity"));
                temp.set("uniquecode", json.get((Object)"UniqueCodeOfInvoice"));
                temp.set("nameofseller", json.get((Object)"NameOfSeller"));
                temp.set("taxsocialcreditcode", json.get((Object)"TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller"));
                temp.set("totalamountexcludingtax", json.get((Object)"TotalAmountExcludingTax"));
                temp.set("totaltaxamount", json.get((Object)"TotalTaxAmount"));
                temp.set("taxincludedamountinfigure", json.get((Object)"TaxIncludedAmountInFigures"));
                temp.set("dateofissue", (Object)DateUtil.stringToDate((String)json.getString("DateOfIssue"), (String)"yyyy-MM-dd"));
                temp.set("contractnumber", json.get((Object)"ContractNumber"));
                temp.set("matchingstate", json.get((Object)"MatchingStateBetweenBusinessDocumentsAndVatEInvoice"));
                temp.set("amortizationmethod", json.get((Object)"DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets"));
                temp.set("isredinvoice", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceIsRedInvoice")));
                temp.set("hasbeenchecked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenChecked")));
                temp.set("hasbeenbooked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenBooked")));
                temp.set("hasbeenfsos", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenFactoredSoldOrSecuritized")));
                temp.set("hasbeenpaid", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenPaid")));
                temp.set("electronicnumber", json.get((Object)"NumberOfBankElectronicReceipt"));
                temp.set("beginperiod", json.get((Object)"BeginningOfExpenditurePeriodUnderAccrualBasis"));
                temp.set("endperiod", json.get((Object)"EndOfExpenditurePeriodUnderAccrualBasis"));
                temp.set("hasbeencompleted", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted")));
                temp.set("beginyear", json.get((Object)"BeginningOfPreTaxDeductionYearOfIncomeTax"));
                temp.set("endyear", json.get((Object)"EndOfPreTaxDeductionYearOfIncomeTax"));
                SingleArchiveUtil.setEntry(temp, voucherJson.get(vId), vId);
                break;
            }
            case "aef_invspclreceiver": {
                temp.set("socialcreditcode", json.get((Object)"UnifiedSocialCreditCodeOfAccountingEntity"));
                temp.set("accountingentityname", json.get((Object)"NameOfAccountingEntity"));
                temp.set("uniquecode", json.get((Object)"UniqueCodeOfInvoice"));
                temp.set("nameofseller", json.get((Object)"NameOfSeller"));
                temp.set("taxsocialcreditcode", json.get((Object)"TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller"));
                temp.set("totalamountexcludingtax", json.get((Object)"TotalAmountExcludingTax"));
                temp.set("totaltaxamount", json.get((Object)"TotalTaxAmount"));
                temp.set("taxincludedamountinfigure", json.get((Object)"TaxIncludedAmountInFigures"));
                temp.set("dateofissue", (Object)DateUtil.stringToDate((String)json.getString("DateOfIssue"), (String)"yyyy-MM-dd"));
                temp.set("contractnumber", json.get((Object)"ContractNumber"));
                temp.set("matchingstate", json.get((Object)"MatchingStateBetweenBusinessDocumentsAndVatEInvoice"));
                temp.set("amortizationmethod", json.get((Object)"DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets"));
                temp.set("isredinvoice", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceIsRedInvoice")));
                temp.set("hasbeenchecked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenChecked")));
                temp.set("hasbeenbooked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenBooked")));
                temp.set("hasbeenfsos", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenFactoredSoldOrSecuritized")));
                temp.set("hasbeenpaid", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenPaid")));
                temp.set("electronicnumber", json.get((Object)"NumberOfBankElectronicReceipt"));
                temp.set("accountingentityname", json.get((Object)"NameOfAccountingEntity"));
                temp.set("beginperiod", json.get((Object)"BeginningOfExpenditurePeriodUnderAccrualBasis"));
                temp.set("endperiod", json.get((Object)"EndOfExpenditurePeriodUnderAccrualBasis"));
                temp.set("hasbeencompleted", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted")));
                temp.set("beginyear", json.get((Object)"BeginningOfPreTaxDeductionYearOfIncomeTax"));
                temp.set("endyear", json.get((Object)"EndOfPreTaxDeductionYearOfIncomeTax"));
                temp.set("hasbeenconfirmed", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceUsageHasBeenConfirmed")));
                temp.set("usageconfirmation", json.get((Object)"UsageConfirmation"));
                temp.set("usageconfirmationperiod", json.get((Object)"PeriodOfUsageConfirmation"));
                temp.set("istransferredout", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInputVatHasBeenTransferredOut")));
                temp.set("transferredoutamount", json.get((Object)"AmountOfTransferredOutInputVat"));
                SingleArchiveUtil.setEntry(temp, voucherJson.get(vId), vId);
                break;
            }
            case "aef_invtlfreceiver": {
                temp.set("socialcreditcode", json.get((Object)"UnifiedSocialCreditCodeOfAccountingEntity"));
                temp.set("accountingentityname", json.get((Object)"NameOfAccountingEntity"));
                temp.set("uniquecode", json.get((Object)"UniqueCodeOfInvoice"));
                temp.set("nameofseller", json.get((Object)"NameOfSeller"));
                temp.set("taxsocialcreditcode", json.get((Object)"TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller"));
                temp.set("totalamountexcludingtax", json.get((Object)"TotalAmountExcludingTax"));
                temp.set("totaltaxamount", json.get((Object)"TotalTaxAmount"));
                temp.set("taxincludedamountinfigure", json.get((Object)"TaxIncludedAmountInFigures"));
                temp.set("dateofissue", (Object)DateUtil.stringToDate((String)json.getString("DateOfIssue"), (String)"yyyy-MM-dd"));
                temp.set("isredinvoice", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceIsRedInvoice")));
                temp.set("hasbeenpaid", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenPaid")));
                temp.set("hasbeenbooked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenBooked")));
                temp.set("hasbeenfsos", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenFactoredSoldOrSecuritized")));
                temp.set("electronicnumber", json.get((Object)"NumberOfBankElectronicReceipt"));
                temp.set("beginperiod", json.get((Object)"BeginningOfExpenditurePeriodUnderAccrualBasis"));
                temp.set("endperiod", json.get((Object)"EndOfExpenditurePeriodUnderAccrualBasis"));
                temp.set("hasbeencompleted", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted")));
                temp.set("beginyear", json.get((Object)"BeginningOfPreTaxDeductionYearOfIncomeTax"));
                temp.set("endyear", json.get((Object)"EndOfPreTaxDeductionYearOfIncomeTax"));
                temp.set("hasbeenconfirmed", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceUsageHasBeenConfirmed")));
                temp.set("usageconfirmation", json.get((Object)"UsageConfirmation"));
                temp.set("usageconfirmationperiod", json.get((Object)"PeriodOfUsageConfirmation"));
                temp.set("istransferredout", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInputVatHasBeenTransferredOut")));
                temp.set("transferredoutamount", json.get((Object)"AmountOfTransferredOutInputVat"));
                SingleArchiveUtil.setEntry(temp, voucherJson.get(vId), vId);
                break;
            }
            case "aef_ntrevgpmreceiver": {
                temp.set("socialcreditcode", json.get((Object)"UnifiedSocialCreditCodeOfAccountingEntity"));
                temp.set("accountingentityname", json.get((Object)"NameOfAccountingEntity"));
                temp.set("einvoiceid", json.get((Object)"EINVOICE_ID"));
                temp.set("billdate", (Object)DateUtil.stringToDate((String)json.getString("BILL_DATE"), (String)"yyyy-MM-dd"));
                temp.set("paidamt", json.get((Object)"PAID_AMT"));
                temp.set("isredinvoice", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceIsRedInvoice")));
                temp.set("hasbeenchecked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenChecked")));
                temp.set("hasbeenbooked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenBooked")));
                SingleArchiveUtil.setEntry(temp, voucherJson.get(vId), vId);
                break;
            }
            case "aef_raireceiver": {
                temp.set("socialcreditcode", json.get((Object)"UnifiedSocialCreditCodeOfAccountingEntity"));
                temp.set("accountingentityname", json.get((Object)"NameOfAccountingEntity"));
                temp.set("travelnumber", json.get((Object)"ElectronicInvoiceRailwayETicketNumber"));
                temp.set("dateofissue", (Object)DateUtil.stringToDate((String)json.getString("DateOfIssue"), (String)"yyyy-MM-dd"));
                temp.set("totalamountexcludingtax", json.get((Object)"TotalAmountExcludingTax"));
                temp.set("taxrate", json.get((Object)"TaxRate"));
                temp.set("taxamount", json.get((Object)"TaxAmount"));
                temp.set("isredinvoice", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceIsRedInvoice")));
                temp.set("hasbeenbooked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenBooked")));
                temp.set("hasbeendeducted", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenDeducted")));
                temp.set("deductiontaxperiod", json.get((Object)"TaxPeriodOfInvoiceDeduction"));
                SingleArchiveUtil.setEntry(temp, voucherJson.get(vId), vId);
                break;
            }
            case "aef_atrreceiver": {
                temp.set("socialcreditcode", json.get((Object)"UnifiedSocialCreditCodeOfAccountingEntity"));
                temp.set("accountingentityname", json.get((Object)"NameOfAccountingEntity"));
                temp.set("travelnumber", json.get((Object)"ElectronicInvoiceAirTransportReceiptNumber"));
                temp.set("fare", json.get((Object)"Fare"));
                temp.set("issueparty", json.get((Object)"IssueParty"));
                temp.set("issuedate", (Object)DateUtil.stringToDate((String)json.getString("IssueDate"), (String)"yyyy-MM-dd"));
                temp.set("isredinvoice", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceIsRedInvoice")));
                temp.set("hasbeenchecked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenChecked")));
                temp.set("hasbeenbooked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenBooked")));
                temp.set("hasbeendeducted", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenDeducted")));
                temp.set("deductiontaxperiod", json.get((Object)"TaxPeriodOfInvoiceDeduction"));
                SingleArchiveUtil.setEntry(temp, voucherJson.get(vId), vId);
                break;
            }
            case "aef_bkerreceiver": {
                temp.set("id", (Object)DBServiceHelper.genGlobalLongId());
                temp.set("socialcreditcode", json.get((Object)"UnifiedSocialCreditCodeOfAccountingEntity"));
                temp.set("accountingentityname", json.get((Object)"NameOfAccountingEntity"));
                temp.set("identifyingcode", json.get((Object)"IdentifyingCode"));
                temp.set("currency", json.get((Object)"Currency"));
                temp.set("transactionamountinfigure", json.get((Object)"TransactionAmountInFigures"));
                temp.set("contractnumber", json.get((Object)"ContractNumber"));
                temp.set("typeofinvoice", json.get((Object)"TypeOfInvoice"));
                temp.set("dateofissue", json.get((Object)DateUtil.stringToDate((String)json.getString("DateOfIssue"), (String)"yyyy-MM-dd")));
                temp.set("uniquecode", json.get((Object)"UniqueCodeOfInvoice"));
                temp.set("payandrevamount", json.get((Object)"AmountPayableAndReceivable"));
                temp.set("hasbeenclaimed", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenClaimed")));
                temp.set("hasbeenbooked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherReceiptHasBeenBooked")));
                temp.set("hasbeenreconciled", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherReceiptHasBeenReconciled")));
                temp.set("hasbeentransfer", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherReceiptHasBeenTransferredToBank")));
                SingleArchiveUtil.setEntry(temp, voucherJson.get(vId), vId);
                break;
            }
            case "aef_bkrs": {
                temp.set("id", (Object)DBServiceHelper.genGlobalLongId());
                temp.set("billid", json.get((Object)"seqNo"));
                temp.set("identificationorg", json.get((Object)"IdentificationCodeOfIssuer"));
                temp.set("bankbranchnumber", json.get((Object)"NumberOfBankBranch"));
                temp.set("currency", json.get((Object)"Currency"));
                temp.set("settlementaccount", json.get((Object)"CustomerSettlementBankAccount"));
                temp.set("accountname", json.get((Object)"NameOfCustomerAccount"));
                temp.set("bankcustomernumber", json.get((Object)"CodeOfBankCustomer"));
                temp.set("reconyear", json.get((Object)"YearOfBankReconciliationStatement"));
                temp.set("reconmonth", json.get((Object)"MonthOfBankReconciliationStatement"));
                temp.set("printtimes", json.get((Object)"PrintTimes"));
                temp.set("printdate", (Object)DateUtil.stringToDate((String)json.getString("PrintDate"), (String)"yyyy-MM-dd"));
                temp.set("accountbal", json.get((Object)"AccountBalanceAtTheEndOfReconciliationCycleAmount"));
                temp.set("reservebal", json.get((Object)"ReserveBalanceAtTheEndOfReconciliationCycle"));
                temp.set("frozenbal", json.get((Object)"FrozenBalanceAtTheEndOfReconciliationCycle"));
                temp.set("overdraftbal", json.get((Object)"OverdraftBalanceAtEndOfReconciliationCycle"));
                temp.set("availablebal", json.get((Object)"AvailableBalanceAtTheEndOfReconciliationCycleAmount"));
                DynamicObjectCollection dyns = (DynamicObjectCollection)temp.get("entryentity");
                List entrys = (List)json.get((Object)"InformationOfReconcileDetailsTuple");
                for (JSONObject jsonObject : entrys) {
                    DynamicObject entry = dyns.addNew();
                    entry.set("bookdate", (Object)DateUtil.stringToDate((String)jsonObject.getString("DateOfBookkeeping"), (String)"yyyy-MM-dd"));
                    entry.set("businessproductstype", jsonObject.get((Object)"TypesOfBusinessProducts"));
                    entry.set("businessserialnumber", jsonObject.get((Object)"BusinessSerialNumber"));
                    entry.set("sourcevouchertype", jsonObject.get((Object)"TypeOfSourceDocument"));
                    entry.set("sourcevouchernumber", jsonObject.get((Object)"NumberOfSourceDocument"));
                    entry.set("electronicreceiptinfo", jsonObject.get((Object)"NotesOfBankElectronicReceipt"));
                    entry.set("creditordebit", jsonObject.get((Object)"IdentificationOfCreditOrDebit"));
                    entry.set("transactionamount", jsonObject.get((Object)"TransactionAmount"));
                    entry.set("balancedirect", jsonObject.get((Object)"DebitOrCreditOfBalance"));
                    entry.set("accountbalance", jsonObject.get((Object)"AccountBalance"));
                    entry.set("transactioncode", jsonObject.get((Object)"TransactionCode"));
                    entry.set("counterpartyaccount", jsonObject.get((Object)"AccountOfCounterparty"));
                    entry.set("counterpartyname", jsonObject.get((Object)"NameOfCounterparty"));
                    entry.set("depositorybank", jsonObject.get((Object)"DepositoryBankOfCounterparty"));
                    entry.set("bookkeeper", jsonObject.get((Object)"Bookkeeper"));
                    entry.set("accountjournal", jsonObject.get((Object)"JournalAccountOfBookkeeping"));
                    entry.set("otherinfo", jsonObject.get((Object)"OtherAccountingInformation"));
                    entry.set("electronicreceiptnumber", jsonObject.get((Object)"NumberOfBankElectronicReceipt"));
                }
                break;
            }
            case "aef_efi": {
                temp.set("socialcreditcode", json.get((Object)"UnifiedSocialCreditCodeOfAccountingEntity"));
                temp.set("accountingentityname", json.get((Object)"NameOfAccountingEntity"));
                temp.set("einvoiceid", json.get((Object)"EInvoiceID"));
                temp.set("dateofissue", (Object)DateUtil.stringToDate((String)json.getString("IssueDate"), (String)"yyyy-MM-dd"));
                temp.set("totalamount", json.get((Object)"TotalAmount"));
                temp.set("isredinvoice", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceIsRedInvoice")));
                temp.set("hasbeenchecked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenChecked")));
                temp.set("hasbeenbooked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInvoiceHasBeenBooked")));
                SingleArchiveUtil.setEntry(temp, voucherJson.get(vId), vId);
                break;
            }
            case "aef_einvordreceiver": {
                temp.set("socialcreditcode", json.get((Object)"UnifiedSocialCreditCodeOfAccountingEntity"));
                temp.set("accountingentityname", json.get((Object)"NameOfAccountingEntity"));
                temp.set("invoicenumber", json.get((Object)"InvoiceNumber"));
                temp.set("nameofseller", json.get((Object)"SellerName"));
                temp.set("taxsocialcreditcode", json.get((Object)"SellerIdNum"));
                temp.set("totalamountexcludingtax", json.get((Object)"TotalAmWithoutTax"));
                temp.set("totaltaxamount", json.get((Object)"TotalTaxAmount"));
                temp.set("taxincludedamountinfigure", json.get((Object)"TotalTax-includedAmount"));
                temp.set("dateofissue", (Object)DateUtil.stringToDate((String)json.getString("RequestTime"), (String)"yyyy-MM-dd"));
                temp.set("contractnumber", json.get((Object)"ContractNumber"));
                temp.set("matchingstate", json.get((Object)"MatchingStateBetweenBusinessDocumentsAndVatEInvoice"));
                temp.set("amortizationmethod", json.get((Object)"DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets"));
                temp.set("isredinvoice", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherEinvoiceIsRedEinvoice")));
                temp.set("hasbeenchecked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherEinvoiceHasBeenChecked")));
                temp.set("hasbeenbooked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherEinvoiceHasBeenBooked")));
                temp.set("hasbeenfsos", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherEinvoiceHasBeenFactoredSoldOrSecuritized")));
                temp.set("hasbeenpaid", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherEinvoiceHasBeenPaid")));
                temp.set("hasbeencompleted", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted")));
                temp.set("electronicnumber", json.get((Object)"NumberOfBankElectronicReceipt"));
                temp.set("beginperiod", json.get((Object)"BeginningOfExpenditurePeriodUnderAccrualBasis"));
                temp.set("endperiod", json.get((Object)"EndOfExpenditurePeriodUnderAccrualBasis"));
                temp.set("beginyear", json.get((Object)"BeginningOfPreTaxDeductionYearOfIncomeTax"));
                temp.set("endyear", json.get((Object)"EndOfPreTaxDeductionYearOfIncomeTax"));
                SingleArchiveUtil.setEntry(temp, voucherJson.get(vId), vId);
                break;
            }
            case "aef_einvspclreceiver": {
                temp.set("socialcreditcode", json.get((Object)"UnifiedSocialCreditCodeOfAccountingEntity"));
                temp.set("accountingentityname", json.get((Object)"NameOfAccountingEntity"));
                temp.set("invoicenumber", json.get((Object)"InvoiceNumber"));
                temp.set("nameofseller", json.get((Object)"SellerName"));
                temp.set("taxsocialcreditcode", json.get((Object)"SellerIdNum"));
                temp.set("totalamountexcludingtax", json.get((Object)"TotalAmWithoutTax"));
                temp.set("totaltaxamount", json.get((Object)"TotalTaxAmount"));
                temp.set("taxincludedamountinfigure", json.get((Object)"TotalTax-includedAmount"));
                temp.set("dateofissue", (Object)DateUtil.stringToDate((String)json.getString("RequestTime"), (String)"yyyy-MM-dd"));
                temp.set("contractnumber", json.get((Object)"ContractNumber"));
                temp.set("matchingstate", json.get((Object)"MatchingStateBetweenBusinessDocumentsAndVatEInvoice"));
                temp.set("amortizationmethod", json.get((Object)"DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets"));
                temp.set("isredinvoice", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherEinvoiceIsRedEinvoice")));
                temp.set("hasbeenchecked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherEinvoiceHasBeenChecked")));
                temp.set("hasbeenbooked", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherEinvoiceHasBeenBooked")));
                temp.set("hasbeenfsos", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherEinvoiceHasBeenFactoredSoldOrSecuritized")));
                temp.set("hasbeenpaid", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherEinvoiceHasBeenPaid")));
                temp.set("electronicnumber", json.get((Object)"NumberOfBankElectronicReceipt"));
                temp.set("beginperiod", json.get((Object)"BeginningOfExpenditurePeriodUnderAccrualBasis"));
                temp.set("endperiod", json.get((Object)"EndOfExpenditurePeriodUnderAccrualBasis"));
                temp.set("hasbeencompleted", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted")));
                temp.set("beginyear", json.get((Object)"BeginningOfPreTaxDeductionYearOfIncomeTax"));
                temp.set("endyear", json.get((Object)"EndOfPreTaxDeductionYearOfIncomeTax"));
                temp.set("hasbeenconfirmed", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherEinvoiceUsageHasBeenConfirmed")));
                temp.set("usageconfirmation", json.get((Object)"UsageConfirmation"));
                temp.set("usageconfirmationperiod", json.get((Object)"PeriodOfUsageConfirmation"));
                temp.set("istransferredout", (Object)SingleArchiveUtil.getBooleanValue(json.get((Object)"WhetherInputVatHasBeenTransferredOut")));
                temp.set("transferredoutamount", json.get((Object)"AmountOfTransferredOutInputVat"));
                SingleArchiveUtil.setEntry(temp, voucherJson.get(vId), vId);
                break;
            }
        }
        return temp;
    }

    private static void setEntry(DynamicObject temp, JSONObject json, Long vId) {
        DynamicObjectCollection dyns = (DynamicObjectCollection)temp.get("entryentity");
        DynamicObject entry = dyns.addNew();
        entry.set("vouchernumber", json.get((Object)"NumberOfAccountingDocuments"));
        entry.set("bookdate", (Object)DateUtil.stringToDate((String)json.getString("PostingDate"), (String)"yyyy-MM-dd"));
        entry.set("period", json.get((Object)"AccountingPeriod"));
        entry.set("vdescription", json.get((Object)"SummaryOfAccountingDocuments"));
        entry.set("voucherid", (Object)vId);
    }

    private static int getBooleanValue(Object object) {
        if (StringUtils.isBlank((Object)object)) {
            return 0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        return "true".equals(object.toString()) ? 1 : 0;
    }

    public static Set<Long> getFilingIds(String billType, Set<Long> ids) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(3);
        qfilters.add(new QFilter("billtype", "=", (Object)billType));
        qfilters.add(new QFilter("billid", "in", ids));
        qfilters.add(new QFilter("filingstatus", "=", (Object)"1"));
        String algoKey = "kd.fi.aef.common.util.SingleArchiveUtil.getFilingIds";
        HashSet<Long> idSet = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"gl_filingdata", (String)"billid", (QFilter[])qfilters.toArray(new QFilter[0]), null);){
            for (Row row : dataSet) {
                Long id = row.getLong("billid");
                idSet.add(id);
            }
        }
        return idSet;
    }

    public static Set<Long> getAllDetailAccountId(Map<String, Object> map) {
        long startperiod = (Long)map.get("startperiod");
        long org = (Long)map.get("org");
        long booktype = (Long)map.get("bookType");
        Long acctTableId = AccountRefUtils.getCurPeriodAccountTableId((long)org, (long)booktype, (long)startperiod);
        DynamicObject curPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter("id", "=", (Object)startperiod).toArray());
        Date date = curPeriodDyn.getDate("enddate");
        List accountIds = AccountUtils.getLeafAccountIds((long)org, (long)acctTableId, (Date)date);
        return new HashSet<Long>(accountIds);
    }

    public static Set<Long> getAllFirstLevelAccountId(Map<String, Object> map) {
        long startperiod = (Long)map.get("startperiod");
        long org = (Long)map.get("org");
        long booktype = (Long)map.get("bookType");
        long acctTableId = AccountRefUtils.getCurPeriodAccountTableId((long)org, (long)booktype, (long)startperiod);
        DynamicObject curPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter("id", "=", (Object)startperiod).toArray());
        Date date = curPeriodDyn.getDate("enddate");
        List accountIds = AccountUtils.getAccountIds((long)org, (long)acctTableId, (Date)date, (QFilter)new QFilter("level", "=", (Object)1));
        return new HashSet<Long>(accountIds);
    }
}

