/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.aef.common.util.BizParamUtils;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.FieldMappingUtil;
import kd.fi.aef.common.util.JudgePageUtil;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.entity.Printsample;
import kd.fi.aef.entity.SchemeEntry;
import kd.fi.aef.helper.ArchiveSchemeHelper;
import kd.fi.bd.util.AccountUtils;

public class SplitDataUtil {
    private static final Log logger = LogFactory.getLog(SplitDataUtil.class);

    public static List<SchemeEntry> splitData(List<SchemeEntry> schemeEntrys, OperateOption option) {
        String archivetype;
        switch (archivetype = option.getVariableValue("archivetype")) {
            case "finance": {
                schemeEntrys = SplitDataUtil.getFinanceSchemeEntrys(schemeEntrys, option);
                break;
            }
            case "bill": {
                schemeEntrys = SplitDataUtil.getCommonBillSchemeEntrys(schemeEntrys, option);
                break;
            }
            case "tax": {
                schemeEntrys = SplitDataUtil.getTaxSchemeEntrys(schemeEntrys, option);
                break;
            }
        }
        return schemeEntrys;
    }

    public static List<SchemeEntry> splitReverseFilingData(List<Long> ids, OperateOption option) {
        List accountIds;
        SchemeEntry schemeEntry;
        ArrayList<SchemeEntry> schemeEntrys = new ArrayList<SchemeEntry>();
        String selectFields = "billtype.id billtype,uniquekey,billid,org.id orgid,wayid.id schemeid,filingperiod.id periodid,batchcode";
        HashSet<String> voucherInfos = new HashSet<String>();
        HashSet<Long> voucherIds = new HashSet<Long>();
        HashSet<Long> cardfinIds = new HashSet<Long>();
        HashSet<String> cardfinInfos = new HashSet<String>();
        HashMap<String, Set<Long>> commonBillIdMap = new HashMap<String, Set<Long>>();
        HashSet<Long> schemeIds = new HashSet<Long>(16);
        HashMap<String, List> subledgerMap = new HashMap<String, List>(5);
        HashMap<String, List> generalledgerMap = new HashMap<String, List>(5);
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.common.util.SplitDataUtil.splitReverseFilingData", (String)"aef_acelre", (String)selectFields, (QFilter[])new QFilter("id", "in", ids).toArray(), (String)"billtype.id");){
            block24: for (Row row : dataset) {
                String billType = row.getString("billtype");
                Long schemeId = row.getLong("schemeid");
                String batchCode = row.getString("batchcode");
                schemeIds.add(schemeId);
                switch (billType) {
                    case "gl_voucher": {
                        Long billId = row.getLong("billid");
                        voucherIds.add(billId);
                        String info = billType + "&" + row.getLong("orgid") + "&" + row.getLong("periodid") + "&" + schemeId + "&" + billId + "&" + batchCode;
                        voucherInfos.add(info);
                        continue block24;
                    }
                    case "fa_card_fin": {
                        Long billid = row.getLong("billid");
                        cardfinIds.add(billid);
                        String infos = billType + "&" + row.getLong("orgid") + "&" + row.getLong("periodid") + "&" + schemeId + "&" + billid + "&" + batchCode;
                        cardfinInfos.add(infos);
                        continue block24;
                    }
                    case "gl_rpt_generalledger": {
                        boolean isSupportGeneralledgerNew;
                        boolean bl = isSupportGeneralledgerNew = option.containsVariable("support_gl_rpt_generalledger_new") && Boolean.parseBoolean(option.getVariableValue("support_gl_rpt_generalledger_new"));
                        if (isSupportGeneralledgerNew) {
                            SchemeEntry scheme = SplitDataUtil.createRptReverseSchemeEntry(row);
                            String[] unikey = row.getString("uniquekey").split("-");
                            generalledgerMap.computeIfAbsent(unikey[0] + "-" + unikey[1] + "-" + unikey[2], value -> new ArrayList()).add(scheme);
                            continue block24;
                        }
                        SchemeEntry schemeEntry2 = SplitDataUtil.createRptReverseSchemeEntry(row);
                        schemeEntrys.add(schemeEntry2);
                        continue block24;
                    }
                    case "gl_rpt_subledger": {
                        SchemeEntry scheme = SplitDataUtil.createRptReverseSchemeEntry(row);
                        String[] unikey = row.getString("uniquekey").split("-");
                        subledgerMap.computeIfAbsent(unikey[0] + "-" + unikey[1] + "-" + unikey[2], value -> new ArrayList()).add(scheme);
                        continue block24;
                    }
                    case "cas_bankjournalformrpt": 
                    case "cas_cashjournalformrpt": {
                        SchemeEntry casRptReverseSchemeEntry = SplitDataUtil.createCasRptReverseSchemeEntry(row);
                        schemeEntrys.add(casRptReverseSchemeEntry);
                        continue block24;
                    }
                }
                Long orgId = row.getLong("orgid");
                String key = orgId + "&" + billType + "&" + schemeId + "&" + batchCode;
                Set billids = commonBillIdMap.computeIfAbsent(key, k -> new HashSet(8));
                billids.add(row.getLong("billid"));
            }
        }
        Map<String, Map<String, String>> billEntryInfo = SplitDataUtil.getBillEntryInfoById(schemeIds);
        List<SchemeEntry> commonBillSchemeEntrys = SplitDataUtil.buildComBillEntrys(commonBillIdMap, billEntryInfo);
        schemeEntrys.addAll(commonBillSchemeEntrys);
        if (!voucherIds.isEmpty()) {
            List<SchemeEntry> voucherSchemeEntrys = SplitDataUtil.buildFinaceBillEntrys(voucherInfos, voucherIds, billEntryInfo, "gl_voucher");
            schemeEntrys.addAll(voucherSchemeEntrys);
        }
        if (!cardfinIds.isEmpty()) {
            List<SchemeEntry> cardfinSchemeEntrys = SplitDataUtil.buildFinaceBillEntrys(cardfinInfos, cardfinIds, billEntryInfo, "fa_card_fin");
            schemeEntrys.addAll(cardfinSchemeEntrys);
        }
        if (!subledgerMap.isEmpty()) {
            for (Map.Entry entry : subledgerMap.entrySet()) {
                schemeEntry = (SchemeEntry)((List)entry.getValue()).get(0);
                if (StringUtils.isNotBlank((CharSequence)schemeEntry.getArchiverange())) {
                    accountIds = ((List)entry.getValue()).stream().map(SchemeEntry::getArchiverange).collect(Collectors.toList());
                    schemeEntry.setArchiverange(SerializationUtils.serializeToBase64(accountIds));
                }
                schemeEntrys.add(schemeEntry);
            }
        }
        if (!generalledgerMap.isEmpty()) {
            for (Map.Entry entry : generalledgerMap.entrySet()) {
                schemeEntry = (SchemeEntry)((List)entry.getValue()).get(0);
                if (StringUtils.isNotBlank((CharSequence)schemeEntry.getArchiverange())) {
                    accountIds = ((List)entry.getValue()).stream().map(SchemeEntry::getArchiverange).collect(Collectors.toList());
                    schemeEntry.setArchiverange(SerializationUtils.serializeToBase64(accountIds));
                }
                schemeEntrys.add(schemeEntry);
            }
        }
        return schemeEntrys;
    }

    private static List<SchemeEntry> buildFinaceBillEntrys(Set<String> infos, Set<Long> Ids, Map<String, Map<String, String>> billEntryInfo, String billType) {
        ArrayList<SchemeEntry> schemeEntrys = new ArrayList<SchemeEntry>();
        HashMap<String, SchemeEntry> schemeMap = new HashMap<String, SchemeEntry>(100);
        HashMap<Long, Long> idAndBilltype = new HashMap<Long, Long>(100);
        String algoKey = "kd.fi.aef.common.util.SplitDataUtil.buildFinaceBillEntrys";
        String selectFields = billType.equalsIgnoreCase("gl_voucher") ? "id,booktype.id booktype" : "id,depreuse.id booktype";
        DataSet dataset = QueryServiceHelper.queryDataSet((String)algoKey, (String)billType, (String)selectFields, (QFilter[])new QFilter("id", "in", Ids).toArray(), null);
        Object object = null;
        try {
            for (Row row : dataset) {
                idAndBilltype.put(row.getLong("id"), row.getLong("booktype"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataset != null) {
                if (object != null) {
                    try {
                        dataset.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataset.close();
                }
            }
        }
        Map<String, Map<String, String>> schemeInfo = SplitDataUtil.getFinaceReserveSchemeinfo(infos, billType);
        for (String info : infos) {
            String largesamplejson_tag;
            String key;
            String[] strInfos = info.split("&");
            Long billId = Long.parseLong(strInfos[4]);
            Long orgId = Long.parseLong(strInfos[1]);
            Long periodId = Long.parseLong(strInfos[2]);
            Long schemeId = Long.parseLong(strInfos[3]);
            Long bookTypeId = (Long)idAndBilltype.get(billId);
            String batchCode = "";
            if (strInfos.length > 5) {
                batchCode = strInfos[5];
            }
            if (schemeMap.get(key = orgId + "-" + bookTypeId + "-" + periodId + "-" + schemeId + "-" + batchCode) != null) {
                ((SchemeEntry)schemeMap.get(key)).getIds().add(billId);
                continue;
            }
            SchemeEntry schemeEntry = new SchemeEntry();
            String isArchieveAttach = billEntryInfo.get(schemeId + "-" + billType).get("isneedattachfile");
            if (StringUtils.isNotEmpty((CharSequence)batchCode) && schemeInfo.containsKey(batchCode)) {
                isArchieveAttach = schemeInfo.get(batchCode).get("isneedattachfile");
            }
            schemeEntry.setIsArchieveAttach(isArchieveAttach);
            schemeEntry.setOrgId(orgId.longValue());
            schemeEntry.setPeriodId(periodId.longValue());
            schemeEntry.setBookTypeId(bookTypeId.longValue());
            schemeEntry.setSchemeId(schemeId.longValue());
            schemeEntry.getIds().add(billId);
            schemeEntry.setBillType(billType);
            schemeEntry.setBatchcode(batchCode);
            schemeEntry.setIsxbrlpilot(billEntryInfo.get(schemeId + "-" + billType).get("isxbrlpilot"));
            if ("gl_voucher".equalsIgnoreCase(billType) && !StringUtils.isEmpty((CharSequence)(largesamplejson_tag = billEntryInfo.get(schemeId + "-" + billType).get("largesamplejson_tag")))) {
                HashMap<String, String> map = new HashMap<String, String>(16);
                HashMap<String, Printsample> refBillInfoMap = new HashMap<String, Printsample>(16);
                List list = SerializationUtils.fromJsonStringToList((String)largesamplejson_tag, Printsample.class);
                for (Printsample printsample : list) {
                    map.put(printsample.getBillType(), printsample.getRefbillsampleid());
                    refBillInfoMap.put(printsample.getBillType(), printsample);
                }
                schemeEntry.setRefBillTempInfo(map);
                if (StringUtils.isNotEmpty((CharSequence)batchCode) && schemeInfo.containsKey(batchCode)) {
                    String archiveRange = schemeInfo.get(batchCode).get("archiverange");
                    if (StringUtils.isNotBlank((CharSequence)archiveRange)) {
                        schemeEntry.setRefBillAllInfo((Map)SerializationUtils.fromJsonString((String)archiveRange, Map.class));
                    } else {
                        schemeEntry.setRefBillAllInfo(new HashMap(1));
                    }
                } else {
                    schemeEntry.setRefBillAllInfo(refBillInfoMap);
                }
            }
            schemeMap.put(key, schemeEntry);
        }
        schemeEntrys.addAll(schemeMap.values());
        return schemeEntrys;
    }

    private static Map<String, Map<String, String>> getFinaceReserveSchemeinfo(Set<String> infos, String billType) {
        HashMap<String, Map<String, String>> schemeInfo = new HashMap<String, Map<String, String>>(infos.size());
        HashSet<String> batchcodes = new HashSet<String>(infos.size());
        for (String info : infos) {
            String[] split = info.split("&");
            if (split.length <= 5) continue;
            batchcodes.add(split[5]);
        }
        String algoKey = "kd.fi.aef.common.util.SplitDataUtil.getFinaceReserveSchemeinfo";
        String selectFields = "billtype,batchcode,archiverange_tag,isneedattachfile";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"aef_archieveconfig", (String)selectFields, (QFilter[])new QFilter("batchcode", "in", batchcodes).and(new QFilter("billType", "=", (Object)billType)).toArray(), null);){
            for (Row row : dataSet) {
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put("isneedattachfile", row.getString("isneedattachfile"));
                if ("gl_voucher".equals(billType)) {
                    map.put("archiverange", row.getString("archiverange_tag"));
                }
                schemeInfo.put(row.getString("batchcode"), map);
            }
        }
        return schemeInfo;
    }

    private static List<SchemeEntry> buildComBillEntrys(Map<String, Set<Long>> commonBillIdMap, Map<String, Map<String, String>> billEntryInfo) {
        ArrayList<SchemeEntry> schemeEntrys = new ArrayList<SchemeEntry>(commonBillIdMap.size());
        Map<String, String> billSchemeInfo = SplitDataUtil.getBillSchemeInfo(commonBillIdMap);
        for (Map.Entry<String, Set<Long>> entry : commonBillIdMap.entrySet()) {
            SchemeEntry schemeEntry = new SchemeEntry();
            String key = entry.getKey();
            String[] infos = key.split("&");
            Long orgId = Long.parseLong(infos[0]);
            String billType = infos[1];
            Long schemeId = Long.parseLong(infos[2]);
            String batchCode = "";
            if (infos.length > 3) {
                batchCode = infos[3];
            }
            key = schemeId + "-" + billType;
            if (StringUtils.isNotEmpty((CharSequence)batchCode) && billSchemeInfo.containsKey(batchCode)) {
                schemeEntry.setArchieveAttach(billSchemeInfo.get(batchCode));
            } else {
                schemeEntry.setArchieveAttach(billEntryInfo.get(key).get("isneedattachfile"));
            }
            schemeEntry.setBillType(billType);
            schemeEntry.setDateField(billEntryInfo.get(key).get("datefield"));
            schemeEntry.setOrgId(orgId.longValue());
            schemeEntry.setSchemeId(schemeId.longValue());
            schemeEntry.setIds(entry.getValue());
            schemeEntry.setIsxbrlpilot(billEntryInfo.get(key).get("isxbrlpilot"));
            schemeEntry.setBatchcode(batchCode);
            schemeEntrys.add(schemeEntry);
        }
        return schemeEntrys;
    }

    private static Map<String, String> getBillSchemeInfo(Map<String, Set<Long>> commonBillIdMap) {
        HashMap<String, String> schemeInfo = new HashMap<String, String>(commonBillIdMap.size());
        HashSet<String> batchcodes = new HashSet<String>(commonBillIdMap.size());
        for (String info : commonBillIdMap.keySet()) {
            String[] split = info.split("&");
            if (split.length <= 3) continue;
            batchcodes.add(info.split("&")[3]);
        }
        String algoKey = "kd.fi.aef.common.util.SplitDataUtil.getBillSchemeInfo";
        String selectFields = "billtype,batchcode,archiverange_tag,isneedattachfile";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"aef_archieveconfig", (String)selectFields, (QFilter[])new QFilter("batchcode", "in", batchcodes).toArray(), null);){
            for (Row row : dataSet) {
                schemeInfo.put(row.getString("batchcode"), row.getString("isneedattachfile"));
            }
        }
        return schemeInfo;
    }

    private static Map<String, Map<String, String>> getBillEntryInfoById(Set<Long> schemeIds) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(16);
        Map schemeMap = BusinessDataServiceHelper.loadFromCache((Object[])schemeIds.toArray(new Long[0]), (String)"aef_archivescheme");
        for (DynamicObject dyn : schemeMap.values()) {
            Long schemeId = dyn.getLong("id");
            String archivetype = dyn.getString("archivetype");
            String isxbrlpilot = dyn.getString("isxbrlpilot");
            DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                String billType = entry.getString("billtype.id");
                String key = schemeId + "-" + billType;
                HashMap<String, String> entryInfos = new HashMap<String, String>(10);
                if ("bill".equalsIgnoreCase(archivetype) || "fa_card_fin".equalsIgnoreCase(billType) || "tax".equalsIgnoreCase(archivetype)) {
                    entryInfos.put("isneedattachfile", entry.getBoolean("isneedattachfile") + "");
                    if (!"fa_card_fin".equalsIgnoreCase(billType)) {
                        entryInfos.put("datefield", entry.getString("datefield"));
                    }
                    entryInfos.put("isxbrlpilot", isxbrlpilot);
                    map.put(key, entryInfos);
                    continue;
                }
                if (!"gl_voucher".equalsIgnoreCase(billType)) continue;
                entryInfos.put("isneedattachfile", entry.getString("isneedattachfile"));
                entryInfos.put("largesamplejson_tag", entry.getString("largesamplejson_tag"));
                entryInfos.put("isxbrlpilot", isxbrlpilot);
                map.put(key, entryInfos);
            }
        }
        return map;
    }

    private static SchemeEntry createCasRptReverseSchemeEntry(Row row) {
        SchemeEntry schemeEntry = new SchemeEntry();
        String uniqueKey = row.getString("uniquekey");
        String[] uniqueKeys = uniqueKey.split("-");
        long orgId = Long.parseLong(uniqueKeys[0]);
        long periodId = Long.parseLong(uniqueKeys[1]);
        schemeEntry.setOrgId(orgId);
        schemeEntry.setPeriodId(periodId);
        schemeEntry.setBillType(row.getString("billtype"));
        return schemeEntry;
    }

    private static SchemeEntry createRptReverseSchemeEntry(Row row) {
        SchemeEntry schemeEntry = new SchemeEntry();
        String uniqueKey = row.getString("uniquekey");
        String[] uniqueKeys = uniqueKey.split("-");
        Long orgId = Long.parseLong(uniqueKeys[0]);
        Long periodId = Long.parseLong(uniqueKeys[2]);
        schemeEntry.setOrgId(orgId.longValue());
        schemeEntry.setBookTypeId(Long.parseLong(uniqueKeys[1]));
        schemeEntry.setPeriodId(periodId.longValue());
        if (uniqueKeys.length == 4) {
            schemeEntry.setArchiverange(uniqueKeys[3]);
        }
        schemeEntry.setBillType(row.getString("billtype"));
        return schemeEntry;
    }

    private static List<SchemeEntry> getCommonBillSchemeEntrys(List<SchemeEntry> schemeEntrys, OperateOption option) {
        int batchNum = SysParamConfig.getInt("batchnum", 200);
        Date startDate = DateUtil.stringToDate((String)option.getVariableValue("startdate"), (String)"yyyy-MM-dd");
        Date endDate = DateUtil.stringToDate((String)option.getVariableValue("enddate"), (String)"yyyy-MM-dd");
        endDate = DateUtil.getNextDate((Date)endDate);
        Map map = DateUtil.getIntervalTimeByMonth((Date)startDate, (Date)endDate);
        ArrayList<SchemeEntry> schemes = new ArrayList<SchemeEntry>();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        Long orgId = Long.parseLong(option.getVariableValue("org"));
        HashSet<String> billTypeSet = new HashSet<String>(schemeEntrys.size());
        for (SchemeEntry schemeEntry : schemeEntrys) {
            String billType = schemeEntry.getBillType();
            billTypeSet.add(billType);
        }
        Map<String, String> billType2ArchiveOrgCfgFieldMap = BizParamUtils.getBillType2ArchiveOrgCfgFieldMap(billTypeSet);
        for (SchemeEntry schemeEntry : schemeEntrys) {
            String periodFiledByBill;
            String billType = schemeEntry.getBillType();
            MainEntityType bet = EntityMetadataCache.getDataEntityType((String)billType);
            String mainOrgField = billType2ArchiveOrgCfgFieldMap.get(billType) == null ? bet.getMainOrg() : billType2ArchiveOrgCfgFieldMap.get(billType);
            String dateField = schemeEntry.getDateField();
            String archiveRangeJson = schemeEntry.getArchiverange();
            QFilter rangeFilter = null;
            if (StringUtils.isNotBlank((CharSequence)archiveRangeJson)) {
                rangeFilter = ArchiveSchemeHelper.getCustomQFilter((String)billType, (String)archiveRangeJson);
            }
            if (JudgePageUtil.isFromIntellexec((OperateOption)option)) {
                map = (Map)SerializationUtils.deSerializeFromBase64((String)schemeEntry.getIntelldateJson());
            }
            if (StringUtils.isNotEmpty((CharSequence)(periodFiledByBill = FieldMappingUtil.getPeriodFiledByBill(billType)))) {
                schemes.addAll(SplitDataUtil.getCommonBillSchemeEntryByPeriod(map, mainOrgField, option, batchNum, schemeEntry, periodFiledByBill));
                continue;
            }
            for (Map.Entry entry : map.entrySet()) {
                startDate = (Date)entry.getKey();
                endDate = (Date)entry.getValue();
                qFilters.clear();
                qFilters.add(new QFilter(mainOrgField, "=", (Object)orgId));
                qFilters.add(new QFilter("billstatus", ">=", (Object)Character.valueOf('C')));
                qFilters.add(new QFilter(dateField, ">=", (Object)startDate));
                qFilters.add(new QFilter(dateField, "<", (Object)endDate));
                if (StringUtils.isNotBlank((CharSequence)archiveRangeJson)) {
                    qFilters.add(rangeFilter);
                }
                HashSet<Long> billIds = new HashSet<Long>(200);
                try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.common.util.SplitDataUtil.getCommonBillSchemeEntrys", (String)billType, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id");){
                    for (Row row : dataset) {
                        billIds.add(row.getLong("id"));
                    }
                }
                Set<Long> hasArchieveBillIds = SplitDataUtil.getHasArchieveCommonBillIds(option, billType, billIds);
                billIds.removeAll(hasArchieveBillIds);
                HashSet<Long> needIds = new HashSet<Long>(batchNum);
                for (Long id : billIds) {
                    needIds.add(id);
                    if (needIds.size() % batchNum != 0) continue;
                    SchemeEntry sEntry = SplitDataUtil.bulidNewEntry(schemeEntry);
                    sEntry.setIds(needIds);
                    schemes.add(sEntry);
                    needIds = new HashSet(batchNum);
                }
                if (needIds.size() <= 0) continue;
                SchemeEntry sEntry = SplitDataUtil.bulidNewEntry(schemeEntry);
                sEntry.setIds(needIds);
                schemes.add(sEntry);
            }
        }
        return schemes;
    }

    private static List<SchemeEntry> getCommonBillSchemeEntryByPeriod(Map<Date, Date> dateMap, String mainOrgField, OperateOption option, int batchNum, SchemeEntry schemeEntry, String periodFiledByBill) {
        if (Objects.isNull(dateMap) || dateMap.isEmpty()) {
            return new ArrayList<SchemeEntry>(0);
        }
        Date minDate = null;
        Date maxDate = null;
        for (Map.Entry<Date, Date> map : dateMap.entrySet()) {
            Date key = map.getKey();
            Date value = map.getValue();
            if (Objects.isNull(minDate) || key.compareTo(minDate) < 0) {
                minDate = key;
            }
            if (!Objects.isNull(maxDate) && value.compareTo(maxDate) <= 0) continue;
            maxDate = value;
        }
        ArrayList<SchemeEntry> schemes = new ArrayList<SchemeEntry>();
        if (Objects.isNull(minDate) && Objects.isNull(maxDate)) {
            return schemes;
        }
        long orgId = Long.parseLong(option.getVariableValue("org"));
        String dateField = schemeEntry.getDateField();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(mainOrgField, "=", (Object)orgId));
        qFilters.add(new QFilter("billstatus", ">=", (Object)Character.valueOf('C')));
        qFilters.add(new QFilter(dateField, ">=", (Object)minDate));
        qFilters.add(new QFilter(dateField, "<", (Object)maxDate));
        String archiveRangeJson = schemeEntry.getArchiverange();
        String billType = schemeEntry.getBillType();
        if (StringUtils.isNotBlank((CharSequence)archiveRangeJson)) {
            QFilter rangeFilter = ArchiveSchemeHelper.getCustomQFilter((String)billType, (String)archiveRangeJson);
            qFilters.add(rangeFilter);
        }
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.common.util.SplitDataUtil.getCommonBillSchemeEntrys", (String)billType, (String)("id," + periodFiledByBill), (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id");){
            DataSet[] splitByPeriod;
            HashSet<Long> billIdSet = new HashSet<Long>(16);
            DataSet copyDataSet = dataset.copy();
            for (Row row : copyDataSet) {
                Long id = row.getLong("id");
                billIdSet.add(id);
            }
            Set<Long> hasArchiveBillIds = SplitDataUtil.getHasArchieveCommonBillIds(option, billType, billIdSet);
            for (DataSet dataSet : splitByPeriod = dataset.splitByGroup(new String[]{periodFiledByBill})) {
                HashSet<Long> needArchiveIds = new HashSet<Long>(16);
                for (Row row : dataSet) {
                    Long billId = row.getLong("id");
                    if (hasArchiveBillIds.contains(billId)) continue;
                    needArchiveIds.add(billId);
                    if (needArchiveIds.size() % batchNum != 0) continue;
                    SchemeEntry sEntry = SplitDataUtil.bulidNewEntry(schemeEntry);
                    sEntry.setIds(needArchiveIds);
                    schemes.add(sEntry);
                    needArchiveIds = new HashSet(batchNum);
                }
                if (needArchiveIds.size() <= 0) continue;
                SchemeEntry sEntry = SplitDataUtil.bulidNewEntry(schemeEntry);
                sEntry.setIds(needArchiveIds);
                schemes.add(sEntry);
            }
        }
        return schemes;
    }

    private static List<SchemeEntry> getTaxSchemeEntrys(List<SchemeEntry> schemeEntrys, OperateOption option) {
        int batchNum = SysParamConfig.getInt("batchnum", 200);
        String startDateString = option.getVariableValue("startdate");
        String endDateString = option.getVariableValue("enddate");
        Date startDate = DateUtil.stringToDate((String)startDateString, (String)"yyyy-MM-dd");
        Date endDate = DateUtil.stringToDate((String)endDateString, (String)"yyyy-MM-dd");
        endDate = DateUtil.getNextDate((Date)endDate);
        Map map = DateUtil.getIntervalTimeByMonth((Date)startDate, (Date)endDate);
        ArrayList<SchemeEntry> schemes = new ArrayList<SchemeEntry>();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        Long orgId = Long.parseLong(option.getVariableValue("org"));
        for (SchemeEntry schemeEntry : schemeEntrys) {
            Map rangeMap;
            String taxarchivedata;
            QFilter rangeFilter = null;
            String archiveRangeJson = schemeEntry.getArchiverange();
            String billType = schemeEntry.getBillType();
            MainEntityType bet = EntityMetadataCache.getDataEntityType((String)billType);
            if (StringUtils.isNotBlank((CharSequence)archiveRangeJson)) {
                rangeFilter = ArchiveSchemeHelper.getCustomQFilter((String)billType, (String)archiveRangeJson);
            }
            if ("tccit".equals(taxarchivedata = (String)(rangeMap = (Map)SerializationUtils.fromJsonString((String)schemeEntry.getArchiverangeReport(), Map.class)).get("taxarchivedata"))) {
                rangeMap.put("startdate", startDateString);
                rangeMap.put("enddate", endDateString);
                rangeMap.put("nxxfilter", archiveRangeJson);
                schemeEntry.setArchiverangeReport(SerializationUtils.toJsonString((Object)rangeMap));
                schemes.add(schemeEntry);
                continue;
            }
            if (!"bill".equals(taxarchivedata)) continue;
            String mainOrgField = bet.getMainOrg();
            String dateField = schemeEntry.getDateField();
            if (JudgePageUtil.isFromIntellexec((OperateOption)option)) {
                map = (Map)SerializationUtils.deSerializeFromBase64((String)schemeEntry.getIntelldateJson());
            }
            for (Map.Entry entry : map.entrySet()) {
                startDate = (Date)entry.getKey();
                endDate = (Date)entry.getValue();
                qFilters.clear();
                qFilters.add(new QFilter(mainOrgField, "=", (Object)orgId));
                qFilters.add(new QFilter("billstatus", ">=", (Object)Character.valueOf('C')));
                qFilters.add(new QFilter(dateField, ">=", (Object)startDate));
                qFilters.add(new QFilter(dateField, "<", (Object)endDate));
                if (StringUtils.isNotBlank((CharSequence)archiveRangeJson)) {
                    qFilters.add(rangeFilter);
                }
                HashSet<Long> billIds = new HashSet<Long>(200);
                try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.common.util.SplitDataUtil.getTaxSchemeEntrys", (String)billType, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id");){
                    for (Row row : dataset) {
                        billIds.add(row.getLong("id"));
                    }
                }
                Set<Long> hasArchieveBillIds = SplitDataUtil.getHasArchieveTaxBillIds(option, billType, billIds);
                billIds.removeAll(hasArchieveBillIds);
                HashSet<Long> needIds = new HashSet<Long>(batchNum);
                for (Long id : billIds) {
                    needIds.add(id);
                    if (needIds.size() % batchNum != 0) continue;
                    SchemeEntry sEntry = SplitDataUtil.bulidNewEntry(schemeEntry);
                    sEntry.setIds(needIds);
                    schemes.add(sEntry);
                    needIds = new HashSet(batchNum);
                }
                if (needIds.size() <= 0) continue;
                SchemeEntry sEntry = SplitDataUtil.bulidNewEntry(schemeEntry);
                sEntry.setIds(needIds);
                schemes.add(sEntry);
            }
        }
        return schemes;
    }

    private static SchemeEntry bulidNewEntry(SchemeEntry schemeEntry) {
        SchemeEntry returnEntry = new SchemeEntry(schemeEntry.getOrgId(), schemeEntry.getSchemeId(), schemeEntry.getBillType(), schemeEntry.getBookTypeId(), schemeEntry.getArchieveType(), schemeEntry.getIsArchieveAttach(), schemeEntry.getAttachtabJson(), schemeEntry.getPrintsampleId(), schemeEntry.getPrintTemplatetag(), schemeEntry.getPrintType(), schemeEntry.getPeriodId(), schemeEntry.getBatchcode(), schemeEntry.getArchiverange(), schemeEntry.getUploadWay(), schemeEntry.getApplicationId(), schemeEntry.getPageId(), schemeEntry.getRefBillTempInfo(), schemeEntry.getRefBillAllInfo(), schemeEntry.getDateField(), schemeEntry.getIds(), schemeEntry.getBcmscene(), schemeEntry.getBcmsceneType(), schemeEntry.getBcmfy(), schemeEntry.getBcmfyName(), schemeEntry.getBcmperiod(), schemeEntry.getIsxbrlpilot(), schemeEntry.getIntelldateJson(), schemeEntry.getArchiverangeReport());
        return returnEntry;
    }

    private static Set<Long> getHasArchieveCommonBillIds(OperateOption option, String billType, Set<Long> billIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        HashSet<Long> set = new HashSet<Long>(100);
        qFilters.add(new QFilter("billtype.number", "=", (Object)billType));
        qFilters.add(new QFilter("type", "=", (Object)Character.valueOf('1')));
        qFilters.add(new QFilter("billid", "in", billIds));
        qFilters.add(new QFilter("org.id", "=", (Object)Long.parseLong(option.getVariableValue("org"))));
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.common.util.SplitDataUtil.getHasArchieveBillIds", (String)"aef_acelre", (String)"billid", (QFilter[])qFilters.toArray(new QFilter[0]), null);){
            for (Row row : dataset) {
                set.add(row.getLong("billid"));
            }
        }
        return set;
    }

    private static Set<Long> getHasArchieveTaxBillIds(OperateOption option, String billType, Set<Long> billIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        HashSet<Long> set = new HashSet<Long>(100);
        qFilters.add(new QFilter("billtype.number", "=", (Object)billType));
        qFilters.add(new QFilter("type", "=", (Object)Character.valueOf('1')));
        qFilters.add(new QFilter("billid", "in", billIds));
        qFilters.add(new QFilter("org.id", "=", (Object)Long.parseLong(option.getVariableValue("org"))));
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.common.util.SplitDataUtil.getHasArchieveBillIds", (String)"aef_acelre_tax", (String)"billid", (QFilter[])qFilters.toArray(new QFilter[0]), null);){
            for (Row row : dataset) {
                set.add(row.getLong("billid"));
            }
        }
        return set;
    }

    private static List<SchemeEntry> getFinanceSchemeEntrys(List<SchemeEntry> schemeEntrys, OperateOption option) {
        boolean isFa = Boolean.parseBoolean(option.getVariableValue("isFa"));
        Long startPeriodId = Long.parseLong(option.getVariableValue("startperiod"));
        Long endPeriod = Long.parseLong(option.getVariableValue("endperiod"));
        Long periodTypeId = SplitDataUtil.getPeriodTypeId(option, isFa);
        String appId = option.getVariableValue("app_id");
        List<Long> periodIds = SplitDataUtil.getPeriodIds(appId, startPeriodId, endPeriod, periodTypeId);
        if (!isFa) {
            ArrayList<SchemeEntry> schemeentrys = new ArrayList<SchemeEntry>();
            for (SchemeEntry schemeEntry : schemeEntrys) {
                String billType;
                if (JudgePageUtil.isFromIntellexec((OperateOption)option)) {
                    periodIds.clear();
                    periodIds.add(schemeEntry.getPeriodId());
                }
                if ("gl_voucher".equals(billType = schemeEntry.getBillType())) {
                    schemeEntrys = SplitDataUtil.getFinaceBillSchemeEntrys(schemeEntry, periodIds, option, isFa);
                    schemeentrys.addAll(schemeEntrys);
                    continue;
                }
                schemeEntrys = SplitDataUtil.getRptSchemeEntrys(schemeEntry, periodIds, option);
                schemeentrys.addAll(schemeEntrys);
            }
            return schemeentrys;
        }
        SchemeEntry schemeEntry = schemeEntrys.get(0);
        schemeEntrys = SplitDataUtil.getFinaceBillSchemeEntrys(schemeEntry, periodIds, option, isFa);
        return schemeEntrys;
    }

    private static List<SchemeEntry> getRptSchemeEntrys(SchemeEntry schemeEntry, List<Long> periodIds, OperateOption option) {
        ArrayList<SchemeEntry> schemes = new ArrayList<SchemeEntry>();
        String appId = option.getVariableValue("app_id");
        String bookType = null;
        if ("gl".equals(appId)) {
            bookType = option.getVariableValue("booktype");
            schemeEntry.setBookTypeId(Long.parseLong(bookType));
        }
        String org = option.getVariableValue("org");
        Set<String> uniKeys = SplitDataUtil.getUniKeys(Long.parseLong(org), schemeEntry.getBillType());
        for (Long periodId : periodIds) {
            String uniKey = Objects.isNull(bookType) ? org + "-" + periodId : org + "-" + bookType + "-" + periodId;
            SchemeEntry sEntry = SplitDataUtil.bulidNewEntry(schemeEntry);
            if ("gl_rpt_subledger".equals(schemeEntry.getBillType()) || "gl_rpt_generalledger".equals(schemeEntry.getBillType())) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("org", Long.parseLong(org));
                map.put("startperiod", periodId);
                map.put("endperiod", periodId);
                map.put("bookType", Long.parseLong(bookType));
                boolean isSupportGeneralledgerNew = option.containsVariable("support_gl_rpt_generalledger_new") && Boolean.parseBoolean(option.getVariableValue("support_gl_rpt_generalledger_new"));
                List<String> accountIdList = "gl_rpt_generalledger".equals(schemeEntry.getBillType()) && isSupportGeneralledgerNew ? SplitDataUtil.getAllFirstLevelAccountId(map) : SplitDataUtil.getAllDetailAccountId(map);
                ArrayList<String> needArchive = new ArrayList<String>(4);
                for (String string : accountIdList) {
                    String unikeySub = uniKey + "-" + string;
                    if (uniKeys.contains(unikeySub) || uniKeys.contains(uniKey)) continue;
                    needArchive.add(string);
                }
                if (needArchive.size() == 0) continue;
                sEntry.setArchiverange(SerializationUtils.serializeToBase64(needArchive));
                sEntry.setPeriodId(periodId.longValue());
                schemes.add(sEntry);
                continue;
            }
            if (uniKeys.contains(uniKey)) continue;
            sEntry.setPeriodId(periodId.longValue());
            schemes.add(sEntry);
        }
        return schemes;
    }

    private static Set<String> getUniKeys(long orgId, String billType) {
        HashSet<String> uniKeys = new HashSet<String>(100);
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("billtype", "=", (Object)billType), new QFilter("type", "=", (Object)"1")};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.common.util.SplitDataUtil.getUniKeys", (String)"aef_acelre", (String)"uniquekey", (QFilter[])filters, null);){
            for (Row row : dataSet) {
                uniKeys.add(row.getString("uniquekey"));
            }
        }
        return uniKeys;
    }

    private static List<SchemeEntry> getFinaceBillSchemeEntrys(SchemeEntry schemeEntry, List<Long> periodIds, OperateOption option, boolean isFa) {
        int batchNum = SysParamConfig.getInt("batchnum", 200);
        ArrayList<SchemeEntry> schemes = new ArrayList<SchemeEntry>();
        String billType = schemeEntry.getBillType();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        Long orgId = Long.parseLong(option.getVariableValue("org"));
        logger.info("orgId :{}, periodIds: {}", (Object)orgId, periodIds);
        for (Long periodId : periodIds) {
            qFilters.clear();
            qFilters.add(new QFilter("billstatus", ">=", (Object)Character.valueOf('C')));
            if ("gl_voucher".equals(billType)) {
                qFilters.add(new QFilter("billstatus", "!=", (Object)"D"));
                qFilters.add(new QFilter("ispost", "=", (Object)"1"));
            }
            qFilters.add(new QFilter("org", "=", (Object)orgId));
            qFilters.add(new QFilter("period", "=", (Object)periodId));
            schemeEntry.setPeriodId(periodId.longValue());
            if (isFa) {
                qFilters.add(new QFilter("depreuse", "=", (Object)Long.parseLong(option.getVariableValue("fadepreuse"))));
                qFilters.add(QFilter.of((String)"bizperiod.id = period.id", (Object[])new Object[0]));
            } else {
                qFilters.add(new QFilter("booktype", "=", (Object)Long.parseLong(option.getVariableValue("booktype"))));
            }
            Set<Long> hasArchieveBillIds = SplitDataUtil.getHasArchieveFianiceBillIds(option, billType, periodId);
            DataSet dataset = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.common.util.SplitDataUtil.getFinaceBillSchemeEntrys", (String)billType, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id");
            Throwable throwable = null;
            try {
                HashSet<Long> billIds = new HashSet<Long>(200);
                for (Row row : dataset) {
                    Long id = row.getLong("id");
                    if (hasArchieveBillIds.contains(id)) continue;
                    billIds.add(id);
                    if (billIds.size() % batchNum != 0) continue;
                    SchemeEntry sEntry = SplitDataUtil.bulidNewEntry(schemeEntry);
                    sEntry.setIds(billIds);
                    schemes.add(sEntry);
                    billIds = new HashSet(batchNum);
                }
                if (billIds.size() <= 0) continue;
                SchemeEntry sEntry = SplitDataUtil.bulidNewEntry(schemeEntry);
                sEntry.setIds(billIds);
                schemes.add(sEntry);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataset == null) continue;
                if (throwable != null) {
                    try {
                        dataset.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataset.close();
            }
        }
        return schemes;
    }

    private static Set<Long> getHasArchieveFianiceBillIds(OperateOption option, String billType, Long periodId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        HashSet<Long> set = new HashSet<Long>(100);
        qFilters.add(new QFilter("billtype.id", "=", (Object)billType));
        qFilters.add(new QFilter("type", "=", (Object)Character.valueOf('1')));
        qFilters.add(new QFilter("filingperiod.id", "=", (Object)periodId));
        qFilters.add(new QFilter("org.id", "=", (Object)Long.parseLong(option.getVariableValue("org"))));
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.common.util.SplitDataUtil.getHasArchieveBillIds", (String)"aef_acelre", (String)"billid", (QFilter[])qFilters.toArray(new QFilter[0]), null);){
            for (Row row : dataset) {
                set.add(row.getLong("billid"));
            }
        }
        return set;
    }

    public static Set<Long> getHasArchieveReportFormIds(Set<Long> ids) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        HashSet<Long> set = new HashSet<Long>(100);
        qFilters.add(new QFilter("billtype", "=", (Object)" "));
        qFilters.add(new QFilter("type", "=", (Object)Character.valueOf('1')));
        qFilters.add(new QFilter("billid", "in", ids));
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.common.util.SplitDataUtil.getHasArchieveBillIds", (String)"aef_acelre", (String)"billid", (QFilter[])qFilters.toArray(new QFilter[0]), null);){
            for (Row row : dataset) {
                set.add(row.getLong("billid"));
            }
        }
        return set;
    }

    private static List<Long> getPeriodIds(String appId, Long startPeriodId, Long endPeriod, Long periodTypeId) {
        ArrayList<Long> periodIds = new ArrayList<Long>();
        String algoKey = "kd.fi.aef.common.util.SplitDataUtil.getPeriodIds";
        QFilter[] filters = new QFilter[4];
        filters[0] = new QFilter("id", ">=", (Object)startPeriodId);
        filters[1] = new QFilter("id", "<=", (Object)endPeriod);
        filters[2] = new QFilter("periodtype", "=", (Object)periodTypeId);
        if (!"gl".equals(appId)) {
            filters[3] = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
        }
        try (DataSet set = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_period", (String)"id", (QFilter[])filters, (String)"id");){
            for (Row row : set) {
                periodIds.add(row.getLong("id"));
            }
        }
        return periodIds;
    }

    private static Long getPeriodTypeId(OperateOption option, boolean isFa) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        String selectField = "periodtype.id periodtypeid";
        String appId = option.getVariableValue("app_id");
        String entityName = "";
        if ("fa".equals(appId)) {
            entityName = "fa_assetbook";
        } else if ("gl".equals(appId)) {
            entityName = "gl_accountbook";
        } else if ("cas".equals(appId)) {
            entityName = "cas_cashmgtinit";
        }
        filters.add(new QFilter("org", "=", (Object)Long.parseLong(option.getVariableValue("org"))));
        if (isFa) {
            filters.add(new QFilter("depreuse", "=", (Object)Long.parseLong(option.getVariableValue("fadepreuse"))));
        } else if ("gl".equals(appId)) {
            filters.add(new QFilter("bookstype", "=", (Object)Long.parseLong(option.getVariableValue("booktype"))));
        }
        DynamicObject periodType = QueryServiceHelper.queryOne((String)entityName, (String)selectField, (QFilter[])filters.toArray(new QFilter[2]));
        if (Objects.nonNull(periodType)) {
            return periodType.getLong("periodtypeid");
        }
        return 0L;
    }

    public static List<SchemeEntry> splitReverseRpt(List<Long> ids) {
        String selectFields = "bcmscene.id bcmscene, bcmscene.number bcmsceneType ,bcmscene.name  bcmsceneName, bcmfy.id  bcmfy, bcmfy.name  bcmfyName, bcmperiod.id bcmperiod, bcmperiod.name bcmperiodName,uniquekey uniquekey, billid,org.id orgid, wayid.id schemeid, rpturl";
        HashMap<String, List> dynMap = new HashMap<String, List>(16);
        DynamicObjectCollection alldyns = QueryServiceHelper.query((String)"aef_acelre_rpt", (String)selectFields, (QFilter[])new QFilter("id", "in", ids).toArray());
        for (DynamicObject dyn : alldyns) {
            long schemeid = dyn.getLong("schemeid");
            long bcmscene = dyn.getLong("bcmscene");
            long bcmfy = dyn.getLong("bcmfy");
            long bcmperiod = dyn.getLong("bcmperiod");
            List dyns2 = dynMap.computeIfAbsent("" + schemeid + bcmscene + bcmfy + bcmperiod, value -> new ArrayList());
            dyns2.add(dyn);
        }
        ArrayList<SchemeEntry> schemes = new ArrayList<SchemeEntry>();
        dynMap.forEach((key, dyns) -> {
            DynamicObject temprow = (DynamicObject)dyns.get(0);
            SchemeEntry schemeEntry = new SchemeEntry();
            schemeEntry.setSchemeId(temprow.getLong("schemeid"));
            schemeEntry.setBcmscene(temprow.getLong("bcmscene"));
            schemeEntry.setBcmsceneType(temprow.getString("bcmsceneType"));
            schemeEntry.setBcmfy(temprow.getLong("bcmfy"));
            schemeEntry.setBcmfyName(temprow.getString("bcmfyName"));
            HashMap<Long, String> bcmPeriodMap = new HashMap<Long, String>(1);
            bcmPeriodMap.put(temprow.getLong("bcmperiod"), temprow.getString("bcmperiodName"));
            schemeEntry.setBcmperiod(SerializationUtils.serializeToBase64(bcmPeriodMap));
            HashMap<String, Map> AllrptUrlMap = new HashMap<String, Map>(16);
            for (DynamicObject row : dyns) {
                Map tempMap = AllrptUrlMap.computeIfAbsent(row.getString("uniquekey").split("_")[0] + "_" + temprow.getLong("bcmperiod"), value -> new HashMap());
                tempMap.put(row.getString("uniquekey"), row.getString("uniquekey") + ".pdf");
            }
            String json = SerializationUtils.toJsonString(AllrptUrlMap);
            schemeEntry.setArchiverange(json);
            schemeEntry.setBillType("aef_rpt");
            schemes.add(schemeEntry);
        });
        return schemes;
    }

    public static List<SchemeEntry> splitReverseTax(List<Long> ids) {
        String selectFields = "taxarchivedata, billtype, billid,org.id orgid, wayid.id schemeid, otherdata_tag otherdata, batchcode, filingperiod period";
        HashMap<String, List> dynMap = new HashMap<String, List>(16);
        DynamicObjectCollection alldyns = QueryServiceHelper.query((String)"aef_acelre_tax", (String)selectFields, (QFilter[])new QFilter("id", "in", ids).toArray());
        Set<Long> schemeidIds = alldyns.stream().map(e -> e.getLong("schemeid")).collect(Collectors.toSet());
        Map<String, Map<String, String>> schemeEntryData = SplitDataUtil.getBillEntryInfoById(schemeidIds);
        for (DynamicObject dyn : alldyns) {
            String batchcode = dyn.getString("batchcode");
            String taxarchivedata = dyn.getString("taxarchivedata");
            String period = dyn.getString("period");
            String billtype = dyn.getString("billtype");
            Long schemeid = dyn.getLong("schemeid");
            dynMap.computeIfAbsent(taxarchivedata + batchcode + period + billtype + schemeid, value -> new ArrayList()).add(dyn);
        }
        ArrayList<SchemeEntry> schemes = new ArrayList<SchemeEntry>();
        dynMap.forEach((key, dyns) -> {
            SchemeEntry schemeEntry = new SchemeEntry();
            schemeEntry.setOrgId(((DynamicObject)dyns.get(0)).getLong("orgid"));
            schemeEntry.setBillType(((DynamicObject)dyns.get(0)).getString("billtype"));
            schemeEntry.setSchemeId(((DynamicObject)dyns.get(0)).getLong("schemeid"));
            schemeEntry.setBatchcode(((DynamicObject)dyns.get(0)).getString("batchcode"));
            String entryKey = ((DynamicObject)dyns.get(0)).getLong("schemeid") + "-" + ((DynamicObject)dyns.get(0)).getString("billtype");
            schemeEntry.setArchieveAttach((String)((Map)schemeEntryData.get(entryKey)).get("isneedattachfile"));
            Set billIds = dyns.stream().map(e -> e.getLong("billid")).collect(Collectors.toSet());
            schemeEntry.setIds(billIds);
            HashMap<String, String> rangeMap = new HashMap<String, String>(16);
            rangeMap.put("taxarchivedata", ((DynamicObject)dyns.get(0)).getString("taxarchivedata"));
            schemeEntry.setArchiverangeReport(SerializationUtils.toJsonString(rangeMap));
            ArrayList<Map> declareList = new ArrayList<Map>(16);
            if (((DynamicObject)dyns.get(0)).getString("taxarchivedata").equals("tccit")) {
                for (DynamicObject row : dyns) {
                    Map tempMap = (Map)SerializationUtils.fromJsonString((String)row.getString("otherdata"), Map.class);
                    declareList.add(tempMap);
                }
            } else {
                schemeEntry.setDateField((String)((Map)schemeEntryData.get(entryKey)).get("datefield"));
            }
            schemeEntry.setArchiverange(SerializationUtils.toJsonString(declareList));
            schemes.add(schemeEntry);
        });
        return schemes;
    }

    private static List<String> getAllDetailAccountId(Map<String, Object> map) {
        long startperiod = (Long)map.get("startperiod");
        long org = (Long)map.get("org");
        long booktype = (Long)map.get("bookType");
        Long acctTableId = AccountRefUtils.getCurPeriodAccountTableId((long)org, (long)booktype, (long)startperiod);
        DynamicObject curPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter("id", "=", (Object)startperiod).toArray());
        Date date = curPeriodDyn.getDate("enddate");
        List accountIds = AccountUtils.getLeafAccountIds((long)org, (long)acctTableId, (Date)date);
        HashSet idSet = new HashSet(accountIds);
        return idSet.stream().map(e -> e.toString()).collect(Collectors.toList());
    }

    private static List<String> getAllFirstLevelAccountId(Map<String, Object> map) {
        long startperiod = (Long)map.get("startperiod");
        long org = (Long)map.get("org");
        long booktype = (Long)map.get("bookType");
        long acctTableId = AccountRefUtils.getCurPeriodAccountTableId((long)org, (long)booktype, (long)startperiod);
        DynamicObject curPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter("id", "=", (Object)startperiod).toArray());
        Date date = curPeriodDyn.getDate("enddate");
        List accountIds = AccountUtils.getAccountIds((long)org, (long)acctTableId, (Date)date, (QFilter)new QFilter("level", "=", (Object)1));
        HashSet idSet = new HashSet(accountIds);
        return idSet.stream().map(Object::toString).collect(Collectors.toList());
    }
}

