/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.cache.CacheHelper;
import kd.fi.aef.cache.CacheModule;
import kd.fi.aef.cache.DistributeCache;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.BusinessTypeUtils;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.FpyOperateUtil;
import kd.fi.aef.common.util.JudgeBillType;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.entity.FileDesc;
import kd.fi.aef.entity.PrintIdandType;
import kd.fi.aef.entity.PrintTemplate;
import kd.fi.aef.helper.ArchiveSchemeHelper;
import kd.fi.aef.logic.ContextData;
import kd.fi.aef.logic.RowResult;
import kd.fi.aef.logic.common.LogicUtils;
import kd.fi.aef.logic.common.SaveArchiveUtils;
import kd.fi.aef.logic.model.Attach;
import kd.fi.aef.logic.model.FileUploadItem;
import kd.fi.aef.logic.output.IDocumentServerHandler;
import kd.fi.aef.logic.output.Result;

public abstract class AbstractArchiveLogicUnit {
    protected final DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.archive);
    protected IDocumentServerHandler documentServerHandler;
    protected ContextData contextData = new ContextData();
    protected Map<Long, List<Attach>> attachMap;
    protected List<DynamicObject> errDyns = new ArrayList<DynamicObject>(16);
    protected Map<Object, FileDesc> billFileMap = new HashMap<Object, FileDesc>(100);
    protected FileUploadItem fileUploadItem;
    protected Date currentDate = new Date();
    protected String billName;
    public static final String NAME = "name";
    public static final String NUMBER = "number";
    public static final String DATASOURCE = "cangqiong";
    protected ArchiveContext context;
    protected Long userId = UserServiceHelper.getCurrentUserId();
    protected String tenantId = RequestContext.get().getTenantId();
    protected String accountId = RequestContext.get().getAccountId();
    private static String SUCCESSCODE = "0000";
    private static final Log logger = LogFactory.getLog(AbstractArchiveLogicUnit.class);
    protected Map<Long, PrintIdandType> billIdAndPrintIdMap;
    protected String printId;
    protected String flag;
    protected boolean multarchive;
    protected boolean isNotNeedUploadFile;
    protected boolean archiveByFilePath;

    public void initAbstractArchiveLogicUnit() {
        this.billName = LogicUtils.getBillName((String)this.context.getBillType());
        if (StringUtils.isNotBlank((CharSequence)this.context.getPrintsampleId())) {
            this.printId = ArchiveSchemeHelper.queryPrintId((String)this.context.getPrintsampleId(), (int)this.context.getPrintType());
        } else if ("1".equals(this.context.getIsReverse())) {
            Map rangeMap;
            if (!(JudgeBillType.isRptFrom((String)this.context.getBillType()) || JudgeBillType.isFinaceRpt((String)this.context.getBillType()) || "tax".equals(this.context.getArchieveType()))) {
                if (StringUtils.isNotBlank((CharSequence)this.context.getPrintTemplatetag())) {
                    List templateList = SerializationUtils.fromJsonStringToList((String)this.context.getPrintTemplatetag(), PrintTemplate.class);
                    HashSet tempIds = new HashSet(this.context.getIds());
                    this.billIdAndPrintIdMap = ArchiveSchemeHelper.getBillIdAndPrintId((List)templateList, (String)this.context.getBillType(), tempIds);
                }
            } else if ("tax".equals(this.context.getArchieveType()) && "bill".equals((String)(rangeMap = (Map)SerializationUtils.fromJsonString((String)this.context.getArchiveRangeReport(), Map.class)).get("taxarchivedata"))) {
                List templateList = SerializationUtils.fromJsonStringToList((String)this.context.getPrintTemplatetag(), PrintTemplate.class);
                HashSet tempIds = new HashSet(this.context.getIds());
                this.billIdAndPrintIdMap = ArchiveSchemeHelper.getBillIdAndPrintId((List)templateList, (String)this.context.getBillType(), tempIds);
            }
        }
        if ("2".equals(this.context.getIsReverse())) {
            this.context.setPageId(DBServiceHelper.genStringId());
        }
        this.flag = LogicUtils.getFlag((String)this.context.getIsReverse());
        this.multarchive = SysParamConfig.getBoolean("multarchive");
        this.isNotNeedUploadFile = "3".equals(this.context.getUploadWay()) && "2".equals(this.context.getIsReverse()) && SysParamConfig.getBoolean("archivetoxinghan");
        this.isNotNeedUploadFile = this.isNotNeedUploadFile || "5".equals(this.context.getUploadWay()) && "2".equals(this.context.getIsReverse());
        this.isNotNeedUploadFile = this.isNotNeedUploadFile || "6".equals(this.context.getUploadWay()) && "2".equals(this.context.getIsReverse());
        this.archiveByFilePath = "5".equals(this.context.getUploadWay()) && SysParamConfig.getBoolean("archivebyfilepath");
    }

    public void doAction(ArchiveContext ctx) throws Exception {
        this.context = ctx;
        this.initAbstractArchiveLogicUnit();
        this.context.setCurUnit(this.getClass().getName());
        this.execute();
    }

    private void execute() throws Exception {
        this.initDocumentServerHandler(this.context);
        Object prepareData = this.prePareDataObject();
        this.handleRowData(prepareData);
        this.getDocumentServerHandler().handleBatchUpload();
        this.saveArchiveRecords(this.context);
        this.afterSaveArchiveRecords(this.context);
    }

    protected IDocumentServerHandler getDocumentServerHandler() {
        return this.documentServerHandler;
    }

    public ContextData getContextData() {
        return this.contextData;
    }

    private void initDocumentServerHandler(ArchiveContext context) throws Exception {
        this.documentServerHandler = LogicUtils.getDocumentServerByUploadWay((String)context.getUploadWay());
        this.documentServerHandler.initServer();
    }

    private void handleRowData(Object prepareData) {
        block3: {
            RowResult result;
            block2: {
                result = null;
                if (!(prepareData instanceof List)) break block2;
                List list = (List)prepareData;
                for (int i = 0; i < list.size(); ++i) {
                    result = this.handleEachRowForList(list.get(i));
                    this.handleEachRowResult(result);
                }
                break block3;
            }
            if (!(prepareData instanceof Map)) break block3;
            Map map = (Map)prepareData;
            for (Map.Entry entry : map.entrySet()) {
                result = this.handleEachRowForMap(entry.getKey(), entry.getValue());
                this.handleEachRowResult(result);
            }
        }
    }

    private void handleEachRowResult(RowResult result) {
        List<Attach> list;
        if (!result.isNeedHandle()) {
            return;
        }
        if (this.documentServerHandler.isneedattachfile(this.context.getIsArchieveAttach()) && "1".equals(this.context.getIsReverse()) && (list = this.getAttachments(result, this.context)) != null && list.size() > 0) {
            this.uploadAttachments(result, list, this.context);
        }
        if (result.getArchiveObject() != null) {
            this.contextData.getArchiveObjects().add(result.getArchiveObject());
        }
    }

    protected void afterSaveArchiveRecords(ArchiveContext context) {
    }

    protected void beforeSaveArchiveRecords(ArchiveContext context) {
    }

    public Result uploadFile(FileUploadItem fileUploadItem, String billName, String className, boolean isXmlFile) {
        Result result;
        if ("2".equals(this.context.getIsReverse()) && this.isNotNeedUploadFile && isXmlFile) {
            return this.reverse(fileUploadItem, billName, className);
        }
        if (isXmlFile) {
            fileUploadItem.setFilePath(null);
        }
        if ((result = this.documentServerHandler.uploadFile(fileUploadItem)) != null && !result.isSucceed()) {
            logger.error(String.format("[uploadFile][%s]%s AbstractArchiveLogicUnit uploadFile fail:%s", className, billName, result.getErrorMessage()));
            throw new KDBizException(new ErrorCode(result.getErrorCcode(), result.getErrorMessage()), new Object[0]);
        }
        if (result != null && result.isSucceed() && StringUtils.isNotEmpty((CharSequence)result.getUrl()) && this.getDocumentServerHandler().isNeedSaveArchivePathRecords()) {
            DynamicObject path = SaveArchiveUtils.getBillPathDynamicObject((String)result.getUrl(), (String)this.context.getBillType(), (int)1, (Object)fileUploadItem.getBillId(), (Long)this.userId, (String)fileUploadItem.getFileName(), (Date)new Date());
            this.contextData.addFilePath(path);
        }
        return result;
    }

    protected void afterHanle(ArchiveContext context) {
    }

    protected void saveArchiveRecords(ArchiveContext context) {
    }

    protected void uploadAttachments(RowResult result, List<Attach> attaches, ArchiveContext context) {
        try {
            if (attaches != null) {
                for (Attach attach : attaches) {
                    String url = attach.getUrl();
                    if (!attach.isInternalFile()) continue;
                    this.fileUploadItem.setFileName(result.getCurrenKey().toString() + "_" + attach.getFileName());
                    String billtype = context.getBillType();
                    this.fileUploadItem.setBusinessType("gl_voucher".equals(billtype) ? 2 : BusinessTypeUtils.getBusinessType(context.getBillType(), true));
                    this.fileUploadItem.setBatchCode(context.getBatchcode());
                    this.setAttachmentsRelatedInfo(this.fileUploadItem, url, null);
                    this.uploadFile(this.fileUploadItem, this.billName, this.getClass().getName(), Boolean.FALSE);
                }
            }
        }
        catch (IOException e) {
            logger.error(String.format("IOException%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"IOException%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", (String)"ArchiveCommonBillByFpyLogicUnit_5", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
    }

    protected abstract List<Attach> getAttachments(RowResult var1, ArchiveContext var2);

    protected abstract RowResult handleEachRowForMap(Object var1, Object var2);

    protected abstract RowResult handleEachRowForList(Object var1);

    private Object prePareDataObject() {
        Object returnObj = null;
        List<?> list = this.prepareListData();
        if (list == null || list.isEmpty()) {
            Map<String, ?> map = this.prePareMapData();
            if (map != null && !map.isEmpty()) {
                returnObj = map;
            }
        } else {
            returnObj = list;
        }
        return returnObj;
    }

    protected abstract Map<String, ?> prePareMapData();

    protected abstract List<?> prepareListData();

    protected void saveFilePath() {
        if (!this.contextData.getAllFilePaths().isEmpty() && this.getDocumentServerHandler().isNeedSaveArchivePathRecords()) {
            SaveServiceHelper.save((DynamicObject[])this.contextData.getAllFilePaths().toArray(new DynamicObject[0]));
        }
    }

    protected void noticeArchive(FileUploadItem fileUploadItem) {
        if ("2".equals(this.context.getIsReverse()) && this.isNotNeedUploadFile) {
            return;
        }
        Result result = this.getDocumentServerHandler().sendNotice(fileUploadItem);
        if (result != null && !result.isSucceed()) {
            throw new KDBizException(result.getErrorMessage());
        }
    }

    protected Result reverse(FileUploadItem fileUploadItem, String billName, String className) {
        if (fileUploadItem == null || fileUploadItem.getBillidsMap() == null || fileUploadItem.getBillidsMap().size() == 0) {
            Result returnResult = new Result();
            returnResult.setSucceed(true);
            return returnResult;
        }
        Result result = this.getDocumentServerHandler().reverse(fileUploadItem);
        if (result != null && !result.isSucceed()) {
            Map billidsMap = fileUploadItem.getBillidsMap();
            Map<String, String> idsMap = billidsMap.keySet().stream().collect(Collectors.toMap(key -> key.split("\\.")[1], key -> key.split("\\.")[0]));
            ArrayList errorMapList = new ArrayList(billidsMap.size());
            if (result.getData() != null && result.getData() instanceof List) {
                List data = (List)result.getData();
                for (Map row : data) {
                    String key2 = (String)row.get("billid");
                    String value = (String)row.get("message");
                    if (!idsMap.containsKey(key2)) continue;
                    logger.error(String.format("[reverse][%s]%s AbstractArchiveLogicUnit reverse fail:%s-%s", className, billName, key2, value));
                    HashMap<String, String> errorMap = new HashMap<String, String>(2);
                    errorMap.put("errorId", idsMap.get(key2));
                    errorMap.put("errorMessage", String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s", (String)"AbstractArchiveLogicUnit_17", (String)"fi-aef-common", (Object[])new Object[0]), billidsMap.get(idsMap.get(key2) + "." + key2), value));
                    errorMapList.add(errorMap);
                }
            } else {
                for (Map.Entry entry : billidsMap.entrySet()) {
                    HashMap<String, String> errorMap = new HashMap<String, String>(2);
                    errorMap.put("errorId", idsMap.get(((String)entry.getKey()).split("\\.")[1]));
                    errorMap.put("errorMessage", String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s", (String)"AbstractArchiveLogicUnit_17", (String)"fi-aef-common", (Object[])new Object[0]), entry.getValue(), result.getErrorMessage()));
                    errorMapList.add(errorMap);
                }
            }
            logger.error(String.format("[reverse][%s]%s AbstractArchiveLogicUnit reverse fail:%s-%s", className, billName, result.getErrorCcode(), result.getErrorMessage()));
            throw new KDBizException(new ErrorCode(result.getErrorCcode(), result.getErrorMessage()), errorMapList.toArray(new Object[0]));
        }
        return result;
    }

    public void setAttachmentsRelatedInfo(FileUploadItem fileUploadItem, String url, FileDesc fileDesc) throws IOException {
        byte[] fileData;
        if (StringUtils.isEmpty((CharSequence)url)) {
            return;
        }
        fileUploadItem.setFilePath(url);
        if (!this.archiveByFilePath && (fileData = FileUtils.downLoadHttpsFile(url)).length > 0) {
            String md5 = FpyOperateUtil.fileMD5(fileData);
            fileUploadItem.setFilebase64(LogicUtils.toBase64((byte[])fileData));
            fileUploadItem.setFileMD5(md5);
            fileUploadItem.setFileBytes(fileData);
            fileUploadItem.setFilePath(null);
            if (fileDesc != null) {
                fileDesc.setFilesize(Integer.valueOf(fileData.length));
                fileDesc.setMd5(md5);
            }
        }
    }

    public FileUploadItem buildPrintFileUploadItem(String archivesCode, String accountBookNo, String accountBookName, String period, String batchNumber, int businessType, String fileName, String url, FileDesc fileDesc, String institutionIssuesNo, String institutionIssuesName) throws IOException {
        FileUploadItem fileUploadItem = new FileUploadItem(archivesCode, accountBookNo, accountBookName, period, batchNumber, businessType, fileName, null, institutionIssuesNo, institutionIssuesName);
        this.setPrintFileRelatedInfo(fileUploadItem, url, fileDesc);
        return fileUploadItem;
    }

    public FileUploadItem buildPrintFileUploadItem(String archivesCode, String accountBookNo, String accountBookName, String period, String batchNumber, int businessType, String fileName, String url, FileDesc fileDesc) throws IOException {
        FileUploadItem fileUploadItem = new FileUploadItem(archivesCode, accountBookNo, accountBookName, period, batchNumber, businessType, fileName, null);
        this.setPrintFileRelatedInfo(fileUploadItem, url, fileDesc);
        return fileUploadItem;
    }

    public void setPrintFileRelatedInfo(FileUploadItem fileUploadItem, String url, FileDesc fileDesc) throws IOException {
        byte[] pdfData;
        if (StringUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (url.startsWith("configKey=")) {
            url = "tempfile/download.do?" + url;
        }
        fileUploadItem.setFilePath(url);
        if (!this.archiveByFilePath && (pdfData = FileUtils.downLoadFileFromUrl(url)).length > 0) {
            String md5 = FpyOperateUtil.fileMD5(pdfData);
            fileUploadItem.setFileMD5(md5);
            fileUploadItem.setFileBytes(pdfData);
            fileUploadItem.setFilebase64(LogicUtils.toBase64((byte[])pdfData));
            fileUploadItem.setFilePath(null);
            if (fileDesc != null) {
                fileDesc.setFilesize(Integer.valueOf(pdfData.length));
                fileDesc.setMd5(md5);
            }
        }
    }

    public void setAnyFileRelatedInfo(FileUploadItem fileUploadItem, String url) throws IOException {
        byte[] pdfData;
        if (StringUtils.isEmpty((CharSequence)url)) {
            return;
        }
        fileUploadItem.setFilePath(url);
        if (!this.archiveByFilePath && (pdfData = FileUtils.downLoadAnyUrl(url)).length > 0) {
            fileUploadItem.setFileMD5(FpyOperateUtil.fileMD5(pdfData));
            fileUploadItem.setFileBytes(pdfData);
            fileUploadItem.setFilebase64(LogicUtils.toBase64((byte[])pdfData));
            fileUploadItem.setFilePath(null);
        }
    }

    protected void setTempFileRelatedInfo(FileUploadItem fileUploadItem, String url, FileDesc fileDesc) throws IOException {
        byte[] pdfData;
        if (StringUtils.isEmpty((CharSequence)url)) {
            return;
        }
        fileUploadItem.setFilePath(url);
        if (!this.archiveByFilePath && (pdfData = FileUtils.downLoadFileFromUrl(url)).length > 0) {
            String md5 = FpyOperateUtil.fileMD5(pdfData);
            fileUploadItem.setFileMD5(md5);
            fileUploadItem.setFileBytes(pdfData);
            fileUploadItem.setFilebase64(LogicUtils.toBase64((byte[])pdfData));
            fileUploadItem.setFilePath(null);
            if (fileDesc != null) {
                fileDesc.setMd5(md5);
                fileDesc.setFilesize(Integer.valueOf(pdfData.length));
            }
        }
    }
}

