/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.ArchiveUtil;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.ElecreceiptUtils;
import kd.fi.aef.common.util.JDomB9Utils;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.entity.BillInfo;
import kd.fi.aef.entity.FileDesc;
import kd.fi.aef.logic.model.Attach;
import kd.fi.aef.logic.model.Bill;
import kd.sdk.fi.gl.voucher.VoucherQuerySDK;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;

public class FPYXmlUtils {
    private static final Log logger = LogFactory.getLog(FPYXmlUtils.class);

    public static String createCommonBillXml(ArchiveContext context, List<Bill> list, Map<Object, FileDesc> billFileMap, String billName, Map<?, List<Attach>> attachMap, Map<String, Object> imageMap, String billType, String flag, Set<?> fillingIds) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName((Element)docinfo, (String)"header");
        JDomB9Utils.addChildAndName((Element)header, (String)"doctype", (String)"srcVoucher");
        JDomB9Utils.addChildAndName((Element)header, (String)"creater", (String)FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName((Element)header, (String)"time", (String)FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName((Element)header, (String)"rearchflag", (String)flag);
        JDomB9Utils.addChildAndName((Element)header, (String)"desc", (String)billName);
        Element datalist = JDomB9Utils.addChildAndName((Element)docinfo, (String)"data-list");
        int i = 0;
        String invoiceStr = SysParamConfig.get("hasinvoicebill");
        List<Object> sysList = new ArrayList(3);
        if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceStr)) {
            sysList = Arrays.asList(invoiceStr.split(","));
        }
        String idField = ArchiveUtil.getFieldName(billType, "id");
        for (Bill bill : list) {
            Map numbermap;
            if (context.getNeedArchiveIds() != null && context.getNeedArchiveIds().size() > 0 && !context.getNeedArchiveIds().contains(bill.getBillId())) continue;
            Element data = JDomB9Utils.addChildAndName((Element)datalist, (String)"data");
            JDomB9Utils.addChildAndName((Element)data, (String)"id", (String)(++i + ""));
            if ("er_tripreimbursebill".equals(billType) || "er_dailyreimbursebill".equals(billType) || "ap_finapbill".equals(billType) || "er_publicreimbursebill".equals(billType) || "ap_invoice".equals(billType) || sysList.contains(billType)) {
                if ("A".equals(imageMap.get("enable"))) {
                    JDomB9Utils.addChildAndName((Element)data, (String)"isFPYBill", (String)"true");
                } else {
                    JDomB9Utils.addChildAndName((Element)data, (String)"isFPYBill", (String)"false");
                }
            }
            if ("ap_finapbill".equals(billType)) {
                JDomB9Utils.addChildAndName((Element)data, (String)"billid", (String)("ap_invoice_" + bill.getBillId()));
            } else {
                JDomB9Utils.addChildAndName((Element)data, (String)"billid", (String)(billType + "_" + bill.getBillId()));
            }
            Map<String, Object> field2ValueMap = bill.getField2ValueMap();
            if (field2ValueMap.size() > 0) {
                field2ValueMap.forEach((xmlFiled, value) -> {
                    if (!xmlFiled.equals(idField)) {
                        JDomB9Utils.addChildAndName((Element)data, (String)xmlFiled, (String)value.toString());
                    }
                });
            }
            JDomB9Utils.addChildAndName((Element)data, (String)"billtype", (String)billName);
            boolean existEntity = fillingIds.contains(bill.getBillId());
            JDomB9Utils.addChildAndName((Element)data, (String)"existEntity", (String)String.valueOf(existEntity));
            Object billId = bill.getBillId();
            Element filelist = JDomB9Utils.addChildAndName((Element)data, (String)"file-list");
            Element file = JDomB9Utils.addChildAndName((Element)filelist, (String)"file");
            String name = billFileMap.get(billId).getName();
            JDomB9Utils.addChildAndName((Element)file, (String)"name", (String)name);
            JDomB9Utils.addChildAndName((Element)file, (String)"srcname", (String)name);
            List<Attach> attaches = attachMap.get(billId);
            if (attaches != null) {
                for (Attach attachfile : attaches) {
                    Element attach = filelist.addElement("file");
                    JDomB9Utils.addChildAndName((Element)attach, (String)"name", (String)(billId + "_" + attachfile.getFileName()));
                    JDomB9Utils.addChildAndName((Element)attach, (String)"srcname", (String)attachfile.getFileName());
                }
            }
            if ((numbermap = (Map)imageMap.get("numbermap")) == null || numbermap.size() <= 0 || numbermap.get(billType) == null || ((Map)numbermap.get(billType)).get(billId) == null || ((List)((Map)numbermap.get(billType)).get(billId)).size() <= 0) continue;
            Element imagesys = JDomB9Utils.addChildAndName((Element)data, (String)"imagesys");
            JDomB9Utils.addChildAndName((Element)imagesys, (String)"imagesystype", (String)(imageMap.get("imagesystype") == null ? "null" : (String)imageMap.get("imagesystype")));
            JDomB9Utils.addChildAndName((Element)imagesys, (String)"imagesysip", (String)(imageMap.get("imagesysip") == null ? "null" : (String)imageMap.get("imagesysip")));
            JDomB9Utils.addChildAndName((Element)imagesys, (String)"imagesysport", (String)(imageMap.get("imagesysport") == null ? "null" : (String)imageMap.get("imagesysport")));
            Element imagelist = JDomB9Utils.addChildAndName((Element)data, (String)"image-list");
            List imagenumbers = (List)((Map)numbermap.get(billType)).get(billId);
            for (String imagenumber : imagenumbers) {
                Element image = JDomB9Utils.addChildAndName((Element)imagelist, (String)"image");
                JDomB9Utils.addChildAndName((Element)image, (String)"imagenumber", (String)imagenumber);
            }
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createTaxBillXml(List<Bill> list, Map<Object, FileDesc> billFileMap, Map<Long, List<Attach>> attachMap, Map<String, Object> extMap) {
        Element attach;
        List<Attach> attaches;
        String name;
        Element file;
        Element filelist;
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName((Element)docinfo, (String)"header");
        JDomB9Utils.addChildAndName((Element)header, (String)"doctype", (String)"taxReport");
        JDomB9Utils.addChildAndName((Element)header, (String)"creater", (String)FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName((Element)header, (String)"time", (String)FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName((Element)header, (String)"rearchflag", (String)((String)extMap.get("flag")));
        JDomB9Utils.addChildAndName((Element)header, (String)"desc", (String)((String)extMap.get("billname")));
        Element datalist = JDomB9Utils.addChildAndName((Element)docinfo, (String)"data-list");
        int i = 0;
        if ("bill".equals(extMap.get("taxarchivedata"))) {
            Set needArchiveIds = (Set)extMap.get("needArchiveIds");
            for (Bill bill : list) {
                if (needArchiveIds != null && needArchiveIds.size() > 0 && !needArchiveIds.contains(bill.getBillId())) continue;
                Element data = JDomB9Utils.addChildAndName((Element)datalist, (String)"data");
                JDomB9Utils.addChildAndName((Element)data, (String)"id", (String)(++i + ""));
                JDomB9Utils.addChildAndName((Element)data, (String)"billid", (String)(extMap.get("billtype") + "_" + bill.getBillId()));
                JDomB9Utils.addChildAndName((Element)data, (String)"period", (String)DateUtil.getShortStr((Date)bill.getDate()));
                JDomB9Utils.addChildAndName((Element)data, (String)"type", (String)((String)extMap.get("billname")));
                JDomB9Utils.addChildAndName((Element)data, (String)"taxcode", (String)"");
                JDomB9Utils.addChildAndName((Element)data, (String)"taxname", (String)"");
                JDomB9Utils.addChildAndName((Element)data, (String)"voucherorgnumber", (String)bill.getOrgNo());
                JDomB9Utils.addChildAndName((Element)data, (String)"voucherorgname", (String)bill.getOrgName());
                JDomB9Utils.addChildAndName((Element)data, (String)"taxnumber", (String)"");
                JDomB9Utils.addChildAndName((Element)data, (String)"taxtimestart", (String)DateUtil.getTimeStr((Date)bill.getDate()));
                JDomB9Utils.addChildAndName((Element)data, (String)"taxtimeend", (String)DateUtil.getTimeStr((Date)bill.getDate()));
                JDomB9Utils.addChildAndName((Element)data, (String)"groupname", (String)((String)extMap.get("groupname")));
                Long billId = (Long)bill.getBillId();
                filelist = JDomB9Utils.addChildAndName((Element)data, (String)"file-list");
                file = JDomB9Utils.addChildAndName((Element)filelist, (String)"file");
                name = billFileMap.get(billId).getName();
                JDomB9Utils.addChildAndName((Element)file, (String)"name", (String)name);
                JDomB9Utils.addChildAndName((Element)file, (String)"srcname", (String)name);
                attaches = attachMap.get(billId);
                if (attaches == null) continue;
                for (Attach attachfile : attaches) {
                    attach = filelist.addElement("file");
                    JDomB9Utils.addChildAndName((Element)attach, (String)"name", (String)(billId + "_" + attachfile.getFileName()));
                    JDomB9Utils.addChildAndName((Element)attach, (String)"srcname", (String)attachfile.getFileName());
                }
            }
        }
        if ("tccit".equals((String)extMap.get("taxarchivedata"))) {
            List declareList = (List)extMap.get("declareList");
            for (Map map : declareList) {
                Long billId = (Long)map.get("id");
                Element data = JDomB9Utils.addChildAndName((Element)datalist, (String)"data");
                JDomB9Utils.addChildAndName((Element)data, (String)"id", (String)(++i + ""));
                JDomB9Utils.addChildAndName((Element)data, (String)"billid", (String)(extMap.get("billtype") + "_" + billId));
                JDomB9Utils.addChildAndName((Element)data, (String)"period", (String)((String)map.get("period")));
                JDomB9Utils.addChildAndName((Element)data, (String)"type", (String)((String)extMap.get("billname")));
                JDomB9Utils.addChildAndName((Element)data, (String)"taxcode", (String)((String)map.get("taxcode")));
                JDomB9Utils.addChildAndName((Element)data, (String)"taxname", (String)((String)map.get("taxname")));
                JDomB9Utils.addChildAndName((Element)data, (String)"voucherorgname", (String)((String)map.get("taxpayername")));
                JDomB9Utils.addChildAndName((Element)data, (String)"voucherorgnumber", (String)((String)map.get("taxnumber")));
                JDomB9Utils.addChildAndName((Element)data, (String)"taxnumber", (String)((String)map.get("taxnumber")));
                JDomB9Utils.addChildAndName((Element)data, (String)"taxtimestart", (String)((String)map.get("startdate")));
                JDomB9Utils.addChildAndName((Element)data, (String)"taxtimeend", (String)((String)map.get("enddate")));
                JDomB9Utils.addChildAndName((Element)data, (String)"groupname", (String)((String)extMap.get("groupname")));
                filelist = JDomB9Utils.addChildAndName((Element)data, (String)"file-list");
                file = JDomB9Utils.addChildAndName((Element)filelist, (String)"file");
                name = billFileMap.get(billId).getName();
                JDomB9Utils.addChildAndName((Element)file, (String)"name", (String)name);
                JDomB9Utils.addChildAndName((Element)file, (String)"srcname", (String)name);
                attaches = attachMap.get(billId);
                if (attaches == null) continue;
                for (Attach attachfile : attaches) {
                    attach = filelist.addElement("file");
                    JDomB9Utils.addChildAndName((Element)attach, (String)"name", (String)(billId + "_" + attachfile.getFileName()));
                    JDomB9Utils.addChildAndName((Element)attach, (String)"srcname", (String)attachfile.getFileName());
                }
            }
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createBatchVoucherXml(String xmlDesc, List<Bill> billList, Map<Long, List<Attach>> attachMap, Map<Long, Map<String, Set<Long>>> linkUpBills, Map<Object, FileDesc> voucherFileMap, Set<String> refBillTypes, String flag, Map<Long, Set<String>> voucherInvoiceMap) {
        return FPYXmlUtils.createBatchVoucherXml(xmlDesc, billList, attachMap, linkUpBills, voucherFileMap, refBillTypes, flag, voucherInvoiceMap, new HashMap<Long, JSONArray>());
    }

    public static String createBatchVoucherXml(String xmlDesc, List<Bill> billList, Map<Long, List<Attach>> attachMap, Map<Long, Map<String, Set<Long>>> linkUpBills, Map<Object, FileDesc> voucherFileMap, Set<String> refBillTypes, String flag, Map<Long, Set<String>> voucherInvoiceMap, HashMap<Long, JSONArray> extInvoiceMap) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName((Element)docinfo, (String)"header");
        JDomB9Utils.addChildAndName((Element)header, (String)"doctype", (String)"voucher");
        JDomB9Utils.addChildAndName((Element)header, (String)"creater", (String)FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName((Element)header, (String)"time", (String)FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName((Element)header, (String)"rearchflag", (String)flag);
        JDomB9Utils.addChildAndName((Element)header, (String)"desc", (String)xmlDesc);
        HashMap<Long, List> entryMap = new HashMap<Long, List>(16);
        if (SysParamConfig.getBoolean("archiveentry", false)) {
            try (DataSet dataSet = VoucherQuerySDK.queryByIds(billList.stream().map(bill -> Long.parseLong(bill.getBillId().toString())).collect(Collectors.toSet()), null, (String)"id, entries.account.number accountcode,entries.account.name accountname, entries.edescription desc, entries.debitlocal dr, entries.creditlocal cr, entries.assgrp.display accountdimensions", null);){
                for (Row row : dataSet) {
                    List eneityList = entryMap.computeIfAbsent(row.getLong("id"), value -> new ArrayList());
                    LinkedHashMap<String, String> eneityMap = new LinkedHashMap<String, String>(16);
                    eneityMap.put("accountcode", row.getString("accountcode"));
                    eneityMap.put("accountname", row.getString("accountname"));
                    eneityMap.put("desc", row.getString("desc"));
                    eneityMap.put("accountdimensions", row.getString("accountdimensions"));
                    eneityMap.put("dr", row.getString("dr"));
                    eneityMap.put("cr", row.getString("cr"));
                    eneityList.add(eneityMap);
                }
            }
        }
        Element datalist = JDomB9Utils.addChildAndName((Element)docinfo, (String)"data-list");
        int i = 0;
        for (Bill bill2 : billList) {
            ++i;
            Long id = (Long)bill2.getBillId();
            Map<String, Set<Long>> refBillMap = linkUpBills.get(id);
            List<Attach> attaches = attachMap.get(id);
            Element data = JDomB9Utils.addChildAndName((Element)datalist, (String)"data");
            Map<String, Object> field2ValueMap = bill2.getField2ValueMap();
            JDomB9Utils.addChildAndName((Element)data, (String)"id", (String)(i + ""));
            for (Map.Entry<String, Object> entry : field2ValueMap.entrySet()) {
                String field = entry.getKey();
                Object value2 = entry.getValue();
                JDomB9Utils.addChildAndName((Element)data, (String)field, (String)(Objects.isNull(value2) ? "" : value2.toString()));
            }
            Element jelinelist = JDomB9Utils.addChildAndName((Element)data, (String)"jeline-list");
            if (entryMap.get(id) != null && ((List)entryMap.get(id)).size() > 0) {
                List list = (List)entryMap.get(id);
                for (Map map : list) {
                    Element jeline = JDomB9Utils.addChildAndName((Element)jelinelist, (String)"jeline");
                    JDomB9Utils.addChildAndName((Element)jeline, (String)"accountcode", (String)((String)map.get("accountcode")));
                    JDomB9Utils.addChildAndName((Element)jeline, (String)"accountname", (String)((String)map.get("accountname")));
                    JDomB9Utils.addChildAndName((Element)jeline, (String)"desc", (String)((String)map.get("desc")));
                    JDomB9Utils.addChildAndName((Element)jeline, (String)"accountdimensions", (String)((String)map.get("accountdimensions")));
                    JDomB9Utils.addChildAndName((Element)jeline, (String)"costcenter");
                    JDomB9Utils.addChildAndName((Element)jeline, (String)"dr", (String)((String)map.get("dr")));
                    JDomB9Utils.addChildAndName((Element)jeline, (String)"cr", (String)((String)map.get("cr")));
                }
            } else {
                Element jeline = JDomB9Utils.addChildAndName((Element)jelinelist, (String)"jeline");
                JDomB9Utils.addChildAndName((Element)jeline, (String)"accountcode");
                JDomB9Utils.addChildAndName((Element)jeline, (String)"accountname");
                JDomB9Utils.addChildAndName((Element)jeline, (String)"desc", (String)bill2.getDesc());
                JDomB9Utils.addChildAndName((Element)jeline, (String)"costcenter");
                JDomB9Utils.addChildAndName((Element)jeline, (String)"dr");
                JDomB9Utils.addChildAndName((Element)jeline, (String)"cr");
            }
            Element refbilllist = JDomB9Utils.addChildAndName((Element)data, (String)"refbill-list");
            JDomB9Utils.addChildAndNameForRefbills((Element)refbilllist, (String)"refbill", refBillMap, refBillTypes);
            Element filelist = JDomB9Utils.addChildAndName((Element)data, (String)"file-list");
            String fileName = voucherFileMap.get(id).getName();
            FPYXmlUtils.addFiles(filelist, "file", attaches, id.toString(), fileName);
            if (voucherInvoiceMap != null && voucherInvoiceMap.size() > 0 && voucherInvoiceMap.get(id) != null && voucherInvoiceMap.get(id).size() > 0) {
                Element invoicesys = JDomB9Utils.addChildAndName((Element)data, (String)"invoicesys");
                JDomB9Utils.addChildAndName((Element)invoicesys, (String)"invoicesystype", (String)"FPY");
                JDomB9Utils.addChildAndName((Element)invoicesys, (String)"invoicesysip");
                JDomB9Utils.addChildAndName((Element)invoicesys, (String)"invoicesysport");
                Element invoicelist = JDomB9Utils.addChildAndName((Element)data, (String)"invoice-list");
                for (String seqNo : voucherInvoiceMap.get(id)) {
                    Element invoice = invoicelist.addElement("invoice");
                    JDomB9Utils.addChildAndName((Element)invoice, (String)"serialNo", (String)seqNo);
                    JDomB9Utils.addChildAndName((Element)invoice, (String)"invoiceno");
                    JDomB9Utils.addChildAndName((Element)invoice, (String)"invoicecode");
                    JDomB9Utils.addChildAndName((Element)invoice, (String)"downloadurl");
                }
            }
            if (extInvoiceMap.size() <= 0) continue;
            Element invoicelist = JDomB9Utils.addChildAndName((Element)data, (String)"invoice-list");
            if (extInvoiceMap.get(id) == null || extInvoiceMap.get(id).size() <= 0) continue;
            JSONArray array = extInvoiceMap.get(id);
            for (Object object : array) {
                JSONObject json = (JSONObject)object;
                Element invoice = invoicelist.addElement("invoice");
                for (Map.Entry entry : json.entrySet()) {
                    String fieldKey = (String)entry.getKey();
                    String fieldVal = entry.getValue().toString();
                    JDomB9Utils.addChildAndName((Element)invoice, (String)fieldKey, (String)fieldVal);
                }
            }
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createBatchVoucherXml(String xmlDesc, DataSet xmlSet, Map<Long, List<Attach>> attachMap, Map<Long, Map<String, Set<Long>>> linkUpBills, Map<Object, FileDesc> voucherFileMap, Set<String> refBillTypes, String flag, Map<Long, Set<String>> voucherInvoiceMap) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName((Element)docinfo, (String)"header");
        JDomB9Utils.addChildAndName((Element)header, (String)"doctype", (String)"voucher");
        JDomB9Utils.addChildAndName((Element)header, (String)"creater", (String)FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName((Element)header, (String)"time", (String)FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName((Element)header, (String)"rearchflag", (String)flag);
        JDomB9Utils.addChildAndName((Element)header, (String)"desc", (String)xmlDesc);
        Element datalist = JDomB9Utils.addChildAndName((Element)docinfo, (String)"data-list");
        int i = 0;
        for (Row row : xmlSet) {
            Long id = row.getLong("id");
            Map<String, Set<Long>> refBillMap = linkUpBills.get(id);
            List<Attach> attaches = attachMap.get(id);
            Element data = JDomB9Utils.addChildAndName((Element)datalist, (String)"data");
            JDomB9Utils.addChildAndName((Element)data, (String)"id", (String)(++i + ""));
            JDomB9Utils.addChildAndName((Element)data, (String)"billid", (String)("gl_voucher" + id.toString()));
            JDomB9Utils.addChildAndName((Element)data, (String)"voucherorgnumber", (String)row.getString("orgnumber"));
            JDomB9Utils.addChildAndName((Element)data, (String)"voucherorgname", (String)row.getString("orgname"));
            JDomB9Utils.addChildAndName((Element)data, (String)"period", (String)FPYXmlUtils.dealPeriodNumber(row.getString("periodnumber")));
            JDomB9Utils.addChildAndName((Element)data, (String)"vouchernum", (String)row.getString("billno"));
            JDomB9Utils.addChildAndName((Element)data, (String)"attachnum", (String)row.getString("attachment"));
            JDomB9Utils.addChildAndName((Element)data, (String)"vouchertype", (String)row.getString("vouchertypename"));
            JDomB9Utils.addChildAndName((Element)data, (String)"currency", (String)row.getString("localcurnumber"));
            JDomB9Utils.addChildAndName((Element)data, (String)"totaldebitloc", (String)row.getString("debitlocamount"));
            JDomB9Utils.addChildAndName((Element)data, (String)"totalcreditloc", (String)row.getString("creditlocamount"));
            JDomB9Utils.addChildAndName((Element)data, (String)"auditing", (String)row.getString("auditorname"));
            JDomB9Utils.addChildAndName((Element)data, (String)"creater", (String)row.getString("creatorname"));
            JDomB9Utils.addChildAndName((Element)data, (String)"accountdate", (String)(row.getDate("accountdate") == null ? "" : DateUtil.getTimeStr((Date)row.getDate("accountdate"))));
            JDomB9Utils.addChildAndName((Element)data, (String)"posting_date", (String)(row.getDate("posting_date") == null ? "" : DateUtil.getTimeStr((Date)row.getDate("posting_date"))));
            Element jelinelist = JDomB9Utils.addChildAndName((Element)data, (String)"jeline-list");
            Element jeline = JDomB9Utils.addChildAndName((Element)jelinelist, (String)"jeline");
            JDomB9Utils.addChildAndName((Element)jeline, (String)"accountcode");
            JDomB9Utils.addChildAndName((Element)jeline, (String)"accountname");
            JDomB9Utils.addChildAndName((Element)jeline, (String)"desc", (String)row.getString("vdescription"));
            JDomB9Utils.addChildAndName((Element)jeline, (String)"costcenter");
            JDomB9Utils.addChildAndName((Element)jeline, (String)"dr");
            JDomB9Utils.addChildAndName((Element)jeline, (String)"cr");
            Element refbilllist = JDomB9Utils.addChildAndName((Element)data, (String)"refbill-list");
            JDomB9Utils.addChildAndNameForRefbills((Element)refbilllist, (String)"refbill", refBillMap, refBillTypes);
            Element filelist = JDomB9Utils.addChildAndName((Element)data, (String)"file-list");
            String fileName = voucherFileMap.get(id).getName();
            FPYXmlUtils.addFiles(filelist, "file", attaches, id.toString(), fileName);
            if (voucherInvoiceMap == null || voucherInvoiceMap.size() <= 0 || voucherInvoiceMap.get(id) == null || voucherInvoiceMap.get(id).size() <= 0) continue;
            Element invoicesys = JDomB9Utils.addChildAndName((Element)data, (String)"invoicesys");
            JDomB9Utils.addChildAndName((Element)invoicesys, (String)"invoicesystype", (String)"FPY");
            JDomB9Utils.addChildAndName((Element)invoicesys, (String)"invoicesysip");
            JDomB9Utils.addChildAndName((Element)invoicesys, (String)"invoicesysport");
            Element invoicelist = JDomB9Utils.addChildAndName((Element)data, (String)"invoice-list");
            for (String seqNo : voucherInvoiceMap.get(id)) {
                Element invoice = invoicelist.addElement("invoice");
                JDomB9Utils.addChildAndName((Element)invoice, (String)"serialNo", (String)seqNo);
                JDomB9Utils.addChildAndName((Element)invoice, (String)"invoiceno");
                JDomB9Utils.addChildAndName((Element)invoice, (String)"invoicecode");
                JDomB9Utils.addChildAndName((Element)invoice, (String)"downloadurl");
            }
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createVoucherRefBillXml(Map<String, List<BillInfo>> linkUpBillInfos, Map<String, Map<Long, Set<Long>>> billAndRefvoucherIds, Map<Long, List<Attach>> refAttachMap, Map<String, Object> imageMap, String accountBookNo, String accountBookName, String period, String flag, Map<String, Set<Object>> errRefBills, Map<Long, BillInfo> voucherInfoMap) {
        HashMap<String, String> billTypeAndNameMap = new HashMap<String, String>();
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName((Element)docinfo, (String)"header");
        JDomB9Utils.addChildAndName((Element)header, (String)"doctype", (String)"srcVoucher");
        JDomB9Utils.addChildAndName((Element)header, (String)"creater", (String)FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName((Element)header, (String)"time", (String)FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName((Element)header, (String)"rearchflag", (String)flag);
        JDomB9Utils.addChildAndName((Element)header, (String)"desc");
        Element datalist = JDomB9Utils.addChildAndName((Element)docinfo, (String)"data-list");
        int i = 0;
        String invoiceStr = SysParamConfig.get("hasinvoicebill");
        List<Object> sysList = new ArrayList(3);
        if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceStr)) {
            sysList = Arrays.asList(invoiceStr.split(","));
        }
        for (Map.Entry<String, List<BillInfo>> linkUpBillInfo : linkUpBillInfos.entrySet()) {
            String billType = linkUpBillInfo.getKey();
            String idField = ArchiveUtil.getFieldName(billType, "id");
            DynamicObjectCollection fileds = ArchiveUtil.getXmlfileds(billType);
            if (!billTypeAndNameMap.containsKey(billType)) {
                String billTypeName = EntityMetadataCache.getDataEntityType((String)billType).getDisplayName().toString();
                billTypeAndNameMap.put(billType, billTypeName);
            }
            List<BillInfo> list = linkUpBillInfo.getValue();
            for (BillInfo billInfo : list) {
                Map numbermap;
                List<Attach> attaches;
                ++i;
                if (errRefBills != null && errRefBills.get(billType) != null && errRefBills.get(billType).size() > 0 && errRefBills.get(billType).contains(billInfo.getBillId())) continue;
                Element data = JDomB9Utils.addChildAndName((Element)datalist, (String)"data");
                JDomB9Utils.addChildAndName((Element)data, (String)"id", (String)(i + ""));
                if ("er_tripreimbursebill".equals(billType) || "er_dailyreimbursebill".equals(billType) || "ap_finapbill".equals(billType) || "er_publicreimbursebill".equals(billType) || "ap_invoice".equals(billType) || sysList.contains(billType)) {
                    if ("A".equals(imageMap.get("enable"))) {
                        JDomB9Utils.addChildAndName((Element)data, (String)"isFPYBill", (String)"true");
                    } else {
                        JDomB9Utils.addChildAndName((Element)data, (String)"isFPYBill", (String)"false");
                    }
                }
                if ("ap_finapbill".equals(billType)) {
                    JDomB9Utils.addChildAndName((Element)data, (String)"billid", (String)("ap_invoice_" + billInfo.getBillId().toString()));
                } else {
                    JDomB9Utils.addChildAndName((Element)data, (String)"billid", (String)(billType + "_" + billInfo.getBillId().toString()));
                }
                if (fileds.size() > 0) {
                    Map fieldMap = billInfo.getFieldMap();
                    for (DynamicObject filed : fileds) {
                        String xmlfiled = filed.getString("xmlfiled");
                        if (xmlfiled.equals(idField)) continue;
                        JDomB9Utils.addChildAndName((Element)data, (String)filed.getString("xmlfiled"), (String)((String)fieldMap.get(filed.getString("xmlfiled"))));
                    }
                } else {
                    JDomB9Utils.addChildAndName((Element)data, (String)"billcode", (String)billInfo.getBillNo());
                    JDomB9Utils.addChildAndName((Element)data, (String)"voucherorgnumber", (String)accountBookNo);
                    JDomB9Utils.addChildAndName((Element)data, (String)"voucherorgname", (String)accountBookName);
                }
                JDomB9Utils.addChildAndName((Element)data, (String)"billtype", (String)((String)billTypeAndNameMap.get(billType)));
                JDomB9Utils.addChildAndName((Element)data, (String)"period", (String)FPYXmlUtils.dealPeriodNumber(period));
                Element refbilllist = JDomB9Utils.addChildAndName((Element)data, (String)"refbill-list");
                Long billId = Long.valueOf(billInfo.getBillId().toString());
                if (billAndRefvoucherIds.get(billType) == null) continue;
                Set<Long> ids = billAndRefvoucherIds.get(billType).get(billId);
                if (ids != null && !ids.isEmpty()) {
                    JDomB9Utils.addChildAndNameForRefbills((Element)refbilllist, (String)"refbill", ids, voucherInfoMap);
                }
                Element filelist = JDomB9Utils.addChildAndName((Element)data, (String)"file-list");
                Element file = JDomB9Utils.addChildAndName((Element)filelist, (String)"file");
                String name = billType + "_" + billInfo.getBillId().toString() + ".pdf";
                JDomB9Utils.addChildAndName((Element)file, (String)"name", (String)name);
                JDomB9Utils.addChildAndName((Element)file, (String)"srcname", (String)name);
                if (refAttachMap != null && refAttachMap.size() > 0 && (attaches = refAttachMap.get(billId)) != null) {
                    for (Attach attachfile : attaches) {
                        Element attach = filelist.addElement("file");
                        JDomB9Utils.addChildAndName((Element)attach, (String)"name", (String)(billId + "_" + attachfile.getFileName()));
                        JDomB9Utils.addChildAndName((Element)attach, (String)"srcname", (String)attachfile.getFileName());
                    }
                }
                if ((numbermap = (Map)imageMap.get("numbermap")) == null || numbermap.size() <= 0 || numbermap.get(billType) == null || ((Map)numbermap.get(billType)).get(billId) == null || ((List)((Map)numbermap.get(billType)).get(billId)).size() <= 0) continue;
                Element imagesys = JDomB9Utils.addChildAndName((Element)data, (String)"imagesys");
                JDomB9Utils.addChildAndName((Element)imagesys, (String)"imagesystype", (String)(imageMap.get("imagesystype") == null ? "null" : (String)imageMap.get("imagesystype")));
                JDomB9Utils.addChildAndName((Element)imagesys, (String)"imagesysip", (String)(imageMap.get("imagesysip") == null ? "null" : (String)imageMap.get("imagesysip")));
                JDomB9Utils.addChildAndName((Element)imagesys, (String)"imagesysport", (String)(imageMap.get("imagesysport") == null ? "null" : (String)imageMap.get("imagesysport")));
                Element imagelist = JDomB9Utils.addChildAndName((Element)data, (String)"image-list");
                List imagenumbers = (List)((Map)numbermap.get(billType)).get(billId);
                for (String imagenumber : imagenumbers) {
                    Element image = JDomB9Utils.addChildAndName((Element)imagelist, (String)"image");
                    JDomB9Utils.addChildAndName((Element)image, (String)"imagenumber", (String)imagenumber);
                }
            }
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createCasRptXml(String desc, List<Map<String, String>> xmlList, String flag) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName((Element)docinfo, (String)"header");
        JDomB9Utils.addChildAndName((Element)header, (String)"doctype", (String)"voucher");
        JDomB9Utils.addChildAndName((Element)header, (String)"creater", (String)FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName((Element)header, (String)"time", (String)FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName((Element)header, (String)"rearchflag", (String)flag);
        JDomB9Utils.addChildAndName((Element)header, (String)"desc", (String)desc);
        Element datalist = JDomB9Utils.addChildAndName((Element)docinfo, (String)"data-list");
        JDomB9Utils.addData((Element)datalist, xmlList, (boolean)Boolean.TRUE);
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createGeneralledgerXml(String desc, List<Map<String, String>> xmlList, String flag) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName((Element)docinfo, (String)"header");
        JDomB9Utils.addChildAndName((Element)header, (String)"doctype", (String)"ledger");
        JDomB9Utils.addChildAndName((Element)header, (String)"creater", (String)FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName((Element)header, (String)"time", (String)FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName((Element)header, (String)"rearchflag", (String)flag);
        JDomB9Utils.addChildAndName((Element)header, (String)"desc", (String)desc);
        Element datalist = JDomB9Utils.addChildAndName((Element)docinfo, (String)"data-list");
        JDomB9Utils.addData((Element)datalist, xmlList, (boolean)Boolean.FALSE);
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createSubledgerXml(String desc, List<Map<String, String>> xmlInfos, String flag) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName((Element)docinfo, (String)"header");
        JDomB9Utils.addChildAndName((Element)header, (String)"doctype", (String)"detailb");
        JDomB9Utils.addChildAndName((Element)header, (String)"creater", (String)FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName((Element)header, (String)"time", (String)FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName((Element)header, (String)"rearchflag", (String)flag);
        JDomB9Utils.addChildAndName((Element)header, (String)"desc", (String)desc);
        Element datalist = JDomB9Utils.addChildAndName((Element)docinfo, (String)"data-list");
        JDomB9Utils.addData((Element)datalist, xmlInfos, (boolean)Boolean.TRUE);
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createSubledgerXml(String desc, List<Map<String, String>> xmlInfos, String flag, boolean isSub) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName((Element)docinfo, (String)"header");
        JDomB9Utils.addChildAndName((Element)header, (String)"doctype", (String)(isSub ? "detailb" : "ledger"));
        JDomB9Utils.addChildAndName((Element)header, (String)"creater", (String)FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName((Element)header, (String)"time", (String)FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName((Element)header, (String)"rearchflag", (String)flag);
        JDomB9Utils.addChildAndName((Element)header, (String)"desc", (String)desc);
        Element datalist = JDomB9Utils.addChildAndName((Element)docinfo, (String)"data-list");
        JDomB9Utils.addData((Element)datalist, xmlInfos, (boolean)isSub);
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createElecreceiptXml(Map<Long, DynamicObject> receiptDys, Map<String, Set<Long>> refBilltypeAndIds, Map<String, Map<Long, Set<Long>>> receiptIdMap, Map<String, Object> imageMap, Map<String, Map<Long, Set<Long>>> billAndRefvoucherIds, String flag, Map<Long, String> recIdUrlMap) {
        HashMap<String, String> billTypeAndNameMap = new HashMap<String, String>();
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName((Element)docinfo, (String)"header");
        JDomB9Utils.addChildAndName((Element)header, (String)"doctype", (String)"bankReturn");
        JDomB9Utils.addChildAndName((Element)header, (String)"creater", (String)FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName((Element)header, (String)"time", (String)FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName((Element)header, (String)"rearchflag", (String)flag);
        JDomB9Utils.addChildAndName((Element)header, (String)"desc", (String)ResManager.loadKDString((String)"CAS\u7535\u5b50\u56de\u5355", (String)"FPYXmlUtils_0", (String)"fi-aef-common", (Object[])new Object[0]));
        Element datalist = JDomB9Utils.addChildAndName((Element)docinfo, (String)"data-list");
        for (Map.Entry<String, Set<Long>> billReceipt : refBilltypeAndIds.entrySet()) {
            String billType = billReceipt.getKey();
            if (!billTypeAndNameMap.containsKey(billType)) {
                String billTypeName = EntityMetadataCache.getDataEntityType((String)billType).getDisplayName().toString();
                billTypeAndNameMap.put(billType, billTypeName);
            }
            Set<Long> billList = billReceipt.getValue();
            for (Long billId : billList) {
                Set<Object> receiptIds = new HashSet();
                if (receiptIdMap.containsKey(billType)) {
                    receiptIds = receiptIdMap.get(billType).get(billId);
                }
                if (receiptIds == null || receiptIds.size() <= 0) continue;
                for (Long receiptId : receiptIds) {
                    Map numbermap;
                    Element data = JDomB9Utils.addChildAndName((Element)datalist, (String)"data");
                    DynamicObject dyo = receiptDys.get(receiptId);
                    if (dyo != null) {
                        JDomB9Utils.addChildAndName((Element)data, (String)"billid", (String)dyo.get("id").toString());
                        JDomB9Utils.addChildAndName((Element)data, (String)"tradeid", (String)dyo.get("tradeid").toString());
                        JDomB9Utils.addChildAndName((Element)data, (String)"payeeaccount", (String)(dyo.get("payeeaccount") == null ? "null" : dyo.get("payeeaccount").toString()));
                        JDomB9Utils.addChildAndName((Element)data, (String)"payeename", (String)(dyo.get("payeename") == null ? "null" : dyo.get("payeename").toString()));
                        JDomB9Utils.addChildAndName((Element)data, (String)"payeebank", (String)(dyo.get("payeebank") == null ? "null" : dyo.get("payeebank").toString()));
                        JDomB9Utils.addChildAndName((Element)data, (String)"paymentaccount", (String)(dyo.get("paymentaccount") == null ? "null" : dyo.get("paymentaccount").toString()));
                        JDomB9Utils.addChildAndName((Element)data, (String)"paymentname", (String)(dyo.get("paymentname") == null ? "null" : dyo.get("paymentname").toString()));
                        JDomB9Utils.addChildAndName((Element)data, (String)"paymentbank", (String)(dyo.get("paymentbank") == null ? "null" : dyo.get("paymentbank").toString()));
                        JDomB9Utils.addChildAndName((Element)data, (String)"tradedate", (String)(dyo.get("tradedate") == null ? "null" : dyo.get("tradedate").toString()));
                        JDomB9Utils.addChildAndName((Element)data, (String)"currency", (String)(dyo.get("currency") == null ? "null" : dyo.get("currency").toString()));
                        JDomB9Utils.addChildAndName((Element)data, (String)"amount", (String)(dyo.get("amount") == null ? "null" : dyo.get("amount").toString()));
                        JDomB9Utils.addChildAndName((Element)data, (String)"postscript", (String)(dyo.get("postscript") == null ? "null" : dyo.get("postscript").toString()));
                        JDomB9Utils.addChildAndName((Element)data, (String)"ismainbill", (String)"true");
                    }
                    Element refbilllist = JDomB9Utils.addChildAndName((Element)data, (String)"refbill-list");
                    Set<Long> ids = billAndRefvoucherIds.get(billType).get(billId);
                    if (ids != null && !ids.isEmpty()) {
                        JDomB9Utils.addChildAndNameForRefbills((Element)refbilllist, (String)"refbill", ids);
                    }
                    if (imageMap != null && (numbermap = (Map)imageMap.get("numbermap")) != null && numbermap.size() > 0 && numbermap.get(billType) != null && ((Map)numbermap.get(billType)).get(billId) != null && ((List)((Map)numbermap.get(billType)).get(billId)).size() > 0) {
                        Element imagesys = JDomB9Utils.addChildAndName((Element)data, (String)"imagesys");
                        JDomB9Utils.addChildAndName((Element)imagesys, (String)"imagesystype", (String)(imageMap.get("imagesystype") == null ? "null" : (String)imageMap.get("imagesystype")));
                        JDomB9Utils.addChildAndName((Element)imagesys, (String)"imagesysip", (String)(imageMap.get("imagesysip") == null ? "null" : (String)imageMap.get("imagesysip")));
                        JDomB9Utils.addChildAndName((Element)imagesys, (String)"imagesysport", (String)(imageMap.get("imagesysport") == null ? "null" : (String)imageMap.get("imagesysport")));
                        Element imagelist = JDomB9Utils.addChildAndName((Element)data, (String)"image-list");
                        List imagenumbers = (List)((Map)numbermap.get(billType)).get(billId);
                        for (String imagenumber : imagenumbers) {
                            Element image = JDomB9Utils.addChildAndName((Element)imagelist, (String)"image");
                            JDomB9Utils.addChildAndName((Element)image, (String)"imagenumber", (String)imagenumber);
                        }
                    }
                    Element filelist = JDomB9Utils.addChildAndName((Element)data, (String)"file-list");
                    if (recIdUrlMap != null && recIdUrlMap.size() > 0) {
                        Element urlFile = JDomB9Utils.addChildAndName((Element)filelist, (String)"file");
                        JDomB9Utils.addChildAndName((Element)urlFile, (String)"name", (String)ElecreceiptUtils.getFileName((String)recIdUrlMap.get(receiptId)));
                        JDomB9Utils.addChildAndName((Element)urlFile, (String)"srcname", (String)ElecreceiptUtils.getFileName((String)recIdUrlMap.get(receiptId)));
                    }
                    JDomB9Utils.addChildAndName((Element)data, (String)"year", (String)FPYXmlUtils.getTimeStr().substring(0, 4));
                }
            }
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createMRptXml(Map<String, String> rptUrlMap, Map<String, String> rptGetNameMap, Map<String, String> rptGetOrgMap, String flag, String bcmfyName, String bcmperiodName) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName((Element)docinfo, (String)"header");
        JDomB9Utils.addChildAndName((Element)header, (String)"doctype", (String)"monthReport");
        JDomB9Utils.addChildAndName((Element)header, (String)"creater", (String)FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName((Element)header, (String)"time", (String)FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName((Element)header, (String)"rearchflag", (String)flag);
        JDomB9Utils.addChildAndName((Element)header, (String)"desc", (String)ResManager.loadKDString((String)"\u6708\u5ea6\u8d22\u52a1\u62a5\u544a", (String)"FPYXmlUtils_1", (String)"fi-aef-common", (Object[])new Object[0]));
        Element datalist = JDomB9Utils.addChildAndName((Element)docinfo, (String)"data-list");
        for (Map.Entry<String, String> rptAllUrlMap : rptUrlMap.entrySet()) {
            String rptAllUrlKey = rptAllUrlMap.getKey();
            String allUrl = rptAllUrlMap.getValue();
            Element data = JDomB9Utils.addChildAndName((Element)datalist, (String)"data");
            JDomB9Utils.addChildAndName((Element)data, (String)"id", (String)("rpt_" + rptAllUrlKey.split("_")[2]));
            JDomB9Utils.addChildAndName((Element)data, (String)"billid", (String)rptAllUrlKey.split("_")[2]);
            JDomB9Utils.addChildAndName((Element)data, (String)"voucherorgnumber", (String)(rptGetOrgMap.get(rptAllUrlKey) == null ? "null" : rptGetOrgMap.get(rptAllUrlKey).split("_")[0]));
            JDomB9Utils.addChildAndName((Element)data, (String)"voucherorgname", (String)(rptGetOrgMap.get(rptAllUrlKey) == null ? "null" : rptGetOrgMap.get(rptAllUrlKey).split("_")[1]));
            JDomB9Utils.addChildAndName((Element)data, (String)"reporttype", (String)(rptGetNameMap.get(rptAllUrlKey) == null ? "null" : rptGetNameMap.get(rptAllUrlKey)));
            JDomB9Utils.addChildAndName((Element)data, (String)"period", (String)FPYXmlUtils.bulidRptPeriod(bcmfyName, bcmperiodName));
            Element filelist = JDomB9Utils.addChildAndName((Element)data, (String)"file-list");
            Element urlFile = JDomB9Utils.addChildAndName((Element)filelist, (String)"file");
            JDomB9Utils.addChildAndName((Element)urlFile, (String)"name", (String)(rptAllUrlKey + ".pdf"));
            JDomB9Utils.addChildAndName((Element)urlFile, (String)"srcname", (String)(rptAllUrlKey + ".pdf"));
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createQRptXml(Map<String, String> rptUrlMap, Map<String, String> rptGetNameMap, Map<String, String> rptGetOrgMap, String flag, String bcmfyName, String bcmperiodName) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName((Element)docinfo, (String)"header");
        JDomB9Utils.addChildAndName((Element)header, (String)"doctype", (String)"monthReport");
        JDomB9Utils.addChildAndName((Element)header, (String)"creater", (String)FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName((Element)header, (String)"time", (String)FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName((Element)header, (String)"rearchflag", (String)flag);
        JDomB9Utils.addChildAndName((Element)header, (String)"desc", (String)ResManager.loadKDString((String)"\u5b63\u5ea6\u8d22\u52a1\u62a5\u544a", (String)"FPYXmlUtils_2", (String)"fi-aef-common", (Object[])new Object[0]));
        Element datalist = JDomB9Utils.addChildAndName((Element)docinfo, (String)"data-list");
        for (Map.Entry<String, String> rptAllUrlMap : rptUrlMap.entrySet()) {
            String rptAllUrlKey = rptAllUrlMap.getKey();
            String allUrl = rptAllUrlMap.getValue();
            Element data = JDomB9Utils.addChildAndName((Element)datalist, (String)"data");
            JDomB9Utils.addChildAndName((Element)data, (String)"id", (String)("rpt_" + rptAllUrlKey.split("_")[2]));
            JDomB9Utils.addChildAndName((Element)data, (String)"billid", (String)rptAllUrlKey.split("_")[2]);
            JDomB9Utils.addChildAndName((Element)data, (String)"voucherorgnumber", (String)(rptGetOrgMap.get(rptAllUrlKey) == null ? "null" : rptGetOrgMap.get(rptAllUrlKey).split("_")[0]));
            JDomB9Utils.addChildAndName((Element)data, (String)"voucherorgname", (String)(rptGetOrgMap.get(rptAllUrlKey) == null ? "null" : rptGetOrgMap.get(rptAllUrlKey).split("_")[1]));
            JDomB9Utils.addChildAndName((Element)data, (String)"reporttype", (String)(rptGetNameMap.get(rptAllUrlKey) == null ? "null" : rptGetNameMap.get(rptAllUrlKey)));
            JDomB9Utils.addChildAndName((Element)data, (String)"period", (String)FPYXmlUtils.bulidRptPeriod(bcmfyName, bcmperiodName));
            Element filelist = JDomB9Utils.addChildAndName((Element)data, (String)"file-list");
            Element urlFile = JDomB9Utils.addChildAndName((Element)filelist, (String)"file");
            JDomB9Utils.addChildAndName((Element)urlFile, (String)"name", (String)(rptAllUrlKey + ".pdf"));
            JDomB9Utils.addChildAndName((Element)urlFile, (String)"srcname", (String)(rptAllUrlKey + ".pdf"));
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createARptXml(Map<String, String> rptUrlMap, Map<String, String> rptGetNameMap, Map<String, String> rptGetOrgMap, String flag, String bcmfyName, String bcmperiodName) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName((Element)docinfo, (String)"header");
        JDomB9Utils.addChildAndName((Element)header, (String)"doctype", (String)"monthReport");
        JDomB9Utils.addChildAndName((Element)header, (String)"creater", (String)FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName((Element)header, (String)"time", (String)FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName((Element)header, (String)"rearchflag", (String)flag);
        JDomB9Utils.addChildAndName((Element)header, (String)"desc", (String)ResManager.loadKDString((String)"\u5e74\u5ea6\u8d22\u52a1\u62a5\u544a", (String)"FPYXmlUtils_3", (String)"fi-aef-common", (Object[])new Object[0]));
        Element datalist = JDomB9Utils.addChildAndName((Element)docinfo, (String)"data-list");
        for (Map.Entry<String, String> rptAllUrlMap : rptUrlMap.entrySet()) {
            String rptAllUrlKey = rptAllUrlMap.getKey();
            String allUrl = rptAllUrlMap.getValue();
            Element data = JDomB9Utils.addChildAndName((Element)datalist, (String)"data");
            JDomB9Utils.addChildAndName((Element)data, (String)"id", (String)("rpt_" + rptAllUrlKey.split("_")[2]));
            JDomB9Utils.addChildAndName((Element)data, (String)"billid", (String)rptAllUrlKey.split("_")[2]);
            JDomB9Utils.addChildAndName((Element)data, (String)"voucherorgnumber", (String)(rptGetOrgMap.get(rptAllUrlKey) == null ? "null" : rptGetOrgMap.get(rptAllUrlKey).split("_")[0]));
            JDomB9Utils.addChildAndName((Element)data, (String)"voucherorgname", (String)(rptGetOrgMap.get(rptAllUrlKey) == null ? "null" : rptGetOrgMap.get(rptAllUrlKey).split("_")[1]));
            JDomB9Utils.addChildAndName((Element)data, (String)"reporttype", (String)(rptGetNameMap.get(rptAllUrlKey) == null ? "null" : rptGetNameMap.get(rptAllUrlKey)));
            JDomB9Utils.addChildAndName((Element)data, (String)"period", (String)FPYXmlUtils.bulidRptPeriod(bcmfyName, bcmperiodName));
            JDomB9Utils.addChildAndName((Element)data, (String)"year", (String)bcmfyName.substring(0, 4));
            JDomB9Utils.addChildAndName((Element)data, (String)"barcode", (String)"001");
            Element filelist = JDomB9Utils.addChildAndName((Element)data, (String)"file-list");
            Element urlFile = JDomB9Utils.addChildAndName((Element)filelist, (String)"file");
            JDomB9Utils.addChildAndName((Element)urlFile, (String)"name", (String)(rptAllUrlKey + ".pdf"));
            JDomB9Utils.addChildAndName((Element)urlFile, (String)"srcname", (String)(rptAllUrlKey + ".pdf"));
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createElecXml(DataSet set, Map<Long, String> billFileNameMap, String billName, Map<Long, List<Attach>> attachMap, String billType, Map<Long, List<DynamicObject>> entryRows, String flag) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName((Element)docinfo, (String)"header");
        JDomB9Utils.addChildAndName((Element)header, (String)"doctype", (String)"elecstatement");
        JDomB9Utils.addChildAndName((Element)header, (String)"creater", (String)FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName((Element)header, (String)"time", (String)FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName((Element)header, (String)"rearchflag", (String)flag);
        JDomB9Utils.addChildAndName((Element)header, (String)"desc", (String)billName);
        Element datalist = JDomB9Utils.addChildAndName((Element)docinfo, (String)"data-list");
        for (Row row : set) {
            Long billId = row.getLong("id");
            List<DynamicObject> entrys = entryRows.get(billId);
            HashSet<String> tradetypeSet = new HashSet<String>(2);
            BigDecimal debitBigDecimal = BigDecimal.ZERO;
            BigDecimal creditBigDecimal = BigDecimal.ZERO;
            int debitnum = 0;
            int creditnum = 0;
            FPYXmlUtils.getDecimalValue(debitBigDecimal, creditBigDecimal, debitnum, creditnum, entrys, tradetypeSet);
            String tradetypeString = ResManager.loadKDString((String)"\u5168\u90e8", (String)"FPYXmlUtils_4", (String)"fi-aef-common", (Object[])new Object[0]);
            if (tradetypeSet.size() == 1) {
                tradetypeString = "0".equals(tradetypeSet.iterator().next()) ? ResManager.loadKDString((String)"\u501f", (String)"FPYXmlUtils_5", (String)"fi-aef-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d37", (String)"FPYXmlUtils_6", (String)"fi-aef-common", (Object[])new Object[0]);
            }
            Element data = JDomB9Utils.addChildAndName((Element)datalist, (String)"data");
            JDomB9Utils.addChildAndName((Element)data, (String)"billid", (String)row.getString("id"));
            JDomB9Utils.addChildAndName((Element)data, (String)"accountdate", (String)DateUtil.getShortStr((Date)row.getDate("period")));
            JDomB9Utils.addChildAndName((Element)data, (String)"tradetype", (String)tradetypeString);
            JDomB9Utils.addChildAndName((Element)data, (String)"period", (String)DateUtil.getShortStr((Date)row.getDate("period")));
            JDomB9Utils.addChildAndName((Element)data, (String)"accountname", (String)row.getString("accountname"));
            JDomB9Utils.addChildAndName((Element)data, (String)"accountno", (String)row.getString("accountno"));
            JDomB9Utils.addChildAndName((Element)data, (String)"currency", (String)row.getString("currency"));
            JDomB9Utils.addChildAndName((Element)data, (String)"debitamount", (String)debitBigDecimal.toString());
            JDomB9Utils.addChildAndName((Element)data, (String)"creditamount", (String)creditBigDecimal.toString());
            JDomB9Utils.addChildAndName((Element)data, (String)"debitnum", (String)(debitnum + ""));
            JDomB9Utils.addChildAndName((Element)data, (String)"creditnum", (String)(creditnum + ""));
            Element jlinelist = JDomB9Utils.addChildAndName((Element)data, (String)"jeline-list");
            if (entrys.size() > 0) {
                for (DynamicObject dyn : entrys) {
                    Element jline = jlinelist.addElement("jeline");
                    JDomB9Utils.addChildAndName((Element)jline, (String)"accounttime", (String)(dyn.getString("accounttime") == null ? "" : dyn.getString("accounttime")));
                    tradetypeString = dyn.getString("tradetype");
                    JDomB9Utils.addChildAndName((Element)jline, (String)"tradetype", (String)(tradetypeString == null ? "" : tradetypeString));
                    JDomB9Utils.addChildAndName((Element)jline, (String)"amount", (String)("0".equals(tradetypeString) ? (dyn.getString("debitamount") == null ? "0" : dyn.getString("debitamount")) : (dyn.getString("creditamount") == null ? "0" : dyn.getString("creditamount"))));
                    JDomB9Utils.addChildAndName((Element)jline, (String)"accountbalance", (String)(dyn.getString("accountbalance") == null ? "0" : dyn.getString("accountbalance")));
                    JDomB9Utils.addChildAndName((Element)jline, (String)"oppositeaccount", (String)(dyn.getString("oppositeaccount") == null ? "" : dyn.getString("oppositeaccount")));
                    JDomB9Utils.addChildAndName((Element)jline, (String)"oppositename", (String)(dyn.getString("oppositename") == null ? "" : dyn.getString("oppositename")));
                    JDomB9Utils.addChildAndName((Element)jline, (String)"abstract", (String)(dyn.getString("abstract") == null ? "" : dyn.getString("abstract")));
                    JDomB9Utils.addChildAndName((Element)jline, (String)"voucherNum", (String)(dyn.getString("voucherNum") == null ? "" : dyn.getString("voucherNum")));
                    JDomB9Utils.addChildAndName((Element)jline, (String)"tradeid", (String)(dyn.getString("tradeid") == null ? "" : dyn.getString("tradeid")));
                }
            }
            Element filelist = JDomB9Utils.addChildAndName((Element)data, (String)"file-list");
            Element file = JDomB9Utils.addChildAndName((Element)filelist, (String)"file");
            String name = billFileNameMap.get(billId);
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = "";
            }
            JDomB9Utils.addChildAndName((Element)file, (String)"name", (String)name);
            JDomB9Utils.addChildAndName((Element)file, (String)"srcname", (String)name);
            List<Attach> attaches = attachMap.get(billId);
            if (attaches == null) continue;
            for (Attach attachfile : attaches) {
                Element attach = filelist.addElement("file");
                JDomB9Utils.addChildAndName((Element)attach, (String)"name", (String)(billId + "_" + attachfile.getFileName()));
                JDomB9Utils.addChildAndName((Element)attach, (String)"srcname", (String)attachfile.getFileName());
            }
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    private static void getDecimalValue(BigDecimal debitBigDecimal, BigDecimal creditBigDecimal, int debitnum, int creditnum, List<DynamicObject> entrys, Set<String> tradetypeSet) {
        for (DynamicObject dynamicObject : entrys) {
            tradetypeSet.add(dynamicObject.getString("tradetype"));
            if ("0".equals(dynamicObject.getString("tradetype"))) {
                ++debitnum;
            } else {
                ++creditnum;
            }
            debitBigDecimal = debitBigDecimal.add(dynamicObject.getBigDecimal("debitamount") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("debitamount"));
            creditBigDecimal = creditBigDecimal.add(dynamicObject.getBigDecimal("creditamount") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("creditamount"));
        }
    }

    public static String bulidRptPeriod(String bcmfyName, String bcmperiodName) {
        String string = "";
        if (!StringUtils.isEmpty((CharSequence)bcmfyName) && !StringUtils.isEmpty((CharSequence)bcmperiodName)) {
            String periodString = "";
            periodString = bcmperiodName.length() == 2 ? "0" + bcmperiodName.substring(0, bcmperiodName.length() - 1) : bcmperiodName.substring(0, bcmperiodName.length() - 1);
            string = bcmfyName.substring(0, bcmfyName.length() - 1) + "-" + periodString;
        }
        return string;
    }

    public static String dealPeriodNumber(String periodNumber) {
        if (!StringUtils.isEmpty((CharSequence)periodNumber) && periodNumber.length() == 6) {
            periodNumber = periodNumber.substring(0, 4) + "-" + periodNumber.substring(4, 6);
        }
        return periodNumber;
    }

    public static void addFiles(Element filelist, String fileNodeName, List<Attach> attaches, String voucherId, String fileName) {
        Element mainfile = filelist.addElement(fileNodeName);
        JDomB9Utils.addChildAndName((Element)mainfile, (String)"name", (String)fileName);
        JDomB9Utils.addChildAndName((Element)mainfile, (String)"srcname", (String)fileName);
        if (attaches == null || attaches.isEmpty()) {
            return;
        }
        for (Attach attach : attaches) {
            String name = attach.getFileName();
            Element file = filelist.addElement(fileNodeName);
            JDomB9Utils.addChildAndName((Element)file, (String)"name", (String)(voucherId + "_" + name));
            JDomB9Utils.addChildAndName((Element)file, (String)"srcname", (String)name);
        }
    }

    private static String getSysName() {
        return ResManager.loadKDString((String)"\u82cd\u7a79", (String)"FPYXmlUtils_7", (String)"fi-aef-common", (Object[])new Object[0]);
    }

    private static String getTimeStr() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        return simpleDateFormat.format(date);
    }

    private static String getLongTimeStr() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    private static String toBase64Str(Document document) {
        ByteArrayOutputStream byteOut = null;
        XMLWriter xmlWriter = null;
        try {
            byteOut = new ByteArrayOutputStream();
            xmlWriter = new XMLWriter((OutputStream)byteOut);
            xmlWriter.write(document);
            byte[] byteArr = byteOut.toByteArray();
            String string = Base64.getEncoder().encodeToString(byteArr);
            return string;
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"Documen\u8f6c\u5316\u4e3abyte[]\u5931\u8d25\u3002", (String)"CreateXmlUtil_1", (String)"fi-aef-common", (Object[])new Object[0]));
        }
        finally {
            if (byteOut != null) {
                try {
                    byteOut.close();
                }
                catch (IOException e) {
                    LogUtil.printLog((Log)logger, (String)ResManager.loadKDString((String)"\u5173\u95ed\u6d41\u5931\u8d25", (String)"FPYXmlUtils_8", (String)"fi-aef-common", (Object[])new Object[0]));
                }
            }
            if (xmlWriter != null) {
                try {
                    xmlWriter.close();
                }
                catch (IOException e) {
                    LogUtil.printLog((Log)logger, (String)ResManager.loadKDString((String)"\u5173\u95ed\u6d41\u5931\u8d25", (String)"FPYXmlUtils_8", (String)"fi-aef-common", (Object[])new Object[0]));
                }
            }
        }
    }

    public static String createFacardfinXml(ArchiveContext context, List<Bill> list, String desc, Map<Object, FileDesc> billFileMap, Map<Object, List<Attach>> attachMap, String flag, Set<Object> errIds) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName((Element)docinfo, (String)"header");
        JDomB9Utils.addChildAndName((Element)header, (String)"doctype", (String)"assetscard");
        JDomB9Utils.addChildAndName((Element)header, (String)"creater", (String)FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName((Element)header, (String)"time", (String)FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName((Element)header, (String)"desc", (String)desc);
        JDomB9Utils.addChildAndName((Element)header, (String)"rearchflag", (String)flag);
        Element datalist = JDomB9Utils.addChildAndName((Element)docinfo, (String)"data-list");
        FPYXmlUtils.addFaChildAndName(datalist, list, billFileMap, attachMap, errIds);
        return FPYXmlUtils.toBase64Str(document);
    }

    private static void addFaChildAndName(Element datalist, List<Bill> list, Map<Object, FileDesc> billFileMap, Map<Object, List<Attach>> attachMap, Set<Object> errIds) {
        int i = 0;
        for (Bill bill : list) {
            ++i;
            Object billId = bill.getBillId();
            if (errIds != null && errIds.size() > 0 && errIds.contains(billId)) continue;
            Element data = JDomB9Utils.addChildAndName((Element)datalist, (String)"data");
            JDomB9Utils.addChildAndName((Element)data, (String)"id", (String)(i + ""));
            JDomB9Utils.addChildAndName((Element)data, (String)"billid", (String)billId.toString());
            JDomB9Utils.addChildAndName((Element)data, (String)"period", (String)CreateXmlUtil.dealPeriodNumber(bill.getPeriodNumber()));
            JDomB9Utils.addChildAndName((Element)data, (String)"voucherorgnumber", (String)bill.getOrgNo());
            JDomB9Utils.addChildAndName((Element)data, (String)"voucherorgname", (String)bill.getOrgName());
            Map<String, Object> field2ValueMap = bill.getField2ValueMap();
            field2ValueMap.forEach((k, v) -> JDomB9Utils.addChildAndName((Element)data, (String)k, (String)v.toString()));
            Element filelist = JDomB9Utils.addChildAndName((Element)data, (String)"file-list");
            Element file = JDomB9Utils.addChildAndName((Element)filelist, (String)"file");
            String fileName = billFileMap.get(billId).getName();
            JDomB9Utils.addChildAndName((Element)file, (String)"name", (String)fileName);
            JDomB9Utils.addChildAndName((Element)file, (String)"srcname", (String)fileName);
            List<Attach> attaches = null;
            if (attachMap != null) {
                attaches = attachMap.get(billId);
            }
            if (attaches == null) continue;
            for (Attach attachfile : attaches) {
                Element attach = filelist.addElement("file");
                JDomB9Utils.addChildAndName((Element)attach, (String)"name", (String)(billId + "_" + attachfile.getFileName()));
                JDomB9Utils.addChildAndName((Element)attach, (String)"srcname", (String)attachfile.getFileName());
            }
        }
    }
}

