/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.datainput;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.ArchiveUtil;
import kd.fi.aef.common.util.BizParamUtils;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.FieldMappingUtil;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.JudgeBillType;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.helper.QueryFinanceBillHelper;
import kd.fi.aef.logic.ContextData;
import kd.fi.aef.logic.common.LogicUtils;
import kd.fi.aef.logic.model.AccountObj;
import kd.fi.aef.logic.model.Attach;
import kd.fi.aef.logic.model.Bill;
import kd.fi.aef.logic.output.IDocumentServerHandler;
import kd.fi.aef.logic.unit.ArchiveVoucherLogicUnit;

public abstract class DataProvider {
    private static final Log logger = LogFactory.getLog(DataProvider.class);
    private static final String SELECT_FIELDS = "id,billno,period.id period,period.name periodname,period.number periodnumber,org.id org,org.name orgname,org.number orgnumber,assetbook.depreuse.name depreusename,assetbook.depreuse.number depreusenumber, realcard.number assetcode, realcard.assetname assetname, realcard.assetcat.name assettype, realcard.headusedept.name usedept, realcard.usedate usestarttime, depremethod.name depreciation, originalval originalvalue, basecurrency.number currency";

    public Map<Long, List<Attach>> getIdAndAttacheFiles(String billType, Set<Long> ids, String attachtabJson) {
        return LogicUtils.getIdAndAttacheFiles((String)billType, ids, (String)attachtabJson);
    }

    public List<Bill> getFacardBillData(ArchiveContext context) {
        ArrayList<Bill> resultList = new ArrayList<Bill>();
        QFilter idFilter = new QFilter("id", "in", (Object)context.getIds());
        DataSet set = QueryServiceHelper.queryDataSet((String)"DataProvider.excute", (String)context.getBillType(), (String)SELECT_FIELDS, (QFilter[])new QFilter[]{idFilter}, null);
        LogUtil.printLog((Log)logger, (String)ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\uff1a{}\u6570\u91cf\u4e3a:{} \u7ebf\u7a0b\uff1a{} ", (String)"DataProvider_0", (String)"fi-aef-common", (Object[])new Object[0]), (Object[])new Object[]{context.getBillType(), context.getIds().size(), Thread.currentThread().getName()});
        if (set != null) {
            while (set.hasNext()) {
                Row row = set.next();
                Bill bill = new Bill();
                bill.setBillId(row.getLong("id"));
                bill.setBillNo(row.getString("billno"));
                bill.setOrgId(row.getLong("org"));
                bill.setBookNumber(row.getString("orgnumber"));
                bill.setBookName(row.getString("orgname"));
                if (context.isSplitBook() && context.isAws()) {
                    bill.setBookNumber(row.getString("orgnumber") + row.getString("depreusenumber"));
                    bill.setBookName(row.getString("orgname") + row.getString("depreusename"));
                }
                bill.setInstitutionIssuesNo("fa_" + row.getString("depreusenumber"));
                bill.setInstitutionIssuesName(row.getString("depreusename"));
                bill.setOrgNo(row.getString("orgnumber"));
                bill.setOrgName(row.getString("orgname"));
                bill.setPeriodId(row.getLong("period"));
                bill.setPeriodNumber(row.getString("periodnumber"));
                HashMap<String, Object> field2ValueMap = new HashMap<String, Object>();
                field2ValueMap.put("assetcode", row.getString("assetcode") == null ? "" : row.getString("assetcode"));
                field2ValueMap.put("assetname", row.getString("assetname") == null ? "" : row.getString("assetname"));
                field2ValueMap.put("assettype", row.getString("assettype") == null ? "" : row.getString("assettype"));
                field2ValueMap.put("usedept", row.getString("usedept") == null ? "" : row.getString("usedept"));
                field2ValueMap.put("usestarttime", row.getDate("usestarttime") == null ? "" : DateUtil.getTimeStr((Date)row.getDate("usestarttime")));
                field2ValueMap.put("depreciation", row.getString("depreciation") == null ? "" : row.getString("depreciation"));
                field2ValueMap.put("originalvalue", row.getString("originalvalue") == null ? "" : row.getString("originalvalue"));
                field2ValueMap.put("currency", row.getString("currency") == null ? "" : row.getString("currency"));
                bill.setField2ValueMap(field2ValueMap);
                resultList.add(bill);
            }
        }
        return resultList;
    }

    public List<Bill> getBillData(ArchiveContext context) {
        String dateField = context.getDateField();
        QFilter idFilter = new QFilter("id", "in", (Object)context.getIds());
        String billType = context.getBillType();
        String selectFields = ArchiveUtil.getSelectFields(billType, dateField);
        selectFields = this.supplementFields(selectFields, billType);
        DataSet set = QueryServiceHelper.queryDataSet((String)"ArchiveOpService.excute", (String)context.getBillType(), (String)selectFields, (QFilter[])new QFilter[]{idFilter}, null);
        LogUtil.printLog((Log)logger, (String)ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\uff1a{}\u6570\u91cf\u4e3a:{} \u7ebf\u7a0b\uff1a{} ", (String)"DataProvider_0", (String)"fi-aef-common", (Object[])new Object[0]), (Object[])new Object[]{context.getBillType(), context.getIds().size(), Thread.currentThread().getName()});
        ArrayList<Bill> resultList = new ArrayList<Bill>();
        String idField = ArchiveUtil.getFieldName(billType, "id");
        String billNoField = ArchiveUtil.getFieldName(billType, QueryFinanceBillHelper.getBillNo((String)billType));
        String periodFiledByBill = FieldMappingUtil.getPeriodFiledByBill(billType);
        DynamicObjectCollection filedDynObjColl = ArchiveUtil.getXmlfileds(billType);
        if (set != null) {
            while (set.hasNext()) {
                Row row = set.next();
                Bill bill = new Bill();
                bill.setBillId(row.getLong(idField));
                bill.setBillNo(row.getString(billNoField));
                bill.setOrgId(row.getLong("org"));
                if (JudgeBillType.isFinaceBill((String)context.getBillType())) {
                    bill.setPeriodId(row.getLong("period"));
                }
                bill.setOrgNo(row.getString("orgnumber"));
                bill.setOrgName(row.getString("orgname"));
                bill.setDate(row.getDate("xinghanperiod"));
                if (StringUtils.isNotEmpty((CharSequence)periodFiledByBill)) {
                    bill.setPeriodId(row.getLong("xinghanperiodid"));
                    String periodNumber = context.isAws() ? CreateXmlUtil.dealPeriodNumber(row.getString("xinghanperiodnumber")) : CreateXmlUtil.dealAdjustmentPeriodNumber(row.getString("xinghanperiodnumber"));
                    bill.setPeriodNumber(periodNumber);
                }
                HashMap<String, Object> field2ValueMap = new HashMap<String, Object>(filedDynObjColl.size());
                if (filedDynObjColl.size() == 0) {
                    Date date;
                    field2ValueMap.put("billcode", bill.getBillNo());
                    field2ValueMap.put("voucherorgnumber", bill.getOrgNo());
                    field2ValueMap.put("voucherorgname", bill.getOrgName());
                    if ("cas_balanceadjust".equals(billType)) {
                        field2ValueMap.put("openingBank", row.getString("openingBank"));
                        field2ValueMap.put("bankAccount", row.getString("bankAccount"));
                        date = row.getDate("biz_date");
                        field2ValueMap.put("biz_date", DateUtil.getTimeStr((Date)date));
                    } else if ("cas_bankstatement".equals(billType)) {
                        date = row.getDate("biz_date");
                        field2ValueMap.put("biz_date", DateUtil.getTimeStr((Date)date));
                    }
                    field2ValueMap.put("period", StringUtils.isNotEmpty((CharSequence)bill.getPeriodNumber()) ? bill.getPeriodNumber() : DateUtil.getShortStr((Date)bill.getDate()));
                } else {
                    for (DynamicObject fieldDynObj : filedDynObjColl) {
                        String xmlFiled = fieldDynObj.getString("xmlfiled");
                        String fieldValue = ArchiveUtil.getFieldValue(row, fieldDynObj);
                        if ("period".equals(xmlFiled)) {
                            field2ValueMap.put(xmlFiled, bill.getPeriodNumber());
                            continue;
                        }
                        field2ValueMap.put(xmlFiled, fieldValue);
                    }
                }
                bill.setField2ValueMap(field2ValueMap);
                resultList.add(bill);
            }
        }
        return resultList;
    }

    public Set<?> getFilingIds(String billType, Set<?> ids) {
        return LogicUtils.getFilingIds((String)billType, ids);
    }

    public Map<String, Object> getImageNumberMap(String billType, Set<Object> ids) {
        Map imageNumberMap = LogicUtils.getImageNumberMap((String)billType, ids);
        return LogicUtils.getImgConfig((Map)imageNumberMap);
    }

    public byte[] getPrintByte(String pageId, String formId, String templateId, List<Object> pkIds, String printType, int type) {
        return FileUtils.getPrintByte(pageId, formId, templateId, pkIds, printType, type);
    }

    public String getPrintUrl(String pageId, String formId, String templateId, List<Object> pkIds, String printType, int type) {
        return FileUtils.getPrintUrl(pageId, formId, templateId, pkIds, printType, type);
    }

    public List<Bill> getVoucherData(ArchiveContext context) {
        QFilter needArchiveVoucherFilter = new QFilter("id", "in", (Object)context.getNeedArchiveIds());
        String billType = context.getBillType();
        String selectFields = ArchiveUtil.getSelectFields(billType, null);
        selectFields = this.supplementFields(selectFields, billType);
        DataSet voucherSet = QueryServiceHelper.queryDataSet((String)"ArchiveOpService.excute", (String)context.getBillType(), (String)selectFields, (QFilter[])new QFilter[]{needArchiveVoucherFilter}, null);
        ArrayList<Bill> resultList = new ArrayList<Bill>(context.getNeedArchiveIds().size());
        String idField = ArchiveUtil.getFieldName(billType, "id");
        String billNoField = ArchiveUtil.getFieldName(billType, QueryFinanceBillHelper.getBillNo((String)billType));
        String descField = ArchiveUtil.getFieldName("gl_voucher", "vdescription");
        String periodField = ArchiveUtil.getFieldName("gl_voucher", "period");
        DynamicObjectCollection filedDynObjColl = ArchiveUtil.getXmlfileds(billType);
        while (voucherSet.hasNext()) {
            Row row = voucherSet.next();
            Bill voucher = new Bill();
            voucher.setBillId(row.getLong(idField));
            voucher.setBillNo(row.getString(billNoField));
            voucher.setOrgName(row.getString("orgname"));
            voucher.setOrgNo(row.getString("orgnumber"));
            voucher.setBookTypeId(row.getLong("booktypeid"));
            voucher.setBookNumber(row.getString("booktypenumber"));
            voucher.setBookName(row.getString("booktypename"));
            voucher.setInstitutionIssuesNo("gl_" + row.getString("booktypenumber"));
            voucher.setInstitutionIssuesName(row.getString("booktypename"));
            voucher.setPeriodNumber(row.getString("periodnumber"));
            voucher.setOrgId(row.getLong("org"));
            voucher.setPeriodId(row.getLong("periodid"));
            HashMap<String, Object> field2ValueMap = new HashMap<String, Object>(filedDynObjColl.size());
            if (filedDynObjColl.size() > 0) {
                for (DynamicObject fieldDynObj : filedDynObjColl) {
                    String xmlFiled = fieldDynObj.getString("xmlfiled");
                    String fieldValue = ArchiveUtil.getFieldValue(row, fieldDynObj);
                    if (xmlFiled.equals(idField)) {
                        field2ValueMap.put(idField, "gl_voucher" + row.getLong(idField));
                        continue;
                    }
                    if (xmlFiled.equals(periodField)) {
                        String periodNumber = context.isAws() ? CreateXmlUtil.dealPeriodNumber(ArchiveUtil.getFieldValue(row, fieldDynObj)) : CreateXmlUtil.dealAdjustmentPeriodNumber(ArchiveUtil.getFieldValue(row, fieldDynObj));
                        field2ValueMap.put(periodField, periodNumber);
                        continue;
                    }
                    if (xmlFiled.equals(descField)) {
                        field2ValueMap.put(xmlFiled, fieldValue);
                        voucher.setDesc(fieldValue);
                        continue;
                    }
                    field2ValueMap.put(xmlFiled, fieldValue);
                }
            } else {
                voucher.setDesc(row.getString(descField));
                field2ValueMap.put("billid", "gl_voucher" + row.getLong(idField));
                field2ValueMap.put("voucherorgnumber", row.getString("orgnumber"));
                field2ValueMap.put("voucherorgname", row.getString("orgname"));
                field2ValueMap.put("period", CreateXmlUtil.dealPeriodNumber(row.getString("periodnumber")));
                field2ValueMap.put("vouchernum", row.getString("billno"));
                field2ValueMap.put("attachnum", row.getString("attachment"));
                field2ValueMap.put("vouchertype", row.getString("vouchertypename"));
                field2ValueMap.put("currency", row.getString("localcurnumber"));
                field2ValueMap.put("totaldebitloc", row.getString("debitlocamount"));
                field2ValueMap.put("totalcreditloc", row.getString("creditlocamount"));
                field2ValueMap.put("auditing", row.getString("auditorname"));
                field2ValueMap.put("creater", row.getString("creatorname"));
                field2ValueMap.put("accountdate", row.getDate("accountdate") == null ? "" : DateUtil.getTimeStr((Date)row.getDate("accountdate")));
                field2ValueMap.put("posting_date", row.getDate("posting_date") == null ? "" : DateUtil.getTimeStr((Date)row.getDate("posting_date")));
            }
            voucher.setField2ValueMap(field2ValueMap);
            resultList.add(voucher);
        }
        LogUtil.printLog((Log)logger, (String)ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\uff1a{}\u6570\u91cf\u4e3a:{} \u7ebf\u7a0b\uff1a{} ", (String)"DataProvider_0", (String)"fi-aef-common", (Object[])new Object[0]), (Object[])new Object[]{context.getBillType(), context.getIds().size(), Thread.currentThread().getName()});
        return resultList;
    }

    private String supplementFields(String selectFields, String billType) {
        if ("gl_voucher".equals(billType)) {
            if (!selectFields.contains(" orgnumber")) {
                selectFields = selectFields + ",org.number orgnumber";
            }
            if (!selectFields.contains(" orgname")) {
                selectFields = selectFields + ",org.name orgname";
            }
            if (!selectFields.contains(" booktypenumber")) {
                selectFields = selectFields + ",booktype.number booktypenumber";
            }
            if (!selectFields.contains(" booktypename")) {
                selectFields = selectFields + ",booktype.name booktypename";
            }
            if (!selectFields.contains(" periodnumber")) {
                selectFields = selectFields + ",period.number periodnumber";
            }
        } else {
            String mainOrg;
            Map<String, String> billType2ArchiveOrgCfgFieldMap = BizParamUtils.getBillType2ArchiveOrgCfgFieldMap(Collections.singleton(billType));
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)billType);
            String string = mainOrg = billType2ArchiveOrgCfgFieldMap.get(billType) == null ? type.getMainOrg() : billType2ArchiveOrgCfgFieldMap.get(billType);
            if (!selectFields.contains(" orgnumber")) {
                selectFields = selectFields + "," + mainOrg + ".number orgnumber";
            }
            if (!selectFields.contains(" orgname")) {
                selectFields = selectFields + "," + mainOrg + ".name orgname";
            }
        }
        return selectFields;
    }

    public void archiveReferenceBills(ArchiveContext context) {
    }

    public void archiveXbrl(ArchiveContext context) {
    }

    public void archiveReceipt(ArchiveContext context) {
    }

    public void initProvider(ArchiveContext context, ContextData ContextData2, ArchiveVoucherLogicUnit archiveVoucherLogicUnit, IDocumentServerHandler documentServerHandler) {
    }

    public void endProvider(ArchiveContext context, ContextData ContextData2) {
    }

    List<AccountObj> getAllAccounts(ArchiveContext context) {
        return null;
    }
}

