/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logicunit.fpy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.ArchiveUtil;
import kd.fi.aef.common.util.BizParamUtils;
import kd.fi.aef.common.util.BusinessTypeUtils;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.ElecreceiptUtils;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.Attach;
import kd.fi.aef.entity.FpyUploadItem;
import kd.fi.aef.entity.PrintIdandType;
import kd.fi.aef.helper.QueryFinanceBillHelper;
import kd.fi.aef.logicunit.AbstractArchiveLogicUnit;

public class ArchiveCommonBillByFpyLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveCommonBillByFpyLogicUnit.class);
    private static final String CLASS_NAME = "ArchiveCommonBillByFpyLogicUnit";

    protected void execute() {
        String dateField = this.context.getDateField();
        ArrayList<DynamicObject> errDyns = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        QFilter idFilter = new QFilter("id", "in", (Object)this.ids);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.billType);
        String mainOrg = type.getMainOrg();
        Map<String, String> billType2ArchiveOrgCfgFieldMap = BizParamUtils.getBillType2ArchiveOrgCfgFieldMap(Collections.singleton(this.billType));
        mainOrg = billType2ArchiveOrgCfgFieldMap.get(this.billType) == null ? mainOrg : billType2ArchiveOrgCfgFieldMap.get(this.billType);
        String periodNumberFiled = "";
        if (this.billType.equals("cas_bankstatement") || this.billType.equals("cas_balanceadjust")) {
            periodNumberFiled = ",period.number periodnumber";
        }
        DynamicObject dyn = QueryServiceHelper.queryOne((String)this.billType, (String)("id," + mainOrg + ".id org," + mainOrg + ".number orgnumber," + mainOrg + ".name orgname," + dateField + " period" + periodNumberFiled), (QFilter[])new QFilter[]{new QFilter("id", "=", this.ids.iterator().next())});
        Set<Long> filingIds = SingleArchiveUtil.getFilingIds(this.billType, this.ids);
        String selectFields = ArchiveUtil.getSelectFields(this.billType, dateField);
        DataSet set = QueryServiceHelper.queryDataSet((String)"ArchiveCommonBillByFpyLogicUnit.excute", (String)this.billType, (String)selectFields, (QFilter[])new QFilter[]{idFilter}, null);
        DataSet xmlSet = set.copy();
        HashMap<Long, List> elecUrlMap = new HashMap<Long, List>(16);
        if ("bei_elecstatement".equals(this.billType)) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.elecUrlMap", (String)"bei_elecstatement", (String)"id ,urlentry.e_fileservicepath url", (QFilter[])new QFilter[]{idFilter}, null);){
                for (Row row : dataSet) {
                    Long id = row.getLong("id");
                    String url = row.getString("url");
                    if (!StringUtils.isNotBlank((CharSequence)url)) continue;
                    elecUrlMap.computeIfAbsent(id, value -> new ArrayList()).add(url);
                }
            }
        }
        String attachtabJson = this.context.getAttachtabJson();
        Map<String, Map<Long, List<String>>> imageNumberMap = SingleArchiveUtil.getImageNumberMap(this.billType, this.ids);
        Map<Long, List<Attach>> attachMap = this.getIdAndAttacheFiles(this.billType, this.ids, attachtabJson);
        Date date = new Date();
        String orgNo = dyn.getString("orgnumber");
        String orgName = dyn.getString("orgname");
        String dateStr = this.billType.equals("cas_bankstatement") || this.billType.equals("cas_balanceadjust") ? CreateXmlUtil.dealPeriodNumber(dyn.getString("periodnumber")) : DateUtil.getShortStr((Date)dyn.getDate("period"));
        HashMap<Long, List<String>> billFileNameMap = new HashMap<Long, List<String>>(100);
        FpyUploadItem fpyUploadItem = new FpyUploadItem(this.archivesCode, orgNo, orgName, dateStr, this.batchCode, BusinessTypeUtils.getBusinessType(this.billType, false), null, null);
        HashSet<Long> needArchiveIds = new HashSet<Long>(16);
        needArchiveIds.addAll(this.ids);
        LogUtil.printLog((Log)logger, (String)ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\uff1a{}\u6570\u91cf\u4e3a:{} \u7ebf\u7a0b\uff1a{} ", (String)"ArchiveMultGlvoucherByFpyLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), (Object[])new Object[]{this.billType, this.ids.size(), Thread.currentThread().getName()});
        String idField = ArchiveUtil.getFieldName(this.billType, "id");
        String billnoField = ArchiveUtil.getFieldName(this.billType, QueryFinanceBillHelper.getBillNo((String)this.billType));
        HashMap<String, String> billidsMap = new HashMap<String, String>();
        while (set.hasNext()) {
            Object string;
            Row row = set.next();
            Long billId = row.getLong(idField);
            String billNo = row.getString(billnoField);
            billidsMap.put(billId + "." + ("ap_finapbill".equals(this.billType) ? "ap_invoice" : this.billType) + "_" + billId.toString(), this.billName + billNo);
            String fileName = this.billType + "_" + billId + ".pdf";
            fpyUploadItem.setFileName(fileName);
            fpyUploadItem.setAccountBookNo(orgNo);
            fpyUploadItem.setAccountBookName(orgName);
            fpyUploadItem.setPeriod(dateStr);
            if ("2".equals(this.isReverse)) continue;
            ArrayList<Object> pks = new ArrayList<Object>(2);
            pks.add(billId);
            try {
                String pdfUrl = null;
                if ("bei_elecstatement".equals(this.billType)) {
                    List urls = (List)elecUrlMap.get(billId);
                    FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
                    for (String tempurl : urls) {
                        tempurl = attachmentFileService.getFileServiceExt().getRealPath(tempurl);
                        billFileNameMap.computeIfAbsent(billId, value -> new ArrayList()).add(ElecreceiptUtils.getFileName((String)tempurl));
                        fpyUploadItem.setFileName(ElecreceiptUtils.getFileName((String)tempurl));
                        this.setAttachmentsRelatedInfo(fpyUploadItem, tempurl);
                        this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                    }
                } else {
                    billFileNameMap.computeIfAbsent(billId, value -> new ArrayList()).add(fileName);
                    if (StringUtils.isNotBlank((CharSequence)this.printSample)) {
                        pdfUrl = FileUtils.getPrintUrl(this.pageId, this.billType, this.printId, pks, "billForm", this.printType);
                    } else if (StringUtils.isNotBlank(this.billIdAndPrintIdMap.get(billId))) {
                        PrintIdandType printIdandType = (PrintIdandType)this.billIdAndPrintIdMap.get(billId);
                        pdfUrl = FileUtils.getPrintUrl(this.pageId, this.billType, printIdandType.getPrintId(), pks, "billForm", printIdandType.getPrintType());
                    } else {
                        needArchiveIds.remove(billId);
                        string = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u627e\u4e0d\u5230\u9002\u7528\u7684\u6253\u5370\u6a21\u677f\u3002", (String)"ArchiveCommonBillLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, row.getString(billnoField));
                        errDyns.add(LogUtil.generateArchiveErrorLog((String)this.billType, (Long)billId, (Long)Long.parseLong(this.schemeId), (String)this.isReverse, (String)TraceIdUtil.getCurrentTraceIdString(), (String)string));
                        continue;
                    }
                    this.setPrintFileRelatedInfo(fpyUploadItem, pdfUrl);
                    this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                }
            }
            catch (Exception e) {
                needArchiveIds.remove(billId);
                string = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u5957\u6253\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%3$s}", (String)"ArchiveCommonBillLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, billId, e.getMessage());
                errDyns.add(LogUtil.generateArchiveErrorLog((String)this.billType, (Long)billId, (Long)Long.parseLong(this.schemeId), (String)this.isReverse, (String)TraceIdUtil.getCurrentTraceIdString(), (String)string));
                logger.error(this.billName, (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                continue;
            }
            if ("1".equals(this.isNeedAttachFile)) {
                List<Attach> attaches = attachMap.get(billId);
                try {
                    if (attaches != null) {
                        for (Attach attach : attaches) {
                            String url = attach.getUrl();
                            fpyUploadItem.setFileName(billId + "_" + attach.getFileSize() + "_" + attach.getFileName());
                            fpyUploadItem.setBusinessType(BusinessTypeUtils.getBusinessType(this.billType, true));
                            this.setAttachmentsRelatedInfo(fpyUploadItem, url);
                            this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                        }
                    }
                }
                catch (IOException e) {
                    logger.error(String.format("IOException%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"IOException%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", (String)"ArchiveCommonBillByFpyLogicUnit_5", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                }
            }
            DynamicObject temp = SingleArchiveUtil.getArhieveRecordDynamicObject(this.billType, this.application, this.schemeId, row, this.userId, date, this.uploadway, "1", null, row.getDate("period"), null, this.batchCode);
            dynamicObjects.add(temp);
        }
        if (errDyns.size() > 0) {
            LogUtil.saveErrorLog(errDyns);
        }
        if (needArchiveIds.size() == 0) {
            this.context.setNeedArchiveIds(new HashSet());
            return;
        }
        this.context.setNeedArchiveIds(needArchiveIds);
        Map<String, Object> imageMap = this.getImgConfig(imageNumberMap);
        String xmlstr = "";
        try {
            xmlstr = CreateXmlUtil.createCommonBillXml(xmlSet, billFileNameMap, this.billName, attachMap, imageMap, this.billType, this.flag, filingIds, needArchiveIds);
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa%1$s\u7684\u5173\u8054\u5355\u636exml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684\u5173\u8054\u5355\u636exml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"ArchiveCommonBillByFpyLogicUnit_6", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        String desc = String.format(ResManager.loadKDString((String)"%s\u5355\u636e", (String)"ArchiveCommonBillByFpyLogicUnit_3", (String)"fi-aef-common", (Object[])new Object[0]), orgName + dateStr);
        fpyUploadItem.setFilebase64(xmlstr);
        fpyUploadItem.setBusinessType(BusinessTypeUtils.getBusinessType(this.billType, false));
        fpyUploadItem.setFileName(desc + this.batchCode + ".xml");
        fpyUploadItem.setBillidsMap(billidsMap);
        this.uploadFile(this.uploadUrl, fpyUploadItem, this.billName, CLASS_NAME, Boolean.TRUE);
        if ("1".equals(this.isReverse)) {
            this.saveDynamicObjects(CLASS_NAME, dynamicObjects, this.billName, this.ids, this.billType);
            this.saveArchieveconfig(this.billType, this.batchCode, this.isNeedAttachFile, null);
        } else {
            this.updateRecordToReserve(CLASS_NAME, this.ids, this.billType, this.context.getReverseReason(), this.batchCode);
            this.deleteArchieveconfig(this.billType, this.context.getBatchcode());
        }
        this.noticeArchive(this.uploadNoticeUrl, fpyUploadItem, this.billName, CLASS_NAME);
    }

    private Map<String, Object> getImgConfig(Map<String, Map<Long, List<String>>> imageNumberMap) {
        HashMap<String, Object> imageMap = new HashMap<String, Object>();
        QFilter imageFilter1 = new QFilter("number", "=", (Object)"FPY");
        DynamicObject imagedyo = BusinessDataServiceHelper.loadSingleFromCache((String)"bas_imageconfig", (String)"number,imagesystermip,imageport,enable", (QFilter[])new QFilter[]{imageFilter1});
        QFilter voiceFilter2 = new QFilter("client_id", "!=", (Object)"");
        if (QueryServiceHelper.exists((String)"er_bd_kdinvoicecloudcfg", (QFilter[])voiceFilter2.toArray()) || QueryServiceHelper.exists((String)"er_bd_kdinvoicecloudcfgct", (QFilter[])voiceFilter2.toArray())) {
            imageMap.put("enable", "A");
        }
        if (imagedyo != null) {
            imageMap.put("numbermap", imageNumberMap);
            imageMap.put("imagesystype", imagedyo.getString("number"));
            imageMap.put("imagesysip", imagedyo.getString("imagesystermip"));
            imageMap.put("imagesysport", imagedyo.getString("imageport"));
        }
        return imageMap;
    }

    private Map<Long, List<Attach>> getIdAndAttacheFiles(String billType, Set<Long> ids, String attachtabJson) {
        HashMap<Long, List<Attach>> map = new HashMap<Long, List<Attach>>();
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        if (StringUtils.isNotBlank((CharSequence)attachtabJson)) {
            Map attachtabmap = (Map)SerializationUtils.fromJsonString((String)attachtabJson, Map.class);
            qfilters.add(new QFilter("fattachmentpanel", "in", attachtabmap.keySet()));
        }
        qfilters.add(new QFilter("fbilltype", "=", (Object)billType));
        qfilters.add(new QFilter("finterid", "in", ids.parallelStream().map(x -> String.valueOf(x)).collect(Collectors.toSet())));
        String algoKey = "kd.fi.aef.common.util.SingleArchiveUtil.getIdAndAttaches";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_attachment", (String)"fextname,fbilltype,ffileid,finterid,fattachmentname", (QFilter[])qfilters.toArray(new QFilter[0]), (String)"finterid");){
            for (Row row : dataSet) {
                Long id = row.getLong("finterid");
                Attach attach = new Attach();
                attach.setBillId(row.getString("finterid"));
                attach.setBillType(billType);
                attach.setExtName(row.getString("fextname"));
                attach.setFileName(row.getString("fattachmentname"));
                attach.setUrl(row.getString("ffileid"));
                if (map.containsKey(id)) {
                    ((List)map.get(id)).add(attach);
                    continue;
                }
                ArrayList<Attach> list = new ArrayList<Attach>();
                list.add(attach);
                map.put(id, list);
            }
        }
        return map;
    }
}

