/*
 * Decompiled with CFR 0.152.
 */
package fi.aef.opplugin;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.fa.business.util.FiBillParamUtil;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.cache.CacheHelper;
import kd.fi.aef.cache.CacheModule;
import kd.fi.aef.cache.DistributeCache;
import kd.fi.aef.common.ArchivePageEngin;
import kd.fi.aef.common.util.ArchiveUtil;
import kd.fi.aef.common.util.ContextUtil;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.JudgeBillType;
import kd.fi.aef.common.util.JudgePageUtil;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.SplitDataUtil;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.entity.ArchiveResult;
import kd.fi.aef.entity.PrintTemplate;
import kd.fi.aef.entity.Printsample;
import kd.fi.aef.entity.SchemeEntry;
import kd.fi.aef.logic.engine.ArchiveEngineImpl;
import kd.fi.bd.util.PeriodUtil;
import org.apache.commons.io.FilenameUtils;

public class ArchiveOpService
extends EntityOperateService {
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.archive);
    private static final int threadSize = 5;
    private static final String ARCHIVE_MUTEX_KEY = "archiveMutexKey";
    private static final ThreadPool threadPoolCash;
    private static final Log logger;

    protected void preparePropertys(List<String> fieldKeys) {
        super.preparePropertys(fieldKeys);
        fieldKeys.add("name");
        fieldKeys.add("org");
        fieldKeys.add("enable");
        fieldKeys.add("archivetype");
        fieldKeys.add("entryentity");
        fieldKeys.add("entryentity.billtype");
        fieldKeys.add("entryentity.archivetype");
        fieldKeys.add("entryentity.archiverange");
        fieldKeys.add("entryentity.isneedattachfile");
        fieldKeys.add("entryentity.archiveperiod");
        fieldKeys.add("entryentity.printsampleid");
        fieldKeys.add("entryentity.largesamplejson");
        fieldKeys.add("entryentity.largesamplejson_tag");
        fieldKeys.add("entryentity.datefield");
    }

    protected void executeOperate(DynamicObject[] dynamicObjects) {
        String message;
        OperateOption option = this.getOption();
        String pageId = null;
        if (JudgePageUtil.isFromArchievePage((OperateOption)option)) {
            pageId = option.getVariableValue("pageId");
        }
        if (!StringUtils.isEmpty((CharSequence)(message = ArchiveUtil.getServerConfig((OperateOption)option)))) {
            if (JudgePageUtil.isFromIntellexec((OperateOption)option)) {
                this.addErrorInfo(message);
                return;
            }
            if (JudgePageUtil.isFromArchievePage((OperateOption)option)) {
                this.createCaheInfo(pageId, true, false, message);
                return;
            }
            throw new KDBizException(message);
        }
        if (JudgePageUtil.isFromArchievePage((OperateOption)option) || JudgePageUtil.isFromMergeRptArchivePage((OperateOption)option)) {
            try {
                this.archieveFromArchievePage(option, pageId);
            }
            catch (Exception e) {
                String string = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                logger.error(string);
                throw new KDBizException(string);
            }
        } else {
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (!dynamicObject.getBoolean("enable")) continue;
                boolean isFa = this.isFa(dynamicObject);
                option.setVariableValue("isFa", isFa + "");
                pageId = DBServiceHelper.genStringId();
                this.buildOption(option, dynamicObject);
                Long pk = Long.valueOf(option.getVariableValue("gl_intellexecschema"));
                DynamicObject intelScheme = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"gl_intellexecschema");
                if (intelScheme == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u667a\u80fd\u6838\u7b97\u8c03\u5ea6\u65b9\u6848\u3002", (String)"ArchiveOpService_0", (String)"fi-aef-opplugin", (Object[])new Object[0]));
                }
                DynamicObjectCollection orgls = (DynamicObjectCollection)intelScheme.get("orgentryentity");
                if (orgls == null || orgls.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u667a\u80fd\u6838\u7b97\u8c03\u5ea6\u7ec4\u7ec7\u3002", (String)"ArchiveOpService_1", (String)"fi-aef-opplugin", (Object[])new Object[0]));
                }
                HasPermOrgResult resutlt = PermissionServiceHelper.getUserHasPermOrgs((long)ContextUtil.getUserId());
                if (!resutlt.hasAllOrgPerm()) {
                    HasPermOrgResult resutlt1 = PermissionServiceHelper.getAllPermOrgs((long)ContextUtil.getUserId(), (String)"15", (String)"aef", (String)"aef_archive", (String)"/=N=NAA4+3V2");
                    for (DynamicObject dynamicObject2 : orgls) {
                        if (resutlt1.getHasPermOrgs().contains(dynamicObject2.getLong("orgid.id"))) continue;
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u65e0\u6743\u9650\u3002", (String)"ArchiveOpService_2", (String)"fi-aef-opplugin", (Object[])new Object[0]), dynamicObject2.getString("orgid.name")));
                    }
                }
                for (DynamicObject dynamicObject2 : orgls) {
                    option.setVariableValue("org", dynamicObject2.getString("orgid.id"));
                    option.setVariableValue("pageId", pageId);
                    this.archieveFromArchievePage(option, pageId);
                }
            }
        }
    }

    private void buildOption(OperateOption option, DynamicObject archiveScheme) {
        option.setVariableValue("archiveplan", archiveScheme.getString("id"));
        String archivetype = archiveScheme.getString("archivetype");
        option.setVariableValue("archivetype", archivetype);
        DynamicObjectCollection archiveSchemeEntry = archiveScheme.getDynamicObjectCollection("entryentity");
        for (DynamicObject dyn : archiveSchemeEntry) {
            String billTypeNumber = dyn.getString("billtype.number");
            if (!StringUtils.isNotBlank((CharSequence)billTypeNumber)) continue;
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billTypeNumber);
            String appId = dataEntityType.getAppId();
            option.setVariableValue("app_id", appId);
            break;
        }
    }

    private void archieveFromArchievePage(OperateOption option, String pageId) {
        String filePath;
        String orgUnionCode;
        Map result;
        List schemes;
        ArrayList<Future> resultList = new ArrayList<Future>(16);
        if (option.containsVariable("mergeRptArchivePage")) {
            pageId = option.getVariableValue("pageId");
            schemes = this.buildSchemesByMergeRpt(option);
            boolean isMergeRptArchiveCheckAuth = SysParamConfig.getBoolean((String)"isMergeRptArchiveCheckAuth", (boolean)false);
            option.setVariableValue("isMergeRptArchiveCheckAuth", Boolean.toString(isMergeRptArchiveCheckAuth));
        } else {
            DynamicObject schemeDynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(option.getVariableValue("archiveplan")), (String)"aef_archivescheme");
            DynamicObjectCollection archiveSchemeEntry = schemeDynamicObject.getDynamicObjectCollection("entryentity");
            boolean isSupportGeneralledgerNew = SysParamConfig.getBoolean((String)"support_gl_rpt_generalledger_new", (boolean)false);
            option.setVariableValue("support_gl_rpt_generalledger_new", Boolean.toString(isSupportGeneralledgerNew));
            if (schemeDynamicObject.getBoolean("isxbrlpilot")) {
                option.setVariableValue("isxbrlpilot", "1");
            } else if (SysParamConfig.getBoolean((String)"exportvat", (boolean)false)) {
                pageId = option.getVariableValue("pageId");
                this.cache.put(pageId + "isFinish", Boolean.TRUE.toString());
                this.cache.put(pageId + "isSuccess", Boolean.FALSE.toString());
                this.cache.put(pageId + "errorMsg", ResManager.loadKDString((String)"\u5b9e\u65f6\u5bfc\u51fa\u53ea\u80fd\u9009\u62e9\u7535\u5b50\u51ed\u8bc1\u8bd5\u70b9\u65b9\u6848\u3002", (String)"ArchiveOpService_12", (String)"fi-aef-opplugin", (Object[])new Object[0]));
                throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u65f6\u5bfc\u51fa\u53ea\u80fd\u9009\u62e9\u7535\u5b50\u51ed\u8bc1\u8bd5\u70b9\u65b9\u6848\u3002", (String)"ArchiveOpService_12", (String)"fi-aef-opplugin", (Object[])new Object[0]));
            }
            try {
                schemes = this.buildSchemes(archiveSchemeEntry, option);
                schemes = SplitDataUtil.splitData(schemes, (OperateOption)option);
            }
            catch (Exception e) {
                pageId = option.getVariableValue("pageId");
                this.cache.put(pageId + "isFinish", Boolean.TRUE.toString());
                this.cache.put(pageId + "isSuccess", Boolean.FALSE.toString());
                logger.error("\u5207\u5206\u5f52\u6863\u65b9\u6848\u5931\u8d25", (Throwable)e);
                this.cache.put(pageId + "errorMsg", String.format(ResManager.loadKDString((String)"\u5207\u5206\u5f52\u6863\u65b9\u6848\u5931\u8d25\uff1a%s", (String)"ArchiveOpService_10", (String)"fi-aef-opplugin", (Object[])new Object[0]), e.getMessage()));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5207\u5206\u5f52\u6863\u65b9\u6848\u5931\u8d25\uff1a%s", (String)"ArchiveOpService_10", (String)"fi-aef-opplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
        logger.info("schemes.size :{}", (Object)schemes.size());
        if (schemes.isEmpty()) {
            pageId = option.getVariableValue("pageId");
            this.cache.put(pageId + "isFinish", Boolean.TRUE.toString());
            this.cache.put(pageId + "isSuccess", Boolean.FALSE.toString());
            return;
        }
        int allcount = 0;
        for (SchemeEntry scheme : schemes) {
            String billType = scheme.getBillType();
            if (JudgeBillType.isFinaceRpt((String)billType)) {
                ++allcount;
                continue;
            }
            if (JudgeBillType.isRptFrom((String)billType)) continue;
            allcount += scheme.getIds().size();
            if (!"tax".equals(option.getVariableValue("archivetype")) || !scheme.getBillType().equals("tcvat_nsrxx")) continue;
            ++allcount;
        }
        logger.info("allcount :{}", (Object)allcount);
        this.cache.put(pageId + "allcount", allcount + "");
        option.setVariableValue("isReverse", "1");
        option.setVariableValue("traceId", TraceIdUtil.getCurrentTraceIdString());
        this.getIsSplitBookParam(option);
        boolean isSupport = SysParamConfig.getBoolean((String)"support_fi_archive_new", (boolean)true);
        boolean enablePlatformThreadPool = FiBillParamUtil.getBooleanValue((String)"83bfebc8000002ac", (String)"/T89/HOQNVSV", (String)"enableplatformthreadpool", null);
        long schemeId = ((SchemeEntry)schemes.get(0)).getSchemeId();
        DLock dLock = this.requireMutexFromDLock(option, schemeId);
        if (Objects.isNull(dLock)) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5f52\u6863\u7684\u6570\u636e\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AbstractArchiveLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]);
            this.cache.put(pageId + "errorMsg", message);
            throw new KDBizException(message);
        }
        for (Object scheme : schemes) {
            Future future = isSupport && !SysParamConfig.getBoolean((String)"exportvat", (boolean)false) ? (enablePlatformThreadPool ? ThreadService.submit((Callable)new ArchiveEngineImpl((SchemeEntry)scheme, option), (TaskType)TaskType.AEF_ARCHIVE_TASK) : threadPoolCash.submit((Callable)new ArchiveEngineImpl((SchemeEntry)scheme, option))) : (enablePlatformThreadPool ? ThreadService.submit((Callable)new ArchivePageEngin((SchemeEntry)scheme, option), (TaskType)TaskType.AEF_ARCHIVE_TASK) : threadPoolCash.submit((Callable)new ArchivePageEngin((SchemeEntry)scheme, option)));
            resultList.add(future);
        }
        if (JudgePageUtil.isFromIntellexec((OperateOption)option)) {
            this.cache.remove(pageId + "isFinish");
            this.cache.remove(pageId + "isSuccess");
            this.cache.remove(pageId + "hasarchievecount");
            this.cache.remove(pageId + "allcount");
            this.cache.remove(pageId + "errorMsg");
            this.cache.remove(pageId + "finishedBill");
        }
        this.getOperationResult().setSuccess(true);
        int successPkIdsSize = 0;
        for (Future taskResult : resultList) {
            try {
                if (!((ArchiveResult)taskResult.get()).getIsSuccess().booleanValue()) {
                    this.getOperationResult().setSuccess(false);
                }
                successPkIdsSize += ((ArchiveResult)taskResult.get()).getSuccessPkIds().size();
            }
            catch (Exception exception) {}
        }
        dLock.unlock();
        this.cache.put(pageId + "hasarchievecount", successPkIdsSize + "");
        if (SysParamConfig.getBoolean((String)"exportvat", (boolean)false) && !(result = FileUtils.exportNew((String)(orgUnionCode = this.cache.get(pageId + "orgUnionCode")))).isEmpty() && StringUtils.isNotBlank((CharSequence)(filePath = (String)result.get("fileName")))) {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(FilenameUtils.getFullPath((String)filePath) + FilenameUtils.getName((String)filePath)));){
                String url = FileUtils.saveAsUrl((InputStream)in, (String)("receiver_" + orgUnionCode + "_" + System.currentTimeMillis() + ".zip"));
                this.cache.put(pageId + "exporturl", url);
            }
            catch (IOException e) {
                throw new KDBizException(e.getMessage());
            }
            finally {
                FileUtils.deleteFile((String)filePath);
            }
        }
    }

    private DLock requireMutexFromDLock(OperateOption option, long schemeId) {
        ArrayList<DynamicObject> errDynObjList = new ArrayList<DynamicObject>(1);
        String archiveType = option.getVariableValue("archivetype");
        String uniqueKey = this.getLockKey(option, archiveType, schemeId);
        DLock dLock = DLock.create((String)uniqueKey).fastMode();
        if (dLock.tryLock()) {
            logger.info("\u83b7\u53d6\u5230\u4e86\u9501\uff1a{}", (Object)uniqueKey);
            return dLock;
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u5f52\u6863\u7c7b\u578b\uff1a%1$s\uff0c\u83b7\u53d6\u9501\u5931\u8d25\uff1a%2$s\u3002", (String)"ArchiveOpService_17", (String)"fi-aef-opplugin", (Object[])new Object[0]), archiveType, uniqueKey);
        errDynObjList.add(LogUtil.generateArchiveErrorLog((String)"", (Long)0L, (Long)schemeId, (String)"1", (String)"", (String)errorMsg));
        logger.error("\u83b7\u53d6\u4e0d\u5230\u9501\uff1a{}", (Object)uniqueKey);
        if (CollectionUtils.isNotEmpty(errDynObjList)) {
            try (TXHandle tx = TX.requiresNew((String)"ArchiveOpService");){
                try {
                    LogUtil.saveErrorLog(errDynObjList);
                }
                catch (Exception e) {
                    tx.markRollback();
                }
            }
        }
        return null;
    }

    private String getLockKey(OperateOption option, String archiveType, long schemeId) {
        String uniqueKey = "";
        if ("finance".equals(archiveType)) {
            boolean isFa = Boolean.parseBoolean(option.getVariableValue("isFa"));
            long orgId = Long.parseLong(option.getVariableValue("org"));
            if (isFa) {
                String depreUseId = option.getVariableValue("fadepreuse");
                uniqueKey = archiveType + ":" + orgId + ":" + depreUseId;
            } else {
                String bookType = "";
                if (option.containsVariable("booktype")) {
                    bookType = option.getVariableValue("booktype");
                }
                uniqueKey = !"".equals(bookType) ? archiveType + ":" + orgId + ":" + bookType : archiveType + ":" + orgId;
            }
        } else if ("bill".equals(archiveType)) {
            long orgId = Long.parseLong(option.getVariableValue("org"));
            uniqueKey = archiveType + ":" + orgId;
        } else if ("reportform".equals(archiveType)) {
            String bcmScene = "";
            if (option.containsVariable("bcmscene")) {
                bcmScene = option.getVariableValue("bcmscene");
            }
            String bcmFy = "";
            if (option.containsVariable("bcmfy")) {
                bcmFy = option.getVariableValue("bcmfy");
            }
            uniqueKey = archiveType + ":" + schemeId + ":" + bcmScene + ":" + bcmFy;
        } else if ("tax".equals(archiveType)) {
            String org = option.getVariableValue("org");
            uniqueKey = archiveType + ":" + org;
        }
        return "archiveMutexKey:" + uniqueKey;
    }

    private void getIsSplitBookParam(OperateOption option) {
        boolean issplitbookstr = SysParamConfig.getBoolean((String)"issplitbook", (boolean)true);
        option.setVariableValue("issplitbook", Boolean.toString(issplitbookstr));
    }

    private List<SchemeEntry> buildSchemes(DynamicObjectCollection archiveSchemeEntry, OperateOption option) {
        ArrayList<SchemeEntry> schemes = new ArrayList<SchemeEntry>();
        if ("reportform".equals(option.getVariableValue("archivetype"))) {
            if (JudgePageUtil.isFromIntellexec((OperateOption)option)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5408\u5e76\u62a5\u8868\u667a\u80fd\u65b9\u6848\u5f52\u6863", (String)"ArchiveOpService_13", (String)"fi-aef-opplugin", (Object[])new Object[0]));
            }
            boolean isMergeRptArchiveCheckAuth = SysParamConfig.getBoolean((String)"isMergeRptArchiveCheckAuth", (boolean)false);
            option.setVariableValue("isMergeRptArchiveCheckAuth", Boolean.toString(isMergeRptArchiveCheckAuth));
            for (DynamicObject scheme : archiveSchemeEntry) {
                SchemeEntry entry = new SchemeEntry();
                entry.setSchemeId(Long.parseLong(((DynamicObject)scheme.getParent()).getPkValue() + ""));
                entry.setPageId(option.getVariableValue("pageId"));
                entry.setUploadWay(option.getVariableValue("uploadway"));
                entry.setArchiverange(scheme.getString("largesamplejson_tag"));
                entry.setBillType("aef_rpt");
                schemes.add(entry);
            }
            return schemes;
        }
        Map<String, Integer> templateStatusMap = this.getTemplateStatusMap(archiveSchemeEntry);
        LogUtil.printLog((Log)logger, (String)ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\u6240\u6709\u5206\u5f55\u6a21\u677f\u4e3a\uff1a{}", (String)"ArchiveOpService_14", (String)"fi-aef-opplugin", (Object[])new Object[0]), (Object[])new Object[]{templateStatusMap});
        HashSet<String> noTemplatebill = new HashSet<String>();
        for (DynamicObject scheme : archiveSchemeEntry) {
            SchemeEntry entry = new SchemeEntry();
            String printsampleId = scheme.getString("printsampleid");
            String printtemplate_tag = scheme.getString("printtemplate_tag");
            List<Object> templatenumbers = new ArrayList(2);
            List<Object> templateList = new ArrayList(2);
            if (StringUtils.isNotBlank((CharSequence)printtemplate_tag)) {
                templateList = SerializationUtils.fromJsonStringToList((String)printtemplate_tag, PrintTemplate.class);
                if ((templateList = templateList.stream().filter(template -> templateStatusMap.containsKey(template.getTemplateNumber())).collect(Collectors.toList())).size() > 0) {
                    for (PrintTemplate printTemplate : templateList) {
                        printTemplate.setPrintType(templateStatusMap.get(printTemplate.getTemplateNumber()).intValue());
                    }
                }
                templatenumbers = templateList.stream().map(PrintTemplate::getTemplateNumber).collect(Collectors.toList());
                entry.setPrintTemplatetag(SerializationUtils.toJsonString(templateList));
            }
            String billType = scheme.getString("billtype.number");
            String string = option.getVariableValue("archivetype");
            if ("tax".equals(string)) {
                this.buildTaxEntry(entry, option, scheme, templateStatusMap, noTemplatebill);
                schemes.add(entry);
                continue;
            }
            if (option.containsVariable("isxbrlpilot") && "bei_elecstatement".equals(billType)) {
                entry.setBillType(billType);
                MainEntityType bet = EntityMetadataCache.getDataEntityType((String)billType);
                String appid = AppMetadataCache.getAppInfo((String)bet.getAppId()).getId();
                entry.setOrgId(Long.parseLong(option.getVariableValue("org")));
                entry.setApplicationId(appid);
                this.buildElecEntry(entry, option, scheme);
                schemes.add(entry);
                continue;
            }
            Set<String> allTemplateNumbers = templateStatusMap.keySet();
            templatenumbers.retainAll(allTemplateNumbers);
            if (templateStatusMap.containsKey(printsampleId) || templatenumbers.size() > 0) {
                String largesamplejson_tag;
                entry.setBillType(billType);
                MainEntityType bet = EntityMetadataCache.getDataEntityType((String)billType);
                String applicationId = AppMetadataCache.getAppInfo((String)bet.getAppId()).getId();
                entry.setOrgId(Long.parseLong(option.getVariableValue("org")));
                entry.setApplicationId(applicationId);
                entry.setSchemeId(Long.parseLong(((DynamicObject)scheme.getParent()).getPkValue() + ""));
                entry.setPrintsampleId(printsampleId);
                if (StringUtils.isNotBlank((CharSequence)printsampleId)) {
                    entry.setPrintType(templateStatusMap.get(printsampleId).intValue());
                }
                entry.setArchieveAttach(scheme.getString("isneedattachfile"));
                entry.setAttachtabJson(scheme.getString("attachtabJson"));
                entry.setPageId(option.getVariableValue("pageId"));
                entry.setUploadWay(option.getVariableValue("uploadway"));
                if ("bill".equals(option.getVariableValue("archivetype"))) {
                    entry.setDateField(scheme.getString("datefield"));
                    entry.setArchiverange(scheme.getString("archiverangejson"));
                }
                if ("gl_voucher".equals(billType) && !StringUtils.isEmpty((CharSequence)(largesamplejson_tag = scheme.getString("largesamplejson_tag")))) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    HashMap<String, Printsample> refBillInfoMap = new HashMap<String, Printsample>(16);
                    List list = SerializationUtils.fromJsonStringToList((String)largesamplejson_tag, Printsample.class);
                    for (Printsample printsample : list) {
                        map.put(printsample.getBillType(), printsample.getRefbillsampleid());
                        refBillInfoMap.put(printsample.getBillType(), printsample);
                    }
                    entry.setRefBillTempInfo(map);
                    entry.setRefBillAllInfo(refBillInfoMap);
                }
                if (JudgePageUtil.isFromIntellexec((OperateOption)option)) {
                    String aiRange = scheme.getString("aiarchive");
                    this.bulidAiOption(option, aiRange, string, billType);
                    if ("finance".equals(string)) {
                        entry.setPeriodId(Long.parseLong(option.getVariableValue("startperiod")));
                    }
                    if ("bill".equals(string)) {
                        HashMap<Date, Date> intelldateMap = new HashMap<Date, Date>(2);
                        Date startDate = DateUtil.stringToDate((String)option.getVariableValue("startdate"), (String)"yyyy-MM-dd");
                        Date endDate = DateUtil.stringToDate((String)option.getVariableValue("enddate"), (String)"yyyy-MM-dd");
                        endDate = DateUtil.stringToDate((String)(option.getVariableValue("enddate") + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
                        intelldateMap.put(startDate, endDate);
                        entry.setIntelldateJson(SerializationUtils.serializeToBase64(intelldateMap));
                    }
                }
                schemes.add(entry);
                continue;
            }
            noTemplatebill.add(billType);
        }
        if (!noTemplatebill.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String s : noTemplatebill) {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)s);
                sb.append(type.getDisplayName()).append(',');
            }
            if (JudgePageUtil.isFromIntellexec((OperateOption)option)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u53ef\u7528\u6a21\u677f\u3002", (String)"ArchiveOpService_3", (String)"fi-aef-opplugin", (Object[])new Object[0]), sb.substring(0, sb.length() - 1)));
            }
            this.cache.put(option.getVariableValue("pageId") + "nothavetemplate", String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u53ef\u7528\u6a21\u677f\u3002", (String)"ArchiveOpService_3", (String)"fi-aef-opplugin", (Object[])new Object[0]), sb.substring(0, sb.length() - 1)));
        }
        return schemes;
    }

    private Map<String, Integer> getTemplateStatusMap(DynamicObjectCollection archiveSchemeEntry) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ArrayList<String> allList = new ArrayList<String>();
        for (DynamicObject schemeEntry : archiveSchemeEntry) {
            String printFormId = schemeEntry.getString("printsampleid");
            String printtemplate_tag = schemeEntry.getString("printtemplate_tag");
            if (StringUtils.isNotBlank((CharSequence)printFormId)) {
                allList.add(printFormId);
            }
            if (!StringUtils.isNotBlank((CharSequence)printtemplate_tag)) continue;
            List templateList = SerializationUtils.fromJsonStringToList((String)printtemplate_tag, PrintTemplate.class);
            List templatenumbers = templateList.stream().map(PrintTemplate::getTemplateNumber).collect(Collectors.toList());
            allList.addAll(templatenumbers);
        }
        ArrayList<String> oldList = new ArrayList<String>();
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter1 = new QFilter("printtplid.number", "in", allList);
        DynamicObjectCollection printsamples = QueryServiceHelper.query((String)"bas_manageprinttpl", (String)"printtplid.number,enable", (QFilter[])new QFilter[]{qFilter, qFilter1});
        for (DynamicObject printsample : printsamples) {
            oldList.add(printsample.getString("printtplid.number"));
            map.put(printsample.getString("printtplid.number"), 1);
        }
        allList.removeAll(oldList);
        QFilter qFilter2 = new QFilter("printtplid.number", "in", allList);
        DynamicObjectCollection newPrintsamples = QueryServiceHelper.query((String)"bos_manageprinttpl", (String)"printtplid.number,enable", (QFilter[])new QFilter[]{qFilter, qFilter2});
        for (DynamicObject printsample : newPrintsamples) {
            if (map.containsKey(printsample.getString("printtplid.number"))) continue;
            map.put(printsample.getString("printtplid.number"), 2);
        }
        return map;
    }

    private void createCaheInfo(String pageId, boolean isFinish, boolean isSuccess, String msg) {
        this.cache.put(pageId + "isFinish", String.valueOf(isFinish));
        this.cache.put(pageId + "isSuccess", String.valueOf(isSuccess));
        if (!isSuccess) {
            this.cache.put(pageId + "errorMsg", msg);
        }
        this.getOperationResult().setSuccess(false);
    }

    private void addErrorInfo(String str) {
        OperateErrorInfo temp = new OperateErrorInfo(str, ErrorLevel.FatalError, (Object)0);
        temp.setMessage(str);
        temp.setTitle(str);
        OperationResult res = this.getOperationResult();
        res.addErrorInfo(temp);
    }

    private void bulidAiOption(OperateOption option, String aiRange, String archiveType, String billType) {
        long orgId = Long.parseLong(option.getVariableValue("org"));
        boolean isControlPeriodSelect = SysParamConfig.getBoolean((String)"controlperiodselect", (boolean)true);
        switch (archiveType) {
            case "finance": {
                if ("fa_card_fin".equals(billType)) {
                    this.setFa(orgId, aiRange, option, isControlPeriodSelect);
                    break;
                }
                String appId = option.getVariableValue("app_id");
                if ("gl".equals(appId)) {
                    Long booktypeId = this.getBook(orgId);
                    option.setVariableValue("booktype", booktypeId.toString());
                    this.setPeriod4Gl(orgId, booktypeId, aiRange, option, isControlPeriodSelect);
                    break;
                }
                if (!"cas".equals(appId)) break;
                this.setPeriod4Cas(option, aiRange, orgId, isControlPeriodSelect);
                break;
            }
            case "bill": {
                if ("2".equals(aiRange)) {
                    option.setVariableValue("startdate", DateUtil.getBBeforeFirstMonthdate());
                    option.setVariableValue("enddate", DateUtil.getBBeforeLastMonthdate());
                    break;
                }
                option.setVariableValue("startdate", DateUtil.getBeforeFirstMonthdate());
                option.setVariableValue("enddate", DateUtil.getBeforeLastMonthdate());
                break;
            }
            case "reportform": {
                throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5408\u5e76\u62a5\u8868\u667a\u80fd\u65b9\u6848\u5f52\u6863", (String)"ArchiveOpService_13", (String)"fi-aef-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setPeriod4Cas(OperateOption option, String aiRange, long orgId, boolean isControlPeriodSelect) {
        QFilter isFinishInitQFilter;
        QFilter orgQFilter = new QFilter("org", "=", (Object)orgId);
        DynamicObject bookDynObj = QueryServiceHelper.queryOne((String)"cas_cashmgtinit", (String)"startperiod, currentperiod, periodtype", (QFilter[])new QFilter[]{orgQFilter, isFinishInitQFilter = new QFilter("isfinishinit", "=", (Object)Boolean.TRUE)});
        if (Objects.nonNull(bookDynObj) && bookDynObj.getLong("currentperiod") != 0L && bookDynObj.getLong("currentperiod") != bookDynObj.getLong("startperiod")) {
            DynamicObject beforePeriod;
            if (isControlPeriodSelect) {
                beforePeriod = this.getPreviousPeriod(bookDynObj.get("currentperiod"), false);
            } else {
                DynamicObject currentperiod = PeriodUtil.getPeriodByDate((Date)new Date(), (long)bookDynObj.getLong("periodtype"));
                beforePeriod = this.getPreviousPeriod(currentperiod.getLong("id"), false);
            }
            if (Objects.nonNull(beforePeriod)) {
                if ("1".equals(aiRange)) {
                    option.setVariableValue("startperiod", beforePeriod.getString("id"));
                    option.setVariableValue("endperiod", beforePeriod.getString("id"));
                }
                if ("2".equals(aiRange)) {
                    DynamicObject bbeforeperiod = this.getPreviousPeriod(beforePeriod.getLong("id"), false);
                    if (bbeforeperiod != null) {
                        option.setVariableValue("startperiod", bbeforeperiod.getString("id"));
                        option.setVariableValue("endperiod", bbeforeperiod.getString("id"));
                    } else {
                        option.setVariableValue("startperiod", "0");
                        option.setVariableValue("endperiod", "0");
                    }
                }
            } else {
                option.setVariableValue("startperiod", "0");
                option.setVariableValue("endperiod", "0");
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8d26\u7c3f\u6682\u65e0\u9700\u8981\u5f52\u6863\u7684\u6570\u636e\u3002", (String)"ArchiveEdit_32", (String)"fi-aef-formplugin", (Object[])new Object[0]));
        }
    }

    private long getBook(long orgid) {
        QFilter orgF = new QFilter("org", "=", (Object)orgid);
        DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype.id,bookstype.name, bookstype.accounttype", (QFilter[])new QFilter[]{orgF});
        if (books != null && books.size() > 0) {
            HashMap<String, Long> bookMap = new HashMap<String, Long>(16);
            for (DynamicObject dynamicObject : books) {
                if (!"1".equals(dynamicObject.getString("bookstype.accounttype"))) continue;
                bookMap.put("mainbook", dynamicObject.getLong("bookstype.id"));
            }
            if (bookMap.containsKey("mainbook")) {
                return (Long)bookMap.get("mainbook");
            }
            return ((DynamicObject)books.get(0)).getLong("bookstype.id");
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"orgid:%s,\u6ca1\u6709\u53ef\u6267\u884c\u7684\u5f52\u6863\u7684\u8d26\u7c3f\u3002", (String)"ArchiveOpService_7", (String)"fi-aef-opplugin", (Object[])new Object[0]), orgid));
    }

    private List<SchemeEntry> buildSchemesByMergeRpt(OperateOption option) {
        ArrayList<SchemeEntry> schemes = new ArrayList<SchemeEntry>();
        SchemeEntry entry = new SchemeEntry();
        entry.setPageId(option.getVariableValue("pageId"));
        entry.setUploadWay(option.getVariableValue("uploadway"));
        entry.setArchiverange(option.getVariableValue("mergeRptArchiveRangeJsonInfo"));
        entry.setBillType("aef_rpt");
        schemes.add(entry);
        return schemes;
    }

    private void setFa(long orgid, String aiRange, OperateOption option, boolean isControlPeriodSelect) {
        QFilter orgF2;
        QFilter orgF = new QFilter("org", "=", (Object)orgid);
        DynamicObject[] assetbooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,depreuse,curperiod,startperiod,periodtype", (QFilter[])new QFilter[]{orgF, orgF2 = new QFilter("enable", "=", (Object)"1")});
        if (assetbooks.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u8d44\u4ea7\u8d26\u7c3f\u6682\u65e0\u9700\u8981\u5f52\u6863\u7684\u6570\u636e\u3002", (String)"ArchiveOpService_15", (String)"fi-aef-opplugin", (Object[])new Object[0]));
        }
        DynamicObject beforeperiod = null;
        for (DynamicObject dynamicObject : assetbooks) {
            if (!ResManager.loadKDString((String)"\u8d26\u9762\u6298\u65e7", (String)"ArchiveOpService_11", (String)"fi-aef-opplugin", (Object[])new Object[0]).equals(dynamicObject.getString("depreuse.name")) || dynamicObject.getLong("curperiod_id") == 0L || dynamicObject.getLong("curperiod_id") == dynamicObject.getLong("startperiod_id")) continue;
            option.setVariableValue("fadepreuse", dynamicObject.getString("depreuse_id"));
            if (isControlPeriodSelect) {
                beforeperiod = this.getPreviousPeriod(dynamicObject.get("curperiod_id"), false);
                break;
            }
            DynamicObject curperiod = PeriodUtil.getPeriodByDate((Date)new Date(), (long)dynamicObject.getLong("periodtype_id"));
            beforeperiod = this.getPreviousPeriod(curperiod.getLong("id"), false);
            break;
        }
        if (!option.containsVariable("fadepreuse")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u8d44\u4ea7\u8d26\u7c3f\u6682\u65e0\u8d26\u9762\u6298\u65e7\u7684\u6570\u636e\u3002", (String)"ArchiveOpService_16", (String)"fi-aef-opplugin", (Object[])new Object[0]));
        }
        if (beforeperiod != null) {
            if ("2".equals(aiRange)) {
                DynamicObject bbeforeperiod = this.getPreviousPeriod(beforeperiod.getLong("id"), false);
                if (bbeforeperiod != null) {
                    option.setVariableValue("startperiod", bbeforeperiod.getString("id"));
                    option.setVariableValue("endperiod", bbeforeperiod.getString("id"));
                } else {
                    option.setVariableValue("startperiod", "0");
                    option.setVariableValue("endperiod", "0");
                }
            } else {
                option.setVariableValue("startperiod", beforeperiod.getString("id"));
                option.setVariableValue("endperiod", beforeperiod.getString("id"));
            }
        } else {
            option.setVariableValue("startperiod", "0");
            option.setVariableValue("endperiod", "0");
        }
    }

    private DynamicObject getPreviousPeriod(Object curPeriodId, boolean isContainAdjustPeriod) {
        if (curPeriodId == null) {
            return null;
        }
        try {
            String entityName = "bd_period";
            String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate,isadjustperiod";
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (String)entityName);
            Object periodtypeid = currPeriod.get("periodtype_id");
            QFilter filterDate = new QFilter("id", "<", curPeriodId);
            QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType}, (String)"id desc", (int)1);
            if (coll == null || coll.isEmpty()) {
                return null;
            }
            DynamicObject dynamicObject = (DynamicObject)coll.get(0);
            if (isContainAdjustPeriod) {
                return dynamicObject;
            }
            if (dynamicObject.getBoolean("isadjustperiod")) {
                return null;
            }
            return dynamicObject;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setPeriod4Gl(long orgId, long booktypeId, String aiRange, OperateOption option, boolean isControlPeriodSelect) {
        QFilter typeB;
        QFilter orgF = new QFilter("org", "=", (Object)orgId);
        DynamicObject bookDyo = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id,curperiod,periodtype,startperiod", (QFilter[])new QFilter[]{orgF, typeB = new QFilter("bookstype", "=", (Object)booktypeId)});
        if (bookDyo != null && bookDyo.getLong("curperiod") != 0L && bookDyo.getLong("curperiod") != bookDyo.getLong("startperiod")) {
            DynamicObject beforeperiod;
            if (isControlPeriodSelect) {
                beforeperiod = this.getPreviousPeriod(bookDyo.get("curperiod"), true);
            } else {
                DynamicObject curperiod = PeriodUtil.getPeriodByDate((Date)new Date(), (long)bookDyo.getLong("periodtype"));
                beforeperiod = this.getPreviousPeriod(curperiod.getLong("id"), true);
            }
            if (beforeperiod != null) {
                if ("2".equals(aiRange)) {
                    DynamicObject bbeforeperiod = this.getPreviousPeriod(beforeperiod.getLong("id"), true);
                    if (bbeforeperiod != null) {
                        option.setVariableValue("startperiod", bbeforeperiod.getString("id"));
                        option.setVariableValue("endperiod", bbeforeperiod.getString("id"));
                    } else {
                        option.setVariableValue("startperiod", "0");
                        option.setVariableValue("endperiod", "0");
                    }
                } else {
                    option.setVariableValue("startperiod", beforeperiod.getString("id"));
                    option.setVariableValue("endperiod", beforeperiod.getString("id"));
                }
            } else {
                option.setVariableValue("startperiod", "0");
                option.setVariableValue("endperiod", "0");
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8d26\u7c3f\u6682\u65e0\u9700\u8981\u5f52\u6863\u7684\u6570\u636e\u3002", (String)"ArchiveEdit_32", (String)"fi-aef-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isFa(DynamicObject archiveScheme) {
        DynamicObjectCollection entitys = archiveScheme.getDynamicObjectCollection("entryentity");
        for (DynamicObject entity : entitys) {
            if (!"fa_card_fin".equals(entity.getString("billtype.number"))) continue;
            return true;
        }
        return false;
    }

    private void buildElecEntry(SchemeEntry entry, OperateOption option, DynamicObject scheme) {
        entry.setSchemeId(Long.parseLong(((DynamicObject)scheme.getParent()).getPkValue() + ""));
        entry.setArchieveAttach(scheme.getString("isneedattachfile"));
        entry.setPageId(option.getVariableValue("pageId"));
        entry.setUploadWay(option.getVariableValue("uploadway"));
        entry.setDateField(scheme.getString("datefield"));
        entry.setArchiverange(scheme.getString("archiverangejson"));
        if (JudgePageUtil.isFromIntellexec((OperateOption)option)) {
            String aiRange = scheme.getString("aiarchive");
            this.bulidAiOption(option, aiRange, "bill", "bei_elecstatement");
            HashMap<Date, Date> intelldateMap = new HashMap<Date, Date>(2);
            Date startDate = DateUtil.stringToDate((String)option.getVariableValue("startdate"), (String)"yyyy-MM-dd");
            Date endDate = DateUtil.stringToDate((String)option.getVariableValue("enddate"), (String)"yyyy-MM-dd");
            endDate = DateUtil.stringToDate((String)(option.getVariableValue("enddate") + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
            intelldateMap.put(startDate, endDate);
            entry.setIntelldateJson(SerializationUtils.serializeToBase64(intelldateMap));
        }
    }

    private void buildTaxEntry(SchemeEntry entry, OperateOption option, DynamicObject scheme, Map<String, Integer> templateStatusMap, Set<String> noTemplatebill) {
        Map rangeMap = (Map)SerializationUtils.fromJsonString((String)scheme.getString("archiverangereport"), Map.class);
        String taxarchivedata = (String)rangeMap.get("taxarchivedata");
        String billType = scheme.getString("billtype.number");
        if (JudgePageUtil.isFromIntellexec((OperateOption)option)) {
            String aiRange = scheme.getString("aiarchive");
            this.bulidAiOption(option, aiRange, "bill", billType);
            HashMap<Date, Date> intelldateMap = new HashMap<Date, Date>(2);
            Date startDate = DateUtil.stringToDate((String)option.getVariableValue("startdate"), (String)"yyyy-MM-dd");
            Date endDate = DateUtil.stringToDate((String)option.getVariableValue("enddate"), (String)"yyyy-MM-dd");
            endDate = DateUtil.stringToDate((String)(option.getVariableValue("enddate") + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
            intelldateMap.put(startDate, endDate);
            entry.setIntelldateJson(SerializationUtils.serializeToBase64(intelldateMap));
        }
        if ("bill".equals(taxarchivedata)) {
            String printsampleId = scheme.getString("printsampleid");
            String printtemplate_tag = entry.getPrintTemplatetag();
            List<Object> templatenumbers = new ArrayList(2);
            if (StringUtils.isNotBlank((CharSequence)printtemplate_tag)) {
                List templateList = SerializationUtils.fromJsonStringToList((String)printtemplate_tag, PrintTemplate.class);
                templatenumbers = templateList.stream().map(PrintTemplate::getTemplateNumber).collect(Collectors.toList());
            }
            if (templateStatusMap.containsKey(printsampleId) || templatenumbers.size() > 0) {
                entry.setBillType(billType);
                MainEntityType bet = EntityMetadataCache.getDataEntityType((String)billType);
                String appid = AppMetadataCache.getAppInfo((String)bet.getAppId()).getId();
                entry.setOrgId(Long.parseLong(option.getVariableValue("org")));
                entry.setApplicationId(appid);
                entry.setSchemeId(Long.parseLong(((DynamicObject)scheme.getParent()).getPkValue() + ""));
                entry.setPrintsampleId(printsampleId);
                if (StringUtils.isNotBlank((CharSequence)printsampleId)) {
                    entry.setPrintType(templateStatusMap.get(printsampleId).intValue());
                }
                entry.setArchieveAttach(scheme.getString("isneedattachfile"));
                entry.setAttachtabJson(scheme.getString("attachtabJson"));
                entry.setPageId(option.getVariableValue("pageId"));
                entry.setUploadWay(option.getVariableValue("uploadway"));
                entry.setDateField(scheme.getString("datefield"));
                entry.setArchiverange(scheme.getString("archiverangejson"));
                entry.setArchiverangeReport(scheme.getString("archiverangereport"));
            } else {
                noTemplatebill.add(billType);
            }
        }
        if ("tccit".equals(taxarchivedata)) {
            entry.setBillType(billType);
            MainEntityType bet = EntityMetadataCache.getDataEntityType((String)billType);
            String appid = AppMetadataCache.getAppInfo((String)bet.getAppId()).getId();
            entry.setOrgId(Long.parseLong(option.getVariableValue("org")));
            entry.setApplicationId(appid);
            entry.setSchemeId(Long.parseLong(((DynamicObject)scheme.getParent()).getPkValue() + ""));
            entry.setPrintsampleId("");
            entry.setArchieveAttach(scheme.getString("isneedattachfile"));
            entry.setAttachtabJson(scheme.getString("attachtabJson"));
            entry.setPageId(option.getVariableValue("pageId"));
            entry.setUploadWay(option.getVariableValue("uploadway"));
            entry.setDateField(scheme.getString("datefield"));
            entry.setArchiverange(scheme.getString("archiverangejson"));
            entry.setArchiverangeReport(scheme.getString("archiverangereport"));
        }
    }

    static {
        logger = LogFactory.getLog(ArchiveOpService.class);
        int archivethreadsize = SysParamConfig.getInt((String)"archivethreadsize", (int)5);
        threadPoolCash = ThreadPools.newFixedThreadPool((String)"fi/aef/ArchiveEngin", (int)(archivethreadsize >= 1 && archivethreadsize <= 10 ? archivethreadsize : 5));
    }
}

