/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class DateFieldSelectorPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        TreeView tree = (TreeView)this.getControl("datetree");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        String billtype = (String)param.getCustomParam("billtype");
        TreeView tree = (TreeView)this.getControl("datetree");
        tree.addNode(this.getRoot(billtype));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
            TreeView tree = (TreeView)this.getControl("datetree");
            if (tree.getTreeState() == null || tree.getTreeState().getFocusNodeId() == null || ((Boolean)tree.getTreeState().getFocusNode().get("isParent")).booleanValue()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5b57\u6bb5\u3002", (String)"DateFieldSelectorPlugin_0", (String)"fi-aef-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeView.TreeState state = tree.getTreeState();
            this.getView().returnDataToParent((Object)state.getFocusNode());
            this.getView().close();
        } else if ("btncancel".equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        TreeView tree = (TreeView)evt.getSource();
        TreeView.TreeState state = tree.getTreeState();
        this.getView().returnDataToParent((Object)state.getFocusNode());
        this.getView().close();
    }

    private TreeNode getRoot(String billtype) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billtype);
        DynamicPropertyCollection dcps = (DynamicPropertyCollection)entityType.getProperties();
        TreeNode root = new TreeNode();
        root.setId(billtype);
        root.setText(entityType.getDisplayName().getLocaleValue());
        root.setIsOpened(true);
        for (IDataEntityProperty dcp : dcps) {
            if (!(dcp instanceof DateTimeProp)) continue;
            TreeNode node = new TreeNode();
            node.setId(dcp.getName());
            LocaleString displayName = dcp.getDisplayName();
            if (null != displayName) {
                node.setText(displayName.getLocaleValue());
            } else {
                node.setText(dcp.getName());
            }
            node.setParentid(root.getId());
            node.setLeaf(true);
            root.addChild(node);
        }
        return root;
    }
}

