/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.aef.common.util.BizParamUtils;

public class FieldMappingEdit
extends AbstractBillPlugIn {
    public static final String BILLTYPE = "billtype";
    public static final String FIELDNAME = "fieldname";
    public static final String FIELDNUMBER = "fieldnumber";
    public static final String XMLFILED = "xmlfiled";
    public static final String ISSYSPRESET = "issyspreset";
    public static final String ENTRYENTITY = "entryentity";
    public static final String FIELDTYPE = "fieldtype";
    public static final String DISPLAYPROP = "displayprop";

    private String getORG_CN() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"FieldMappingEdit_4", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private String getPERIOD_CN() {
        return ResManager.loadKDString((String)"\u671f\u95f4", (String)"FieldMappingEdit_5", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private String getBILLNO_CN() {
        return ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7", (String)"FieldMappingEdit_6", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private String getATTACHMENT_CN() {
        return ResManager.loadKDString((String)"\u9644\u4ef6\u6570", (String)"FieldMappingEdit_7", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private String getVOUCHERTYPE_CN() {
        return ResManager.loadKDString((String)"\u51ed\u8bc1\u7c7b\u578b", (String)"FieldMappingEdit_8", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private String getCURRENCY_CN() {
        return ResManager.loadKDString((String)"\u5e01\u522b", (String)"FieldMappingEdit_9", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private String getVDESCRIPTION_CN() {
        return ResManager.loadKDString((String)"\u6458\u8981", (String)"FieldMappingEdit_10", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private String getDEBITLOCAMOUNT_CN() {
        return ResManager.loadKDString((String)"\u8d37\u65b9\u91d1\u989d", (String)"FieldMappingEdit_11", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private String getCREDITLOCAMOUNT_CN() {
        return ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d", (String)"FieldMappingEdit_12", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private String getAUDITING_CN() {
        return ResManager.loadKDString((String)"\u5ba1\u6838\u4eba", (String)"FieldMappingEdit_13", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private String getCREATER_CN() {
        return ResManager.loadKDString((String)"\u5236\u5355\u4eba", (String)"FieldMappingEdit_14", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    private String getBILLCODE_CN() {
        return ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"FieldMappingEdit_15", (String)"fi-aef-formplugin", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FIELDNAME});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof DeleteEntry) {
            this.deleteField();
            args.setCancel(true);
        }
        if (args.getSource() instanceof Save) {
            DynamicObjectCollection dyns = this.getModel().getEntryEntity(ENTRYENTITY);
            int fieldcnt = 0;
            for (int i = 0; i < dyns.size(); ++i) {
                String mString;
                String xmlField;
                DynamicObject dynamicObject = (DynamicObject)dyns.get(i);
                if (!dynamicObject.getBoolean(ISSYSPRESET)) {
                    ++fieldcnt;
                }
                if (!FieldMappingEdit.validateStr(xmlField = dynamicObject.getString(XMLFILED))) {
                    mString = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u5f52\u6863\u5b57\u6bb5\u6807\u8bc6\u4e0d\u5408\u6cd5\u3002", (String)"FieldMappingEdit_19", (String)"fi-aef-formplugin", (Object[])new Object[0]), i + 1);
                    this.getView().showTipNotification(mString);
                    args.setCancel(true);
                }
                if (!"3".equals(dynamicObject.getString(FIELDTYPE)) || !StringUtils.isBlank((CharSequence)dynamicObject.getString(DISPLAYPROP))) continue;
                mString = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u57fa\u7840\u8d44\u6599\u5f52\u6863\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FieldMappingEdit_16", (String)"fi-aef-formplugin", (Object[])new Object[0]), i + 1);
                this.getView().showTipNotification(mString);
                args.setCancel(true);
            }
            if (fieldcnt > 10) {
                String mString = String.format(ResManager.loadKDString((String)"\u975e\u9884\u7f6e\u5b57\u6bb5\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u5341\u4e2a\u3002", (String)"FieldMappingEdit_18", (String)"fi-aef-formplugin", (Object[])new Object[0]), new Object[0]);
                this.getView().showTipNotification(mString);
                args.setCancel(true);
            }
            DynamicObject billdyn = (DynamicObject)this.getModel().getValue(BILLTYPE);
            QFilter qFilter = new QFilter(BILLTYPE, "=", billdyn.get("id"));
            String entityname = this.getModel().getDataEntity().getDataEntityType().getName();
            Long id = (Long)this.getModel().getValue("id");
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entityname, (String)"id", (QFilter[])qFilter.toArray());
            if (dynamicObject != null && id.longValue() != dynamicObject.getLong("id")) {
                String mString = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e3a%s\u7684\u5b57\u6bb5\u914d\u7f6e\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u914d\u7f6e\u3002", (String)"FieldMappingEdit_2", (String)"fi-aef-formplugin", (Object[])new Object[0]), billdyn.getString("name"));
                this.getView().showTipNotification(mString);
                args.setCancel(true);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "billtype": {
                if (StringUtils.isNotBlank((Object)model.getValue(BILLTYPE))) {
                    DynamicObject bill = (DynamicObject)model.getValue(BILLTYPE);
                    String billtype = bill.getString("number");
                    String billname = bill.getString("name");
                    model.setValue("number", (Object)billtype);
                    model.setValue("name", (Object)billname);
                    this.buildentry(billtype);
                    break;
                }
                DynamicObjectCollection entryColl = this.getModel().getEntryEntity(ENTRYENTITY);
                this.getModel().getEntryEntity(ENTRYENTITY).clear();
                this.getModel().updateEntryCache(entryColl);
                this.getView().updateView(ENTRYENTITY);
                break;
            }
        }
    }

    private void buildentry(String billtype) {
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity(ENTRYENTITY);
        DynamicObjectType entryType = this.getModel().getEntryEntity(ENTRYENTITY).getDynamicObjectType();
        this.getModel().getEntryEntity(ENTRYENTITY).clear();
        if ("gl_voucher".equals(billtype)) {
            this.buildDyn(entryColl, entryType, "id", "id", "billid", "1", "");
            this.buildDyn(entryColl, entryType, this.getORG_CN(), "org", "voucherorgnumber", "3", "1");
            this.buildDyn(entryColl, entryType, this.getORG_CN(), "org", "voucherorgname", "3", "2");
            this.buildDyn(entryColl, entryType, this.getPERIOD_CN(), "period", "period", "3", "1");
            this.buildDyn(entryColl, entryType, this.getBILLNO_CN(), "billno", "vouchernum", "1", "");
            this.buildDyn(entryColl, entryType, this.getATTACHMENT_CN(), "attachment", "attachnum", "1", "");
            this.buildDyn(entryColl, entryType, this.getVOUCHERTYPE_CN(), "vouchertype", "vouchertype", "3", "2");
            this.buildDyn(entryColl, entryType, this.getCURRENCY_CN(), "localcur", "currency", "3", "1");
            this.buildDyn(entryColl, entryType, this.getVDESCRIPTION_CN(), "vdescription", "desc", "1", "");
            this.buildDyn(entryColl, entryType, this.getDEBITLOCAMOUNT_CN(), "debitlocamount", "totaldebitloc", "2", "");
            this.buildDyn(entryColl, entryType, this.getCREDITLOCAMOUNT_CN(), "creditlocamount", "totalcreditloc", "2", "");
            this.buildDyn(entryColl, entryType, this.getAUDITING_CN(), "auditor", "auditing", "3", "2");
            this.buildDyn(entryColl, entryType, this.getCREATER_CN(), "submitter", "creater", "3", "2");
        } else {
            MainEntityType srcEntityType = EntityMetadataCache.getDataEntityType((String)billtype);
            String billfield = ((BillEntityType)srcEntityType).getBillNo();
            Map billType2ArchiveOrgCfgFieldMap = BizParamUtils.getBillType2ArchiveOrgCfgFieldMap(Collections.singleton(billtype));
            String orgField = billType2ArchiveOrgCfgFieldMap.get(billtype) == null ? srcEntityType.getMainOrg() : (String)billType2ArchiveOrgCfgFieldMap.get(billtype);
            this.buildDyn(entryColl, entryType, "id", "id", "billid", "1", "");
            this.buildDyn(entryColl, entryType, this.getBILLCODE_CN(), billfield, "billcode", "1", "");
            this.buildDyn(entryColl, entryType, this.getORG_CN(), orgField, "voucherorgnumber", "3", "1");
            this.buildDyn(entryColl, entryType, this.getORG_CN(), orgField, "voucherorgname", "3", "2");
            if ("cas_balanceadjust".equals(billtype) || "cas_bankstatement".equals(billtype)) {
                this.buildDyn(entryColl, entryType, this.getPERIOD_CN(), "period", "period", "3", "1");
            }
        }
        this.getModel().updateEntryCache(entryColl);
        this.getView().updateView(ENTRYENTITY);
    }

    private void buildDyn(DynamicObjectCollection entryColl, DynamicObjectType entryType, String ... args) {
        DynamicObject entryObj = new DynamicObject(entryType);
        entryObj.set(FIELDNAME, (Object)args[0]);
        entryObj.set(FIELDNUMBER, (Object)args[1]);
        entryObj.set(XMLFILED, (Object)args[2]);
        entryObj.set(FIELDTYPE, (Object)args[3]);
        entryObj.set(DISPLAYPROP, (Object)args[4]);
        entryObj.set(ISSYSPRESET, (Object)true);
        entryColl.add((Object)entryObj);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "fieldname": {
                this.chooseField();
                break;
            }
        }
    }

    private void deleteField() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY);
        int beginSize = 0;
        if (selectRows != null && selectRows.length > 0) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                DynamicObject dynamicRow = (DynamicObject)entity.get(selectRows[i]);
                if (dynamicRow.getBoolean(ISSYSPRESET)) {
                    ++beginSize;
                    continue;
                }
                entity.remove(selectRows[i]);
            }
        }
        this.getModel().updateEntryCache(entity);
        this.getView().updateView(ENTRYENTITY);
        if (selectRows != null && beginSize == selectRows.length) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"FieldMappingEdit_0", (String)"fi-aef-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private void chooseField() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("aef_field_choose");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex(ENTRYENTITY);
        DynamicObject billtype = (DynamicObject)model.getValue(BILLTYPE);
        if (!StringUtils.isNotBlank((Object)billtype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u636e\u7c7b\u578b\u518d\u914d\u7f6e\u5355\u636e\u5b57\u6bb5\u3002", (String)"FieldMappingEdit_1", (String)"fi-aef-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("billnumber", billtype.get("number"));
        map.put("index", index);
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "field_choose_close_call_back"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "field_choose_close_call_back": {
                this.parseClosedCallBackInfo(returnData);
                break;
            }
        }
    }

    private void parseClosedCallBackInfo(Object returnData) {
        ArrayList returnParams = (ArrayList)returnData;
        DynamicObjectType entryType = this.getModel().getEntryEntity(ENTRYENTITY).getDynamicObjectType();
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isNotEmpty((Collection)entryColl)) {
            entryColl.remove(this.getModel().getEntryCurrentRowIndex(ENTRYENTITY));
        }
        for (HashMap returnParam : returnParams) {
            DynamicObject entryObj = new DynamicObject(entryType);
            entryObj.set(FIELDNAME, returnParam.get(FIELDNAME));
            entryObj.set(FIELDNUMBER, returnParam.get(FIELDNUMBER));
            entryObj.set(FIELDTYPE, returnParam.get(FIELDTYPE));
            entryObj.set(DISPLAYPROP, returnParam.get(DISPLAYPROP));
            entryObj.set(ISSYSPRESET, (Object)false);
            entryColl.add(Integer.parseInt((String)returnParam.get("index")), entryObj);
        }
        this.getModel().updateEntryCache(entryColl);
        this.getView().updateView(ENTRYENTITY);
    }

    private static boolean validateStr(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        String regex = "^[a-zA-Z][\\w]*$";
        return str.matches(regex);
    }
}

