/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.list.column.VoucherNoColumnDesc;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.xdb.ExceedShardingQueryLimit;
import kd.fi.ai.enums.PermissonType;
import kd.fi.v2.fah.constant.FAHCommonConstant;

public class VoucherNoUtil {
    private static final String GL_VOUCHER = "gl_voucher";
    public static final Log logger = LogFactory.getLog(VoucherNoUtil.class);

    public static Map<String, String> getVoucherNumber(List<String> fids, String entityID) {
        return VoucherNoUtil.getVoucherNumber(fids, entityID, null);
    }

    public static Map<String, String> getVoucherNumber(List<String> fids, String entityID, VoucherNoColumnDesc vchnoCol) {
        Object billId;
        Object OpKey;
        if (CollectionUtils.isEmpty(fids)) {
            return null;
        }
        List<Long> newFids = fids.stream().map(s -> Long.valueOf(s)).collect(Collectors.toList());
        HashSet<Long> voucherids = new HashSet<Long>(16);
        HashMap<String, Long> singleBillVchMap = new HashMap<String, Long>(16);
        HashMap multiBillVchMap = new HashMap(16);
        if (vchnoCol != null) {
            String voucherFieldId = vchnoCol.getListFieldId();
            if (!StringUtils.isEmpty((CharSequence)voucherFieldId)) {
                try (DataSet daptracks = QueryServiceHelper.queryDataSet((String)"VoucherNoUtil.queryVoucherIDField", (String)entityID, (String)("id," + voucherFieldId), (QFilter[])new QFilter[]{new QFilter("id", "in", newFids)}, null);){
                    for (Row row : daptracks) {
                        String billid = row.getString("id");
                        long vid = row.getLong(voucherFieldId);
                        if (vid == 0L) continue;
                        if (multiBillVchMap.containsKey(billid)) {
                            ((Set)multiBillVchMap.get(billid)).add(vid);
                        } else if (singleBillVchMap.containsKey(billid)) {
                            HashSet<Object> vids = new HashSet<Object>(2);
                            multiBillVchMap.put(billid, vids);
                            vids.add(singleBillVchMap.remove(billid));
                            vids.add(vid);
                        } else {
                            singleBillVchMap.put(billid, vid);
                        }
                        voucherids.add(vid);
                    }
                }
            }
            if (!StringUtils.isEmpty((CharSequence)(OpKey = vchnoCol.getOperationKey()))) {
                DataSet qd = DB.queryDataSet((String)"VoucherNoUtil.queryDaptracker", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)VoucherNoUtil.getSqlBuilderByEntityBillIds(entityID, newFids, (String)OpKey));
                Object object = null;
                try {
                    for (Row row : qd) {
                        String billId2 = row.getString("sourcebillid");
                        long vid = row.getLong("voucherid");
                        if (multiBillVchMap.containsKey(billId2)) {
                            ((Set)multiBillVchMap.get(billId2)).add(vid);
                        } else if (singleBillVchMap.containsKey(billId2)) {
                            HashSet<Object> vids = new HashSet<Object>(2);
                            multiBillVchMap.put(billId2, vids);
                            vids.add(singleBillVchMap.remove(billId2));
                            vids.add(vid);
                        } else {
                            singleBillVchMap.put(billId2, vid);
                        }
                        voucherids.add(vid);
                    }
                }
                catch (Throwable it) {
                    object = it;
                    throw it;
                }
                finally {
                    if (qd != null) {
                        if (object != null) {
                            try {
                                qd.close();
                            }
                            catch (Throwable it) {
                                ((Throwable)object).addSuppressed(it);
                            }
                        } else {
                            qd.close();
                        }
                    }
                }
            }
        }
        if (vchnoCol == null || StringUtils.isEmpty((CharSequence)vchnoCol.getListFieldId()) && StringUtils.isEmpty((CharSequence)vchnoCol.getOperationKey())) {
            DataSet qd = DB.queryDataSet((String)"VoucherNoUtil.queryDaptracker", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)VoucherNoUtil.getSqlBuilderByEntityBillIds(entityID, newFids, null));
            OpKey = null;
            try {
                for (Row row : qd) {
                    billId = row.getString("sourcebillid");
                    long vid = row.getLong("voucherid");
                    if (multiBillVchMap.containsKey(billId)) {
                        ((Set)multiBillVchMap.get(billId)).add(vid);
                    } else if (singleBillVchMap.containsKey(billId)) {
                        HashSet<Object> vids = new HashSet<Object>(2);
                        multiBillVchMap.put((String)billId, vids);
                        vids.add(singleBillVchMap.remove(billId));
                        vids.add(vid);
                    } else {
                        singleBillVchMap.put((String)billId, vid);
                    }
                    voucherids.add(vid);
                }
            }
            catch (Throwable it) {
                OpKey = it;
                throw it;
            }
            finally {
                if (qd != null) {
                    if (OpKey != null) {
                        try {
                            qd.close();
                        }
                        catch (Throwable it) {
                            ((Throwable)OpKey).addSuppressed(it);
                        }
                    } else {
                        qd.close();
                    }
                }
            }
        }
        HashMap<Long, String> vnos = new HashMap<Long, String>(voucherids.size());
        if (voucherids.size() > 0) {
            ExceedShardingQueryLimit es = ExceedShardingQueryLimit.create();
            Object it = null;
            try {
                es.setSkipExceedLimit(true);
                DataSet vouchers = QueryServiceHelper.queryDataSet((String)"VoucherNoUtil.queryGLVoucher", (String)GL_VOUCHER, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", voucherids)}, null);
                billId = null;
                try {
                    for (Row row : vouchers) {
                        long id = row.getLong("id");
                        String vchno = row.getString("billno");
                        vnos.put(id, vchno);
                    }
                }
                catch (Throwable vid) {
                    billId = vid;
                    throw vid;
                }
                finally {
                    if (vouchers != null) {
                        if (billId != null) {
                            try {
                                vouchers.close();
                            }
                            catch (Throwable vid) {
                                ((Throwable)billId).addSuppressed(vid);
                            }
                        } else {
                            vouchers.close();
                        }
                    }
                }
            }
            catch (Throwable vouchers) {
                it = vouchers;
                throw vouchers;
            }
            finally {
                if (es != null) {
                    if (it != null) {
                        try {
                            es.close();
                        }
                        catch (Throwable vouchers) {
                            ((Throwable)it).addSuppressed(vouchers);
                        }
                    } else {
                        es.close();
                    }
                }
            }
        }
        HashMap<String, String> result = new HashMap<String, String>(fids.size());
        Set sSet = singleBillVchMap.entrySet();
        for (Map.Entry se : sSet) {
            result.put((String)se.getKey(), (String)vnos.get(se.getValue()));
        }
        Set mSet = multiBillVchMap.entrySet();
        for (Map.Entry me : mSet) {
            Set vids = (Set)me.getValue();
            ArrayList<String> vnoList = new ArrayList<String>(vids.size());
            for (Long vid : vids) {
                String vno = (String)vnos.get(vid);
                if (vno == null) continue;
                vnoList.add(vno);
            }
            result.put((String)me.getKey(), String.join((CharSequence)",", vnoList));
        }
        return result;
    }

    private static SqlBuilder getSqlBuilderByEntityBillIds(String entityID, List<Long> newFids, String opKey) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fsourcebillid sourcebillid,fvoucherid voucherid from t_ai_daptracker where ", new Object[0]);
        sqlBuilder.appendIn(" fsourcebillid", newFids.toArray()).append(" and fbilltype = ?", new Object[]{entityID});
        if (StringUtils.isNotEmpty((CharSequence)opKey)) {
            sqlBuilder.append(" and foper = ?", new Object[]{opKey});
        }
        sqlBuilder.append(" union all", new Object[0]);
        sqlBuilder.append(" select FSRC_BILLID sourcebillid,FGL_HEADER_ID voucherid from t_fah_evt_tracker where ", new Object[0]);
        sqlBuilder.appendIn(" FSRC_BILLID ", newFids.toArray()).append(" and fsrc_billtype = ?", new Object[]{entityID}).append(" and fstatus = ?", new Object[]{"4"});
        return sqlBuilder;
    }

    private static boolean getEnableBizVoucherBySysParam(Long org) {
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        AppParam param = new AppParam(appId, "10", org, Long.valueOf(0L));
        Object bizvoucher = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"isbizvoucher");
        Boolean isbizvoucher = bizvoucher == null ? Boolean.FALSE : (Boolean)bizvoucher;
        return isbizvoucher;
    }

    public static FormShowParameter getFormShowParameter(String billId, String entityId, String operationKey, String voucherFieldId) {
        Iterator it2;
        DataSet qd;
        Row row2;
        Object object;
        if (!VoucherNoUtil.checkTraceVoucherPermission(entityId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c\u8054\u67e5\u51ed\u8bc1\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TraceVoucher_6", (String)"fi-ai-common", (Object[])new Object[0]), EntityMetadataCache.getDataEntityType((String)entityId).getDisplayName()));
        }
        long billidLong = 0L;
        HashSet<Long> voucherids = null;
        try {
            billidLong = Long.parseLong(billId);
        }
        catch (NumberFormatException e) {
            logger.error((Throwable)e);
        }
        if (!StringUtils.isEmpty((CharSequence)voucherFieldId)) {
            DataSet daptracks = QueryServiceHelper.queryDataSet((String)"VoucherNoUtil.queryVoucherIDField", (String)entityId, (String)("id," + voucherFieldId), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billidLong)}, null);
            object = null;
            try {
                for (Row row2 : daptracks) {
                    long vid = row2.getLong(voucherFieldId);
                    if (vid == 0L) continue;
                    voucherids = new HashSet(16);
                    voucherids.add(vid);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (daptracks != null) {
                    if (object != null) {
                        try {
                            daptracks.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        daptracks.close();
                    }
                }
            }
        }
        if ((voucherids == null || voucherids.isEmpty()) && !StringUtils.isEmpty((CharSequence)operationKey)) {
            qd = DB.queryDataSet((String)"VoucherNoUtil.queryDaptracker", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)VoucherNoUtil.getSqlBuilder(entityId, operationKey, billidLong));
            object = null;
            try {
                it2 = qd.iterator();
                voucherids = new HashSet<Long>();
                while (it2.hasNext()) {
                    row2 = (Row)it2.next();
                    voucherids.add(row2.getLong("voucherid"));
                }
            }
            catch (Throwable it2) {
                object = it2;
                throw it2;
            }
            finally {
                if (qd != null) {
                    if (object != null) {
                        try {
                            qd.close();
                        }
                        catch (Throwable it2) {
                            ((Throwable)object).addSuppressed(it2);
                        }
                    } else {
                        qd.close();
                    }
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)voucherFieldId) && StringUtils.isEmpty((CharSequence)operationKey)) {
            qd = DB.queryDataSet((String)"VoucherNoUtil.queryDaptracker", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)VoucherNoUtil.getSqlBuilder(entityId, operationKey, billidLong));
            object = null;
            try {
                it2 = qd.iterator();
                voucherids = new HashSet();
                while (it2.hasNext()) {
                    row2 = (Row)it2.next();
                    voucherids.add(row2.getLong("voucherid"));
                }
            }
            catch (Throwable it3) {
                object = it3;
                throw it3;
            }
            finally {
                if (qd != null) {
                    if (object != null) {
                        try {
                            qd.close();
                        }
                        catch (Throwable it3) {
                            ((Throwable)object).addSuppressed(it3);
                        }
                    } else {
                        qd.close();
                    }
                }
            }
        }
        if (voucherids == null || voucherids.size() == 0) {
            return null;
        }
        if (voucherids.size() == 1) {
            long billId1 = (Long)voucherids.iterator().next();
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)billId1);
            showParameter.setFormId(GL_VOUCHER);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            long orgId = 0L;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"TraceVoucher_queryvoucher", (String)GL_VOUCHER, (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId1)}, null);){
                for (Row row3 : ds) {
                    orgId = row3.getLong("org");
                }
            }
            long userId = Long.parseLong(RequestContext.get().getUserId());
            int i = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"83bfebc8000017ac", (String)GL_VOUCHER, (String)"4715a0df000000ac");
            StringBuilder sbNotMatchTips = new StringBuilder();
            QFilter qf = PermissionServiceHelper.getOperationRuleFilter((Long)userId, (String)"83bfebc8000017ac", (String)GL_VOUCHER, (String)"modify", (StringBuilder)sbNotMatchTips);
            if (i == 1 && VoucherNoUtil.hasSpecialDataPermission(billId1, qf) && !VoucherNoUtil.getEnableBizVoucherBySysParam(orgId)) {
                showParameter.setStatus(OperationStatus.EDIT);
            } else {
                showParameter.setStatus(OperationStatus.VIEW);
            }
            showParameter.setHasRight(true);
            showParameter.setHasRight(true);
            return showParameter;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(GL_VOUCHER);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        for (Long pkid : voucherids) {
            showParameter.addLinkQueryPkId((Object)pkid);
        }
        showParameter.getCustomParams().put("org", "");
        showParameter.getCustomParams().put("booktype", "");
        return showParameter;
    }

    private static boolean hasSpecialDataPermission(long billId1, QFilter qf) {
        if (qf != null) {
            return QueryServiceHelper.exists((String)GL_VOUCHER, (QFilter[])new QFilter[]{qf, new QFilter("id", "=", (Object)billId1)});
        }
        return true;
    }

    private static SqlBuilder getSqlBuilder(String entityId, String operationKey, long billIdLong) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fvoucherid voucherid from t_ai_daptracker where ", new Object[0]);
        sqlBuilder.append(" fsourcebillid = ?", new Object[]{billIdLong}).append(" and fbilltype = ?", new Object[]{entityId});
        if (StringUtils.isNotEmpty((CharSequence)operationKey)) {
            sqlBuilder.append(" and foper=?", new Object[]{operationKey});
        }
        sqlBuilder.append(" union all", new Object[0]);
        sqlBuilder.append(" select FGL_HEADER_ID voucherid from t_fah_evt_tracker where ", new Object[0]);
        sqlBuilder.append(" FSRC_BILLID = ?", new Object[]{billIdLong}).append(" and fsrc_billtype = ?", new Object[]{entityId}).append(" and fstatus = ?", new Object[]{"4"});
        return sqlBuilder;
    }

    public static boolean checkTraceVoucherPermission(String entityId) {
        Set permissionSet = EntityMetadataCache.getPermissionItems((String)entityId);
        if (permissionSet.contains(PermissonType.TRACE_VOUCHER.getPermId())) {
            return PermissionServiceHelper.checkPermission((long)Long.parseLong(RequestContext.get().getUserId()), null, null, (String)entityId, (String)PermissonType.TRACE_VOUCHER.getPermId());
        }
        return true;
    }
}

