/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.fi.ai.dap.cache.DistributeCache;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.GenVoucherMemoryMergeTask;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.builder.AcctBookInfo;
import kd.fi.ai.builder.BuildVoucherType;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTplContext;
import kd.fi.ai.builder.SourceBillInfo;
import kd.fi.ai.cache.CacheModule;
import kd.fi.ai.exception.DapException;
import kd.fi.ai.mservice.builder.BuildVchScheme;
import kd.fi.ai.mservice.builder.BuildVchServiceImpl;
import kd.fi.ai.mservice.builder.SelectedAcctBook;
import kd.fi.ai.mservice.builder.TaskRuner;
import kd.fi.ai.mservice.builder.buildresult.BuildVchResult;
import kd.fi.ai.mservice.builder.buildresult.SingleTplResult;
import kd.fi.ai.mservice.builder.context.BuildVchContext;
import kd.fi.ai.mservice.builder.context.SingleTplContext;
import kd.fi.ai.mservice.builder.helper.CacheHelper;
import kd.fi.ai.mservice.builder.singletplaction.AbstractSingleTemplateAction;
import kd.fi.ai.mservice.builder.singletplaction.BeginNetControlAction;
import kd.fi.ai.mservice.builder.singletplaction.BuildFilterAction;
import kd.fi.ai.mservice.builder.singletplaction.CheckRightAction;
import kd.fi.ai.mservice.builder.singletplaction.CreatePluginAction;
import kd.fi.ai.mservice.builder.singletplaction.CreateQueryParemeterAction;
import kd.fi.ai.mservice.builder.singletplaction.InitVariableAction;
import kd.fi.ai.mservice.builder.singletplaction.LoadBizVoucherByBookAction;
import kd.fi.ai.mservice.builder.singletplaction.LoadSourceBillIdsAction;
import kd.fi.ai.mservice.builder.singletplaction.SplitTaskAction;
import kd.fi.v2.fah.optimizor.FahOptimizeControlPanel;
import kd.fi.v2.fah.utils.ParamUtils;

public class BuildVchEngine {
    private static Log log = LogFactory.getLog(BuildVchEngine.class);
    private static int cpu = Runtime.getRuntime().availableProcessors();
    private static ThreadPool threadPoolCash = ThreadPools.newFixedThreadPool((String)"fi/ai/buildvoucher", (int)(cpu < 4 ? 4 : (cpu > 8 ? 8 : cpu)));
    kd.fi.ai.cache.DistributeCache cache = kd.fi.ai.cache.CacheHelper.getDistributeCache((CacheModule)CacheModule.aiBuildVchWizard);
    DistributeCache distributeCache = kd.bos.ext.fi.ai.dap.cache.CacheHelper.getDistributeCache((kd.bos.ext.fi.ai.dap.cache.CacheModule)kd.bos.ext.fi.ai.dap.cache.CacheModule.GenerateVoucherTaskProcess);
    private static String newthreadPool = "fi.ai.buildVoucher.newthreadPool";

    public void BuildVoucher(BuildVchScheme scheme) throws Exception {
        this.cache.put(newthreadPool, ParamUtils.isNewThred());
        IBuildVchContext context = this.CreateContext(scheme);
        BuildVchResult buildVchResult = new BuildVchResult();
        try {
            boolean isAsync;
            context.getLogger().info(ResManager.loadKDString((String)"\u5f00\u59cb\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"BuildVchEngine_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
            context.getLogger().info(ResManager.loadKDString((String)"\u5f00\u59cb\u521d\u59cb\u5316\u53c2\u6570\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"BuildVchEngine_1", (String)"fi-ai-mservice", (Object[])new Object[0]));
            context.getProgresser().Forward(0, ResManager.loadKDString((String)"\u53c2\u6570\u521d\u59cb\u5316\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"BuildVchEngine_2", (String)"fi-ai-mservice", (Object[])new Object[0]));
            context.ParseInputParameter();
            context.getLogger().info(ResManager.loadKDString((String)"\u9010\u4e2a\u8d26\u7c3f\u3001\u6e90\u5355\u3001\u51ed\u8bc1\u6a21\u677f\uff0c\u8fdb\u884c\u5faa\u73af\uff0c\u8bfb\u53d6\u7b26\u5408\u6761\u4ef6\uff0c\u9700\u8981\u5904\u7406\u7684\u6570\u636e", (String)"BuildVchEngine_3", (String)"fi-ai-mservice", (Object[])new Object[0]));
            context.getProgresser().Forward(1, ResManager.loadKDString((String)"\u6b63\u5728\u8bfb\u53d6\u7b26\u5408\u6761\u4ef6\u7684\u6e90\u5355\u6570\u636e", (String)"BuildVchEngine_4", (String)"fi-ai-mservice", (Object[])new Object[0]));
            for (Map.Entry bookEntry : context.getBooks().entrySet()) {
                AcctBookInfo book = (AcctBookInfo)bookEntry.getValue();
                for (Map.Entry billEntry : book.getSourceBills().entrySet()) {
                    SourceBillInfo sourceBill = (SourceBillInfo)billEntry.getValue();
                    this.DoEverySourceBill(context, buildVchResult, book, sourceBill);
                }
            }
            context.getProgresser().Forward(2, ResManager.loadKDString((String)"\u5f85\u5904\u7406\u6e90\u5355\u5df2\u7ecf\u8bfb\u53d6\u5b8c\u6bd5\uff0c\u5f00\u59cb\u5206\u6279\u5904\u7406", (String)"BuildVchEngine_5", (String)"fi-ai-mservice", (Object[])new Object[0]));
            this.putCache(context);
            context.getProgresser().getTaskInfos().forEach(v -> log.info("---BuildVchEngine---Progresser:templateid:" + v.getTemplateId() + ";  entrynumber:" + v.getEntityNumber() + ";  bookid:" + v.getBookId() + ";  srcbills:" + StringUtils.join((Iterable)v.getSrcBillIds(), (String)",")));
            context.getLogger().info(ResManager.loadKDString((String)"\u5f00\u59cb\u5206\u6279\u6267\u884c\u4efb\u52a1", (String)"BuildVchEngine_6", (String)"fi-ai-mservice", (Object[])new Object[0]));
            context.getProgresser().Forward(1, ResManager.loadKDString((String)"\u6b63\u5728\u5206\u6279\u751f\u6210\u51ed\u8bc1\u5c0f\u4efb\u52a1\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"BuildVchEngine_7", (String)"fi-ai-mservice", (Object[])new Object[0]));
            boolean bl = isAsync = "C".equals(scheme.getBuildType()) && null != this.cache.get(scheme.getAsyncId() + "isFinish");
            if (isAsync) {
                this.cache.put(scheme.getAsyncId() + "taskCount", context.getProgresser().getTaskIds().size() + "");
            }
            scheme.getGvMemory().setSingle_currTaskSize(context.getProgresser().getTaskIds().size());
            if (context.getProgresser().getTaskIds().size() == 1) {
                this.synExecuteTasks(context, buildVchResult);
            } else {
                this.asynExecuteTasks(context, buildVchResult);
            }
        }
        catch (Exception e) {
            if (e instanceof DapException) {
                throw e;
            }
            if (e.getCause() instanceof DapException) {
                DapException dep = (DapException)e.getCause();
                DapException dapException = new DapException(dep.getMassage(), dep.getBillids(), dep.getBookid(), dep.getTemplateid(), (Throwable)dep);
                dapException.setExceptionstack(dep.getExceptionstack());
                throw dapException;
            }
            context.getLogger().error((Throwable)e);
            log.error((Throwable)e);
            ArrayList idscol = new ArrayList(16);
            for (SelectedAcctBook sab : scheme.getSelectedBooks()) {
                sab.getSelectedSourceBills().stream().forEach(v -> idscol.addAll(new ArrayList(v.getBillIds())));
            }
            DapException dapException = null;
            if (e.getMessage() != null && e.getMessage().length() > 50) {
                if (e.getCause() instanceof Exception) {
                    Exception ec = (Exception)e.getCause();
                    String message = "";
                    message = ec.getMessage() != null && ec.getMessage().length() > 50 ? StringUtils.substring((String)ec.getMessage(), (int)0, (int)50) : ec.getMessage();
                    dapException = new DapException(message, idscol.toArray(), null, null, (Throwable)ec);
                    dapException.setExceptionstack((Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)ec));
                } else {
                    String message = StringUtils.substring((String)e.getMessage(), (int)0, (int)50);
                    dapException = new DapException(message, idscol.toArray(), null, null, (Throwable)e);
                    dapException.setExceptionstack((Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            } else {
                dapException = new DapException(e.getMessage(), idscol.toArray(), null, null, (Throwable)e);
                dapException.setExceptionstack((Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            throw dapException;
        }
        finally {
            CacheHelper.ClearCache((BuildVchContext)((BuildVchContext)context));
        }
    }

    private void DoEverySourceBill(IBuildVchContext context, BuildVchResult buildVchResult, AcctBookInfo book, SourceBillInfo sourceBill) {
        if (book.getBuildVoucherType() == BuildVoucherType.OnlyGLVoucher) {
            context.getLogger().info(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u8bfb\u53d6\u6765\u6e90\u5355\u636e \u201c%s\u201d \u5df2\u751f\u6210\u7684\u4e1a\u52a1\u51ed\u8bc1\u3002", (String)"BuildVchEngine_8", (String)"fi-ai-mservice", (Object[])new Object[0]), sourceBill.getBillName().toString()));
            this.DoEveryTemplate(context, buildVchResult, book, sourceBill, (VCHTemplate)sourceBill.getVchTemplates().values().iterator().next());
        } else {
            for (Map.Entry entry : sourceBill.getVchTemplates().entrySet()) {
                VCHTemplate template = (VCHTemplate)entry.getValue();
                context.getLogger().info(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u8bfb\u53d6\u51ed\u8bc1\u6a21\u677f\u201c%s\u201d\u7b26\u5408\u6761\u4ef6\u7684\u6e90\u5355\u6570\u636e\u3002", (String)"BuildVchEngine_9", (String)"fi-ai-mservice", (Object[])new Object[0]), template.getDescription().toString()));
                this.DoEveryTemplate(context, buildVchResult, book, sourceBill, template);
            }
        }
    }

    private void DoEveryTemplate(IBuildVchContext context, BuildVchResult buildVchResult, AcctBookInfo book, SourceBillInfo sourceBill, VCHTemplate template) {
        List<AbstractSingleTemplateAction> logicUnits = this.CreateLogicUnits(book);
        SingleTplContext tplContext = this.CreateTplContext(context, book, sourceBill, template);
        SingleTplResult tplResult = new SingleTplResult();
        tplResult.setBuildVchResult(buildVchResult);
        for (AbstractSingleTemplateAction logicUnit : logicUnits) {
            logicUnit.Do((ISingleTplContext)tplContext, tplResult);
        }
    }

    private void updateSingleTaskCache(GenVoucherMemoryMergeTask gvMemory) {
        if (gvMemory.isSingleTask()) {
            String cacheData = this.distributeCache.get(gvMemory.getGenerateVoucherTaskProcess());
            Map<String, String> cacheDataMap = new HashMap(8);
            if (cacheData != null) {
                cacheDataMap = (Map)SerializationUtils.fromJsonString((String)cacheData, Map.class);
            }
            String currTaskKey = "currProgress";
            String progressinfo = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u7b2c\u201c%1$s\u201d\u7ec4\u7b2c\u201c%2$s\u201d\u4e2a\u5b50\u4efb\u52a1\uff0c\u5df2\u5b8c\u6210\u201c%3$s\u201d\u7ec4\u4efb\u52a1\u3002", (String)"BuildVchEngine_11", (String)"fi-ai-mservice", (Object[])new Object[0]), gvMemory.getSingle_currAcctBookHasDone() + 1, gvMemory.getSingle_currTaskHasDone() + " / " + gvMemory.getSingle_currTaskSize(), gvMemory.getSingle_currAcctBookHasDone() + " / " + gvMemory.getSingle_currAcctBookSize());
            cacheDataMap.put(currTaskKey, (String)((Object)Integer.valueOf(gvMemory.getCurr_progress())));
            cacheDataMap.put(currTaskKey + "_info", progressinfo);
            this.distributeCache.put(gvMemory.getGenerateVoucherTaskProcess(), SerializationUtils.toJsonString(cacheDataMap));
        }
    }

    private void asynExecuteTasks(IBuildVchContext context, BuildVchResult buildVchResult) throws Exception {
        ArrayList<Future> resultList = new ArrayList<Future>(10);
        Object lock = new Object();
        String flag = this.cache.get(newthreadPool);
        for (String taskId : context.getProgresser().getTaskIds()) {
            Future future;
            if ("true".equals(flag)) {
                log.info("\u6b63\u5728\u4f7f\u7528\u65b0\u7684\u7ebf\u7a0b\u6c60\u751f\u6210\u51ed\u8bc1\u3002");
                future = ThreadService.submit((Callable)new TaskRuner(context.getTransId(), taskId, RequestContextCreator.createForThreadPool(), lock, TraceIdUtil.getCurrentTraceIdString()), (TaskType)TaskType.AI_BUILD_VOUCHER);
                resultList.add(future);
                continue;
            }
            log.info("\u6b63\u5728\u4f7f\u7528\u8001\u7684\u7ebf\u7a0b\u6c60\u751f\u6210\u51ed\u8bc1\u3002");
            future = threadPoolCash.submit((Callable)new TaskRuner(context.getTransId(), taskId, RequestContextCreator.createForThreadPool(), lock, TraceIdUtil.getCurrentTraceIdString()));
            resultList.add(future);
        }
        int taskDone = 0;
        int gv_taskDone = 0;
        BuildVchScheme scheme = ((BuildVchContext)context).getScheme();
        boolean isAsync = "C".equals(scheme.getBuildType()) && null != this.cache.get(scheme.getAsyncId() + "isFinish");
        for (Future taskResult : resultList) {
            try {
                Boolean result = (Boolean)taskResult.get();
                if (isAsync && Boolean.TRUE.equals(result)) {
                    this.cache.put(scheme.getAsyncId() + "taskDoneCount", ++taskDone + "");
                }
                if (!scheme.getGvMemory().isSingleTask()) continue;
                scheme.getGvMemory().currTaskToDone(++gv_taskDone);
                this.updateSingleTaskCache(scheme.getGvMemory());
            }
            catch (Exception e) {
                context.getLogger().error((Throwable)e);
                log.error((Throwable)e);
                if (e.getCause() instanceof Exception) {
                    throw new Exception(e.getCause());
                }
                throw e;
            }
        }
    }

    private void synExecuteTasks(IBuildVchContext context, BuildVchResult buildVchResult) {
        Object lock = new Object();
        int taskDone = 0;
        int gv_taskDone = 0;
        BuildVchScheme scheme = ((BuildVchContext)context).getScheme();
        boolean isAsync = "C".equals(scheme.getBuildType()) && null != this.cache.get(scheme.getAsyncId() + "isFinish");
        for (String taskId : context.getProgresser().getTaskIds()) {
            BuildVchServiceImpl buildVchService = new BuildVchServiceImpl(lock);
            buildVchService.BuildSingleTask(context.getTransId(), taskId);
            if (isAsync) {
                this.cache.put(scheme.getAsyncId() + "taskDoneCount", ++taskDone + "");
            }
            if (!scheme.getGvMemory().isSingleTask()) continue;
            scheme.getGvMemory().currTaskToDone(++gv_taskDone);
            this.updateSingleTaskCache(scheme.getGvMemory());
        }
    }

    private IBuildVchContext CreateContext(BuildVchScheme scheme) {
        BuildVchContext context = new BuildVchContext();
        context.setScheme(scheme);
        context.Initialize();
        return context;
    }

    private SingleTplContext CreateTplContext(IBuildVchContext context, AcctBookInfo book, SourceBillInfo sourceBill, VCHTemplate template) {
        SingleTplContext tempContext = new SingleTplContext();
        tempContext.setBuildVchContext(context);
        tempContext.setBook(book);
        tempContext.setSourceBill(sourceBill);
        tempContext.setVchTemplate(template);
        tempContext.setEntryMax(FahOptimizeControlPanel.getDapGenEntryMaxSize());
        return tempContext;
    }

    private void putCache(IBuildVchContext context) {
        CacheHelper.putContext((BuildVchContext)((BuildVchContext)context));
        context.getProgresser().EndInitialize();
    }

    private List<AbstractSingleTemplateAction> CreateLogicUnits(AcctBookInfo bookInfo) {
        ArrayList<AbstractSingleTemplateAction> logicUnits = new ArrayList<AbstractSingleTemplateAction>();
        if (bookInfo.getBuildVoucherType() == BuildVoucherType.OnlyGLVoucher) {
            logicUnits.add((AbstractSingleTemplateAction)new CreatePluginAction());
            logicUnits.add((AbstractSingleTemplateAction)new InitVariableAction());
            logicUnits.add((AbstractSingleTemplateAction)new CheckRightAction());
            logicUnits.add((AbstractSingleTemplateAction)new BeginNetControlAction());
            logicUnits.add((AbstractSingleTemplateAction)new LoadBizVoucherByBookAction());
            logicUnits.add((AbstractSingleTemplateAction)new SplitTaskAction());
        } else {
            logicUnits.add((AbstractSingleTemplateAction)new CreatePluginAction());
            logicUnits.add((AbstractSingleTemplateAction)new InitVariableAction());
            logicUnits.add((AbstractSingleTemplateAction)new CheckRightAction());
            logicUnits.add((AbstractSingleTemplateAction)new BeginNetControlAction());
            logicUnits.add((AbstractSingleTemplateAction)new CreateQueryParemeterAction());
            logicUnits.add((AbstractSingleTemplateAction)new BuildFilterAction());
            logicUnits.add(new LoadSourceBillIdsAction());
            logicUnits.add((AbstractSingleTemplateAction)new SplitTaskAction());
        }
        return logicUnits;
    }
}

