/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singletplaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.fi.ai.VchTplBizGroup;
import kd.fi.ai.VchTplEntry;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.dap.DapConfig;
import kd.fi.ai.enums.EventPagingEnum;
import kd.fi.ai.mservice.builder.helper.SourceBillHelper;
import kd.fi.ai.mservice.builder.reporter.DapReportUtil;
import kd.fi.ai.mservice.builder.singletplaction.AbstractSingleTemplateAction;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.ai.util.FormulaEngineUtil;
import kd.fi.v2.fah.utils.StringUtils;
import org.apache.commons.collections4.ListUtils;

public class LoadSourceBillIdsAction
extends AbstractSingleTemplateAction {
    protected void DoAction() {
        QFilter[] qFilters;
        super.DoAction();
        this.WriteInfoLog(ResManager.loadKDString((String)"\u5f00\u59cb\u8bfb\u53d6\u7b26\u5408\u6761\u4ef6\u7684\u6e90\u5355\u5185\u7801", (String)"LoadSourceBillIdsAction_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
        MainEntityType mainEntityType = SourceBillHelper.getMainEntityType((String)this.templateContext.getSourceBill().getEntityNumber());
        String pkFieldName = mainEntityType.getPrimaryKey().getName();
        String entityNumber = this.templateContext.getSourceBill().getEntityNumber();
        if (this.templateResult.getQFilters().size() > 0) {
            qFilters = new QFilter[this.templateResult.getQFilters().size()];
            qFilters = this.templateResult.getQFilters().toArray(qFilters);
        } else {
            qFilters = new QFilter[]{};
        }
        List<Object> billIds = new ArrayList();
        if (this.templateContext.getVchTemplate().getEventClassId() != 0L) {
            this.getEventId();
            return;
        }
        for (QFilter qf : qFilters) {
            if (!pkFieldName.equalsIgnoreCase(qf.getProperty())) continue;
            Collection ids = (Collection)qf.getValue();
            int size = ids.size();
            if (size > 1000) {
                HashSet idcache = new HashSet(1000);
                int i = 0;
                for (Object id : ids) {
                    idcache.add(id);
                    if (++i % 1000 != 0 && i != size) continue;
                    qf.__setValue(idcache);
                    billIds.addAll(QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])qFilters, null, (int)-1));
                    idcache.clear();
                }
                break;
            }
            billIds = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])qFilters, null, (int)-1);
            break;
        }
        this.templateResult.getSrcBillIds().addAll(billIds);
        DapConfig cfg = this.templateContext.getSourceBill().getConfig();
        int billsize = billIds.size();
        if (billsize > 0 && !cfg.isEntrysum()) {
            Map entryTypes = mainEntityType.getAllEntities();
            for (EntityType et : entryTypes.values()) {
                int entryMax;
                if (!(et instanceof EntryType) || et instanceof SubEntryType || et instanceof LinkEntryType || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)et.getAlias())) continue;
                boolean hasProperty = false;
                block5: for (VchTplBizGroup bp : this.templateContext.getVchTemplate().getBizGroups()) {
                    for (VchTplEntry tplentry : bp.getVchEntrys()) {
                        String[] amtVars = null;
                        if (!"@autoCal".equals(tplentry.getOriAmountSet())) {
                            for (String var : amtVars = FormulaEngineUtil.extractVariablesFromCache((String)tplentry.getOriAmountSet(), (boolean)this.context.isCacheExtractVariables())) {
                                if (!et.getProperties().containsKey((Object)var)) continue;
                                hasProperty = true;
                                break block5;
                            }
                        }
                        if ("@autoCal".equals(tplentry.getLocalAmountSet())) continue;
                        for (String var : amtVars = FormulaEngineUtil.extractVariablesFromCache((String)tplentry.getLocalAmountSet(), (boolean)this.context.isCacheExtractVariables())) {
                            if (!et.getProperties().containsKey((Object)var)) continue;
                            hasProperty = true;
                            break block5;
                        }
                    }
                }
                if (!hasProperty) continue;
                String entryTable = et.getAlias();
                ISimpleProperty p = et.getPrimaryKey();
                String entryPKName = p.getAlias();
                long count = 0L;
                int n = entryMax = this.templateContext.getEntryMax() == null ? 50000 : this.templateContext.getEntryMax();
                if (billsize > 10000) {
                    count = entryMax + 1;
                } else {
                    try {
                        count = this.queryCount(mainEntityType.getDBRouteKey(), entryTable, billIds);
                    }
                    catch (Exception e) {
                        this.WriteInfoLog(e.getMessage());
                    }
                }
                boolean bl = this.templateContext.getEntryMax() == null ? count > (long)entryMax || count > 10000L && count / (long)billsize >= 20L : count > (long)entryMax;
                boolean isSuperEntry = bl;
                if (!isSuperEntry) continue;
                this.WriteInfoLog(String.format(ResManager.loadKDString((String)"\u8d85\u5927\u5206\u5f55--\u5171\u53d6\u5230\u7684\u6e90\u5355\u5206\u5f55\u6570\uff1a%s", (String)"LoadSourceBillIdsAction_1", (String)"fi-ai-mservice", (Object[])new Object[0]), count));
                if (billsize > 1000) {
                    HashSet<Object> idcache = new HashSet<Object>(1000);
                    int i = 0;
                    for (Object id : billIds) {
                        idcache.add(id);
                        if (++i % 1000 != 0 && i != billsize) continue;
                        Map<Object, List<Long>> billEntryIds = this.loadBillEntryIds(mainEntityType, idcache.toArray(), entryTable, entryPKName);
                        this.templateResult.getBillEntryIds().putAll(billEntryIds);
                        idcache.clear();
                    }
                } else {
                    Map<Object, List<Long>> billEntryIds = this.loadBillEntryIds(mainEntityType, billIds.toArray(), entryTable, entryPKName);
                    this.templateResult.getBillEntryIds().putAll(billEntryIds);
                }
                this.templateResult.setGroupEntryName(et.getName());
                break;
            }
        }
        this.WriteInfoLog(String.format(ResManager.loadKDString((String)"\u5171\u53d6\u5230\u7684\u6e90\u5355\u6570\uff1a%s", (String)"LoadSourceBillIdsAction_2", (String)"fi-ai-mservice", (Object[])new Object[0]), Integer.toString(billsize)));
        Set sourceBillIds = this.templateContext.getSourceBill().getBillIds();
        if (billsize < sourceBillIds.size()) {
            HashSet invalidIds = new HashSet();
            HashSet billIdSet = new HashSet(billIds);
            for (Object id : sourceBillIds) {
                if (billIdSet.contains(id)) continue;
                invalidIds.add(id);
            }
            DataSet billSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityNumber, (String)("id," + DapBuildVoucherCommonUtil.getBillNoFormBill((String)entityNumber)), (QFilter[])new QFilter[]{new QFilter("id", "in", invalidIds)}, null);
            ArrayList<DapReportUtil.ReportData> reports = new ArrayList<DapReportUtil.ReportData>(invalidIds.size());
            for (Row row : billSet) {
                DapReportUtil.ReportData rep = new DapReportUtil.ReportData();
                rep.setBook(this.templateContext.getBook());
                rep.setSourceBill(this.templateContext.getSourceBill());
                rep.setSourceBillId((Object)row.getLong("id"));
                rep.setSourceBillNo(row.getString("billno"));
                rep.setVchTemplateID(this.templateContext.getVchTemplate() == null ? null : this.templateContext.getVchTemplate().getId());
                rep.setCheckItem(VoucherCheckItem.Bill);
                rep.setErrLevel(VoucherErrLevel.Error);
                rep.setErrMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u6ee1\u8db3\u51ed\u8bc1\u6a21\u677f\u914d\u7f6e\u6761\u4ef6\uff1a\u201c%s\u201d\u3002", (String)"LoadSourceBillIdsAction_3", (String)"fi-ai-mservice", (Object[])new Object[0]), this.templateResult.getqFiltersAlias()));
                reports.add(rep);
            }
            if (reports.size() > 0) {
                DapReportUtil.saveReport((DapReportUtil.ReportData[])reports.toArray(new DapReportUtil.ReportData[0]), (String)"", (String)"");
            }
        }
    }

    private long queryCount(String RouteKey, String entryTable, List<Object> billIds) {
        List keyLists = ListUtils.partition(billIds, (int)1000);
        long c = 0L;
        for (List ids : keyLists) {
            HintCondition fidHint = new HintCondition("fid", "in", (Object)ids);
            ShardingHintContext ctx = ShardingHintContext.createAndSet((String)entryTable, (HintCondition[])new HintCondition[]{fidHint}).prepareShardingIndex();
            Throwable throwable = null;
            try {
                c += this.getEntryCount(RouteKey, entryTable, ids).longValue();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ctx == null) continue;
                if (throwable != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ctx.close();
            }
        }
        return c;
    }

    private Long getEntryCount(String routeKey, String entryTable, List<Object> ids) {
        return (Long)DB.query((DBRoute)DBRoute.of((String)routeKey), (String)("select count(1) as c from " + entryTable + " where fid in(" + StringUtils.join((Object[])ids.toArray(), (String)",") + ")"), (Object[])new String[0], rh -> {
            if (rh.next()) {
                return rh.getLong("c");
            }
            return 0L;
        });
    }

    private void getEventId() {
        QFilter isPage = new QFilter("paging", "!=", (Object)EventPagingEnum.NO_COMMIT.getStatus());
        QFilter ids = new QFilter("id", "in", (Object)this.templateContext.getSourceBill().getBillIds());
        HashSet<Object> evtIds = new HashSet<Object>();
        try (DataSet dsEvent = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + ".getEventId"), (String)"ai_event", (String)"id", (QFilter[])new QFilter[]{ids, isPage}, null);){
            for (Row row : dsEvent) {
                evtIds.add(row.get("id"));
            }
        }
        HashSet<Object> evtBlockIds = new HashSet<Object>();
        QFilter blockIdFilter = new QFilter("eventid", "in", evtIds);
        try (DataSet dsBlockEvent = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + ".getEventBlockId"), (String)"ai_eventblock", (String)"eventid", (QFilter[])new QFilter[]{blockIdFilter}, null);){
            for (Row row : dsBlockEvent) {
                evtBlockIds.add(row.get("eventid"));
            }
        }
        if (!evtBlockIds.isEmpty()) {
            evtIds.removeAll(evtBlockIds);
        }
        this.templateResult.getSrcBillIds().addAll(evtIds);
    }

    private Map<Object, List<Long>> loadBillEntryIds(MainEntityType mainEntityType, Object[] billIds, String entryTable, String entryPKName) {
        Map billEntryIds = (Map)DB.query((DBRoute)DBRoute.of((String)mainEntityType.getDBRouteKey()), (String)("select fid as id," + entryPKName + " as entryid from " + entryTable + " where fid in(" + kd.bos.dataentity.utils.StringUtils.join((Object[])billIds, (String)",") + ")"), (Object[])new String[0], rh -> {
            HashMap bes = new HashMap();
            while (rh.next()) {
                List<Long> entryids;
                Object id = rh.getObject("id");
                long entryid = rh.getLong("entryid");
                if (bes.containsKey(id)) {
                    entryids = (List)bes.get(id);
                    entryids.add(entryid);
                    continue;
                }
                entryids = new ArrayList();
                entryids.add(entryid);
                bes.put(id, entryids);
            }
            return bes;
        });
        return billEntryIds;
    }
}

