/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.ai.dap.cache.CacheHelper;
import kd.bos.ext.fi.ai.dap.cache.CacheModule;
import kd.bos.ext.fi.ai.dap.cache.DistributeCache;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.GenVoucherMemoryMergeTask;
import kd.fi.ai.dap.MutexRequireUtil;
import kd.fi.ai.mservice.builder.BuildVchScheme;
import kd.fi.ai.mservice.builder.plugin.VchPlugProxy;
import kd.fi.ai.mservice.builder.reporter.DapReportUtil;
import kd.fi.ai.mservice.service.GenerateVoucherProcess;
import kd.fi.ai.mservice.service.MergeGLVoucherImpl;
import kd.fi.ai.mservice.service.MergeGLVoucherServiceUtil;
import kd.fi.ai.mservice.util.BuildVoucherUtils;
import kd.fi.ai.service.BuildVoucherService;
import kd.fi.ai.util.BuildVoucherUtil;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.ai.util.TccUtil;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.v2.fah.log.FahPoaFeatureMonitor;
import kd.fi.v2.fah.utils.DateValueUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class BuildVoucherServiceImpl
implements BuildVoucherService {
    private static final Log log = LogFactory.getLog(BuildVoucherServiceImpl.class);

    public String buildVoucher(String entityKey, Set<Long> billids) {
        return this.buildVoucher(entityKey, billids, null, null);
    }

    public String buildVoucher(String entityKey, Set<Long> billids, String paramJson) {
        return this.buildVoucher(entityKey, billids, paramJson, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String buildVoucher(String entityKey, Set<Long> billids, String paramJson, String schemeStr) {
        this.genVoucherTip(paramJson);
        Set<Long> lockIDs = new HashSet<Long>(billids);
        boolean isOpenMutexLock = this.getIsOpenMutexLock(paramJson);
        Map<String, Object> paramMap = this.parseFromJsonString(paramJson);
        try {
            if (isOpenMutexLock && !paramMap.containsKey("preBuild")) {
                lockIDs = MutexRequireUtil.requireMutexBatch((String)entityKey, billids);
            }
            HashSet<Long> lockBillIds = new HashSet<Long>(lockIDs);
            if (TccUtil.isDtxEnable()) {
                BuildVoucherServiceImpl.checkUnfinishedTx(entityKey, lockBillIds);
            }
            String string = this.generateVoucherProcess(entityKey, lockBillIds, false, paramJson, false, null, this.getschema(schemeStr), this.getopr(paramJson), this.getbuildType(paramJson), 0L);
            return string;
        }
        finally {
            if (isOpenMutexLock) {
                try (TXHandle x = TX.requiresNew();){
                    try {
                        MutexRequireUtil.batchRelease((String)entityKey, lockIDs);
                    }
                    catch (Throwable t) {
                        x.markRollback();
                    }
                }
            }
        }
    }

    public String onTimeBuildVoucher(String entityKey, Set<Long> billids) {
        return this.onTimeBuildVoucher(entityKey, null, billids);
    }

    public String onTimeBuildVoucher(String entityKey, String onTimeOperateKey, Set<Long> billids) {
        return this.onTimeBuildVoucher(entityKey, onTimeOperateKey, billids, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String onTimeBuildVoucher(String entityKey, String onTimeOperateKey, Set<Long> billids, String params) {
        this.genVoucherTip(params);
        Set<Long> lockIDs = new HashSet<Long>(billids);
        boolean isOpenMutexLock = this.getIsOpenMutexLock(params);
        Map<String, Object> paramMap = this.parseFromJsonString(params);
        try {
            if (isOpenMutexLock && !paramMap.containsKey("preBuild")) {
                lockIDs = MutexRequireUtil.requireMutexBatch((String)entityKey, billids);
            }
            HashSet<Long> lockBillIds = new HashSet<Long>(lockIDs);
            if (TccUtil.isDtxEnable()) {
                BuildVoucherServiceImpl.checkUnfinishedTx(entityKey, lockBillIds);
            }
            String string = this.generateVoucherProcess(entityKey, lockBillIds, true, params, false, onTimeOperateKey, null, "generateVoucher", "E", 0L);
            return string;
        }
        finally {
            if (isOpenMutexLock) {
                try (TXHandle x = TX.requiresNew();){
                    try {
                        MutexRequireUtil.batchRelease((String)entityKey, lockIDs);
                    }
                    catch (Throwable t) {
                        x.markRollback();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String iepBuildVoucher(String entityKey, Set<Long> billids) {
        Set lockIDs = new HashSet();
        try {
            lockIDs = MutexRequireUtil.requireMutexBatch((String)entityKey, billids);
            HashSet<Long> lockBillIds = new HashSet<Long>(lockIDs);
            if (TccUtil.isDtxEnable()) {
                BuildVoucherServiceImpl.checkUnfinishedTx(entityKey, lockBillIds);
            }
            String string = this.generateVoucherProcess(entityKey, lockBillIds, false, null, true, null, null, "generateVoucher", "B", 0L);
            return string;
        }
        finally {
            try (TXHandle x = TX.requiresNew();){
                try {
                    MutexRequireUtil.batchRelease((String)entityKey, lockIDs);
                }
                catch (Throwable t) {
                    x.markRollback();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String eventBuildVoucher(String entityKey, Set<Long> billids, String paramJson, Long eventClass) {
        this.genVoucherTip(paramJson);
        Set<Long> lockIDs = new HashSet<Long>(billids);
        boolean isOpenMutexLock = this.getIsOpenMutexLock(paramJson);
        Map<String, Object> paramMap = this.parseFromJsonString(paramJson);
        try {
            if (isOpenMutexLock && !paramMap.containsKey("preBuild")) {
                lockIDs = MutexRequireUtil.requireMutexBatch((String)entityKey, billids);
            }
            HashSet<Long> lockBillIds = new HashSet<Long>(lockIDs);
            if (TccUtil.isDtxEnable()) {
                BuildVoucherServiceImpl.checkUnfinishedTx(entityKey, lockBillIds);
            }
            String opr = this.getopr(paramJson);
            String buildType = this.getbuildType(paramJson);
            String string = this.generateVoucherProcess(entityKey, lockBillIds, false, paramJson, false, null, null, opr, buildType, eventClass);
            return string;
        }
        finally {
            if (isOpenMutexLock) {
                try (TXHandle x = TX.requiresNew();){
                    try {
                        MutexRequireUtil.batchRelease((String)entityKey, lockIDs);
                    }
                    catch (Throwable t) {
                        x.markRollback();
                    }
                }
            }
        }
    }

    public String mergeGLVouchers(String mergeCode, String billEntityKey) {
        return new MergeGLVoucherImpl().mergeGLVouchers(mergeCode, billEntityKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateVoucherProcess(String billTypeKey, Set<Long> billids, boolean onTime, String paramJson, boolean iep, String onTimeOperateKey, BuildVchScheme schema, String opr, String buildType, Long eventClass) {
        DistributeCache distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.GenerateVoucherTaskProcess);
        String generateProcessKey = this.getGenerateProcessKey(paramJson);
        String currTaskKey = "currProgress";
        Date start = new Date();
        GenVoucherMemoryMergeTask gvMemory = new GenVoucherMemoryMergeTask(generateProcessKey, billids, billTypeKey);
        Map<String, Integer> cacheDataMap = new HashMap<String, Object>(8);
        String progressinfo = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u5206\u6279\u6570\u636e\uff0c\u5f53\u524d\u603b\u4efb\u52a1\u5355\u636e\u6570\u4e3a\uff1a\u201c%1$s\u201d\u3002", (String)"BuildVoucherServiceImpl_7", (String)"fi-ai-mservice", (Object[])new Object[0]), billids.size());
        cacheDataMap.put(currTaskKey, gvMemory.getCurr_progress());
        cacheDataMap.put(currTaskKey + "_info", (Integer)((Object)progressinfo));
        cacheDataMap.put("billids", (Integer)((Object)SerializationUtils.toJsonString(billids)));
        distributeCache.put(generateProcessKey, SerializationUtils.toJsonString(cacheDataMap));
        Map<String, Object> paramMap = this.parseFromJsonString(paramJson);
        int split_size = billids.size() > 10000 ? 2000 : 1000;
        List all_task_billids = DapBuildVoucherCommonUtil.splitSet(billids, (int)split_size);
        String result = null;
        int currprogressjilu = 0;
        long startTime = 0L;
        int batchIdx = 0;
        try {
            for (Set currIds : all_task_billids) {
                Object stop;
                ++batchIdx;
                startTime = System.currentTimeMillis();
                String currProgress = distributeCache.get(generateProcessKey);
                if (currProgress != null && (stop = (cacheDataMap = (Map)SerializationUtils.fromJsonString((String)currProgress, Map.class)).get("stop")) != null) {
                    BuildVoucherUtils.rebackCurrTaskBizVoucherData((Set)gvMemory.getProgressTaskHasDone(), (Date)start, (String)billTypeKey);
                    this.poaFeatureMonitor_output(billTypeKey, billids.size(), true, onTime, iep, schema != null, buildType, eventClass, generateProcessKey);
                    String string = null;
                    return string;
                }
                if (!gvMemory.isSingleTask()) {
                    progressinfo = String.format(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1\u6279\u6b21\u201c%1$s\u201d\u6761\uff0c\u5df2\u5b8c\u6210\u751f\u6210\u51ed\u8bc1\u201c%2$s\u201d\u6761\u3002", (String)"BuildVoucherServiceImpl_8", (String)"fi-ai-mservice", (Object[])new Object[0]), currIds.size(), gvMemory.getProgressTaskHasDone().size() + " / " + billids.size());
                    cacheDataMap.put(currTaskKey, gvMemory.getCurr_progress());
                    cacheDataMap.put(currTaskKey + "_info", (Integer)((Object)progressinfo));
                    distributeCache.put(generateProcessKey, SerializationUtils.toJsonString(cacheDataMap));
                }
                Map<String, Set<Long>> spitBillBuildVoucherType = this.spitBillBuildVoucherType(billTypeKey, currIds);
                Set<Long> isHasBizVoucher = spitBillBuildVoucherType.get("isHasBizVoucher");
                Set<Long> isNotHasBizVoucher = spitBillBuildVoucherType.get("isNotHasBizVoucher");
                if (!isHasBizVoucher.isEmpty()) {
                    boolean checkHasBizVoucherMaxSize = this.checkHasBizVoucherMaxSize(isHasBizVoucher);
                    if (checkHasBizVoucherMaxSize) {
                        result = result != null ? result : ResManager.loadKDString((String)"\u5f53\u524d\u6279\u6b21\u4e1a\u52a1\u51ed\u8bc1\u5206\u5f55\u6570\u5927\u4e8e100000\uff0c\u6682\u4e0d\u652f\u6301\u7531\u4e1a\u52a1\u51ed\u8bc1\u751f\u6210\u603b\u8d26\u51ed\u8bc1\u3002", (String)"BuildVoucherServiceImpl_6", (String)"fi-ai-mservice", (Object[])new Object[0]);
                    } else {
                        GenerateVoucherProcess generateVoucherProcess = new GenerateVoucherProcess(billTypeKey, isHasBizVoucher, onTime, this.insertisBizGenerateVoucherParams(paramJson), iep, schema, opr, buildType, gvMemory, eventClass);
                        generateVoucherProcess.setOnTimeOperateKey(onTimeOperateKey);
                        generateVoucherProcess.setBuildVoucherType(this.getbuildVoucherType(paramJson));
                        String generateVoucher = generateVoucherProcess.generateVoucher();
                        if (generateVoucher != null) {
                            String string = result = result != null ? result : generateVoucher;
                        }
                    }
                }
                if (!isNotHasBizVoucher.isEmpty()) {
                    GenerateVoucherProcess generateVoucherProcess = new GenerateVoucherProcess(billTypeKey, isNotHasBizVoucher, onTime, paramJson, iep, schema, opr, buildType, gvMemory, eventClass);
                    generateVoucherProcess.setOnTimeOperateKey(onTimeOperateKey);
                    generateVoucherProcess.setBuildVoucherType(this.getbuildVoucherType(paramJson));
                    String generateVoucher = generateVoucherProcess.generateVoucher();
                    if (generateVoucher != null) {
                        result = result != null ? result : generateVoucher;
                    }
                }
                gvMemory.currTaskToDone(currIds);
                log.info(String.format("\u7b2c%1$s\u6279\u5355\u636e\u5b8c\u6210\u751f\u6210\u51ed\u8bc1\uff0c\u5f53\u524d\u6279\u6b21\u751f\u6210\u51ed\u8bc1\u5355\u636e%2$s\u6761\uff0c\u5df2\u5b8c\u6210\u751f\u6210\u51ed\u8bc1\u5355\u636e%3$s/%4$s\u6761\uff0c\u5f53\u524d\u6279\u6b21\u8017\u65f6\uff1a%5$sms", batchIdx, currIds.size(), gvMemory.getProgressTaskHasDone().size(), billids.size(), System.currentTimeMillis() - startTime));
            }
            if (!gvMemory.isSingleTask()) {
                startTime = System.currentTimeMillis();
                int mergeSize = gvMemory.getNeed_mergeVoucher_headerSize();
                progressinfo = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u6700\u7ec8\u5408\u5e76\uff0c\u5171\u9700\u8981\u6267\u884c\u201c%1$s\u201d\u4efd\u3002", (String)"BuildVoucherServiceImpl_9", (String)"fi-ai-mservice", (Object[])new Object[0]), mergeSize);
                cacheDataMap.put(currTaskKey, 90);
                cacheDataMap.put(currTaskKey + "_info", (Integer)((Object)progressinfo));
                distributeCache.put(generateProcessKey, SerializationUtils.toJsonString(cacheDataMap));
                Map glVoucher_seq_entry = gvMemory.getGlVoucher_seq_entry();
                Object mergeGLVouchers = null;
                if (!paramMap.containsKey("preBuild")) {
                    MergeGLVoucherServiceUtil.mergeGLVouchers(gvMemory.getCurr_task_needMergeVoucher(), billTypeKey, gvMemory.getVch_tpl_entry_sort(), gvMemory.getTrackersNotToSave(), glVoucher_seq_entry, gvMemory.getBuildVchTask_contextData(), gvMemory.getInsertedEntryIdMap());
                }
                if (mergeGLVouchers != null) {
                    result = result != null ? result : mergeGLVouchers;
                }
                log.info("\u6267\u884c\u6700\u7ec8\u51ed\u8bc1\u5408\u5e76\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
            }
            currprogressjilu = 99;
            cacheDataMap.put(currTaskKey, 99);
            cacheDataMap.put(currTaskKey + "_info", (Integer)((Object)ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5b8c\u6210\uff0c\u6b63\u5728\u6784\u9020\u51ed\u8bc1\u751f\u6210\u62a5\u544a\uff0c\u6b63\u5728\u7ec4\u88c5\u64cd\u4f5c\u7ed3\u679c\u3002", (String)"BuildVoucherServiceImpl_10", (String)"fi-ai-mservice", (Object[])new Object[0])));
            distributeCache.put(generateProcessKey, SerializationUtils.toJsonString(cacheDataMap));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            boolean ec = eventClass != 0L;
            cacheDataMap.put(currTaskKey + "_error", (Integer)((Object)ResManager.loadKDString((String)"\u51ed\u8bc1\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u751f\u6210\u62a5\u544a\u3002", (String)"BuildVoucherServiceImpl_11", (String)"fi-ai-mservice", (Object[])new Object[0])));
            currprogressjilu = 100;
            cacheDataMap.put(currTaskKey, 100);
            distributeCache.put(generateProcessKey, SerializationUtils.toJsonString(cacheDataMap));
            try (TXHandle x = TX.requiresNew();){
                try {
                    DapVoucherUtil.generateExceptionReport((Exception)e, (String)billTypeKey, new ArrayList<Long>(billids), (String)e.getMessage(), null, null, (Boolean)ec, null, (Date)start);
                    BuildVoucherUtils.rebackCurrTaskBuildVoucherData(billids, (Date)start, (String)billTypeKey);
                }
                catch (Throwable t) {
                    log.error(t);
                    x.markRollback();
                }
            }
        }
        finally {
            cacheDataMap.put(currTaskKey, currprogressjilu);
            distributeCache.put(generateProcessKey, SerializationUtils.toJsonString(cacheDataMap));
            if (generateProcessKey.contains("neverneedprocess")) {
                distributeCache.remove(generateProcessKey);
            }
        }
        this.poaFeatureMonitor_output(billTypeKey, billids.size(), false, onTime, iep, schema != null, buildType, eventClass, generateProcessKey);
        return result;
    }

    private Map<String, Object> parseFromJsonString(String paramJson) {
        return StringUtils.isEmpty((String)paramJson) ? new HashMap(0) : (Map)SerializationUtils.fromJsonString((String)paramJson, Map.class);
    }

    private BuildVchScheme getschema(String schemeStr) {
        BuildVchScheme schema = null;
        if (schemeStr != null) {
            schema = (BuildVchScheme)SerializationUtils.fromJsonString((String)schemeStr, BuildVchScheme.class);
        }
        return schema;
    }

    private String getopr(String paramsJson) {
        String opr = null;
        if (paramsJson != null) {
            Map params = (Map)SerializationUtils.fromJsonString((String)paramsJson, Map.class);
            opr = params.get("opr") != null ? params.get("opr").toString() : null;
        }
        opr = opr == null ? "generateVoucher" : opr;
        return opr;
    }

    private String getbuildType(String paramsJson) {
        String buildType = null;
        if (paramsJson != null) {
            Map params = (Map)SerializationUtils.fromJsonString((String)paramsJson, Map.class);
            buildType = params.get("buildType") != null ? params.get("buildType").toString() : null;
        }
        buildType = buildType == null ? "A" : buildType;
        return buildType;
    }

    private String getbuildVoucherType(String params) {
        Map param;
        String bvType = "0";
        if (params != null && (param = (Map)SerializationUtils.fromJsonString((String)params, Map.class)) != null && param.get("BuildVoucherType") != null) {
            bvType = (String)param.get("BuildVoucherType");
        }
        return bvType;
    }

    private String getGenerateProcessKey(String params) {
        Map param;
        String gpk = "-neverneedprocess-" + UUID.randomUUID().toString();
        if (params != null && (param = (Map)SerializationUtils.fromJsonString((String)params, Map.class)) != null && param.get("GenerateProcessKey") != null) {
            gpk = (String)param.get("GenerateProcessKey");
        }
        return gpk;
    }

    private Map<String, Set<Long>> spitBillBuildVoucherType(String billTypeKey, Set<Long> billids) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(2);
        HashSet<Long> isNotHasBizVoucherCol = new HashSet<Long>(billids);
        HashSet<Long> isHasBizVoucherCol = new HashSet<Long>(billids.size());
        HashMap<Long, Long> bizVoucherToBillID = new HashMap<Long, Long>(2);
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.service.BuildVoucherServiceImpl", (String)"ai_bizvoucher", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebill", "=", (Object)billTypeKey), new QFilter("sourcebillid", "in", billids), new QFilter("glvoucherid", "=", (Object)0L)}, null);){
            for (Row row : queryDataSet) {
                Long sid = row.getLong("sourcebillid");
                isHasBizVoucherCol.add(sid);
                isNotHasBizVoucherCol.remove(sid);
                bizVoucherToBillID.put(row.getLong("id"), row.getLong("sourcebillid"));
            }
        }
        if (bizVoucherToBillID.size() > 0) {
            Set<Long> hasEntryBizVoucherIds = this.hasEntryBizVoucherIds(bizVoucherToBillID.keySet());
            HashSet goodBills = new HashSet(2);
            if (hasEntryBizVoucherIds.size() < bizVoucherToBillID.size()) {
                for (Long bvid : hasEntryBizVoucherIds) {
                    goodBills.add(bizVoucherToBillID.remove(bvid));
                }
                String joinIds = QFilterBuilder.buildSQLParamHolder((int)bizVoucherToBillID.size());
                DB.execute((DBRoute)DBRoute.of((String)"ai"), (String)("delete from t_ai_bizvoucher where fid in " + joinIds), (Object[])bizVoucherToBillID.keySet().toArray());
                isHasBizVoucherCol.removeAll(bizVoucherToBillID.values());
                isHasBizVoucherCol.addAll(goodBills);
                isNotHasBizVoucherCol.addAll(bizVoucherToBillID.values());
                isNotHasBizVoucherCol.removeAll(goodBills);
            }
        }
        result.put("isHasBizVoucher", isHasBizVoucherCol);
        result.put("isNotHasBizVoucher", isNotHasBizVoucherCol);
        return result;
    }

    private Set<Long> hasEntryBizVoucherIds(Collection<Long> bizVoucherIdList) {
        HashSet<Long> normalIds = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select b.fid as id from t_ai_bizvoucher as b where ", new Object[0]).appendIn(" b.fid", new ArrayList<Long>(bizVoucherIdList)).append(" and exists ( select 1 from t_ai_bizvoucherentry as e where e.fid=b.fid )", new Object[0]);
        try (DataSet qd = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);){
            for (Row row : qd) {
                normalIds.add(row.getLong("id"));
            }
        }
        return normalIds;
    }

    private boolean getIsOpenMutexLock(String params) {
        boolean result = true;
        if (params != null) {
            Map param = (Map)SerializationUtils.fromJsonString((String)params, Map.class);
            if (param != null && param.get("isopenmutexlock") != null) {
                result = (Boolean)param.get("isopenmutexlock");
            }
            if (param != null && param.get("preBuild") != null) {
                return false;
            }
        }
        return result;
    }

    private String insertisBizGenerateVoucherParams(String paramJson) {
        String params = "";
        if (paramJson != null) {
            Map pj = (Map)SerializationUtils.fromJsonString((String)paramJson, Map.class);
            pj.put("isBizGenerateVoucher", true);
            params = SerializationUtils.toJsonString((Object)pj);
        } else {
            HashMap<String, Boolean> pj = new HashMap<String, Boolean>(1);
            pj.put("isBizGenerateVoucher", true);
            params = SerializationUtils.toJsonString(pj);
        }
        return params;
    }

    private void genVoucherTip(String paramJson) {
        DistributeCache distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.GenerateVoucherTaskProcess);
        String generateProcessKey = this.getGenerateProcessKey(paramJson);
        String currTaskKey = "currProgress";
        HashMap<String, Object> cacheDataMap = new HashMap<String, Object>(8);
        String progressinfo = ResManager.loadKDString((String)"\u6b63\u5728\u5bf9\u5f85\u751f\u6210\u51ed\u8bc1\u5355\u636e\u8fdb\u884c\u9501\u5b9a\u3002", (String)"BuildVoucherServiceImpl_12", (String)"fi-ai-mservice", (Object[])new Object[0]);
        cacheDataMap.put(currTaskKey, 1);
        cacheDataMap.put(currTaskKey + "_info", progressinfo);
        distributeCache.put(generateProcessKey, SerializationUtils.toJsonString(cacheDataMap));
    }

    private boolean checkHasBizVoucherMaxSize(Set<Long> isHasBizVoucher) {
        boolean result = false;
        String sql = "select fvalue from t_ai_sysparam where fkey = 'bizvoucherbuildvouchermaxsize';";
        int max_size = 100000;
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.operate.BuildVoucher", (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                max_size = ((Row)iterator.next()).getInteger("fvalue");
            }
        }
        String joinIds = QFilterBuilder.buildSQLParamHolder((int)isHasBizVoucher.size());
        sql = "select count(fentryid) as sizes from t_ai_bizvoucherentry where fid in (select fid from t_ai_bizvoucher where fsourcebillid in " + joinIds + ")";
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.mservice.service.BuildVoucherServiceImpl", (DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])isHasBizVoucher.toArray());){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                Integer integer = ((Row)iterator.next()).getInteger("sizes");
                if (integer <= max_size) continue;
                result = true;
            }
        }
        return result;
    }

    public String getVoucherEntity(Long voucherid) {
        return VchPlugProxy.getVoucherEntity((Long)voucherid);
    }

    public String getPreviewVoucherEntity(Long orgId, Long booktypeId) {
        return VchPlugProxy.getPreviewVoucherEntity((Long)orgId, (Long)booktypeId);
    }

    public static void checkUnfinishedTx(String entityKey, Set<Long> billIds) {
        if (null == billIds || billIds.isEmpty()) {
            return;
        }
        List businessIds = billIds.stream().map(String::valueOf).collect(Collectors.toList());
        List unFinishedIds = TxCheckUtil.loadUnfinishedTx((String)("dap_" + entityKey), businessIds);
        if (null != unFinishedIds && !unFinishedIds.isEmpty()) {
            List<Long> unFinishedIdList = unFinishedIds.stream().map(Long::parseLong).collect(Collectors.toList());
            unFinishedIdList.forEach(billIds::remove);
            try {
                String pkKey = EntityMetadataCache.getDataEntityType((String)entityKey).getPrimaryKey().getName();
                DynamicObject[] billDysColl = BusinessDataServiceHelper.load((String)entityKey, (String)(pkKey + "," + DapBuildVoucherCommonUtil.getBillNoFormBill((String)entityKey)), (QFilter[])new QFilter(pkKey, "in", unFinishedIdList).toArray());
                if (null != billDysColl && billDysColl.length > 0) {
                    DapReportUtil.saveReport((String)entityKey, (DynamicObject[])billDysColl, (String)ResManager.loadKDString((String)"\u5355\u636e\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d,\u4e0d\u80fd\u751f\u6210\u51ed\u8bc1\u3002", (String)"BuildVoucherServiceImpl_13", (String)"fi-ai-mservice", (Object[])new Object[0]), (String)"", (String)"");
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    private void poaFeatureMonitor_output(String billType, int dataCount, boolean progressStop, boolean onTime, boolean iep, boolean withSchema, String buildType, Long eventClass, String generateProcessKey) {
        boolean saveBizVoucherEntry = BuildVoucherUtil.check_SaveBizVoucherEntry((String)generateProcessKey);
        HashMap<String, String> varMap = new HashMap<String, String>(8);
        varMap.put("API", "generateVoucherProcess");
        varMap.put("ProgressStop", String.valueOf(progressStop));
        varMap.put("onTime", String.valueOf(onTime));
        varMap.put("iep", String.valueOf(iep));
        varMap.put("withSchema", String.valueOf(withSchema));
        varMap.put("buildType", buildType);
        varMap.put("eventClass", String.valueOf(eventClass));
        varMap.put("saveBizVoucherEntry", String.valueOf(saveBizVoucherEntry));
        long cost = DateValueUtils.cost();
        FahPoaFeatureMonitor.output((Log)log, (String)"FAH_FEATURE_BUILD_VOUCHER", (int)dataCount, (Long)cost, (String)billType, varMap);
        if (saveBizVoucherEntry) {
            FahPoaFeatureMonitor.output((Log)log, (String)"FI2022_003_001", (int)dataCount, (Long)cost, (String)billType, varMap);
        }
    }
}

