/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.service.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.PersistedArrayRow;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.runtime.CRExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BatchFuncParser;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.ConfigurationUtil;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.IBuildVchReporter;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.SourceBillInfo;
import kd.fi.ai.dap.DapCache;
import kd.fi.ai.dap.DapConfig;
import kd.fi.ai.event.DataSourceFactory;
import kd.fi.ai.event.PkEntryPkPair;
import kd.fi.ai.exception.DapException;
import kd.fi.ai.function.Function;
import kd.fi.ai.function.IBatchFunctionHandler;
import kd.fi.ai.mservice.builder.compiler.SelectedSourceEntity;
import kd.fi.ai.mservice.builder.context.BuildVchContext;
import kd.fi.ai.mservice.builder.context.SingleTaskContext;
import kd.fi.ai.mservice.builder.getvaluehandle.ConditionGetHandle;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.builder.getvaluemode.SourceBillFieldMode;
import kd.fi.ai.mservice.builder.helper.BuildHelper;
import kd.fi.ai.mservice.builder.reporter.BuildVchReporter;
import kd.fi.ai.mservice.service.helper.VchTemplateMainData;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.FieldReplaceUtil;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.v2.fah.dao.biz.ExtDataModelHelper;
import kd.fi.v2.fah.utils.StringUtils;

public class SelectTemplateUtil {
    public static final String USE_TEMP = "useTemp";
    public static final String SELECT_IDS = "selectId";
    public static final String SELECT_VALID_TEMPLATE = "select_valid_template";
    private static Log logger = LogFactory.getLog(SelectTemplateUtil.class);

    public static List<VCHTemplate> getTemplateToList(String entityname, Collection<? extends Object> ids) {
        return SelectTemplateUtil.getTemplateToList(entityname, ids, null);
    }

    public static List<VCHTemplate> getNewTemplateToList(String entityname, Collection<? extends Object> ids, Boolean isValidBills) {
        String value = SysParamConfig.get((String)SELECT_VALID_TEMPLATE);
        int defaltValue = null == value ? 1000 : Integer.parseInt(value);
        isValidBills = ids.size() <= defaltValue;
        return isValidBills != false ? SelectTemplateUtil.getTemplateToList(entityname, ids, null) : SelectTemplateUtil.getTemplates(entityname, ids, null);
    }

    public static List<VCHTemplate> getTemplateToList(String entityname, Collection<? extends Object> ids, List<QFilter> qfilters) {
        List<VCHTemplate> vchTemplate = SelectTemplateUtil.getTemplates(entityname, ids, qfilters);
        List<VCHTemplate> tps = SelectTemplateUtil.getBillValidTemplates(entityname, ids, vchTemplate);
        if (tps.isEmpty()) {
            return vchTemplate;
        }
        return tps;
    }

    public static List<VCHTemplate> getBillValidTemplates(String entityname, Collection<? extends Object> ids, List<VCHTemplate> vchTemplateList) {
        if (vchTemplateList == null) {
            return Collections.emptyList();
        }
        ArrayList<VCHTemplate> list = new ArrayList<VCHTemplate>(vchTemplateList);
        SingleTaskContext taskContext = new SingleTaskContext();
        taskContext.setBuildVchContext((IBuildVchContext)new BuildVchContext());
        taskContext.getBuildVchContext().setReporter((IBuildVchReporter)new BuildVchReporter());
        taskContext.setSourceBill(new SourceBillInfo());
        MainEntityType dataEntityType = null;
        HashMap sourceFields = new HashMap(8);
        HashMap<Long, ConditionGetHandle> vtpFilter = new HashMap<Long, ConditionGetHandle>(8);
        Long eventClassId = 0L;
        String extDataModelEntityName = null;
        for (VCHTemplate vCHTemplate : list) {
            String string = vCHTemplate.getSourceBill();
            if (!string.equals(entityname)) {
                taskContext.setTemplateEntityName(string);
                Map commonAndSourceFieldcol = FieldReplaceUtil.getCommonAndSourceFieldcol((String)string, (String)entityname);
                taskContext.setCommonAndSourceFieldcol(commonAndSourceFieldcol);
            }
            if (dataEntityType == null) {
                if (vCHTemplate.getEventClassId() != 0L) {
                    dataEntityType = AiEventMetaUtil.getEntityType((Object)vCHTemplate.getEventClassId());
                    eventClassId = vCHTemplate.getEventClassId();
                } else {
                    extDataModelEntityName = vCHTemplate.getSourceBill().startsWith("fah_e_") ? vCHTemplate.getSourceBill() : null;
                    String realEntityName = StringUtils.isNotEmpty((String)extDataModelEntityName) ? extDataModelEntityName : entityname;
                    dataEntityType = MetadataServiceHelper.getDataEntityType((String)realEntityName);
                }
            }
            taskContext.setSrcEntityType(dataEntityType);
            if (vCHTemplate.getFilterSet() == null) continue;
            VchTplExpression filterSet = FieldReplaceUtil.replaceFilterSet((VchTplExpression)vCHTemplate.getFilterSet(), (Map)taskContext.getCommonAndSourceFieldcol());
            vCHTemplate.setFilterSet(filterSet);
            String expression = null;
            String oriExp = vCHTemplate.getFilterSet().getExpression();
            try {
                expression = vCHTemplate.getFilterSet().buildFullFormula(dataEntityType);
            }
            catch (Exception e2) {
                logger.error((Throwable)e2);
                throw new DapException(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u201c%1$s\uff08%2$s\uff09\u201d\u9002\u7528\u6761\u4ef6\u89e3\u6790\u53d1\u751f\u9519\u8bef\uff1a\u201c%3$s\u201d\u3002", (String)"SelectTemplateUtil_0", (String)"fi-ai-mservice", (Object[])new Object[0]), vCHTemplate.getDescription(), vCHTemplate.getBillNo(), e2.getMessage()), (Throwable)e2);
            }
            vCHTemplate.getFilterSet().setFilterCondition(null);
            vCHTemplate.getFilterSet().setExpression(expression);
            ConditionGetHandle billFilterHandle = new ConditionGetHandle((ISingleTaskContext)taskContext, expression, oriExp, Boolean.TRUE);
            vtpFilter.put(Long.valueOf(vCHTemplate.getId()), billFilterHandle);
            billFilterHandle.Compile();
            BuildHelper.AddVarsToFldList(sourceFields, (List)billFilterHandle.getVars());
        }
        if (sourceFields.size() == 0 || dataEntityType == null) {
            return vchTemplateList;
        }
        EntityType entity1 = null;
        for (Map.Entry entry : sourceFields.entrySet()) {
            IVariableMode var = (IVariableMode)entry.getValue();
            EntityType entity2 = null;
            if (var instanceof SourceBillFieldMode) {
                entity2 = (EntityType)((SourceBillFieldMode)var).getSourceField().getParent();
            }
            entity1 = BuildHelper.ComparerEntity(entity1, entity2);
        }
        SelectedSourceEntity selectedSourceEntity = new SelectedSourceEntity();
        selectedSourceEntity.setEntityType(entity1);
        sourceFields.entrySet().stream().filter(e -> e.getValue() instanceof SourceBillFieldMode).forEach(e -> selectedSourceEntity.getSelectedFields().put(e.getKey(), (SourceBillFieldMode)e.getValue()));
        SelectTemplateUtil.buildSelectString(selectedSourceEntity, dataEntityType);
        Object var12_17 = null;
        ISimpleProperty pkProperty = dataEntityType.getPrimaryKey();
        String pkPropName = pkProperty.getName();
        List<List<Long>> splitbatch = SelectTemplateUtil.idCollectionSplitBatch(ids);
        for (List<Long> newIds : splitbatch) {
            QFilter billIdsFilter = new QFilter(pkPropName, "in", newIds);
            if (!"ai_event".equals(entityname) || StringUtils.isNotEmpty((String)extDataModelEntityName)) {
                String realEntityName = StringUtils.isNotEmpty((String)extDataModelEntityName) ? extDataModelEntityName : entityname;
                DataSet dsn = QueryServiceHelper.queryDataSet((String)SelectTemplateUtil.class.getName(), (String)realEntityName, (String)selectedSourceEntity.getSelectString(), (QFilter[])new QFilter[]{billIdsFilter}, null);
                Throwable throwable = null;
                try {
                    ArrayList<Row> pageRows = new ArrayList<Row>(2000);
                    int index = 0;
                    RowMeta rowMeta = dsn.getRowMeta();
                    int cols = rowMeta.getFieldCount();
                    TXHandle h = TX.notSupported();
                    Throwable throwable2 = null;
                    try {
                        while (dsn.hasNext()) {
                            Row row = dsn.next();
                            Object[] values = new Object[cols];
                            for (int i = 0; i < cols; ++i) {
                                values[i] = row.get(i);
                            }
                            PersistedArrayRow prow = new PersistedArrayRow(rowMeta, values, false);
                            pageRows.add((Row)prow);
                            if (++index % 2000 != 0) continue;
                            DynamicObjectCollection dynamicObjectCollection = SelectTemplateUtil.filterRows((ISingleTaskContext)taskContext, vtpFilter, selectedSourceEntity, dsn, pageRows);
                            pageRows.clear();
                            dynamicObjectCollection.clear();
                        }
                        if (pageRows.isEmpty()) continue;
                        DynamicObjectCollection dynamicObjectCollection = SelectTemplateUtil.filterRows((ISingleTaskContext)taskContext, vtpFilter, selectedSourceEntity, dsn, pageRows);
                        continue;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (h == null) continue;
                        if (throwable2 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        h.close();
                        continue;
                    }
                }
                catch (Throwable pageRows) {
                    throwable = pageRows;
                    throw pageRows;
                }
                finally {
                    if (dsn == null) continue;
                    if (throwable != null) {
                        try {
                            dsn.close();
                        }
                        catch (Throwable pageRows) {
                            throwable.addSuppressed(pageRows);
                        }
                        continue;
                    }
                    dsn.close();
                    continue;
                }
            }
            List batchEvtEntry = DataSourceFactory.getDataSource().batchEvtEntry((Object)eventClassId, new HashSet<Object>(ids));
            for (Object eventInfo : batchEvtEntry) {
                DynamicObjectCollection rowss;
                if (eventInfo instanceof Map) {
                    Map event = (Map)eventInfo;
                    String pk = "";
                    Object entryPk = null;
                    if (event.containsKey("pk")) {
                        pk = event.get("pk");
                    }
                    if (event.containsKey("entryPk")) {
                        entryPk = event.get("entryPk");
                    }
                    eventInfo = new PkEntryPkPair((Object)pk, entryPk);
                } else if (eventInfo instanceof Collection) {
                    Collection eic = (Collection)eventInfo;
                    eventInfo = new HashSet(eic);
                }
                if ((rowss = DataSourceFactory.getDataSource().getEventObjectCollection((Object)eventClassId, eventInfo, selectedSourceEntity.getSelectString())).isEmpty()) continue;
                DynamicObjectCollection dynamicObjectCollection = SelectTemplateUtil.filterRows((ISingleTaskContext)taskContext, vtpFilter, selectedSourceEntity, rowss);
            }
        }
        if (!vtpFilter.isEmpty()) {
            List<VCHTemplate> tps = list.stream().filter(e -> !vtpFilter.containsKey(Long.valueOf(e.getId()))).collect(Collectors.toList());
            if (tps.isEmpty()) {
                return Collections.emptyList();
            }
            return tps;
        }
        return vchTemplateList;
    }

    public static List<List<Long>> idCollectionSplitBatch(Collection<? extends Object> ids) {
        List sids = new ArrayList(8);
        if (ids instanceof List) {
            sids = (List)ids;
        } else if (ids instanceof Set) {
            sids = new ArrayList((Set)ids);
        }
        List collect = sids.stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toList());
        Integer value = ConfigurationUtil.getInteger((String)"orm.opt.in.threshold", (Integer)2000);
        List splitbatch = DapBuildVoucherCommonUtil.splitbatch(collect, (int)(value - 1));
        return splitbatch;
    }

    private static DynamicObjectCollection filterRows(ISingleTaskContext taskContext, Map<Long, ConditionGetHandle> vtpFilter, SelectedSourceEntity selectedSourceEntity, DataSet dsn, List<Row> pageRows) {
        ThreadCache.remove((Object)"batchFunctionAvailable");
        DynamicObjectCollection rows = ORMUtil.toDynamicObjectCollection(pageRows.iterator(), (RowMeta)dsn.getRowMeta(), (String)"PlainObject");
        return SelectTemplateUtil.filterRows(taskContext, vtpFilter, selectedSourceEntity, rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DynamicObjectCollection filterRows(ISingleTaskContext taskContext, Map<Long, ConditionGetHandle> vtpFilter, SelectedSourceEntity selectedSourceEntity, DynamicObjectCollection rows) {
        ThreadCache.remove((Object)"batchFunctionAvailable");
        taskContext.getBatchFunValues().clear();
        taskContext.getBosBatchFunValues().clear();
        DynamicObjectType dType = rows.getDynamicObjectType();
        SelectTemplateUtil.buildSourceRowPropsDictory(selectedSourceEntity, dType);
        HashMap distinctHandle = new HashMap(2);
        vtpFilter.values().forEach(e -> distinctHandle.put(e.getOriExp(), e));
        for (DynamicObject r : rows) {
            distinctHandle.entrySet().forEach(e -> ((ConditionGetHandle)e.getValue()).matchFunction(selectedSourceEntity.getFldProperties(), r));
        }
        SelectTemplateUtil.batchCallFunction(taskContext);
        try {
            ThreadCache.put((Object)"batchFunctionAvailable", (Object)"batchFunctionAvailable");
            HashMap reverseVtpFilter = new HashMap(2);
            vtpFilter.entrySet().stream().forEach(e -> reverseVtpFilter.computeIfAbsent(e.getValue(), o -> new HashSet(2)).add(e.getKey()));
            for (DynamicObject r : rows) {
                HashSet validTps = new HashSet(2);
                reverseVtpFilter.entrySet().forEach(e -> {
                    if (((ConditionGetHandle)e.getKey()).GetVchFldValue(selectedSourceEntity.getFldProperties(), r, null).booleanValue()) {
                        validTps.addAll((Collection)e.getValue());
                    }
                });
                validTps.forEach(e -> {
                    ConditionGetHandle cfr_ignored_0 = (ConditionGetHandle)vtpFilter.remove(e);
                });
                if (vtpFilter.size() != 0) continue;
                break;
            }
        }
        finally {
            ThreadCache.remove((Object)"batchFunctionAvailable");
        }
        return rows;
    }

    private static void batchCallFunction(ISingleTaskContext taskContext) {
        Map batchFunValues = taskContext.getBatchFunValues();
        HashMap<String, Set> batchFunMap = new HashMap<String, Set>();
        for (Function function : batchFunValues.keySet()) {
            Set fcSet = batchFunMap.computeIfAbsent(function.getName(), key -> new HashSet());
            fcSet.add(function);
        }
        for (Map.Entry entry : batchFunMap.entrySet()) {
            IBatchFunctionHandler handler = Function.getBatchFunctionHandler((String)((String)entry.getKey()));
            Map vals = handler.execute((Set)entry.getValue());
            if (vals == null) continue;
            batchFunValues.putAll(vals);
        }
        Map bosBatchFunValues = taskContext.getBosBatchFunValues();
        BatchFuncParser batchFuncParser = new BatchFuncParser();
        Map batchRunResult = batchFuncParser.batchCall(bosBatchFunValues.keySet(), (ExpressionContext)new CRExpressionContext(null, null, null), taskContext.getFuncLib());
        bosBatchFunValues.putAll(batchRunResult);
    }

    private static void buildSourceRowPropsDictory(SelectedSourceEntity sourceEntity, DynamicObjectType dType) {
        for (Map.Entry fldAliasItem : sourceEntity.getFldAlias().entrySet()) {
            String var = (String)fldAliasItem.getKey();
            String alias = (String)fldAliasItem.getValue();
            DynamicProperty property = dType.getProperty(alias);
            sourceEntity.getFldProperties().put(var, property);
        }
        String entryPKPropName = sourceEntity.getEntryPKPropName();
        String entryPKPropAlias = (String)sourceEntity.getFldAlias().get(entryPKPropName);
        DynamicProperty entryPKProp = dType.getProperty(entryPKPropAlias);
        sourceEntity.setEntryPKProperty(entryPKProp);
    }

    private static void buildSelectString(SelectedSourceEntity selectedSourceEntity, MainEntityType mainEntityType) {
        ArrayList<String> selectFldStrings = new ArrayList<String>(selectedSourceEntity.getSelectedFields().size());
        int fldIndex = 0;
        String pkPropName = mainEntityType.getPrimaryKey().getName();
        if (!selectedSourceEntity.getFldAlias().containsKey(pkPropName)) {
            selectedSourceEntity.getFldAlias().put(pkPropName, pkPropName);
            selectFldStrings.add(pkPropName);
            ++fldIndex;
        }
        String entryPKPropName = selectedSourceEntity.getEntryPKPropName();
        if (!selectedSourceEntity.getFldAlias().containsKey(entryPKPropName)) {
            String alias = "f" + Integer.toString(fldIndex);
            selectedSourceEntity.getFldAlias().put(entryPKPropName, alias);
            if (selectedSourceEntity.getEntityType() instanceof SubEntryType) {
                selectFldStrings.add(selectedSourceEntity.getEntityType().getParent().getName() + "." + entryPKPropName + " " + (String)alias);
            } else {
                selectFldStrings.add(entryPKPropName + " " + (String)alias);
            }
            ++fldIndex;
        }
        for (Map.Entry fldItem : selectedSourceEntity.getSelectedFields().entrySet()) {
            SourceBillFieldMode fldMode = (SourceBillFieldMode)fldItem.getValue();
            String var = fldMode.getVar();
            if (selectedSourceEntity.getFldAlias().containsKey(var)) continue;
            String fldAlias = "f" + Integer.toString(fldIndex);
            String selectFldString = fldMode.getFullPropName() + " " + fldAlias;
            selectFldStrings.add(selectFldString);
            selectedSourceEntity.getFldAlias().put(var, fldAlias);
            ++fldIndex;
        }
        String selectString = kd.bos.dataentity.utils.StringUtils.join((Object[])selectFldStrings.toArray(new Object[selectFldStrings.size()]), (String)",");
        selectedSourceEntity.setSelectString(selectString);
    }

    public static QFilter getVchTemplateBillFilter(DapConfig cg, Collection<? extends Object> ids) {
        ArrayList bizOrgFields = new ArrayList(cg.getBizOrgFields());
        logger.info("######getVchTemplateBillFilter----cg.getBizOrgFields:" + bizOrgFields + ";size:" + bizOrgFields.size());
        StringBuilder selector = new StringBuilder();
        selector.append("id");
        boolean eventEntryOrg = false;
        HashSet<String> dupilyProCol = new HashSet<String>(8);
        for (String orgPropName : bizOrgFields) {
            MainEntityType eventMeta;
            selector.append(",");
            selector.append(orgPropName);
            String[] pops = orgPropName.split("\\.");
            if (pops.length > 1) {
                for (int i = 0; i < pops.length - 1; ++i) {
                    StringBuilder currprop = new StringBuilder();
                    if (i > 0) {
                        for (int j = 0; j < i; ++j) {
                            currprop.append(pops[j]);
                            currprop.append('.');
                        }
                    }
                    currprop.append(pops[i]);
                    currprop.append(".id");
                    String curop = currprop.toString();
                    if (!dupilyProCol.add(curop)) continue;
                    selector.append(",");
                    selector.append(curop);
                }
                if (cg.getEventClassID() == 0L) continue;
                eventEntryOrg = true;
                continue;
            }
            if (cg.getEventClassID() == 0L || (eventMeta = EntityMetadataCache.getDataEntityType((String)cg.getBillentity())).getProperty(orgPropName) != null) continue;
            eventEntryOrg = true;
        }
        String entityName = cg.getBillentity();
        if ("ai_eventclass".equals(entityName)) {
            entityName = "ai_event";
        }
        HashSet<Long> bizOrg = new HashSet<Long>(2);
        List<List<Long>> splitbatch = SelectTemplateUtil.idCollectionSplitBatch(ids);
        for (List<Long> newIds : splitbatch) {
            Object eventInfo2;
            if (eventEntryOrg) {
                List batchEvtEntry = DataSourceFactory.getDataSource().batchEvtEntry((Object)cg.getEventClassID(), new HashSet<Object>(ids));
                for (Object eventInfo2 : batchEvtEntry) {
                    DynamicObjectCollection rows;
                    if (eventInfo2 instanceof Map) {
                        Map event = (Map)eventInfo2;
                        String pk = "";
                        Iterator<Object> entryPk = null;
                        if (event.containsKey("pk")) {
                            pk = event.get("pk");
                        }
                        if (event.containsKey("entryPk")) {
                            entryPk = event.get("entryPk");
                        }
                        eventInfo2 = new PkEntryPkPair((Object)pk, entryPk);
                    } else if (eventInfo2 instanceof Collection) {
                        Collection eic = (Collection)eventInfo2;
                        eventInfo2 = new HashSet(eic);
                    }
                    if ((rows = DataSourceFactory.getDataSource().getEventObjectCollection((Object)cg.getEventClassID(), eventInfo2, selector.toString())).isEmpty()) continue;
                    rows.stream().forEach(info -> cg.getBizOrgFields().forEach(field -> bizOrg.add(info.getLong(field))));
                }
                continue;
            }
            List bizOrgList = cg.getBizOrgFields();
            DataSet ds = QueryServiceHelper.queryDataSet((String)SelectTemplateUtil.class.getName(), (String)entityName, (String)selector.toString(), (QFilter[])new QFilter("id", "in", newIds).toArray(), null);
            eventInfo2 = null;
            try {
                for (Row row : ds) {
                    for (String orgField : bizOrgList) {
                        bizOrg.add(row.getLong(orgField));
                    }
                }
            }
            catch (Throwable iterator) {
                eventInfo2 = iterator;
                throw iterator;
            }
            finally {
                if (ds == null) continue;
                if (eventInfo2 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable iterator) {
                        ((Throwable)eventInfo2).addSuppressed(iterator);
                    }
                    continue;
                }
                ds.close();
            }
        }
        String selectFields = "id,bizorgentry.bizorg bizorg,bizorgentry.bizacctorg bizacctorg";
        QFilter orgqf = new QFilter("bizorgentry.bizorg", "in", bizOrg);
        DynamicObjectCollection bizColl = QueryServiceHelper.query((String)"bd_accountingsys", (String)selectFields, (QFilter[])new QFilter[]{orgqf});
        Set accOrg = bizColl.stream().map(e -> e.getLong("bizacctorg")).collect(Collectors.toSet());
        accOrg.addAll(bizOrg);
        QFilter isBizQf = new QFilter("isbizunit", "=", (Object)"1");
        QFilter orgQf = new QFilter("org", "in", accOrg);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"gl_accountbook", (String)"org", (QFilter[])new QFilter[]{isBizQf, orgQf});
        HashSet bookOrg = new HashSet();
        query.stream().forEach(q -> bookOrg.add(q.getLong("org")));
        QFilter idQF = null;
        HashSet templateid = new HashSet(16);
        for (Long org : bookOrg) {
            Object value = BaseDataServiceHelper.getBaseDataIdInFilter((String)"ai_vchtemplate", (Long)org).getValue();
            if (value == null) continue;
            Collection cc = (Collection)value;
            templateid.addAll(cc);
        }
        if (!templateid.isEmpty()) {
            idQF = new QFilter("id", "in", templateid);
        }
        return idQF;
    }

    private static List<VCHTemplate> getTemplates(String entityname, Collection<? extends Object> ids, List<QFilter> filters) {
        if ("ai_event".equals(entityname)) {
            entityname = "ai_eventclass";
        }
        if (filters != null && !filters.isEmpty()) {
            return DapCache.getTemplateByFilters(filters);
        }
        filters = new LinkedList<QFilter>();
        QFilter enableFilter = new QFilter("enable", "!=", (Object)"0");
        long eventClassID = 0L;
        if ("ai_eventclass".equals(entityname)) {
            ExtDataModelHelper.ModelIdAndBillType modelIdAndBillType = ExtDataModelHelper.queryModelIdAndBillType((Object)ids.iterator().next());
            if ("ai_event".equals(modelIdAndBillType.getBillType())) {
                eventClassID = modelIdAndBillType.getModelId();
                enableFilter.and(new QFilter("eventclass.id", "=", (Object)eventClassID));
            } else {
                entityname = modelIdAndBillType.getBillType();
            }
        }
        QFilter billTypeFilter = new QFilter("fsourcebill", "=", (Object)entityname);
        DynamicObject dapConfigDynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"ai_dapconfig", (String)"parentbill.id", (QFilter[])new QFilter("billentity.id", "=", (Object)entityname).toArray());
        if (dapConfigDynamicObject != null && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)dapConfigDynamicObject.getString("parentbill.id"))) {
            billTypeFilter.or(new QFilter("fsourcebill", "=", (Object)dapConfigDynamicObject.getString("parentbill.id")));
        }
        DapConfig dapConfig = DapCache.getDapConfigCache((String)entityname, (long)eventClassID);
        dapConfig.setEventClassID(eventClassID);
        QFilter vchIdQF = SelectTemplateUtil.getVchTemplateBillFilter(dapConfig, ids);
        if (vchIdQF != null) {
            enableFilter.and(vchIdQF);
        }
        filters.add(enableFilter);
        filters.add(billTypeFilter);
        return DapCache.getTemplateByFilters(filters);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<VchTemplateMainData> matchTemplate(List<VchTemplateMainData> vchTempDataCol, String entityname, Set<Long> ids) {
        void var9_12;
        if (vchTempDataCol.isEmpty()) {
            return vchTempDataCol;
        }
        SingleTaskContext taskContext = new SingleTaskContext();
        taskContext.setBuildVchContext((IBuildVchContext)new BuildVchContext());
        taskContext.getBuildVchContext().setReporter((IBuildVchReporter)new BuildVchReporter());
        taskContext.setSourceBill(new SourceBillInfo());
        MainEntityType dataEntityType = null;
        HashMap sourceFields = new HashMap(8);
        HashMap<Long, ConditionGetHandle> vtpFilter = new HashMap<Long, ConditionGetHandle>(8);
        Long eventClassId = 0L;
        for (VchTemplateMainData vchTemplateMainData : vchTempDataCol) {
            String string;
            if (dataEntityType == null) {
                if (vchTemplateMainData.getEventClassId() != 0L) {
                    eventClassId = vchTemplateMainData.getEventClassId();
                    dataEntityType = AiEventMetaUtil.getEntityType((Object)vchTemplateMainData.getEventClassId());
                } else {
                    dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityname);
                }
            }
            taskContext.setSrcEntityType(dataEntityType);
            if (vchTemplateMainData.getFilterExpress() == null) continue;
            Object var10_15 = null;
            try {
                string = vchTemplateMainData.getFilterExpress().buildFullFormula(dataEntityType);
            }
            catch (Exception exception) {
                logger.error((Throwable)exception);
                VCHTemplate vchTemplate = vchTemplateMainData.getVchTemplate();
                boolean isNullTemplate = vchTemplate == null;
                throw new DapException(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u201c%1$s\uff08%2$s\uff09\u201d\u9002\u7528\u6761\u4ef6\u89e3\u6790\u53d1\u751f\u9519\u8bef\uff1a\u201c%3$s\u201d\u3002", (String)"SelectTemplateUtil_0", (String)"fi-ai-mservice", (Object[])new Object[0]), isNullTemplate ? "-" : vchTemplate.getName(), isNullTemplate ? "-" : vchTemplate.getBillNo(), exception.getMessage()), (Throwable)exception);
            }
            vchTemplateMainData.getFilterExpress().setFilterCondition(null);
            vchTemplateMainData.getFilterExpress().setExpression(string);
            ConditionGetHandle conditionGetHandle = new ConditionGetHandle((ISingleTaskContext)taskContext, string, Boolean.TRUE);
            vtpFilter.put(vchTemplateMainData.getTemId(), conditionGetHandle);
            conditionGetHandle.Compile();
            BuildHelper.AddVarsToFldList(sourceFields, (List)conditionGetHandle.getVars());
        }
        if (sourceFields.size() == 0 || dataEntityType == null) {
            return vchTempDataCol;
        }
        Set vtids = vtpFilter.keySet();
        for (VchTemplateMainData vchTemplateMainData : vchTempDataCol) {
            if (!vtids.contains(vchTemplateMainData.getTemId())) continue;
            vchTemplateMainData.setMatchSourcebillid(new HashSet(8));
        }
        Object var9_11 = null;
        for (Map.Entry entry : sourceFields.entrySet()) {
            IVariableMode var = (IVariableMode)entry.getValue();
            EntityType entity2 = null;
            if (var instanceof SourceBillFieldMode) {
                entity2 = (EntityType)((SourceBillFieldMode)var).getSourceField().getParent();
            }
            EntityType entityType = BuildHelper.ComparerEntity((EntityType)var9_12, entity2);
        }
        SelectedSourceEntity selectedSourceEntity = new SelectedSourceEntity();
        selectedSourceEntity.setEntityType((EntityType)var9_12);
        sourceFields.entrySet().stream().filter(e -> e.getValue() instanceof SourceBillFieldMode).forEach(e -> selectedSourceEntity.getSelectedFields().put(e.getKey(), (SourceBillFieldMode)e.getValue()));
        SelectTemplateUtil.buildSelectString(selectedSourceEntity, dataEntityType);
        ISimpleProperty iSimpleProperty = dataEntityType.getPrimaryKey();
        String pkPropName = iSimpleProperty.getName();
        QFilter billIdsFilter = new QFilter(pkPropName, "in", ids);
        if (!"ai_event".equals(entityname)) {
            try (DataSet dsn = QueryServiceHelper.queryDataSet((String)SelectTemplateUtil.class.getName(), (String)entityname, (String)selectedSourceEntity.getSelectString(), (QFilter[])new QFilter[]{billIdsFilter}, null);){
                ArrayList<Row> arrayList = new ArrayList<Row>(2000);
                int index = 0;
                RowMeta rowMeta = dsn.getRowMeta();
                int cols = rowMeta.getFieldCount();
                try (TXHandle h = TX.notSupported();){
                    while (dsn.hasNext()) {
                        Row row = dsn.next();
                        Object[] values = new Object[cols];
                        for (int i = 0; i < cols; ++i) {
                            values[i] = row.get(i);
                        }
                        PersistedArrayRow prow = new PersistedArrayRow(rowMeta, values, false);
                        arrayList.add((Row)prow);
                        if (++index % 2000 != 0) continue;
                        SelectTemplateUtil.filterRows((ISingleTaskContext)taskContext, vtpFilter, selectedSourceEntity, dsn, arrayList, vchTempDataCol);
                        arrayList.clear();
                    }
                    if (arrayList.isEmpty()) return vchTempDataCol;
                    SelectTemplateUtil.filterRows((ISingleTaskContext)taskContext, vtpFilter, selectedSourceEntity, dsn, arrayList, vchTempDataCol);
                    return vchTempDataCol;
                }
            }
        } else {
            List batchEvtEntry = DataSourceFactory.getDataSource().batchEvtEntry((Object)eventClassId, new HashSet<Long>(ids));
            for (Object e2 : batchEvtEntry) {
                void var16_36;
                DynamicObjectCollection rows;
                if (e2 instanceof Map) {
                    void var18_43;
                    Map event = (Map)e2;
                    String string = "";
                    Object entryPk = null;
                    if (event.containsKey("pk")) {
                        Object v = event.get("pk");
                    }
                    if (event.containsKey("entryPk")) {
                        entryPk = event.get("entryPk");
                    }
                    PkEntryPkPair pkEntryPkPair = new PkEntryPkPair((Object)var18_43, entryPk);
                } else if (e2 instanceof Collection) {
                    Collection eic = (Collection)e2;
                    HashSet hashSet = new HashSet(eic);
                }
                if ((rows = DataSourceFactory.getDataSource().getEventObjectCollection((Object)eventClassId, (Object)var16_36, selectedSourceEntity.getSelectString())).isEmpty()) continue;
                SelectTemplateUtil.filterRows((ISingleTaskContext)taskContext, vtpFilter, selectedSourceEntity, rows, vchTempDataCol);
            }
        }
        return vchTempDataCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filterRows(ISingleTaskContext taskContext, Map<Long, ConditionGetHandle> vtpFilter, SelectedSourceEntity selectedSourceEntity, DynamicObjectCollection rows, List<VchTemplateMainData> vchTempDataCol) {
        ThreadCache.remove((Object)"batchFunctionAvailable");
        taskContext.getBatchFunValues().clear();
        taskContext.getBosBatchFunValues().clear();
        DynamicObjectType dType = rows.getDynamicObjectType();
        SelectTemplateUtil.buildSourceRowPropsDictory(selectedSourceEntity, dType);
        HashMap distinctHandle = new HashMap(2);
        vtpFilter.values().forEach(e -> distinctHandle.put(e.getOriExp(), e));
        for (DynamicObject r : rows) {
            distinctHandle.entrySet().forEach(e -> ((ConditionGetHandle)e.getValue()).matchFunction(selectedSourceEntity.getFldProperties(), r));
        }
        HashMap<Long, Set> templateAndBillCache = new HashMap<Long, Set>(8);
        HashMap<Long, Set> templateAndBillErrorCache = new HashMap<Long, Set>(8);
        SelectTemplateUtil.batchCallFunction(taskContext);
        try {
            ThreadCache.put((Object)"batchFunctionAvailable", (Object)"batchFunctionAvailable");
            HashMap reverseVtpFilter = new HashMap(2);
            vtpFilter.entrySet().stream().forEach(e -> reverseVtpFilter.computeIfAbsent(e.getValue(), o -> new HashSet(2)).add(e.getKey()));
            for (DynamicObject r : rows) {
                long id = Long.parseLong(r.getString("id"));
                for (Map.Entry e2 : reverseVtpFilter.entrySet()) {
                    if (((ConditionGetHandle)e2.getKey()).GetVchFldValue(selectedSourceEntity.getFldProperties(), r, null).booleanValue()) {
                        for (Long templateId : (Set)e2.getValue()) {
                            templateAndBillCache.computeIfAbsent(templateId, v -> new HashSet()).add(id);
                        }
                        continue;
                    }
                    for (Long templateId : (Set)e2.getValue()) {
                        templateAndBillErrorCache.computeIfAbsent(templateId, v -> new HashSet()).add(id);
                    }
                }
            }
            for (Map.Entry tb : templateAndBillCache.entrySet()) {
                for (VchTemplateMainData vtm : vchTempDataCol) {
                    if (!((Long)tb.getKey()).equals(vtm.getTemId())) continue;
                    vtm.getMatchSourcebillid().addAll((Collection)tb.getValue());
                    Set error = (Set)templateAndBillErrorCache.get(tb.getKey());
                    if (error == null || error.isEmpty()) continue;
                    vtm.getMatchSourcebillid().removeAll(error);
                }
            }
        }
        finally {
            ThreadCache.remove((Object)"batchFunctionAvailable");
        }
    }

    private static void filterRows(ISingleTaskContext taskContext, Map<Long, ConditionGetHandle> vtpFilter, SelectedSourceEntity selectedSourceEntity, DataSet dsn, List<Row> pageRows, List<VchTemplateMainData> vchTempDataCol) {
        DynamicObjectCollection rows = ORMUtil.toDynamicObjectCollection(pageRows.iterator(), (RowMeta)dsn.getRowMeta(), (String)"PlainObject");
        SelectTemplateUtil.filterRows(taskContext, vtpFilter, selectedSourceEntity, rows, vchTempDataCol);
    }
}

