/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.enums.CheckBoxEnum;
import kd.fi.ai.formplugin.dao.BillTypeReader;
import kd.fi.ai.util.DapUtil;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.dao.sys.SysBasePropDataDaoImpl;

public class ReconciliationResultRptHelper {
    public static DynamicObjectCollection getBillType(String algoKey) {
        return BillTypeReader.loadBillTypeCollection((String)algoKey, null);
    }

    public static boolean checkIsCanBuildvch(String billNum) {
        QFilter numberQfilter = new QFilter("number", "=", (Object)billNum);
        QFilter modeltypeQfilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
        QFilter voucherQfilter = new QFilter("voucher", "=", (Object)CheckBoxEnum.TRUE.getValue());
        return QueryServiceHelper.exists((String)"bos_entityobject", (QFilter[])new QFilter[]{numberQfilter, modeltypeQfilter, voucherQfilter});
    }

    public static List<String> getBuildVchBillsByBizapp(String bizapp) {
        ArrayList<String> billCodeList = new ArrayList<String>();
        try (DataSet childDataSet = ReconciliationResultRptHelper.getBuildVchBillsDataSetByBizapp(bizapp);){
            List bills = DapUtil.getDapBillEntitys();
            for (Row rowChild : childDataSet) {
                String billCode = rowChild.getString("id");
                if (!bills.contains(billCode)) continue;
                billCodeList.add(billCode);
            }
        }
        return billCodeList;
    }

    public static Map<String, String> getBillsIdAndNameByBizapp(String bizapp) {
        List bills = DapUtil.getDapBillEntitys();
        HashMap<String, String> billObjMap = new HashMap<String, String>();
        try (DataSet childDataSet = ReconciliationResultRptHelper.getBuildVchBillsDataSetByBizapp(bizapp);){
            for (Row rowChild : childDataSet) {
                String billCode = rowChild.getString("id");
                if (!bills.contains(billCode)) continue;
                billObjMap.put(billCode, rowChild.getString("name"));
            }
        }
        return billObjMap;
    }

    public static DataSet getBuildVchBillsDataSetByBizapp(String bizapp) {
        QFilter bizappidQfilter = new QFilter("bizappid", "=", (Object)bizapp);
        QFilter modeltypeQfilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
        QFilter voucherQfilter = new QFilter("voucher", "=", (Object)CheckBoxEnum.TRUE.getValue());
        DataSet childDataSet = QueryServiceHelper.queryDataSet((String)"getBillNumsByBillType", (String)"bos_entityobject", (String)"id,name", (QFilter[])new QFilter[]{bizappidQfilter, modeltypeQfilter, voucherQfilter}, null);
        return childDataSet;
    }

    public static boolean checkIsExistsvchTemplate(String billNo) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("fsourcebill", "=", (Object)billNo));
        return QueryServiceHelper.exists((String)"ai_vchtemplate", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public static DynamicObjectCollection getVchTemplate(String nodeId, Long org) {
        QFilter[] filterList = new QFilter[]{new QFilter("fsourcebill", "=", (Object)nodeId), new QFilter("enable", "!=", (Object)"0")};
        String selectFields = "id";
        return SysBasePropDataDaoImpl.queryBaseData((String)"ai_vchtemplate", (Long)org, (String)selectFields, (QFilter[])filterList);
    }

    public static DynamicObject getPeriodByPkValue(long periodId) {
        String selectFields = "id,begindate,enddate";
        QFilter f = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)selectFields, (QFilter[])new QFilter[]{f});
        return period;
    }

    public static boolean checkIsBuildGlVch(Set<Long> billIds, Long acctorgId) {
        return billIds.size() == ReconciliationResultRptHelper.getVchedBillCount(billIds, acctorgId);
    }

    public static int getVchedBillCount(Set<Long> billIds, Long acctorgId) {
        HashSet<Long> vchMap = new HashSet<Long>(billIds.size());
        List setList = kd.fi.ai.util.DapBuildVoucherCommonUtil.splitSet(billIds, (int)100000);
        for (Set set : setList) {
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fvoucherid voucherid from t_ai_daptracker where", new Object[0]);
            sql.appendIn(" FSOURCEBILLID ", set.toArray());
            DataSet dataSet = DB.queryDataSet((String)ReconciliationResultRptHelper.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
            Throwable throwable = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    vchMap.add(row.getLong("voucherid"));
                }
            }
            catch (Throwable row) {
                throwable = row;
                throw row;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row) {
                        throwable.addSuppressed(row);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        if (vchMap.size() > 0) {
            QFilter glidFilter = new QFilter("id", "in", vchMap);
            QFilter glOrgFilter = new QFilter("org", "=", (Object)acctorgId);
            List glids = QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter[]{glidFilter, glOrgFilter}, null, (int)vchMap.size());
            if (glids != null) {
                DynamicObjectCollection sourceIds = QueryServiceHelper.query((String)"ai_daptracker", (String)"id,sourcebillid", (QFilter[])new QFilter("voucherid", "in", (Object)glids).toArray());
                HashSet<Long> sourceid = new HashSet<Long>();
                for (DynamicObject source : sourceIds) {
                    sourceid.add(source.getLong("sourcebillid"));
                }
                Set buildVoucherBillIds = billIds.stream().filter(e -> sourceid.contains(e)).collect(Collectors.toSet());
                return buildVoucherBillIds.size();
            }
            return 0;
        }
        return 0;
    }

    public static DataSet getNoGenVouchers(String key, String sql, Object[] params) {
        return DB.queryDataSet((String)"kd.fi.ai.formplugin.ReconciliationResultRptHelper", (DBRoute)DBRoute.of((String)key), (String)sql, (Object[])params);
    }

    public static int getNoGenCount(Set<Long> billIds, List<String> billNum, Long acctorgId) {
        int Allnum = 0;
        if (billNum != null && billNum.size() > 0) {
            for (int i = 0; i < billNum.size(); ++i) {
                String type = billNum.get(i);
                if (!DapBuildVoucherCommonUtil.getDistributeHasDapWBill((String)type).booleanValue() || billIds.size() <= 0) continue;
                int size = billIds.size();
                if (size > 5000) {
                    HashSet<Long> ids = new HashSet<Long>(5000);
                    int a = 0;
                    for (Long billid : billIds) {
                        ids.add(billid);
                        if (++a % 5000 != 0 && a != size) continue;
                        String joinIds = QFilterBuilder.buildSQLParamHolder((int)ids.size());
                        String sql = "SELECT COUNT(1) NUM FROM " + DapBuildVoucherCommonUtil.getBlackTableName((String)type) + " WHERE FORGID = " + acctorgId + " AND FSOURCEBILLID IN " + joinIds;
                        DataSet noGenVouchers = ReconciliationResultRptHelper.getNoGenVouchers(DapBuildVoucherCommonUtil.getDBRouteKey((String)type), sql, ids.toArray());
                        for (Row row : noGenVouchers) {
                            Long num = row.getLong("NUM");
                            Allnum = (int)((long)Allnum + num);
                        }
                        ids.clear();
                    }
                    continue;
                }
                String joinIds = QFilterBuilder.buildSQLParamHolder((int)billIds.size());
                String sql = "SELECT COUNT(1) NUM FROM " + DapBuildVoucherCommonUtil.getBlackTableName((String)type) + " WHERE FORGID = " + acctorgId + " AND FSOURCEBILLID IN " + joinIds;
                DataSet noGenVouchers = ReconciliationResultRptHelper.getNoGenVouchers(DapBuildVoucherCommonUtil.getDBRouteKey((String)type), sql, billIds.toArray());
                for (Row row : noGenVouchers) {
                    Long num = row.getLong("NUM");
                    Allnum = (int)((long)Allnum + num);
                }
            }
        }
        return Allnum;
    }

    public static List<Long> getNoGenCountBill(String billtype, Long acctorgId) {
        ArrayList<Long> list = new ArrayList<Long>(16);
        if (DapBuildVoucherCommonUtil.getDistributeHasDapWBill((String)billtype).booleanValue()) {
            String sql = "SELECT FSOURCEBILLID ID FROM " + DapBuildVoucherCommonUtil.getBlackTableName((String)billtype) + " WHERE FORGID = " + acctorgId + ";";
            try (DataSet noGenVouchers = DB.queryDataSet((String)"kd.fi.ai.formplugin.ReconciliationResultRptHelper", (DBRoute)DBRoute.of((String)DapBuildVoucherCommonUtil.getDBRouteKey((String)billtype)), (String)sql);){
                Iterator iterRow = noGenVouchers.iterator();
                while (iterRow.hasNext()) {
                    list.add(((Row)iterRow.next()).getLong("ID"));
                }
            }
        }
        return list;
    }

    public static DynamicObjectCollection getReconciliations(String algoKey, String selectFields, QFilter[] filters) {
        DynamicObjectCollection reconciliationScheme = QueryServiceHelper.query((String)algoKey, (String)"ai_reconciliation_scheme", (String)selectFields, (QFilter[])filters, null);
        return reconciliationScheme;
    }

    protected List<Map<String, Object>> getBillIds(String billNum, Long acctorgId, Long periodId) {
        List<Long> list = ReconciliationResultRptHelper.getNoGenCountBill(billNum, acctorgId);
        ArrayList<Map<String, Object>> billObjList = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection vchTemplateColl = ReconciliationResultRptHelper.getVchTemplate(billNum, acctorgId);
        if (null == vchTemplateColl || vchTemplateColl.size() == 0) {
            return billObjList;
        }
        String vchDate = "";
        String bizorg = "";
        String billNoField = "";
        LinkedHashMap<String, Boolean> isQueryMap = new LinkedHashMap<String, Boolean>();
        for (DynamicObject vchTemplate : vchTemplateColl) {
            String caCheKey;
            Long vchTemplateId = vchTemplate.getLong("id");
            Map<String, Object> dataFromVchtemplate = this.getDataFromVchtemplate(vchTemplateId);
            vchDate = (String)dataFromVchtemplate.get("vchDate");
            bizorg = (String)dataFromVchtemplate.get("acctOrg");
            billNoField = kd.fi.ai.util.DapBuildVoucherCommonUtil.getBillNoFormBill((String)billNum);
            StringBuilder sf = new StringBuilder();
            sf.append("id,");
            sf.append(billNoField);
            sf.append(",").append(bizorg);
            QFilter acctOrgFilter = new QFilter((String)dataFromVchtemplate.get("acctOrg"), "in", (Object)DapUtil.getBizOrgIds((long)acctorgId));
            ArrayList<QFilter> qFilterArr = new ArrayList<QFilter>();
            qFilterArr.add(acctOrgFilter);
            if (StringUtils.isNotEmpty((CharSequence)vchDate)) {
                sf.append(",").append(vchDate);
                DynamicObject period = ReconciliationResultRptHelper.getPeriodByPkValue(periodId);
                Date begindate = period.getDate("begindate");
                Date enddate = period.getDate("enddate");
                QFilter begindateFilter = new QFilter((String)dataFromVchtemplate.get("vchDate"), ">=", (Object)begindate);
                QFilter enddateFilter = new QFilter((String)dataFromVchtemplate.get("vchDate"), "<=", (Object)enddate);
                qFilterArr.add(begindateFilter);
                qFilterArr.add(enddateFilter);
            }
            if ("fa_card_fin".equals(billNum)) {
                QFilter cardFiter = new QFilter("bizperiod", "=", (Object)"period", true);
                QFilter cardFiter2 = new QFilter("period", "<>", (Object)0);
                qFilterArr.add(cardFiter);
                qFilterArr.add(cardFiter2);
            }
            if (isQueryMap.containsKey(caCheKey = billNum + sf + qFilterArr)) continue;
            isQueryMap.put(caCheKey, true);
            DynamicObjectCollection billObjs = QueryServiceHelper.query((String)billNum, (String)sf.toString(), (QFilter[])qFilterArr.toArray(new QFilter[0]));
            for (DynamicObject billObj : billObjs) {
                HashMap<String, Object> billObjMap = new HashMap<String, Object>();
                if (list.contains(billObj.get("id"))) continue;
                billObjMap.put("id", billObj.get("id"));
                billObjMap.put("billno", billObj.get(billNoField));
                billObjMap.put("sourcebilltype", billNum);
                billObjMap.put("bizorg", billObj.get(bizorg));
                if (StringUtils.isNotEmpty((CharSequence)vchDate) && !"newdate".equals(vchDate) && !"lastdate".equals(vchDate)) {
                    billObjMap.put("vchDate", billObj.get(vchDate.trim()));
                }
                billObjList.add(billObjMap);
            }
        }
        return billObjList;
    }

    private boolean is_a_word(String str) {
        str = str.trim();
        Pattern p = Pattern.compile("^[A-Za-z]+$");
        Matcher m = p.matcher(str);
        return m.matches();
    }

    private Map<String, Object> getDataFromVchtemplate(Long pkValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        MainEntityType vchtemplateType = EntityMetadataCache.getDataEntityType((String)"ai_vchtemplate");
        DynamicObject vchTempObj = BusinessDataReader.loadSingle((Object)pkValue, (DynamicObjectType)vchtemplateType);
        String toJson = vchTempObj.getString("fxml");
        ILocaleValue langJsons = (ILocaleValue)vchTempObj.get("fxmllang");
        if (!StringUtils.isBlank((CharSequence)toJson)) {
            VCHTemplate vchTemplate = VCHTemplate.deserializeFromString((String)toJson, (Map)langJsons);
            String voucherdate = vchTemplate.getVchDateSet2() == null ? null : vchTemplate.getVchDateSet2().getSingleField();
            String acctOrgSet = vchTemplate.getAcctOrgSet();
            map.put("vchDate", voucherdate);
            map.put("acctOrg", acctOrgSet);
        }
        return map;
    }
}

