/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ApInvoice4MapperSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ApInvoice4MapperSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("org");
        lst.add("serialno");
        lst.add("sellertin");
        lst.add("biztype");
        lst.add("sellertin");
        lst.add("asstacttype");
        lst.add("asstactname");
        lst.add("receivablessupp");
        lst.add("entry.e_invname");
        lst.add("entry.e_invspectype");
        lst.add("entry.e_invunit");
        lst.add("entry.spectype");
        lst.add("entry.material");
        lst.add("entry.measureunit");
        lst.add("entry.expenseitem");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject invoice;
        String serialno;
        int n;
        super.beforeExecuteOperationTransaction(e);
        OperationResult invoicies = e.getDataEntities();
        DynamicObjectCollection sellers = new DynamicObjectCollection();
        DynamicObjectCollection invoicemappers = new DynamicObjectCollection();
        OperationResult operationResult = invoicies;
        int n2 = ((DynamicObject[])operationResult).length;
        for (n = 0; n < n2 && !ObjectUtils.isEmpty((Object)(serialno = (invoice = operationResult[n]).getString("serialno"))); ++n) {
            DynamicObject seller = this.buildSeller(invoice);
            if (ObjectUtils.isEmpty((Object)seller)) continue;
            sellers.add((Object)seller);
        }
        if (sellers.size() > 0) {
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_seller", (DynamicObject[])((DynamicObject[])sellers.toArray((Object[])new DynamicObject[sellers.size()])), (OperateOption)OperateOption.create());
        }
        try {
            operationResult = invoicies;
            n2 = ((DynamicObject[])operationResult).length;
            for (n = 0; n < n2 && !ObjectUtils.isEmpty((Object)(serialno = (invoice = operationResult[n]).getString("serialno"))); ++n) {
                DynamicObject invoiceMapper = this.buildInvoicemapper(invoice);
                if (ObjectUtils.isEmpty((Object)invoiceMapper)) continue;
                invoicemappers.add((Object)invoiceMapper);
            }
            if (invoicemappers.size() > 0) {
                operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_invoicemapper", (DynamicObject[])((DynamicObject[])invoicemappers.toArray((Object[])new DynamicObject[invoicemappers.size()])), (OperateOption)OperateOption.create());
            }
        }
        catch (Exception err) {
            logger.info("ApInvoice4MapperSaveOp save mapper error:{}", (Object)err);
        }
    }

    private DynamicObject buildInvoicemapper(DynamicObject invoice) {
        QFilter qFilter = new QFilter("useorg", "=", invoice.getDynamicObject("org").getPkValue());
        qFilter.and(new QFilter("number", "=", invoice.get("sellertin")));
        String selector = "id, createorg, org, ctrlstrategy, status, useorg, entry.seq, entry.e_invname, entry.e_invspectype, entry.e_invunit, entry.e_material, entry.e_spectype, entry.e_measureunit, entry.e_expenseitem";
        DynamicObject oldInvoicemapper = BusinessDataServiceHelper.loadSingle((String)"ap_invoicemapper", (String)selector, (QFilter[])new QFilter[]{qFilter});
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"ap_invoicemapper");
        DynamicObject invoicemapper = new DynamicObject((DynamicObjectType)dt);
        DynamicObjectType invoicemapperType = (DynamicObjectType)invoicemapper.getDataEntityType();
        DynamicObjectType newEntryDt = ((EntryProp)invoicemapperType.getProperty("entry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection invoiceEntries = invoice.getDynamicObjectCollection("entry");
        if (ObjectUtils.isEmpty((Object)oldInvoicemapper)) {
            invoicemapper.set("useorg", invoice.get("org"));
            invoicemapper.set("org", invoice.get("org"));
            invoicemapper.set("createorg", invoice.get("org"));
            invoicemapper.set("number", invoice.get("sellertin"));
            invoicemapper.set("name", invoice.get("asstactname"));
            invoicemapper.set("enable", (Object)"1");
            invoicemapper.set("status", (Object)"C");
            invoicemapper.set("createtime", (Object)new Date());
            HashMap<String, DynamicObject> entryMap = new HashMap<String, DynamicObject>();
            for (DynamicObject invoiceEntry : invoiceEntries) {
                String key;
                if (ObjectUtils.isEmpty((Object)invoiceEntry.get("material.id")) || entryMap.containsKey((key = invoiceEntry.getString("e_invname") + invoiceEntry.getString("e_invspectype") + invoiceEntry.getString("e_invunit")).replaceAll(" ", ""))) continue;
                entryMap.put(key.replaceAll(" ", ""), invoiceEntry);
                DynamicObject invoicemapperEntry = this.addInvoiceMapperEntry(newEntryDt, invoiceEntry);
                invoicemapper.getDynamicObjectCollection("entry").add((Object)invoicemapperEntry);
            }
            return invoicemapper;
        }
        DynamicObjectType oldEntryDt = ((EntryProp)((DynamicObjectType)oldInvoicemapper.getDataEntityType()).getProperty("entry")).getDynamicCollectionItemPropertyType();
        HashMap<String, DynamicObject> entryMap = new HashMap<String, DynamicObject>();
        for (DynamicObject entry : oldInvoicemapper.getDynamicObjectCollection("entry")) {
            entryMap.put((entry.getString("e_invname") + entry.getString("e_invspectype") + entry.getString("e_invunit")).replaceAll(" ", ""), entry);
        }
        boolean change = false;
        block2: for (DynamicObject invoiceEntry : invoiceEntries) {
            if (ObjectUtils.isEmpty((Object)invoiceEntry.get("material.id")) && ObjectUtils.isEmpty((Object)invoiceEntry.get("expenseitem"))) continue;
            String key = invoiceEntry.getString("e_invname") + invoiceEntry.getString("e_invspectype") + invoiceEntry.getString("e_invunit");
            if (!entryMap.containsKey(key.replaceAll(" ", ""))) {
                DynamicObject invoicemapperEntry = this.addInvoiceMapperEntry(oldEntryDt, invoiceEntry);
                oldInvoicemapper.getDynamicObjectCollection("entry").add((Object)invoicemapperEntry);
                change = true;
                continue;
            }
            DynamicObjectCollection oldEntries = oldInvoicemapper.getDynamicObjectCollection("entry");
            for (DynamicObject oldEntry : oldEntries) {
                if (oldEntry.getPkValue().equals(0L)) continue;
                String invname = oldEntry.getString("e_invname");
                String invspectype = oldEntry.getString("e_invspectype");
                String invunit = oldEntry.getString("e_invunit");
                Long expenseitemPK = null;
                Long materialPK = oldEntry.getLong("e_material.id");
                if (ObjectUtils.isEmpty((Object)materialPK)) {
                    expenseitemPK = oldEntry.getLong("e_expenseitem.id");
                }
                String spectype = oldEntry.getString("e_spectype");
                Long measureunit = 0L;
                if (!ObjectUtils.isEmpty((Object)oldEntry.getDynamicObject("e_measureunit"))) {
                    measureunit = (Long)oldEntry.getDynamicObject("e_measureunit").getPkValue();
                }
                if (!invname.equals(invoiceEntry.get("e_invname")) || !invspectype.equals(invoiceEntry.get("e_invspectype")) || !invunit.equals(invoiceEntry.get("e_invunit"))) continue;
                if (!ObjectUtils.isEmpty((Object)materialPK) && materialPK.longValue() != invoiceEntry.getLong("material.id")) {
                    oldEntry.set("e_material", (Object)invoiceEntry.getLong("material.id"));
                    change = true;
                }
                if (!spectype.equals(invoiceEntry.get("spectype"))) {
                    oldEntry.set("e_spectype", invoiceEntry.get("spectype"));
                    change = true;
                }
                if (!ObjectUtils.isEmpty((Object)invoiceEntry.getDynamicObject("measureunit")) && measureunit.longValue() != ((Long)invoiceEntry.getDynamicObject("measureunit").getPkValue()).longValue()) {
                    oldEntry.set("e_measureunit", invoiceEntry.get("measureunit"));
                    change = true;
                }
                if (ObjectUtils.isEmpty((Object)expenseitemPK) || expenseitemPK.longValue() == invoiceEntry.getDynamicObject("expenseitem").getLong("id")) continue block2;
                oldEntry.set("e_expenseitem", invoiceEntry.get("expenseitem"));
                change = true;
                continue block2;
            }
        }
        if (change) {
            logger.info("ApInvoice4MapperSaveOp-invoice data :{}", (Object)oldInvoicemapper);
            logger.info("ApInvoice4MapperSaveOp-invoice entityinfo :{}", (Object)oldEntryDt.toPlainString());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{oldInvoicemapper});
        }
        return null;
    }

    private DynamicObject buildSeller(DynamicObject invoice) {
        if (ObjectUtils.isEmpty((Object)invoice.get("receivablessupp"))) {
            return null;
        }
        QFilter qf = new QFilter("useorg", "=", invoice.getDynamicObject("org").getPkValue());
        qf.and(new QFilter("number", "=", invoice.get("sellertin")));
        String select = "id, number, asstacttype, asstact, biztype, sellername, phone, bankname, bankacctno, address";
        DynamicObject oldseller = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_seller", (String)select, (QFilter[])new QFilter[]{qf});
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"ap_seller");
        DynamicObject seller = new DynamicObject((DynamicObjectType)dt);
        if (ObjectUtils.isEmpty((Object)oldseller)) {
            return this.setSeller(seller, invoice);
        }
        boolean change = false;
        if (!invoice.get("asstacttype").equals(oldseller.get("asstacttype"))) {
            change = true;
        }
        if (invoice.getLong("receivablessupp.id") != oldseller.getLong("asstact.id")) {
            change = true;
        }
        if (!invoice.get("biztype").equals(oldseller.get("biztype"))) {
            change = true;
        }
        if (!invoice.getString("asstactname").equals(oldseller.getString("name"))) {
            change = true;
        }
        if (change) {
            seller.set("asstacttype", invoice.get("asstacttype"));
            seller.set("asstact", invoice.get("receivablessupp"));
            seller.set("name", invoice.get("asstactname"));
            seller.set("biztype", invoice.get("biztype"));
            seller.set("id", oldseller.getPkValue());
            SaveServiceHelper.update((DynamicObject)seller);
        }
        return null;
    }

    private DynamicObject setSeller(DynamicObject seller, DynamicObject invoice) {
        seller.set("useorg", invoice.get("org"));
        seller.set("org", invoice.get("org"));
        seller.set("createorg", invoice.get("org"));
        seller.set("asstacttype", invoice.get("asstacttype"));
        seller.set("asstact", invoice.get("receivablessupp"));
        seller.set("biztype", invoice.get("biztype"));
        seller.set("number", invoice.get("sellertin"));
        seller.set("name", invoice.get("asstactname"));
        seller.set("enable", (Object)"1");
        seller.set("status", (Object)"C");
        seller.set("createtime", (Object)new Date());
        return seller;
    }

    private DynamicObject addInvoiceMapperEntry(DynamicObjectType entryDt, DynamicObject invoiceEntry) {
        DynamicObject invoicemapperEntry = new DynamicObject(entryDt);
        invoicemapperEntry.set("e_invname", invoiceEntry.get("e_invname"));
        if (!ObjectUtils.isEmpty((Object)invoiceEntry.get("e_invspectype"))) {
            invoicemapperEntry.set("e_invspectype", invoiceEntry.get("e_invspectype"));
        }
        if (!ObjectUtils.isEmpty((Object)invoiceEntry.get("e_invunit"))) {
            invoicemapperEntry.set("e_invunit", invoiceEntry.get("e_invunit"));
        }
        if (!ObjectUtils.isEmpty((Object)invoiceEntry.get("material"))) {
            invoicemapperEntry.set("e_material", invoiceEntry.get("material.id"));
        }
        if (!ObjectUtils.isEmpty((Object)invoiceEntry.get("spectype"))) {
            invoicemapperEntry.set("e_spectype", invoiceEntry.get("spectype"));
        }
        if (!ObjectUtils.isEmpty((Object)invoiceEntry.get("measureunit"))) {
            invoicemapperEntry.set("e_measureunit", invoiceEntry.get("measureunit.id"));
        }
        if (!ObjectUtils.isEmpty((Object)invoiceEntry.get("expenseitem"))) {
            invoicemapperEntry.set("e_expenseitem", invoiceEntry.get("expenseitem.id"));
        }
        return invoicemapperEntry;
    }
}

