/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.PeriodHelper;
import kd.fi.arapcommon.service.AdjExchService;
import kd.fi.arapcommon.service.BalanceService;
import kd.fi.arapcommon.service.CloseRecordService;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class AntiClosePeriodOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(AntiClosePeriodOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ArrayList<DynamicObject> inits = new ArrayList<DynamicObject>();
        AdjExchService adjExchService = new AdjExchService("ar");
        HashMap<Long, DynamicObject> orgAndCurPeriod = new HashMap<Long, DynamicObject>(e.getDataEntities().length);
        List orgIds = Arrays.stream(e.getDataEntities()).map(init -> init.getLong("org.id")).collect(Collectors.toList());
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"imsc", (String)"dmw", (String)"EASMigrateService", (String)"GetControlDateByOrg", (Object[])new Object[]{"ar", orgIds});
        logger.info("ar.AntiClosePeriodOp.result:" + result);
        Map orgIdAndControlDateMap = (Map)result.get("data");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        logger.info("ar.AntiClosePeriodOp.orgIdAndControlDateMap:" + orgIdAndControlDateMap);
        for (DynamicObject param : e.getDataEntities()) {
            Long orgPk = param.getDynamicObject("org").getLong("id");
            Long periodPk = param.getLong("curperiod");
            DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)periodPk, (String)"bd_period");
            Date beginDate = period.getDate("begindate");
            InitHelper helper = new InitHelper(orgPk.longValue(), "ar_init");
            DynamicObject init2 = BusinessDataServiceHelper.loadSingleFromCache((Object)helper.getInitId(), (String)"ar_init");
            orgAndCurPeriod.put(orgPk, init2.getDynamicObject("curperiod"));
            StringBuffer error = new StringBuffer();
            if (this.controlDateCheck(beginDate, orgPk, orgIdAndControlDateMap, simpleDateFormat, error) && this.anitCheck(init2, period.getInt("number"), error) & this.adjExchCheck(adjExchService, init2, period, error)) {
                init2.set("curperiod", (Object)period);
                inits.add(init2);
                Date closeDate = DateUtils.getNextDay((Date)beginDate, (int)-1);
                CloseRecordService closeRecordService = new CloseRecordService("ar");
                closeRecordService.deleteCloseRecordByAntiClose(orgPk, closeDate);
                BalanceService balanceService = new BalanceService("ar");
                balanceService.deleteBalanceByClose(orgPk, closeDate);
                continue;
            }
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setPkValue(init2.getPkValue());
            errorInfo.setMessage(error.toString());
            errorInfo.setErrorLevel(ErrorLevel.FatalError.name());
            this.operationResult.addErrorInfo(errorInfo);
            this.operationResult.setSuccess(false);
        }
        if (!inits.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])inits.toArray(new DynamicObject[0]));
            block1: for (DynamicObject init3 : inits) {
                DynamicObject org = init3.getDynamicObject("org");
                DynamicObject period = init3.getDynamicObject("curperiod");
                DynamicObject deletePeriod = (DynamicObject)orgAndCurPeriod.get(org.getPkValue());
                int targetPeriodNumber = period.getInt("number");
                int deletePeriodNumber = deletePeriod.getInt("number");
                while (deletePeriodNumber > targetPeriodNumber) {
                    adjExchService.cancelAdj(org, deletePeriod, Boolean.FALSE);
                    if (!EmptyUtils.isNotEmpty((Object)(deletePeriod = PeriodHelper.getPrevPeriod((long)deletePeriod.getLong("id"))))) continue block1;
                    deletePeriodNumber = deletePeriod.getInt("number");
                }
            }
        }
        e.setDataEntities(inits.toArray(new DynamicObject[0]));
    }

    private boolean controlDateCheck(Date beginDate, long orgPk, Map<Long, String> orgIdAndControlDateMap, SimpleDateFormat simpleDateFormat, StringBuffer error) {
        Date controlDate;
        String controlDateString = orgIdAndControlDateMap.get(orgPk);
        if (controlDateString == null || "".equals(controlDateString)) {
            return true;
        }
        try {
            controlDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(controlDateString + " 00:00:00");
        }
        catch (ParseException eb) {
            throw new KDException((Throwable)eb, BosErrorCode.systemError, new Object[0]);
        }
        if (beginDate.compareTo(controlDate) <= 0) {
            error.append("ar prohibit close period from eas date control");
            return false;
        }
        return true;
    }

    private boolean anitCheck(DynamicObject init, int selectNumber, StringBuffer error) {
        String errorMessage;
        String periodName;
        boolean anitclose = true;
        long curnumber = init.getDynamicObject("curperiod").getLong("number");
        long startnumber = init.getDynamicObject("startperiod").getLong("number");
        String orgName = init.getDynamicObject("org").getLocaleString("name").getLocaleValue();
        if ((long)selectNumber > curnumber) {
            periodName = BusinessDataServiceHelper.loadSingleFromCache((Object)init.getDynamicObject("curperiod").getPkValue(), (String)"bd_period").getLocaleString("name").getLocaleValue();
            errorMessage = String.format(ResManager.loadKDString((String)"%1$s\u5f53\u524d\u671f\u95f4\u4e3a%2$s\u53cd\u7ed3\u8d26\u5931\u8d25", (String)"AntiClosePeriodOp_0", (String)"fi-ar-opplugin", (Object[])new Object[0]), orgName, periodName);
            error.append(errorMessage);
            error.append('\n');
            anitclose = false;
        }
        if ((long)selectNumber < startnumber) {
            periodName = BusinessDataServiceHelper.loadSingleFromCache((Object)init.getDynamicObject("startperiod").getPkValue(), (String)"bd_period").getLocaleString("name").getLocaleValue();
            errorMessage = String.format(ResManager.loadKDString((String)"%1$s\u542f\u7528\u671f\u95f4\u4e3a%2$s\u53cd\u7ed3\u8d26\u5931\u8d25", (String)"AntiClosePeriodOp_1", (String)"fi-ar-opplugin", (Object[])new Object[0]), orgName, periodName);
            error.append(errorMessage);
            error.append('\n');
            anitclose = false;
        }
        if ((long)selectNumber == curnumber) {
            error.append(orgName);
            error.append(ResManager.loadKDString((String)"\u53cd\u7ed3\u671f\u95f4\u4e3a\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u9700\u8981\u53cd\u7ed3\u3002\n", (String)"AntiClosePeriodOp_4", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            anitclose = false;
        }
        return anitclose;
    }

    private boolean adjExchCheck(AdjExchService adjExchService, DynamicObject init, DynamicObject targetPeriod, StringBuffer error) {
        DynamicObject org = init.getDynamicObject("org");
        DynamicObject period = init.getDynamicObject("curperiod");
        ArrayList errorMessages = new ArrayList(8);
        boolean passCheck = true;
        if (EmptyUtils.isEmpty((Object)period)) {
            passCheck = false;
            error.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%\u83b7\u53d6\u5f53\u524d\u671f\u95f4\u5931\u8d25", (String)"AntiClosePeriodOp_6", (String)"fi-ar-opplugin", (Object[])new Object[]{org.getString("name")}));
        } else {
            int targetPeriodNumber = targetPeriod.getInt("number");
            int currentPeriodNumber = period.getInt("number");
            while (currentPeriodNumber > targetPeriodNumber) {
                errorMessages.clear();
                errorMessages.addAll(adjExchService.cancelAdjValidate(org, period));
                if (EmptyUtils.isNotEmpty(errorMessages)) {
                    passCheck = false;
                    error.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u671f\u95f4\uff1a%2$s\u3002", (String)"AntiClosePeriodOp_5", (String)"fi-ar-opplugin", (Object[])new Object[0]), org.getString("name"), period.getString("name")));
                    for (String errorMessage : errorMessages) {
                        error.append(errorMessage);
                    }
                    error.append('\n');
                }
                if (!EmptyUtils.isNotEmpty((Object)(period = PeriodHelper.getPrevPeriod((long)period.getLong("id"))))) break;
                currentPeriodNumber = period.getInt("number");
            }
        }
        return passCheck;
    }
}

