/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.ar.mservice.verify.ArSaloutAutoVerifyService;
import kd.fi.ar.mservice.verify.VerifyServiceFactory;
import kd.fi.ar.validator.ArRevcfmUnAuditValidator;
import kd.fi.arapcommon.enums.ARVerifyStatusEnum;
import kd.fi.arapcommon.helper.ArApProcessParamsHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.Settle4ScmcHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.service.AbstractVerifyTemplate;
import kd.fi.arapcommon.validator.VerifyECUnFinishValidator;

public class ArRevcfmBillUnAuditOp
extends ArapBaseOp {
    private static final Log LOGGER = LogFactory.getLog(ArRevcfmBillUnAuditOp.class);

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        ArrayList<Object> canUnVerifyPks = new ArrayList<Object>();
        for (DynamicObject entity : entities) {
            String verifyStatus = entity.getString("verifystatus");
            if (ARVerifyStatusEnum.UNVERIFY.getValue().equals(verifyStatus)) continue;
            canUnVerifyPks.add(entity.getPkValue());
        }
        ArrayList params = new ArrayList();
        ArApProcessParamsHelper.processRevcfmToSmParams(params, (DynamicObject[])entities, (boolean)false);
        Settle4ScmcHelper.disposeArRevcfmToSalOrder(params);
        if (canUnVerifyPks.size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("nochk", "true");
            OperationResult result = OperationServiceHelper.executeOperate((String)"fakeunaudit", (String)"ar_revcfmbill", (Object[])canUnVerifyPks.toArray(), (OperateOption)option);
            if (!result.isSuccess()) {
                OperationHelper.assertResult((OperationResult)result);
            }
            ArSaloutAutoVerifyService service = new ArSaloutAutoVerifyService();
            service.unAutoVerify(canUnVerifyPks.toArray(), false);
        }
        this.writtenOffBillUnDelete(entities);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("org");
        lst.add("asstacttype");
        lst.add("asstact");
        lst.add("billtype");
        lst.add("verifystatus");
        lst.add("currency");
        lst.add("sourcebillid");
        lst.add("sourcebilltype");
        lst.add("inventorycost");
        lst.add("e_inventorycost");
        lst.add("bookdate");
        lst.add("entry");
        lst.add("iswrittenoff");
        lst.add("e_corebilltype");
        lst.add("e_corebillid");
        lst.add("e_unitcoefficient");
        lst.add("e_corebillentryid");
        lst.add("e_conbillentity");
        lst.add("e_conbillid");
        lst.add("e_conbillentryid");
        lst.add("e_confirmamt");
        lst.add("linetype");
        lst.add("sourcebillid");
        lst.add("sourcebilltype");
        lst.add("billsrctype");
        lst.add("e_confirmqty");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject entity : dataEntities = e.getDataEntities()) {
            entity.set("inventorycost", (Object)BigDecimal.ZERO);
            this.resetEntryInventoryCost(entity);
        }
    }

    private void writtenOffBillUnDelete(DynamicObject[] dataEntities) {
        DynamicObject[] srcRevcfmBills;
        DynamicObject[] verifyRecords;
        ArrayList<Long> writtenBillIds = new ArrayList<Long>(16);
        ArrayList<Long> srcBillIds = new ArrayList<Long>(16);
        for (DynamicObject bill : dataEntities) {
            if (!bill.getBoolean("iswrittenoff")) continue;
            writtenBillIds.add(bill.getLong("id"));
            srcBillIds.add(bill.getLong("sourcebillid"));
        }
        if (writtenBillIds.size() == 0) {
            return;
        }
        for (DynamicObject result : verifyRecords = BusinessDataServiceHelper.load((String)"ar_verifyrecord", (String)this.getVerifyRecordSelects(), (QFilter[])new QFilter[]{new QFilter("billid", "in", srcBillIds), new QFilter("entry.e_billid", "in", writtenBillIds)})) {
            if (!result.getBoolean("isvoucher")) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u7684\u6838\u9500\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ArRevcfmBillUnAuditOp_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
        Map verifyRecordMap = VerifyServiceHelper.classfyByRelation((DynamicObject[])verifyRecords);
        for (Map.Entry entry : verifyRecordMap.entrySet()) {
            AbstractVerifyTemplate verifyTemplate = VerifyServiceFactory.getService((String)((String)entry.getKey()));
            verifyTemplate.unVerify(((List)entry.getValue()).toArray(new DynamicObject[0]));
        }
        for (DynamicObject srcBill : srcRevcfmBills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds)})) {
            srcBill.set("hadwrittenoff", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])srcRevcfmBills);
        this.valid(srcBillIds.toArray());
        OperationServiceHelper.executeOperate((String)"nocheckdel", (String)"ar_revcfmbill", (Object[])writtenBillIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
    }

    private void valid(Object[] pkIds) {
        try {
            OperationResult result = OperationServiceHelper.executeOperate((String)"valid", (String)"ar_revcfmbill", (Object[])pkIds, (OperateOption)OperateOption.create());
            LOGGER.info("valid result :" + result.isSuccess());
            if (!result.isSuccess()) {
                LOGGER.info("valid fail :" + result.getMessage());
                throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25, %s", (String)"ValidOperationServiceHelper_0", (String)"fi-arapcommon", (Object[])new Object[]{result.getMessage()}));
            }
        }
        catch (Exception e) {
            LOGGER.error("valid error :" + e);
            throw e;
        }
    }

    private void resetEntryInventoryCost(DynamicObject entity) {
        DynamicObjectCollection entryList = entity.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entryList) {
            entry.set("e_inventorycost", (Object)BigDecimal.ZERO);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new VerifyECUnFinishValidator());
        if (!this.operateOption.getVariables().containsKey("nochk")) {
            e.addValidator((AbstractValidator)new ArRevcfmUnAuditValidator());
        }
    }

    private String getVerifyRecordSelects() {
        return "org,billid,billno,billtype,billentryid,qty,measureunit,verifyqty,verifybaseqty,payableamount,verifyamount,verifytype,isvoucher,verifyrelation,e_billtype,e_qty,e_measureunit,e_verifyqty,e_verifybaseqty,e_payableamount,e_verifyamount,e_billid,e_billno,e_billentryid,currency,e_currency,e_verifytaxamount,verifytaxamount,e_writtenoffremark,e_iswrittenoff,e_hadwrittenoff";
    }
}

