/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.report.baddebt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataHandle;
import kd.fi.ar.report.baddebt.BadDebtRptParam;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.helper.FspWapper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.helper.PeriodHelper;
import kd.fi.arapcommon.report.ReportHelper;
import kd.fi.arapcommon.report.acctage.AcctageGroup;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.report.acctage.AcctageRptSettingPlugin;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang.StringUtils;

public class BadDebtRptForm
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private Set<Long> orgIds = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("orgs");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", this.getOrgIds()));
        });
        BasedataEdit periodCtrl = (BasedataEdit)this.getControl("accrualperiod");
        periodCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("periodtype", "in", this.getPeriodTypeIds()).and(new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE)));
        });
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject currency;
        DynamicObject init;
        DynamicObject period;
        long orgId = RequestContext.get().getOrgId();
        if (EmptyUtils.isEmpty((Object)this.getModel().getValue("orgs"))) {
            this.orgIds = this.getOrgIds();
            if (this.orgIds != null && this.orgIds.size() > 0) {
                if (!this.orgIds.contains(orgId)) {
                    orgId = this.orgIds.iterator().next();
                }
                this.getModel().setValue("orgs", (Object)new Object[]{orgId});
            }
        }
        if ((period = PeriodHelper.getPeriodByDate((long)orgId, (Date)new Date())) != null) {
            this.getModel().setValue("accrualperiod", (Object)new Object[]{period.getLong("id")});
        }
        if ((init = BusinessDataServiceHelper.loadSingle((String)"ar_init", (String)"standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)})) != null && (currency = init.getDynamicObject("standardcurrency")) != null) {
            this.getModel().setValue("q_currency", (Object)new Object[]{currency.getLong("id")});
        }
        this.resetFilterGrid();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean verify = super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection orgs = queryParam.getFilter().getDynamicObjectCollection("orgs");
        if (orgs == null || orgs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"BadDebtRptForm_0", (String)"fi-ar-report", (Object[])new Object[0]));
            verify = false;
        }
        if (filterInfo.getString("datarange") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u8303\u56f4\u3002", (String)"BadDebtRptForm_1", (String)"fi-ar-report", (Object[])new Object[0]));
            verify = false;
        }
        return verify;
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        List keyCols;
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        if ("showqtycols".equals(key)) {
            List qtyCols = Stream.of(((String)value).split(",")).collect(Collectors.toList());
            if (!qtyCols.contains("standardamt")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u503c\u201d\u4e2d\u201c\u574f\u8d26\u8ba1\u63d0\u57fa\u6570\u201d\u4e3a\u5fc5\u9009\u9879\u3002", (String)"BadDebtRptForm_5", (String)"fi-ar-report", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (((Boolean)this.getModel().getValue("showlocalamt")).booleanValue() && !qtyCols.contains("standardlocalamt")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u503c\u201d\u4e2d\u201c\u574f\u8d26\u8ba1\u63d0\u57fa\u6570(\u672c\u4f4d\u5e01)\u201d\u4e3a\u5fc5\u9009\u9879\u3002", (String)"BadDebtRptForm_6", (String)"fi-ar-report", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
        } else if ("showkeycols".equals(key) && !(keyCols = Stream.of(((String)value).split(",")).collect(Collectors.toList())).contains("asstacttype")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u5f80\u6765\u7c7b\u578b\u201d\u5fc5\u9009\uff01", (String)"AcctageForm_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            e.setCancel(true);
            this.getView().updateView(key);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel m = this.getModel();
        ChangeData[] changeDatas = e.getChangeSet();
        Object newValue = changeDatas[0].getNewValue();
        Object oldValue = changeDatas[0].getOldValue();
        if ("showlocalamt".equals(key)) {
            boolean isShowLocalAmt = (Boolean)newValue;
            ReportConf conf = ReportDataHandle.loadReportConf((String)this.getModel().getDataEntityType().getName());
            List bigTableColConfs = conf.getBigTableColConf();
            List cols = bigTableColConfs.stream().filter(colConf -> "B".equals(colConf.getCalType())).map(BigTableColConf::getCol).collect(Collectors.toList());
            if (!isShowLocalAmt) {
                cols.removeIf(col -> StringUtils.endsWith((String)col, (String)"localamt"));
            }
            m.setValue("showqtycols", (Object)String.join((CharSequence)",", cols));
        }
        if ("q_asstacttype".equals(key)) {
            if (newValue == null || "".equals(newValue)) {
                m.setValue("bd_supplier", null);
                m.setValue("bd_customer", null);
                m.setValue("bos_user", null);
            }
            if ("bd_supplier".equals(newValue)) {
                m.setValue("bd_customer", null);
                m.setValue("bos_user", null);
            }
            if ("bd_customer".equals(newValue)) {
                m.setValue("bd_supplier", null);
                m.setValue("bos_user", null);
            }
            if ("bos_user".equals(newValue)) {
                m.setValue("bd_supplier", null);
                m.setValue("bd_customer", null);
            }
        }
        if ("showperiodresult".equals(key)) {
            if (((Boolean)newValue).booleanValue()) {
                m.setValue("accrualperiod", null);
                this.getView().setEnable(Boolean.FALSE, new String[]{"accrualperiod"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"accrualperiod"});
            }
        }
        if ("orgs".equals(key) && EmptyUtils.isEmpty((Object)newValue)) {
            m.setValue("orgs", oldValue);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        BadDebtRptParam param = this.buildReportParam(queryParam);
        Object hyperLinkClickLineName = this.getView().getFormShowParameter().getCustomParams().get("hyperLinkKey");
        if (hyperLinkClickLineName != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"reportfilterap"});
        }
        queryParam.getCustomParam().put("baddebtparam", param);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("groupset".equals(key)) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("ap_acctagesetting");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "groupset"));
            fsp.setCustomParam("isAr", (Object)Boolean.TRUE);
            FspWapper fspWapper = new FspWapper(fsp);
            fspWapper.clearPlugins();
            fspWapper.registerPlugin(AcctageRptSettingPlugin.class.getName());
            this.getView().showForm(fsp);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter == null) {
            return;
        }
        Map customParams = formShowParameter.getCustomParams();
        if (customParams == null) {
            return;
        }
        if ("baddebtaccruelist".equals(customParams.get("hyperLinkKey"))) {
            boolean isPeriod = (Boolean)customParams.get("isPeriod");
            this.getModel().setValue("orgs", (Object)new Object[]{customParams.get("orgId")});
            this.getModel().setValue("accrualperiod", (Object)new Object[]{customParams.get("periodId")});
            this.getModel().setValue("q_asstacttype", null);
            this.getModel().setValue("q_currency", null);
            this.getModel().setValue("datarange", (Object)"all");
            if (isPeriod) {
                this.getModel().setValue("showperiodresult", (Object)Boolean.TRUE);
            }
            ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
            control.search();
        }
        if ("baddebtrpt".equals(customParams.get("hyperLinkKey"))) {
            this.setQueryConditionDeassign(customParams);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("baddebtbillno".equals(fieldName)) {
            ReportList list = (ReportList)this.getControl("reportlistap");
            DynamicObject rowData = list.getReportModel().getRowData(evt.getRowIndex());
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId("ar_baddebtpreparebill");
            parameter.setPkId((Object)rowData.getLong("id"));
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)parameter);
        } else if ("billno".equals(fieldName)) {
            ReportList list = (ReportList)this.getControl("reportlistap");
            DynamicObject rowData = list.getReportModel().getRowData(evt.getRowIndex());
            boolean exists = QueryServiceHelper.exists((String)"ar_baddebtpreparebill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)rowData.getLong("id")), new QFilter("billsrctype", "!=", (Object)"fromeas")});
            if (!exists) {
                this.getView().showMessage("source bill from eas can not show");
                return;
            }
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(rowData.getString("sourceentity"));
            parameter.setPkId((Object)rowData.getLong("srcid"));
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            ReportShowParameter parameter = new ReportShowParameter();
            FormShowParameter reportParameter = this.getView().getFormShowParameter();
            parameter.setFormId(reportParameter.getFormId());
            parameter.getOpenStyle().setTargetKey(reportParameter.getOpenStyle().getTargetKey());
            parameter.getOpenStyle().setShowType(reportParameter.getFormConfig().getShowType());
            parameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u63d0\u660e\u7ec6", (String)"BadDebtRptForm_4", (String)"fi-ar-report", (Object[])new Object[0]));
            ReportList reportList = (ReportList)evt.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(evt.getRowIndex());
            Map<String, Object> customParams = this.getCustomParams(rowData);
            customParams.put("hyperLinkKey", "baddebtrpt");
            parameter.setCustomParams(customParams);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        List groups;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("groupset".equals(actionId) && (groups = (List)closedCallBackEvent.getReturnData()) != null) {
            this.getPageCache().put("groups", SerializationUtils.toJsonString((Object)groups));
            this.getView().invokeOperation("refresh");
        }
    }

    private BadDebtRptParam buildReportParam(ReportQueryParam queryParam) {
        Map customParams;
        BadDebtRptParam param = new BadDebtRptParam();
        FilterInfo filterInfo = queryParam.getFilter();
        String entity = filterInfo.getString("datarange");
        param.setEntity(entity);
        List orgIds = DynamicObjectHelper.getIdList((Collection)filterInfo.getDynamicObjectCollection("orgs"));
        param.setOrgIds(orgIds);
        param.setCurrencyIds(DynamicObjectHelper.getIdList((Collection)filterInfo.getDynamicObjectCollection("q_currency")));
        String asstactType = filterInfo.getString("q_asstacttype");
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            param.setAsstactType(asstactType);
            DynamicObjectCollection acctacts = filterInfo.getDynamicObjectCollection(param.getAsstactType());
            param.setAsstactPks(ReportHelper.getBasedataIds((List)acctacts));
        }
        param.setShowLocalAmt(filterInfo.getBoolean("showlocalamt"));
        param.setShowByBill(filterInfo.getBoolean("showbybill"));
        param.setHyperLink(false);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter != null && (customParams = formShowParameter.getCustomParams()) != null && "baddebtrpt".equals(customParams.get("hyperLinkKey"))) {
            param.setHyperLink(true);
        }
        DynamicObjectCollection accrualperiod = filterInfo.getDynamicObjectCollection("accrualperiod");
        ArrayList<Long> periodIds = new ArrayList<Long>(8);
        boolean showPeriodResult = filterInfo.getBoolean("showperiodresult");
        param.setShowPeriodResult(showPeriodResult);
        if (showPeriodResult) {
            periodIds.add(0L);
        } else if (accrualperiod != null && accrualperiod.size() > 0) {
            accrualperiod.forEach(period -> {
                Object id = period.get("id");
                periodIds.add((Long)id);
            });
        }
        param.setPeriodIds(periodIds);
        return param;
    }

    private Set<Long> getOrgIds() {
        List orgs = OrgHelper.getAuthorizedInitializedOrgs((String)this.getView().getEntityId(), (String)"47150e89000000ac");
        return orgs.stream().map(org -> org.getLong("id")).collect(Collectors.toSet());
    }

    private Set<Long> getPeriodTypeIds() {
        HashSet<Long> periodTypeIdSet = new HashSet<Long>(8);
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
        if (EmptyUtils.isNotEmpty((Object)orgs)) {
            for (DynamicObject org : orgs) {
                long orgId = ((DynamicObject)org.get("fbasedataid")).getLong("id");
                long periodTypeId = PeriodHelper.getPeriodTypeId((long)orgId);
                periodTypeIdSet.add(periodTypeId);
            }
        }
        return periodTypeIdSet;
    }

    private List<AcctageGroup> getGroups(List<Object> orgIds) {
        FormShowParameter formShowParameter;
        List<AcctageGroup> groups = new ArrayList(8);
        String groupStr = this.getPageCache().get("groups");
        if (ObjectUtils.isEmpty((Object)groupStr)) {
            block0: for (Object orgId : orgIds) {
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                QFilter statusFilter = new QFilter("status", "=", (Object)"C");
                DynamicObjectCollection accrualAgingGroups = BaseDataServiceHelper.queryBaseData((String)"ar_accrualaging", (Long)((Long)orgId), (QFilter)statusFilter.and(enableFilter), (String)"id");
                List accrualAgingGroupIds = DynamicObjectHelper.getIdList((Collection)accrualAgingGroups);
                Map accrualAgings = BusinessDataServiceHelper.loadFromCache((Object[])accrualAgingGroupIds.toArray(), (String)"ar_accrualaging");
                for (Map.Entry accrualAgingMap : accrualAgings.entrySet()) {
                    DynamicObject accrualAging = (DynamicObject)accrualAgingMap.getValue();
                    DynamicObjectCollection entry = accrualAging.getDynamicObjectCollection("entry");
                    for (DynamicObject row : entry) {
                        AcctageGroup acctageGroup = new AcctageGroup();
                        Integer startDay = row.getInt("e_startday");
                        Integer endDay = row.getInt("e_endday");
                        boolean isEndDayZero = endDay.equals(0);
                        if (startDay.equals(0) && isEndDayZero) break;
                        acctageGroup.setBeginDay(startDay);
                        if (!isEndDayZero) {
                            acctageGroup.setEndDay(endDay);
                        }
                        acctageGroup.setDisplayName(row.getString("e_section"));
                        groups.add(acctageGroup);
                    }
                    if (groups.isEmpty()) continue;
                    break block0;
                }
            }
            if (groups.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u8ba1\u63d0\u8d26\u9f84\u5206\u7ec4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BadDebtRptForm_3", (String)"fi-ar-report", (Object[])new Object[0]));
            }
        } else {
            groups = SerializationUtils.fromJsonStringToList((String)groupStr, AcctageGroup.class);
        }
        if ((formShowParameter = this.getView().getFormShowParameter()) == null) {
            return groups;
        }
        Map customParams = formShowParameter.getCustomParams();
        if (customParams == null) {
            return groups;
        }
        ArrayList<AcctageGroup> hyperLinkClickGroups = new ArrayList<AcctageGroup>(8);
        if ("baddebtrpt".equals(customParams.get("hyperLinkKey"))) {
            for (int i = 0; i < groups.size(); ++i) {
                AcctageGroup agingGroup = groups.get(i);
                if (!AcctageHelper.getAmountFieldName((AcctageGroup)agingGroup, (String)"standardamt").equals(customParams.get("groupname"))) continue;
                hyperLinkClickGroups.add(agingGroup);
            }
        }
        if (hyperLinkClickGroups.size() > 0) {
            return hyperLinkClickGroups;
        }
        return groups;
    }

    private void setQueryConditionDeassign(Map<String, Object> customParams) {
        IDataModel parentModel = this.getView().getParentView().getModel();
        List<String> filterFieldKeys = this.getFilterFieldKeys();
        IDataModel m = this.getModel();
        DataEntityPropertyCollection properties = m.getDataEntityType().getProperties();
        Map rowData = (Map)customParams.get("rowData");
        for (String originalFieldKey : filterFieldKeys) {
            IDataEntityProperty prop;
            Object value = null;
            String propKey = originalFieldKey;
            if (originalFieldKey.startsWith("q_")) {
                propKey = originalFieldKey.substring(2);
            } else if ("bd_customer".equals(originalFieldKey) || "bd_supplier".equals(originalFieldKey) || "bos_user".equals(originalFieldKey)) {
                propKey = "asstact";
            }
            if (rowData.get(propKey) != null) {
                value = rowData.get(propKey);
            }
            if (ObjectUtils.isEmpty(value)) {
                value = parentModel.getValue(originalFieldKey);
            }
            if ((prop = (IDataEntityProperty)properties.get((Object)originalFieldKey)) instanceof MulBasedataProp) {
                value = this.getMutlBasedataPks(value);
            } else if (prop instanceof ItemClassProp && value instanceof Map) {
                value = ((Map)value).get("id");
            }
            m.setValue(originalFieldKey, value);
        }
        m.setValue("showbybill", (Object)Boolean.TRUE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"groupset_btn"});
        ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
        control.search();
    }

    private Map<String, Object> getCustomParams(DynamicObject rowData) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        HashMap<String, Object> rowDataMap = new HashMap<String, Object>(8);
        customParams.put("isopenbyhyperlink", Boolean.TRUE);
        rowDataMap.put("asstacttype", rowData.get("asstacttype"));
        rowDataMap.put("asstact", rowData.get("asstact"));
        rowDataMap.put("currency", rowData.get("currency"));
        rowDataMap.put("accrualperiod", rowData.get("period"));
        customParams.put("rowData", rowDataMap);
        return customParams;
    }

    private List<String> getFilterFieldKeys() {
        Container fixFilterContainer = (Container)this.getView().getControl("fsap");
        Container commFilterContainer = (Container)this.getView().getControl("commonfs");
        Container showFilterContainer = (Container)this.getView().getControl("flexpanelap1");
        Container moreFilterContainer = (Container)this.getView().getControl("reportmorefilterpanelap");
        ArrayList filterItems = new ArrayList(8);
        filterItems.addAll(fixFilterContainer.getItems());
        filterItems.addAll(commFilterContainer.getItems());
        filterItems.addAll(showFilterContainer.getItems());
        filterItems.addAll(moreFilterContainer.getItems());
        return filterItems.stream().map(Control::getKey).collect(Collectors.toList());
    }

    private Object getMutlBasedataPks(Object value) {
        if (value instanceof DynamicObjectCollection) {
            DynamicObjectCollection temCollectionValue = (DynamicObjectCollection)value;
            ArrayList<Object> pks = new ArrayList<Object>(((DynamicObjectCollection)value).size());
            for (DynamicObject eachValue : temCollectionValue) {
                pks.add(eachValue.getDynamicObject("fbasedataid").getPkValue());
            }
            value = pks.toArray(new Object[0]);
        } else if (value instanceof DynamicObject) {
            value = new Object[]{((DynamicObject)value).getPkValue()};
        } else if (value instanceof Map) {
            Object id = ((Map)value).get("id");
            value = new Object[]{Long.valueOf(id.toString())};
        }
        return value;
    }

    private void resetFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (!this.filterGrid(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        HashSet<String> removedPros = new HashSet<String>();
        removedPros.add("org");
        removedPros.add("asstacttype");
        removedPros.add("asstact");
        removedPros.add("currency");
        return removedPros.contains(split[0]);
    }
}

