/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.service.baddebtnew;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.business.service.baddebtnew.BadDebtContext;
import kd.fi.ar.vo.baddebtnew.BadDebtCalculateVO;
import kd.fi.ar.vo.baddebtnew.BadDebtCommonVO;
import kd.fi.ar.vo.baddebtnew.BadDebtPrepareBillEntryVO;
import kd.fi.arapcommon.service.adjustexch.AdjustExchHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.adjexch.BillFieldMappingVO;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractBadDebtBillHandler {
    protected static final Log logger = LogFactory.getLog(AbstractBadDebtBillHandler.class);
    protected static final String AR_BADDEBTACCRUAL = "ar_baddebtpreparebill";
    protected BadDebtContext badDebtContext = null;
    protected Set<Object> inverseBillIdSet = new HashSet<Object>(8);
    protected Map<String, Set<BillFieldMappingVO>> billFieldMappingVOMap = new HashMap<String, Set<BillFieldMappingVO>>(16);

    public AbstractBadDebtBillHandler(BadDebtContext badDebtContext) {
        this.badDebtContext = badDebtContext;
        this.initBillFieldMappingVOMap();
    }

    public abstract List<BadDebtCommonVO> getBillIds(Set<Long> var1);

    public abstract List<BadDebtCommonVO> getBillIds(Set<Long> var1, Set<Long> var2);

    public abstract LinkedHashMap<Object, BadDebtCalculateVO> getBills(List<BadDebtCommonVO> var1);

    public abstract Map<Object, BadDebtCalculateVO> getProcessBills();

    public abstract Set<String> getOriginSelector();

    public abstract String getEntityKey();

    public abstract Map<Object, BadDebtCalculateVO> getOffsetBill();

    public abstract Map<Object, BadDebtCalculateVO> getBadDebtLossBill();

    public Set<String> getSelector() {
        Set<String> selector = this.getOriginSelector();
        String entityKey = this.getEntityKey();
        for (BillFieldMappingVO vo : this.billFieldMappingVOMap.get(entityKey)) {
            if (entityKey.equals(vo.getSrcFieldSite())) {
                selector.add(vo.getSrcField());
                continue;
            }
            selector.add(vo.getSrcFieldSite() + "." + vo.getSrcField());
        }
        return selector;
    }

    protected static Set<String> getBaseBillSelector() {
        HashSet<String> selector = new HashSet<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("exratetable");
        selector.add("exratedate");
        selector.add("exchangerate");
        selector.add("currency");
        selector.add("asstacttype");
        selector.add("asstact");
        selector.add("remark");
        selector.add("quotation");
        return selector;
    }

    protected List<String> getBadDebtProviosionBillSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("asstact");
        selector.add("asstacttype");
        selector.add("billno");
        selector.add("isoffset");
        selector.add("remark");
        selector.add("currency");
        selector.add("exratetable");
        selector.add("exratedate");
        selector.add("quotation");
        selector.add("exchangerate");
        selector.add("accrualscheme");
        selector.add("accrualmethod");
        selector.add("individualreason");
        selector.add("accrualobj");
        selector.add("accrualfrequency");
        selector.add("agingrange");
        selector.add("accrualpercent");
        selector.add("sourcebilltype");
        selector.add("sourcebillid");
        selector.add("sourcebilldate");
        selector.add("billsrctype");
        selector.add("entry.id");
        selector.add("entry.e_material");
        selector.add("entry.e_expenseitem");
        selector.add("entry.e_agingrange");
        selector.add("entry.e_accrualpercent");
        selector.add("entry.e_srcbillid");
        selector.add("entry.e_srcentryid");
        selector.add("entry.e_curaccruedamt");
        selector.add("entry.e_curaccruedlocalamt");
        selector.add("entry.e_recamount");
        selector.add("entry.e_reclocalamt");
        String entityKey = this.getEntityKey();
        for (BillFieldMappingVO billFieldMappingVO : this.billFieldMappingVOMap.get(entityKey)) {
            if (AR_BADDEBTACCRUAL.equals(billFieldMappingVO.getTargetFieldSite())) {
                selector.add(billFieldMappingVO.getTargetField());
                continue;
            }
            selector.add(billFieldMappingVO.getTargetFieldSite() + "." + billFieldMappingVO.getTargetField());
        }
        return selector.stream().distinct().collect(Collectors.toList());
    }

    public final void initBillFieldMappingVOMap() {
        Set<BillFieldMappingVO> billFieldMappingVOS;
        String entityKey = this.getEntityKey();
        this.billFieldMappingVOMap.put(entityKey, AdjustExchHelper.getBillFieldMapping((String)entityKey, (String)AR_BADDEBTACCRUAL));
        boolean materialSettle = this.badDebtContext.isMaterialSettle();
        if ("ar_finarbill".equals(entityKey) && (billFieldMappingVOS = this.billFieldMappingVOMap.get(entityKey)) != null && !billFieldMappingVOS.isEmpty()) {
            Iterator<BillFieldMappingVO> iterator = billFieldMappingVOS.iterator();
            while (iterator.hasNext()) {
                BillFieldMappingVO next = iterator.next();
                String srcFieldSite = next.getSrcFieldSite();
                if ((!materialSettle || !"planentity".equals(srcFieldSite)) && (materialSettle || !"entry".equals(srcFieldSite))) continue;
                iterator.remove();
            }
        }
    }

    public void extendFieldVoluation(BadDebtCalculateVO vo, Row row) {
        for (BillFieldMappingVO billFieldMappingVO : this.billFieldMappingVOMap.get(this.getEntityKey())) {
            if (AR_BADDEBTACCRUAL.equals(billFieldMappingVO.getTargetFieldSite())) {
                vo.getBillMap().put(billFieldMappingVO.getTargetField(), row.get(billFieldMappingVO.getSrcField()));
                continue;
            }
            vo.getEntryMap().put(billFieldMappingVO.getTargetField(), row.get(billFieldMappingVO.getSrcFieldSite() + "." + billFieldMappingVO.getSrcField()));
        }
    }

    public Map<Long, Long> getLastBadDebtPrepareBillIds() {
        HashMap<Long, Long> lastBillsSrcAndIdMap = new HashMap<Long, Long>(64);
        if (this.badDebtContext.getLastPeriodId() == null || this.badDebtContext.isPeriod()) {
            return lastBillsSrcAndIdMap;
        }
        QFilter filter = new QFilter("org.id", "=", (Object)this.badDebtContext.getOrgId());
        filter.and(new QFilter("period.id", "=", (Object)this.badDebtContext.getLastPeriodId()));
        filter.and(new QFilter("sourcebilltype", "=", (Object)this.getEntityKey()));
        filter.and(new QFilter("billsrctype", "!=", (Object)"fromeas"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)AR_BADDEBTACCRUAL, (String)"id,entry.e_srcbillid", (QFilter[])filter.toArray(), (String)"accrualdate");
        for (Row row : dataSet) {
            Long id = row.getLong("id");
            Long srcBillId = row.getLong("entry.e_srcbillid");
            lastBillsSrcAndIdMap.put(srcBillId, id);
        }
        return lastBillsSrcAndIdMap;
    }

    public Map<Object, BadDebtPrepareBillEntryVO> getLastBadDebtPrepareBill(Map<Long, Long> lastBillsSrcAndIdMap, List<BadDebtCommonVO> subBillIds, boolean onlyLastPrepareBill, Map<String, List<Long>> mappingMap) {
        HashMap<Object, BadDebtPrepareBillEntryVO> lastBadDebtPrepareMap = new HashMap<Object, BadDebtPrepareBillEntryVO>(32);
        if (lastBillsSrcAndIdMap.isEmpty() || subBillIds.size() <= 0 && !onlyLastPrepareBill) {
            return lastBadDebtPrepareMap;
        }
        HashSet<Long> lastBadDebtPrepareBillIds = new HashSet<Long>(32);
        if (onlyLastPrepareBill) {
            lastBadDebtPrepareBillIds.addAll(lastBillsSrcAndIdMap.values());
        } else {
            Set srcIds = subBillIds.stream().map(BadDebtCommonVO::getId).collect(Collectors.toSet());
            for (Long srcId : srcIds) {
                Long badDebtBillId = lastBillsSrcAndIdMap.get(srcId);
                if (badDebtBillId == null) continue;
                lastBadDebtPrepareBillIds.add(badDebtBillId);
                lastBillsSrcAndIdMap.remove(srcId);
            }
        }
        QFilter filter = new QFilter("id", "in", lastBadDebtPrepareBillIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)AR_BADDEBTACCRUAL, (String)StringUtils.join((Object[])this.getBadDebtProviosionBillSelector().toArray(), (String)","), (QFilter[])filter.toArray(), (String)"accrualdate");
        for (Row row : dataSet) {
            BadDebtPrepareBillEntryVO lastBadDebtPrepareBillVO = this.lastPrePareBillFieldAssignment(row);
            Long srcBillId = row.getLong("entry.e_srcbillid");
            Long srcEntryId = row.getLong("entry.e_srcentryid");
            String srcbillidStr = srcBillId.toString();
            List<Long> entryIdList = mappingMap.get(srcbillidStr);
            if (EmptyUtils.isNotEmpty(entryIdList)) {
                entryIdList.add(srcEntryId);
            } else {
                entryIdList = new ArrayList<Long>(1);
                entryIdList.add(srcEntryId);
                mappingMap.put(srcbillidStr, entryIdList);
            }
            for (BillFieldMappingVO billFieldMappingVO : this.billFieldMappingVOMap.get(this.getEntityKey())) {
                if (AR_BADDEBTACCRUAL.equals(billFieldMappingVO.getTargetFieldSite())) {
                    lastBadDebtPrepareBillVO.getBillMap().put(billFieldMappingVO.getTargetField(), row.get(billFieldMappingVO.getTargetField()));
                    continue;
                }
                lastBadDebtPrepareBillVO.getEntryMap().put(billFieldMappingVO.getTargetField(), row.get(billFieldMappingVO.getTargetFieldSite() + "." + billFieldMappingVO.getTargetField()));
            }
            lastBadDebtPrepareMap.put(srcEntryId, lastBadDebtPrepareBillVO);
        }
        return lastBadDebtPrepareMap;
    }

    public List<BadDebtPrepareBillEntryVO> getLastBadDebtPrepareBillForEas(List<Long> billIds) {
        ArrayList<BadDebtPrepareBillEntryVO> result = new ArrayList<BadDebtPrepareBillEntryVO>(32);
        QFilter filter = new QFilter("id", "in", billIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)AR_BADDEBTACCRUAL, (String)StringUtils.join((Object[])this.getBadDebtProviosionBillSelector().toArray(), (String)","), (QFilter[])filter.toArray(), (String)"accrualdate");
        for (Row row : dataSet) {
            BadDebtPrepareBillEntryVO lastBadDebtPrepareBillVO = this.lastPrePareBillFieldAssignment(row);
            lastBadDebtPrepareBillVO.setSourceBillId(row.getString("id"));
            lastBadDebtPrepareBillVO.setBillSrcType(row.getString("billsrctype"));
            result.add(lastBadDebtPrepareBillVO);
        }
        return result;
    }

    protected BadDebtPrepareBillEntryVO lastPrePareBillFieldAssignment(Row row) {
        BadDebtPrepareBillEntryVO lastBadDebtPrepareBillVO = new BadDebtPrepareBillEntryVO();
        lastBadDebtPrepareBillVO.setAsstactId(row.getLong("asstact").longValue());
        lastBadDebtPrepareBillVO.setAsstactType(row.getString("asstacttype"));
        lastBadDebtPrepareBillVO.setBillNo(row.getString("billno"));
        lastBadDebtPrepareBillVO.setOffset(row.getBoolean("isoffset").booleanValue());
        lastBadDebtPrepareBillVO.setRemark(row.getString("remark"));
        lastBadDebtPrepareBillVO.setCurrencyId(row.getLong("currency").longValue());
        lastBadDebtPrepareBillVO.setExrateTableId(row.getLong("exratetable").longValue());
        lastBadDebtPrepareBillVO.setExrateDate(row.getDate("exratedate"));
        lastBadDebtPrepareBillVO.setQuotation(row.getString("quotation"));
        lastBadDebtPrepareBillVO.setExchangeRate(row.getBigDecimal("exchangerate"));
        lastBadDebtPrepareBillVO.setAccrualScheme(row.getLong("accrualscheme").longValue());
        lastBadDebtPrepareBillVO.setAccrualObj(row.getLong("accrualobj").longValue());
        lastBadDebtPrepareBillVO.setIndividualReason(row.getString("individualreason"));
        lastBadDebtPrepareBillVO.setAccrualMethod(row.getString("accrualmethod"));
        lastBadDebtPrepareBillVO.setAccrualFrequency(row.getString("accrualfrequency"));
        lastBadDebtPrepareBillVO.setSourceBillType(row.getString("sourcebilltype"));
        lastBadDebtPrepareBillVO.setSourceBillId(row.getString("sourcebillid"));
        lastBadDebtPrepareBillVO.setSourceBillDate(row.getDate("sourcebilldate"));
        lastBadDebtPrepareBillVO.setMaterialId(row.getLong("entry.e_material").longValue());
        lastBadDebtPrepareBillVO.setExpenseItemId(row.getLong("entry.e_expenseitem").longValue());
        lastBadDebtPrepareBillVO.setCurAccruedAmt(row.getBigDecimal("entry.e_curaccruedamt"));
        lastBadDebtPrepareBillVO.setCurAccruedAmtLocal(row.getBigDecimal("entry.e_curaccruedlocalamt"));
        lastBadDebtPrepareBillVO.setRecAmount(row.getBigDecimal("entry.e_recamount"));
        lastBadDebtPrepareBillVO.setRecLocalAmt(row.getBigDecimal("entry.e_reclocalamt"));
        lastBadDebtPrepareBillVO.setAgingRange(row.getString("entry.e_agingrange"));
        lastBadDebtPrepareBillVO.setAccrualPercent(row.getBigDecimal("entry.e_accrualpercent"));
        lastBadDebtPrepareBillVO.setSrcBillId(row.getLong("entry.e_srcbillid").longValue());
        lastBadDebtPrepareBillVO.setSrcEntryId(row.getLong("entry.e_srcentryid").longValue());
        return lastBadDebtPrepareBillVO;
    }

    public Set<Object> getInverseBillIdSet() {
        return this.inverseBillIdSet;
    }

    public void setInverseBillIdSet(Set<Object> inverseBillIdSet) {
        this.inverseBillIdSet = inverseBillIdSet;
    }
}

