/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceSwitch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.enums.ARVerifyStatusEnum;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.QuotationHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;
import kd.fi.arapcommon.service.helper.CommonVerifyServiceHelper;
import kd.fi.arapcommon.service.helper.VerifyLogHelper;
import kd.fi.arapcommon.service.log.MserviceLogHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.vo.BillVerifyVO;
import kd.fi.arapcommon.vo.RedVerifyRecordParam;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.vo.VerifyRecordEntryVO;
import kd.fi.arapcommon.vo.VerifyRecordVO;

public class VerifyServiceHelper {
    private static final Log logger = LogFactory.getLog(VerifyServiceHelper.class);

    public static List<Object> saveVerifyRecord(DynamicObject[] results) {
        long start = System.currentTimeMillis();
        Map<Long, List<DynamicObject>> verifyRecordMap = Stream.of(results).collect(Collectors.groupingBy(verifyRecord -> verifyRecord.getLong("org.id")));
        for (Map.Entry<Long, List<DynamicObject>> map : verifyRecordMap.entrySet()) {
            List<DynamicObject> verifyRecords = map.getValue();
            Map verifySeqMap = CommonVerifyServiceHelper.getVerifySeqMap((DynamicObject[])verifyRecords.toArray(new DynamicObject[0]), (String)"ar_verifyrecord");
            for (DynamicObject verifyRecord2 : verifyRecords) {
                long mainBillId = verifyRecord2.getLong("billid");
                DynamicObjectCollection entry = verifyRecord2.getDynamicObjectCollection("entry");
                long asstBillId = ((DynamicObject)entry.get(0)).getLong("e_billid");
                verifyRecord2.set("verifyseq", verifySeqMap.get(mainBillId + "-" + asstBillId));
            }
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ar_verifyrecord", (DynamicObject[])results, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)result);
        long end = System.currentTimeMillis();
        logger.info("save verifyrecord spend " + (end - start));
        return result.getSuccessPkIds();
    }

    public static List<VerifyRecordVO> verify(List<BillVerifyVO> mainList, List<BillVerifyVO> asstList, SettleSchemeVO scheme, String verifyType) {
        logger.info("verify SettleSchemeVO :" + scheme);
        ArrayList<VerifyRecordVO> resultList = new ArrayList<VerifyRecordVO>();
        Map<Long, Long> entryRowBotpMap = new HashMap<Long, Long>();
        Map<Long, Long> asstactIdToMasterIdMap = VerifyServiceHelper.buildMapForAsstactIdToMasterId(mainList, asstList);
        String isAsstActMatch = StdConfig.get((String)"verify.isAsstActMatch");
        HashMap<String, Boolean> billAsstMatchMap = new HashMap<String, Boolean>(8);
        if (scheme.isOnlyByBotp()) {
            String asstBill = asstList.get(0).getBillType();
            String entryType = asstList.get(0).getEntryEntityName();
            HashSet<Long> asstIds = new HashSet<Long>(asstList.size());
            ArrayList asstEntryIds = new ArrayList(asstList.size());
            for (BillVerifyVO asst : asstList) {
                asstIds.add(asst.getId());
                asstEntryIds.add(asst.getEntryId());
            }
            entryRowBotpMap = BOTPHelper.loadSourceRowIdsMap((String)asstBill, (String)entryType, (Long[])asstIds.toArray(new Long[0]), (Long[])asstEntryIds.toArray(new Long[0]), (String)mainList.get(0).getBillType());
        }
        block1: for (BillVerifyVO main : mainList) {
            ArrayList<BillVerifyVO> matchAsstList = new ArrayList<BillVerifyVO>();
            for (BillVerifyVO asst : asstList) {
                if (asst.getEntryUnSettleQty().compareTo(BigDecimal.ZERO) == 0 || !VerifyServiceHelper.isMatch(main, asst, scheme, entryRowBotpMap, asstactIdToMasterIdMap, billAsstMatchMap, isAsstActMatch)) continue;
                matchAsstList.add(asst);
            }
            if (matchAsstList.size() <= 0) continue;
            if ((scheme.isOnlyByBotp() || scheme.isOnlyByCoreBill()) && matchAsstList.size() == 1 && ((BillVerifyVO)matchAsstList.get(0)).isAllVerify()) {
                ArrayList<BillVerifyVO> mainAllVerifyList = new ArrayList<BillVerifyVO>();
                mainAllVerifyList.add(main);
                resultList.addAll(VerifyServiceHelper.allVerify(mainAllVerifyList, matchAsstList, scheme, verifyType));
                main.setEntryUnSettleQty(BigDecimal.ZERO);
                ((BillVerifyVO)matchAsstList.get(0)).setEntryUnSettleQty(BigDecimal.ZERO);
                continue;
            }
            for (BillVerifyVO asst : matchAsstList) {
                if (main.getEntryUnSettleQty().compareTo(BigDecimal.ZERO) == 0) continue block1;
                if (asst.getEntryUnSettleQty().compareTo(BigDecimal.ZERO) == 0) continue;
                VerifyRecordVO result = new VerifyRecordVO();
                ArrayList<BillVerifyVO> tempAsstList = new ArrayList<BillVerifyVO>(1);
                tempAsstList.add(asst);
                VerifyServiceHelper.buildVerifyRecord(main, tempAsstList, scheme, result, verifyType);
                resultList.add(result);
            }
        }
        return resultList;
    }

    private static Map<Long, Long> buildMapForAsstactIdToMasterId(List<BillVerifyVO> mainList, List<BillVerifyVO> asstList) {
        HashMap<Long, Long> asstactIdToMasterIdMap = new HashMap<Long, Long>(16);
        HashSet<Long> supplierIdSet = new HashSet<Long>(64);
        HashSet<Long> customerIdSet = new HashSet<Long>(64);
        for (BillVerifyVO main : mainList) {
            if ("bd_supplier".equals(main.getAsstActType())) {
                supplierIdSet.add(main.getAsstActId());
            }
            if (!"bd_customer".equals(main.getAsstActType())) continue;
            customerIdSet.add(main.getAsstActId());
        }
        for (BillVerifyVO asst : asstList) {
            if ("bd_supplier".equals(asst.getAsstActType())) {
                supplierIdSet.add(asst.getAsstActId());
            }
            if (!"bd_customer".equals(asst.getAsstActType())) continue;
            customerIdSet.add(asst.getAsstActId());
        }
        String selectField = "id,masterid";
        if (supplierIdSet.size() > 0) {
            DynamicObjectCollection supplierCollection = QueryServiceHelper.query((String)"bd_supplier", (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIdSet)});
            asstactIdToMasterIdMap.putAll(supplierCollection.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("masterid"))));
        }
        if (customerIdSet.size() > 0) {
            DynamicObjectCollection customerCollection = QueryServiceHelper.query((String)"bd_customer", (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "in", customerIdSet)});
            asstactIdToMasterIdMap.putAll(customerCollection.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("masterid"))));
        }
        return asstactIdToMasterIdMap;
    }

    public static List<VerifyRecordVO> allVerify(List<BillVerifyVO> mainList, List<BillVerifyVO> asstList, SettleSchemeVO scheme, String verifyType) {
        ArrayList<VerifyRecordVO> resultList = new ArrayList<VerifyRecordVO>();
        BillVerifyVO main = mainList.get(0);
        VerifyRecordVO result = new VerifyRecordVO();
        result.setPrecision(main.getPrecision());
        result.setBasePrecision(main.getBasePrecision());
        result.setSettleDate(new Date());
        result.setCreatorId(RequestContext.get().getCurrUserId());
        result.setOrgId(main.getOrgId());
        result.setCurrencyId(main.getCurrencyId());
        result.setMaterialId(main.getEntryMaterialId());
        result.setMeasureunitId(Long.valueOf(main.getEntryMeasureUnitId()));
        result.setBaseunitId(Long.valueOf(main.getEntryBaseUnitId()));
        result.setBillNo(main.getBillNo());
        result.setBillDate(main.getBizdate());
        result.setBillType(main.getBillType());
        result.setQty(main.getEntryQty());
        BigDecimal mainVerifyQty = UnitConvertHelper.getBaseunitqty((BigDecimal)main.getEntryUnSettleQty(), (BigDecimal)BigDecimal.ONE, (DynamicObject)main.getEntryMeasureUnit());
        result.setVerifyQty(mainVerifyQty);
        BigDecimal convertRate = main.getUnitCoefficient();
        BigDecimal mainVerifyBaseQty = UnitConvertHelper.getBaseunitqty((BigDecimal)main.getEntryUnSettleQty(), (BigDecimal)convertRate, (DynamicObject)main.getEntryBaseUnit());
        result.setVerifyBaseQty(mainVerifyBaseQty);
        result.setMainPayableAmt(main.getEntryPayableAmt());
        result.setTotalSettleAmt(main.getPrice().multiply(main.getEntryUnSettleQty()).setScale((int)main.getPrecision(), RoundingMode.HALF_UP));
        result.setAsstActType(main.getAsstActType());
        result.setAsstActId(main.getAsstActId());
        result.setMainBillId(main.getId());
        result.setMainBillEntryId(main.getEntryId());
        result.setSettleType(verifyType);
        result.setBaseCurrencyId(main.getBaseCurrencyId());
        result.setQuotation(main.getQuotation());
        result.setExchangeRate(main.getExchangeRate());
        BigDecimal verifyTaxAmt = BigDecimal.ZERO;
        for (BillVerifyVO asst : asstList) {
            if (!VerifyServiceHelper.isAllVerifyMatch(main, asst)) continue;
            VerifyRecordEntryVO entryVO = new VerifyRecordEntryVO();
            result.getVrEntrys().add(entryVO);
            entryVO.setPrecision(asst.getPrecision());
            entryVO.setBasePrecision(asst.getBasePrecision());
            entryVO.setBillNum(asst.getBillNo());
            entryVO.setBillDate(asst.getBizdate());
            entryVO.setBillType(asst.getBillType());
            entryVO.setCurrencyId(asst.getCurrencyId());
            entryVO.setQty(asst.getEntryQty());
            BigDecimal asstVerifyQty = UnitConvertHelper.getBaseunitqty((BigDecimal)asst.getEntryUnSettleQty(), (BigDecimal)BigDecimal.ONE, (DynamicObject)asst.getEntryMeasureUnit());
            entryVO.setVerifyQty(asstVerifyQty);
            BigDecimal asstConvertRate = asst.getUnitCoefficient();
            BigDecimal asstVerifyBaseQty = UnitConvertHelper.getBaseunitqty((BigDecimal)asst.getEntryUnSettleQty(), (BigDecimal)asstConvertRate, (DynamicObject)asst.getEntryBaseUnit());
            entryVO.setVerifyBaseQty(asstVerifyBaseQty);
            entryVO.setPayableAmt(asst.getEntryPayableAmt());
            if (asst.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) == 0) {
                entryVO.setSettleAmt(asst.getPrice().multiply(asst.getEntryUnSettleQty()).setScale((int)asst.getPrecision(), RoundingMode.HALF_UP));
            } else {
                entryVO.setSettleAmt(asst.getEntryUnSettleAmt().setScale((int)asst.getPrecision(), RoundingMode.HALF_UP));
            }
            if (asst.getPriceTax() != null) {
                entryVO.setVerifyAmt(asst.getPriceTax().multiply(asst.getEntryUnSettleQty()).setScale((int)asst.getPrecision(), RoundingMode.HALF_UP));
                verifyTaxAmt = verifyTaxAmt.add(entryVO.getVerifyAmt());
            }
            entryVO.setAsstActType(asst.getAsstActType());
            entryVO.setAsstActId(asst.getAsstActId());
            entryVO.setMaterielId(Long.valueOf(asst.getEntryMaterialId()));
            entryVO.setMeasureunitId(Long.valueOf(asst.getEntryMeasureUnitId()));
            entryVO.setBaseunitId(Long.valueOf(asst.getEntryBaseUnitId()));
            entryVO.setBillId(asst.getId());
            entryVO.setBillEntryId(asst.getEntryId());
            entryVO.setBaseCurrencyId(asst.getBaseCurrencyId());
            entryVO.setQuotation(asst.getQuotation());
            entryVO.setExchangeRate(asst.getExchangeRate());
            entryVO.setMainBillEntity(main.getMainBillEntity());
            entryVO.setMainBillNumber(main.getMainBillNumber());
            entryVO.setMainBillId(main.getMainBillId());
            entryVO.setMainBillEntryId(main.getMainBillEntryId());
            entryVO.setMainBillEntrySeq(main.getMainBillEntrySeq());
            entryVO.setConBillEntity(main.getConBillEntity());
            entryVO.setConBillNumber(main.getConBillNumber());
            entryVO.setConBillRowNum(main.getConBillRowNum());
            entryVO.setConBillId(main.getConBillId());
            entryVO.setConBillEntryId(main.getConBillEntryId());
        }
        if (VerifyServiceHelper.sameDirection(result.getVerifyQty(), verifyTaxAmt)) {
            result.setVerifyAmt(verifyTaxAmt);
        } else {
            result.setVerifyAmt(verifyTaxAmt.negate());
        }
        if (result.getVrEntrys() != null && result.getVrEntrys().size() > 0) {
            resultList.add(result);
        }
        return resultList;
    }

    private static boolean isMatch(BillVerifyVO main, BillVerifyVO asst, SettleSchemeVO scheme, Map<Long, Long> botpMap, Map<Long, Long> asstTypeToMasterIdMap, Map<String, Boolean> billAsstMatchMap, String isAsstActMatch) {
        boolean isMatch = false;
        if (main.getBillType().equals(asst.getBillType()) && VerifyServiceHelper.sameDirection(main.getEntryUnSettleQty(), asst.getEntryUnSettleQty())) {
            return false;
        }
        if (!main.getBillType().equals(asst.getBillType()) && !VerifyServiceHelper.sameDirection(main.getEntryUnSettleQty(), asst.getEntryUnSettleQty())) {
            return false;
        }
        if (scheme.isOnlyByBotp()) {
            long entryId = main.getEntryId();
            if (main.isPresent() && !asst.isPresent() || !main.isPresent() && asst.isPresent()) {
                return false;
            }
            boolean isMatchForOrgIdAndAsstActId = VerifyServiceHelper.isMatchForOrgIdAndAsstActId(main, asst, asstTypeToMasterIdMap, billAsstMatchMap);
            if (isMatchForOrgIdAndAsstActId) {
                if (entryId == asst.getEntrySouBillId()) {
                    isMatch = true;
                }
                if (!botpMap.isEmpty() && botpMap.containsKey(asst.getEntryId()) && botpMap.get(asst.getEntryId()) == entryId) {
                    isMatch = true;
                }
            }
        } else if (scheme.isOnlyByCoreBill()) {
            if (!ObjectUtils.isEmpty((Object)main.getEntryCoreBillNum()) && !main.getEntryCoreBillseq().equals("0") && main.getEntryCoreBillNum().equals(asst.getEntryCoreBillNum()) && main.getEntryCoreBillseq().equals(asst.getEntryCoreBillseq())) {
                boolean isMatchForOrgIdAndAsstActId = VerifyServiceHelper.isMatchForOrgIdAndAsstActId(main, asst, asstTypeToMasterIdMap, billAsstMatchMap);
                logger.info("\u6838\u5fc3\u5355\u636e\u53f7\u5339\u914d\u7ec4\u7ec7\u548c\u5f80\u6765\u6237\u5339\u914d\u7ed3\u679c\uff1a" + isMatchForOrgIdAndAsstActId);
                boolean isMaterialInfoMatch = VerifyServiceHelper.isMaterialInfoMatch(main, asst, isAsstActMatch);
                logger.info("\u6838\u5fc3\u5355\u636e\u53f7\u5339\u914d\u7269\u6599\u4fe1\u606f\u5339\u914d\u7ed3\u679c\uff1a" + isMaterialInfoMatch);
                isMatch = main.getEntryMaterialId() == asst.getEntryMaterialId() && (main.isPresent() && asst.isPresent() || !main.isPresent() && !asst.isPresent()) && isMatchForOrgIdAndAsstActId && isMaterialInfoMatch;
            }
        } else if (scheme.isManual() && main.getEntryMaterialId() == asst.getEntryMaterialId() && (main.isPresent() && asst.isPresent() || !main.isPresent() && !asst.isPresent())) {
            isMatch = true;
        }
        return isMatch;
    }

    private static boolean isMatchForOrgIdAndAsstActId(BillVerifyVO main, BillVerifyVO asst, Map<Long, Long> asstTypeToMasterIdMap, Map<String, Boolean> billAsstMatchMap) {
        boolean orgMatch;
        boolean bl = orgMatch = main.getOrgId() == asst.getOrgId();
        if (!orgMatch) {
            return false;
        }
        if (main.getAsstActId() == asst.getAsstActId()) {
            return true;
        }
        String key = main.getAsstActId() + "" + asst.getAsstActId();
        Boolean asstMatch = billAsstMatchMap.get(key);
        if (asstMatch == null) {
            asstMatch = (Boolean)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0001", (Object)Boolean.TRUE, (Object[])new Object[]{main, asst, asstTypeToMasterIdMap});
            billAsstMatchMap.put(key, asstMatch);
        }
        return orgMatch && asstMatch != false;
    }

    private static boolean isMaterialInfoMatch(BillVerifyVO main, BillVerifyVO asst, String isAsstActMatch) {
        boolean isMatch = true;
        if (isAsstActMatch == null || "true".equals(isAsstActMatch)) {
            isMatch = main.getEntryMaterialVersion() == asst.getEntryMaterialVersion();
            isMatch = isMatch && main.getEntryMaterialAuxProp().equals(asst.getEntryMaterialAuxProp());
            isMatch = isMatch && main.getEntryMaterialConfigNumber() == asst.getEntryMaterialConfigNumber();
            isMatch = isMatch && main.getEntryMaterialTrackNumber() == asst.getEntryMaterialTrackNumber();
        }
        return isMatch;
    }

    private static boolean isAllVerifyMatch(BillVerifyVO main, BillVerifyVO asst) {
        boolean isMatch = false;
        if (main.getBillType().equals(asst.getBillType()) && VerifyServiceHelper.sameDirection(main.getEntryUnSettleQty(), asst.getEntryUnSettleQty())) {
            return false;
        }
        if (!main.getBillType().equals(asst.getBillType()) && !VerifyServiceHelper.sameDirection(main.getEntryUnSettleQty(), asst.getEntryUnSettleQty())) {
            return false;
        }
        if (main.getEntryMaterialId() == asst.getEntryMaterialId() && (main.isPresent() && asst.isPresent() || !main.isPresent() && !asst.isPresent())) {
            isMatch = true;
        }
        return isMatch;
    }

    private static void buildVerifyRecord(BillVerifyVO main, List<BillVerifyVO> matchAsstList, SettleSchemeVO scheme, VerifyRecordVO result, String verifyType) {
        BigDecimal mainCurVerifyBaseQty = BigDecimal.ZERO;
        BigDecimal mainVerifyBaseQtyCV = BigDecimal.ZERO;
        BigDecimal asstCurVerifyBaseQty = BigDecimal.ZERO;
        BigDecimal asstCurVerifyQty = BigDecimal.ZERO;
        BigDecimal asstCurVerifyAmt = BigDecimal.ZERO;
        BigDecimal verifyTaxAmt = BigDecimal.ZERO;
        BigDecimal convertRate = main.getUnitCoefficient() == null ? BigDecimal.ONE : main.getUnitCoefficient();
        boolean isArfinSelf = false;
        boolean isSalout = false;
        BigDecimal mainEUnVerifyQty = main.getEntryUnSettleQty();
        BigDecimal mainQty = main.getEntryQty();
        BigDecimal mainBaseQty = main.getBaseUnitQty();
        for (BillVerifyVO asst : matchAsstList) {
            BigDecimal mainUnVerifyQty = main.getEntryUnSettleQty();
            BigDecimal mainUnVerifyBaseQty = mainQty.compareTo(mainUnVerifyQty) == 0 ? mainBaseQty : mainUnVerifyQty.multiply(convertRate);
            if (mainUnVerifyQty.compareTo(BigDecimal.ZERO) == 0) break;
            BigDecimal asstQty = asst.getEntryQty();
            BigDecimal asstUnVerifyQty = asst.getEntryUnSettleQty();
            if (asstUnVerifyQty.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal asstConvertRate = asst.getUnitCoefficient() == null ? BigDecimal.ONE : asst.getUnitCoefficient();
            BigDecimal asstUnVerifyBaseQty = asstQty.compareTo(asstUnVerifyQty) == 0 ? asst.getBaseUnitQty() : asstUnVerifyQty.multiply(asstConvertRate);
            asstCurVerifyBaseQty = main.getBillType().equals(asst.getBillType()) ? (mainUnVerifyBaseQty.abs().compareTo(asstUnVerifyBaseQty.abs()) >= 0 ? asstUnVerifyBaseQty : mainUnVerifyBaseQty.negate()) : (mainUnVerifyBaseQty.abs().compareTo(asstUnVerifyBaseQty.abs()) >= 0 ? asstUnVerifyBaseQty : mainUnVerifyBaseQty);
            asstCurVerifyQty = asstCurVerifyBaseQty.compareTo(asstUnVerifyBaseQty) == 0 ? asstUnVerifyQty : asstCurVerifyBaseQty.divide(asstConvertRate, 10, RoundingMode.HALF_UP);
            asstCurVerifyAmt = asst.getPrice().multiply(asstCurVerifyQty);
            BigDecimal tempMainVerifyBaseQty = BigDecimal.ZERO;
            if (mainUnVerifyQty.compareTo(BigDecimal.ZERO) > 0) {
                tempMainVerifyBaseQty = asstCurVerifyBaseQty.abs();
                mainVerifyBaseQtyCV = mainVerifyBaseQtyCV.add(tempMainVerifyBaseQty);
                mainCurVerifyBaseQty = mainCurVerifyBaseQty.add(UnitConvertHelper.getBaseunitqty((BigDecimal)tempMainVerifyBaseQty, (BigDecimal)BigDecimal.ONE, (DynamicObject)asst.getEntryBaseUnit()));
            } else {
                tempMainVerifyBaseQty = asstCurVerifyBaseQty.abs().negate();
                mainVerifyBaseQtyCV = mainVerifyBaseQtyCV.add(tempMainVerifyBaseQty);
                mainCurVerifyBaseQty = mainCurVerifyBaseQty.add(UnitConvertHelper.getBaseunitqty((BigDecimal)tempMainVerifyBaseQty, (BigDecimal)BigDecimal.ONE, (DynamicObject)asst.getEntryBaseUnit()));
            }
            VerifyRecordEntryVO entryVO = new VerifyRecordEntryVO();
            entryVO.setPrecision(asst.getPrecision());
            entryVO.setBasePrecision(asst.getBasePrecision());
            entryVO.setBillNum(asst.getBillNo());
            entryVO.setBillDate(asst.getBizdate());
            entryVO.setBillType(asst.getBillType());
            entryVO.setCurrencyId(asst.getCurrencyId());
            entryVO.setQty(asst.getEntryQty());
            entryVO.setVerifyBaseQty(UnitConvertHelper.getBaseunitqty((BigDecimal)asstCurVerifyBaseQty, (BigDecimal)BigDecimal.ONE, (DynamicObject)asst.getEntryBaseUnit()));
            entryVO.setVerifyQty(asstCurVerifyQty);
            entryVO.setPayableAmt(asst.getEntryPayableAmt());
            if (asstCurVerifyQty.compareTo(asstUnVerifyQty) == 0 && "im_saloutbill".equals(main.getBillType()) && "ar_revcfmbill".equals(asst.getBillType())) {
                entryVO.setSettleAmt(asst.getEntryUnSettleAmt());
            } else if (asstCurVerifyQty.compareTo(asstUnVerifyQty) == 0 && "ar_revcfmbill".equals(main.getBillType()) && "ar_revcfmbill".equals(asst.getBillType())) {
                entryVO.setSettleAmt(asst.getEntryUnSettleAmt());
                isArfinSelf = true;
            } else {
                BigDecimal tempVerifyAmt = asstCurVerifyAmt.setScale((int)asst.getPrecision(), RoundingMode.HALF_UP);
                entryVO.setSettleAmt(tempVerifyAmt);
                asst.setEntryUnSettleAmt(asst.getEntryUnSettleAmt().subtract(tempVerifyAmt));
            }
            if ("im_saloutbill".equals(main.getBillType()) && "im_saloutbill".equals(asst.getBillType())) {
                isSalout = true;
            }
            if (asst.getPriceTax() != null) {
                entryVO.setVerifyAmt(asst.getPriceTax().multiply(asstCurVerifyQty).setScale((int)asst.getPrecision(), RoundingMode.HALF_UP));
                verifyTaxAmt = verifyTaxAmt.add(entryVO.getVerifyAmt());
            }
            entryVO.setAsstActType(asst.getAsstActType());
            entryVO.setAsstActId(asst.getAsstActId());
            entryVO.setMaterielId(Long.valueOf(asst.getEntryMaterialId()));
            entryVO.setMeasureunitId(Long.valueOf(asst.getEntryMeasureUnitId()));
            entryVO.setBaseunitId(Long.valueOf(asst.getEntryBaseUnitId()));
            entryVO.setBillId(asst.getId());
            entryVO.setRevcfmBillId(asst.getId());
            entryVO.setBillEntryId(asst.getEntryId());
            entryVO.setRevcfmBillEntryId(asst.getEntryId());
            entryVO.setBaseCurrencyId(asst.getBaseCurrencyId());
            entryVO.setQuotation(asst.getQuotation());
            entryVO.setExchangeRate(asst.getExchangeRate());
            entryVO.setMainBillEntity(main.getMainBillEntity());
            entryVO.setMainBillNumber(main.getMainBillNumber());
            entryVO.setMainBillId(main.getMainBillId());
            entryVO.setMainBillEntryId(main.getMainBillEntryId());
            entryVO.setMainBillEntrySeq(main.getMainBillEntrySeq());
            entryVO.setConBillEntity(main.getConBillEntity());
            entryVO.setConBillNumber(main.getConBillNumber());
            entryVO.setConBillRowNum(main.getConBillRowNum());
            entryVO.setConBillId(main.getConBillId());
            entryVO.setConBillEntryId(main.getConBillEntryId());
            result.getVrEntrys().add(entryVO);
            asst.setEntryUnSettleQty(asst.getEntryUnSettleQty().subtract(asstCurVerifyQty));
            main.setEntryUnSettleQty(main.getEntryUnSettleQty().subtract(tempMainVerifyBaseQty.divide(convertRate, 10, RoundingMode.HALF_UP)));
            logger.info(main.getBillNo() + "/" + main.getEntryId() + "-tempMainVerifyBaseQty:" + tempMainVerifyBaseQty + ",main unverifyqty: -" + main.getEntryUnSettleQty());
        }
        result.setPrecision(main.getPrecision());
        result.setBasePrecision(main.getBasePrecision());
        result.setSettleDate(new Date());
        result.setCreatorId(RequestContext.get().getCurrUserId());
        result.setOrgId(main.getOrgId());
        result.setCurrencyId(main.getCurrencyId());
        result.setMaterialId(main.getEntryMaterialId());
        result.setMeasureunitId(Long.valueOf(main.getEntryMeasureUnitId()));
        result.setBaseunitId(Long.valueOf(main.getEntryBaseUnitId()));
        result.setBillNo(main.getBillNo());
        result.setBillDate(main.getBizdate());
        result.setBillType(main.getBillType());
        result.setQty(main.getEntryQty());
        result.setVerifyBaseQty(mainCurVerifyBaseQty);
        BigDecimal mainVeiryQty = mainBaseQty.compareTo(mainCurVerifyBaseQty) == 0 ? mainQty : UnitConvertHelper.getUnitQty((BigDecimal)mainVerifyBaseQtyCV, (BigDecimal)convertRate, (DynamicObject)main.getEntryMeasureUnit());
        result.setVerifyQty(mainVeiryQty);
        result.setMainPayableAmt(main.getEntryPayableAmt());
        if (isArfinSelf && mainVeiryQty.compareTo(mainEUnVerifyQty) == 0 || isSalout && mainVeiryQty.compareTo(main.getEntryQty()) == 0) {
            result.setTotalSettleAmt(main.getEntryUnSettleAmt());
        } else {
            result.setTotalSettleAmt(main.getPrice().multiply(mainVeiryQty).setScale((int)main.getPrecision(), RoundingMode.HALF_UP));
        }
        main.setEntryUnSettleAmt(main.getEntryUnSettleAmt().subtract(result.getTotalSettleAmt()));
        if (VerifyServiceHelper.sameDirection(mainVeiryQty, verifyTaxAmt)) {
            result.setVerifyAmt(verifyTaxAmt);
        } else {
            result.setVerifyAmt(verifyTaxAmt.negate());
        }
        result.setAsstActType(main.getAsstActType());
        result.setAsstActId(main.getAsstActId());
        result.setMainBillId(main.getId());
        result.setMainBillEntryId(main.getEntryId());
        result.setBaseCurrencyId(main.getBaseCurrencyId());
        result.setQuotation(main.getQuotation());
        result.setExchangeRate(main.getExchangeRate());
        result.setSettleType(verifyType);
    }

    public static VerifyRecordVO converDyn2VO(DynamicObject result) {
        VerifyRecordVO recordVO = new VerifyRecordVO();
        recordVO.setOrgId(result.getLong("org.id"));
        recordVO.setBillType(result.getString("billtype"));
        recordVO.setMainBillId(result.getLong("billid"));
        recordVO.setMainBillEntryId(result.getLong("billentryid"));
        recordVO.setQty(result.getBigDecimal("qty"));
        recordVO.setMeasureunitId(Long.valueOf(result.getLong("measureunit.id")));
        recordVO.setVerifyQty(result.getBigDecimal("verifyqty"));
        recordVO.setVerifyBaseQty(result.getBigDecimal("verifybaseqty"));
        recordVO.setMainPayableAmt(result.getBigDecimal("payableamount"));
        recordVO.setTotalSettleAmt(result.getBigDecimal("verifyamount"));
        recordVO.setVerifyAmt(result.getBigDecimal("verifytaxamount"));
        recordVO.setSettleType(result.getString("verifytype"));
        recordVO.setSettleRela(result.getString("verifyrelation"));
        DynamicObjectCollection collection = result.getDynamicObjectCollection("entry");
        for (DynamicObject obj : collection) {
            VerifyRecordEntryVO entryVO = new VerifyRecordEntryVO();
            entryVO.setBillType(obj.getString("e_billtype"));
            entryVO.setBillId(obj.getLong("e_billid"));
            entryVO.setRevcfmBillId(obj.getLong("e_billid"));
            entryVO.setBillEntryId(obj.getLong("e_billentryid"));
            entryVO.setRevcfmBillEntryId(obj.getLong("e_billentryid"));
            entryVO.setQty(obj.getBigDecimal("e_qty"));
            entryVO.setMeasureunitId(Long.valueOf(obj.getLong("e_measureunit.id")));
            entryVO.setVerifyQty(obj.getBigDecimal("e_verifyqty"));
            entryVO.setVerifyBaseQty(obj.getBigDecimal("e_verifybaseqty"));
            entryVO.setPayableAmt(obj.getBigDecimal("e_payableamount"));
            entryVO.setSettleAmt(obj.getBigDecimal("e_verifyamount"));
            entryVO.setVerifyAmt(obj.getBigDecimal("e_verifytaxamount"));
            recordVO.getVrEntrys().add(entryVO);
        }
        return recordVO;
    }

    public static DynamicObject[] converVO2Dyn(List<VerifyRecordVO> resultList) {
        long start = System.currentTimeMillis();
        DynamicObject[] resultArr = new DynamicObject[resultList.size()];
        DynamicObjectType dt = null;
        HashMap<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>(8);
        int size = resultList.size();
        for (int i = 0; i < size; ++i) {
            VerifyRecordVO vo = resultList.get(i);
            DynamicObject org = (DynamicObject)orgMap.get(vo.getOrgId());
            if (org == null) {
                org = BusinessDataServiceHelper.loadSingleFromCache((Object)vo.getOrgId(), (String)"bos_org");
                orgMap.put(vo.getOrgId(), org);
            }
            DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)"ar_verifyrecord");
            result.set("billno", (Object)vo.getBillNo());
            result.set("billstatus", (Object)"C");
            result.set("billtype", (Object)vo.getBillType());
            result.set("billdate", (Object)vo.getBillDate());
            result.set("material", (Object)vo.getMaterialId());
            result.set("measureunit", (Object)vo.getMeasureunitId());
            result.set("baseunit", (Object)vo.getBaseunitId());
            result.set("qty", (Object)vo.getQty());
            result.set("verifyqty", (Object)vo.getVerifyQty());
            result.set("verifybaseqty", (Object)vo.getVerifyBaseQty());
            result.set("asstacttype", (Object)vo.getAsstActType());
            result.set("asstact", (Object)vo.getAsstActId());
            result.set("org", (Object)org);
            result.set("currency", (Object)vo.getCurrencyId());
            result.set("payableamount", (Object)vo.getMainPayableAmt());
            result.set("verifyseq", (Object)vo.getSettleSeq());
            result.set("createtime", (Object)vo.getSettleDate());
            result.set("creator", (Object)vo.getCreatorId());
            result.set("verifytype", (Object)vo.getSettleType());
            result.set("verifyrelation", (Object)vo.getSettleRela());
            result.set("billid", (Object)vo.getMainBillId());
            result.set("billentryid", (Object)vo.getMainBillEntryId());
            String mainquotation = vo.getQuotation();
            BigDecimal mainexchangeRate = vo.getExchangeRate();
            int mainbasePrecision = vo.getBasePrecision();
            BigDecimal totalSettleAmt = vo.getTotalSettleAmt();
            BigDecimal verifyAmt = vo.getVerifyAmt();
            result.set("basecurrency", (Object)vo.getBaseCurrencyId());
            result.set("exchangerate", (Object)mainexchangeRate);
            result.set("verifyamount", (Object)totalSettleAmt);
            result.set("verifytaxamount", (Object)verifyAmt);
            if (vo.getExchangeRate() != null) {
                BigDecimal localverifyamt = QuotationHelper.getLocamtByQuotation((String)mainquotation, (BigDecimal)totalSettleAmt, (BigDecimal)mainexchangeRate, (int)mainbasePrecision);
                result.set("localverifyamt", (Object)localverifyamt);
            }
            if (dt == null) {
                EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)result.getDataEntityType().getName()).findProperty("entry");
                dt = prop.getDynamicCollectionItemPropertyType();
            }
            List entrys = vo.getVrEntrys();
            for (VerifyRecordEntryVO entry : entrys) {
                DynamicObject resultEntry = new DynamicObject(dt);
                resultEntry.set("e_billno", (Object)entry.getBillNum());
                resultEntry.set("e_billtype", (Object)entry.getBillType());
                resultEntry.set("e_billdate", (Object)entry.getBillDate());
                resultEntry.set("e_asstacttype", (Object)entry.getAsstActType());
                resultEntry.set("e_asstact", (Object)entry.getAsstActId());
                resultEntry.set("e_description", (Object)entry.getDescription());
                resultEntry.set("e_currency", (Object)entry.getCurrencyId());
                resultEntry.set("e_material", (Object)entry.getMaterielId());
                resultEntry.set("e_measureunit", (Object)entry.getMeasureunitId());
                resultEntry.set("e_baseunit", (Object)entry.getBaseunitId());
                resultEntry.set("e_qty", (Object)entry.getQty());
                resultEntry.set("e_payableamount", (Object)entry.getPayableAmt());
                resultEntry.set("e_verifyqty", (Object)entry.getVerifyQty());
                resultEntry.set("e_verifybaseqty", (Object)entry.getVerifyBaseQty());
                resultEntry.set("e_billid", (Object)entry.getBillId());
                resultEntry.set("e_billentryid", (Object)entry.getBillEntryId());
                resultEntry.set("e_basecurrency", (Object)entry.getBaseCurrencyId());
                String quotation = entry.getQuotation();
                BigDecimal exchangeRate = entry.getExchangeRate();
                int basePrecision = entry.getBasePrecision();
                BigDecimal settleAmt = entry.getSettleAmt();
                resultEntry.set("e_exchangerate", (Object)exchangeRate);
                resultEntry.set("e_verifyamount", (Object)settleAmt);
                resultEntry.set("e_verifytaxamount", (Object)entry.getVerifyAmt());
                if (entry.getExchangeRate() != null) {
                    BigDecimal eLocalverifyamt = QuotationHelper.getLocamtByQuotation((String)quotation, (BigDecimal)settleAmt, (BigDecimal)exchangeRate, (int)basePrecision);
                    resultEntry.set("e_localverifyamt", (Object)eLocalverifyamt);
                }
                result.getDynamicObjectCollection("entry").add((Object)resultEntry);
            }
            resultArr[i] = result;
        }
        long end = System.currentTimeMillis();
        logger.info("converVO2Dyn spend " + (end - start));
        return resultArr;
    }

    public static Map<String, List<DynamicObject>> classfyByRelation(DynamicObject[] entities) {
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(entities.length);
        for (DynamicObject entity : entities) {
            Set keySet = map.keySet();
            String verifyRelation = entity.getString("verifyrelation");
            List objList = null;
            objList = keySet.contains(verifyRelation) ? (List)map.get(verifyRelation) : new ArrayList();
            objList.add(entity);
            map.put(verifyRelation, objList);
        }
        return map;
    }

    public static String getBillVerifyStatus(DynamicObject bill) {
        if (bill == null) {
            return null;
        }
        DynamicObjectCollection entryColl = bill.getDynamicObjectCollection("entry");
        boolean verified = true;
        for (DynamicObject entry : entryColl) {
            BigDecimal unverify = entry.getBigDecimal("e_unverifyqty");
            if (unverify.compareTo(BigDecimal.ZERO) == 0) continue;
            verified = false;
            break;
        }
        if (verified) {
            return ARVerifyStatusEnum.VERIFIED.getValue();
        }
        boolean unVerify = true;
        for (DynamicObject entry : entryColl) {
            BigDecimal unverify = entry.getBigDecimal("e_verifiedqty");
            if (unverify.compareTo(BigDecimal.ZERO) == 0) continue;
            unVerify = false;
            break;
        }
        if (unVerify) {
            return ARVerifyStatusEnum.UNVERIFY.getValue();
        }
        return ARVerifyStatusEnum.PARTVERIFY.getValue();
    }

    @Deprecated
    public static void invokeDisposeScmc(List<Map<String, Object>> disposeList, boolean isSettle) {
        if (disposeList != null && disposeList.size() > 0) {
            VerifyLogHelper.logInvokeScmcParam(disposeList, (boolean)isSettle);
            try (TXHandle tx = TX.requiresNew((String)"verifyinvokeScmc");){
                try {
                    if (isSettle) {
                        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvService", (String)"ARVerify", (Object[])new Object[]{disposeList});
                    } else {
                        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvService", (String)"ARUnVerify", (Object[])new Object[]{disposeList});
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    public static boolean sameDirection(BigDecimal a, BigDecimal b) {
        return a.compareTo(BigDecimal.ZERO) * b.compareTo(BigDecimal.ZERO) >= 0;
    }

    @Deprecated
    public static Map<Long, BigDecimal> getBaseUnitActualCost(List<Long> verifyRecordIds) {
        HashMap<Long, BigDecimal> baseUnitActualCost = new HashMap<Long, BigDecimal>(16);
        QFilter writeOffIdf = new QFilter("entry.writeoffid", "in", verifyRecordIds);
        DataSet costDs = QueryServiceHelper.queryDataSet((String)VerifyServiceHelper.class.getName(), (String)"cal_costrecord", (String)"bizbillid,entry.writeoffid as writeoffid,entry.unitactualcost as unitactualcost", (QFilter[])new QFilter[]{writeOffIdf}, (String)"bizbillid,costaccount.ismainaccount desc");
        for (Row row : costDs) {
            baseUnitActualCost.putIfAbsent(row.getLong("writeoffid"), row.getBigDecimal("unitactualcost"));
        }
        return baseUnitActualCost;
    }

    public static Map<Long, BigDecimal> getBaseUnitActualCost(List<Long> verifyRecordIds, List<Long> mainBillIds) {
        HashMap<Long, BigDecimal> baseUnitActualCost = new HashMap<Long, BigDecimal>(16);
        QFilter writeOffIdf = new QFilter("entry.writeoffid", "in", verifyRecordIds);
        QFilter bizbillIdf = new QFilter("bizbillid", "in", mainBillIds);
        DataSet costDs = QueryServiceHelper.queryDataSet((String)VerifyServiceHelper.class.getName(), (String)"cal_costrecord", (String)"bizbillid,entry.writeoffid as writeoffid,entry.unitactualcost as unitactualcost", (QFilter[])new QFilter[]{writeOffIdf, bizbillIdf}, null);
        for (Row row : costDs) {
            baseUnitActualCost.putIfAbsent(row.getLong("writeoffid"), row.getBigDecimal("unitactualcost"));
        }
        return baseUnitActualCost;
    }

    public static Map<Long, BigDecimal> getBaseUnitActualCost(List<Long> verifyRecordIds, List<Long> mainBillIds, Date startDate, Date endDate) {
        HashMap<Long, BigDecimal> baseUnitActualCost = new HashMap<Long, BigDecimal>(16);
        QFilter filter = new QFilter("entry.writeoffid", "in", verifyRecordIds);
        filter.and(new QFilter("entry.writeoffid", "in", verifyRecordIds));
        filter.and(new QFilter("bizbillid", "in", mainBillIds));
        if (startDate != null && endDate != null) {
            filter.and(new QFilter("bookdate", ">=", (Object)startDate)).and(new QFilter("bookdate", "<=", (Object)endDate));
        }
        DataSet costDs = QueryServiceHelper.queryDataSet((String)VerifyServiceHelper.class.getName(), (String)"cal_costrecord", (String)"bizbillid,entry.writeoffid as writeoffid,entry.unitactualcost as unitactualcost", (QFilter[])new QFilter[]{filter}, null);
        for (Row row : costDs) {
            baseUnitActualCost.putIfAbsent(row.getLong("writeoffid"), row.getBigDecimal("unitactualcost"));
        }
        return baseUnitActualCost;
    }

    public static Map<Long, BigDecimal> getBaseUnitActualCostByBatch(Map<Long, List<Long>> mainId2VrIdMap, Map<Long, Date> mainBillBizDate) {
        HashMap<Long, BigDecimal> baseUnitActualCost = new HashMap<Long, BigDecimal>(16);
        int queryEntryCount = 10000;
        String queryEntryCountConfig = StdConfig.get((String)"queryCostEntryCount");
        if (!ObjectUtils.isEmpty((Object)queryEntryCountConfig)) {
            queryEntryCount = Integer.parseInt(queryEntryCountConfig);
        }
        ArrayList<Map.Entry<Long, Date>> list = new ArrayList<Map.Entry<Long, Date>>(mainBillBizDate.entrySet());
        list.sort(Map.Entry.comparingByValue());
        ArrayList<Long> batchMainBillIds = new ArrayList<Long>(16);
        ArrayList<Long> batchVerifyRecordIds = new ArrayList<Long>(16);
        Date startDate = null;
        Date lastDate = null;
        for (Map.Entry entry : list) {
            Long mainBillId = (Long)entry.getKey();
            List<Long> verifyRecordIds = mainId2VrIdMap.get(mainBillId);
            if (verifyRecordIds != null && verifyRecordIds.size() != 0) {
                batchMainBillIds.add(mainBillId);
                batchVerifyRecordIds.addAll(verifyRecordIds);
            }
            if (batchMainBillIds.size() == 1) {
                startDate = (Date)entry.getValue();
            }
            lastDate = (Date)entry.getValue();
            if (batchMainBillIds.size() != queryEntryCount) continue;
            Map<Long, BigDecimal> batchUnitActualCost = VerifyServiceHelper.getBaseUnitActualCost(batchVerifyRecordIds, batchMainBillIds, startDate, lastDate);
            for (Map.Entry<Long, BigDecimal> entrySet : batchUnitActualCost.entrySet()) {
                baseUnitActualCost.putIfAbsent(entrySet.getKey(), entrySet.getValue());
            }
            batchMainBillIds.clear();
            batchVerifyRecordIds.clear();
        }
        if (batchMainBillIds.size() > 0) {
            Map<Long, BigDecimal> batchUnitActualCost = VerifyServiceHelper.getBaseUnitActualCost(batchVerifyRecordIds, batchMainBillIds, startDate, lastDate);
            for (Map.Entry<Long, BigDecimal> entrySet : batchUnitActualCost.entrySet()) {
                baseUnitActualCost.putIfAbsent(entrySet.getKey(), entrySet.getValue());
            }
        }
        return baseUnitActualCost;
    }

    public static Map<Long, Map<Long, BigDecimal>> getRevcfmInventoryCost(List<Long> verifyRecordIds) {
        HashMap<Long, Map<Long, BigDecimal>> costMap = new HashMap<Long, Map<Long, BigDecimal>>(6);
        DynamicObject[] verifyRecordList = BusinessDataServiceHelper.load((String)"cal_salwfrecord", (String)"id,producttype,entry.e_billid,entry.e_billentryid,entry.e_inventorycost", (QFilter[])new QFilter[]{new QFilter("id", "in", verifyRecordIds), new QFilter("producttype", "!=", (Object)"kitchild")});
        ArrayList entryEntityList = new ArrayList(100);
        for (DynamicObject entity : verifyRecordList) {
            DynamicObjectCollection entryList = entity.getDynamicObjectCollection("entry");
            entryEntityList.addAll(entryList);
        }
        for (DynamicObject entry : entryEntityList) {
            BigDecimal rowCost;
            Long billId = entry.getLong("e_billid");
            Long billEntryId = entry.getLong("e_billentryid");
            BigDecimal inventoryCost = entry.getBigDecimal("e_inventorycost");
            HashMap<Long, BigDecimal> rowDetail = (HashMap<Long, BigDecimal>)costMap.get(billId);
            if (EmptyUtils.isEmpty((Object)rowDetail)) {
                rowDetail = new HashMap<Long, BigDecimal>();
            }
            if ((rowCost = (BigDecimal)rowDetail.get(billEntryId)) != null) {
                inventoryCost = rowCost.add(inventoryCost);
            }
            rowDetail.put(billEntryId, inventoryCost);
            costMap.put(billId, rowDetail);
        }
        return costMap;
    }

    @Deprecated
    public static Map<Long, Map<String, BigDecimal>> getCostRecordActualCost(List<Long> verifyRecordIds) {
        HashMap<Long, Map<String, BigDecimal>> baseUnitActualCost = new HashMap<Long, Map<String, BigDecimal>>(16);
        QFilter writeOffIdf = new QFilter("entry.writeoffid", "in", verifyRecordIds);
        QFilter isMainAccountf = new QFilter("costaccount.ismainaccount", "=", (Object)Boolean.TRUE);
        DataSet costDs = QueryServiceHelper.queryDataSet((String)VerifyServiceHelper.class.getName(), (String)"cal_costrecord", (String)"bizbillid,entry.writeoffid as writeoffid,entry.unitactualcost as unitactualcost,entry.actualcost as actualcost", (QFilter[])new QFilter[]{writeOffIdf, isMainAccountf}, null);
        for (Row row : costDs) {
            BigDecimal unitActualCost = row.getBigDecimal("unitactualcost");
            BigDecimal actualCost = row.getBigDecimal("actualcost");
            if (BigDecimal.ZERO.compareTo(unitActualCost) == 0 || BigDecimal.ZERO.compareTo(actualCost) == 0) continue;
            HashMap<String, BigDecimal> rowCostRecordCostMap = new HashMap<String, BigDecimal>(16);
            rowCostRecordCostMap.put("baseUnitActualCost", unitActualCost);
            BigDecimal actualCostTotal = rowCostRecordCostMap.getOrDefault("actualCost", BigDecimal.ZERO);
            rowCostRecordCostMap.put("actualCost", actualCostTotal.add(actualCost));
            baseUnitActualCost.put(row.getLong("writeoffid"), rowCostRecordCostMap);
        }
        return baseUnitActualCost;
    }

    public static Map<Long, Map<String, BigDecimal>> getCostRecordActualCost(List<Long> verifyRecordIds, List<Long> mainBillIds) {
        HashMap<Long, Map<String, BigDecimal>> baseUnitActualCost = new HashMap<Long, Map<String, BigDecimal>>(16);
        QFilter writeOffIdf = new QFilter("entry.writeoffid", "in", verifyRecordIds);
        QFilter bizbillIdf = new QFilter("bizbillid", "in", mainBillIds);
        QFilter isMainAccountf = new QFilter("costaccount.ismainaccount", "=", (Object)Boolean.TRUE);
        DataSet costDs = QueryServiceHelper.queryDataSet((String)VerifyServiceHelper.class.getName(), (String)"cal_costrecord", (String)"bizbillid,entry.writeoffid as writeoffid,entry.unitactualcost as unitactualcost,entry.actualcost as actualcost", (QFilter[])new QFilter[]{bizbillIdf, writeOffIdf, isMainAccountf}, null);
        for (Row row : costDs) {
            BigDecimal unitActualCost = row.getBigDecimal("unitactualcost");
            BigDecimal actualCost = row.getBigDecimal("actualcost");
            HashMap<String, BigDecimal> rowCostRecordCostMap = new HashMap<String, BigDecimal>(16);
            rowCostRecordCostMap.put("baseUnitActualCost", unitActualCost);
            BigDecimal actualCostTotal = rowCostRecordCostMap.getOrDefault("actualCost", BigDecimal.ZERO);
            rowCostRecordCostMap.put("actualCost", actualCostTotal.add(actualCost));
            baseUnitActualCost.put(row.getLong("writeoffid"), rowCostRecordCostMap);
        }
        return baseUnitActualCost;
    }

    public static Map<Long, Boolean> revInventoryCostResult(List<Long> revcfmIds) {
        QFilter filter = new QFilter("entry.e_billid", "in", revcfmIds);
        filter.and(new QFilter("entry.e_billtype", "=", (Object)"ar_revcfmbill"));
        filter.and(new QFilter("billtype", "=", (Object)"im_saloutbill"));
        filter.and(new QFilter("producttype", "!=", (Object)"kitparent"));
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter((String)"ar_revcfmbill", (Object[])revcfmIds.toArray(), (boolean)true);
        filter.and(commonFilter);
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)"cal_salwfrecord", (String)"id as verifyId,billdate,entry.e_billid as revcfmId,billid as mainBillId", (QFilter[])new QFilter[]{filter});
        HashMap<Long, HashSet<Long>> revcfmToVerifyMap = new HashMap<Long, HashSet<Long>>(16);
        HashMap<Long, List<Long>> mainId2VrIdMap = new HashMap<Long, List<Long>>(16);
        HashMap<Long, Date> mainBizDateMap = new HashMap<Long, Date>(16);
        for (DynamicObject entity : dataList) {
            long verifyId = entity.getLong("verifyId");
            long revcfmId = entity.getLong("revcfmId");
            Long mainBillId = entity.getLong("mainBillId");
            mainBizDateMap.put(mainBillId, entity.getDate("billdate"));
            ArrayList<Long> verifyRds = (ArrayList<Long>)mainId2VrIdMap.get(mainBillId);
            if (verifyRds == null) {
                verifyRds = new ArrayList<Long>(16);
                verifyRds.add(verifyId);
                mainId2VrIdMap.put(mainBillId, verifyRds);
            } else {
                verifyRds.add(verifyId);
            }
            HashSet<Long> verifyIdList = (HashSet<Long>)revcfmToVerifyMap.get(revcfmId);
            if (EmptyUtils.isEmpty((Object)verifyIdList)) {
                verifyIdList = new HashSet<Long>(16);
            }
            verifyIdList.add(verifyId);
            revcfmToVerifyMap.put(revcfmId, verifyIdList);
        }
        Map<Long, BigDecimal> verifyBaseUnitCost = VerifyServiceHelper.getBaseUnitActualCostByBatch(mainId2VrIdMap, mainBizDateMap);
        HashMap<Long, Boolean> costResult = new HashMap<Long, Boolean>(16);
        for (Long revcfmId : revcfmIds) {
            Set verifyIds = (Set)revcfmToVerifyMap.get(revcfmId);
            boolean containsCost = VerifyServiceHelper.containsVerifyCost(verifyIds, verifyBaseUnitCost);
            costResult.put(revcfmId, containsCost);
        }
        return costResult;
    }

    public static Boolean containsVerifyCost(Set<Long> verifyIds, Map<Long, BigDecimal> verifyCostMap) {
        if (EmptyUtils.isEmpty(verifyIds)) {
            return false;
        }
        HashSet<Long> hadCost = new HashSet<Long>(16);
        for (Long verifyId : verifyIds) {
            BigDecimal inventoryCost = verifyCostMap.get(verifyId);
            if (inventoryCost == null) continue;
            hadCost.add(verifyId);
        }
        if (hadCost.size() == 0) {
            return false;
        }
        if (hadCost.size() < verifyIds.size()) {
            return false;
        }
        return true;
    }

    public static Set<String> getExcludeBillTypeNum() {
        HashSet<String> billTypeSet = new HashSet<String>(8);
        billTypeSet.add("ar_revcfmbill_sale_BT_S");
        billTypeSet.add("ar_revcfmbill_other_BT_S");
        billTypeSet.add("ar_revcfmbill_borrowar_BT_S");
        return billTypeSet;
    }

    public static Set<String> getVerifyBillTypeNum() {
        HashSet<String> billTypeSet = new HashSet<String>(8);
        billTypeSet.add("ar_revcfmbill_standard_BT_S");
        billTypeSet.add("ar_revcfmbill_service_BT_S");
        String billTypes = StdConfig.get((String)"verify.arbilltype");
        if (StringUtils.isNotEmpty((String)billTypes)) {
            String[] billTypeArr;
            for (String billType : billTypeArr = billTypes.split(",")) {
                billTypeSet.add(billType);
            }
        }
        billTypeSet.remove("ar_revcfmbill_sale_BT_S");
        billTypeSet.remove("ar_revcfmbill_other_BT_S");
        billTypeSet.remove("ar_revcfmbill_borrowar_BT_S ");
        return billTypeSet;
    }

    public static Set<Long> getSalBillIdsByCoreBill(DynamicObject[] arBills) {
        HashSet<String> coreBillNoSet = new HashSet<String>(arBills.length);
        HashSet<Integer> coreBillEntrySeqSet = new HashSet<Integer>(arBills.length);
        HashMap coreBillTypeMap = new HashMap(8);
        for (DynamicObject obj : arBills) {
            DynamicObjectCollection entries = obj.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                String coreBillType;
                String coreBillno = entry.getString("e_corebillno");
                if (ObjectUtils.isEmpty((Object)coreBillno)) continue;
                coreBillNoSet.add(coreBillno);
                int coreSeq = entry.getInt("e_corebillentryseq");
                if (coreSeq != 0) {
                    coreBillEntrySeqSet.add(coreSeq);
                }
                if (ObjectUtils.isEmpty((Object)(coreBillType = entry.getString("e_corebilltype")))) continue;
                Set coreBillNoTmpSet = (Set)coreBillTypeMap.get(coreBillType);
                if (coreBillNoTmpSet != null) {
                    coreBillNoTmpSet.add(coreBillno);
                    continue;
                }
                HashSet<String> tmpSet = new HashSet<String>(8);
                tmpSet.add(coreBillno);
                coreBillTypeMap.put(coreBillType, tmpSet);
            }
        }
        HashSet<Long> salBillIds = new HashSet<Long>(8);
        if (coreBillNoSet.size() > 0 && coreBillEntrySeqSet.size() > 0) {
            QFilter filter = new QFilter("billentry.mainbillnumber", "in", coreBillNoSet);
            filter.and("billentry.mainbillentryseq", "in", coreBillEntrySeqSet);
            filter.and("billstatus", "=", (Object)"C");
            filter.and("billentry.logisticsbill", "=", (Object)Boolean.FALSE);
            filter.and("billentry.unverifyqty", "<>", (Object)BigDecimal.ZERO);
            ArrayList<String> invBillnos = new ArrayList<String>(2);
            invBillnos.add("211");
            invBillnos.add("2111");
            filter.and("invscheme.number", "not in", invBillnos);
            QFilter isnotVmiDomianFilter = new QFilter("biztype.domain", "<>", (Object)"6");
            QFilter virtualBillFilter = new QFilter("isvirtualbill", "=", (Object)Boolean.TRUE);
            QFilter isnotvirtualBillFilter = new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE);
            QFilter vmiFilter = isnotVmiDomianFilter.and(isnotvirtualBillFilter);
            filter.and(vmiFilter.or(virtualBillFilter));
            QFilter commonFilter = ArApXDBHelper.getSalOutBillXDBFilter(coreBillTypeMap);
            filter.and(commonFilter);
            List pks = QueryServiceHelper.queryPrimaryKeys((String)"im_saloutbill", (QFilter[])new QFilter[]{filter}, (String)"biztime,billno", (int)-1);
            salBillIds = new HashSet(pks);
        }
        return salBillIds;
    }

    public static void invokeDisposeScmc(List<VerifyRecordVO> voList, List<Map<String, Object>> disposeList, SettleSchemeVO scheme) {
        if (disposeList != null && disposeList.size() > 0) {
            boolean isSettle = scheme.isSettle();
            VerifyLogHelper.logInvokeScmcParam(disposeList, (boolean)isSettle);
            if (ECServiceHelper.isVerifyImOpened()) {
                logger.info("arinvokeDisposeScmc-consistency-true");
                long uniqueKey = DB.genGlobalLongId();
                for (Map<String, Object> dispose : disposeList) {
                    dispose.put("uniquekey", uniqueKey);
                }
                CommonParam ecParam = new CommonParam();
                ecParam.put((Object)"disposeList", disposeList);
                Set mainIdList = voList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
                HashSet asstIdList = new HashSet(voList.size());
                HashSet reccfmBillIdList = new HashSet(voList.size());
                for (VerifyRecordVO vr : voList) {
                    List vrEntrys = vr.getVrEntrys();
                    Set asstIds = vrEntrys.stream().map(SettleRecordEntryVO::getBillId).collect(Collectors.toSet());
                    Set reccfmBillIds = vrEntrys.stream().map(VerifyRecordEntryVO::getRevcfmBillId).collect(Collectors.toSet());
                    asstIdList.addAll(asstIds);
                    reccfmBillIdList.addAll(reccfmBillIds);
                }
                ArrayList businessInfo = new ArrayList(voList.size());
                businessInfo.addAll(mainIdList);
                businessInfo.addAll(asstIdList);
                businessInfo.addAll(reccfmBillIdList);
                if (isSettle) {
                    List recordPks = scheme.getRecordPks();
                    businessInfo.addAll(recordPks);
                    ECServiceHelper.beginAndRegisterWithBusInfo((String)"ar_verify", (String)"ar_verify_wbsal", (String)"fi", (String)"ar", (String)"ArVerifyWBSalEC", (Param)ecParam, (String)"", businessInfo);
                } else {
                    ECServiceHelper.beginAndRegister((String)"ar_unverify", (String)"ar_unverify_wbsal", (String)"fi", (String)"ar", (String)"ArUnVerifyWBSalEC", (Param)ecParam, (String)"");
                }
            } else {
                logger.info("arinvokeDisposeScmc-consistency-false");
                try (TXHandle tx = TX.requiresNew((String)"verifyinvokeScmc");){
                    try {
                        if (isSettle) {
                            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvService", (String)"ARVerify", (Object[])new Object[]{disposeList});
                        } else {
                            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvService", (String)"ARUnVerify", (Object[])new Object[]{disposeList});
                        }
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    public static void verifyInvokeCal(List<Object> verifyRecordPks) {
        if (ObjectUtils.isEmpty(verifyRecordPks)) {
            return;
        }
        if (ECServiceHelper.isVerifyCalOpened()) {
            logger.info("arverifyInvokeCal-consistency-true");
            CommonParam param = new CommonParam();
            param.put((Object)"verifyRecordPks", verifyRecordPks);
            ECServiceHelper.beginAndRegister((String)"ar_verify", (String)"ar_verify_invokecal", (String)"fi", (String)"ar", (String)"ArVerifyInvokeCalEC", (Param)param, (String)"");
        } else {
            logger.info("arverifyInvokeCal-consistency-false");
            DynamicObject[] vrDatas = BusinessDataServiceHelper.load((String)"ar_verifyrecord", (String)"id,billid,verifyseq,billentryid,billtype,billno,verifyqty,billstatus,createtime,auditor,modifytime,auditdate,org,entry.e_billid,entry.e_billentryid,entry.e_billno,entry.e_billtype", (QFilter[])new QFilter[]{new QFilter("id", "in", verifyRecordPks)});
            ThreadPools.executeOnceIncludeRequestContext((String)"invoke.arVerify", () -> {
                logger.info("ar-invoke fi-cal-CalBizService");
                Object mserviceLogPk = MserviceLogHelper.insertFailMsLog4VerifyCal((String)"arverify-cal", (Object[])new Object[]{"SALEWRITEOFF", null, vrDatas});
                logger.info("ar-insertFailMsLog4VerifyCal success");
                try {
                    DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{"SALEWRITEOFF", null, vrDatas});
                    logger.info("ar fi-cal-CalBizService success");
                    MserviceLogHelper.updateMserviceLogSuccess((Object)mserviceLogPk);
                }
                catch (Exception e) {
                    logger.info("ar CalBizService-exception");
                    logger.error((Throwable)e);
                    MserviceLogHelper.updateExceptionInfo((Object)mserviceLogPk, (String)e.toString());
                }
            });
        }
    }

    public static void writtenOffVs(RedVerifyRecordParam redVerifyRecordParam, List<Long> verifyRecordIds, Long revcfmBillId) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("recordType", "cal_salwfrecord");
        params.put("recordPk", verifyRecordIds);
        params.put("caBillType", "ar_revcfmbill");
        params.put("bookDate", redVerifyRecordParam.getBookDate());
        params.put("bizDate", redVerifyRecordParam.getBizDate());
        params.put("remark", redVerifyRecordParam.getRemark());
        HashMap<Long, Long> caBillIdMapping = new HashMap<Long, Long>(2);
        caBillIdMapping.put(redVerifyRecordParam.getSourcebillId(), redVerifyRecordParam.getBillId());
        params.put("caBillIdMapping", caBillIdMapping);
        long uniqueKey = DB.genGlobalLongId();
        params.put("uniquekey", uniqueKey);
        if (ECServiceSwitch.isOpened()) {
            CommonParam param = new CommonParam();
            param.put((Object)"schemamap", params);
            logger.info("writtenoff_revcfm_id: " + revcfmBillId);
            ECServiceHelper.beginAndRegister((String)"ar_writtenoff", (String)"", (String)"mpscmm", (String)"mscommon", (String)"ChargeAgainstRecordImpl", (Param)param, (String)"");
        } else {
            try (TXHandle tx = TX.requiresNew((String)"writtenvs");){
                try {
                    DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"ChargeAgainstRecordImpl", (String)"chargeAgainstRecord", (Object[])new Object[]{params});
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    public static String getRevcfmSelector() {
        return "org,asstacttype,asstact,currency,basecurrency,quotation,exchangerate,e_isallverify,billno,e_material,e_measureunit,e_confirmqty,e_baseunitqty,bizdate,e_verifiedamt,e_unverifyamt,e_actunitprice,e_acttaxunitprice,e_quantity,e_verifiedqty,e_ispresent,e_baseunit,e_baseunitqty,e_unitcoefficient,e_confirmamt,e_corebillno,e_corebillentryseq,e_unverifyqty,sourcebilltype,e_sourcebillid,e_sourcebillentryid,billtype,e_materialversion,e_material.masterid.modelnum,e_assistantattr,configuredcode,tracknumber,e_confirmbaseqty";
    }

    public static String getSalSelector() {
        return "id,org,invscheme.transceivertype,billno,settlecurrency,currency,quotation,exchangerate,billtype,biztime,customer,billentry.actualprice,billentry.actualtaxprice,billentry.id,billentry.material,billentry.qty,billentry.amount,billentry.ispresent,billentry.mainbillnumber,billentry.unverifyqty,billentry.baseqty,billentry.unit,billentry.baseunit,billentry.entrysettleorg,billentry.mainbillentryseq,billentry.srcbillentryid,billentry.mversion,billentry.material.masterid.modelnum,billentry.auxpty,billentry.configuredcode,billentry.tracknumber,billentry.settlecustomer";
    }

    public static void autoGetInventoryCost(String eventNumber, Long orgId, List<Long> salOutBillIds) {
        if (ObjectUtils.isEmpty(salOutBillIds)) {
            return;
        }
        logger.info("\u5b58\u8d27\u6838\u7b97\u4e8b\u4ef6\u89e6\u53d1\uff1a\u4e8b\u4ef6\u7f16\u7801==>{}\uff0c\u7b26\u5408\u6761\u4ef6\u7684\u9500\u552e\u51fa\u5e93\u5355ids==>{}", (Object)eventNumber, salOutBillIds);
        HashSet<Long> batchIds = new HashSet<Long>(1000);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter billTypeFilter = new QFilter("billtype", "=", (Object)"im_saloutbill");
        QFilter asstBillTypeFilter = new QFilter("entry.e_billtype", "=", (Object)"ar_revcfmbill");
        QFilter billIdFilter = new QFilter("billid", "in", salOutBillIds);
        try (DataSet verifyRecords = QueryServiceHelper.queryDataSet((String)"VerifyServiceHelper.getRevCfmBillIds", (String)"ar_verifyrecord", (String)"entry.e_billid", (QFilter[])new QFilter[]{orgFilter, asstBillTypeFilter, billTypeFilter, billIdFilter}, null);){
            for (Row verifyRecord : verifyRecords) {
                batchIds.add(verifyRecord.getLong("entry.e_billid"));
                if (batchIds.size() != 1000) continue;
                TXHandle tx = TX.requiresNew();
                Throwable throwable = null;
                try {
                    try {
                        VerifyServiceHelper.execute(eventNumber, batchIds);
                        batchIds.clear();
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
        }
        if (!batchIds.isEmpty()) {
            var9_9 = null;
            try (TXHandle tx = TX.requiresNew();){
                try {
                    VerifyServiceHelper.execute(eventNumber, batchIds);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
        }
    }

    private static void execute(String eventNumber, Set<Long> batchIds) {
        logger.info("\u5b58\u8d27\u6838\u7b97\u4e8b\u4ef6\u89e6\u53d1\uff1a\u4e8b\u4ef6\u7f16\u7801==>{}\uff0c\u7b26\u5408\u6761\u4ef6\u7684\u6536\u5165\u786e\u8ba4\u5355ids==>{}", (Object)eventNumber, batchIds);
        OperationServiceHelper.executeOperate((String)"getinventorycost", (String)"ar_revcfmbill", (Object[])batchIds.toArray(), (OperateOption)OperateOption.create());
    }

    public static boolean enablePreOriginalWfConfig(boolean isOnlyTax) {
        if (isOnlyTax) {
            if (!VerifyServiceHelper.queryBaseDataForVerify("msmod_schemeset", "enable", 1678167385250475008L, 1678167826390592512L, 1695568059550730240L, 1695567805635831808L)) {
                return false;
            }
            if (!VerifyServiceHelper.queryBaseDataForVerify("msmod_writeofftype", "enable", 1678148494499522560L, 1678144407779420160L, 1693749472343164928L, 1693748335779055616L)) {
                return false;
            }
            if (!VerifyServiceHelper.queryBaseDataForVerify("msmod_matchrule", "enable", 1678164631362742272L, 167816298785827430L, 1693752186385008640L, 1693752659301050368L)) {
                return false;
            }
            if (!VerifyServiceHelper.queryBaseDataForVerify("msmod_scheme", "enable", 1678166181728496640L, 1678166573031894016L, 1693753509310433280L, 1693754142616782848L)) {
                return false;
            }
            if (!VerifyServiceHelper.queryBaseDataForVerify("msmod_rewriterule", "enable", 1690460086469976064L, 1690457066227288064L)) {
                return false;
            }
            return VerifyServiceHelper.queryBaseDataForVerify("sbs_billfieldmapping", "isenable", 1677476932607813632L, 1677541175092848640L);
        }
        if (!VerifyServiceHelper.queryBaseDataForVerify("msmod_writeofftype_sort", "enable", 1389236194302264320L, 1680584151830651904L)) {
            return false;
        }
        if (!VerifyServiceHelper.queryBaseDataForVerify("msmod_writeofftype", "enable", 1679120508043735040L, 1682538187484133376L)) {
            return false;
        }
        if (!VerifyServiceHelper.queryBaseDataForVerify("msmod_matchrule", "enable", 1680362254467615744L, 1682628186049181696L)) {
            return false;
        }
        if (!VerifyServiceHelper.queryBaseDataForVerify("msmod_scheme", "enable", 1680378656117245952L, 1682629160729806848L)) {
            return false;
        }
        if (!VerifyServiceHelper.queryBaseDataForVerify("msmod_rewriterule", "enable", 1680462935044148224L, 1682633796803196928L)) {
            return false;
        }
        if (!VerifyServiceHelper.queryBaseDataForVerify("msmod_schemeset", "enable", 1680467798893283328L, 1682639299285448704L)) {
            return false;
        }
        return VerifyServiceHelper.queryBaseDataForVerify("sbs_billfieldmapping", "isenable", 1678291984298756096L, 1678372086948775936L);
    }

    private static boolean queryBaseDataForVerify(String entityName, String enableName, Long ... ids) {
        List<Long> idList = Arrays.asList(ids);
        return QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{new QFilter("id", "in", idList), new QFilter(enableName, "=", (Object)"1")});
    }
}

