/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.business.fin.BusArEditInBulkService;
import kd.fi.ar.enums.DiscountModeEnum;
import kd.fi.ar.formplugin.base.ArBaseBillPlugin;
import kd.fi.ar.formplugin.formservice.bus.BusArBillFormHelper;
import kd.fi.ar.formplugin.formservice.bus.BusArBillImportHelper;
import kd.fi.ar.helper.FinArBillHelper;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.eas.helper.MoveEasCommonHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.ArApCorebillHelper;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.helper.ArApSettleTypeHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.DiscountAmtHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.LineTypeHelper;
import kd.fi.arapcommon.helper.MTOHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.helper.PrecisionHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.BillStatusCtrlService;
import kd.fi.arapcommon.service.EditInBulkService;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.OperationUtils;

public class BusArBillEdit
extends ArBaseBillPlugin
implements EntryGridBindDataListener {
    private InitHelper init;
    private boolean isCopyEntryRow = false;
    private Map<String, Object> customersMap;
    private BillStatusCtrlService billStatusCtrlService = new BillStatusCtrlService();
    private BusArBillImportHelper importHelper;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.materialFilter();
        this.materialVersionFilter();
        this.measureUnitFilter();
        this.taxratefilter();
        this.configuredCodeFilter();
        this.addClickListeners(new String[]{"e_corebillno", "sameinfo_view", "sameinfo_ignore"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.asstactFilter();
        this.filterPayproperty();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    private void materialFilter() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!ObjectUtils.isEmpty((Object)org) && LineTypeHelper.getParam((long)org.getLong("id"), (boolean)true).booleanValue()) {
            return;
        }
        BasedataEdit materialF7 = (BasedataEdit)this.getControl("e_material");
        materialF7.addBeforeF7SelectListener(evt -> {
            DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtype");
            if (!ObjectUtils.isEmpty((Object)billtype)) {
                QFilter filter = "ar_busbill_sersal_BT_S".equals(billtype.getString("number")) ? new QFilter("materialtype", "=", (Object)"9") : new QFilter("materialtype", "in", (Object)new String[]{"1", "2", "3", "4", "5", "6"});
                ListFilterParameter parameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                parameter.getQFilters().add(filter);
            }
        });
    }

    private void materialVersionFilter() {
        BasedataEdit materialVersionF7 = (BasedataEdit)this.getControl("e_materialversion");
        materialVersionF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject material = (DynamicObject)this.getModel().getValue("e_material", currentRow);
            if (!ObjectUtils.isEmpty((Object)material)) {
                long materialId = material.getLong("id");
                QFilter filter = new QFilter("material", "=", (Object)materialId);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    private void measureUnitFilter() {
        BasedataEdit measureUnitEdit = (BasedataEdit)this.getControl("e_measureunit");
        FormServiceHelper.addMeasureUnitFilter((IDataModel)this.getModel(), (String)"e_material", (String)"entry", (BasedataEdit)measureUnitEdit);
    }

    private void taxratefilter() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        BasedataEdit taxrateF7 = (BasedataEdit)this.getControl("taxrateid");
        BaseDataHelper.taxratefilter((Date)bizdate, (BasedataEdit)taxrateF7);
    }

    private void configuredCodeFilter() {
        BasedataEdit billTypeF7 = (BasedataEdit)this.getControl("configuredcode");
        billTypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject material = (DynamicObject)this.getModel().getValue("e_material", currentRow);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (EmptyUtils.isNotEmpty((Object)material)) {
                long materialId = material.getLong("id");
                QFilter filter = new QFilter("material.id", "=", (Object)materialId);
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    private void asstactFilter() {
        ItemClassEdit asstactF7 = (ItemClassEdit)this.getControl("asstact");
        asstactF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String asstactType = this.getModel().getValue("asstacttype").toString();
            if ("bd_customer".equals(asstactType)) {
                QFilter filter = new QFilter("bizfunction", "ilike", (Object)"%2%");
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter);
            }
        });
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "e_corebillno": {
                this.coreBillShowF7();
                break;
            }
            case "sameinfo_view": {
                Map sameBillInfo = (Map)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0071", new HashMap(2), (Object[])new Object[]{this.getModel().getDataEntity(true)});
                if (sameBillInfo != null && !sameBillInfo.isEmpty()) {
                    ArrayList sameBillNos = new ArrayList(sameBillInfo.values());
                    ListShowParameter parameter = new ListShowParameter();
                    parameter.setBillFormId("ar_busbill");
                    parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    QFilter qFilter = new QFilter("billno", "in", sameBillNos.get(0));
                    parameter.getListFilterParameter().setFilter(qFilter);
                    parameter.setCustomParam("checkKey", (Object)Boolean.TRUE);
                    this.getView().showForm((FormShowParameter)parameter);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
                    break;
                }
            }
            case "sameinfo_ignore": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
            }
        }
    }

    private void coreBillShowF7() {
        int currentRow = this.getModel().getEntryCurrentRowIndex("entry");
        String coreBillType = (String)this.getModel().getValue("e_corebilltype", currentRow);
        ArApCorebillHelper.showCoreBillF7((String)coreBillType, (IFormView)this.getView(), (String)this.getPluginName());
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Object returnData = e.getReturnData();
        switch (id) {
            case "coreBill": {
                ArApCorebillHelper.closeCoreBillF7((IDataModel)this.getModel(), (String)"entry", (Object)returnData);
                this.getView().updateView("entry");
                break;
            }
            case "editinbulk": {
                Map returnMap = (Map)returnData;
                if (ObjectUtils.isEmpty((Object)returnMap)) {
                    return;
                }
                DynamicObjectCollection returnEntrys = (DynamicObjectCollection)returnMap.get("entrys");
                Map srcEntryRowMap = (Map)returnMap.get("srcEntryRowMap");
                BusArEditInBulkService editInBulkService = new BusArEditInBulkService(this.getView(), this.getPluginName());
                editInBulkService.returnParent(returnEntrys, srcEntryRowMap);
                this.getPageCache().put("iseditinbulk", "true");
                this.getView().updateView();
                break;
            }
            case "ap_totaldiscount": {
                Map discountMap = (Map)returnData;
                if (!EmptyUtils.isNotEmpty((Object)discountMap)) break;
                this.setEntryDiscountAmt(discountMap);
                break;
            }
            case "woff": {
                if (returnData == null) {
                    return;
                }
                Map woffMap = (Map)returnData;
                List busIds = (List)woffMap.get("ids");
                String bizDate = (String)woffMap.get("bizdate");
                this.invokeWoff(busIds, bizDate);
            }
        }
    }

    private void setEntryDiscountAmt(Map<String, Object> discountMap) {
        IDataModel m = this.getModel();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        if (entrys != null && entrys.size() > 0) {
            for (int i = 0; i < entrys.size(); ++i) {
                if (((DynamicObject)entrys.get(i)).getBoolean("e_ispresent")) continue;
                m.beginInit();
                m.setValue("e_discountamount", (Object)BigDecimal.ZERO, i);
                m.setValue("e_discountmode", (Object)"TOTAL", i);
                m.endInit();
                this.calculateRow(this.getModel(), i, "e_discountamount", this.getModel().getValue("e_discountamount", i), false);
            }
        }
        DiscountAmtHelper discountService = new DiscountAmtHelper();
        discountService.setEntryDiscountAmt(BillModelFactory.getModel((String)"ar_busbill"), m, discountMap);
        entrys = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < entrys.size(); ++i) {
            this.calculateRow(this.getModel(), i, "e_discountamount", this.getModel().getValue("e_discountamount", i), false);
        }
        this.getView().updateView("fs_amtinfo");
        this.getView().updateView("entry");
        PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
    }

    private BusArBillImportHelper getImportHelper() {
        if (this.importHelper == null) {
            this.importHelper = new BusArBillImportHelper(this.getModel(), this.getPageCache());
        }
        return this.importHelper;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        this.getImportHelper().initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        this.getImportHelper().beforeImportData(e);
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.getImportHelper().afterImportData(e);
    }

    protected void calculatorEntryAmt(IDataModel m, boolean includeTax, BigDecimal rate, int precision, int localprecision, int index) {
    }

    public void afterCreateNewData(EventObject e) {
        long settleTypeId;
        super.afterCreateNewData(e);
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        BookDateHelper.setBookDateAndRange((IFormView)this.getView(), (boolean)true);
        if (parameter.getCustomParam("isPeriod") != null) {
            this.getModel().setValue("isperiod", parameter.getCustomParam("isPeriod"));
        }
        if ((settleTypeId = ArApSettleTypeHelper.getDefaultSettleType()) != 0L) {
            this.getModel().setValue("settlementtype", (Object)settleTypeId);
        }
        if (!"true".equals(this.getPageCache().get("isWebApi"))) {
            this.createNewModel();
        }
    }

    private void createNewModel() {
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org) && !ObjectUtils.isEmpty((Object)(org = OrgHelper.getAuthorizedBankOrg((String)"ar", (String)"ar_busbill", (String)"47150e89000000ac")))) {
            this.getModel().setValue("org", (Object)org.getLong("id"));
        }
        if (ObjectUtils.isEmpty((Object)org)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"BusArBillEdit_8", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            return;
        }
        long orgId = (Long)org.getPkValue();
        this.init = new InitHelper(orgId, "ar_init");
        if (this.isInitSetting(org)) {
            BusArBillFormHelper.createByInit((IDataModel)this.getModel(), (IPageCache)this.getPageCache(), (InitHelper)this.init);
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue("recorg")) && org.getBoolean("fisbankroll")) {
                model.setValue("recorg", (Object)orgId);
            }
            if (EmptyUtils.isEmpty((Object)this.getModel().getValue("duedate"))) {
                this.getModel().setValue("duedate", (Object)new Date());
            }
            this.fillToolBar();
            model.setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit", "bar_track", "bar_generatevoucher", "tbltrack"});
        }
    }

    private boolean isInitSetting(DynamicObject org) {
        if (ObjectUtils.isEmpty((Object)this.init.getStartDate())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%s\u7ec4\u7ec7\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"BusArBillEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
            return false;
        }
        return true;
    }

    public void afterBindData(EventObject e) {
        Date startDate;
        super.afterBindData(e);
        BookDateHelper.setBookDateRange((IFormView)this.getView(), (boolean)true);
        if (((Boolean)this.getModel().getValue("isperiod")).booleanValue()) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (this.init == null) {
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            this.init = new InitHelper(org.getLong("id"), "ar_init");
        }
        if ((startDate = this.init.getStartDate()) == null) {
            return;
        }
        DateEdit bizdate = (DateEdit)this.getControl("bizdate");
        bizdate.setMinDate(startDate);
        this.fillToolBar();
        OperationUtils.setButtonUnvisibleByAppId((String)this.getModel().getDataEntityType().getName(), (IFormView)this.getView());
        this.setAsstactCaption();
        PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
    }

    private void setAsstactCaption() {
        ItemClassEdit asstact;
        String asstName;
        String asstactType = (String)this.getModel().getValue("asstacttype");
        String customerCaption = ResManager.loadKDString((String)"\u7ed3\u7b97\u5ba2\u6237", (String)"BusArBillEdit_12", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        String asstactCaption = ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"BusArBillEdit_13", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        if (!asstactCaption.equals(asstName = (asstact = (ItemClassEdit)this.getControl("asstact")).getProperty().getDisplayName().getLocaleValue())) {
            return;
        }
        if ("bd_customer".equals(asstactType)) {
            asstact.setCaption(new LocaleString(customerCaption));
        } else {
            asstact.setCaption(new LocaleString(asstactCaption));
        }
    }

    public void initialize() {
        super.initialize();
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List entities = e.getRows();
        this.controlEnableForMTO(entities);
    }

    private void controlEnableForMTO(List<RowDataEntity> entries) {
        String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
        if (StringUtils.isNotEmpty((CharSequence)sourceBillType)) {
            for (int i = 0; i < entries.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"configuredcode"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"tracknumber"});
            }
        }
    }

    public void changeMtoEnable(DynamicObject material, int row) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String configproperty = material.getString("configproperties");
        Long masterid = material.getLong("masterid");
        HashSet<Long> masterids = new HashSet<Long>(1);
        masterids.add(masterid);
        Map tracewayMap = MTOHelper.getMaterialToTraceWayMap(masterids, (DynamicObject)org);
        List tracewayNumbers = (List)tracewayMap.get(masterid);
        if ("2".equals(configproperty)) {
            this.getView().setEnable(Boolean.TRUE, row, new String[]{"configuredcode"});
        } else {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"configuredcode"});
        }
        if (EmptyUtils.isNotEmpty((Object)tracewayNumbers) && tracewayNumbers.contains("GZ001")) {
            this.getView().setEnable(Boolean.TRUE, row, new String[]{"tracknumber"});
        } else {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"tracknumber"});
        }
    }

    private void fillToolBar() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_unsubmit", "bar_del", "bar_audit", "bar_unaudit", "bar_generatevoucher", "bar_track", "bar_submitandnew", "bar_woff", "bar_push"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_track"});
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            if (((Boolean)this.getModel().getValue("isselfwoff")).booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_submitandnew"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_submit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_del", "bar_submitandnew"});
            }
        } else if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
            if (!((Boolean)this.getModel().getValue("isperiod")).booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_submit"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_audit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unsubmit", "bar_audit"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_submit"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_audit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unaudit", "bar_unsubmit", "bar_audit", "bar_new", "bar_submitandnew"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"calculatetaxcbtn"});
        } else if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_woff", "bar_push", "bar_audit", "bar_unaudit", "bar_generatevoucher"});
            if (!((Boolean)this.getModel().getValue("isperiod")).booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_audit"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_unaudit"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"calculatetaxcbtn"});
        }
        if (((Boolean)this.getModel().getValue("isadjust")).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_unaudit"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int index = changeData[0].getRowIndex();
        IDataModel m = this.getModel();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!this.billStatusCtrlService.isCanChange(billStatus)) {
            return;
        }
        switch (key) {
            case "billtype": {
                if (newValue != null) break;
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"billtype", (Object)oldValue);
                return;
            }
            case "bizdate": {
                if (newValue == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"bizdate", (Object)oldValue);
                    return;
                }
                BookDateHelper.setBookDateAndRange((IFormView)this.getView(), (boolean)true);
                this.bizDateChanged();
                break;
            }
            case "currency": {
                int newPrecision;
                if (newValue == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"currency", (Object)oldValue);
                    return;
                }
                if (ObjectUtils.isEmpty((Object)oldValue)) {
                    return;
                }
                int oldPrecision = ((DynamicObject)oldValue).getInt("amtprecision");
                if (oldPrecision != (newPrecision = ((DynamicObject)newValue).getInt("amtprecision"))) {
                    this.calculateAllRow(m);
                }
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                break;
            }
            case "exratedate": 
            case "exratetable": {
                if (newValue == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)key, (Object)oldValue);
                    return;
                }
                if (oldValue != null) break;
                return;
            }
            case "e_material": {
                m.setValue("e_materialversion", null, index);
                m.setValue("configuredcode", null, index);
                m.setValue("tracknumber", null, index);
                m.setValue("e_productline", null, index);
                this.materialChanged(newValue, index);
                break;
            }
            case "asstact": {
                long asstactSettleTypeId;
                this.setReceivingcond(newValue);
                String asstactType = (String)m.getValue("asstacttype");
                DynamicObject asstact = (DynamicObject)m.getValue("asstact");
                if (ObjectUtils.isEmpty((Object)asstact)) {
                    this.clearAssLinkcustomer();
                    return;
                }
                if ("bd_customer".equals(asstactType)) {
                    DynamicObjectCollection entrys;
                    this.customersMap = FinArBillHelper.setCustomersToViewCash((IDataModel)this.getModel(), (IPageCache)this.getPageCache());
                    if (this.customersMap != null && this.customersMap.size() > 0 && (entrys = this.getModel().getEntryEntity("entry")) != null && entrys.size() > 0) {
                        for (int i = 0; i < entrys.size(); ++i) {
                            this.getModel().setValue("e_invoicecustomerid", this.customersMap.get("invoiceCustomerId"), i);
                            this.getModel().setValue("e_delivercustomerid", this.customersMap.get("deliverCustomerId"), i);
                        }
                    }
                }
                if ((asstactSettleTypeId = ArApSettleTypeHelper.getAsstactSettleType((String)asstactType, (long)asstact.getLong("id"))) == 0L) {
                    return;
                }
                m.setValue("settlementtype", (Object)asstactSettleTypeId);
                break;
            }
            case "e_measureunit": {
                this.calculateBaseQty(index);
                this.calculateQty(index);
                break;
            }
            case "e_quantity": {
                DynamicObject payproperty = (DynamicObject)m.getValue("payproperty");
                if (payproperty != null && payproperty.getBoolean("isbasedonamt") && ((BigDecimal)newValue).abs().compareTo(BigDecimal.ONE) != 0) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"e_quantity", (Object)oldValue, (int)index);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u91d1\u989d\u57fa\u51c6\u4e1a\u52a1\uff0c\u6570\u91cf\u5e94\u4e3a1\u6216-1\u3002", (String)"BusArBillEdit_6", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (((BigDecimal)newValue).compareTo(BigDecimal.ZERO) == 0) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"e_quantity", (Object)oldValue, (int)index);
                    break;
                }
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(index, this.getModel(), key, BillModelFactory.getModel((String)"ar_busbill"));
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                m.setValue("e_uninvoicedqty", newValue, index);
                m.setValue("e_unwoffqty", newValue, index);
                m.setValue("e_unconfirmqty", newValue, index);
                m.setValue("e_unrelateinvqty", newValue, index);
                this.calculateBaseQty(index);
            }
            case "e_recamount": 
            case "e_amount": 
            case "e_discountrate": 
            case "e_taxrate": {
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(index, this.getModel(), key, BillModelFactory.getModel((String)"ar_busbill"));
                this.calculateRow(m, index, key, oldValue, false);
                break;
            }
            case "e_unitprice": 
            case "e_taxunitprice": {
                boolean isPresent = (Boolean)this.getModel().getValue("e_ispresent", index);
                if (isPresent) {
                    BigDecimal price = (BigDecimal)newValue;
                    if (BigDecimal.ZERO.compareTo(price) == 0) {
                        m.setValue("e_discountmode", (Object)"NULL", index);
                    } else {
                        m.setValue("e_discountmode", (Object)"PERCENT", index);
                        m.setValue("e_discountrate", (Object)new BigDecimal(100), index);
                    }
                }
                this.calculateRow(m, index, key, oldValue, false);
                break;
            }
            case "e_discountamount": {
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(index, this.getModel(), key, BillModelFactory.getModel((String)"ar_busbill"));
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                break;
            }
            case "e_discountmode": {
                m.setValue("e_discountrate", (Object)BigDecimal.ZERO, index);
                if ("TOTAL".equals(newValue)) {
                    m.setValue("e_discountamount", (Object)BigDecimal.ZERO, index);
                }
                this.calculateRow(m, index, key, oldValue, false);
                break;
            }
            case "e_ispresent": {
                boolean isPriceTotal = (Boolean)this.getModel().getValue("ispricetotal");
                boolean curIsPresent = (Boolean)newValue;
                BigDecimal rice = (BigDecimal)m.getValue("e_unitprice", index);
                BigDecimal priceTax = (BigDecimal)m.getValue("e_taxunitprice", index);
                if (isPriceTotal) {
                    this.getModel().beginInit();
                    if ((BigDecimal.ZERO.compareTo(rice) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0) && curIsPresent) {
                        m.setValue("e_discountmode", (Object)"PERCENT", index);
                        m.setValue("e_discountrate", (Object)new BigDecimal(100), index);
                    } else {
                        m.setValue("e_discountmode", (Object)"NULL", index);
                        m.setValue("e_discountrate", (Object)BigDecimal.ZERO, index);
                        m.setValue("e_discountamount", (Object)BigDecimal.ZERO, index);
                    }
                    this.getModel().endInit();
                    this.calculateRow(m, index, key, oldValue, true);
                    this.getView().updateView("entry", index);
                    break;
                }
                if ((BigDecimal.ZERO.compareTo(rice) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0) && curIsPresent) {
                    m.setValue("e_discountmode", (Object)"PERCENT", index);
                    m.setValue("e_discountrate", (Object)new BigDecimal(100), index);
                    break;
                }
                m.setValue("e_discountmode", (Object)"NULL", index);
                break;
            }
            case "exchangerate": {
                if (EmptyUtils.isEmpty((Object)newValue)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"BusArBillEdit_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.calculateAllRow(m);
                break;
            }
            case "payproperty": {
                FormServiceHelper.paypropertyChanged((IDataModel)m, (String)"entry", (String)"e_quantity");
                break;
            }
            case "e_corebilltype": {
                m.setValue("e_corebillno", null, index);
                m.setValue("e_corebillentryseq", null, index);
                break;
            }
            case "biztype": {
                DynamicObject supplier;
                if (Objects.equals(newValue, oldValue)) break;
                DynamicObject oldBizType = (DynamicObject)oldValue;
                String type = (String)m.getValue("asstacttype");
                String message = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u660e\u7ec6\u884c\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"BusArBillEdit_9", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                if ("bd_supplier".equals(type) && !this.isVmi((DynamicObject)newValue, supplier = (DynamicObject)m.getValue("asstact"))) {
                    message = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u5f80\u6765\u6237\u4fe1\u606f\u53ca\u660e\u7ec6\u884c\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"BusArBillEdit_11", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                }
                this.getPageCache().put("OLDBIZTYPEID", String.valueOf(oldValue == null ? Long.valueOf(0L) : oldBizType.getPkValue()));
                this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this));
                break;
            }
            case "duedate": {
                this.setPlanDuedateRange();
                if (newValue != null) break;
                this.getModel().setValue("duedate", this.getModel().getValue("bizdate"));
                break;
            }
            case "asstacttype": {
                this.setAsstactCaption();
                this.clearAssLinkcustomer();
            }
        }
    }

    private void clearAssLinkcustomer() {
        this.getModel().setValue("paymentcustomerid", null);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        if (entrys != null && entrys.size() > 0) {
            for (int i = 0; i < entrys.size(); ++i) {
                this.getModel().setValue("e_invoicecustomerid", null, i);
                this.getModel().setValue("e_delivercustomerid", null, i);
            }
        }
    }

    private void setPlanDuedateRange() {
        DateEdit plandutedate = (DateEdit)this.getView().getControl("planduedate");
        Date maxDate = (Date)this.getModel().getValue("duedate");
        if (maxDate != null) {
            plandutedate.setMaxDate(maxDate);
        }
    }

    private boolean isVmi(DynamicObject bizType, DynamicObject asstact) {
        boolean isMatch = true;
        if (ObjectUtils.isEmpty((Object)bizType) || ObjectUtils.isEmpty((Object)asstact)) {
            return isMatch;
        }
        String domain = bizType.getString("domain");
        DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"enablevmi", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstact.getLong("id"))});
        boolean enableVmi = supplier.getBoolean("enablevmi");
        if (!enableVmi && "6".equals(domain)) {
            isMatch = false;
        }
        return isMatch;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("biztype".equals(messageBoxClosedEvent.getCallBackId())) {
            String biztypeId;
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                String type = (String)this.getModel().getValue("asstacttype");
                if ("bd_supplier".equals(type)) {
                    DynamicObject supplier = (DynamicObject)this.getModel().getValue("asstact");
                    DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
                    if (!this.isVmi(bizType, supplier)) {
                        this.getModel().setValue("asstact", null);
                    }
                }
                this.clearEntry();
                this.calculateAllRow(this.getModel());
            } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel && StringUtils.isNotEmpty((CharSequence)(biztypeId = this.getPageCache().get("OLDBIZTYPEID")))) {
                this.getModel().beginInit();
                this.getModel().setValue("biztype", (Object)Long.parseLong(biztypeId));
                this.getModel().endInit();
                this.getView().updateView("biztype");
            }
            this.getPageCache().remove("OLDBIZTYPEID");
        }
        String callBackID = messageBoxClosedEvent.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, messageBoxClosedEvent.getResult());
        if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = messageBoxClosedEvent.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            Object billNo = this.getModel().getValue("billno");
            LogUtil.addOpLog((String)"ar_busbill", (Object)billNo, (String)operateKey, (String)("billnos\uff1a" + billNo + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        }
    }

    private void clearEntry() {
        this.getModel().deleteEntryData("subentryentity");
        this.getModel().deleteEntryData("entry");
        this.getModel().createNewEntryRow("entry");
    }

    private void bizDateChanged() {
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        Date dueDate = (Date)this.getModel().getValue("duedate");
        if (dueDate != null && bizDate != null && dueDate.compareTo(bizDate) < 0) {
            this.getModel().setValue("duedate", (Object)bizDate);
        }
    }

    @Deprecated
    private BigDecimal calculateExchangeRate() {
        DynamicObject srcCurrency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject destCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        DynamicObject exrateTable = (DynamicObject)this.getModel().getValue("exratetable");
        Date exrateDate = (Date)this.getModel().getValue("exratedate");
        if (destCurrency == null || srcCurrency == null || exrateTable == null) {
            return null;
        }
        BigDecimal exchangeRate = BaseDataHelper.getExchangeRate((Long)exrateTable.getLong("id"), (Long)srcCurrency.getLong("id"), (Long)destCurrency.getLong("id"), (Date)exrateDate);
        this.getModel().setValue("exchangerate", (Object)exchangeRate);
        if (exchangeRate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"BusArBillEdit_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        return exchangeRate;
    }

    private void materialChanged(Object newValue, int index) {
        DynamicObject material = (DynamicObject)newValue;
        if (!ObjectUtils.isEmpty((Object)material)) {
            this.getModel().setValue("e_spectype", (Object)material.getString("modelnum"), index);
            this.getModel().setValue("e_measureunit", (Object)material.getLong("baseunit.id"), index);
            this.getModel().setValue("e_baseunit", (Object)material.getLong("baseunit.id"), index);
            this.getModel().setValue("e_baseunitqty", this.getModel().getValue("e_quantity", index), index);
            this.getModel().setValue("e_unitcoefficient", (Object)BigDecimal.ONE, index);
            DynamicObject productline = material.getDynamicObject("productline");
            if (productline != null) {
                this.getModel().setValue("e_productline", productline.getPkValue(), index);
            }
            if (material.getDynamicObject("taxrate") != null) {
                Object taxrateId = material.getDynamicObject("taxrate").getPkValue();
                this.getModel().setValue("taxrateid", taxrateId, index);
            }
        } else {
            this.getModel().setValue("e_spectype", null, index);
        }
    }

    private void calculateBaseQty(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject measureUnit = (DynamicObject)model.getValue("e_measureunit", rowIndex);
        if (measureUnit == null) {
            return;
        }
        DynamicObject material = (DynamicObject)model.getValue("e_material", rowIndex);
        if (material == null) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)model.getValue("e_baseunit", rowIndex);
        if (baseUnit == null && (baseUnit = material.getDynamicObject("baseunit")) != null) {
            model.setValue("e_baseunit", baseUnit.getPkValue(), rowIndex);
        }
        if (baseUnit == null) {
            return;
        }
        long baseUnitID = (Long)baseUnit.getPkValue();
        long measureUnitID = (Long)measureUnit.getPkValue();
        long materialID = (Long)material.getPkValue();
        BigDecimal convertRate = UnitConvertHelper.getUnitRateConv((Long)materialID, (Long)measureUnitID, (Long)baseUnitID);
        BigDecimal quantity = (BigDecimal)model.getValue("e_quantity", rowIndex);
        if (convertRate != null) {
            model.setValue("e_unitcoefficient", (Object)convertRate, rowIndex);
            if (quantity != null) {
                model.setValue("e_baseunitqty", (Object)convertRate.multiply(quantity), rowIndex);
            }
        }
    }

    private void calculateQty(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject measureUnit = (DynamicObject)model.getValue("e_measureunit", rowIndex);
        if (measureUnit == null) {
            return;
        }
        BigDecimal quantity = (BigDecimal)model.getValue("e_quantity", rowIndex);
        if (quantity != null) {
            model.setValue("e_quantity", (Object)quantity.setScale(measureUnit.getInt("precision"), 4), rowIndex);
        }
    }

    private void calculateAllRow(IDataModel m) {
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocal = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localAmt = BigDecimal.ZERO;
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalLocal = BigDecimal.ZERO;
        int entryRowCount = m.getEntryRowCount("entry");
        for (int i = 0; i < entryRowCount; ++i) {
            PriceLocalCalculator calculator = this.buildCalculator(m, i);
            this.setRowValue(m, calculator, i);
            tax = tax.add(calculator.getTax());
            taxLocal = taxLocal.add(calculator.getTaxlocal());
            amount = amount.add(calculator.getAmount());
            localAmt = localAmt.add(calculator.getAmountlocal());
            priceTaxTotal = priceTaxTotal.add(calculator.getPricetaxtotal());
            priceTaxTotalLocal = priceTaxTotalLocal.add(calculator.getPricetaxtotallocal());
        }
        m.setValue("tax", (Object)tax);
        m.setValue("taxlocamt", (Object)taxLocal);
        m.setValue("amount", (Object)amount);
        m.setValue("localamt", (Object)localAmt);
        m.setValue("uninvoicedamt", (Object)priceTaxTotal);
        m.setValue("unwoffamt", (Object)priceTaxTotal);
        m.setValue("reclocalamt", (Object)priceTaxTotalLocal);
        m.setValue("uninvoicedlocamt", (Object)priceTaxTotalLocal);
        m.setValue("unwofflocamt", (Object)priceTaxTotalLocal);
        m.setValue("unwoffnotaxamt", (Object)amount);
        m.setValue("unwoffnotaxlocamt", (Object)localAmt);
        m.setValue("unwofftax", (Object)tax);
        m.setValue("unwofftaxlocal", (Object)taxLocal);
        m.setValue("unrelateinvamt", (Object)priceTaxTotal);
        m.setValue("unrelateinvlocamt", (Object)priceTaxTotalLocal);
        m.setValue("recamount", (Object)priceTaxTotal);
    }

    private void calculateRow(IDataModel m, int index, String changeKey, Object oldValue, boolean isPresent) {
        BigDecimal oldEntryPriceTaxTotalLocal;
        BigDecimal oldEntryTax = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_tax", index);
        BigDecimal oldEntryTaxLocal = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_taxlocalamt", index);
        BigDecimal oldEntryAmount = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_amount", index);
        BigDecimal oldEntryAmountLocal = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_localamt", index);
        BigDecimal oldEntryPriceTaxTotal = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_recamount", index);
        BigDecimal bigDecimal = oldEntryPriceTaxTotalLocal = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_reclocalamt", index);
        if ("e_amount".equals(changeKey)) {
            oldEntryAmount = (BigDecimal)oldValue;
        }
        if ("e_recamount".equals(changeKey)) {
            oldEntryPriceTaxTotal = (BigDecimal)oldValue;
        }
        PriceLocalCalculator calculator = !isPresent ? this.buildCalculator(m, index) : this.buildCalculatorByPresent(m, index, isPresent);
        this.setRowValue(m, calculator, index);
        BigDecimal tax = ((BigDecimal)m.getValue("tax")).subtract(oldEntryTax).add(calculator.getTax());
        BigDecimal taxlocamt = ((BigDecimal)m.getValue("taxlocamt")).subtract(oldEntryTaxLocal).add(calculator.getTaxlocal());
        BigDecimal amount = ((BigDecimal)m.getValue("amount")).subtract(oldEntryAmount).add(calculator.getAmount());
        BigDecimal localamt = ((BigDecimal)m.getValue("localamt")).subtract(oldEntryAmountLocal).add(calculator.getAmountlocal());
        m.setValue("tax", (Object)tax);
        m.setValue("taxlocamt", (Object)taxlocamt);
        m.setValue("amount", (Object)amount);
        m.setValue("localamt", (Object)localamt);
        BigDecimal priceTaxTotal = ((BigDecimal)m.getValue("recamount")).subtract(oldEntryPriceTaxTotal).add(calculator.getPricetaxtotal());
        m.setValue("uninvoicedamt", (Object)priceTaxTotal);
        m.setValue("unwoffamt", (Object)priceTaxTotal);
        BigDecimal priceTaxTotalLocal = ((BigDecimal)m.getValue("reclocalamt")).subtract(oldEntryPriceTaxTotalLocal).add(calculator.getPricetaxtotallocal());
        m.setValue("reclocalamt", (Object)priceTaxTotalLocal);
        m.setValue("uninvoicedlocamt", (Object)priceTaxTotalLocal);
        m.setValue("unwofflocamt", (Object)priceTaxTotalLocal);
        m.setValue("recamount", (Object)priceTaxTotal);
        m.setValue("unwoffnotaxamt", (Object)amount);
        m.setValue("unwoffnotaxlocamt", (Object)localamt);
        m.setValue("unwofftax", (Object)tax);
        m.setValue("unwofftaxlocal", (Object)taxlocamt);
        m.setValue("unrelateinvamt", (Object)priceTaxTotal);
        m.setValue("unrelateinvlocamt", (Object)priceTaxTotalLocal);
    }

    protected void setRowValue(IDataModel m, PriceLocalCalculator calculator, int index) {
        super.setRowValue(m, calculator, index);
        m.setValue("e_taxlocalamt", (Object)calculator.getTaxlocal(), index);
        m.setValue("e_uninvoicedlocamt", (Object)calculator.getPricetaxtotallocal(), index);
        m.setValue("e_unwoffamt", (Object)calculator.getPricetaxtotal(), index);
        m.setValue("e_unwofflocamt", (Object)calculator.getPricetaxtotallocal(), index);
        m.setValue("e_unrelateinvamt", (Object)calculator.getPricetaxtotal(), index);
        m.setValue("e_unrelateinvlocamt", (Object)calculator.getPricetaxtotallocal(), index);
        m.setValue("e_unwofftax", (Object)calculator.getTax(), index);
        m.setValue("e_unwofftaxlocal", (Object)calculator.getTaxlocal(), index);
        m.setValue("e_unwoffnotaxamt", (Object)calculator.getAmount(), index);
        m.setValue("e_unwoffnotaxlocamt", (Object)calculator.getAmountlocal(), index);
        m.setValue("e_uninvnotaxamt", (Object)calculator.getAmount(), index);
        m.setValue("e_uninvnotaxlocalamt", (Object)calculator.getAmountlocal(), index);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IBillModel model = (IBillModel)this.getModel();
        BookDateHelper.setBookDateAndRange((IFormView)this.getView(), (boolean)true);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            this.init = new InitHelper(org.getLong("id"), "ar_init");
            this.getModel().setValue("basecurrency", this.init.getStandardCurrency().getPkValue());
        }
        BigDecimal recAmount = (BigDecimal)model.getValue("recamount");
        BigDecimal recLocalAmount = (BigDecimal)model.getValue("reclocalamt");
        model.setValue("uninvoicedamt", (Object)recAmount);
        model.setValue("uninvoicedlocamt", (Object)recLocalAmount);
        model.setValue("unwoffamt", (Object)recAmount);
        model.setValue("unwofflocamt", (Object)recLocalAmount);
        model.setValue("unrelateinvamt", (Object)recAmount);
        model.setValue("unrelateinvlocamt", (Object)recLocalAmount);
        int entryCount = this.getModel().getEntryRowCount("entry");
        for (int row = 0; row < entryCount; ++row) {
            BigDecimal quantity = (BigDecimal)this.getModel().getValue("e_quantity", row);
            this.getModel().setValue("e_uninvoicedqty", (Object)quantity, row);
            this.getModel().setValue("e_unwoffqty", (Object)quantity, row);
            this.getModel().setValue("e_unconfirmqty", (Object)quantity, row);
            this.getModel().setValue("e_unrelateinvqty", (Object)quantity, row);
            BigDecimal recamount = (BigDecimal)this.getModel().getValue("e_recamount", row);
            BigDecimal reclocalamt = (BigDecimal)this.getModel().getValue("e_reclocalamt", row);
            this.getModel().setValue("e_uninvoicedamt", (Object)recamount, row);
            this.getModel().setValue("e_uninvoicedlocamt", (Object)reclocalamt, row);
            this.getModel().setValue("e_unwoffamt", (Object)recamount, row);
            this.getModel().setValue("e_unwofflocamt", (Object)reclocalamt, row);
            this.getModel().setValue("e_unrelateinvamt", (Object)recamount, row);
            this.getModel().setValue("e_unrelateinvlocamt", (Object)reclocalamt, row);
            BigDecimal amount = (BigDecimal)this.getModel().getValue("e_amount", row);
            this.getModel().setValue("e_unconfirmamt", (Object)amount, row);
        }
        Date currentDate = ObjectUtils.isEmpty((Object)this.init.getCurrentDate()) ? this.init.getStartDate() : this.init.getCurrentDate();
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        this.getModel().setValue("bizdate", (Object)(currentDate.after(bizDate) ? currentDate : bizDate));
        this.getModel().setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (!"refresh".equals(operateKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
        }
        switch (operateKey) {
            case "deleteentry": {
                this.calculateHeadAmt();
                break;
            }
            case "submit": {
                if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                    this.getView().invokeOperation("refresh");
                }
            }
            case "save": {
                Map sameBillInfo = (Map)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0071", new HashMap(2), (Object[])new Object[]{this.getModel().getDataEntity(true)});
                this.sameBillWarn(sameBillInfo);
            }
            case "unsubmit": 
            case "audit": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (!ObjectUtils.isEmpty((Object)org)) {
                    int woffStatus = SystemParameterHelper.getParameterInteger((long)((Long)org.getPkValue()), (String)"ar_004");
                    this.getView().setVisible(Boolean.valueOf(woffStatus != 0), new String[]{"bar_woff"});
                }
                this.fillToolBar();
                break;
            }
            case "unaudit": {
                this.fillToolBar();
                this.getView().invokeOperation("refresh");
                break;
            }
            case "woff": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                OperateOption option = OperateOption.create();
                option.setVariableValue("isselfwoff", "true");
                option.setVariableValue("woffmode", "part");
                this.getView().invokeOperation("pushwoff", option);
                break;
            }
            case "batchwoff": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
            }
        }
        OperationUtils.setButtonUnvisibleByAppId((String)this.getModel().getDataEntityType().getName(), (IFormView)this.getView());
    }

    private void woffBusBIlls() {
        Date bookDate = (Date)this.getModel().getValue("bookdate");
        Long billId = (Long)this.getModel().getValue("id");
        ArrayList<Object> billIds = new ArrayList<Object>(2);
        billIds.add(billId);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = org.getLong("id");
        DynamicObject closeAccount = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_closeaccount", (String)"currentdate", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        HashMap<Long, Date> orgIdToCurDateMap = new HashMap<Long, Date>(2);
        orgIdToCurDateMap.put(orgId, closeAccount.getDate("currentdate"));
        Date orgCurDate = closeAccount.getDate("currentdate");
        Date currentDate = new Date();
        ArrayList woffBillBizDates = new ArrayList(2);
        HashMap<String, Comparable<Long>> dateMap = new HashMap<String, Comparable<Long>>(2);
        DynamicObject apInit = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_init", (String)"isfinishinit", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        boolean isfinishinit = apInit.getBoolean("isfinishinit");
        if (!isfinishinit) {
            if (bookDate.before(currentDate)) {
                dateMap.put("id", billId);
                dateMap.put("bizdate", currentDate);
                dateMap.put("bookdate", currentDate);
                woffBillBizDates.add(dateMap);
                String bizDate = SerializationUtils.toJsonString(woffBillBizDates);
                this.invokeWoff(billIds, bizDate);
            } else {
                dateMap.put("id", billId);
                dateMap.put("bizdate", bookDate);
                dateMap.put("bookdate", bookDate);
                woffBillBizDates.add(dateMap);
                String bizDate = SerializationUtils.toJsonString(woffBillBizDates);
                this.invokeWoff(billIds, bizDate);
            }
        } else if (!bookDate.before(currentDate) && !bookDate.before(orgCurDate)) {
            dateMap.put("id", billId);
            dateMap.put("bizdate", bookDate);
            dateMap.put("bookdate", bookDate);
            woffBillBizDates.add(dateMap);
            String bizDate = SerializationUtils.toJsonString(woffBillBizDates);
            this.invokeWoff(billIds, bizDate);
        } else if (!orgCurDate.before(bookDate) && !orgCurDate.before(currentDate)) {
            dateMap.put("id", billId);
            dateMap.put("bizdate", orgCurDate);
            dateMap.put("bookdate", orgCurDate);
            woffBillBizDates.add(dateMap);
            String bizDate = SerializationUtils.toJsonString(woffBillBizDates);
            this.invokeWoff(billIds, bizDate);
        } else if (!currentDate.before(orgCurDate) && !currentDate.before(bookDate)) {
            if (!orgCurDate.before(bookDate)) {
                if (DateUtils.isSameMonth((Date)currentDate, (Date)orgCurDate)) {
                    dateMap.put("id", billId);
                    dateMap.put("bizdate", currentDate);
                    dateMap.put("bookdate", currentDate);
                    woffBillBizDates.add(dateMap);
                    String bizDate = SerializationUtils.toJsonString(woffBillBizDates);
                    this.invokeWoff(billIds, bizDate);
                } else {
                    HashMap<Long, Date> needSelect = new HashMap<Long, Date>(2);
                    needSelect.put(billId, bookDate);
                    HashMap<Long, Date> billOrgDate = new HashMap<Long, Date>(2);
                    billOrgDate.put(billId, orgCurDate);
                    this.showWoffConfirm("needselect1", needSelect, billIds, billOrgDate, orgIdToCurDateMap);
                }
            } else if (DateUtils.isSameMonth((Date)currentDate, (Date)orgCurDate)) {
                dateMap.put("id", billId);
                dateMap.put("bizdate", currentDate);
                dateMap.put("bookdate", currentDate);
                woffBillBizDates.add(dateMap);
                String bizDate = SerializationUtils.toJsonString(woffBillBizDates);
                this.invokeWoff(billIds, bizDate);
            } else if (DateUtils.isSameMonth((Date)currentDate, (Date)bookDate)) {
                dateMap.put("id", billId);
                dateMap.put("bizdate", currentDate);
                dateMap.put("bookdate", currentDate);
                woffBillBizDates.add(dateMap);
                String bizDate = SerializationUtils.toJsonString(woffBillBizDates);
                this.invokeWoff(billIds, bizDate);
            } else {
                HashMap<Long, Date> needSelect = new HashMap<Long, Date>(2);
                needSelect.put(billId, bookDate);
                HashMap<Long, Date> billOrgDate = new HashMap<Long, Date>(2);
                billOrgDate.put(billId, orgCurDate);
                this.showWoffConfirm("needselect2", needSelect, billIds, billOrgDate, orgIdToCurDateMap);
            }
        }
    }

    private void showWoffConfirm(String type, Map<Long, Date> bookDate, List<Object> ids, Map<Long, Date> billOrgDate, Map<Long, Date> orgIdToCurDateMap) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        if ("needselect1".equals(type)) {
            parameter.setCustomParam("needSettle1", bookDate);
        } else {
            parameter.setCustomParam("needSettle2", bookDate);
        }
        parameter.setCustomParam("billorgdate", billOrgDate);
        parameter.setCustomParam("ids", ids);
        parameter.setFormId("ap_offset_date");
        parameter.setCustomParam("operation", (Object)"batchwoff");
        parameter.setCustomParam("orgcurdate", orgIdToCurDateMap);
        parameter.setCustomParam("entityflag", (Object)"ar");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "woff"));
        this.getView().showForm(parameter);
    }

    private void invokeWoff(List<Object> busIds, String bizDate) {
        String ids = SerializationUtils.toJsonString(busIds);
        OperateOption option = OperateOption.create();
        option.setVariableValue("entity", "ar_busbill");
        option.setVariableValue("ids", ids);
        option.setVariableValue("bizdate", bizDate);
        this.getView().invokeOperation("batchwoff", option);
    }

    private void calculateHeadAmt() {
        IDataModel m = this.getModel();
        int count = m.getEntryRowCount("entry");
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localamt = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxlocamt = BigDecimal.ZERO;
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        BigDecimal pricetaxtotallocal = BigDecimal.ZERO;
        BigDecimal uninvoicedlocamt = BigDecimal.ZERO;
        BigDecimal uninvoicedamt = BigDecimal.ZERO;
        BigDecimal unwoffamt = BigDecimal.ZERO;
        BigDecimal unwofflocamt = BigDecimal.ZERO;
        BigDecimal unrelateinvamt = BigDecimal.ZERO;
        BigDecimal unrelateinvlocamt = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            amount = amount.add((BigDecimal)m.getValue("e_amount", i));
            localamt = localamt.add((BigDecimal)m.getValue("e_localamt", i));
            tax = tax.add((BigDecimal)m.getValue("e_tax", i));
            taxlocamt = taxlocamt.add((BigDecimal)m.getValue("e_taxlocalamt", i));
            pricetaxtotal = pricetaxtotal.add((BigDecimal)m.getValue("e_recamount", i));
            pricetaxtotallocal = pricetaxtotallocal.add((BigDecimal)m.getValue("e_reclocalamt", i));
            uninvoicedlocamt = uninvoicedlocamt.add((BigDecimal)m.getValue("e_uninvoicedlocamt", i));
            uninvoicedamt = uninvoicedamt.add((BigDecimal)m.getValue("e_uninvoicedamt", i));
            unwoffamt = unwoffamt.add((BigDecimal)m.getValue("e_unwoffamt", i));
            unwofflocamt = unwofflocamt.add((BigDecimal)m.getValue("e_unwofflocamt", i));
            unrelateinvamt = unrelateinvamt.add((BigDecimal)m.getValue("e_unrelateinvamt", i));
            unrelateinvlocamt = unrelateinvlocamt.add((BigDecimal)m.getValue("e_unrelateinvlocamt", i));
        }
        m.setValue("amount", (Object)amount);
        m.setValue("localamt", (Object)localamt);
        m.setValue("tax", (Object)tax);
        m.setValue("taxlocamt", (Object)taxlocamt);
        m.setValue("recamount", (Object)pricetaxtotal);
        m.setValue("reclocalamt", (Object)pricetaxtotallocal);
        m.setValue("uninvoicedamt", (Object)uninvoicedamt);
        m.setValue("uninvoicedlocamt", (Object)uninvoicedlocamt);
        m.setValue("unwoffamt", (Object)unwoffamt);
        m.setValue("unwofflocamt", (Object)unwofflocamt);
        m.setValue("unwoffnotaxamt", (Object)amount);
        m.setValue("unwoffnotaxlocamt", (Object)localamt);
        m.setValue("unwofftax", (Object)tax);
        m.setValue("unwofftaxlocal", (Object)taxlocamt);
        m.setValue("unrelateinvamt", (Object)unrelateinvamt);
        m.setValue("unrelateinvlocamt", (Object)unrelateinvlocamt);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        EditInBulkService editInBulkService = new EditInBulkService(this.getView(), this.getPluginName());
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "editsettingsinbulk": {
                editInBulkService.showEditSettingsInBulk();
                break;
            }
            case "editinbulk": {
                boolean includeTax = (Boolean)this.getModel().getValue("isincludetax");
                if (!includeTax) break;
                editInBulkService.showEditInBulk();
                break;
            }
            case "bar_save4woff": {
                OperateOption option = OperateOption.create();
                option.setVariableValue("isselfwoff", "true");
                this.getView().invokeOperation("save", option);
                break;
            }
            case "totaldiscount": {
                DiscountAmtHelper totalService = new DiscountAmtHelper();
                totalService.discountShowForm(this.getView(), (AbstractBillPlugIn)this, BillModelFactory.getModel((String)"ar_busbill"));
                break;
            }
            case "barbatchwoff": {
                ArrayList<Object> idList = new ArrayList<Object>(2);
                idList.add(this.getModel().getDataEntity().getPkValue());
                String message = MoveEasCommonHelper.fromEasNotAllowedWrittenOff((String)"ar_busbill", idList);
                if (!"".equals(message)) {
                    this.getView().showTipNotification(message);
                    return;
                }
                this.woffBusBIlls();
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        int rowIndex = e.getRowIndex();
        switch (key) {
            case "e_discountrate": {
                if (ObjectUtils.isEmpty((Object)value)) {
                    return;
                }
                this.verifyDiscountRate(new BigDecimal(value.toString()), rowIndex, e);
            }
        }
    }

    private void verifyDiscountRate(BigDecimal discountRate, int rowIndex, BeforeFieldPostBackEvent e) {
        if (discountRate.compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u5b57\u3002", (String)"BusArBillEdit_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            this.getView().updateView("e_discountrate", rowIndex);
            return;
        }
        if (DiscountModeEnum.PERCENT.getValue().equals(this.getModel().getValue("e_discountmode", rowIndex))) {
            if (discountRate.compareTo(new BigDecimal(100)) == 0 && ((Boolean)this.getModel().getValue("ispricetotal")).booleanValue()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BusArBillEdit_10", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView("e_discountrate", rowIndex);
                return;
            }
            if (discountRate.compareTo(new BigDecimal(100)) > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6570\u5b57\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"BusArBillEdit_4", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView("e_discountrate", rowIndex);
                return;
            }
        }
    }

    private void setReceivingcond(Object newValue) {
        if (newValue == null) {
            this.getModel().setValue("paycond", null);
        } else {
            DynamicObject asstact = (DynamicObject)newValue;
            DynamicObject asstactFieldValue = QueryServiceHelper.queryOne((String)"bd_customer", (String)"receivingcondid", (QFilter[])new QFilter[]{new QFilter("id", "=", asstact.getPkValue())});
            if (asstactFieldValue == null) {
                this.getModel().setValue("paycond", null);
                return;
            }
            long paycondId = asstactFieldValue.getLong("receivingcondid");
            if (paycondId == 0L) {
                this.getModel().setValue("paycond", null);
                return;
            }
            boolean exists = QueryServiceHelper.exists((String)"bd_reccondition", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)paycondId), new QFilter("enable", "=", (Object)Boolean.TRUE)});
            if (exists) {
                this.getModel().setValue("paycond", (Object)paycondId);
            } else {
                this.getModel().setValue("paycond", null);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)"SZJK-PRE-0057");
        }
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String key = operate.getOperateKey();
        if (Objects.equals("copyentryrow", key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u5206\u5f55\u590d\u5236\u3002", (String)"BusArBillEdit_7", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            boolean isPriceTotal = (Boolean)this.getModel().getValue("ispricetotal");
            String discountType = (String)this.getModel().getValue("e_discountmode", entryCurrentRowIndex);
            BigDecimal discountRate = (BigDecimal)this.getModel().getValue("e_discountrate", entryCurrentRowIndex);
            boolean isPresent = (Boolean)this.getModel().getValue("e_ispresent", entryCurrentRowIndex);
            if (isPriceTotal && "PERCENT".equals(discountType) && new BigDecimal("100").compareTo(discountRate) == 0 && !isPresent) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u542b\u7a0e\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539", (String)"PriceTaxTotalCalculator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.isCopyEntryRow = true;
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int index;
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        if (this.isCopyEntryRow && "entry".equals(entryProp.getName())) {
            for (RowDataEntity rowEntity : e.getRowDataEntities()) {
                index = rowEntity.getRowIndex();
                this.calculateRow(this.getModel(), index, "", BigDecimal.ZERO, false);
                BigDecimal qty = (BigDecimal)this.getModel().getValue("e_quantity", index);
                this.getModel().setValue("e_uninvoicedqty", (Object)qty, index);
                this.getModel().setValue("e_unwoffqty", (Object)qty, index);
                this.getModel().setValue("e_unconfirmqty", (Object)qty, index);
                this.getModel().setValue("e_unrelateinvqty", (Object)qty, index);
            }
        }
        if ("entry".equals(entryProp.getName())) {
            for (RowDataEntity rowEntity : e.getRowDataEntities()) {
                index = rowEntity.getRowIndex();
                if (this.isCopyEntryRow) continue;
                if (this.customersMap == null || this.customersMap.size() == 0) {
                    this.customersMap = FinArBillHelper.setCustomersToViewCash((IDataModel)this.getModel());
                }
                Object invoiceCustomerId = this.customersMap.get("invoiceCustomerId");
                Object deliverCustomerId = this.customersMap.get("deliverCustomerId");
                if (EmptyUtils.isNotEmpty((Object)invoiceCustomerId) && !"0".equals(invoiceCustomerId)) {
                    this.getModel().setValue("e_invoicecustomerid", invoiceCustomerId, index);
                }
                if (!EmptyUtils.isNotEmpty((Object)deliverCustomerId) || "0".equals(deliverCustomerId)) continue;
                this.getModel().setValue("e_delivercustomerid", deliverCustomerId, index);
            }
        }
    }

    private void filterPayproperty() {
        BasedataEdit paypropertyF7 = (BasedataEdit)this.getControl("payproperty");
        paypropertyF7.addBeforeF7SelectListener(evt -> {
            String billStatus = (String)this.getModel().getValue("billstatus");
            if (!"A".equals(billStatus)) {
                DynamicObject payproperty = (DynamicObject)this.getModel().getValue("payproperty");
                Boolean isbasedonamt = payproperty.getBoolean("isbasedonamt");
                ListFilterParameter lfp = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                lfp.getQFilters().add(new QFilter("isbasedonamt", "=", (Object)isbasedonamt));
            }
        });
    }

    public void afterLoadData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
        Object billStatus = this.getModel().getValue("billstatus");
        if ("B".equals(billStatus) || "A".equals(billStatus)) {
            Map sameBillInfo = (Map)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0071", new HashMap(2), (Object[])new Object[]{this.getModel().getDataEntity(true)});
            this.sameBillWarn(sameBillInfo);
        }
    }

    private void sameBillWarn(Map<String, List<String>> sameBillInfo) {
        if (sameBillInfo == null || sameBillInfo.isEmpty()) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"sameinfoflex"});
        ArrayList<List<String>> sameBillNos = new ArrayList<List<String>>(sameBillInfo.values());
        Label label = (Label)this.getView().getControl("sameinfo_labelap");
        String message = ResManager.loadKDString((String)"\u91cd\u590d\u5355\u636e\u98ce\u9669\u63d0\u9192\uff1a", (String)"FinArBillEdit_45", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        String billName = ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536", (String)"BusArBillEdit_14", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        label.setText(message.concat(ExecCtrlHelper.getSameBillMessage((List)((List)sameBillNos.get(0)), (String)billName)));
    }
}

