/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.botp.cv;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.ar.util.GBKUtils;

public class ArBill2OriginalBillCommonUtil {
    private static final BigDecimal TAX_RATE_10 = new BigDecimal("0.10");
    private static final Log LOGGER = LogFactory.getLog(ArBill2OriginalBillCommonUtil.class);
    public static final String DIRECT = "0";
    public static final String INDIRECT = "1";
    public static final String TRUE = "1";
    public static final String BOTH_ITEM_EXIST_CHOOSE_EXPENSE = "1";
    private static final String NUMBER = "number";
    private static final String ONE_2_ONE = "OneToOne";
    private static final int IMC_AMT_PRECISION = 2;
    private static final int IMC_NUM_PRECISION = 8;
    private static final String ALL_E_SPECIAL = "08xdp";
    private static final String ALL_E_NORMAL = "10xdp";
    private Map<Object, DynamicObject> bdmOrgMap = new HashMap<Object, DynamicObject>(16);
    private Map<Object, DynamicObject> erPayeeMap = new HashMap<Object, DynamicObject>(16);
    private Map<Object, DynamicObject> asstactMap = new HashMap<Object, DynamicObject>(16);

    public void checkGroupByRule(AbstractConvertPlugIn plugin) {
        String groupMode2 = plugin.getRule().getGroupByPolicy().getGroupMode2();
        String groupMode3 = plugin.getRule().getGroupByPolicy().getGroupMode3();
        if (ONE_2_ONE.equalsIgnoreCase(groupMode2) || ONE_2_ONE.equalsIgnoreCase(groupMode3)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u6536\u4e0b\u63a8\u9700\u8981\u8bb0\u5f55\u660e\u7ec6\u5173\u7cfb\uff0c\u6240\u4ee5\u6682\u4e0d\u652f\u6301\u660e\u7ec6\u5408\u5e76\uff0c\u8bf7\u4fee\u6539\u201c\u8f6c\u6362\u89c4\u5219>\u5206\u5355\u5408\u5e76>\u5355\u636e\u4f53\u6216\u5b50\u5355\u636e\u4f53\u5206\u5355\u5408\u5e76\u7b56\u7565\u201d\u3002", (String)"ArBill2OriginalBillCommonUtil_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
    }

    public String getEntryItemType(DynamicObject billTypeDO) {
        String billTypeNum;
        String itemTypeName = "e_expenseitem";
        if (billTypeDO != null && ("arfin_standard_BT_S".equals(billTypeNum = billTypeDO.getString(NUMBER)) || "arfin_expense_BT_S".equals(billTypeNum) || "arfin_sersal_BT_S".equals(billTypeNum))) {
            itemTypeName = "e_material";
        }
        return itemTypeName;
    }

    public void setBillNoByDB(DynamicObject dataEntity) {
        if (!dataEntity.getDataEntityState().getFromDatabase()) {
            dataEntity.set("billno", (Object)UUID.randomUUID().toString());
        }
    }

    public void fillSourceMap(ExtendedDataEntity[] extendedDataEntities, Map<String, DynamicProperty> srcfldPro, HashMap<Object, DynamicObject> sourceMap, HashMap<Object, Map<Object, DynamicObject>> sourceItemMap, String srcBillName) {
        DynamicObject[] sourceBills;
        HashSet<Object> sourceBillPks = new HashSet<Object>();
        for (ExtendedDataEntity entity : extendedDataEntities) {
            List sourceBillRows = (List)entity.getValue("ConvertSource");
            for (DynamicObject sourceBillRow : sourceBillRows) {
                sourceBillPks.add(srcfldPro.get("id").getValue((Object)sourceBillRow));
            }
        }
        for (DynamicObject sourceBill : sourceBills = BusinessDataServiceHelper.load((Object[])sourceBillPks.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)srcBillName))) {
            sourceMap.put(sourceBill.getPkValue(), sourceBill);
            DynamicObjectCollection entry = sourceBill.getDynamicObjectCollection("entry");
            HashMap<Object, DynamicObject> itemMap = new HashMap<Object, DynamicObject>();
            for (DynamicObject item : entry) {
                itemMap.put(item.getPkValue(), item);
            }
            sourceItemMap.put(sourceBill.getPkValue(), itemMap);
        }
    }

    public void fillSourceMap2(ExtendedDataEntity[] extendedDataEntities, Map<String, DynamicProperty> srcfldPro, HashMap<Object, DynamicObject> sourceMap, String srcBillName) {
        DynamicObject[] sourceBills;
        HashSet<Object> sourceBillPks = new HashSet<Object>();
        for (ExtendedDataEntity entity : extendedDataEntities) {
            List sourceBillRows = (List)entity.getValue("ConvertSource");
            for (DynamicObject sourceBillRow : sourceBillRows) {
                sourceBillPks.add(srcfldPro.get("id").getValue((Object)sourceBillRow));
            }
        }
        String fields = "org,asstact,asstacttype,recamount";
        for (DynamicObject sourceBill : sourceBills = BusinessDataServiceHelper.load((String)srcBillName, (String)fields, (QFilter[])new QFilter("id", "in", sourceBillPks).toArray())) {
            sourceMap.put(sourceBill.getPkValue(), sourceBill);
        }
    }

    public DynamicObject createNewRow(int seqIncrement, DynamicObject tgtEntryRow, BigDecimal discountAmtWithTax, BigDecimal discountAmount, BigDecimal discountTax, DynamicObjectCollection itemsNews, Boolean hsbzFlag) {
        DynamicObject newRow = (DynamicObject)OrmUtils.clone((IDataEntityBase)tgtEntryRow, (boolean)false, (boolean)true);
        BigDecimal discountAmtWithTaxNow = this.getRealValue(discountAmtWithTax.negate(), 2);
        BigDecimal discountAmountNow = this.getRealValue(discountAmount.negate(), 2);
        BigDecimal discountTaxNow = this.getRealValue(discountTax.negate(), 2);
        newRow.set("taxamount", (Object)discountAmtWithTaxNow);
        newRow.set("oritaxamount", (Object)discountAmtWithTaxNow);
        newRow.set("amount", (Object)discountAmountNow);
        newRow.set("tax", (Object)discountTaxNow);
        newRow.set("taxrate", tgtEntryRow.get("taxrate"));
        newRow.set("rowtype", (Object)"1");
        newRow.set("seq", (Object)seqIncrement);
        newRow.set("unitprice", (Object)"");
        newRow.set("taxunitprice", (Object)"");
        newRow.set("num", (Object)"");
        newRow.set("unit", (Object)"");
        newRow.set("oriunit", (Object)"");
        newRow.set("specification", (Object)"");
        newRow.set("orispecification", (Object)"");
        newRow.set("fromtaxprice", null);
        newRow.set("oriunitprice", null);
        newRow.set("fromprice", null);
        newRow.set("discountmode", null);
        if (hsbzFlag.booleanValue()) {
            newRow.set("remainvalidamount", (Object)discountAmtWithTaxNow);
        } else {
            newRow.set("remainvalidamount", (Object)discountAmountNow);
        }
        newRow.set("remainvalidtax", (Object)discountTaxNow);
        newRow.set("orinum", null);
        newRow.set("remainvalidnum", (Object)0);
        newRow.set("combineamount", (Object)0);
        newRow.set("combinelocalamount", (Object)0);
        newRow.set("combinenum", (Object)0);
        newRow.set("discountamount", (Object)0);
        newRow.set("fromdiscountamount", (Object)0);
        if (itemsNews != null) {
            itemsNews.add((Object)newRow);
        }
        return newRow;
    }

    public void dealItemFromInfo(DynamicObject sourceEntryRow, DynamicObject newRow, BigDecimal itemTaxRate, DynamicObject tgtEntryRow, DynamicObject fromCurrency) {
        int amtprecision = fromCurrency.getInt("amtprecision");
        BigDecimal sourceRowFromDiscountTaxAmount = sourceEntryRow.getBigDecimal("e_discountamount").setScale(amtprecision, RoundingMode.HALF_UP);
        newRow.set("fromtaxamount", (Object)sourceRowFromDiscountTaxAmount.negate());
        BigDecimal sourceRowFromDiscountAmount = sourceRowFromDiscountTaxAmount.multiply(BigDecimal.ONE.divide(BigDecimal.ONE.add(itemTaxRate), 20, RoundingMode.HALF_UP)).setScale(amtprecision, RoundingMode.HALF_UP);
        BigDecimal sourceRowFromDiscountTax = sourceRowFromDiscountTaxAmount.subtract(sourceRowFromDiscountAmount);
        newRow.set("fromtax", (Object)sourceRowFromDiscountTax.negate());
        newRow.set("fromamount", (Object)sourceRowFromDiscountAmount.negate());
        newRow.set("fromdiscountamount", null);
        tgtEntryRow.set("fromdiscountamount", null);
    }

    public void dealItemFromInfo(DynamicObject newRow, BigDecimal itemTaxRate, DynamicObject tgtEntryRow, DynamicObject fromCurrency) {
        int amtprecision = fromCurrency.getInt("amtprecision");
        BigDecimal sourceRowFromDiscountTaxAmount = tgtEntryRow.getBigDecimal("fromdiscountamount").setScale(amtprecision, RoundingMode.HALF_UP);
        newRow.set("fromtaxamount", (Object)sourceRowFromDiscountTaxAmount.negate());
        BigDecimal sourceRowFromDiscountAmount = sourceRowFromDiscountTaxAmount.multiply(BigDecimal.ONE.divide(BigDecimal.ONE.add(itemTaxRate), 20, RoundingMode.HALF_UP)).setScale(amtprecision, RoundingMode.HALF_UP);
        BigDecimal sourceRowFromDiscountTax = sourceRowFromDiscountTaxAmount.subtract(sourceRowFromDiscountAmount);
        newRow.set("fromtax", (Object)sourceRowFromDiscountTax.negate());
        newRow.set("fromamount", (Object)sourceRowFromDiscountAmount.negate());
        newRow.set("fromdiscountamount", null);
        tgtEntryRow.set("fromdiscountamount", null);
    }

    public void setCurrencyAndAmount(ExtendedDataEntity entity, DynamicObject sourceObj, BigDecimal invoiceAmount, BigDecimal totalTax) {
        entity.setValue("currency", (Object)sourceObj.getDynamicObject("currency").getLocaleString("name").getLocaleValue());
        entity.setValue("exchangedate", (Object)sourceObj.getDate("exratedate"));
        entity.setValue("exchangerate", (Object)this.getRealValue(sourceObj.getBigDecimal("exchangerate"), 6));
        BigDecimal amount = this.getRealValue(invoiceAmount, 2);
        BigDecimal tax = this.getRealValue(totalTax, 2);
        BigDecimal total = amount.add(tax);
        entity.setValue("invoiceamount", (Object)amount);
        entity.setValue("totaltax", (Object)tax);
        entity.setValue("totalamount", (Object)total);
        entity.setValue("oldtotalamount", (Object)total);
        entity.setValue("surplusamount", (Object)this.getRealValue(invoiceAmount, 2));
        entity.setValue("surplustax", (Object)this.getRealValue(totalTax, 2));
        entity.setValue("billproperties", (Object)(invoiceAmount.compareTo(BigDecimal.ZERO) >= 0 ? "1" : "-1"));
    }

    public void setCurrencyAndAmount(ExtendedDataEntity entity, BigDecimal invoiceAmount, BigDecimal totalTax) {
        BigDecimal amount = this.getRealValue(invoiceAmount, 2);
        BigDecimal tax = this.getRealValue(totalTax, 2);
        BigDecimal total = amount.add(tax);
        entity.setValue("invoiceamount", (Object)amount);
        entity.setValue("totaltax", (Object)tax);
        entity.setValue("totalamount", (Object)total);
        entity.setValue("oldtotalamount", (Object)total);
        entity.setValue("surplusamount", (Object)this.getRealValue(invoiceAmount, 2));
        entity.setValue("surplustax", (Object)this.getRealValue(totalTax, 2));
        entity.setValue("billproperties", (Object)(invoiceAmount.compareTo(BigDecimal.ZERO) >= 0 ? "1" : "-1"));
    }

    public BigDecimal calToAmount(String quotation, BigDecimal exrate, BigDecimal fromAmount, DynamicObject fromCurrency) {
        int amtprecision = fromCurrency.getInt("amtprecision");
        if (DIRECT.equals(quotation)) {
            return fromAmount.multiply(exrate).setScale(amtprecision, RoundingMode.HALF_UP);
        }
        if ("1".equals(quotation)) {
            return fromAmount.divide(exrate, amtprecision, RoundingMode.HALF_UP);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6362\u7b97\u65b9\u5f0f\u6709\u8bef", (String)"ArBill2OriginalBillCommonUtil_5", (String)"fi-ar-formplugin", (Object[])new Object[0]));
    }

    public void setHSBZ(ExtendedDataEntity entity, DynamicObject sourceObj) {
        boolean hsbzFlag = sourceObj.getBoolean("isincludetax");
        String hsbz = hsbzFlag ? "1" : DIRECT;
        entity.setValue("hsbz", (Object)hsbz);
    }

    public void setBuyerAndSallerInfo(ExtendedDataEntity entity, DynamicObject sourceObj) {
        DynamicObject org = sourceObj.getDynamicObject("org");
        Object orgObj = entity.getValue("orgid");
        if (null == orgObj) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5\u6620\u5c04", (String)"ArBill2OriginalBillCommonUtil_4", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        Object pkValue = ((DynamicObject)orgObj).getPkValue();
        DynamicObject bdmOrg = this.bdmOrgMap.get(pkValue);
        if (null == bdmOrg) {
            bdmOrg = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"bdm_org");
            this.bdmOrgMap.put(pkValue, bdmOrg);
        }
        if (null == bdmOrg) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6ca1\u6709\u88ab\u5bfc\u5165\u53d1\u7968\u4e91\uff0c\u6240\u9009\u5355\u636e\u4e0d\u80fd\u4e0b\u63a8\u3002", (String)"ArBill2OriginalBillCommonUtil_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), org.getString("name")));
        }
        DynamicObject epBaseInfo = bdmOrg.getDynamicObject("epinfo");
        if (ObjectUtils.isEmpty((Object)epBaseInfo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u5355\u636e\u7684\u7ed3\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u5148\u5728\u201c\u53d1\u7968\u4e91>\u57fa\u7840\u8d44\u6599>\u4f01\u4e1a\u7ba1\u7406\u201d\u4e2d\u5f15\u7528\u3002", (String)"ArBill2OriginalBillCommonUtil_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        String saleTaxNo = epBaseInfo.getString(NUMBER);
        String saleName = epBaseInfo.getString("name");
        String saleInvoiceaddr = epBaseInfo.getString("invoiceaddr");
        String saleOpenuserbank = epBaseInfo.getString("openuserbank");
        entity.setValue("salername", (Object)saleName);
        entity.setValue("salertaxno", (Object)saleTaxNo);
        if (StringUtils.isBlank((Object)entity.getValue("salerbank"))) {
            entity.setValue("salerbank", (Object)saleOpenuserbank);
        }
        if (StringUtils.isBlank((Object)entity.getValue("saleraddr"))) {
            entity.setValue("saleraddr", (Object)saleInvoiceaddr);
        }
        DynamicObject asstact = sourceObj.getDynamicObject("asstact");
        Object buyerName = entity.getValue("buyername");
        String buyerProperty = null;
        if (asstact != null) {
            if (StringUtils.isBlank((Object)buyerName)) {
                entity.setValue("buyername", (Object)asstact.getLocaleString("name").getLocaleValue());
            }
            if ("bos_user".equals(sourceObj.get("asstacttype"))) {
                entity.setValue("buyertaxno", null);
                DynamicObject erPayeeInfo = this.getErPayeeInfo(asstact.getLong("id"), asstact.getString("name"));
                if (erPayeeInfo != null && null != erPayeeInfo.getDynamicObject("payerbank")) {
                    String payerBank = erPayeeInfo.getDynamicObject("payerbank").getString("name");
                    String payerAccount = erPayeeInfo.getString("payeraccount");
                    if (StringUtils.isBlank((Object)entity.getValue("buyerbank"))) {
                        entity.setValue("buyerbank", (Object)this.concat(payerBank, payerAccount));
                    }
                }
                buyerProperty = "1";
            } else {
                String txRegisterNo;
                String invoiceReceiverKey;
                String type;
                DynamicObject value;
                String asstacttype = sourceObj.getString("asstacttype");
                String key = sourceObj.getString("asstacttype") + asstact.getLong("id");
                if ("bd_customer".equals(asstacttype)) {
                    value = this.asstactMap.get(key);
                    if (null == value) {
                        asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)asstact.getLong("id"), (String)sourceObj.getString("asstacttype"), (String)"tx_register_no,bizpartner_address,bizpartner_phone, entry_bank, entry_bank.bankaccount,societycreditcode, entry_bank.bank, entry_bank.isdefault_bank,invoicecustomerid,type");
                        this.asstactMap.put(key, asstact);
                    } else {
                        asstact = value;
                    }
                    type = "invoicecustomerid";
                } else {
                    value = this.asstactMap.get(key);
                    if (null == value) {
                        asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)asstact.getLong("id"), (String)sourceObj.getString("asstacttype"), (String)"tx_register_no,bizpartner_address,bizpartner_phone, entry_bank, entry_bank.bankaccount,societycreditcode, entry_bank.bank, entry_bank.isdefault_bank,invoicesupplierid,type");
                        this.asstactMap.put(key, asstact);
                    } else {
                        asstact = value;
                    }
                    type = "invoicesupplierid";
                }
                DynamicObject invoiceCustomer = asstact.getDynamicObject(type);
                if (null != invoiceCustomer && null == (asstact = this.asstactMap.get(invoiceReceiverKey = sourceObj.getString("asstacttype") + invoiceCustomer.getLong("id")))) {
                    asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)invoiceCustomer.getLong("id"), (String)sourceObj.getString("asstacttype"), (String)"tx_register_no,bizpartner_address,bizpartner_phone, entry_bank, entry_bank.bankaccount,societycreditcode, entry_bank.bank, entry_bank.isdefault_bank,invoicesupplierid,type");
                    this.asstactMap.put(invoiceReceiverKey, asstact);
                }
                if (StringUtils.isBlank((CharSequence)(txRegisterNo = asstact.getString("tx_register_no")))) {
                    txRegisterNo = asstact.getString("societycreditcode");
                }
                if (StringUtils.isBlank((Object)entity.getValue("buyername"))) {
                    entity.setValue("buyername", (Object)asstact.getLocaleString("name").getLocaleValue());
                }
                entity.setValue("customname", (Object)asstact.getLocaleString("name").getLocaleValue());
                if (StringUtils.isBlank((Object)entity.getValue("buyertaxno"))) {
                    entity.setValue("buyertaxno", (Object)txRegisterNo);
                }
                String bizpartner_address = asstact.getLocaleString("bizpartner_address").getLocaleValue_zh_CN();
                String bizpartner_phone = asstact.getString("bizpartner_phone");
                if (StringUtils.isBlank((Object)entity.getValue("buyeraddr"))) {
                    entity.setValue("buyeraddr", (Object)this.concat(bizpartner_address, bizpartner_phone));
                }
                this.setBankInfo(entity, asstact);
                buyerProperty = "4".equals(asstact.get("type")) ? "1" : DIRECT;
            }
        }
        entity.setValue("buyerproperty", buyerProperty);
    }

    public void setBankInfo(ExtendedDataEntity entity, DynamicObject asstact) {
        if (StringUtils.isNotBlank((Object)entity.getValue("buyerbank"))) {
            return;
        }
        String acctBank = null;
        String bank = null;
        DynamicObjectCollection bankColls = asstact.getDynamicObjectCollection("entry_bank");
        if (bankColls != null && bankColls.size() > 0) {
            if (bankColls.size() == 1) {
                DynamicObject bankInfo = (DynamicObject)bankColls.get(0);
                acctBank = bankInfo.getString("bankaccount");
                bank = bankInfo.getString("bank.name");
            } else {
                for (int i = 0; i < bankColls.size(); ++i) {
                    DynamicObject bankInfo = (DynamicObject)bankColls.get(i);
                    if (bankInfo.getBoolean("isdefault_bank")) {
                        acctBank = bankInfo.getString("bankaccount");
                        bank = bankInfo.getString("bank.name");
                        break;
                    }
                    if (i != 0) continue;
                    acctBank = bankInfo.getString("bankaccount");
                    bank = bankInfo.getString("bank.name");
                }
            }
        }
        entity.setValue("buyerbank", (Object)this.concat(bank, acctBank));
    }

    public DynamicObject getErPayeeInfo(long userId, String name) {
        String key = name + userId;
        DynamicObject obj = this.erPayeeMap.get(key);
        if (null != obj) {
            return obj;
        }
        DynamicObject dynamicObject = null;
        QFilter uFilter = new QFilter("name", "=", (Object)name);
        uFilter = uFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        uFilter.and(new QFilter("payer", "=", (Object)userId));
        QFilter[] qFilters = new QFilter[]{uFilter};
        String selectFields = "id,name,payer,payeraccount,payeraccount01,payeraccount02,payerbank_id,payerbank.name,payerbank.number";
        String orderBys = "isdefault desc";
        DynamicObject[] defaultAccounts = BusinessDataServiceHelper.load((String)"er_payeer", (String)selectFields, (QFilter[])qFilters, (String)orderBys, (int)1);
        if (defaultAccounts != null && defaultAccounts.length > 0) {
            dynamicObject = defaultAccounts[0];
        }
        this.erPayeeMap.put(key, dynamicObject);
        return dynamicObject;
    }

    public void setItemTaxClass(String matchType, DynamicObject sourceEntryRow, DynamicObject tgtEntryRow) {
        DynamicObject meterial = sourceEntryRow.getDynamicObject("e_material");
        if (null != meterial) {
            tgtEntryRow.set("spbm", (Object)meterial.getString(NUMBER));
        }
    }

    public BigDecimal execTaxRate(String taxRateStr) {
        BigDecimal taxRateBig = null;
        if (taxRateStr != null && !taxRateStr.trim().equals("") && (taxRateBig = new BigDecimal(taxRateStr).stripTrailingZeros()).compareTo(TAX_RATE_10) == 0) {
            taxRateBig = TAX_RATE_10;
        }
        return taxRateBig;
    }

    public BigDecimal getRealValue(BigDecimal srcVal, int scale) {
        BigDecimal tgtVal = BigDecimal.ZERO;
        if (srcVal.compareTo(tgtVal) == 0) {
            return tgtVal;
        }
        if (scale < 0) {
            return srcVal;
        }
        return srcVal.setScale(scale, RoundingMode.HALF_UP);
    }

    public void setConstantData(DynamicObject dataEntity, DynamicObject dataEntityNew) {
        if (dataEntityNew == null) {
            if (StringUtils.isBlank((Object)dataEntity.get("systemsource"))) {
                dataEntity.set("systemsource", (Object)"AR_FINARBILL");
            }
            dataEntity.set("createdate", (Object)new Date());
        } else {
            dataEntity.set("confirmstate", dataEntityNew.get("confirmstate"));
            dataEntity.set("validstate", dataEntityNew.get("validstate"));
            dataEntity.set("split", dataEntityNew.get("split"));
            dataEntity.set("priority", dataEntityNew.get("priority"));
            dataEntity.set("taxationstyle", dataEntityNew.get("taxationstyle"));
            dataEntity.set("billsource", dataEntityNew.get("billsource"));
            dataEntity.set("splitormergeflag", dataEntityNew.get("splitormergeflag"));
            dataEntity.set("biztype", dataEntityNew.get("biztype"));
            dataEntity.set("producttype", dataEntityNew.get("producttype"));
        }
    }

    public String concat(String start, String end) {
        if (null == start) {
            return end;
        }
        if (null == end) {
            return start;
        }
        return start + end;
    }

    public void setRemark(DynamicObject dataEntity) {
        String remarkStr = dataEntity.getString("invoiceremark");
        if (StringUtils.isBlank((CharSequence)remarkStr)) {
            return;
        }
        String invoiceType = dataEntity.getString("invoicetype");
        if (this.isAllEInvoice(invoiceType)) {
            if (remarkStr.length() > 200) {
                remarkStr = remarkStr.substring(0, 200);
            }
        } else if (GBKUtils.getGBKLength((String)remarkStr) > 230) {
            remarkStr = GBKUtils.splitAndBuildGbkStr((String)remarkStr, (int)230);
        }
        dataEntity.set("invoiceremark", (Object)remarkStr);
    }

    private boolean isAllEInvoice(String invoiceType) {
        return ALL_E_SPECIAL.equals(invoiceType) || ALL_E_NORMAL.equals(invoiceType);
    }

    public void setOriginalBillValueByInvoke(List<DynamicObject> dataEntitys) {
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"OBBotpConvertServiceImpl", (String)"originalBillsBotpConvert", (Object[])new Object[]{dataEntitys});
        this.setMatchedData(dataEntitys, map);
    }

    public void setMatchedData(List<DynamicObject> dataEntitys, Map<Object, DynamicObject> map) {
        for (DynamicObject dataEntity : dataEntitys) {
            String billNo = dataEntity.getString("billno");
            DynamicObject dataEntityNew = map.get(billNo);
            dataEntity.set("buyername", dataEntityNew.get("buyername"));
            dataEntity.set("buyertaxno", dataEntityNew.get("buyertaxno"));
            dataEntity.set("buyerbank", dataEntityNew.get("buyerbank"));
            dataEntity.set("buyeraddr", dataEntityNew.get("buyeraddr"));
            dataEntity.set("buyerphone", dataEntityNew.get("buyerphone"));
            dataEntity.set("buyeremail", dataEntityNew.get("buyeremail"));
            dataEntity.set("buyerproperty", dataEntityNew.get("buyerproperty"));
            dataEntity.set("salername", dataEntityNew.get("salername"));
            dataEntity.set("salertaxno", dataEntityNew.get("salertaxno"));
            dataEntity.set("iselepaper", dataEntityNew.get("iselepaper"));
            dataEntity.set("salerbank", dataEntityNew.get("salerbank"));
            dataEntity.set("saleraddr", dataEntityNew.get("saleraddr"));
            dataEntity.set("drawer", dataEntityNew.get("drawer"));
            dataEntity.set("payee", dataEntityNew.get("payee"));
            dataEntity.set("reviewer", dataEntityNew.get("reviewer"));
            dataEntity.set("specialtype", dataEntityNew.get("specialtype"));
            dataEntity.set("jqbh", dataEntityNew.get("jqbh"));
            dataEntity.set("invoiceamount", dataEntityNew.get("invoiceamount"));
            dataEntity.set("totaltax", dataEntityNew.get("totaltax"));
            dataEntity.set("totalamount", dataEntityNew.get("totalamount"));
            dataEntity.set("mergerule", dataEntityNew.get("mergerule"));
            dataEntity.set("splitrule", dataEntityNew.get("splitrule"));
            dataEntity.set("surplusamount", dataEntityNew.get("surplusamount"));
            dataEntity.set("surplustax", dataEntityNew.get("surplustax"));
            dataEntity.set("billproperties", dataEntityNew.get("billproperties"));
            dataEntity.set("oldtotalamount", dataEntityNew.get("oldtotalamount"));
            dataEntity.set("foreigninvoiceamount", dataEntityNew.get("foreigninvoiceamount"));
            dataEntity.set("foreigntax", dataEntityNew.get("foreigntax"));
            dataEntity.set("foreigntotalamount", dataEntityNew.get("foreigntotalamount"));
            dataEntity.set("invoiceremark", dataEntityNew.get("invoiceremark"));
            dataEntity.set("sim_original_bill_item", dataEntityNew.get("sim_original_bill_item"));
            dataEntity.set("iselepaper", dataEntityNew.get("iselepaper"));
            this.setConstantData(dataEntity, dataEntityNew);
            if (dataEntity.getDataEntityState().getFromDatabase()) continue;
            dataEntity.set("billno", null);
        }
    }

    public static boolean isPushPresent() {
        QFilter filter = new QFilter("config_key", "=", (Object)"ArBillPushPresent");
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"invsm_param_configuration", (String)"config_type,config_key,config_value", (QFilter[])new QFilter[]{filter});
        if (collection.length == 0) {
            return false;
        }
        String configValue = collection[0].getString("config_value");
        return "1".equals(configValue);
    }

    public static void addFilterAndQueryFields(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("invoicedamt");
        e.addSrcField("uninvoicedamt");
        e.addSrcField("e_issueinvqty");
        e.addSrcField("e_remark");
        e.addSrcField("e_creator");
        e.addSrcField("e_unitprice");
        e.addSrcField("taxrateid");
        e.addSrcField("id");
        e.addSrcField("e_measureunit.name");
        e.addSrcField("e_spectype");
        e.addSrcField("e_expenseitem.name");
        e.addSrcField("e_material.name");
        e.addSrcField("e_quantity");
        e.addSrcField("e_taxrate");
        e.addSrcField("e_discountmode");
        e.addSrcField("e_material");
        e.addSrcField("e_material.number");
        e.addSrcField("e_amount");
        e.addSrcField("e_uninvoicedamt");
        e.addSrcField("e_discountmode");
        e.addSrcField("e_discountamount");
        e.addSrcField("entry.id");
        e.addSrcField("entry.seq");
        e.addSrcField("billtype.number");
        e.addSrcField("currency");
        e.addSrcField("e_ispresent");
    }

    DynamicObject dealPresentItem(ArBill2OriginalBillCommonUtil handler, boolean isFrom, int seqIncrement, DynamicObject tgtEntryRow, boolean hsbzFlag) {
        DynamicObject discountRowNew;
        BigDecimal amount = tgtEntryRow.getBigDecimal("amount");
        BigDecimal tax = tgtEntryRow.getBigDecimal("tax");
        BigDecimal amountWithTax = tgtEntryRow.getBigDecimal("taxamount");
        if (isFrom) {
            BigDecimal fromTaxAmount = tgtEntryRow.getBigDecimal("fromtaxamount");
            BigDecimal fromAmount = tgtEntryRow.getBigDecimal("fromamount");
            BigDecimal fromTax = tgtEntryRow.getBigDecimal("fromtax");
            discountRowNew = handler.createNewRow(seqIncrement, tgtEntryRow, amountWithTax, amount, tax, null, hsbzFlag);
            discountRowNew.set("fromtax", (Object)fromTax.negate());
            discountRowNew.set("fromamount", (Object)fromAmount.negate());
            discountRowNew.set("fromtaxamount", (Object)fromTaxAmount.negate());
        } else {
            discountRowNew = handler.createNewRow(seqIncrement, tgtEntryRow, amountWithTax, amount, tax, null, hsbzFlag);
        }
        return discountRowNew;
    }

    public void dealPresentItem(ArBill2OriginalBillCommonUtil handler, boolean isFrom, ExtendedDataEntity entity, DynamicObjectCollection itemsNews, int seqIncrement, DynamicObject tgtEntryRow, DynamicObject fromCurrency, String quotation, boolean hsbzFlag, BigDecimal unitPrice, BigDecimal num, BigDecimal itemTaxRate) {
        BigDecimal amount = tgtEntryRow.getBigDecimal("amount");
        BigDecimal tax = tgtEntryRow.getBigDecimal("tax");
        BigDecimal amountWithTax = tgtEntryRow.getBigDecimal("taxamount");
        itemsNews.add((Object)tgtEntryRow);
        if (isFrom) {
            BigDecimal fromTaxAmount = tgtEntryRow.getBigDecimal("fromtaxamount");
            BigDecimal fromAmount = tgtEntryRow.getBigDecimal("fromamount");
            BigDecimal fromTax = tgtEntryRow.getBigDecimal("fromtax");
            DynamicObject newRow = handler.createNewRow(seqIncrement, tgtEntryRow, amountWithTax, amount, tax, itemsNews, hsbzFlag);
            newRow.set("fromtax", (Object)fromTax.negate());
            newRow.set("fromamount", (Object)fromAmount.negate());
            newRow.set("fromtaxamount", (Object)fromTaxAmount.negate());
        } else {
            handler.createNewRow(seqIncrement, tgtEntryRow, amountWithTax, amount, tax, itemsNews, hsbzFlag);
        }
    }

    public boolean bothItemExistChooseMaterial(DynamicObject originalBill) {
        String jsonStr = originalBill.getString("botpparamconfig");
        try {
            if (StringUtils.isBlank((CharSequence)jsonStr)) {
                return true;
            }
            jsonStr = '{' + jsonStr.replace("and", ",").replace('=', ':') + '}';
            JSONObject json = JSONObject.parseObject((String)jsonStr);
            return !"1".equals(json.get((Object)"item"));
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"BOTP\u53d6\u503c\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5BOTP\u4e0b\u63a8\u53c2\u6570\u914d\u7f6e\u3002", (String)"ArBill2OriginalBillCommonUtil_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
    }

    public void clear() {
        this.bdmOrgMap.clear();
        this.erPayeeMap.clear();
        this.asstactMap.clear();
    }
}

