/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.eas.helper.MoveEasCommonHelper;
import kd.fi.arapcommon.enums.SettleBillTypeEnum;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.vo.EasSettleRecordContext;

public class EasSettleBillInfoMakeupHelper {
    private static final String PAYBILL_PUR = "cas_paybill_pur_BT_S";
    private static final String PAYBILL_EXP = "cas_paybill_other&settle_BT_S";
    private static final String PAYMENTTYPE_NUM = "202";
    private static final String RECTYPE_NUM = "101";

    public static void settleRecordBillInfoMakeUpByMain(String billEntity, EasSettleRecordContext recordContext, DynamicObject settleRecord) {
        Map<Long, DynamicObject> billMap = recordContext.getBillEntity4BillMap().get(billEntity);
        Map<Long, DynamicObject> billEntryRowMap = recordContext.getBillEntity4EntryMap().get(billEntity);
        DynamicObject bill = billMap.get(settleRecord.getLong("mainbillid"));
        DynamicObject row = billEntryRowMap.get(settleRecord.getLong("mainbillentryid"));
        if (bill == null || row == null) {
            return;
        }
        if ("ap_finapbill".equals(billEntity)) {
            EasSettleBillInfoMakeupHelper.finApInfoMakeupByMain(settleRecord, bill, row);
        } else if ("cas_paybill".equals(billEntity)) {
            EasSettleBillInfoMakeupHelper.casPayInfoMakeupByMain(settleRecord, bill, row);
        } else if ("ar_finarbill".equals(billEntity)) {
            EasSettleBillInfoMakeupHelper.finArInfoMakeupByMain(settleRecord, bill, row);
        } else if ("cas_recbill".equals(billEntity)) {
            EasSettleBillInfoMakeupHelper.casRecInfoMakeupByMain(settleRecord, bill, row);
        } else if ("ap_paidbill".equals(billEntity)) {
            EasSettleBillInfoMakeupHelper.paidBillInfoMakeupByMain(settleRecord, bill, row);
        } else if ("ar_receivedbill".equals(billEntity)) {
            EasSettleBillInfoMakeupHelper.receivedInfoMakeupByMain(settleRecord, bill, row);
        }
    }

    public static void settleRecordBillInfoMakeUpByAsst(String billEntity, EasSettleRecordContext recordContext, List<DynamicObject> asstRecords) {
        Map<Object, Object> billMap = new HashMap(8);
        Map<Object, Object> billEntryRowMap = new HashMap(8);
        if ("ap_liquidation".equals(billEntity) || "ar_liquidation".equals(billEntity)) {
            List<DynamicObject> liquidateBills = recordContext.getNeedSaveOtherBillsMap().get(billEntity);
            for (DynamicObject liquidateBill : liquidateBills) {
                billMap.put(liquidateBill.getLong("id"), liquidateBill);
                DynamicObjectCollection entryEntity = liquidateBill.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : entryEntity) {
                    billEntryRowMap.put(row.getLong("id"), row);
                }
            }
        } else {
            billMap = recordContext.getBillEntity4BillMap().get(billEntity);
            billEntryRowMap = recordContext.getBillEntity4EntryMap().get(billEntity);
        }
        for (DynamicObject recordEntry : asstRecords) {
            DynamicObject bill = (DynamicObject)billMap.get(recordEntry.getLong("billid"));
            DynamicObject row = (DynamicObject)billEntryRowMap.get(recordEntry.getLong("billentryid"));
            if (bill == null || row == null) continue;
            if ("ap_finapbill".equals(billEntity)) {
                EasSettleBillInfoMakeupHelper.finApInfoMakeupByAsst(recordEntry, bill, row);
                continue;
            }
            if ("cas_paybill".equals(billEntity)) {
                EasSettleBillInfoMakeupHelper.casPayInfoMakeupByAsst(recordEntry, bill, row);
                continue;
            }
            if ("ar_finarbill".equals(billEntity)) {
                EasSettleBillInfoMakeupHelper.finArInfoMakeupByAsst(recordEntry, bill, row);
                continue;
            }
            if ("cas_recbill".equals(billEntity)) {
                EasSettleBillInfoMakeupHelper.casRecInfoMakeupByAsst(recordEntry, bill, row);
                continue;
            }
            if ("ap_liquidation".equals(billEntity) || "ar_liquidation".equals(billEntity)) {
                EasSettleBillInfoMakeupHelper.liquidateInfoMakeupByAsst(recordEntry, bill, row);
                continue;
            }
            if ("ap_paidbill".equals(billEntity)) {
                EasSettleBillInfoMakeupHelper.paidBillInfoMakeupByAsst(recordEntry, bill, row);
                continue;
            }
            if (!"ar_receivedbill".equals(billEntity)) continue;
            EasSettleBillInfoMakeupHelper.receivedInfoMakeupByAsst(recordEntry, bill, row);
        }
    }

    public static void liquidateBillInfoMakeUp(DynamicObject liquidateBill, EasSettleRecordContext recordContext) {
        String billEntity = liquidateBill.getString("sourcebilltype");
        Map<Long, DynamicObject> billMap = recordContext.getBillEntity4BillMap().get(billEntity);
        Map<Long, DynamicObject> billEntryRowMap = recordContext.getBillEntity4EntryMap().get(billEntity);
        DynamicObjectCollection entryEntity = liquidateBill.getDynamicObjectCollection("entryentity");
        DynamicObject sourceBill = billMap.get(((DynamicObject)entryEntity.get(0)).getLong("sourcebillid"));
        if ("ap_finapbill".equals(billEntity)) {
            EasSettleBillInfoMakeupHelper.liquidateBillInfoMakeUpByFinAp(liquidateBill, sourceBill, billEntryRowMap);
        } else if ("ar_finarbill".equals(billEntity)) {
            EasSettleBillInfoMakeupHelper.liquidateBillInfoMakeUpByFinAr(liquidateBill, sourceBill, billEntryRowMap);
        } else if ("cas_paybill".equals(billEntity)) {
            EasSettleBillInfoMakeupHelper.liquidateBillInfoMakeUpByCasPay(liquidateBill, sourceBill, billEntryRowMap);
        } else if ("cas_recbill".equals(billEntity)) {
            EasSettleBillInfoMakeupHelper.liquidateBillInfoMakeUpByCasRec(liquidateBill, sourceBill, billEntryRowMap);
        }
        String billNo = CodeRuleServiceHelper.getNumber((String)liquidateBill.getDataEntityType().getName(), (DynamicObject)liquidateBill, (String)liquidateBill.getString("org.id"));
        liquidateBill.set("billno", (Object)billNo);
        ArrayList<Tuple<String, String>> sumAmtFieldList = new ArrayList<Tuple<String, String>>(2);
        sumAmtFieldList.add(Tuple.create((Object)"unsettleamt", (Object)"liquidationamt"));
        sumAmtFieldList.add(Tuple.create((Object)"e_lqdlocalamt", (Object)"liquidationlocalamt"));
        MoveEasCommonHelper.entryAmtSumToHead(liquidateBill, "entryentity", sumAmtFieldList);
        liquidateBill.set("issettled", (Object)Boolean.TRUE);
        liquidateBill.set("description", (Object)ResManager.loadKDString((String)"EAS\u5355\u636e\u7ed3\u7b97\u672a\u6e05\u9879\u3002", (String)"EasSettleBillInfoMakeupHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        liquidateBill.set("billstatus", (Object)"C");
    }

    public static void getBillMapInfo(Map<String, Set<Long>> billEntity4BillIds, EasSettleRecordContext recordContext) {
        if (ObjectUtils.isEmpty(billEntity4BillIds)) {
            return;
        }
        HashMap<String, Map<Long, DynamicObject>> billEntity4BillMap = new HashMap<String, Map<Long, DynamicObject>>(64);
        HashMap<String, Map<Long, DynamicObject>> billEntity4EntryMap = new HashMap<String, Map<Long, DynamicObject>>(64);
        for (Map.Entry<String, Set<Long>> entrySet : billEntity4BillIds.entrySet()) {
            String billEntity = entrySet.getKey();
            Set<Long> billIds = entrySet.getValue();
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)billEntity, (String)EasSettleBillInfoMakeupHelper.getBillSelectors(billEntity), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
            HashMap<Long, DynamicObject> billMap = new HashMap<Long, DynamicObject>(64);
            HashMap<Long, DynamicObject> entryRowMap = new HashMap<Long, DynamicObject>(64);
            for (DynamicObject bill : bills) {
                String entryName = "entry";
                if ("ap_finapbill".equals(billEntity)) {
                    entryName = "detailentry";
                }
                DynamicObjectCollection entry = bill.getDynamicObjectCollection(entryName);
                for (DynamicObject row : entry) {
                    entryRowMap.put(row.getLong("id"), row);
                }
                billMap.put(bill.getLong("id"), bill);
            }
            billEntity4BillMap.put(billEntity, billMap);
            billEntity4EntryMap.put(billEntity, entryRowMap);
        }
        recordContext.setBillEntity4BillMap(billEntity4BillMap);
        recordContext.setBillEntity4EntryMap(billEntity4EntryMap);
    }

    private static void finApInfoMakeupByMain(DynamicObject settleRecord, DynamicObject bill, DynamicObject row) {
        settleRecord.set("billno", bill.get("billno"));
        settleRecord.set("quotation", (Object)"0");
        settleRecord.set("material", row.get("material"));
        settleRecord.set("maincurrency", bill.get("currency"));
        settleRecord.set("mainbizdate", bill.get("bizdate"));
        long billType = bill.getLong("billtypeid.id");
        String billTypeEnum = (String)BillTypeConsts.getBillTypeMap().get(billType);
        if (ObjectUtils.isEmpty((Object)billTypeEnum)) {
            billTypeEnum = bill.getString("billtypeid.number");
        }
        settleRecord.set("mainbilltype", (Object)billTypeEnum);
        settleRecord.set("mainasstacttype", bill.get("asstacttype"));
        settleRecord.set("mainasstactid", bill.get("asstact"));
        settleRecord.set("mainasstact", bill.get("asstact.name"));
        settleRecord.set("mainpayableamt", row.get("e_pricetaxtotal"));
        settleRecord.set("expenseitem", row.get("expenseitem"));
        settleRecord.set("productline", row.get("e_productline"));
        settleRecord.set("corebillno", row.get("corebillno"));
        settleRecord.set("corebillentryseq", row.get("corebillentryseq"));
        settleRecord.set("conbillnumber", row.get("e_conbillnumber"));
        settleRecord.set("corebillid", row.get("corebillid"));
        settleRecord.set("corebillentryid", row.get("corebillentryid"));
        settleRecord.set("paypropertytype", (Object)"ap_payproperty");
        settleRecord.set("paypropertyfield", bill.get("payproperty"));
        settleRecord.set("basecurrency", bill.get("basecurrency"));
    }

    private static void finApInfoMakeupByAsst(DynamicObject recordEntry, DynamicObject bill, DynamicObject row) {
        recordEntry.set("billdate", bill.get("bizdate"));
        recordEntry.set("billnum", bill.get("billno"));
        recordEntry.set("e_material", row.get("material"));
        recordEntry.set("e_expenseitem", row.get("expenseitem"));
        recordEntry.set("e_productline", row.get("e_productline"));
        recordEntry.set("e_corebillno", row.get("corebillno"));
        recordEntry.set("e_corebillentryseq", row.get("corebillentryseq"));
        recordEntry.set("e_conbillnumber", row.get("e_conbillnumber"));
        long billType = bill.getLong("billtypeid.id");
        String billTypeEnum = (String)BillTypeConsts.getBillTypeMap().get(billType);
        if (ObjectUtils.isEmpty((Object)billTypeEnum)) {
            billTypeEnum = bill.getString("billtypeid.number");
        }
        recordEntry.set("billtype", (Object)billTypeEnum);
        recordEntry.set("currency", bill.get("currency"));
        recordEntry.set("e_quotation", (Object)"0");
        recordEntry.set("asstacttype", bill.get("asstacttype"));
        recordEntry.set("asstactid", bill.get("asstact"));
        recordEntry.set("asstact", (Object)bill.getString("asstact.name"));
        recordEntry.set("description", bill.get("remark"));
        recordEntry.set("payableamt", row.get("e_pricetaxtotal"));
        recordEntry.set("e_paypropertytype", (Object)"ap_payproperty");
        recordEntry.set("e_paypropertyfield", bill.get("payproperty"));
    }

    private static void finArInfoMakeupByMain(DynamicObject settleRecord, DynamicObject bill, DynamicObject row) {
        settleRecord.set("billno", bill.get("billno"));
        settleRecord.set("quotation", (Object)"0");
        settleRecord.set("material", row.get("e_material"));
        settleRecord.set("maincurrency", bill.get("currency"));
        settleRecord.set("mainbizdate", bill.get("bizdate"));
        long billType = bill.getLong("billtype.id");
        String billTypeEnum = (String)BillTypeConsts.getBillTypeMap().get(billType);
        if (ObjectUtils.isEmpty((Object)billTypeEnum)) {
            billTypeEnum = bill.getString("billtype.number");
        }
        settleRecord.set("mainbilltype", (Object)billTypeEnum);
        settleRecord.set("mainasstacttype", bill.get("asstacttype"));
        settleRecord.set("mainasstactid", bill.get("asstact"));
        settleRecord.set("mainasstact", bill.get("asstact.name"));
        settleRecord.set("mainpayableamt", row.get("e_recamount"));
        settleRecord.set("expenseitem", row.get("e_expenseitem"));
        settleRecord.set("productline", row.get("e_productline"));
        settleRecord.set("corebillno", row.get("e_corebillno"));
        settleRecord.set("corebillentryseq", row.get("e_corebillentryseq"));
        settleRecord.set("conbillnumber", row.get("e_conbillnumber"));
        settleRecord.set("corebillid", row.get("corebillid"));
        settleRecord.set("corebillentryid", row.get("corebillentryid"));
        settleRecord.set("paypropertytype", (Object)"ar_payproperty");
        settleRecord.set("paypropertyfield", bill.get("payproperty"));
        settleRecord.set("basecurrency", bill.get("basecurrency"));
    }

    private static void finArInfoMakeupByAsst(DynamicObject recordEntry, DynamicObject bill, DynamicObject row) {
        recordEntry.set("billdate", bill.get("bizdate"));
        recordEntry.set("billnum", bill.get("billno"));
        recordEntry.set("e_material", row.get("e_material"));
        recordEntry.set("e_expenseitem", row.get("e_expenseitem"));
        recordEntry.set("e_productline", row.get("e_productline"));
        recordEntry.set("e_corebillno", row.get("e_corebillno"));
        recordEntry.set("e_corebillentryseq", row.get("e_corebillentryseq"));
        recordEntry.set("e_conbillnumber", row.get("e_conbillnumber"));
        long billType = bill.getLong("billtype.id");
        String billTypeEnum = (String)BillTypeConsts.getBillTypeMap().get(billType);
        if (ObjectUtils.isEmpty((Object)billTypeEnum)) {
            billTypeEnum = bill.getString("billtype.number");
        }
        recordEntry.set("billtype", (Object)billTypeEnum);
        recordEntry.set("currency", bill.get("currency"));
        recordEntry.set("e_quotation", (Object)"0");
        recordEntry.set("asstacttype", bill.get("asstacttype"));
        recordEntry.set("asstactid", bill.get("asstact"));
        recordEntry.set("asstact", (Object)bill.getString("asstact.name"));
        recordEntry.set("description", bill.get("remark"));
        recordEntry.set("payableamt", row.get("e_recamount"));
        recordEntry.set("e_paypropertytype", (Object)"ar_payproperty");
        recordEntry.set("e_paypropertyfield", bill.get("payproperty"));
    }

    private static void casPayInfoMakeupByMain(DynamicObject settleRecord, DynamicObject bill, DynamicObject row) {
        settleRecord.set("billno", bill.get("billno"));
        settleRecord.set("quotation", (Object)"0");
        settleRecord.set("material", row.get("e_material"));
        settleRecord.set("maincurrency", bill.get("currency"));
        settleRecord.set("mainbizdate", bill.get("bizdate"));
        String billTypeNo = bill.getString("billtype.number");
        if (PAYBILL_PUR.equals(billTypeNo)) {
            settleRecord.set("mainbilltype", (Object)SettleBillTypeEnum.APPAY.getValue());
        } else if (PAYBILL_EXP.equals(billTypeNo)) {
            settleRecord.set("mainbilltype", (Object)SettleBillTypeEnum.OTHERPAY.getValue());
        } else {
            settleRecord.set("mainbilltype", (Object)bill.getString("billtype.number"));
        }
        DynamicObject paymentType = bill.getDynamicObject("paymenttype");
        if (paymentType != null && EntityMetadataUtils.isExistProperty((DynamicObject)paymentType, (String)"biztype") && PAYMENTTYPE_NUM.equals(paymentType.getString("biztype"))) {
            settleRecord.set("mainbilltype", (Object)SettleBillTypeEnum.ADVPAY.getValue());
        }
        settleRecord.set("mainasstacttype", bill.get("payeetype"));
        settleRecord.set("mainasstactid", bill.get("payee"));
        settleRecord.set("mainasstact", bill.get("payeename"));
        settleRecord.set("mainpayableamt", row.get("e_payableamt"));
        settleRecord.set("expenseitem", row.get("e_expenseitem"));
        settleRecord.set("productline", row.get("productline"));
        settleRecord.set("corebillno", row.get("e_corebillno"));
        settleRecord.set("corebillentryseq", row.get("e_corebillentryseq"));
        settleRecord.set("conbillnumber", row.get("conbillnumber"));
        settleRecord.set("corebillid", row.get("e_corebillid"));
        settleRecord.set("corebillentryid", row.get("e_corebillentryid"));
        settleRecord.set("paypropertytype", (Object)"cas_paymentbilltype");
        settleRecord.set("paypropertyfield", row.get("e_paymenttype"));
        settleRecord.set("basecurrency", bill.get("basecurrency"));
    }

    private static void casPayInfoMakeupByAsst(DynamicObject recordEntry, DynamicObject bill, DynamicObject row) {
        recordEntry.set("billdate", bill.get("bizdate"));
        recordEntry.set("billnum", bill.get("billno"));
        recordEntry.set("e_material", row.get("e_material"));
        recordEntry.set("e_expenseitem", row.get("e_expenseitem"));
        recordEntry.set("e_productline", row.get("productline"));
        recordEntry.set("e_corebillno", row.get("e_corebillno"));
        recordEntry.set("e_corebillentryseq", row.get("e_corebillentryseq"));
        recordEntry.set("e_conbillnumber", row.get("conbillnumber"));
        String billTypeNo = bill.getString("billtype.number");
        if (PAYBILL_PUR.equals(billTypeNo)) {
            recordEntry.set("billtype", (Object)SettleBillTypeEnum.APPAY.getValue());
        } else if (PAYBILL_EXP.equals(billTypeNo)) {
            recordEntry.set("billtype", (Object)SettleBillTypeEnum.OTHERPAY.getValue());
        } else {
            recordEntry.set("billtype", (Object)bill.getString("billtype.number"));
        }
        DynamicObject paymentType = bill.getDynamicObject("paymenttype");
        if (paymentType != null && EntityMetadataUtils.isExistProperty((DynamicObject)paymentType, (String)"biztype") && PAYMENTTYPE_NUM.equals(paymentType.getString("biztype"))) {
            recordEntry.set("billtype", (Object)SettleBillTypeEnum.ADVPAY.getValue());
        }
        recordEntry.set("currency", bill.get("currency"));
        recordEntry.set("e_quotation", (Object)"0");
        recordEntry.set("asstacttype", bill.get("payeetype"));
        recordEntry.set("asstactid", bill.get("payee"));
        recordEntry.set("asstact", bill.get("payeename"));
        recordEntry.set("payableamt", row.get("e_payableamt"));
        recordEntry.set("e_paypropertytype", (Object)"cas_paymentbilltype");
        recordEntry.set("e_paypropertyfield", row.get("e_paymenttype"));
    }

    private static void paidBillInfoMakeupByMain(DynamicObject settleRecord, DynamicObject bill, DynamicObject row) {
        settleRecord.set("billno", bill.get("billno"));
        settleRecord.set("quotation", (Object)"0");
        settleRecord.set("material", row.get("e_material"));
        settleRecord.set("maincurrency", bill.get("currency"));
        settleRecord.set("mainbizdate", bill.get("bizdate"));
        settleRecord.set("mainbilltype", (Object)SettleBillTypeEnum.PAID.getValue());
        DynamicObject paymentType = bill.getDynamicObject("paymenttype");
        if (paymentType != null && EntityMetadataUtils.isExistProperty((DynamicObject)paymentType, (String)"biztype") && PAYMENTTYPE_NUM.equals(paymentType.getString("biztype"))) {
            settleRecord.set("mainbilltype", (Object)SettleBillTypeEnum.ADVPAY.getValue());
        }
        settleRecord.set("mainasstacttype", bill.get("payeetype"));
        settleRecord.set("mainasstactid", bill.get("payee"));
        settleRecord.set("mainasstact", bill.get("payeename"));
        settleRecord.set("mainpayableamt", row.get("e_actamt"));
        settleRecord.set("expenseitem", row.get("e_expenseitem"));
        settleRecord.set("corebillno", row.get("e_corebillno"));
        settleRecord.set("corebillentryseq", row.get("e_corebillentryseq"));
        settleRecord.set("paypropertytype", (Object)"cas_paymentbilltype");
        settleRecord.set("paypropertyfield", bill.get("paymenttype"));
        settleRecord.set("basecurrency", bill.get("basecurrency"));
    }

    private static void paidBillInfoMakeupByAsst(DynamicObject recordEntry, DynamicObject bill, DynamicObject row) {
        recordEntry.set("billdate", bill.get("bizdate"));
        recordEntry.set("billnum", bill.get("billno"));
        recordEntry.set("e_material", row.get("e_material"));
        recordEntry.set("e_expenseitem", row.get("e_expenseitem"));
        recordEntry.set("e_corebillno", row.get("e_corebillno"));
        recordEntry.set("e_corebillentryseq", row.get("e_corebillentryseq"));
        recordEntry.set("billtype", (Object)SettleBillTypeEnum.PAID.getValue());
        DynamicObject paymentType = bill.getDynamicObject("paymenttype");
        if (paymentType != null && EntityMetadataUtils.isExistProperty((DynamicObject)paymentType, (String)"biztype") && PAYMENTTYPE_NUM.equals(paymentType.getString("biztype"))) {
            recordEntry.set("billtype", (Object)SettleBillTypeEnum.ADVPAY.getValue());
        }
        recordEntry.set("currency", bill.get("currency"));
        recordEntry.set("e_quotation", (Object)"0");
        recordEntry.set("asstacttype", bill.get("payeetype"));
        recordEntry.set("asstactid", bill.get("payee"));
        recordEntry.set("asstact", bill.get("payeename"));
        recordEntry.set("payableamt", row.get("e_actamt"));
        recordEntry.set("e_paypropertytype", (Object)"cas_paymentbilltype");
        recordEntry.set("e_paypropertyfield", bill.get("paymenttype"));
    }

    private static void receivedInfoMakeupByMain(DynamicObject settleRecord, DynamicObject bill, DynamicObject row) {
        settleRecord.set("billno", bill.get("billno"));
        settleRecord.set("quotation", (Object)"0");
        settleRecord.set("material", row.get("e_material"));
        settleRecord.set("maincurrency", bill.get("currency"));
        settleRecord.set("mainbizdate", bill.get("bizdate"));
        settleRecord.set("mainbilltype", (Object)SettleBillTypeEnum.RECEIVED.getValue());
        DynamicObject receivingType = bill.getDynamicObject("rectype");
        if (receivingType != null && EntityMetadataUtils.isExistProperty((DynamicObject)receivingType, (String)"biztype") && RECTYPE_NUM.equals(receivingType.getString("biztype"))) {
            settleRecord.set("mainbilltype", (Object)SettleBillTypeEnum.ADVREC.getValue());
        }
        settleRecord.set("mainasstacttype", bill.get("asstacttype"));
        settleRecord.set("mainasstactid", bill.get("asstact"));
        settleRecord.set("mainasstact", bill.get("asstact.name"));
        settleRecord.set("mainpayableamt", row.get("e_amount"));
        settleRecord.set("expenseitem", row.get("e_expenseitem"));
        settleRecord.set("corebillno", row.get("e_corebillno"));
        settleRecord.set("corebillentryseq", row.get("e_corebillentryseq"));
        settleRecord.set("paypropertytype", (Object)"cas_receivingbilltype");
        settleRecord.set("paypropertyfield", bill.get("rectype"));
        settleRecord.set("basecurrency", bill.get("basecurrency"));
    }

    private static void receivedInfoMakeupByAsst(DynamicObject recordEntry, DynamicObject bill, DynamicObject row) {
        recordEntry.set("billdate", bill.get("bizdate"));
        recordEntry.set("billnum", bill.get("billno"));
        recordEntry.set("e_material", row.get("e_material"));
        recordEntry.set("e_expenseitem", row.get("e_expenseitem"));
        recordEntry.set("e_corebillno", row.get("e_corebillno"));
        recordEntry.set("e_corebillentryseq", row.get("e_corebillentryseq"));
        recordEntry.set("billtype", (Object)SettleBillTypeEnum.RECEIVED.getValue());
        DynamicObject receivingType = bill.getDynamicObject("rectype");
        if (receivingType != null && EntityMetadataUtils.isExistProperty((DynamicObject)receivingType, (String)"biztype") && RECTYPE_NUM.equals(receivingType.getString("biztype"))) {
            recordEntry.set("billtype", (Object)SettleBillTypeEnum.ADVREC.getValue());
        }
        recordEntry.set("currency", bill.get("currency"));
        recordEntry.set("e_quotation", (Object)"0");
        recordEntry.set("asstacttype", bill.get("asstacttype"));
        recordEntry.set("asstactid", bill.get("asstact"));
        recordEntry.set("asstact", bill.get("asstact.name"));
        recordEntry.set("payableamt", row.get("e_amount"));
        recordEntry.set("e_paypropertytype", (Object)"cas_receivingbilltype");
        recordEntry.set("e_paypropertyfield", bill.get("rectype"));
    }

    private static void casRecInfoMakeupByMain(DynamicObject settleRecord, DynamicObject bill, DynamicObject row) {
        settleRecord.set("billno", bill.get("billno"));
        settleRecord.set("quotation", (Object)"0");
        settleRecord.set("material", row.get("e_material"));
        settleRecord.set("maincurrency", bill.get("currency"));
        settleRecord.set("mainbizdate", bill.get("bizdate"));
        settleRecord.set("mainbilltype", bill.get("biztype"));
        DynamicObject receivingType = bill.getDynamicObject("receivingtype");
        if (receivingType != null && EntityMetadataUtils.isExistProperty((DynamicObject)receivingType, (String)"biztype") && RECTYPE_NUM.equals(receivingType.getString("biztype"))) {
            settleRecord.set("mainbilltype", (Object)SettleBillTypeEnum.ADVREC.getValue());
        }
        settleRecord.set("mainasstacttype", bill.get("payertype"));
        settleRecord.set("mainasstactid", bill.get("payer"));
        settleRecord.set("mainasstact", bill.get("payername"));
        settleRecord.set("mainpayableamt", row.get("e_receivableamt"));
        settleRecord.set("expenseitem", row.get("e_expenseitem"));
        settleRecord.set("productline", row.get("productline"));
        settleRecord.set("corebillno", row.get("e_corebillno"));
        settleRecord.set("corebillentryseq", row.get("e_corebillentryseq"));
        settleRecord.set("conbillnumber", row.get("conbillnumber"));
        String coreBillId = row.getString("e_corebillid");
        if (!ObjectUtils.isEmpty((Object)coreBillId)) {
            settleRecord.set("corebillid", (Object)Long.parseLong(coreBillId));
        }
        settleRecord.set("corebillentryid", row.get("e_corebillentryid"));
        settleRecord.set("paypropertytype", (Object)"cas_receivingbilltype");
        settleRecord.set("paypropertyfield", row.get("e_receivingtype"));
        settleRecord.set("basecurrency", bill.get("basecurrency"));
    }

    private static void casRecInfoMakeupByAsst(DynamicObject recordEntry, DynamicObject bill, DynamicObject row) {
        recordEntry.set("billdate", bill.get("bizdate"));
        recordEntry.set("billnum", bill.get("billno"));
        recordEntry.set("e_material", row.get("e_material"));
        recordEntry.set("e_expenseitem", row.get("e_expenseitem"));
        recordEntry.set("e_productline", row.get("productline"));
        recordEntry.set("e_corebillno", row.get("e_corebillno"));
        recordEntry.set("e_corebillentryseq", row.get("e_corebillentryseq"));
        recordEntry.set("e_conbillnumber", row.get("conbillnumber"));
        recordEntry.set("billtype", bill.get("biztype"));
        DynamicObject receivingType = bill.getDynamicObject("receivingtype");
        if (receivingType != null && EntityMetadataUtils.isExistProperty((DynamicObject)receivingType, (String)"biztype") && RECTYPE_NUM.equals(receivingType.getString("biztype"))) {
            recordEntry.set("billtype", (Object)SettleBillTypeEnum.ADVREC.getValue());
        }
        recordEntry.set("currency", bill.get("currency"));
        recordEntry.set("e_quotation", (Object)"0");
        recordEntry.set("asstacttype", bill.get("payertype"));
        recordEntry.set("asstactid", bill.get("payer"));
        recordEntry.set("asstact", bill.get("payername"));
        recordEntry.set("payableamt", row.get("e_receivableamt"));
        recordEntry.set("e_paypropertytype", (Object)"cas_receivingbilltype");
        recordEntry.set("e_paypropertyfield", row.get("e_receivingtype"));
    }

    private static void liquidateInfoMakeupByAsst(DynamicObject recordEntry, DynamicObject bill, DynamicObject row) {
        recordEntry.set("billdate", bill.get("liquidationdate"));
        recordEntry.set("billnum", bill.get("billno"));
        String itemType = row.getString("itemtype");
        if ("bd_material".equalsIgnoreCase(itemType)) {
            recordEntry.set("e_material", row.get("item"));
        } else {
            recordEntry.set("e_expenseitem", row.get("item"));
        }
        recordEntry.set("billtype", (Object)SettleBillTypeEnum.LIQUIDATION.getValue());
        recordEntry.set("currency", bill.get("currency"));
        recordEntry.set("e_quotation", (Object)"0");
        recordEntry.set("asstacttype", bill.get("asstacttype"));
        recordEntry.set("asstactid", bill.get("asstact"));
        recordEntry.set("asstact", bill.get("asstact.name"));
        recordEntry.set("payableamt", row.get("amount"));
        String sourceBillType = bill.getString("sourcebilltype");
        if ("ap_finapbill".equals(sourceBillType)) {
            recordEntry.set("e_paypropertytype", (Object)"ap_payproperty");
            recordEntry.set("e_paypropertyfield", row.get("e_payproperty"));
        } else if ("ar_finarbill".equals(sourceBillType)) {
            recordEntry.set("e_paypropertytype", (Object)"ar_payproperty");
            recordEntry.set("e_paypropertyfield", row.get("e_payproperty"));
        } else if ("cas_paybill".equals(sourceBillType)) {
            recordEntry.set("e_paypropertytype", (Object)"cas_paymentbilltype");
            recordEntry.set("e_paypropertyfield", row.get("e_paymenttype"));
        } else {
            recordEntry.set("e_paypropertytype", (Object)"cas_receivingbilltype");
            recordEntry.set("e_paypropertyfield", row.get("e_receivingtype"));
        }
    }

    private static void liquidateBillInfoMakeUpByFinAp(DynamicObject liquidateBill, DynamicObject sourceBill, Map<Long, DynamicObject> billEntryRowMap) {
        liquidateBill.set("org", sourceBill.get("org"));
        liquidateBill.set("asstacttype", sourceBill.get("asstacttype"));
        liquidateBill.set("asstact", sourceBill.get("asstact"));
        liquidateBill.set("currency", sourceBill.get("currency"));
        liquidateBill.set("exratetable", sourceBill.get("exratetable"));
        liquidateBill.set("exratedate", sourceBill.get("exratedate"));
        liquidateBill.set("quotation", (Object)"0");
        liquidateBill.set("exchangerate", sourceBill.get("exchangerate"));
        liquidateBill.set("biztypef7", sourceBill.get("biztypef7"));
        liquidateBill.set("basecurrency", sourceBill.get("basecurrency"));
        DynamicObjectCollection entryEntity = liquidateBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : entryEntity) {
            DynamicObject sourceRow = billEntryRowMap.get(row.getLong("sourceentryid"));
            row.set("sourcebillno", sourceBill.get("billno"));
            row.set("sourcebilldate", sourceBill.get("bizdate"));
            row.set("amount", sourceRow.get("e_pricetaxtotal"));
            row.set("e_payproperty", sourceBill.get("payproperty"));
            if (sourceRow.get("material") == null) {
                row.set("itemtype", (Object)"er_expenseitemedit");
                row.set("item", sourceRow.get("expenseitem"));
                continue;
            }
            row.set("itemtype", (Object)"bd_material");
            row.set("item", sourceRow.get("material"));
        }
    }

    private static void liquidateBillInfoMakeUpByFinAr(DynamicObject liquidateBill, DynamicObject sourceBill, Map<Long, DynamicObject> billEntryRowMap) {
        liquidateBill.set("org", sourceBill.get("org"));
        liquidateBill.set("asstacttype", sourceBill.get("asstacttype"));
        liquidateBill.set("asstact", sourceBill.get("asstact"));
        liquidateBill.set("currency", sourceBill.get("currency"));
        liquidateBill.set("exratetable", sourceBill.get("exratetable"));
        liquidateBill.set("exratedate", sourceBill.get("exratedate"));
        liquidateBill.set("quotation", (Object)"0");
        liquidateBill.set("exchangerate", sourceBill.get("exchangerate"));
        liquidateBill.set("biztypef7", sourceBill.get("biztypef7"));
        liquidateBill.set("basecurrency", sourceBill.get("basecurrency"));
        DynamicObjectCollection entryEntity = liquidateBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : entryEntity) {
            DynamicObject sourceRow = billEntryRowMap.get(row.getLong("sourceentryid"));
            row.set("sourcebillno", sourceBill.get("billno"));
            row.set("sourcebilldate", sourceBill.get("bizdate"));
            row.set("amount", sourceRow.get("e_recamount"));
            row.set("e_payproperty", sourceBill.get("payproperty"));
            if (sourceRow.get("e_material") == null) {
                row.set("itemtype", (Object)"er_expenseitemedit");
                row.set("item", sourceRow.get("e_expenseitem"));
                continue;
            }
            row.set("itemtype", (Object)"bd_material");
            row.set("item", sourceRow.get("e_material"));
        }
    }

    private static void liquidateBillInfoMakeUpByCasPay(DynamicObject liquidateBill, DynamicObject sourceBill, Map<Long, DynamicObject> billEntryRowMap) {
        DynamicObjectCollection entryEntity = liquidateBill.getDynamicObjectCollection("entryentity");
        DynamicObject sourceBillRow = billEntryRowMap.get(((DynamicObject)entryEntity.get(0)).getLong("sourceentryid"));
        liquidateBill.set("org", sourceBillRow.get("settleorg"));
        liquidateBill.set("currency", sourceBill.get("currency"));
        liquidateBill.set("exchangerate", sourceBill.get("exchangerate"));
        liquidateBill.set("asstacttype", sourceBill.get("payeetype"));
        liquidateBill.set("asstact", sourceBill.get("payee"));
        liquidateBill.set("basecurrency", sourceBill.get("basecurrency"));
        liquidateBill.set("quotation", (Object)"0");
        liquidateBill.set("exratetable", sourceBill.get("exratetable"));
        liquidateBill.set("exratedate", sourceBill.get("exratedate"));
        for (DynamicObject row : entryEntity) {
            DynamicObject sourceRow = billEntryRowMap.get(row.getLong("sourceentryid"));
            row.set("sourcebillno", sourceBill.get("billno"));
            row.set("sourcebilldate", sourceBill.get("bizdate"));
            row.set("amount", sourceRow.get("e_payableamt"));
            row.set("e_paymenttype", sourceRow.get("e_paymenttype"));
            if (sourceRow.get("e_material") == null) {
                row.set("itemtype", (Object)"er_expenseitemedit");
                row.set("item", sourceRow.get("e_expenseitem"));
                continue;
            }
            row.set("itemtype", (Object)"bd_material");
            row.set("item", sourceRow.get("e_material"));
        }
    }

    private static void liquidateBillInfoMakeUpByCasRec(DynamicObject liquidateBill, DynamicObject sourceBill, Map<Long, DynamicObject> billEntryRowMap) {
        DynamicObjectCollection entryEntity = liquidateBill.getDynamicObjectCollection("entryentity");
        DynamicObject sourceBillRow = billEntryRowMap.get(((DynamicObject)entryEntity.get(0)).getLong("sourceentryid"));
        liquidateBill.set("org", sourceBillRow.get("e_settleorg"));
        liquidateBill.set("currency", sourceBill.get("currency"));
        liquidateBill.set("exchangerate", sourceBill.get("exchangerate"));
        liquidateBill.set("asstacttype", sourceBill.get("payertype"));
        liquidateBill.set("asstact", sourceBill.get("payer"));
        liquidateBill.set("basecurrency", sourceBill.get("basecurrency"));
        liquidateBill.set("quotation", (Object)"0");
        liquidateBill.set("exratetable", sourceBill.get("exratetable"));
        liquidateBill.set("exratedate", sourceBill.get("exratedate"));
        for (DynamicObject row : entryEntity) {
            DynamicObject sourceRow = billEntryRowMap.get(row.getLong("sourceentryid"));
            row.set("sourcebillno", sourceBill.get("billno"));
            row.set("sourcebilldate", sourceBill.get("bizdate"));
            row.set("amount", sourceRow.get("e_receivableamt"));
            row.set("e_receivingtype", sourceRow.get("e_receivingtype"));
            if (sourceRow.get("e_material") == null) {
                row.set("itemtype", (Object)"er_expenseitemedit");
                row.set("item", sourceRow.get("e_expenseitem"));
                continue;
            }
            row.set("itemtype", (Object)"bd_material");
            row.set("item", sourceRow.get("e_material"));
        }
    }

    private static String getBillSelectors(String billEntity) {
        if ("ap_finapbill".equals(billEntity)) {
            return "billtypeid,detailentry.corebillentryseq,asstacttype,detailentry.corebillentryid,remark,detailentry.corebillno,detailentry.e_pricetaxtotal,basecurrency,detailentry.material,bizdate,detailentry.e_productline,payproperty,detailentry.corebillid,detailentry.expenseitem,currency,asstact,detailentry.e_conbillnumber,billno,org,exratetable,exratedate,exchangerate,biztypef7";
        }
        if ("cas_paybill".equals(billEntity)) {
            return "payeename,entry.e_corebillid,entry.e_expenseitem,entry.e_paymenttype,payquotation,entry.e_corebillno,basecurrency,payee,biztype,entry.e_material,payeetype,bizdate,billtype,entry.conbillnumber,entry.productline,currency,entry.e_corebillentryid,billno,paymenttype,entry.e_corebillentryseq,entry.e_payableamt,settleorg,exchangerate,exratetable,exratedate";
        }
        if ("ar_finarbill".equals(billEntity)) {
            return "billno,e_material,e_recamount,e_expenseitem,e_productline,currency,bizdate,billtype,asstacttype,asstact,e_corebillno,e_corebillentryseq,corebillid,corebillentryid,e_conbillnumber,payproperty,basecurrency,remark,org,exratetable,exchangerate,exratedate,biztypef7";
        }
        if ("cas_recbill".equals(billEntity)) {
            return "billno,e_material,currency,biztype,receivingtype,payer,payertype,payername,e_receivingtype,basecurrency,e_receivableamt,e_expenseitem,productline,e_corebillno,e_corebillentryseq,conbillnumber,e_corebillid,e_corebillentryid,bizdate,e_settleorg,exchangerate,exratetable,exratedate";
        }
        if ("ap_paidbill".equals(billEntity)) {
            return "billno,e_material,currency,bizdate,paymenttype,payeetype,payee,payeename,e_actamt,e_expenseitem,e_corebillno,e_corebillentryseq,basecurrency";
        }
        if ("ar_receivedbill".equals(billEntity)) {
            return "billno,rectype,e_material,currency,bizdate,rectype,asstacttype,asstact,e_amount,e_expenseitem,e_corebillno,e_corebillentryseq,basecurrency";
        }
        return "id";
    }
}

