/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.enums.EasRecordOriginTypeEnum;
import kd.fi.arapcommon.enums.EasRecordToXhStatusEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;

public class EasSettleRecordHelper {
    public static void insertEasRecordData(DynamicObject[] dataEntities) {
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        if (!BillSrcTypeEnum.FROMEAS.getValue().equals(dataEntities[0].getString("billsrctype"))) {
            return;
        }
        String entityName = dataEntities[0].getDataEntityType().getName();
        List billIds = Arrays.stream(dataEntities).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("sourcebillid", "in", billIds);
        DataSet easRecordDataSet = QueryServiceHelper.queryDataSet((String)"query_exist", (String)"ap_eassettlerecord", (String)"sourcebillid", (QFilter[])new QFilter[]{filter}, (String)"");
        HashSet<Long> hasExistBillIds = new HashSet<Long>(32);
        for (Row row : easRecordDataSet) {
            hasExistBillIds.add(row.getLong("sourcebillid"));
        }
        BillModel billModel = BillModelFactory.getModel((String)entityName);
        HashMap<String, List> settleRelation4BillsMap = new HashMap<String, List>(8);
        ArrayList<Long> sourceBillIds = new ArrayList<Long>(64);
        for (DynamicObject dataEntity : dataEntities) {
            List writeOffBills;
            List transferBills;
            if (hasExistBillIds.contains(dataEntity.getLong("id")) || ObjectUtils.isEmpty((Object)dataEntity.getString(billModel.HEAD_SOURCEBILLID))) continue;
            sourceBillIds.add(Long.parseLong(dataEntity.getString(billModel.HEAD_SOURCEBILLID)));
            if ("ap_finapbill".equals(entityName)) {
                if (dataEntity.getBoolean("istanspay")) {
                    transferBills = settleRelation4BillsMap.getOrDefault(SettleRelationEnum.PAYTRANS.getValue(), new ArrayList(16));
                    transferBills.add(dataEntity);
                    settleRelation4BillsMap.put(SettleRelationEnum.PAYTRANS.getValue(), transferBills);
                    continue;
                }
                if (dataEntity.getBoolean("hadwrittenoff") || !dataEntity.getBoolean("iswrittenoff")) continue;
                writeOffBills = settleRelation4BillsMap.getOrDefault(SettleRelationEnum.APWRITEOFF.getValue(), new ArrayList(16));
                writeOffBills.add(dataEntity);
                settleRelation4BillsMap.put(SettleRelationEnum.APWRITEOFF.getValue(), writeOffBills);
                continue;
            }
            if (!"ar_finarbill".equals(entityName)) continue;
            if (dataEntity.getBoolean("istransfer")) {
                transferBills = settleRelation4BillsMap.getOrDefault(SettleRelationEnum.ARTRANSFER.getValue(), new ArrayList(16));
                transferBills.add(dataEntity);
                settleRelation4BillsMap.put(SettleRelationEnum.ARTRANSFER.getValue(), transferBills);
                continue;
            }
            if (dataEntity.getBoolean("hadwrittenoff") || !dataEntity.getBoolean("iswrittenoff")) continue;
            writeOffBills = settleRelation4BillsMap.getOrDefault(SettleRelationEnum.ARWRITEOFF.getValue(), new ArrayList(16));
            writeOffBills.add(dataEntity);
            settleRelation4BillsMap.put(SettleRelationEnum.ARWRITEOFF.getValue(), writeOffBills);
        }
        if (settleRelation4BillsMap.isEmpty()) {
            return;
        }
        String selectors = billModel.HEAD_SOURCEBILLID + "," + billModel.HEAD_ORG + "," + billModel.E_SOURCEBILLENTRYID + "," + billModel.E_SOURCEBILLID + "," + billModel.HEAD_CURRENCY + "," + billModel.HEAD_BASECURRENCY + "," + billModel.HEAD_EXCHANGERATE + "," + billModel.E_PRICETAXTOTAL + "," + billModel.E_PRICETAXTOTALLOC + "," + billModel.HEAD_HADWRITTENOFF + "," + billModel.HEAD_ISWRITTENOFF + "," + billModel.HEAD_BIZDATE + "," + billModel.HEAD_BILLNO;
        DynamicObject[] sourceBills = BusinessDataServiceHelper.load((String)entityName, (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIds)});
        Map<Long, DynamicObject> sourceBillMap = Arrays.stream(sourceBills).collect(Collectors.toMap(bill -> bill.getLong("id"), Function.identity()));
        ArrayList<DynamicObject> allPreInsertEasRecords = new ArrayList<DynamicObject>(64);
        for (Map.Entry entrySet : settleRelation4BillsMap.entrySet()) {
            allPreInsertEasRecords.addAll(EasSettleRecordHelper.finSelfInsertData((String)entrySet.getKey(), (List)entrySet.getValue(), sourceBillMap));
        }
        if (!allPreInsertEasRecords.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])allPreInsertEasRecords.toArray(new DynamicObject[0]));
        }
    }

    private static List<DynamicObject> finSelfInsertData(String settleRelation, List<DynamicObject> targetBills, Map<Long, DynamicObject> sourceBillMap) {
        if (ObjectUtils.isEmpty(targetBills)) {
            return new ArrayList<DynamicObject>(2);
        }
        ArrayList<DynamicObject> easSettleRecords = new ArrayList<DynamicObject>(64);
        String entityName = targetBills.get(0).getDataEntityType().getName();
        BillModel billModel = BillModelFactory.getModel((String)entityName);
        for (DynamicObject targetBill : targetBills) {
            DynamicObject easSettleRecord = EasSettleRecordHelper.createEasSettleRecord(settleRelation, targetBill);
            DynamicObjectCollection entry = easSettleRecord.getDynamicObjectCollection("entry");
            DynamicObjectCollection targetEntry = targetBill.getDynamicObjectCollection(billModel.ENTRY);
            boolean isWriteOffBill = targetBill.getBoolean(billModel.HEAD_ISWRITTENOFF) && !targetBill.getBoolean(billModel.HEAD_HADWRITTENOFF);
            for (DynamicObject targetRow : targetEntry) {
                String sourceBillId = targetRow.getString(billModel.E_SOURCEBILLID);
                String sourceBillEntryId = targetRow.getString(billModel.E_SOURCEBILLENTRYID);
                DynamicObject asstRow = entry.addNew();
                asstRow.set("e_billid", targetBill.get("id"));
                asstRow.set("e_billno", targetBill.get("billno"));
                asstRow.set("e_billentryid", targetRow.get("id"));
                asstRow.set("e_billentity", (Object)entityName);
                asstRow.set("e_ismain", (Object)Boolean.FALSE);
                asstRow.set("e_currency", targetBill.get(billModel.HEAD_CURRENCY));
                asstRow.set("e_basecurrency", targetBill.get(billModel.HEAD_BASECURRENCY));
                asstRow.set("e_exchangerate", targetBill.get(billModel.HEAD_EXCHANGERATE));
                asstRow.set("e_settleamt", targetRow.get(billModel.E_PRICETAXTOTAL));
                asstRow.set("e_settleamtlocal", targetRow.get(billModel.E_PRICETAXTOTALLOC));
                if (isWriteOffBill) continue;
                DynamicObject mainRow = entry.addNew();
                mainRow.set("e_billid", (Object)Long.parseLong(sourceBillId));
                mainRow.set("e_billno", targetBill.get("billno"));
                mainRow.set("e_billentryid", (Object)Long.parseLong(sourceBillEntryId));
                mainRow.set("e_billentity", (Object)entityName);
                mainRow.set("e_ismain", (Object)Boolean.TRUE);
                mainRow.set("e_currency", targetBill.get(billModel.HEAD_CURRENCY));
                mainRow.set("e_basecurrency", targetBill.get(billModel.HEAD_BASECURRENCY));
                mainRow.set("e_exchangerate", targetBill.get(billModel.HEAD_EXCHANGERATE));
                if (SettleRelationEnum.APWRITEOFF.getValue().equals(settleRelation)) {
                    mainRow.set("e_settleamt", (Object)targetRow.getBigDecimal(billModel.E_PRICETAXTOTAL).negate());
                    mainRow.set("e_settleamtlocal", (Object)targetRow.getBigDecimal(billModel.E_PRICETAXTOTALLOC).negate());
                    continue;
                }
                mainRow.set("e_settleamt", targetRow.get(billModel.E_PRICETAXTOTAL));
                mainRow.set("e_settleamtlocal", targetRow.get(billModel.E_PRICETAXTOTALLOC));
            }
            if (isWriteOffBill) {
                DynamicObject sourceBill = sourceBillMap.get(targetBill.getLong(billModel.HEAD_SOURCEBILLID));
                DynamicObjectCollection sourceEntry = sourceBill.getDynamicObjectCollection(billModel.ENTRY);
                for (DynamicObject sourceRow : sourceEntry) {
                    DynamicObject mainRow = entry.addNew();
                    mainRow.set("e_billid", sourceBill.get("id"));
                    mainRow.set("e_billno", sourceBill.get("billno"));
                    mainRow.set("e_billentryid", sourceRow.get("id"));
                    mainRow.set("e_billentity", (Object)entityName);
                    mainRow.set("e_ismain", (Object)Boolean.TRUE);
                    mainRow.set("e_currency", sourceBill.get(billModel.HEAD_CURRENCY));
                    mainRow.set("e_basecurrency", sourceBill.get(billModel.HEAD_BASECURRENCY));
                    mainRow.set("e_exchangerate", sourceBill.get(billModel.HEAD_EXCHANGERATE));
                    mainRow.set("e_settleamt", sourceRow.get(billModel.E_PRICETAXTOTAL));
                    mainRow.set("e_settleamtlocal", sourceRow.get(billModel.E_PRICETAXTOTALLOC));
                }
            }
            easSettleRecords.add(easSettleRecord);
        }
        return easSettleRecords;
    }

    private static DynamicObject createEasSettleRecord(String settleRelation, DynamicObject targetBill) {
        DynamicObject easSettleRecord = BusinessDataServiceHelper.newDynamicObject((String)"ap_eassettlerecord");
        easSettleRecord.set("org", targetBill.get("org"));
        easSettleRecord.set("sourcebillid", (Object)targetBill.getLong("id"));
        easSettleRecord.set("settlerelation", (Object)settleRelation);
        easSettleRecord.set("xhrecordstatus", (Object)EasRecordToXhStatusEnum.UNPRODUCE.getValue());
        easSettleRecord.set("origintype", (Object)EasRecordOriginTypeEnum.FROMBILL.getValue());
        easSettleRecord.set("issamecurreny", (Object)Boolean.TRUE);
        easSettleRecord.set("settledate", targetBill.get("bizdate"));
        easSettleRecord.set("creator", targetBill.get("creator"));
        easSettleRecord.getDynamicObjectCollection("entry").clear();
        return easSettleRecord;
    }

    public static Set<String> getEasSettleRecordSelectors() {
        HashSet<String> selectors = new HashSet<String>(16);
        selectors.add("org");
        selectors.add("settledate");
        selectors.add("origintype");
        selectors.add("settlerelation");
        selectors.add("issamecurreny");
        selectors.add("sourcebillid");
        selectors.add("xhrecordstatus");
        selectors.add("failmessage");
        selectors.add("failmessage_tag");
        selectors.add("creator");
        selectors.add("isreversebill");
        selectors.add("isreversed");
        selectors.add("modifier");
        selectors.add("modifytime");
        selectors.add("isfromar");
        selectors.add("srcsysbillid");
        selectors.add("e_exchangerate");
        selectors.add("entry.e_billid");
        selectors.add("entry.e_billno");
        selectors.add("entry.e_srcsysbillentryid");
        selectors.add("entry.e_billentryid");
        selectors.add("entry.e_ismain");
        selectors.add("entry.e_billentity");
        selectors.add("entry.e_currency");
        selectors.add("entry.e_basecurrency");
        selectors.add("entry.e_swappl");
        selectors.add("entry.e_settleamt");
        selectors.add("entry.e_settleamtlocal");
        selectors.add("entry.e_exchangerate");
        return selectors;
    }
}

