/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BadDebtLossAfterProcess4EasOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BadDebtLossAfterProcess4EasOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("BadDebtLossAfterProcess4EasOp endOperationTransaction begin.");
        DynamicObject[] dataEntities = this.getBills(e);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject dataEntity : dataEntities) {
            orgIds.add(dataEntity.getLong("org.id"));
        }
        Map<Long, DynamicObject> initObjMap = this.getInitObjMap(orgIds);
        for (DynamicObject dataEntity : dataEntities) {
            long orgId = dataEntity.getLong("org.id");
            DynamicObject initObj = initObjMap.get(orgId);
            if (initObj == null) continue;
            if (dataEntity.getDynamicObject("exratetable") == null) {
                dataEntity.set("exratetable", (Object)initObj.getDynamicObject("exratetable"));
            }
            if (dataEntity.getDynamicObject("basecurrency") != null) continue;
            dataEntity.set("basecurrency", (Object)initObj.getDynamicObject("standardcurrency"));
        }
        Set<Long> sourceBillIdSet = Arrays.stream(dataEntities).map(data -> data.getLong("sourcebillid")).collect(Collectors.toSet());
        Map<Long, DynamicObject> finArBillMap = this.getSrcFinBills(sourceBillIdSet);
        ArrayList<Long> noSrcBillIds = new ArrayList<Long>(8);
        ArrayList<DynamicObject> saveDatas = new ArrayList<DynamicObject>(8);
        for (DynamicObject dataEntity : dataEntities) {
            Long srcBillId = dataEntity.getLong("sourcebillid");
            DynamicObject finArBill = finArBillMap.get(srcBillId);
            if (finArBill == null) {
                noSrcBillIds.add(dataEntity.getLong("id"));
                if (noSrcBillIds.size() < 10000) continue;
                DeleteServiceHelper.delete((String)this.billEntityType.getName(), (QFilter[])new QFilter[]{new QFilter("id", "in", noSrcBillIds)});
                noSrcBillIds.clear();
                continue;
            }
            this.handleEntryField(finArBill, dataEntity);
            this.handleHeadField(finArBill, dataEntity);
            this.handlePlanEntryField(finArBill, dataEntity);
            saveDatas.add(dataEntity);
            if (saveDatas.size() < 10000) continue;
            SaveServiceHelper.save((DynamicObject[])saveDatas.toArray(new DynamicObject[0]));
            saveDatas.clear();
        }
        if (!noSrcBillIds.isEmpty()) {
            DeleteServiceHelper.delete((String)this.billEntityType.getName(), (QFilter[])new QFilter[]{new QFilter("id", "in", noSrcBillIds)});
        }
        if (!saveDatas.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveDatas.toArray(new DynamicObject[0]));
        }
        logger.info("BadDebtLossAfterProcess4EasOp endOperationTransaction end.");
    }

    private void handleEntryField(DynamicObject finArBill, DynamicObject dataEntity) {
        DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            Long srcEntryId = entry.getLong("e_srcentryid");
            DynamicObject finArBillEntry = null;
            DynamicObjectCollection finArBillEntries = finArBill.getDynamicObjectCollection("entry");
            for (DynamicObject billEntry : finArBillEntries) {
                if (!srcEntryId.equals(billEntry.getLong("id"))) continue;
                finArBillEntry = billEntry;
                break;
            }
            if (finArBillEntry == null) {
                logger.info("no match entry");
                return;
            }
            BigDecimal unLockAmt = entry.getBigDecimal("e_baddebtamt").subtract(entry.getBigDecimal("e_settledamt"));
            entry.set("e_unlockamt", (Object)unLockAmt);
            entry.set("e_unsettleamt", (Object)unLockAmt);
            entry.set("e_recamt", (Object)finArBillEntry.getBigDecimal("e_unlockamt"));
            entry.set("e_material", finArBillEntry.get("e_material"));
            entry.set("e_expenseitem", finArBillEntry.get("e_expenseitem"));
            entry.set("e_project", finArBillEntry.get("project"));
        }
    }

    private void handleHeadField(DynamicObject finArBill, DynamicObject dataEntity) {
        DynamicObject entry = (DynamicObject)dataEntity.getDynamicObjectCollection("entry").get(0);
        BigDecimal entryBadAmt = entry.getBigDecimal("e_baddebtamt");
        BigDecimal entryUnsettleAmt = entry.getBigDecimal("e_unsettleamt");
        dataEntity.set("recamt", (Object)finArBill.getBigDecimal("recamount"));
        dataEntity.set("unsettleamt", (Object)entryUnsettleAmt);
        if (BigDecimal.ZERO.compareTo(entryUnsettleAmt) == 0) {
            dataEntity.set("settlestatus", (Object)"settled");
        } else if (entryBadAmt.compareTo(entryUnsettleAmt) == 0) {
            dataEntity.set("settlestatus", (Object)"unsettle");
        } else {
            dataEntity.set("settlestatus", (Object)"partsettle");
        }
        dataEntity.set("isperiod", (Object)finArBill.getBoolean("isperiod"));
        dataEntity.set("biztypef7", finArBill.get("biztypef7"));
    }

    private void handlePlanEntryField(DynamicObject finArBill, DynamicObject dataEntity) {
        DynamicObject lossBillPlanEntry = (DynamicObject)dataEntity.getDynamicObjectCollection("planentry").get(0);
        DynamicObject lossBillEntry = (DynamicObject)dataEntity.getDynamicObjectCollection("entry").get(0);
        DynamicObject planEntity = (DynamicObject)finArBill.getDynamicObjectCollection("planentity").get(0);
        lossBillPlanEntry.set("p_duedate", (Object)planEntity.getDate("planduedate"));
        lossBillPlanEntry.set("p_settletype", planEntity.get("plansettletype"));
        lossBillPlanEntry.set("p_recamt", (Object)planEntity.getBigDecimal("unplanlockamt"));
        lossBillPlanEntry.set("p_unsettleamt", (Object)lossBillEntry.getBigDecimal("e_unsettleamt"));
        lossBillPlanEntry.set("p_unlockamt", (Object)lossBillEntry.getBigDecimal("e_unsettleamt"));
        lossBillPlanEntry.set("p_srcplanentryid", (Object)planEntity.getLong("id"));
    }

    private DynamicObject[] getBills(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List billIds = Arrays.stream(dataEntities).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        return BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)String.join((CharSequence)",", this.getSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
    }

    private Map<Long, DynamicObject> getInitObjMap(Set<Long> orgIds) {
        boolean isAr = this.billEntityType.getName().startsWith("ar");
        DynamicObject[] initObjs = BusinessDataServiceHelper.load((String)(isAr ? "ar_init" : "ap_init"), (String)"exratetable,standardcurrency,org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        HashMap<Long, DynamicObject> initObjMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject initObj : initObjs) {
            initObjMap.put(initObj.getLong("org.id"), initObj);
        }
        return initObjMap;
    }

    private Map<Long, DynamicObject> getSrcFinBills(Set<Long> sourceBillIdSet) {
        Map<Long, Object> result = new HashMap<Long, DynamicObject>(8);
        DynamicObject[] finArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,isperiod,biztypef7,recamount,e_recamount,e_unlockamt,e_material,e_expenseitem,project,planduedate,plansettletype,e_recamt,e_unsettleamt,unplanlockamt", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIdSet)});
        if (finArBills != null && finArBills.length > 0) {
            result = Arrays.stream(finArBills).collect(Collectors.toMap(e -> e.getLong("id"), Function.identity(), (v1, v2) -> v2));
        }
        return result;
    }

    private List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add("org");
        selector.add("exratetable");
        selector.add("basecurrency");
        selector.add("sourcebillid");
        selector.add("recamt");
        selector.add("unsettleamt");
        selector.add("settlestatus");
        selector.add("isperiod");
        selector.add("biztypef7");
        selector.add("e_srcentryid");
        selector.add("e_baddebtamt");
        selector.add("e_settledamt");
        selector.add("e_unlockamt");
        selector.add("e_unsettleamt");
        selector.add("e_recamt");
        selector.add("e_material");
        selector.add("e_expenseitem");
        selector.add("e_project");
        selector.add("p_duedate");
        selector.add("p_settletype");
        selector.add("p_recamt");
        selector.add("p_unsettleamt");
        selector.add("p_unlockamt");
        selector.add("p_srcplanentryid");
        return selector;
    }
}

